// SPDX-FileCopyrightText: 2021 Rot127 <unisono@quyllur.org>
// SPDX-License-Identifier: LGPL-3.0-only

// LLVM commit: ec11388b3342a2b22eae22fd13ff4997b103d155
// LLVM commit date: 2022-12-21 19:19:58 +0100 (ISO 8601 format)
// Date of code generation: 2022-12-21 14:35:08-05:00
//========================================
// The following code is generated.
// Do not edit. Repository of code generator:
// https://github.com/rizinorg/rz-hexagon

#include <stdio.h>
#include <stdbool.h>
#include <rz_types.h>
#include <rz_util.h>
#include <rz_util/rz_hex.h>
#include <rz_util/rz_strbuf.h>
#include <rz_analysis.h>
#include "hexagon.h"
#include "hexagon_insn.h"
#include "hexagon_arch.h"

#if ASAN && !defined(__clang__)
#define NO_OPT_IF_ASAN __attribute__((optimize(0)))
#else
#define NO_OPT_IF_ASAN
#endif

#define HEX_OP_MASKS_MAX 4

typedef enum {
	HEX_OP_TEMPLATE_TYPE_NONE = 0,
	HEX_OP_TEMPLATE_TYPE_IMM = 1,
	HEX_OP_TEMPLATE_TYPE_IMM_CONST = 2,
	HEX_OP_TEMPLATE_TYPE_REG = 3,
	HEX_OP_TEMPLATE_TYPE_MASK = 3
} HexOpTemplateType;

typedef enum {
	// 1 << 0 and 1 << 1 reserved by HexOpTemplateType
	// for HEX_OP_TEMPLATE_TYPE_REG:
	HEX_OP_TEMPLATE_FLAG_REG_OUT = 1 << 2,
	HEX_OP_TEMPLATE_FLAG_REG_PAIR = 1 << 3,
	HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE = 1 << 4,
	HEX_OP_TEMPLATE_FLAG_REG_N_REG = 1 << 5,
	// for HEX_OP_TEMPLATE_TYPE_IMM:
	HEX_OP_TEMPLATE_FLAG_IMM_SIGNED = 1 << 2,
	HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE = 1 << 3,
	HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE = 1 << 4,
	HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH = 1 << 5
} HexOpTemplateFlag;

// Note:
// The structs below are using ut8 instead of direct enum types
// where possible to optimize for size. Members are also ordered
// deliberately to make them well packed.
// Keep this in mind when changing anything here!

typedef struct {
	ut8 bits; // number of bits this part has
	ut8 shift; // index of the first bit in the instruction where this part starts
} HexOpMask;

typedef struct {
	ut8 info; // HexOpTemplateType | HexOpTemplateFlag
	ut8 syntax; // offset into HexInsnTemplate.syntax where to insert this op
	HexOpMask masks[HEX_OP_MASKS_MAX];
	union {
		ut8 imm_scale;
		ut8 reg_cls; // HexRegClass
	};
} HexOpTemplate;

typedef enum {
	HEX_INSN_TEMPLATE_FLAG_CALL = 1 << 0,
	HEX_INSN_TEMPLATE_FLAG_PREDICATED = 1 << 1,
	HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT = 1 << 2,
	HEX_INSN_TEMPLATE_FLAG_LOOP_BEGIN = 1 << 3,
	HEX_INSN_TEMPLATE_FLAG_LOOP_0 = 1 << 4,
	HEX_INSN_TEMPLATE_FLAG_LOOP_1 = 1 << 5
} HexInsnTemplateFlag;

typedef struct {
	struct {
		ut32 mask;
		ut32 op;
	} encoding;
	HexInsnID id;
	HexOpTemplate ops[HEX_MAX_OPERANDS];
	ut8 pred; // HexPred
	ut8 cond; // RzTypeCond
	ut8 flags; // HexInsnTemplateFlag
	const char *syntax;
	_RzAnalysisOpType type;
} HexInsnTemplate;

static const HexInsnTemplate templates_sub_A[] = {
	{
		// 0000PP00iiiiiiixxxx | Rx = add(Rxin,Ii)
		.encoding = { .mask = 0xf0001800, .op = 0x0 },
		.id = HEX_INS_SA1_ADDI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 4 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,)",
	},
	{
		// 0000PP11000ssssxxxx | Rx = add(Rxin,Rs)
		.encoding = { .mask = 0xf0001f00, .op = 0x1800 },
		.id = HEX_INS_SA1_ADDRX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,)",
	},
	{
		// 0000PP011iiiiiidddd | Rd = add(r29,Ii)
		.encoding = { .mask = 0xf0001c00, .op = 0xc00 },
		.id = HEX_INS_SA1_ADDSP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 4 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,)",
	},
	{
		// 0000PP10010ssssdddd | Rd = and(Rs,#1)
		.encoding = { .mask = 0xf0001f00, .op = 0x1200 },
		.id = HEX_INS_SA1_AND1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1)",
	},
	{
		// 0000PP110100111dddd | if (!p0) Rd = #0
		.encoding = { .mask = 0xf0001ff0, .op = 0x1a70 },
		.id = HEX_INS_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000PP110100101dddd | if (!p0.new) Rd = #0
		.encoding = { .mask = 0xf0001ff0, .op = 0x1a50 },
		.id = HEX_INS_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000PP110100110dddd | if (p0) Rd = #0
		.encoding = { .mask = 0xf0001ff0, .op = 0x1a60 },
		.id = HEX_INS_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000PP110100100dddd | if (p0.new) Rd = #0
		.encoding = { .mask = 0xf0001ff0, .op = 0x1a40 },
		.id = HEX_INS_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000PP11001ssss00ii | p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xf0001f0c, .op = 0x1900 },
		.id = HEX_INS_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 0 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,)",
	},
	{
		// 0000PP111000ii00ddd | Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xf0001f98, .op = 0x1c00 },
		.id = HEX_INS_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,)",
	},
	{
		// 0000PP111000ii01ddd | Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xf0001f98, .op = 0x1c08 },
		.id = HEX_INS_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,)",
	},
	{
		// 0000PP111000ii10ddd | Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xf0001f98, .op = 0x1c10 },
		.id = HEX_INS_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,)",
	},
	{
		// 0000PP111000ii11ddd | Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xf0001f98, .op = 0x1c18 },
		.id = HEX_INS_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,)",
	},
	{
		// 0000PP11101ssss1ddd | Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xf0001f08, .op = 0x1d08 },
		.id = HEX_INS_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0)",
	},
	{
		// 0000PP11101ssss0ddd | Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xf0001f08, .op = 0x1d00 },
		.id = HEX_INS_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,)",
	},
	{
		// 0000PP10011ssssdddd | Rd = add(Rs,n1)
		.encoding = { .mask = 0xf0001f00, .op = 0x1300 },
		.id = HEX_INS_SA1_DEC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,)",
	},
	{
		// 0000PP10001ssssdddd | Rd = add(Rs,#1)
		.encoding = { .mask = 0xf0001f00, .op = 0x1100 },
		.id = HEX_INS_SA1_INC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1)",
	},
	{
		// 0000PP010iiiiiidddd | Rd = Ii
		.encoding = { .mask = 0xf0001c00, .op = 0x800 },
		.id = HEX_INS_SA1_SETI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 4 } }, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 0000PP110100000dddd | Rd = n1
		.encoding = { .mask = 0xf0001ff0, .op = 0x1a00 },
		.id = HEX_INS_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 0000PP10101ssssdddd | Rd = sxtb(Rs)
		.encoding = { .mask = 0xf0001f00, .op = 0x1500 },
		.id = HEX_INS_SA1_SXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb()",
	},
	{
		// 0000PP10100ssssdddd | Rd = sxth(Rs)
		.encoding = { .mask = 0xf0001f00, .op = 0x1400 },
		.id = HEX_INS_SA1_SXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth()",
	},
	{
		// 0000PP10000ssssdddd | Rd = Rs
		.encoding = { .mask = 0xf0001f00, .op = 0x1000 },
		.id = HEX_INS_SA1_TFR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 0000PP10111ssssdddd | Rd = and(Rs,#255)
		.encoding = { .mask = 0xf0001f00, .op = 0x1700 },
		.id = HEX_INS_SA1_ZXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255)",
	},
	{
		// 0000PP10110ssssdddd | Rd = zxth(Rs)
		.encoding = { .mask = 0xf0001f00, .op = 0x1600 },
		.id = HEX_INS_SA1_ZXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth()",
	},
	{
		// 0000PP010iiiiiidddd | Rd = Ii
		.encoding = { .mask = 0xf0001c00, .op = 0x800 },
		.id = HEX_INS_UNDOCUMENTED_SA2_TFRSI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 4 } }, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_sub_L1[] = {
	{
		// 0000PP0iiiissssdddd | Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xf0001000, .op = 0x0 },
		.id = HEX_INS_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(+)",
	},
	{
		// 0000PP1iiiissssdddd | Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xf0001000, .op = 0x1000 },
		.id = HEX_INS_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memub(+)",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_sub_L2[] = {
	{
		// 0000PP1111100000000 | deallocframe
		.encoding = { .mask = 0xf0001fff, .op = 0x1f00 },
		.id = HEX_INS_SL2_DEALLOCFRAME,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "deallocframe",
	},
	{
		// 0000PP1111111000000 | jumpr r31
		.encoding = { .mask = 0xf0001fff, .op = 0x1fc0 },
		.id = HEX_INS_SL2_JUMPR31,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = "jumpr R31",
	},
	{
		// 0000PP1111111000101 | if (!p0) jumpr r31
		.encoding = { .mask = 0xf0001fff, .op = 0x1fc5 },
		.id = HEX_INS_SL2_JUMPR31_F,
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000PP1111111000111 | if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xf0001fff, .op = 0x1fc7 },
		.id = HEX_INS_SL2_JUMPR31_FNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000PP1111111000100 | if (p0) jumpr r31
		.encoding = { .mask = 0xf0001fff, .op = 0x1fc4 },
		.id = HEX_INS_SL2_JUMPR31_T,
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000PP1111111000110 | if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xf0001fff, .op = 0x1fc6 },
		.id = HEX_INS_SL2_JUMPR31_TNEW,
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000PP10iiissssdddd | Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xf0001800, .op = 0x1000 },
		.id = HEX_INS_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb(+)",
	},
	{
		// 0000PP11110iiiiiddd | Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xf0001f00, .op = 0x1e00 },
		.id = HEX_INS_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memd(R29+)",
	},
	{
		// 0000PP00iiissssdddd | Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xf0001800, .op = 0x0 },
		.id = HEX_INS_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh(+)",
	},
	{
		// 0000PP1110iiiiidddd | Rd = memw(r29+Ii)
		.encoding = { .mask = 0xf0001e00, .op = 0x1c00 },
		.id = HEX_INS_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(R29+)",
	},
	{
		// 0000PP01iiissssdddd | Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xf0001800, .op = 0x800 },
		.id = HEX_INS_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memuh(+)",
	},
	{
		// 0000PP1111101000000 | dealloc_return
		.encoding = { .mask = 0xf0001fff, .op = 0x1f40 },
		.id = HEX_INS_SL2_RETURN,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = "dealloc_return",
	},
	{
		// 0000PP1111101000101 | if (!p0) dealloc_return
		.encoding = { .mask = 0xf0001fff, .op = 0x1f45 },
		.id = HEX_INS_SL2_RETURN_F,
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000PP1111101000111 | if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xf0001fff, .op = 0x1f47 },
		.id = HEX_INS_SL2_RETURN_FNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000PP1111101000100 | if (p0) dealloc_return
		.encoding = { .mask = 0xf0001fff, .op = 0x1f44 },
		.id = HEX_INS_SL2_RETURN_T,
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000PP1111101000110 | if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xf0001fff, .op = 0x1f46 },
		.id = HEX_INS_SL2_RETURN_TNEW,
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_sub_S1[] = {
	{
		// 0000PP1iiiisssstttt | memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xf0001000, .op = 0x1000 },
		.id = HEX_INS_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(+) = ",
	},
	{
		// 0000PP0iiiisssstttt | memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xf0001000, .op = 0x0 },
		.id = HEX_INS_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(+) = ",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_sub_S2[] = {
	{
		// 0000PP1110iiiii0000 | allocframe(Ii)
		.encoding = { .mask = 0xf0001e0f, .op = 0x1c00 },
		.id = HEX_INS_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "allocframe()",
	},
	{
		// 0000PP10010ssssiiii | memb(Rs+Ii) = #0
		.encoding = { .mask = 0xf0001f00, .op = 0x1200 },
		.id = HEX_INS_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(+) = #0",
	},
	{
		// 0000PP10011ssssiiii | memb(Rs+Ii) = #1
		.encoding = { .mask = 0xf0001f00, .op = 0x1300 },
		.id = HEX_INS_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(+) = #1",
	},
	{
		// 0000PP0101iiiiiittt | memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xf0001e00, .op = 0xa00 },
		.id = HEX_INS_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memd(R29+) = ",
	},
	{
		// 0000PP00iiisssstttt | memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xf0001800, .op = 0x0 },
		.id = HEX_INS_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(+) = ",
	},
	{
		// 0000PP0100iiiiitttt | memw(r29+Ii) = Rt
		.encoding = { .mask = 0xf0001e00, .op = 0x800 },
		.id = HEX_INS_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(R29+) = ",
	},
	{
		// 0000PP10000ssssiiii | memw(Rs+Ii) = #0
		.encoding = { .mask = 0xf0001f00, .op = 0x1000 },
		.id = HEX_INS_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(+) = #0",
	},
	{
		// 0000PP10001ssssiiii | memw(Rs+Ii) = #1
		.encoding = { .mask = 0xf0001f00, .op = 0x1100 },
		.id = HEX_INS_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(+) = #1",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_normal_0x0[] = {
	{
		// 0000iiiiiiiiiiiiPPiiiiiiiiiiiiii | immext(Ii)
		.encoding = { .mask = 0xf0000000, .op = 0x0 },
		.id = HEX_INS_A4_EXT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0xe, 0 }, { 0xc, 16 } }, .imm_scale = 6, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "immext()",
	},
	{
		// 0000000000000000PP00000000000000 | <invalid>
		.encoding = { .mask = 0xffff3fff, .op = 0x0 },
		.id = HEX_INS_INVALID_DECODE,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_ILL,
		.syntax = "<invalid>",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_normal_0x1[] = {
	{
		// 0001010001iissssPP00ttttiiiiiii0 | p0 = cmp.eq(Rs,Rt); if (!p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14400000 },
		.id = HEX_INS_J4_CMPEQ_FP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.eq(,); if (!P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010001iissssPP10ttttiiiiiii0 | p0 = cmp.eq(Rs,Rt); if (!p0.new) jump:t Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14402000 },
		.id = HEX_INS_J4_CMPEQ_FP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.eq(,); if (!P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010001iissssPP01ttttiiiiiii0 | p1 = cmp.eq(Rs,Rt); if (!p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14401000 },
		.id = HEX_INS_J4_CMPEQ_FP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.eq(,); if (!P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010001iissssPP11ttttiiiiiii0 | p1 = cmp.eq(Rs,Rt); if (!p1.new) jump:t Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14403000 },
		.id = HEX_INS_J4_CMPEQ_FP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.eq(,); if (!P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010000iissssPP00ttttiiiiiii0 | p0 = cmp.eq(Rs,Rt); if (p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14000000 },
		.id = HEX_INS_J4_CMPEQ_TP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.eq(,); if (P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010000iissssPP10ttttiiiiiii0 | p0 = cmp.eq(Rs,Rt); if (p0.new) jump:t Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14002000 },
		.id = HEX_INS_J4_CMPEQ_TP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 35 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.eq(,); if (P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010000iissssPP01ttttiiiiiii0 | p1 = cmp.eq(Rs,Rt); if (p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14001000 },
		.id = HEX_INS_J4_CMPEQ_TP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.eq(,); if (P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010000iissssPP11ttttiiiiiii0 | p1 = cmp.eq(Rs,Rt); if (p1.new) jump:t Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14003000 },
		.id = HEX_INS_J4_CMPEQ_TP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 35 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.eq(,); if (P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000001iissssPP0IIIIIiiiiiii0 | p0 = cmp.eq(Rs,II); if (!p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc02001, .op = 0x10400000 },
		.id = HEX_INS_J4_CMPEQI_FP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.eq(,); if (!P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000001iissssPP1IIIIIiiiiiii0 | p0 = cmp.eq(Rs,II); if (!p0.new) jump:t Ii
		.encoding = { .mask = 0xffc02001, .op = 0x10402000 },
		.id = HEX_INS_J4_CMPEQI_FP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.eq(,); if (!P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001001iissssPP0IIIIIiiiiiii0 | p1 = cmp.eq(Rs,II); if (!p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc02001, .op = 0x12400000 },
		.id = HEX_INS_J4_CMPEQI_FP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.eq(,); if (!P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001001iissssPP1IIIIIiiiiiii0 | p1 = cmp.eq(Rs,II); if (!p1.new) jump:t Ii
		.encoding = { .mask = 0xffc02001, .op = 0x12402000 },
		.id = HEX_INS_J4_CMPEQI_FP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.eq(,); if (!P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000000iissssPP0IIIIIiiiiiii0 | p0 = cmp.eq(Rs,II); if (p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc02001, .op = 0x10000000 },
		.id = HEX_INS_J4_CMPEQI_TP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.eq(,); if (P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000000iissssPP1IIIIIiiiiiii0 | p0 = cmp.eq(Rs,II); if (p0.new) jump:t Ii
		.encoding = { .mask = 0xffc02001, .op = 0x10002000 },
		.id = HEX_INS_J4_CMPEQI_TP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 35 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.eq(,); if (P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001000iissssPP0IIIIIiiiiiii0 | p1 = cmp.eq(Rs,II); if (p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc02001, .op = 0x12000000 },
		.id = HEX_INS_J4_CMPEQI_TP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.eq(,); if (P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001000iissssPP1IIIIIiiiiiii0 | p1 = cmp.eq(Rs,II); if (p1.new) jump:t Ii
		.encoding = { .mask = 0xffc02001, .op = 0x12002000 },
		.id = HEX_INS_J4_CMPEQI_TP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 35 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.eq(,); if (P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000111iissssPP000000iiiiiii0 | p0 = cmp.eq(Rs,n1); if (!p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x11c00000 },
		.id = HEX_INS_J4_CMPEQN1_FP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.eq(,); if (!P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000111iissssPP100000iiiiiii0 | p0 = cmp.eq(Rs,n1); if (!p0.new) jump:t Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x11c02000 },
		.id = HEX_INS_J4_CMPEQN1_FP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.eq(,); if (!P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001111iissssPP000000iiiiiii0 | p1 = cmp.eq(Rs,n1); if (!p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x13c00000 },
		.id = HEX_INS_J4_CMPEQN1_FP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.eq(,); if (!P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001111iissssPP100000iiiiiii0 | p1 = cmp.eq(Rs,n1); if (!p1.new) jump:t Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x13c02000 },
		.id = HEX_INS_J4_CMPEQN1_FP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.eq(,); if (!P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000110iissssPP000000iiiiiii0 | p0 = cmp.eq(Rs,n1); if (p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x11800000 },
		.id = HEX_INS_J4_CMPEQN1_TP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.eq(,); if (P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000110iissssPP100000iiiiiii0 | p0 = cmp.eq(Rs,n1); if (p0.new) jump:t Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x11802000 },
		.id = HEX_INS_J4_CMPEQN1_TP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 35 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.eq(,); if (P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001110iissssPP000000iiiiiii0 | p1 = cmp.eq(Rs,n1); if (p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x13800000 },
		.id = HEX_INS_J4_CMPEQN1_TP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.eq(,); if (P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001110iissssPP100000iiiiiii0 | p1 = cmp.eq(Rs,n1); if (p1.new) jump:t Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x13802000 },
		.id = HEX_INS_J4_CMPEQN1_TP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 35 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.eq(,); if (P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010011iissssPP00ttttiiiiiii0 | p0 = cmp.gt(Rs,Rt); if (!p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14c00000 },
		.id = HEX_INS_J4_CMPGT_FP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gt(,); if (!P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010011iissssPP10ttttiiiiiii0 | p0 = cmp.gt(Rs,Rt); if (!p0.new) jump:t Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14c02000 },
		.id = HEX_INS_J4_CMPGT_FP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gt(,); if (!P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010011iissssPP01ttttiiiiiii0 | p1 = cmp.gt(Rs,Rt); if (!p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14c01000 },
		.id = HEX_INS_J4_CMPGT_FP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gt(,); if (!P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010011iissssPP11ttttiiiiiii0 | p1 = cmp.gt(Rs,Rt); if (!p1.new) jump:t Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14c03000 },
		.id = HEX_INS_J4_CMPGT_FP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gt(,); if (!P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010010iissssPP00ttttiiiiiii0 | p0 = cmp.gt(Rs,Rt); if (p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14800000 },
		.id = HEX_INS_J4_CMPGT_TP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gt(,); if (P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010010iissssPP10ttttiiiiiii0 | p0 = cmp.gt(Rs,Rt); if (p0.new) jump:t Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14802000 },
		.id = HEX_INS_J4_CMPGT_TP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 35 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gt(,); if (P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010010iissssPP01ttttiiiiiii0 | p1 = cmp.gt(Rs,Rt); if (p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14801000 },
		.id = HEX_INS_J4_CMPGT_TP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gt(,); if (P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010010iissssPP11ttttiiiiiii0 | p1 = cmp.gt(Rs,Rt); if (p1.new) jump:t Ii
		.encoding = { .mask = 0xffc03001, .op = 0x14803000 },
		.id = HEX_INS_J4_CMPGT_TP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 35 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gt(,); if (P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000011iissssPP0IIIIIiiiiiii0 | p0 = cmp.gt(Rs,II); if (!p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc02001, .op = 0x10c00000 },
		.id = HEX_INS_J4_CMPGTI_FP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gt(,); if (!P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000011iissssPP1IIIIIiiiiiii0 | p0 = cmp.gt(Rs,II); if (!p0.new) jump:t Ii
		.encoding = { .mask = 0xffc02001, .op = 0x10c02000 },
		.id = HEX_INS_J4_CMPGTI_FP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gt(,); if (!P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001011iissssPP0IIIIIiiiiiii0 | p1 = cmp.gt(Rs,II); if (!p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc02001, .op = 0x12c00000 },
		.id = HEX_INS_J4_CMPGTI_FP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gt(,); if (!P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001011iissssPP1IIIIIiiiiiii0 | p1 = cmp.gt(Rs,II); if (!p1.new) jump:t Ii
		.encoding = { .mask = 0xffc02001, .op = 0x12c02000 },
		.id = HEX_INS_J4_CMPGTI_FP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gt(,); if (!P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000010iissssPP0IIIIIiiiiiii0 | p0 = cmp.gt(Rs,II); if (p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc02001, .op = 0x10800000 },
		.id = HEX_INS_J4_CMPGTI_TP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gt(,); if (P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000010iissssPP1IIIIIiiiiiii0 | p0 = cmp.gt(Rs,II); if (p0.new) jump:t Ii
		.encoding = { .mask = 0xffc02001, .op = 0x10802000 },
		.id = HEX_INS_J4_CMPGTI_TP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 35 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gt(,); if (P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001010iissssPP0IIIIIiiiiiii0 | p1 = cmp.gt(Rs,II); if (p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc02001, .op = 0x12800000 },
		.id = HEX_INS_J4_CMPGTI_TP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gt(,); if (P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001010iissssPP1IIIIIiiiiiii0 | p1 = cmp.gt(Rs,II); if (p1.new) jump:t Ii
		.encoding = { .mask = 0xffc02001, .op = 0x12802000 },
		.id = HEX_INS_J4_CMPGTI_TP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 35 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gt(,); if (P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000111iissssPP000001iiiiiii0 | p0 = cmp.gt(Rs,n1); if (!p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x11c00100 },
		.id = HEX_INS_J4_CMPGTN1_FP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gt(,); if (!P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000111iissssPP100001iiiiiii0 | p0 = cmp.gt(Rs,n1); if (!p0.new) jump:t Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x11c02100 },
		.id = HEX_INS_J4_CMPGTN1_FP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gt(,); if (!P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001111iissssPP000001iiiiiii0 | p1 = cmp.gt(Rs,n1); if (!p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x13c00100 },
		.id = HEX_INS_J4_CMPGTN1_FP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gt(,); if (!P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001111iissssPP100001iiiiiii0 | p1 = cmp.gt(Rs,n1); if (!p1.new) jump:t Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x13c02100 },
		.id = HEX_INS_J4_CMPGTN1_FP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gt(,); if (!P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000110iissssPP000001iiiiiii0 | p0 = cmp.gt(Rs,n1); if (p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x11800100 },
		.id = HEX_INS_J4_CMPGTN1_TP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gt(,); if (P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000110iissssPP100001iiiiiii0 | p0 = cmp.gt(Rs,n1); if (p0.new) jump:t Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x11802100 },
		.id = HEX_INS_J4_CMPGTN1_TP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 35 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gt(,); if (P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001110iissssPP000001iiiiiii0 | p1 = cmp.gt(Rs,n1); if (p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x13800100 },
		.id = HEX_INS_J4_CMPGTN1_TP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gt(,); if (P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001110iissssPP100001iiiiiii0 | p1 = cmp.gt(Rs,n1); if (p1.new) jump:t Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x13802100 },
		.id = HEX_INS_J4_CMPGTN1_TP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 35 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gt(,); if (P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010101iissssPP00ttttiiiiiii0 | p0 = cmp.gtu(Rs,Rt); if (!p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc03001, .op = 0x15400000 },
		.id = HEX_INS_J4_CMPGTU_FP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 38 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gtu(,); if (!P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010101iissssPP10ttttiiiiiii0 | p0 = cmp.gtu(Rs,Rt); if (!p0.new) jump:t Ii
		.encoding = { .mask = 0xffc03001, .op = 0x15402000 },
		.id = HEX_INS_J4_CMPGTU_FP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gtu(,); if (!P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010101iissssPP01ttttiiiiiii0 | p1 = cmp.gtu(Rs,Rt); if (!p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc03001, .op = 0x15401000 },
		.id = HEX_INS_J4_CMPGTU_FP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 38 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gtu(,); if (!P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010101iissssPP11ttttiiiiiii0 | p1 = cmp.gtu(Rs,Rt); if (!p1.new) jump:t Ii
		.encoding = { .mask = 0xffc03001, .op = 0x15403000 },
		.id = HEX_INS_J4_CMPGTU_FP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gtu(,); if (!P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010100iissssPP00ttttiiiiiii0 | p0 = cmp.gtu(Rs,Rt); if (p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc03001, .op = 0x15000000 },
		.id = HEX_INS_J4_CMPGTU_TP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gtu(,); if (P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010100iissssPP10ttttiiiiiii0 | p0 = cmp.gtu(Rs,Rt); if (p0.new) jump:t Ii
		.encoding = { .mask = 0xffc03001, .op = 0x15002000 },
		.id = HEX_INS_J4_CMPGTU_TP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gtu(,); if (P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010100iissssPP01ttttiiiiiii0 | p1 = cmp.gtu(Rs,Rt); if (p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc03001, .op = 0x15001000 },
		.id = HEX_INS_J4_CMPGTU_TP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gtu(,); if (P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001010100iissssPP11ttttiiiiiii0 | p1 = cmp.gtu(Rs,Rt); if (p1.new) jump:t Ii
		.encoding = { .mask = 0xffc03001, .op = 0x15003000 },
		.id = HEX_INS_J4_CMPGTU_TP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gtu(,); if (P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000101iissssPP0IIIIIiiiiiii0 | p0 = cmp.gtu(Rs,II); if (!p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc02001, .op = 0x11400000 },
		.id = HEX_INS_J4_CMPGTUI_FP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 38 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gtu(,); if (!P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000101iissssPP1IIIIIiiiiiii0 | p0 = cmp.gtu(Rs,II); if (!p0.new) jump:t Ii
		.encoding = { .mask = 0xffc02001, .op = 0x11402000 },
		.id = HEX_INS_J4_CMPGTUI_FP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gtu(,); if (!P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001101iissssPP0IIIIIiiiiiii0 | p1 = cmp.gtu(Rs,II); if (!p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc02001, .op = 0x13400000 },
		.id = HEX_INS_J4_CMPGTUI_FP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 38 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gtu(,); if (!P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001101iissssPP1IIIIIiiiiiii0 | p1 = cmp.gtu(Rs,II); if (!p1.new) jump:t Ii
		.encoding = { .mask = 0xffc02001, .op = 0x13402000 },
		.id = HEX_INS_J4_CMPGTUI_FP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gtu(,); if (!P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000100iissssPP0IIIIIiiiiiii0 | p0 = cmp.gtu(Rs,II); if (p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc02001, .op = 0x11000000 },
		.id = HEX_INS_J4_CMPGTUI_TP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gtu(,); if (P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000100iissssPP1IIIIIiiiiiii0 | p0 = cmp.gtu(Rs,II); if (p0.new) jump:t Ii
		.encoding = { .mask = 0xffc02001, .op = 0x11002000 },
		.id = HEX_INS_J4_CMPGTUI_TP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = cmp.gtu(,); if (P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001100iissssPP0IIIIIiiiiiii0 | p1 = cmp.gtu(Rs,II); if (p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc02001, .op = 0x13000000 },
		.id = HEX_INS_J4_CMPGTUI_TP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gtu(,); if (P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001100iissssPP1IIIIIiiiiiii0 | p1 = cmp.gtu(Rs,II); if (p1.new) jump:t Ii
		.encoding = { .mask = 0xffc02001, .op = 0x13002000 },
		.id = HEX_INS_J4_CMPGTUI_TP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 36 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = cmp.gtu(,); if (P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001011000iiddddPPIIIIIIiiiiiii0 | Rd = II ; jump Ii
		.encoding = { .mask = 0xffc00001, .op = 0x16000000 },
		.id = HEX_INS_J4_JUMPSETI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 8 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_JMP,
		.syntax = " =  ; jump ",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001011100iissssPP00ddddiiiiiii0 | Rd = Rs ; jump Ii
		.encoding = { .mask = 0xffc03001, .op = 0x17000000 },
		.id = HEX_INS_J4_JUMPSETR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 8 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_JMP,
		.syntax = " =  ; jump ",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000111iissssPP000011iiiiiii0 | p0 = tstbit(Rs,#0); if (!p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x11c00300 },
		.id = HEX_INS_J4_TSTBIT0_FP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 39 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = tstbit(,#0); if (!P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000111iissssPP100011iiiiiii0 | p0 = tstbit(Rs,#0); if (!p0.new) jump:t Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x11c02300 },
		.id = HEX_INS_J4_TSTBIT0_FP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 38 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = tstbit(,#0); if (!P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001111iissssPP000011iiiiiii0 | p1 = tstbit(Rs,#0); if (!p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x13c00300 },
		.id = HEX_INS_J4_TSTBIT0_FP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 39 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = tstbit(,#0); if (!P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001111iissssPP100011iiiiiii0 | p1 = tstbit(Rs,#0); if (!p1.new) jump:t Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x13c02300 },
		.id = HEX_INS_J4_TSTBIT0_FP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 38 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = tstbit(,#0); if (!P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000110iissssPP000011iiiiiii0 | p0 = tstbit(Rs,#0); if (p0.new) jump:nt Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x11800300 },
		.id = HEX_INS_J4_TSTBIT0_TP0_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 38 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = tstbit(,#0); if (P0.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001000110iissssPP100011iiiiiii0 | p0 = tstbit(Rs,#0); if (p0.new) jump:t Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x11802300 },
		.id = HEX_INS_J4_TSTBIT0_TP0_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P0 = tstbit(,#0); if (P0.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001110iissssPP000011iiiiiii0 | p1 = tstbit(Rs,#0); if (p1.new) jump:nt Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x13800300 },
		.id = HEX_INS_J4_TSTBIT0_TP1_JUMP_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 38 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = tstbit(,#0); if (P1.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0001001110iissssPP100011iiiiiii0 | p1 = tstbit(Rs,#0); if (p1.new) jump:t Ii
		.encoding = { .mask = 0xffc03f01, .op = 0x13802300 },
		.id = HEX_INS_J4_TSTBIT0_TP1_JUMP_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 37 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "P1 = tstbit(,#0); if (P1.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 00011001110tttttPP000000010ddddd | Vd.b = vsplat(Rt)
		.encoding = { .mask = 0xffe03fe0, .op = 0x19c00040 },
		.id = HEX_INS_V6_LVSPLATB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vsplat()",
	},
	{
		// 00011001110tttttPP000000001ddddd | Vd.h = vsplat(Rt)
		.encoding = { .mask = 0xffe03fe0, .op = 0x19c00020 },
		.id = HEX_INS_V6_LVSPLATH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vsplat()",
	},
	{
		// 00011001101tttttPP000000001ddddd | Vd = vsplat(Rt)
		.encoding = { .mask = 0xffe03fe0, .op = 0x19a00020 },
		.id = HEX_INS_V6_LVSPLATW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsplat()",
	},
	{
		// 00011110tt000011PP0000ss000000dd | Qd = and(Qs,Qt)
		.encoding = { .mask = 0xff3f3cfc, .op = 0x1e030000 },
		.id = HEX_INS_V6_PRED_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,)",
	},
	{
		// 00011110tt000011PP0000ss000101dd | Qd = and(Qs,!Qt)
		.encoding = { .mask = 0xff3f3cfc, .op = 0x1e030014 },
		.id = HEX_INS_V6_PRED_AND_N,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,!)",
	},
	{
		// 0001111000000011PP0000ss000010dd | Qd = not(Qs)
		.encoding = { .mask = 0xffff3cfc, .op = 0x1e030008 },
		.id = HEX_INS_V6_PRED_NOT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = not()",
	},
	{
		// 00011110tt000011PP0000ss000001dd | Qd = or(Qs,Qt)
		.encoding = { .mask = 0xff3f3cfc, .op = 0x1e030004 },
		.id = HEX_INS_V6_PRED_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = or(,)",
	},
	{
		// 00011110tt000011PP0000ss000100dd | Qd = or(Qs,!Qt)
		.encoding = { .mask = 0xff3f3cfc, .op = 0x1e030010 },
		.id = HEX_INS_V6_PRED_OR_N,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = or(,!)",
	},
	{
		// 00011001101tttttPP000000010001dd | Qd = vsetq(Rt)
		.encoding = { .mask = 0xffe03ffc, .op = 0x19a00044 },
		.id = HEX_INS_V6_PRED_SCALAR2,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsetq()",
	},
	{
		// 00011001101tttttPP000000010011dd | Qd = vsetq2(Rt)
		.encoding = { .mask = 0xffe03ffc, .op = 0x19a0004c },
		.id = HEX_INS_V6_PRED_SCALAR2V2,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsetq2()",
	},
	{
		// 00011110tt000011PP0000ss000011dd | Qd = xor(Qs,Qt)
		.encoding = { .mask = 0xff3f3cfc, .op = 0x1e03000c },
		.id = HEX_INS_V6_PRED_XOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = xor(,)",
	},
	{
		// 00011110tt000011PP0000ss000110dd | Qd.b = vshuffe(Qs.h,Qt.h)
		.encoding = { .mask = 0xff3f3cfc, .op = 0x1e030018 },
		.id = HEX_INS_V6_SHUFFEQH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vshuffe(.h,.h)",
	},
	{
		// 00011110tt000011PP0000ss000111dd | Qd.h = vshuffe(Qs.w,Qt.w)
		.encoding = { .mask = 0xff3f3cfc, .op = 0x1e03001c },
		.id = HEX_INS_V6_SHUFFEQW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vshuffe(.w,.w)",
	},
	{
		// 00011111010vvvvvPP1uuuuu1iiddddd | Vdd.w = v6mpy(Vuu.ub,Vvv.b,Ii):h
		.encoding = { .mask = 0xffe02080, .op = 0x1f402080 },
		.id = HEX_INS_V6_V6MPYHUBS10,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = V6mpy(.ub,.b,):h",
	},
	{
		// 00011111001vvvvvPP1uuuuu1iixxxxx | Vxx.w += v6mpy(Vuu.ub,Vvv.b,Ii):h
		.encoding = { .mask = 0xffe02080, .op = 0x1f202080 },
		.id = HEX_INS_V6_V6MPYHUBS10_VXX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += V6mpy(.ub,.b,):h",
	},
	{
		// 00011111010vvvvvPP1uuuuu0iiddddd | Vdd.w = v6mpy(Vuu.ub,Vvv.b,Ii):v
		.encoding = { .mask = 0xffe02080, .op = 0x1f402000 },
		.id = HEX_INS_V6_V6MPYVUBS10,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = V6mpy(.ub,.b,):v",
	},
	{
		// 00011111001vvvvvPP1uuuuu0iixxxxx | Vxx.w += v6mpy(Vuu.ub,Vvv.b,Ii):v
		.encoding = { .mask = 0xffe02080, .op = 0x1f202000 },
		.id = HEX_INS_V6_V6MPYVUBS10_VXX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += V6mpy(.ub,.b,):v",
	},
	{
		// 0001111000000110PP1uuuuu100ddddd | Vd.hf = vabs(Vu.hf)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e062080 },
		.id = HEX_INS_V6_VABS_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = vabs(.hf)",
	},
	{
		// 0001111000000110PP1uuuuu101ddddd | Vd.sf = vabs(Vu.sf)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e0620a0 },
		.id = HEX_INS_V6_VABS_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vabs(.sf)",
	},
	{
		// 0001111000000001PP0uuuuu100ddddd | Vd.b = vabs(Vu.b)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e010080 },
		.id = HEX_INS_V6_VABSB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vabs(.b)",
	},
	{
		// 0001111000000001PP0uuuuu101ddddd | Vd.b = vabs(Vu.b):sat
		.encoding = { .mask = 0xffff20e0, .op = 0x1e0100a0 },
		.id = HEX_INS_V6_VABSB_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vabs(.b):sat",
	},
	{
		// 00011100110vvvvvPP0uuuuu001ddddd | Vd.uh = vabsdiff(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1cc00020 },
		.id = HEX_INS_V6_VABSDIFFH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vabsdiff(.h,.h)",
	},
	{
		// 00011100110vvvvvPP0uuuuu000ddddd | Vd.ub = vabsdiff(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x1cc00000 },
		.id = HEX_INS_V6_VABSDIFFUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vabsdiff(.ub,.ub)",
	},
	{
		// 00011100110vvvvvPP0uuuuu010ddddd | Vd.uh = vabsdiff(Vu.uh,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1cc00040 },
		.id = HEX_INS_V6_VABSDIFFUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vabsdiff(.uh,.uh)",
	},
	{
		// 00011100110vvvvvPP0uuuuu011ddddd | Vd.uw = vabsdiff(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1cc00060 },
		.id = HEX_INS_V6_VABSDIFFW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vabsdiff(.w,.w)",
	},
	{
		// 0001111000000000PP0uuuuu000ddddd | Vd.h = vabs(Vu.h)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e000000 },
		.id = HEX_INS_V6_VABSH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vabs(.h)",
	},
	{
		// 0001111000000000PP0uuuuu001ddddd | Vd.h = vabs(Vu.h):sat
		.encoding = { .mask = 0xffff20e0, .op = 0x1e000020 },
		.id = HEX_INS_V6_VABSH_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vabs(.h):sat",
	},
	{
		// 0001111000000000PP0uuuuu010ddddd | Vd.w = vabs(Vu.w)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e000040 },
		.id = HEX_INS_V6_VABSW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vabs(.w)",
	},
	{
		// 0001111000000000PP0uuuuu011ddddd | Vd.w = vabs(Vu.w):sat
		.encoding = { .mask = 0xffff20e0, .op = 0x1e000060 },
		.id = HEX_INS_V6_VABSW_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vabs(.w):sat",
	},
	{
		// 00011111011vvvvvPP1uuuuu011ddddd | Vd.qf16 = vadd(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f602060 },
		.id = HEX_INS_V6_VADD_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf16 = vadd(.hf,.hf)",
	},
	{
		// 00011111101vvvvvPP1uuuuu111ddddd | Vd.hf = vadd(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa020e0 },
		.id = HEX_INS_V6_VADD_HF_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = vadd(.hf,.hf)",
	},
	{
		// 00011111011vvvvvPP1uuuuu010ddddd | Vd.qf16 = vadd(Vu.qf16,Vv.qf16)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f602040 },
		.id = HEX_INS_V6_VADD_QF16,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf16 = vadd(.qf16,.qf16)",
	},
	{
		// 00011111011vvvvvPP1uuuuu100ddddd | Vd.qf16 = vadd(Vu.qf16,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f602080 },
		.id = HEX_INS_V6_VADD_QF16_MIX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf16 = vadd(.qf16,.hf)",
	},
	{
		// 00011111101vvvvvPP1uuuuu000ddddd | Vd.qf32 = vadd(Vu.qf32,Vv.qf32)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa02000 },
		.id = HEX_INS_V6_VADD_QF32,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf32 = vadd(.qf32,.qf32)",
	},
	{
		// 00011111101vvvvvPP1uuuuu010ddddd | Vd.qf32 = vadd(Vu.qf32,Vv.sf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa02040 },
		.id = HEX_INS_V6_VADD_QF32_MIX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf32 = vadd(.qf32,.sf)",
	},
	{
		// 00011111101vvvvvPP1uuuuu001ddddd | Vd.qf32 = vadd(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa02020 },
		.id = HEX_INS_V6_VADD_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf32 = vadd(.sf,.sf)",
	},
	{
		// 00011101010vvvvvPP1uuuuu110ddddd | Vdd.sf = vadd(Vu.bf,Vv.bf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1d4020c0 },
		.id = HEX_INS_V6_VADD_SF_BF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vadd(.bf,.bf)",
	},
	{
		// 00011111100vvvvvPP1uuuuu100ddddd | Vdd.sf = vadd(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f802080 },
		.id = HEX_INS_V6_VADD_SF_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vadd(.hf,.hf)",
	},
	{
		// 00011111100vvvvvPP1uuuuu110ddddd | Vd.sf = vadd(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f8020c0 },
		.id = HEX_INS_V6_VADD_SF_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vadd(.sf,.sf)",
	},
	{
		// 00011111101vvvvvPP0uuuuu110ddddd | Vd.b = vadd(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa000c0 },
		.id = HEX_INS_V6_VADDB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vadd(.b,.b)",
	},
	{
		// 00011100011vvvvvPP0uuuuu100ddddd | Vdd.b = vadd(Vuu.b,Vvv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c600080 },
		.id = HEX_INS_V6_VADDB_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vadd(.b,.b)",
	},
	{
		// 00011110vv000001PP1uuuuu011xxxxx | if (!Qv) Vx.b += Vu.b
		.encoding = { .mask = 0xff3f20e0, .op = 0x1e012060 },
		.id = HEX_INS_V6_VADDBNQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if (!) .b += .b",
	},
	{
		// 00011110vv000001PP1uuuuu000xxxxx | if (Qv) Vx.b += Vu.b
		.encoding = { .mask = 0xff3f20e0, .op = 0x1e012000 },
		.id = HEX_INS_V6_VADDBQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () .b += .b",
	},
	{
		// 00011111000vvvvvPP0uuuuu000ddddd | Vd.b = vadd(Vu.b,Vv.b):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1f000000 },
		.id = HEX_INS_V6_VADDBSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vadd(.b,.b):sat",
	},
	{
		// 00011110101vvvvvPP0uuuuu000ddddd | Vdd.b = vadd(Vuu.b,Vvv.b):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1ea00000 },
		.id = HEX_INS_V6_VADDBSAT_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vadd(.b,.b):sat",
	},
	{
		// 00011100101vvvvvPP1uuuuu0xxddddd | Vd.w = vadd(Vu.w,Vv.w,Qx):carry
		.encoding = { .mask = 0xffe02080, .op = 0x1ca02000 },
		.id = HEX_INS_V6_VADDCARRY,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vadd(.w,.w,):carry",
	},
	{
		// 00011101101vvvvvPP1uuuuu0eeddddd | Vd.w,Qe = vadd(Vu.w,Vv.w):carry
		.encoding = { .mask = 0xffe02080, .op = 0x1da02000 },
		.id = HEX_INS_V6_VADDCARRYO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w, = vadd(.w,.w):carry",
	},
	{
		// 00011101100vvvvvPP1uuuuu0ssddddd | Vd.w = vadd(Vu.w,Vv.w,Qs):carry:sat
		.encoding = { .mask = 0xffe02080, .op = 0x1d802000 },
		.id = HEX_INS_V6_VADDCARRYSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vadd(.w,.w,):carry:sat",
	},
	{
		// 00011111000vvvvvPP1uuuuu000ddddd | Vd.h = vadd(vclb(Vu.h),Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f002000 },
		.id = HEX_INS_V6_VADDCLBH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vadd(vclb(.h),.h)",
	},
	{
		// 00011111000vvvvvPP1uuuuu001ddddd | Vd.w = vadd(vclb(Vu.w),Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f002020 },
		.id = HEX_INS_V6_VADDCLBW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vadd(vclb(.w),.w)",
	},
	{
		// 00011111101vvvvvPP0uuuuu111ddddd | Vd.h = vadd(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa000e0 },
		.id = HEX_INS_V6_VADDH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vadd(.h,.h)",
	},
	{
		// 00011100011vvvvvPP0uuuuu101ddddd | Vdd.h = vadd(Vuu.h,Vvv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c6000a0 },
		.id = HEX_INS_V6_VADDH_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vadd(.h,.h)",
	},
	{
		// 00011110vv000001PP1uuuuu100xxxxx | if (!Qv) Vx.h += Vu.h
		.encoding = { .mask = 0xff3f20e0, .op = 0x1e012080 },
		.id = HEX_INS_V6_VADDHNQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if (!) .h += .h",
	},
	{
		// 00011110vv000001PP1uuuuu001xxxxx | if (Qv) Vx.h += Vu.h
		.encoding = { .mask = 0xff3f20e0, .op = 0x1e012020 },
		.id = HEX_INS_V6_VADDHQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () .h += .h",
	},
	{
		// 00011100010vvvvvPP0uuuuu011ddddd | Vd.h = vadd(Vu.h,Vv.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c400060 },
		.id = HEX_INS_V6_VADDHSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vadd(.h,.h):sat",
	},
	{
		// 00011100100vvvvvPP0uuuuu001ddddd | Vdd.h = vadd(Vuu.h,Vvv.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c800020 },
		.id = HEX_INS_V6_VADDHSAT_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vadd(.h,.h):sat",
	},
	{
		// 00011100101vvvvvPP0uuuuu100ddddd | Vdd.w = vadd(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1ca00080 },
		.id = HEX_INS_V6_VADDHW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vadd(.h,.h)",
	},
	{
		// 00011100001vvvvvPP1uuuuu010xxxxx | Vxx.w += vadd(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c202040 },
		.id = HEX_INS_V6_VADDHW_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vadd(.h,.h)",
	},
	{
		// 00011100101vvvvvPP0uuuuu010ddddd | Vdd.h = vadd(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x1ca00040 },
		.id = HEX_INS_V6_VADDUBH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vadd(.ub,.ub)",
	},
	{
		// 00011100010vvvvvPP1uuuuu101xxxxx | Vxx.h += vadd(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c4020a0 },
		.id = HEX_INS_V6_VADDUBH_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h += vadd(.ub,.ub)",
	},
	{
		// 00011100010vvvvvPP0uuuuu001ddddd | Vd.ub = vadd(Vu.ub,Vv.ub):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c400020 },
		.id = HEX_INS_V6_VADDUBSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vadd(.ub,.ub):sat",
	},
	{
		// 00011100011vvvvvPP0uuuuu111ddddd | Vdd.ub = vadd(Vuu.ub,Vvv.ub):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c6000e0 },
		.id = HEX_INS_V6_VADDUBSAT_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vadd(.ub,.ub):sat",
	},
	{
		// 00011110101vvvvvPP0uuuuu100ddddd | Vd.ub = vadd(Vu.ub,Vv.b):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1ea00080 },
		.id = HEX_INS_V6_VADDUBUBB_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vadd(.ub,.b):sat",
	},
	{
		// 00011100010vvvvvPP0uuuuu010ddddd | Vd.uh = vadd(Vu.uh,Vv.uh):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c400040 },
		.id = HEX_INS_V6_VADDUHSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vadd(.uh,.uh):sat",
	},
	{
		// 00011100100vvvvvPP0uuuuu000ddddd | Vdd.uh = vadd(Vuu.uh,Vvv.uh):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c800000 },
		.id = HEX_INS_V6_VADDUHSAT_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vadd(.uh,.uh):sat",
	},
	{
		// 00011100101vvvvvPP0uuuuu011ddddd | Vdd.w = vadd(Vu.uh,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1ca00060 },
		.id = HEX_INS_V6_VADDUHW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vadd(.uh,.uh)",
	},
	{
		// 00011100010vvvvvPP1uuuuu100xxxxx | Vxx.w += vadd(Vu.uh,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c402080 },
		.id = HEX_INS_V6_VADDUHW_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vadd(.uh,.uh)",
	},
	{
		// 00011111011vvvvvPP0uuuuu001ddddd | Vd.uw = vadd(Vu.uw,Vv.uw):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1f600020 },
		.id = HEX_INS_V6_VADDUWSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vadd(.uw,.uw):sat",
	},
	{
		// 00011110101vvvvvPP0uuuuu010ddddd | Vdd.uw = vadd(Vuu.uw,Vvv.uw):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1ea00040 },
		.id = HEX_INS_V6_VADDUWSAT_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vadd(.uw,.uw):sat",
	},
	{
		// 00011100010vvvvvPP0uuuuu000ddddd | Vd.w = vadd(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c400000 },
		.id = HEX_INS_V6_VADDW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vadd(.w,.w)",
	},
	{
		// 00011100011vvvvvPP0uuuuu110ddddd | Vdd.w = vadd(Vuu.w,Vvv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c6000c0 },
		.id = HEX_INS_V6_VADDW_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vadd(.w,.w)",
	},
	{
		// 00011110vv000001PP1uuuuu101xxxxx | if (!Qv) Vx.w += Vu.w
		.encoding = { .mask = 0xff3f20e0, .op = 0x1e0120a0 },
		.id = HEX_INS_V6_VADDWNQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if (!) .w += .w",
	},
	{
		// 00011110vv000001PP1uuuuu010xxxxx | if (Qv) Vx.w += Vu.w
		.encoding = { .mask = 0xff3f20e0, .op = 0x1e012040 },
		.id = HEX_INS_V6_VADDWQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () .w += .w",
	},
	{
		// 00011100010vvvvvPP0uuuuu100ddddd | Vd.w = vadd(Vu.w,Vv.w):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c400080 },
		.id = HEX_INS_V6_VADDWSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vadd(.w,.w):sat",
	},
	{
		// 00011100100vvvvvPP0uuuuu010ddddd | Vdd.w = vadd(Vuu.w,Vvv.w):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c800040 },
		.id = HEX_INS_V6_VADDWSAT_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vadd(.w,.w):sat",
	},
	{
		// 00011011vvvvvtttPP0uuuuu000ddddd | Vd = valign(Vu,Vv,Rt)
		.encoding = { .mask = 0xff0020e0, .op = 0x1b000000 },
		.id = HEX_INS_V6_VALIGNB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = valign(,,)",
	},
	{
		// 00011110001vvvvvPP1uuuuuiiiddddd | Vd = valign(Vu,Vv,Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x1e202000 },
		.id = HEX_INS_V6_VALIGNBI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 5 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = valign(,,)",
	},
	{
		// 00011100001vvvvvPP0uuuuu101ddddd | Vd = vand(Vu,Vv)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c2000a0 },
		.id = HEX_INS_V6_VAND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vand(,)",
	},
	{
		// 00011001101tttttPP0001uu101ddddd | Vd = vand(!Qu,Rt)
		.encoding = { .mask = 0xffe03ce0, .op = 0x19a004a0 },
		.id = HEX_INS_V6_VANDNQRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vand(!,)",
	},
	{
		// 00011001011tttttPP1001uu011xxxxx | Vx |= vand(!Qu,Rt)
		.encoding = { .mask = 0xffe03ce0, .op = 0x19602460 },
		.id = HEX_INS_V6_VANDNQRT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vand(!,)",
	},
	{
		// 00011001101tttttPP0000uu101ddddd | Vd = vand(Qu,Rt)
		.encoding = { .mask = 0xffe03ce0, .op = 0x19a000a0 },
		.id = HEX_INS_V6_VANDQRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vand(,)",
	},
	{
		// 00011001011tttttPP1000uu011xxxxx | Vx |= vand(Qu,Rt)
		.encoding = { .mask = 0xffe03ce0, .op = 0x19602060 },
		.id = HEX_INS_V6_VANDQRT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vand(,)",
	},
	{
		// 00011110vv000011PP1uuuuu001ddddd | Vd = vand(!Qv,Vu)
		.encoding = { .mask = 0xff3f20e0, .op = 0x1e032020 },
		.id = HEX_INS_V6_VANDVNQV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vand(!,)",
	},
	{
		// 00011110vv000011PP1uuuuu000ddddd | Vd = vand(Qv,Vu)
		.encoding = { .mask = 0xff3f20e0, .op = 0x1e032000 },
		.id = HEX_INS_V6_VANDVQV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vand(,)",
	},
	{
		// 00011001101tttttPP0uuuuu010010dd | Qd = vand(Vu,Rt)
		.encoding = { .mask = 0xffe020fc, .op = 0x19a00048 },
		.id = HEX_INS_V6_VANDVRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vand(,)",
	},
	{
		// 00011001011tttttPP1uuuuu100000xx | Qx |= vand(Vu,Rt)
		.encoding = { .mask = 0xffe020fc, .op = 0x19602080 },
		.id = HEX_INS_V6_VANDVRT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vand(,)",
	},
	{
		// 00011001100tttttPP0uuuuu000ddddd | Vd.h = vasl(Vu.h,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x19800000 },
		.id = HEX_INS_V6_VASLH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vasl(.h,)",
	},
	{
		// 00011001101tttttPP1uuuuu101xxxxx | Vx.h += vasl(Vu.h,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x19a020a0 },
		.id = HEX_INS_V6_VASLH_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h += vasl(.h,)",
	},
	{
		// 00011111101vvvvvPP0uuuuu101ddddd | Vd.h = vasl(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa000a0 },
		.id = HEX_INS_V6_VASLHV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vasl(.h,.h)",
	},
	{
		// 00011001011tttttPP0uuuuu111ddddd | Vd.w = vasl(Vu.w,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x196000e0 },
		.id = HEX_INS_V6_VASLW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vasl(.w,)",
	},
	{
		// 00011001011tttttPP1uuuuu010xxxxx | Vx.w += vasl(Vu.w,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x19602040 },
		.id = HEX_INS_V6_VASLW_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vasl(.w,)",
	},
	{
		// 00011111101vvvvvPP0uuuuu100ddddd | Vd.w = vasl(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa00080 },
		.id = HEX_INS_V6_VASLWV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vasl(.w,.w)",
	},
	{
		// 00011010101vvvvvPP1uuuuu111xxxxx | Vxx.w = vasrinto(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1aa020e0 },
		.id = HEX_INS_V6_VASR_INTO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vasrinto(.w,.w)",
	},
	{
		// 00011001011tttttPP0uuuuu110ddddd | Vd.h = vasr(Vu.h,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x196000c0 },
		.id = HEX_INS_V6_VASRH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vasr(.h,)",
	},
	{
		// 00011001100tttttPP1uuuuu111xxxxx | Vx.h += vasr(Vu.h,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x198020e0 },
		.id = HEX_INS_V6_VASRH_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h += vasr(.h,)",
	},
	{
		// 00011011vvvvvtttPP1uuuuu000ddddd | Vd.b = vasr(Vu.h,Vv.h,Rt):rnd:sat
		.encoding = { .mask = 0xff0020e0, .op = 0x1b002000 },
		.id = HEX_INS_V6_VASRHBRNDSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vasr(.h,.h,):rnd:sat",
	},
	{
		// 00011000vvvvvtttPP0uuuuu000ddddd | Vd.b = vasr(Vu.h,Vv.h,Rt):sat
		.encoding = { .mask = 0xff0020e0, .op = 0x18000000 },
		.id = HEX_INS_V6_VASRHBSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vasr(.h,.h,):sat",
	},
	{
		// 00011011vvvvvtttPP0uuuuu111ddddd | Vd.ub = vasr(Vu.h,Vv.h,Rt):rnd:sat
		.encoding = { .mask = 0xff0020e0, .op = 0x1b0000e0 },
		.id = HEX_INS_V6_VASRHUBRNDSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vasr(.h,.h,):rnd:sat",
	},
	{
		// 00011011vvvvvtttPP0uuuuu110ddddd | Vd.ub = vasr(Vu.h,Vv.h,Rt):sat
		.encoding = { .mask = 0xff0020e0, .op = 0x1b0000c0 },
		.id = HEX_INS_V6_VASRHUBSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vasr(.h,.h,):sat",
	},
	{
		// 00011111101vvvvvPP0uuuuu011ddddd | Vd.h = vasr(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa00060 },
		.id = HEX_INS_V6_VASRHV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vasr(.h,.h)",
	},
	{
		// 00011000vvvvvtttPP0uuuuu111ddddd | Vd.ub = vasr(Vu.uh,Vv.uh,Rt):rnd:sat
		.encoding = { .mask = 0xff0020e0, .op = 0x180000e0 },
		.id = HEX_INS_V6_VASRUHUBRNDSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vasr(.uh,.uh,):rnd:sat",
	},
	{
		// 00011000vvvvvtttPP1uuuuu101ddddd | Vd.ub = vasr(Vu.uh,Vv.uh,Rt):sat
		.encoding = { .mask = 0xff0020e0, .op = 0x180020a0 },
		.id = HEX_INS_V6_VASRUHUBSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vasr(.uh,.uh,):sat",
	},
	{
		// 00011000vvvvvtttPP0uuuuu001ddddd | Vd.uh = vasr(Vu.uw,Vv.uw,Rt):rnd:sat
		.encoding = { .mask = 0xff0020e0, .op = 0x18000020 },
		.id = HEX_INS_V6_VASRUWUHRNDSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vasr(.uw,.uw,):rnd:sat",
	},
	{
		// 00011000vvvvvtttPP1uuuuu100ddddd | Vd.uh = vasr(Vu.uw,Vv.uw,Rt):sat
		.encoding = { .mask = 0xff0020e0, .op = 0x18002080 },
		.id = HEX_INS_V6_VASRUWUHSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vasr(.uw,.uw,):sat",
	},
	{
		// 00011101000vvvvvPP0uuuuu011ddddd | Vd.ub = vasr(Vuu.uh,Vv.ub):rnd:sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1d000060 },
		.id = HEX_INS_V6_VASRVUHUBRNDSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vasr(.uh,.ub):rnd:sat",
	},
	{
		// 00011101000vvvvvPP0uuuuu010ddddd | Vd.ub = vasr(Vuu.uh,Vv.ub):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1d000040 },
		.id = HEX_INS_V6_VASRVUHUBSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vasr(.uh,.ub):sat",
	},
	{
		// 00011101000vvvvvPP0uuuuu001ddddd | Vd.uh = vasr(Vuu.w,Vv.uh):rnd:sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1d000020 },
		.id = HEX_INS_V6_VASRVWUHRNDSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vasr(.w,.uh):rnd:sat",
	},
	{
		// 00011101000vvvvvPP0uuuuu000ddddd | Vd.uh = vasr(Vuu.w,Vv.uh):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1d000000 },
		.id = HEX_INS_V6_VASRVWUHSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vasr(.w,.uh):sat",
	},
	{
		// 00011001011tttttPP0uuuuu101ddddd | Vd.w = vasr(Vu.w,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x196000a0 },
		.id = HEX_INS_V6_VASRW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vasr(.w,)",
	},
	{
		// 00011001011tttttPP1uuuuu101xxxxx | Vx.w += vasr(Vu.w,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x196020a0 },
		.id = HEX_INS_V6_VASRW_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vasr(.w,)",
	},
	{
		// 00011011vvvvvtttPP0uuuuu010ddddd | Vd.h = vasr(Vu.w,Vv.w,Rt)
		.encoding = { .mask = 0xff0020e0, .op = 0x1b000040 },
		.id = HEX_INS_V6_VASRWH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vasr(.w,.w,)",
	},
	{
		// 00011011vvvvvtttPP0uuuuu100ddddd | Vd.h = vasr(Vu.w,Vv.w,Rt):rnd:sat
		.encoding = { .mask = 0xff0020e0, .op = 0x1b000080 },
		.id = HEX_INS_V6_VASRWHRNDSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vasr(.w,.w,):rnd:sat",
	},
	{
		// 00011011vvvvvtttPP0uuuuu011ddddd | Vd.h = vasr(Vu.w,Vv.w,Rt):sat
		.encoding = { .mask = 0xff0020e0, .op = 0x1b000060 },
		.id = HEX_INS_V6_VASRWHSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vasr(.w,.w,):sat",
	},
	{
		// 00011000vvvvvtttPP0uuuuu010ddddd | Vd.uh = vasr(Vu.w,Vv.w,Rt):rnd:sat
		.encoding = { .mask = 0xff0020e0, .op = 0x18000040 },
		.id = HEX_INS_V6_VASRWUHRNDSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vasr(.w,.w,):rnd:sat",
	},
	{
		// 00011011vvvvvtttPP0uuuuu101ddddd | Vd.uh = vasr(Vu.w,Vv.w,Rt):sat
		.encoding = { .mask = 0xff0020e0, .op = 0x1b0000a0 },
		.id = HEX_INS_V6_VASRWUHSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vasr(.w,.w,):sat",
	},
	{
		// 00011111101vvvvvPP0uuuuu000ddddd | Vd.w = vasr(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa00000 },
		.id = HEX_INS_V6_VASRWV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vasr(.w,.w)",
	},
	{
		// 0001111000000011PP1uuuuu111ddddd | Vd = Vu
		.encoding = { .mask = 0xffff20e0, .op = 0x1e0320e0 },
		.id = HEX_INS_V6_VASSIGN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 0001111000000110PP1uuuuu001ddddd | Vd.w = vfmv(Vu.w)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e062020 },
		.id = HEX_INS_V6_VASSIGN_FP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vfmv(.w)",
	},
	{
		// 0001111000000001PP0uuuuu110ddddd | Vd.tmp = Vu
		.encoding = { .mask = 0xffff20e0, .op = 0x1e0100c0 },
		.id = HEX_INS_V6_VASSIGN_TMP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".tmp = ",
	},
	{
		// 00011111000vvvvvPP1uuuuu100ddddd | Vd.b = vavg(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f002080 },
		.id = HEX_INS_V6_VAVGB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vavg(.b,.b)",
	},
	{
		// 00011111000vvvvvPP1uuuuu101ddddd | Vd.b = vavg(Vu.b,Vv.b):rnd
		.encoding = { .mask = 0xffe020e0, .op = 0x1f0020a0 },
		.id = HEX_INS_V6_VAVGBRND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vavg(.b,.b):rnd",
	},
	{
		// 00011100110vvvvvPP0uuuuu110ddddd | Vd.h = vavg(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1cc000c0 },
		.id = HEX_INS_V6_VAVGH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vavg(.h,.h)",
	},
	{
		// 00011100111vvvvvPP0uuuuu101ddddd | Vd.h = vavg(Vu.h,Vv.h):rnd
		.encoding = { .mask = 0xffe020e0, .op = 0x1ce000a0 },
		.id = HEX_INS_V6_VAVGHRND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vavg(.h,.h):rnd",
	},
	{
		// 00011100110vvvvvPP0uuuuu100ddddd | Vd.ub = vavg(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x1cc00080 },
		.id = HEX_INS_V6_VAVGUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vavg(.ub,.ub)",
	},
	{
		// 00011100111vvvvvPP0uuuuu011ddddd | Vd.ub = vavg(Vu.ub,Vv.ub):rnd
		.encoding = { .mask = 0xffe020e0, .op = 0x1ce00060 },
		.id = HEX_INS_V6_VAVGUBRND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vavg(.ub,.ub):rnd",
	},
	{
		// 00011100110vvvvvPP0uuuuu101ddddd | Vd.uh = vavg(Vu.uh,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1cc000a0 },
		.id = HEX_INS_V6_VAVGUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vavg(.uh,.uh)",
	},
	{
		// 00011100111vvvvvPP0uuuuu100ddddd | Vd.uh = vavg(Vu.uh,Vv.uh):rnd
		.encoding = { .mask = 0xffe020e0, .op = 0x1ce00080 },
		.id = HEX_INS_V6_VAVGUHRND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vavg(.uh,.uh):rnd",
	},
	{
		// 00011111000vvvvvPP1uuuuu010ddddd | Vd.uw = vavg(Vu.uw,Vv.uw)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f002040 },
		.id = HEX_INS_V6_VAVGUW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vavg(.uw,.uw)",
	},
	{
		// 00011111000vvvvvPP1uuuuu011ddddd | Vd.uw = vavg(Vu.uw,Vv.uw):rnd
		.encoding = { .mask = 0xffe020e0, .op = 0x1f002060 },
		.id = HEX_INS_V6_VAVGUWRND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vavg(.uw,.uw):rnd",
	},
	{
		// 00011100110vvvvvPP0uuuuu111ddddd | Vd.w = vavg(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1cc000e0 },
		.id = HEX_INS_V6_VAVGW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vavg(.w,.w)",
	},
	{
		// 00011100111vvvvvPP0uuuuu110ddddd | Vd.w = vavg(Vu.w,Vv.w):rnd
		.encoding = { .mask = 0xffe020e0, .op = 0x1ce000c0 },
		.id = HEX_INS_V6_VAVGWRND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vavg(.w,.w):rnd",
	},
	{
		// 00011010011vvvvvPP0uuuuu0ssddddd | if (Ps) Vdd = vcombine(Vu,Vv)
		.encoding = { .mask = 0xffe02080, .op = 0x1a600000 },
		.id = HEX_INS_V6_VCCOMBINE,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = vcombine(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0001111000000010PP0uuuuu111ddddd | Vd.uh = vcl0(Vu.uh)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e0200e0 },
		.id = HEX_INS_V6_VCL0H,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vcl0(.uh)",
	},
	{
		// 0001111000000010PP0uuuuu101ddddd | Vd.uw = vcl0(Vu.uw)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e0200a0 },
		.id = HEX_INS_V6_VCL0W,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vcl0(.uw)",
	},
	{
		// 0001101000000000PP0uuuuu0ssddddd | if (Ps) Vd = Vu
		.encoding = { .mask = 0xffff2080, .op = 0x1a000000 },
		.id = HEX_INS_V6_VCMOV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 9 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00011111010vvvvvPP0uuuuu111ddddd | Vdd = vcombine(Vu,Vv)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f4000e0 },
		.id = HEX_INS_V6_VCOMBINE,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vcombine(,)",
	},
	{
		// 00011110101vvvvvPP0uuuuu111ddddd | Vdd.tmp = vcombine(Vu,Vv)
		.encoding = { .mask = 0xffe020e0, .op = 0x1ea000e0 },
		.id = HEX_INS_V6_VCOMBINE_TMP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".tmp = vcombine(,)",
	},
	{
		// 0001111000000101PP1uuuuu010ddddd | Vd.h = Vu.hf
		.encoding = { .mask = 0xffff20e0, .op = 0x1e052040 },
		.id = HEX_INS_V6_VCONV_H_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 5 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = .hf",
	},
	{
		// 0001111000000101PP1uuuuu100ddddd | Vd.hf = Vu.h
		.encoding = { .mask = 0xffff20e0, .op = 0x1e052080 },
		.id = HEX_INS_V6_VCONV_HF_H,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = .h",
	},
	{
		// 0001111000000100PP1uuuuu011ddddd | Vd.hf = Vu.qf16
		.encoding = { .mask = 0xffff20e0, .op = 0x1e042060 },
		.id = HEX_INS_V6_VCONV_HF_QF16,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = .qf16",
	},
	{
		// 0001111000000100PP1uuuuu110ddddd | Vd.hf = Vuu.qf32
		.encoding = { .mask = 0xffff20e0, .op = 0x1e0420c0 },
		.id = HEX_INS_V6_VCONV_HF_QF32,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = .qf32",
	},
	{
		// 0001111000000100PP1uuuuu000ddddd | Vd.sf = Vu.qf32
		.encoding = { .mask = 0xffff20e0, .op = 0x1e042000 },
		.id = HEX_INS_V6_VCONV_SF_QF32,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = .qf32",
	},
	{
		// 0001111000000101PP1uuuuu011ddddd | Vd.sf = Vu.w
		.encoding = { .mask = 0xffff20e0, .op = 0x1e052060 },
		.id = HEX_INS_V6_VCONV_SF_W,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = .w",
	},
	{
		// 0001111000000101PP1uuuuu001ddddd | Vd.w = Vu.sf
		.encoding = { .mask = 0xffff20e0, .op = 0x1e052020 },
		.id = HEX_INS_V6_VCONV_W_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 5 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = .sf",
	},
	{
		// 00011111110vvvvvPP1uuuuu110ddddd | Vd.b = vcvt(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc020c0 },
		.id = HEX_INS_V6_VCVT_B_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vcvt(.hf,.hf)",
	},
	{
		// 00011101010vvvvvPP1uuuuu011ddddd | Vd.bf = vcvt(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1d402060 },
		.id = HEX_INS_V6_VCVT_BF_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".bf = vcvt(.sf,.sf)",
	},
	{
		// 0001111000000110PP1uuuuu000ddddd | Vd.h = vcvt(Vu.hf)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e062000 },
		.id = HEX_INS_V6_VCVT_H_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vcvt(.hf)",
	},
	{
		// 0001111000000100PP1uuuuu010ddddd | Vdd.hf = vcvt(Vu.b)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e042040 },
		.id = HEX_INS_V6_VCVT_HF_B,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = vcvt(.b)",
	},
	{
		// 0001111000000100PP1uuuuu111ddddd | Vd.hf = vcvt(Vu.h)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e0420e0 },
		.id = HEX_INS_V6_VCVT_HF_H,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = vcvt(.h)",
	},
	{
		// 00011111011vvvvvPP1uuuuu001ddddd | Vd.hf = vcvt(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f602020 },
		.id = HEX_INS_V6_VCVT_HF_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = vcvt(.sf,.sf)",
	},
	{
		// 0001111000000100PP1uuuuu001ddddd | Vdd.hf = vcvt(Vu.ub)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e042020 },
		.id = HEX_INS_V6_VCVT_HF_UB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = vcvt(.ub)",
	},
	{
		// 0001111000000100PP1uuuuu101ddddd | Vd.hf = vcvt(Vu.uh)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e0420a0 },
		.id = HEX_INS_V6_VCVT_HF_UH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = vcvt(.uh)",
	},
	{
		// 0001111000000100PP1uuuuu100ddddd | Vdd.sf = vcvt(Vu.hf)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e042080 },
		.id = HEX_INS_V6_VCVT_SF_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vcvt(.hf)",
	},
	{
		// 00011111110vvvvvPP1uuuuu101ddddd | Vd.ub = vcvt(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc020a0 },
		.id = HEX_INS_V6_VCVT_UB_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vcvt(.hf,.hf)",
	},
	{
		// 0001111000000101PP1uuuuu000ddddd | Vd.uh = vcvt(Vu.hf)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e052000 },
		.id = HEX_INS_V6_VCVT_UH_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vcvt(.hf)",
	},
	{
		// 00011001111tttttPP1yyyyy010xxxxx | vdeal(Vy,Vx,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x19e02040 },
		.id = HEX_INS_V6_VDEAL,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vdeal(,,)",
	},
	{
		// 0001111000000000PP0uuuuu111ddddd | Vd.b = vdeal(Vu.b)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e0000e0 },
		.id = HEX_INS_V6_VDEALB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vdeal(.b)",
	},
	{
		// 00011111001vvvvvPP0uuuuu111ddddd | Vd.b = vdeale(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f2000e0 },
		.id = HEX_INS_V6_VDEALB4W,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vdeale(.b,.b)",
	},
	{
		// 0001111000000000PP0uuuuu110ddddd | Vd.h = vdeal(Vu.h)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e0000c0 },
		.id = HEX_INS_V6_VDEALH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vdeal(.h)",
	},
	{
		// 00011011vvvvvtttPP1uuuuu100ddddd | Vdd = vdeal(Vu,Vv,Rt)
		.encoding = { .mask = 0xff0020e0, .op = 0x1b002080 },
		.id = HEX_INS_V6_VDEALVDD,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vdeal(,,)",
	},
	{
		// 00011111001vvvvvPP0uuuuu001ddddd | Vd = vdelta(Vu,Vv)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f200020 },
		.id = HEX_INS_V6_VDELTA,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vdelta(,)",
	},
	{
		// 00011111101vvvvvPP1uuuuu110ddddd | Vd.sf = vdmpy(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa020c0 },
		.id = HEX_INS_V6_VDMPY_SF_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vdmpy(.hf,.hf)",
	},
	{
		// 00011100010vvvvvPP1uuuuu011xxxxx | Vx.sf += vdmpy(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c402060 },
		.id = HEX_INS_V6_VDMPY_SF_HF_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf += vdmpy(.hf,.hf)",
	},
	{
		// 00011001000tttttPP0uuuuu110ddddd | Vd.h = vdmpy(Vu.ub,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x190000c0 },
		.id = HEX_INS_V6_VDMPYBUS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vdmpy(.ub,.b)",
	},
	{
		// 00011001000tttttPP1uuuuu110xxxxx | Vx.h += vdmpy(Vu.ub,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x190020c0 },
		.id = HEX_INS_V6_VDMPYBUS_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h += vdmpy(.ub,.b)",
	},
	{
		// 00011001000tttttPP0uuuuu111ddddd | Vdd.h = vdmpy(Vuu.ub,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x190000e0 },
		.id = HEX_INS_V6_VDMPYBUS_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vdmpy(.ub,.b)",
	},
	{
		// 00011001000tttttPP1uuuuu111xxxxx | Vxx.h += vdmpy(Vuu.ub,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x190020e0 },
		.id = HEX_INS_V6_VDMPYBUS_DV_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h += vdmpy(.ub,.b)",
	},
	{
		// 00011001000tttttPP0uuuuu010ddddd | Vd.w = vdmpy(Vu.h,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19000040 },
		.id = HEX_INS_V6_VDMPYHB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vdmpy(.h,.b)",
	},
	{
		// 00011001000tttttPP1uuuuu011xxxxx | Vx.w += vdmpy(Vu.h,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19002060 },
		.id = HEX_INS_V6_VDMPYHB_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vdmpy(.h,.b)",
	},
	{
		// 00011001001tttttPP0uuuuu100ddddd | Vdd.w = vdmpy(Vuu.h,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19200080 },
		.id = HEX_INS_V6_VDMPYHB_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vdmpy(.h,.b)",
	},
	{
		// 00011001001tttttPP1uuuuu100xxxxx | Vxx.w += vdmpy(Vuu.h,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19202080 },
		.id = HEX_INS_V6_VDMPYHB_DV_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vdmpy(.h,.b)",
	},
	{
		// 00011001001tttttPP0uuuuu011ddddd | Vd.w = vdmpy(Vuu.h,Rt.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x19200060 },
		.id = HEX_INS_V6_VDMPYHISAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vdmpy(.h,.h):sat",
	},
	{
		// 00011001001tttttPP1uuuuu010xxxxx | Vx.w += vdmpy(Vuu.h,Rt.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x19202040 },
		.id = HEX_INS_V6_VDMPYHISAT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vdmpy(.h,.h):sat",
	},
	{
		// 00011001001tttttPP0uuuuu010ddddd | Vd.w = vdmpy(Vu.h,Rt.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x19200040 },
		.id = HEX_INS_V6_VDMPYHSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vdmpy(.h,.h):sat",
	},
	{
		// 00011001001tttttPP1uuuuu011xxxxx | Vx.w += vdmpy(Vu.h,Rt.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x19202060 },
		.id = HEX_INS_V6_VDMPYHSAT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vdmpy(.h,.h):sat",
	},
	{
		// 00011001001tttttPP0uuuuu001ddddd | Vd.w = vdmpy(Vuu.h,Rt.uh,#1):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x19200020 },
		.id = HEX_INS_V6_VDMPYHSUISAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vdmpy(.h,.uh,#1):sat",
	},
	{
		// 00011001001tttttPP1uuuuu001xxxxx | Vx.w += vdmpy(Vuu.h,Rt.uh,#1):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x19202020 },
		.id = HEX_INS_V6_VDMPYHSUISAT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vdmpy(.h,.uh,#1):sat",
	},
	{
		// 00011001001tttttPP0uuuuu000ddddd | Vd.w = vdmpy(Vu.h,Rt.uh):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x19200000 },
		.id = HEX_INS_V6_VDMPYHSUSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vdmpy(.h,.uh):sat",
	},
	{
		// 00011001001tttttPP1uuuuu000xxxxx | Vx.w += vdmpy(Vu.h,Rt.uh):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x19202000 },
		.id = HEX_INS_V6_VDMPYHSUSAT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vdmpy(.h,.uh):sat",
	},
	{
		// 00011100000vvvvvPP0uuuuu011ddddd | Vd.w = vdmpy(Vu.h,Vv.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c000060 },
		.id = HEX_INS_V6_VDMPYHVSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vdmpy(.h,.h):sat",
	},
	{
		// 00011100000vvvvvPP1uuuuu011xxxxx | Vx.w += vdmpy(Vu.h,Vv.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c002060 },
		.id = HEX_INS_V6_VDMPYHVSAT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vdmpy(.h,.h):sat",
	},
	{
		// 00011001000tttttPP0uuuuu101ddddd | Vdd.uw = vdsad(Vuu.uh,Rt.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x190000a0 },
		.id = HEX_INS_V6_VDSADUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vdsad(.uh,.uh)",
	},
	{
		// 00011001011tttttPP1uuuuu000xxxxx | Vxx.uw += vdsad(Vuu.uh,Rt.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x19602000 },
		.id = HEX_INS_V6_VDSADUH_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw += vdsad(.uh,.uh)",
	},
	{
		// 00011111100vvvvvPP0uuuuu000000dd | Qd = vcmp.eq(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020fc, .op = 0x1f800000 },
		.id = HEX_INS_V6_VEQB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vcmp.eq(.b,.b)",
	},
	{
		// 00011100100vvvvvPP1uuuuu000000xx | Qx &= vcmp.eq(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802000 },
		.id = HEX_INS_V6_VEQB_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= vcmp.eq(.b,.b)",
	},
	{
		// 00011100100vvvvvPP1uuuuu010000xx | Qx |= vcmp.eq(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802040 },
		.id = HEX_INS_V6_VEQB_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vcmp.eq(.b,.b)",
	},
	{
		// 00011100100vvvvvPP1uuuuu100000xx | Qx ^= vcmp.eq(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802080 },
		.id = HEX_INS_V6_VEQB_XOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= vcmp.eq(.b,.b)",
	},
	{
		// 00011111100vvvvvPP0uuuuu000001dd | Qd = vcmp.eq(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020fc, .op = 0x1f800004 },
		.id = HEX_INS_V6_VEQH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vcmp.eq(.h,.h)",
	},
	{
		// 00011100100vvvvvPP1uuuuu000001xx | Qx &= vcmp.eq(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802004 },
		.id = HEX_INS_V6_VEQH_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= vcmp.eq(.h,.h)",
	},
	{
		// 00011100100vvvvvPP1uuuuu010001xx | Qx |= vcmp.eq(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802044 },
		.id = HEX_INS_V6_VEQH_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vcmp.eq(.h,.h)",
	},
	{
		// 00011100100vvvvvPP1uuuuu100001xx | Qx ^= vcmp.eq(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802084 },
		.id = HEX_INS_V6_VEQH_XOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= vcmp.eq(.h,.h)",
	},
	{
		// 00011111100vvvvvPP0uuuuu000010dd | Qd = vcmp.eq(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020fc, .op = 0x1f800008 },
		.id = HEX_INS_V6_VEQW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vcmp.eq(.w,.w)",
	},
	{
		// 00011100100vvvvvPP1uuuuu000010xx | Qx &= vcmp.eq(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802008 },
		.id = HEX_INS_V6_VEQW_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= vcmp.eq(.w,.w)",
	},
	{
		// 00011100100vvvvvPP1uuuuu010010xx | Qx |= vcmp.eq(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802048 },
		.id = HEX_INS_V6_VEQW_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vcmp.eq(.w,.w)",
	},
	{
		// 00011100100vvvvvPP1uuuuu100010xx | Qx ^= vcmp.eq(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802088 },
		.id = HEX_INS_V6_VEQW_XOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= vcmp.eq(.w,.w)",
	},
	{
		// 00011100011vvvvvPP1uuuuu010ddddd | Vd.hf = vfmax(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c602040 },
		.id = HEX_INS_V6_VFMAX_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = vfmax(.hf,.hf)",
	},
	{
		// 00011100011vvvvvPP1uuuuu011ddddd | Vd.sf = vfmax(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c602060 },
		.id = HEX_INS_V6_VFMAX_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vfmax(.sf,.sf)",
	},
	{
		// 00011100011vvvvvPP1uuuuu000ddddd | Vd.hf = vfmin(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c602000 },
		.id = HEX_INS_V6_VFMIN_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = vfmin(.hf,.hf)",
	},
	{
		// 00011100011vvvvvPP1uuuuu001ddddd | Vd.sf = vfmin(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c602020 },
		.id = HEX_INS_V6_VFMIN_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vfmin(.sf,.sf)",
	},
	{
		// 0001111000000110PP1uuuuu010ddddd | Vd.hf = vfneg(Vu.hf)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e062040 },
		.id = HEX_INS_V6_VFNEG_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = vfneg(.hf)",
	},
	{
		// 0001111000000110PP1uuuuu011ddddd | Vd.sf = vfneg(Vu.sf)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e062060 },
		.id = HEX_INS_V6_VFNEG_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vfneg(.sf)",
	},
	{
		// 00011111100vvvvvPP0uuuuu000100dd | Qd = vcmp.gt(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020fc, .op = 0x1f800010 },
		.id = HEX_INS_V6_VGTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vcmp.gt(.b,.b)",
	},
	{
		// 00011100100vvvvvPP1uuuuu000100xx | Qx &= vcmp.gt(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802010 },
		.id = HEX_INS_V6_VGTB_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= vcmp.gt(.b,.b)",
	},
	{
		// 00011100100vvvvvPP1uuuuu010100xx | Qx |= vcmp.gt(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802050 },
		.id = HEX_INS_V6_VGTB_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vcmp.gt(.b,.b)",
	},
	{
		// 00011100100vvvvvPP1uuuuu100100xx | Qx ^= vcmp.gt(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802090 },
		.id = HEX_INS_V6_VGTB_XOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= vcmp.gt(.b,.b)",
	},
	{
		// 00011100100vvvvvPP1uuuuu011110dd | Qd = vcmp.gt(Vu.bf,Vv.bf)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802078 },
		.id = HEX_INS_V6_VGTBF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vcmp.gt(.bf,.bf)",
	},
	{
		// 00011100100vvvvvPP1uuuuu110100xx | Qx &= vcmp.gt(Vu.bf,Vv.bf)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c8020d0 },
		.id = HEX_INS_V6_VGTBF_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= vcmp.gt(.bf,.bf)",
	},
	{
		// 00011100100vvvvvPP1uuuuu001110xx | Qx |= vcmp.gt(Vu.bf,Vv.bf)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802038 },
		.id = HEX_INS_V6_VGTBF_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vcmp.gt(.bf,.bf)",
	},
	{
		// 00011100100vvvvvPP1uuuuu111100xx | Qx ^= vcmp.gt(Vu.bf,Vv.bf)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c8020f0 },
		.id = HEX_INS_V6_VGTBF_XOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= vcmp.gt(.bf,.bf)",
	},
	{
		// 00011111100vvvvvPP0uuuuu000101dd | Qd = vcmp.gt(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020fc, .op = 0x1f800014 },
		.id = HEX_INS_V6_VGTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vcmp.gt(.h,.h)",
	},
	{
		// 00011100100vvvvvPP1uuuuu000101xx | Qx &= vcmp.gt(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802014 },
		.id = HEX_INS_V6_VGTH_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= vcmp.gt(.h,.h)",
	},
	{
		// 00011100100vvvvvPP1uuuuu010101xx | Qx |= vcmp.gt(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802054 },
		.id = HEX_INS_V6_VGTH_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vcmp.gt(.h,.h)",
	},
	{
		// 00011100100vvvvvPP1uuuuu100101xx | Qx ^= vcmp.gt(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802094 },
		.id = HEX_INS_V6_VGTH_XOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= vcmp.gt(.h,.h)",
	},
	{
		// 00011100100vvvvvPP1uuuuu011101dd | Qd = vcmp.gt(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802074 },
		.id = HEX_INS_V6_VGTHF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vcmp.gt(.hf,.hf)",
	},
	{
		// 00011100100vvvvvPP1uuuuu110011xx | Qx &= vcmp.gt(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c8020cc },
		.id = HEX_INS_V6_VGTHF_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= vcmp.gt(.hf,.hf)",
	},
	{
		// 00011100100vvvvvPP1uuuuu001101xx | Qx |= vcmp.gt(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802034 },
		.id = HEX_INS_V6_VGTHF_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vcmp.gt(.hf,.hf)",
	},
	{
		// 00011100100vvvvvPP1uuuuu111011xx | Qx ^= vcmp.gt(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c8020ec },
		.id = HEX_INS_V6_VGTHF_XOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= vcmp.gt(.hf,.hf)",
	},
	{
		// 00011100100vvvvvPP1uuuuu011100dd | Qd = vcmp.gt(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802070 },
		.id = HEX_INS_V6_VGTSF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vcmp.gt(.sf,.sf)",
	},
	{
		// 00011100100vvvvvPP1uuuuu110010xx | Qx &= vcmp.gt(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c8020c8 },
		.id = HEX_INS_V6_VGTSF_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= vcmp.gt(.sf,.sf)",
	},
	{
		// 00011100100vvvvvPP1uuuuu001100xx | Qx |= vcmp.gt(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802030 },
		.id = HEX_INS_V6_VGTSF_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vcmp.gt(.sf,.sf)",
	},
	{
		// 00011100100vvvvvPP1uuuuu111010xx | Qx ^= vcmp.gt(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c8020e8 },
		.id = HEX_INS_V6_VGTSF_XOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= vcmp.gt(.sf,.sf)",
	},
	{
		// 00011111100vvvvvPP0uuuuu001000dd | Qd = vcmp.gt(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020fc, .op = 0x1f800020 },
		.id = HEX_INS_V6_VGTUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vcmp.gt(.ub,.ub)",
	},
	{
		// 00011100100vvvvvPP1uuuuu001000xx | Qx &= vcmp.gt(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802020 },
		.id = HEX_INS_V6_VGTUB_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= vcmp.gt(.ub,.ub)",
	},
	{
		// 00011100100vvvvvPP1uuuuu011000xx | Qx |= vcmp.gt(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802060 },
		.id = HEX_INS_V6_VGTUB_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vcmp.gt(.ub,.ub)",
	},
	{
		// 00011100100vvvvvPP1uuuuu101000xx | Qx ^= vcmp.gt(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c8020a0 },
		.id = HEX_INS_V6_VGTUB_XOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= vcmp.gt(.ub,.ub)",
	},
	{
		// 00011111100vvvvvPP0uuuuu001001dd | Qd = vcmp.gt(Vu.uh,Vv.uh)
		.encoding = { .mask = 0xffe020fc, .op = 0x1f800024 },
		.id = HEX_INS_V6_VGTUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vcmp.gt(.uh,.uh)",
	},
	{
		// 00011100100vvvvvPP1uuuuu001001xx | Qx &= vcmp.gt(Vu.uh,Vv.uh)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802024 },
		.id = HEX_INS_V6_VGTUH_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= vcmp.gt(.uh,.uh)",
	},
	{
		// 00011100100vvvvvPP1uuuuu011001xx | Qx |= vcmp.gt(Vu.uh,Vv.uh)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802064 },
		.id = HEX_INS_V6_VGTUH_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vcmp.gt(.uh,.uh)",
	},
	{
		// 00011100100vvvvvPP1uuuuu101001xx | Qx ^= vcmp.gt(Vu.uh,Vv.uh)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c8020a4 },
		.id = HEX_INS_V6_VGTUH_XOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= vcmp.gt(.uh,.uh)",
	},
	{
		// 00011111100vvvvvPP0uuuuu001010dd | Qd = vcmp.gt(Vu.uw,Vv.uw)
		.encoding = { .mask = 0xffe020fc, .op = 0x1f800028 },
		.id = HEX_INS_V6_VGTUW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vcmp.gt(.uw,.uw)",
	},
	{
		// 00011100100vvvvvPP1uuuuu001010xx | Qx &= vcmp.gt(Vu.uw,Vv.uw)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802028 },
		.id = HEX_INS_V6_VGTUW_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= vcmp.gt(.uw,.uw)",
	},
	{
		// 00011100100vvvvvPP1uuuuu011010xx | Qx |= vcmp.gt(Vu.uw,Vv.uw)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802068 },
		.id = HEX_INS_V6_VGTUW_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vcmp.gt(.uw,.uw)",
	},
	{
		// 00011100100vvvvvPP1uuuuu101010xx | Qx ^= vcmp.gt(Vu.uw,Vv.uw)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c8020a8 },
		.id = HEX_INS_V6_VGTUW_XOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= vcmp.gt(.uw,.uw)",
	},
	{
		// 00011111100vvvvvPP0uuuuu000110dd | Qd = vcmp.gt(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020fc, .op = 0x1f800018 },
		.id = HEX_INS_V6_VGTW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vcmp.gt(.w,.w)",
	},
	{
		// 00011100100vvvvvPP1uuuuu000110xx | Qx &= vcmp.gt(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802018 },
		.id = HEX_INS_V6_VGTW_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= vcmp.gt(.w,.w)",
	},
	{
		// 00011100100vvvvvPP1uuuuu010110xx | Qx |= vcmp.gt(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802058 },
		.id = HEX_INS_V6_VGTW_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= vcmp.gt(.w,.w)",
	},
	{
		// 00011100100vvvvvPP1uuuuu100110xx | Qx ^= vcmp.gt(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020fc, .op = 0x1c802098 },
		.id = HEX_INS_V6_VGTW_XOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= vcmp.gt(.w,.w)",
	},
	{
		// 0001111000000000PP10000010000000 | vhist
		.encoding = { .mask = 0xffff3fff, .op = 0x1e002080 },
		.id = HEX_INS_V6_VHIST,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vhist",
	},
	{
		// 00011110vv000010PP10000010000000 | vhist(Qv)
		.encoding = { .mask = 0xff3f3fff, .op = 0x1e022080 },
		.id = HEX_INS_V6_VHISTQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vhist()",
	},
	{
		// 00011001101tttttPP100000001xxxxx | Vx.w = vinsert(Rt)
		.encoding = { .mask = 0xffe03fe0, .op = 0x19a02020 },
		.id = HEX_INS_V6_VINSERTWR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vinsert()",
	},
	{
		// 00011011vvvvvtttPP0uuuuu001ddddd | Vd = vlalign(Vu,Vv,Rt)
		.encoding = { .mask = 0xff0020e0, .op = 0x1b000020 },
		.id = HEX_INS_V6_VLALIGNB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vlalign(,,)",
	},
	{
		// 00011110011vvvvvPP1uuuuuiiiddddd | Vd = vlalign(Vu,Vv,Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x1e602000 },
		.id = HEX_INS_V6_VLALIGNBI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 5 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vlalign(,,)",
	},
	{
		// 00011001100tttttPP0uuuuu011ddddd | Vd.ub = vlsr(Vu.ub,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x19800060 },
		.id = HEX_INS_V6_VLSRB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vlsr(.ub,)",
	},
	{
		// 00011001100tttttPP0uuuuu010ddddd | Vd.uh = vlsr(Vu.uh,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x19800040 },
		.id = HEX_INS_V6_VLSRH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vlsr(.uh,)",
	},
	{
		// 00011111101vvvvvPP0uuuuu010ddddd | Vd.h = vlsr(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa00040 },
		.id = HEX_INS_V6_VLSRHV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vlsr(.h,.h)",
	},
	{
		// 00011001100tttttPP0uuuuu001ddddd | Vd.uw = vlsr(Vu.uw,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x19800020 },
		.id = HEX_INS_V6_VLSRW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vlsr(.uw,)",
	},
	{
		// 00011111101vvvvvPP0uuuuu001ddddd | Vd.w = vlsr(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa00020 },
		.id = HEX_INS_V6_VLSRWV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vlsr(.w,.w)",
	},
	{
		// 00011001011tttttPP0uuuuu100ddddd | Vd.h = vlut4(Vu.uh,Rtt.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x19600080 },
		.id = HEX_INS_V6_VLUT4,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vlut4(.uh,.h)",
	},
	{
		// 00011011vvvvvtttPP1uuuuu001ddddd | Vd.b = vlut32(Vu.b,Vv.b,Rt)
		.encoding = { .mask = 0xff0020e0, .op = 0x1b002020 },
		.id = HEX_INS_V6_VLUTVVB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vlut32(.b,.b,)",
	},
	{
		// 00011000vvvvvtttPP0uuuuu011ddddd | Vd.b = vlut32(Vu.b,Vv.b,Rt):nomatch
		.encoding = { .mask = 0xff0020e0, .op = 0x18000060 },
		.id = HEX_INS_V6_VLUTVVB_NM,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vlut32(.b,.b,):nomatch",
	},
	{
		// 00011011vvvvvtttPP1uuuuu101xxxxx | Vx.b |= vlut32(Vu.b,Vv.b,Rt)
		.encoding = { .mask = 0xff0020e0, .op = 0x1b0020a0 },
		.id = HEX_INS_V6_VLUTVVB_ORACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b |= vlut32(.b,.b,)",
	},
	{
		// 00011100110vvvvvPP1uuuuuiiixxxxx | Vx.b |= vlut32(Vu.b,Vv.b,Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x1cc02000 },
		.id = HEX_INS_V6_VLUTVVB_ORACCI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 5 } }, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b |= vlut32(.b,.b,)",
	},
	{
		// 00011110001vvvvvPP0uuuuuiiiddddd | Vd.b = vlut32(Vu.b,Vv.b,Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x1e200000 },
		.id = HEX_INS_V6_VLUTVVBI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 5 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vlut32(.b,.b,)",
	},
	{
		// 00011011vvvvvtttPP1uuuuu110ddddd | Vdd.h = vlut16(Vu.b,Vv.h,Rt)
		.encoding = { .mask = 0xff0020e0, .op = 0x1b0020c0 },
		.id = HEX_INS_V6_VLUTVWH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vlut16(.b,.h,)",
	},
	{
		// 00011000vvvvvtttPP0uuuuu100ddddd | Vdd.h = vlut16(Vu.b,Vv.h,Rt):nomatch
		.encoding = { .mask = 0xff0020e0, .op = 0x18000080 },
		.id = HEX_INS_V6_VLUTVWH_NM,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vlut16(.b,.h,):nomatch",
	},
	{
		// 00011011vvvvvtttPP1uuuuu111xxxxx | Vxx.h |= vlut16(Vu.b,Vv.h,Rt)
		.encoding = { .mask = 0xff0020e0, .op = 0x1b0020e0 },
		.id = HEX_INS_V6_VLUTVWH_ORACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h |= vlut16(.b,.h,)",
	},
	{
		// 00011100111vvvvvPP1uuuuuiiixxxxx | Vxx.h |= vlut16(Vu.b,Vv.h,Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x1ce02000 },
		.id = HEX_INS_V6_VLUTVWH_ORACCI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 5 } }, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h |= vlut16(.b,.h,)",
	},
	{
		// 00011110011vvvvvPP0uuuuuiiiddddd | Vdd.h = vlut16(Vu.b,Vv.h,Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x1e600000 },
		.id = HEX_INS_V6_VLUTVWHI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 5 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vlut16(.b,.h,)",
	},
	{
		// 00011101010vvvvvPP1uuuuu111ddddd | Vd.bf = vmax(Vu.bf,Vv.bf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1d4020e0 },
		.id = HEX_INS_V6_VMAX_BF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".bf = vmax(.bf,.bf)",
	},
	{
		// 00011111110vvvvvPP1uuuuu011ddddd | Vd.hf = vmax(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc02060 },
		.id = HEX_INS_V6_VMAX_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = vmax(.hf,.hf)",
	},
	{
		// 00011111110vvvvvPP1uuuuu001ddddd | Vd.sf = vmax(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc02020 },
		.id = HEX_INS_V6_VMAX_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vmax(.sf,.sf)",
	},
	{
		// 00011111001vvvvvPP0uuuuu101ddddd | Vd.b = vmax(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f2000a0 },
		.id = HEX_INS_V6_VMAXB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vmax(.b,.b)",
	},
	{
		// 00011111000vvvvvPP0uuuuu111ddddd | Vd.h = vmax(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f0000e0 },
		.id = HEX_INS_V6_VMAXH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmax(.h,.h)",
	},
	{
		// 00011111000vvvvvPP0uuuuu101ddddd | Vd.ub = vmax(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f0000a0 },
		.id = HEX_INS_V6_VMAXUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vmax(.ub,.ub)",
	},
	{
		// 00011111000vvvvvPP0uuuuu110ddddd | Vd.uh = vmax(Vu.uh,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f0000c0 },
		.id = HEX_INS_V6_VMAXUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vmax(.uh,.uh)",
	},
	{
		// 00011111001vvvvvPP0uuuuu000ddddd | Vd.w = vmax(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f200000 },
		.id = HEX_INS_V6_VMAXW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmax(.w,.w)",
	},
	{
		// 00011101010vvvvvPP1uuuuu000ddddd | Vd.bf = vmin(Vu.bf,Vv.bf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1d402000 },
		.id = HEX_INS_V6_VMIN_BF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".bf = vmin(.bf,.bf)",
	},
	{
		// 00011111110vvvvvPP1uuuuu100ddddd | Vd.hf = vmin(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc02080 },
		.id = HEX_INS_V6_VMIN_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = vmin(.hf,.hf)",
	},
	{
		// 00011111110vvvvvPP1uuuuu010ddddd | Vd.sf = vmin(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc02040 },
		.id = HEX_INS_V6_VMIN_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vmin(.sf,.sf)",
	},
	{
		// 00011111001vvvvvPP0uuuuu100ddddd | Vd.b = vmin(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f200080 },
		.id = HEX_INS_V6_VMINB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vmin(.b,.b)",
	},
	{
		// 00011111000vvvvvPP0uuuuu011ddddd | Vd.h = vmin(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f000060 },
		.id = HEX_INS_V6_VMINH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmin(.h,.h)",
	},
	{
		// 00011111000vvvvvPP0uuuuu001ddddd | Vd.ub = vmin(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f000020 },
		.id = HEX_INS_V6_VMINUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vmin(.ub,.ub)",
	},
	{
		// 00011111000vvvvvPP0uuuuu010ddddd | Vd.uh = vmin(Vu.uh,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f000040 },
		.id = HEX_INS_V6_VMINUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vmin(.uh,.uh)",
	},
	{
		// 00011111000vvvvvPP0uuuuu100ddddd | Vd.w = vmin(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f000080 },
		.id = HEX_INS_V6_VMINW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmin(.w,.w)",
	},
	{
		// 00011001001tttttPP0uuuuu110ddddd | Vdd.h = vmpa(Vuu.ub,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x192000c0 },
		.id = HEX_INS_V6_VMPABUS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmpa(.ub,.b)",
	},
	{
		// 00011001001tttttPP1uuuuu110xxxxx | Vxx.h += vmpa(Vuu.ub,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x192020c0 },
		.id = HEX_INS_V6_VMPABUS_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h += vmpa(.ub,.b)",
	},
	{
		// 00011100001vvvvvPP0uuuuu011ddddd | Vdd.h = vmpa(Vuu.ub,Vvv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c200060 },
		.id = HEX_INS_V6_VMPABUSV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmpa(.ub,.b)",
	},
	{
		// 00011001011tttttPP0uuuuu011ddddd | Vdd.h = vmpa(Vuu.ub,Rt.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x19600060 },
		.id = HEX_INS_V6_VMPABUU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmpa(.ub,.ub)",
	},
	{
		// 00011001101tttttPP1uuuuu100xxxxx | Vxx.h += vmpa(Vuu.ub,Rt.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x19a02080 },
		.id = HEX_INS_V6_VMPABUU_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h += vmpa(.ub,.ub)",
	},
	{
		// 00011100111vvvvvPP0uuuuu111ddddd | Vdd.h = vmpa(Vuu.ub,Vvv.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x1ce000e0 },
		.id = HEX_INS_V6_VMPABUUV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmpa(.ub,.ub)",
	},
	{
		// 00011001001tttttPP0uuuuu111ddddd | Vdd.w = vmpa(Vuu.h,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x192000e0 },
		.id = HEX_INS_V6_VMPAHB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmpa(.h,.b)",
	},
	{
		// 00011001001tttttPP1uuuuu111xxxxx | Vxx.w += vmpa(Vuu.h,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x192020e0 },
		.id = HEX_INS_V6_VMPAHB_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vmpa(.h,.b)",
	},
	{
		// 00011001100tttttPP1uuuuu100xxxxx | Vx.h = vmpa(Vxin.h,Vu.h,Rtt.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x19802080 },
		.id = HEX_INS_V6_VMPAHHSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmpa(.h,.h,.h):sat",
	},
	{
		// 00011001100tttttPP0uuuuu101ddddd | Vdd.w = vmpa(Vuu.uh,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x198000a0 },
		.id = HEX_INS_V6_VMPAUHB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmpa(.uh,.b)",
	},
	{
		// 00011001100tttttPP1uuuuu010xxxxx | Vxx.w += vmpa(Vuu.uh,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19802040 },
		.id = HEX_INS_V6_VMPAUHB_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vmpa(.uh,.b)",
	},
	{
		// 00011001100tttttPP1uuuuu101xxxxx | Vx.h = vmpa(Vxin.h,Vu.uh,Rtt.uh):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x198020a0 },
		.id = HEX_INS_V6_VMPAUHUHSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmpa(.h,.uh,.uh):sat",
	},
	{
		// 00011001100tttttPP1uuuuu110xxxxx | Vx.h = vmps(Vxin.h,Vu.uh,Rtt.uh):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x198020c0 },
		.id = HEX_INS_V6_VMPSUHUHSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmps(.h,.uh,.uh):sat",
	},
	{
		// 00011111100vvvvvPP1uuuuu011ddddd | Vd.hf = vmpy(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f802060 },
		.id = HEX_INS_V6_VMPY_HF_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = vmpy(.hf,.hf)",
	},
	{
		// 00011100010vvvvvPP1uuuuu010xxxxx | Vx.hf += vmpy(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c402040 },
		.id = HEX_INS_V6_VMPY_HF_HF_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf += vmpy(.hf,.hf)",
	},
	{
		// 00011111111vvvvvPP1uuuuu011ddddd | Vd.qf16 = vmpy(Vu.qf16,Vv.qf16)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fe02060 },
		.id = HEX_INS_V6_VMPY_QF16,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf16 = vmpy(.qf16,.qf16)",
	},
	{
		// 00011111111vvvvvPP1uuuuu100ddddd | Vd.qf16 = vmpy(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fe02080 },
		.id = HEX_INS_V6_VMPY_QF16_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf16 = vmpy(.hf,.hf)",
	},
	{
		// 00011111111vvvvvPP1uuuuu101ddddd | Vd.qf16 = vmpy(Vu.qf16,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fe020a0 },
		.id = HEX_INS_V6_VMPY_QF16_MIX_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf16 = vmpy(.qf16,.hf)",
	},
	{
		// 00011111111vvvvvPP1uuuuu000ddddd | Vd.qf32 = vmpy(Vu.qf32,Vv.qf32)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fe02000 },
		.id = HEX_INS_V6_VMPY_QF32,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf32 = vmpy(.qf32,.qf32)",
	},
	{
		// 00011111111vvvvvPP1uuuuu111ddddd | Vdd.qf32 = vmpy(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fe020e0 },
		.id = HEX_INS_V6_VMPY_QF32_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf32 = vmpy(.hf,.hf)",
	},
	{
		// 00011111100vvvvvPP1uuuuu000ddddd | Vdd.qf32 = vmpy(Vu.qf16,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f802000 },
		.id = HEX_INS_V6_VMPY_QF32_MIX_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf32 = vmpy(.qf16,.hf)",
	},
	{
		// 00011111111vvvvvPP1uuuuu110ddddd | Vdd.qf32 = vmpy(Vu.qf16,Vv.qf16)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fe020c0 },
		.id = HEX_INS_V6_VMPY_QF32_QF16,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf32 = vmpy(.qf16,.qf16)",
	},
	{
		// 00011111111vvvvvPP1uuuuu001ddddd | Vd.qf32 = vmpy(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fe02020 },
		.id = HEX_INS_V6_VMPY_QF32_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf32 = vmpy(.sf,.sf)",
	},
	{
		// 00011101010vvvvvPP1uuuuu100ddddd | Vdd.sf = vmpy(Vu.bf,Vv.bf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1d402080 },
		.id = HEX_INS_V6_VMPY_SF_BF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vmpy(.bf,.bf)",
	},
	{
		// 00011101000vvvvvPP1uuuuu000xxxxx | Vxx.sf += vmpy(Vu.bf,Vv.bf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1d002000 },
		.id = HEX_INS_V6_VMPY_SF_BF_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf += vmpy(.bf,.bf)",
	},
	{
		// 00011111100vvvvvPP1uuuuu010ddddd | Vdd.sf = vmpy(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f802040 },
		.id = HEX_INS_V6_VMPY_SF_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vmpy(.hf,.hf)",
	},
	{
		// 00011100010vvvvvPP1uuuuu001xxxxx | Vxx.sf += vmpy(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c402020 },
		.id = HEX_INS_V6_VMPY_SF_HF_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf += vmpy(.hf,.hf)",
	},
	{
		// 00011111100vvvvvPP1uuuuu001ddddd | Vd.sf = vmpy(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f802020 },
		.id = HEX_INS_V6_VMPY_SF_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vmpy(.sf,.sf)",
	},
	{
		// 00011001001tttttPP0uuuuu101ddddd | Vdd.h = vmpy(Vu.ub,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x192000a0 },
		.id = HEX_INS_V6_VMPYBUS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmpy(.ub,.b)",
	},
	{
		// 00011001001tttttPP1uuuuu101xxxxx | Vxx.h += vmpy(Vu.ub,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x192020a0 },
		.id = HEX_INS_V6_VMPYBUS_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h += vmpy(.ub,.b)",
	},
	{
		// 00011100000vvvvvPP0uuuuu110ddddd | Vdd.h = vmpy(Vu.ub,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c0000c0 },
		.id = HEX_INS_V6_VMPYBUSV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmpy(.ub,.b)",
	},
	{
		// 00011100000vvvvvPP1uuuuu110xxxxx | Vxx.h += vmpy(Vu.ub,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c0020c0 },
		.id = HEX_INS_V6_VMPYBUSV_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h += vmpy(.ub,.b)",
	},
	{
		// 00011100000vvvvvPP0uuuuu100ddddd | Vdd.h = vmpy(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c000080 },
		.id = HEX_INS_V6_VMPYBV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmpy(.b,.b)",
	},
	{
		// 00011100000vvvvvPP1uuuuu100xxxxx | Vxx.h += vmpy(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c002080 },
		.id = HEX_INS_V6_VMPYBV_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h += vmpy(.b,.b)",
	},
	{
		// 00011111111vvvvvPP0uuuuu101ddddd | Vd.w = vmpye(Vu.w,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fe000a0 },
		.id = HEX_INS_V6_VMPYEWUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmpye(.w,.uh)",
	},
	{
		// 00011110101vvvvvPP0uuuuu110ddddd | Vdd = vmpye(Vu.w,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1ea000c0 },
		.id = HEX_INS_V6_VMPYEWUH_64,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vmpye(.w,.uh)",
	},
	{
		// 00011001010tttttPP0uuuuu000ddddd | Vdd.w = vmpy(Vu.h,Rt.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x19400000 },
		.id = HEX_INS_V6_VMPYH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmpy(.h,.h)",
	},
	{
		// 00011001101tttttPP1uuuuu110xxxxx | Vxx.w += vmpy(Vu.h,Rt.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x19a020c0 },
		.id = HEX_INS_V6_VMPYH_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vmpy(.h,.h)",
	},
	{
		// 00011001010tttttPP1uuuuu000xxxxx | Vxx.w += vmpy(Vu.h,Rt.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x19402000 },
		.id = HEX_INS_V6_VMPYHSAT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vmpy(.h,.h):sat",
	},
	{
		// 00011001010tttttPP0uuuuu010ddddd | Vd.h = vmpy(Vu.h,Rt.h):<<1:rnd:sat
		.encoding = { .mask = 0xffe020e0, .op = 0x19400040 },
		.id = HEX_INS_V6_VMPYHSRS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmpy(.h,.h):<<1:rnd:sat",
	},
	{
		// 00011001010tttttPP0uuuuu001ddddd | Vd.h = vmpy(Vu.h,Rt.h):<<1:sat
		.encoding = { .mask = 0xffe020e0, .op = 0x19400020 },
		.id = HEX_INS_V6_VMPYHSS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmpy(.h,.h):<<1:sat",
	},
	{
		// 00011100001vvvvvPP0uuuuu010ddddd | Vdd.w = vmpy(Vu.h,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c200040 },
		.id = HEX_INS_V6_VMPYHUS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmpy(.h,.uh)",
	},
	{
		// 00011100001vvvvvPP1uuuuu001xxxxx | Vxx.w += vmpy(Vu.h,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c202020 },
		.id = HEX_INS_V6_VMPYHUS_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vmpy(.h,.uh)",
	},
	{
		// 00011100000vvvvvPP0uuuuu111ddddd | Vdd.w = vmpy(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c0000e0 },
		.id = HEX_INS_V6_VMPYHV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmpy(.h,.h)",
	},
	{
		// 00011100000vvvvvPP1uuuuu111xxxxx | Vxx.w += vmpy(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c0020e0 },
		.id = HEX_INS_V6_VMPYHV_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vmpy(.h,.h)",
	},
	{
		// 00011100001vvvvvPP0uuuuu001ddddd | Vd.h = vmpy(Vu.h,Vv.h):<<1:rnd:sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c200020 },
		.id = HEX_INS_V6_VMPYHVSRS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmpy(.h,.h):<<1:rnd:sat",
	},
	{
		// 00011111011vvvvvPP0uuuuu000ddddd | Vd.w = vmpyieo(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f600000 },
		.id = HEX_INS_V6_VMPYIEOH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmpyieo(.h,.h)",
	},
	{
		// 00011100010vvvvvPP1uuuuu000xxxxx | Vx.w += vmpyie(Vu.w,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c402000 },
		.id = HEX_INS_V6_VMPYIEWH_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vmpyie(.w,.h)",
	},
	{
		// 00011111110vvvvvPP0uuuuu000ddddd | Vd.w = vmpyie(Vu.w,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc00000 },
		.id = HEX_INS_V6_VMPYIEWUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmpyie(.w,.uh)",
	},
	{
		// 00011100001vvvvvPP1uuuuu101xxxxx | Vx.w += vmpyie(Vu.w,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c2020a0 },
		.id = HEX_INS_V6_VMPYIEWUH_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vmpyie(.w,.uh)",
	},
	{
		// 00011100001vvvvvPP0uuuuu100ddddd | Vd.h = vmpyi(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c200080 },
		.id = HEX_INS_V6_VMPYIH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmpyi(.h,.h)",
	},
	{
		// 00011100001vvvvvPP1uuuuu100xxxxx | Vx.h += vmpyi(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c202080 },
		.id = HEX_INS_V6_VMPYIH_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h += vmpyi(.h,.h)",
	},
	{
		// 00011001011tttttPP0uuuuu000ddddd | Vd.h = vmpyi(Vu.h,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19600000 },
		.id = HEX_INS_V6_VMPYIHB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vmpyi(.h,.b)",
	},
	{
		// 00011001011tttttPP1uuuuu001xxxxx | Vx.h += vmpyi(Vu.h,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19602020 },
		.id = HEX_INS_V6_VMPYIHB_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h += vmpyi(.h,.b)",
	},
	{
		// 00011111110vvvvvPP0uuuuu001ddddd | Vd.w = vmpyio(Vu.w,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc00020 },
		.id = HEX_INS_V6_VMPYIOWH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmpyio(.w,.h)",
	},
	{
		// 00011001101tttttPP0uuuuu000ddddd | Vd.w = vmpyi(Vu.w,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19a00000 },
		.id = HEX_INS_V6_VMPYIWB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmpyi(.w,.b)",
	},
	{
		// 00011001010tttttPP1uuuuu010xxxxx | Vx.w += vmpyi(Vu.w,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19402040 },
		.id = HEX_INS_V6_VMPYIWB_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vmpyi(.w,.b)",
	},
	{
		// 00011001100tttttPP0uuuuu111ddddd | Vd.w = vmpyi(Vu.w,Rt.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x198000e0 },
		.id = HEX_INS_V6_VMPYIWH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmpyi(.w,.h)",
	},
	{
		// 00011001010tttttPP1uuuuu011xxxxx | Vx.w += vmpyi(Vu.w,Rt.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x19402060 },
		.id = HEX_INS_V6_VMPYIWH_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vmpyi(.w,.h)",
	},
	{
		// 00011001100tttttPP0uuuuu110ddddd | Vd.w = vmpyi(Vu.w,Rt.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x198000c0 },
		.id = HEX_INS_V6_VMPYIWUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmpyi(.w,.ub)",
	},
	{
		// 00011001100tttttPP1uuuuu001xxxxx | Vx.w += vmpyi(Vu.w,Rt.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x19802020 },
		.id = HEX_INS_V6_VMPYIWUB_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vmpyi(.w,.ub)",
	},
	{
		// 00011111111vvvvvPP0uuuuu111ddddd | Vd.w = vmpyo(Vu.w,Vv.h):<<1:sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1fe000e0 },
		.id = HEX_INS_V6_VMPYOWH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmpyo(.w,.h):<<1:sat",
	},
	{
		// 00011100001vvvvvPP1uuuuu011xxxxx | Vxx += vmpyo(Vu.w,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c202060 },
		.id = HEX_INS_V6_VMPYOWH_64_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " += vmpyo(.w,.h)",
	},
	{
		// 00011111010vvvvvPP0uuuuu000ddddd | Vd.w = vmpyo(Vu.w,Vv.h):<<1:rnd:sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1f400000 },
		.id = HEX_INS_V6_VMPYOWH_RND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vmpyo(.w,.h):<<1:rnd:sat",
	},
	{
		// 00011100001vvvvvPP1uuuuu111xxxxx | Vx.w += vmpyo(Vu.w,Vv.h):<<1:rnd:sat:shift
		.encoding = { .mask = 0xffe020e0, .op = 0x1c2020e0 },
		.id = HEX_INS_V6_VMPYOWH_RND_SACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vmpyo(.w,.h):<<1:rnd:sat:shift",
	},
	{
		// 00011100001vvvvvPP1uuuuu110xxxxx | Vx.w += vmpyo(Vu.w,Vv.h):<<1:sat:shift
		.encoding = { .mask = 0xffe020e0, .op = 0x1c2020c0 },
		.id = HEX_INS_V6_VMPYOWH_SACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vmpyo(.w,.h):<<1:sat:shift",
	},
	{
		// 00011001110tttttPP0uuuuu000ddddd | Vdd.uh = vmpy(Vu.ub,Rt.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x19c00000 },
		.id = HEX_INS_V6_VMPYUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vmpy(.ub,.ub)",
	},
	{
		// 00011001100tttttPP1uuuuu000xxxxx | Vxx.uh += vmpy(Vu.ub,Rt.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x19802000 },
		.id = HEX_INS_V6_VMPYUB_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh += vmpy(.ub,.ub)",
	},
	{
		// 00011100000vvvvvPP0uuuuu101ddddd | Vdd.uh = vmpy(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c0000a0 },
		.id = HEX_INS_V6_VMPYUBV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vmpy(.ub,.ub)",
	},
	{
		// 00011100000vvvvvPP1uuuuu101xxxxx | Vxx.uh += vmpy(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c0020a0 },
		.id = HEX_INS_V6_VMPYUBV_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh += vmpy(.ub,.ub)",
	},
	{
		// 00011001010tttttPP0uuuuu011ddddd | Vdd.uw = vmpy(Vu.uh,Rt.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x19400060 },
		.id = HEX_INS_V6_VMPYUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vmpy(.uh,.uh)",
	},
	{
		// 00011001010tttttPP1uuuuu001xxxxx | Vxx.uw += vmpy(Vu.uh,Rt.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x19402020 },
		.id = HEX_INS_V6_VMPYUH_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw += vmpy(.uh,.uh)",
	},
	{
		// 00011001011tttttPP0uuuuu010ddddd | Vd.uw = vmpye(Vu.uh,Rt.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x19600040 },
		.id = HEX_INS_V6_VMPYUHE,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vmpye(.uh,.uh)",
	},
	{
		// 00011001100tttttPP1uuuuu011xxxxx | Vx.uw += vmpye(Vu.uh,Rt.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x19802060 },
		.id = HEX_INS_V6_VMPYUHE_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw += vmpye(.uh,.uh)",
	},
	{
		// 00011100001vvvvvPP0uuuuu000ddddd | Vdd.uw = vmpy(Vu.uh,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c200000 },
		.id = HEX_INS_V6_VMPYUHV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vmpy(.uh,.uh)",
	},
	{
		// 00011100001vvvvvPP1uuuuu000xxxxx | Vxx.uw += vmpy(Vu.uh,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c202000 },
		.id = HEX_INS_V6_VMPYUHV_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw += vmpy(.uh,.uh)",
	},
	{
		// 00011111110vvvvvPP1uuuuu111ddddd | Vd.uh = vmpy(Vu.uh,Vv.uh):>>16
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc020e0 },
		.id = HEX_INS_V6_VMPYUHVS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vmpy(.uh,.uh):>>16",
	},
	{
		// 00011110111vvvvvPP1uuuuu0ttddddd | Vd = vmux(Qt,Vu,Vv)
		.encoding = { .mask = 0xffe02080, .op = 0x1ee02000 },
		.id = HEX_INS_V6_VMUX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vmux(,,)",
	},
	{
		// 00011111000vvvvvPP1uuuuu110ddddd | Vd.b = vnavg(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f0020c0 },
		.id = HEX_INS_V6_VNAVGB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vnavg(.b,.b)",
	},
	{
		// 00011100111vvvvvPP0uuuuu001ddddd | Vd.h = vnavg(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1ce00020 },
		.id = HEX_INS_V6_VNAVGH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vnavg(.h,.h)",
	},
	{
		// 00011100111vvvvvPP0uuuuu000ddddd | Vd.b = vnavg(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x1ce00000 },
		.id = HEX_INS_V6_VNAVGUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vnavg(.ub,.ub)",
	},
	{
		// 00011100111vvvvvPP0uuuuu010ddddd | Vd.w = vnavg(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1ce00040 },
		.id = HEX_INS_V6_VNAVGW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vnavg(.w,.w)",
	},
	{
		// 00011010010vvvvvPP0uuuuu0ssddddd | if (!Ps) Vdd = vcombine(Vu,Vv)
		.encoding = { .mask = 0xffe02080, .op = 0x1a400000 },
		.id = HEX_INS_V6_VNCCOMBINE,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 20 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = vcombine(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0001101000100000PP0uuuuu0ssddddd | if (!Ps) Vd = Vu
		.encoding = { .mask = 0xffff2080, .op = 0x1a200000 },
		.id = HEX_INS_V6_VNCMOV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0001111000000011PP0uuuuu101ddddd | Vd.h = vnormamt(Vu.h)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e0300a0 },
		.id = HEX_INS_V6_VNORMAMTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vnormamt(.h)",
	},
	{
		// 0001111000000011PP0uuuuu100ddddd | Vd.w = vnormamt(Vu.w)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e030080 },
		.id = HEX_INS_V6_VNORMAMTW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vnormamt(.w)",
	},
	{
		// 0001111000000000PP0uuuuu100ddddd | Vd = vnot(Vu)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e000080 },
		.id = HEX_INS_V6_VNOT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vnot()",
	},
	{
		// 00011100001vvvvvPP0uuuuu110ddddd | Vd = vor(Vu,Vv)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c2000c0 },
		.id = HEX_INS_V6_VOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vor(,)",
	},
	{
		// 00011111110vvvvvPP0uuuuu010ddddd | Vd.b = vpacke(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc00040 },
		.id = HEX_INS_V6_VPACKEB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vpacke(.h,.h)",
	},
	{
		// 00011111110vvvvvPP0uuuuu011ddddd | Vd.h = vpacke(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc00060 },
		.id = HEX_INS_V6_VPACKEH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vpacke(.w,.w)",
	},
	{
		// 00011111110vvvvvPP0uuuuu110ddddd | Vd.b = vpack(Vu.h,Vv.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc000c0 },
		.id = HEX_INS_V6_VPACKHB_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vpack(.h,.h):sat",
	},
	{
		// 00011111110vvvvvPP0uuuuu101ddddd | Vd.ub = vpack(Vu.h,Vv.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc000a0 },
		.id = HEX_INS_V6_VPACKHUB_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vpack(.h,.h):sat",
	},
	{
		// 00011111111vvvvvPP0uuuuu001ddddd | Vd.b = vpacko(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fe00020 },
		.id = HEX_INS_V6_VPACKOB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vpacko(.h,.h)",
	},
	{
		// 00011111111vvvvvPP0uuuuu010ddddd | Vd.h = vpacko(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fe00040 },
		.id = HEX_INS_V6_VPACKOH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vpacko(.w,.w)",
	},
	{
		// 00011111111vvvvvPP0uuuuu000ddddd | Vd.h = vpack(Vu.w,Vv.w):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1fe00000 },
		.id = HEX_INS_V6_VPACKWH_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vpack(.w,.w):sat",
	},
	{
		// 00011111110vvvvvPP0uuuuu111ddddd | Vd.uh = vpack(Vu.w,Vv.w):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc000e0 },
		.id = HEX_INS_V6_VPACKWUH_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vpack(.w,.w):sat",
	},
	{
		// 0001111000000010PP0uuuuu110ddddd | Vd.h = vpopcount(Vu.h)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e0200c0 },
		.id = HEX_INS_V6_VPOPCOUNTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vpopcount(.h)",
	},
	{
		// 00011110vv000011PP100000010ddddd | Vd.b = prefixsum(Qv)
		.encoding = { .mask = 0xff3f3fe0, .op = 0x1e032040 },
		.id = HEX_INS_V6_VPREFIXQB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = prefixsum()",
	},
	{
		// 00011110vv000011PP100001010ddddd | Vd.h = prefixsum(Qv)
		.encoding = { .mask = 0xff3f3fe0, .op = 0x1e032140 },
		.id = HEX_INS_V6_VPREFIXQH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = prefixsum()",
	},
	{
		// 00011110vv000011PP100010010ddddd | Vd.w = prefixsum(Qv)
		.encoding = { .mask = 0xff3f3fe0, .op = 0x1e032240 },
		.id = HEX_INS_V6_VPREFIXQW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = prefixsum()",
	},
	{
		// 00011111001vvvvvPP0uuuuu011ddddd | Vd = vrdelta(Vu,Vv)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f200060 },
		.id = HEX_INS_V6_VRDELTA,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vrdelta(,)",
	},
	{
		// 00011001110tttttPP0uuuuu101ddddd | Vdd.w = vrmpy(Vu.b,Rtt.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x19c000a0 },
		.id = HEX_INS_V6_VRMPYBUB_RTT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vrmpy(.b,.ub)",
	},
	{
		// 00011001101tttttPP1uuuuu000xxxxx | Vxx.w += vrmpy(Vu.b,Rtt.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x19a02000 },
		.id = HEX_INS_V6_VRMPYBUB_RTT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vrmpy(.b,.ub)",
	},
	{
		// 00011001000tttttPP0uuuuu100ddddd | Vd.w = vrmpy(Vu.ub,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19000080 },
		.id = HEX_INS_V6_VRMPYBUS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vrmpy(.ub,.b)",
	},
	{
		// 00011001000tttttPP1uuuuu101xxxxx | Vx.w += vrmpy(Vu.ub,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x190020a0 },
		.id = HEX_INS_V6_VRMPYBUS_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vrmpy(.ub,.b)",
	},
	{
		// 00011001010tttttPP0uuuuu10iddddd | Vdd.w = vrmpy(Vuu.ub,Rt.b,Ii)
		.encoding = { .mask = 0xffe020c0, .op = 0x19400080 },
		.id = HEX_INS_V6_VRMPYBUSI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 5 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vrmpy(.ub,.b,)",
	},
	{
		// 00011001010tttttPP1uuuuu10ixxxxx | Vxx.w += vrmpy(Vuu.ub,Rt.b,Ii)
		.encoding = { .mask = 0xffe020c0, .op = 0x19402080 },
		.id = HEX_INS_V6_VRMPYBUSI_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 5 } }, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vrmpy(.ub,.b,)",
	},
	{
		// 00011100000vvvvvPP0uuuuu010ddddd | Vd.w = vrmpy(Vu.ub,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c000040 },
		.id = HEX_INS_V6_VRMPYBUSV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vrmpy(.ub,.b)",
	},
	{
		// 00011100000vvvvvPP1uuuuu010xxxxx | Vx.w += vrmpy(Vu.ub,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c002040 },
		.id = HEX_INS_V6_VRMPYBUSV_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vrmpy(.ub,.b)",
	},
	{
		// 00011100000vvvvvPP0uuuuu001ddddd | Vd.w = vrmpy(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c000020 },
		.id = HEX_INS_V6_VRMPYBV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vrmpy(.b,.b)",
	},
	{
		// 00011100000vvvvvPP1uuuuu001xxxxx | Vx.w += vrmpy(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c002020 },
		.id = HEX_INS_V6_VRMPYBV_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vrmpy(.b,.b)",
	},
	{
		// 00011001000tttttPP0uuuuu011ddddd | Vd.uw = vrmpy(Vu.ub,Rt.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x19000060 },
		.id = HEX_INS_V6_VRMPYUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vrmpy(.ub,.ub)",
	},
	{
		// 00011001000tttttPP1uuuuu100xxxxx | Vx.uw += vrmpy(Vu.ub,Rt.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x19002080 },
		.id = HEX_INS_V6_VRMPYUB_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw += vrmpy(.ub,.ub)",
	},
	{
		// 00011001110tttttPP0uuuuu100ddddd | Vdd.uw = vrmpy(Vu.ub,Rtt.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x19c00080 },
		.id = HEX_INS_V6_VRMPYUB_RTT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vrmpy(.ub,.ub)",
	},
	{
		// 00011001101tttttPP1uuuuu111xxxxx | Vxx.uw += vrmpy(Vu.ub,Rtt.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x19a020e0 },
		.id = HEX_INS_V6_VRMPYUB_RTT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw += vrmpy(.ub,.ub)",
	},
	{
		// 00011001101tttttPP0uuuuu11iddddd | Vdd.uw = vrmpy(Vuu.ub,Rt.ub,Ii)
		.encoding = { .mask = 0xffe020c0, .op = 0x19a000c0 },
		.id = HEX_INS_V6_VRMPYUBI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vrmpy(.ub,.ub,)",
	},
	{
		// 00011001011tttttPP1uuuuu11ixxxxx | Vxx.uw += vrmpy(Vuu.ub,Rt.ub,Ii)
		.encoding = { .mask = 0xffe020c0, .op = 0x196020c0 },
		.id = HEX_INS_V6_VRMPYUBI_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 5 } }, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw += vrmpy(.ub,.ub,)",
	},
	{
		// 00011100000vvvvvPP0uuuuu000ddddd | Vd.uw = vrmpy(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c000000 },
		.id = HEX_INS_V6_VRMPYUBV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vrmpy(.ub,.ub)",
	},
	{
		// 00011100000vvvvvPP1uuuuu000xxxxx | Vx.uw += vrmpy(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c002000 },
		.id = HEX_INS_V6_VRMPYUBV_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw += vrmpy(.ub,.ub)",
	},
	{
		// 0001100111101tttPP0uuuuu000ddddd | Vdddd.w = vrmpyz(Vu.b,Rt.b)
		.encoding = { .mask = 0xfff820e0, .op = 0x19e80000 },
		.id = HEX_INS_V6_VRMPYZBB_RT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vrmpyz(.b,.b)",
	},
	{
		// 0001100111000tttPP1uuuuu010yyyyy | Vyyyy.w += vrmpyz(Vu.b,Rt.b)
		.encoding = { .mask = 0xfff820e0, .op = 0x19c02040 },
		.id = HEX_INS_V6_VRMPYZBB_RT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vrmpyz(.b,.b)",
	},
	{
		// 0001100111100xxxPP0uuuuu000ddddd | Vdddd.w = vrmpyz(Vu.b,Rx.b++)
		.encoding = { .mask = 0xfff820e0, .op = 0x19e00000 },
		.id = HEX_INS_V6_VRMPYZBB_RX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vrmpyz(.b,.b++)",
	},
	{
		// 0001100111001xxxPP1uuuuu010yyyyy | Vyyyy.w += vrmpyz(Vu.b,Rx.b++)
		.encoding = { .mask = 0xfff820e0, .op = 0x19c82040 },
		.id = HEX_INS_V6_VRMPYZBB_RX_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vrmpyz(.b,.b++)",
	},
	{
		// 0001100111111tttPP0uuuuu010ddddd | Vdddd.w = vrmpyz(Vu.b,Rt.ub)
		.encoding = { .mask = 0xfff820e0, .op = 0x19f80040 },
		.id = HEX_INS_V6_VRMPYZBUB_RT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vrmpyz(.b,.ub)",
	},
	{
		// 0001100111010tttPP1uuuuu001yyyyy | Vyyyy.w += vrmpyz(Vu.b,Rt.ub)
		.encoding = { .mask = 0xfff820e0, .op = 0x19d02020 },
		.id = HEX_INS_V6_VRMPYZBUB_RT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vrmpyz(.b,.ub)",
	},
	{
		// 0001100111110xxxPP0uuuuu010ddddd | Vdddd.w = vrmpyz(Vu.b,Rx.ub++)
		.encoding = { .mask = 0xfff820e0, .op = 0x19f00040 },
		.id = HEX_INS_V6_VRMPYZBUB_RX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vrmpyz(.b,.ub++)",
	},
	{
		// 0001100111011xxxPP1uuuuu001yyyyy | Vyyyy.w += vrmpyz(Vu.b,Rx.ub++)
		.encoding = { .mask = 0xfff820e0, .op = 0x19d82020 },
		.id = HEX_INS_V6_VRMPYZBUB_RX_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vrmpyz(.b,.ub++)",
	},
	{
		// 0001100111101tttPP0uuuuu001ddddd | Vdddd.w = vr16mpyz(Vu.c,Rt.b)
		.encoding = { .mask = 0xfff820e0, .op = 0x19e80020 },
		.id = HEX_INS_V6_VRMPYZCB_RT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vr16mpyz(.c,.b)",
	},
	{
		// 0001100111000tttPP1uuuuu011yyyyy | Vyyyy.w += vr16mpyz(Vu.c,Rt.b)
		.encoding = { .mask = 0xfff820e0, .op = 0x19c02060 },
		.id = HEX_INS_V6_VRMPYZCB_RT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vr16mpyz(.c,.b)",
	},
	{
		// 0001100111100xxxPP0uuuuu001ddddd | Vdddd.w = vr16mpyz(Vu.c,Rx.b++)
		.encoding = { .mask = 0xfff820e0, .op = 0x19e00020 },
		.id = HEX_INS_V6_VRMPYZCB_RX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vr16mpyz(.c,.b++)",
	},
	{
		// 0001100111001xxxPP1uuuuu011yyyyy | Vyyyy.w += vr16mpyz(Vu.c,Rx.b++)
		.encoding = { .mask = 0xfff820e0, .op = 0x19c82060 },
		.id = HEX_INS_V6_VRMPYZCB_RX_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vr16mpyz(.c,.b++)",
	},
	{
		// 0001100111101tttPP0uuuuu010ddddd | Vdddd.w = vr16mpyzs(Vu.c,Rt.b)
		.encoding = { .mask = 0xfff820e0, .op = 0x19e80040 },
		.id = HEX_INS_V6_VRMPYZCBS_RT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vr16mpyzs(.c,.b)",
	},
	{
		// 0001100111000tttPP1uuuuu001yyyyy | Vyyyy.w += vr16mpyzs(Vu.c,Rt.b)
		.encoding = { .mask = 0xfff820e0, .op = 0x19c02020 },
		.id = HEX_INS_V6_VRMPYZCBS_RT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vr16mpyzs(.c,.b)",
	},
	{
		// 0001100111100xxxPP0uuuuu010ddddd | Vdddd.w = vr16mpyzs(Vu.c,Rx.b++)
		.encoding = { .mask = 0xfff820e0, .op = 0x19e00040 },
		.id = HEX_INS_V6_VRMPYZCBS_RX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vr16mpyzs(.c,.b++)",
	},
	{
		// 0001100111001xxxPP1uuuuu001yyyyy | Vyyyy.w += vr16mpyzs(Vu.c,Rx.b++)
		.encoding = { .mask = 0xfff820e0, .op = 0x19c82020 },
		.id = HEX_INS_V6_VRMPYZCBS_RX_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vr16mpyzs(.c,.b++)",
	},
	{
		// 0001100111111tttPP0uuuuu000ddddd | Vdddd.w = vr8mpyz(Vu.n,Rt.b)
		.encoding = { .mask = 0xfff820e0, .op = 0x19f80000 },
		.id = HEX_INS_V6_VRMPYZNB_RT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vr8mpyz(.n,.b)",
	},
	{
		// 0001100111010tttPP1uuuuu010yyyyy | Vyyyy.w += vr8mpyz(Vu.n,Rt.b)
		.encoding = { .mask = 0xfff820e0, .op = 0x19d02040 },
		.id = HEX_INS_V6_VRMPYZNB_RT_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vr8mpyz(.n,.b)",
	},
	{
		// 0001100111110xxxPP0uuuuu000ddddd | Vdddd.w = vr8mpyz(Vu.n,Rx.b++)
		.encoding = { .mask = 0xfff820e0, .op = 0x19f00000 },
		.id = HEX_INS_V6_VRMPYZNB_RX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vr8mpyz(.n,.b++)",
	},
	{
		// 0001100111011xxxPP1uuuuu010yyyyy | Vyyyy.w += vr8mpyz(Vu.n,Rx.b++)
		.encoding = { .mask = 0xfff820e0, .op = 0x19d82040 },
		.id = HEX_INS_V6_VRMPYZNB_RX_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VQR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += vr8mpyz(.n,.b++)",
	},
	{
		// 00011001011tttttPP0uuuuu001ddddd | Vd = vror(Vu,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x19600020 },
		.id = HEX_INS_V6_VROR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vror(,)",
	},
	{
		// 00011010100vvvvvPP1uuuuu111ddddd | Vd.uw = vrotr(Vu.uw,Vv.uw)
		.encoding = { .mask = 0xffe020e0, .op = 0x1a8020e0 },
		.id = HEX_INS_V6_VROTR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vrotr(.uw,.uw)",
	},
	{
		// 00011111011vvvvvPP0uuuuu110ddddd | Vd.b = vround(Vu.h,Vv.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1f6000c0 },
		.id = HEX_INS_V6_VROUNDHB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vround(.h,.h):sat",
	},
	{
		// 00011111011vvvvvPP0uuuuu111ddddd | Vd.ub = vround(Vu.h,Vv.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1f6000e0 },
		.id = HEX_INS_V6_VROUNDHUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vround(.h,.h):sat",
	},
	{
		// 00011111111vvvvvPP0uuuuu011ddddd | Vd.ub = vround(Vu.uh,Vv.uh):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1fe00060 },
		.id = HEX_INS_V6_VROUNDUHUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vround(.uh,.uh):sat",
	},
	{
		// 00011111111vvvvvPP0uuuuu100ddddd | Vd.uh = vround(Vu.uw,Vv.uw):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1fe00080 },
		.id = HEX_INS_V6_VROUNDUWUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vround(.uw,.uw):sat",
	},
	{
		// 00011111011vvvvvPP0uuuuu100ddddd | Vd.h = vround(Vu.w,Vv.w):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1f600080 },
		.id = HEX_INS_V6_VROUNDWH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vround(.w,.w):sat",
	},
	{
		// 00011111011vvvvvPP0uuuuu101ddddd | Vd.uh = vround(Vu.w,Vv.w):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1f6000a0 },
		.id = HEX_INS_V6_VROUNDWUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vround(.w,.w):sat",
	},
	{
		// 00011001010tttttPP0uuuuu11iddddd | Vdd.uw = vrsad(Vuu.ub,Rt.ub,Ii)
		.encoding = { .mask = 0xffe020c0, .op = 0x194000c0 },
		.id = HEX_INS_V6_VRSADUBI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vrsad(.ub,.ub,)",
	},
	{
		// 00011001010tttttPP1uuuuu11ixxxxx | Vxx.uw += vrsad(Vuu.ub,Rt.ub,Ii)
		.encoding = { .mask = 0xffe020c0, .op = 0x194020c0 },
		.id = HEX_INS_V6_VRSADUBI_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 5 } }, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw += vrsad(.ub,.ub,)",
	},
	{
		// 00011101100vvvvvPP1uuuuu111ddddd | Vd.w = vsatdw(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1d8020e0 },
		.id = HEX_INS_V6_VSATDW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vsatdw(.w,.w)",
	},
	{
		// 00011111011vvvvvPP0uuuuu010ddddd | Vd.ub = vsat(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f600040 },
		.id = HEX_INS_V6_VSATHUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vsat(.h,.h)",
	},
	{
		// 00011111001vvvvvPP0uuuuu110ddddd | Vd.uh = vsat(Vu.uw,Vv.uw)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f2000c0 },
		.id = HEX_INS_V6_VSATUWUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vsat(.uw,.uw)",
	},
	{
		// 00011111011vvvvvPP0uuuuu011ddddd | Vd.h = vsat(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f600060 },
		.id = HEX_INS_V6_VSATWH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vsat(.w,.w)",
	},
	{
		// 0001111000000010PP0uuuuu011ddddd | Vdd.h = vsxt(Vu.b)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e020060 },
		.id = HEX_INS_V6_VSB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vsxt(.b)",
	},
	{
		// 0001111000000010PP0uuuuu100ddddd | Vdd.w = vsxt(Vu.h)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e020080 },
		.id = HEX_INS_V6_VSH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vsxt(.h)",
	},
	{
		// 00011111010vvvvvPP0uuuuu011ddddd | Vd.h = vshuffe(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f400060 },
		.id = HEX_INS_V6_VSHUFEH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vshuffe(.h,.h)",
	},
	{
		// 00011001111tttttPP1yyyyy001xxxxx | vshuff(Vy,Vx,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x19e02020 },
		.id = HEX_INS_V6_VSHUFF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vshuff(,,)",
	},
	{
		// 0001111000000010PP0uuuuu000ddddd | Vd.b = vshuff(Vu.b)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e020000 },
		.id = HEX_INS_V6_VSHUFFB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vshuff(.b)",
	},
	{
		// 00011111010vvvvvPP0uuuuu001ddddd | Vd.b = vshuffe(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f400020 },
		.id = HEX_INS_V6_VSHUFFEB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vshuffe(.b,.b)",
	},
	{
		// 0001111000000001PP0uuuuu111ddddd | Vd.h = vshuff(Vu.h)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e0100e0 },
		.id = HEX_INS_V6_VSHUFFH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vshuff(.h)",
	},
	{
		// 00011111010vvvvvPP0uuuuu010ddddd | Vd.b = vshuffo(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f400040 },
		.id = HEX_INS_V6_VSHUFFOB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vshuffo(.b,.b)",
	},
	{
		// 00011011vvvvvtttPP1uuuuu011ddddd | Vdd = vshuff(Vu,Vv,Rt)
		.encoding = { .mask = 0xff0020e0, .op = 0x1b002060 },
		.id = HEX_INS_V6_VSHUFFVDD,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 19 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS_LOW8, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vshuff(,,)",
	},
	{
		// 00011111010vvvvvPP0uuuuu110ddddd | Vdd.b = vshuffoe(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f4000c0 },
		.id = HEX_INS_V6_VSHUFOEB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vshuffoe(.b,.b)",
	},
	{
		// 00011111010vvvvvPP0uuuuu101ddddd | Vdd.h = vshuffoe(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f4000a0 },
		.id = HEX_INS_V6_VSHUFOEH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vshuffoe(.h,.h)",
	},
	{
		// 00011111010vvvvvPP0uuuuu100ddddd | Vd.h = vshuffo(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f400080 },
		.id = HEX_INS_V6_VSHUFOH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vshuffo(.h,.h)",
	},
	{
		// 00011111011vvvvvPP1uuuuu110ddddd | Vd.qf16 = vsub(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f6020c0 },
		.id = HEX_INS_V6_VSUB_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf16 = vsub(.hf,.hf)",
	},
	{
		// 00011111011vvvvvPP1uuuuu000ddddd | Vd.hf = vsub(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f602000 },
		.id = HEX_INS_V6_VSUB_HF_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".hf = vsub(.hf,.hf)",
	},
	{
		// 00011111011vvvvvPP1uuuuu101ddddd | Vd.qf16 = vsub(Vu.qf16,Vv.qf16)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f6020a0 },
		.id = HEX_INS_V6_VSUB_QF16,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf16 = vsub(.qf16,.qf16)",
	},
	{
		// 00011111011vvvvvPP1uuuuu111ddddd | Vd.qf16 = vsub(Vu.qf16,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f6020e0 },
		.id = HEX_INS_V6_VSUB_QF16_MIX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf16 = vsub(.qf16,.hf)",
	},
	{
		// 00011111101vvvvvPP1uuuuu011ddddd | Vd.qf32 = vsub(Vu.qf32,Vv.qf32)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa02060 },
		.id = HEX_INS_V6_VSUB_QF32,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf32 = vsub(.qf32,.qf32)",
	},
	{
		// 00011111101vvvvvPP1uuuuu101ddddd | Vd.qf32 = vsub(Vu.qf32,Vv.sf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa020a0 },
		.id = HEX_INS_V6_VSUB_QF32_MIX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf32 = vsub(.qf32,.sf)",
	},
	{
		// 00011111101vvvvvPP1uuuuu100ddddd | Vd.qf32 = vsub(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1fa02080 },
		.id = HEX_INS_V6_VSUB_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".qf32 = vsub(.sf,.sf)",
	},
	{
		// 00011101010vvvvvPP1uuuuu101ddddd | Vdd.sf = vsub(Vu.bf,Vv.bf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1d4020a0 },
		.id = HEX_INS_V6_VSUB_SF_BF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vsub(.bf,.bf)",
	},
	{
		// 00011111100vvvvvPP1uuuuu101ddddd | Vdd.sf = vsub(Vu.hf,Vv.hf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f8020a0 },
		.id = HEX_INS_V6_VSUB_SF_HF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vsub(.hf,.hf)",
	},
	{
		// 00011111100vvvvvPP1uuuuu111ddddd | Vd.sf = vsub(Vu.sf,Vv.sf)
		.encoding = { .mask = 0xffe020e0, .op = 0x1f8020e0 },
		.id = HEX_INS_V6_VSUB_SF_SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".sf = vsub(.sf,.sf)",
	},
	{
		// 00011100010vvvvvPP0uuuuu101ddddd | Vd.b = vsub(Vu.b,Vv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c4000a0 },
		.id = HEX_INS_V6_VSUBB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vsub(.b,.b)",
	},
	{
		// 00011100100vvvvvPP0uuuuu011ddddd | Vdd.b = vsub(Vuu.b,Vvv.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c800060 },
		.id = HEX_INS_V6_VSUBB_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vsub(.b,.b)",
	},
	{
		// 00011110vv000010PP1uuuuu001xxxxx | if (!Qv) Vx.b -= Vu.b
		.encoding = { .mask = 0xff3f20e0, .op = 0x1e022020 },
		.id = HEX_INS_V6_VSUBBNQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if (!) .b -= .b",
	},
	{
		// 00011110vv000001PP1uuuuu110xxxxx | if (Qv) Vx.b -= Vu.b
		.encoding = { .mask = 0xff3f20e0, .op = 0x1e0120c0 },
		.id = HEX_INS_V6_VSUBBQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () .b -= .b",
	},
	{
		// 00011111001vvvvvPP0uuuuu010ddddd | Vd.b = vsub(Vu.b,Vv.b):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1f200040 },
		.id = HEX_INS_V6_VSUBBSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vsub(.b,.b):sat",
	},
	{
		// 00011110101vvvvvPP0uuuuu001ddddd | Vdd.b = vsub(Vuu.b,Vvv.b):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1ea00020 },
		.id = HEX_INS_V6_VSUBBSAT_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".b = vsub(.b,.b):sat",
	},
	{
		// 00011100101vvvvvPP1uuuuu1xxddddd | Vd.w = vsub(Vu.w,Vv.w,Qx):carry
		.encoding = { .mask = 0xffe02080, .op = 0x1ca02080 },
		.id = HEX_INS_V6_VSUBCARRY,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vsub(.w,.w,):carry",
	},
	{
		// 00011101101vvvvvPP1uuuuu1eeddddd | Vd.w,Qe = vsub(Vu.w,Vv.w):carry
		.encoding = { .mask = 0xffe02080, .op = 0x1da02080 },
		.id = HEX_INS_V6_VSUBCARRYO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w, = vsub(.w,.w):carry",
	},
	{
		// 00011100010vvvvvPP0uuuuu110ddddd | Vd.h = vsub(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c4000c0 },
		.id = HEX_INS_V6_VSUBH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vsub(.h,.h)",
	},
	{
		// 00011100100vvvvvPP0uuuuu100ddddd | Vdd.h = vsub(Vuu.h,Vvv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c800080 },
		.id = HEX_INS_V6_VSUBH_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vsub(.h,.h)",
	},
	{
		// 00011110vv000010PP1uuuuu010xxxxx | if (!Qv) Vx.h -= Vu.h
		.encoding = { .mask = 0xff3f20e0, .op = 0x1e022040 },
		.id = HEX_INS_V6_VSUBHNQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if (!) .h -= .h",
	},
	{
		// 00011110vv000001PP1uuuuu111xxxxx | if (Qv) Vx.h -= Vu.h
		.encoding = { .mask = 0xff3f20e0, .op = 0x1e0120e0 },
		.id = HEX_INS_V6_VSUBHQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () .h -= .h",
	},
	{
		// 00011100011vvvvvPP0uuuuu010ddddd | Vd.h = vsub(Vu.h,Vv.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c600040 },
		.id = HEX_INS_V6_VSUBHSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vsub(.h,.h):sat",
	},
	{
		// 00011100101vvvvvPP0uuuuu000ddddd | Vdd.h = vsub(Vuu.h,Vvv.h):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1ca00000 },
		.id = HEX_INS_V6_VSUBHSAT_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vsub(.h,.h):sat",
	},
	{
		// 00011100101vvvvvPP0uuuuu111ddddd | Vdd.w = vsub(Vu.h,Vv.h)
		.encoding = { .mask = 0xffe020e0, .op = 0x1ca000e0 },
		.id = HEX_INS_V6_VSUBHW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vsub(.h,.h)",
	},
	{
		// 00011100101vvvvvPP0uuuuu101ddddd | Vdd.h = vsub(Vu.ub,Vv.ub)
		.encoding = { .mask = 0xffe020e0, .op = 0x1ca000a0 },
		.id = HEX_INS_V6_VSUBUBH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vsub(.ub,.ub)",
	},
	{
		// 00011100011vvvvvPP0uuuuu000ddddd | Vd.ub = vsub(Vu.ub,Vv.ub):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c600000 },
		.id = HEX_INS_V6_VSUBUBSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vsub(.ub,.ub):sat",
	},
	{
		// 00011100100vvvvvPP0uuuuu110ddddd | Vdd.ub = vsub(Vuu.ub,Vvv.ub):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c8000c0 },
		.id = HEX_INS_V6_VSUBUBSAT_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vsub(.ub,.ub):sat",
	},
	{
		// 00011110101vvvvvPP0uuuuu101ddddd | Vd.ub = vsub(Vu.ub,Vv.b):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1ea000a0 },
		.id = HEX_INS_V6_VSUBUBUBB_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".ub = vsub(.ub,.b):sat",
	},
	{
		// 00011100011vvvvvPP0uuuuu001ddddd | Vd.uh = vsub(Vu.uh,Vv.uh):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c600020 },
		.id = HEX_INS_V6_VSUBUHSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vsub(.uh,.uh):sat",
	},
	{
		// 00011100100vvvvvPP0uuuuu111ddddd | Vdd.uh = vsub(Vuu.uh,Vvv.uh):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c8000e0 },
		.id = HEX_INS_V6_VSUBUHSAT_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vsub(.uh,.uh):sat",
	},
	{
		// 00011100101vvvvvPP0uuuuu110ddddd | Vdd.w = vsub(Vu.uh,Vv.uh)
		.encoding = { .mask = 0xffe020e0, .op = 0x1ca000c0 },
		.id = HEX_INS_V6_VSUBUHW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vsub(.uh,.uh)",
	},
	{
		// 00011111110vvvvvPP0uuuuu100ddddd | Vd.uw = vsub(Vu.uw,Vv.uw):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1fc00080 },
		.id = HEX_INS_V6_VSUBUWSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vsub(.uw,.uw):sat",
	},
	{
		// 00011110101vvvvvPP0uuuuu011ddddd | Vdd.uw = vsub(Vuu.uw,Vvv.uw):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1ea00060 },
		.id = HEX_INS_V6_VSUBUWSAT_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vsub(.uw,.uw):sat",
	},
	{
		// 00011100010vvvvvPP0uuuuu111ddddd | Vd.w = vsub(Vu.w,Vv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c4000e0 },
		.id = HEX_INS_V6_VSUBW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vsub(.w,.w)",
	},
	{
		// 00011100100vvvvvPP0uuuuu101ddddd | Vdd.w = vsub(Vuu.w,Vvv.w)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c8000a0 },
		.id = HEX_INS_V6_VSUBW_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vsub(.w,.w)",
	},
	{
		// 00011110vv000010PP1uuuuu011xxxxx | if (!Qv) Vx.w -= Vu.w
		.encoding = { .mask = 0xff3f20e0, .op = 0x1e022060 },
		.id = HEX_INS_V6_VSUBWNQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if (!) .w -= .w",
	},
	{
		// 00011110vv000010PP1uuuuu000xxxxx | if (Qv) Vx.w -= Vu.w
		.encoding = { .mask = 0xff3f20e0, .op = 0x1e022000 },
		.id = HEX_INS_V6_VSUBWQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () .w -= .w",
	},
	{
		// 00011100011vvvvvPP0uuuuu011ddddd | Vd.w = vsub(Vu.w,Vv.w):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1c600060 },
		.id = HEX_INS_V6_VSUBWSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vsub(.w,.w):sat",
	},
	{
		// 00011100101vvvvvPP0uuuuu001ddddd | Vdd.w = vsub(Vuu.w,Vvv.w):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x1ca00020 },
		.id = HEX_INS_V6_VSUBWSAT_DV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vsub(.w,.w):sat",
	},
	{
		// 00011110101vvvvvPP1uuuuu0ttddddd | Vdd = vswap(Qt,Vu,Vv)
		.encoding = { .mask = 0xffe02080, .op = 0x1ea02000 },
		.id = HEX_INS_V6_VSWAP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vswap(,,)",
	},
	{
		// 00011001000tttttPP0uuuuu000ddddd | Vdd.h = vtmpy(Vuu.b,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19000000 },
		.id = HEX_INS_V6_VTMPYB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = VTMPy(.b,.b)",
	},
	{
		// 00011001000tttttPP1uuuuu000xxxxx | Vxx.h += vtmpy(Vuu.b,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19002000 },
		.id = HEX_INS_V6_VTMPYB_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h += VTMPy(.b,.b)",
	},
	{
		// 00011001000tttttPP0uuuuu001ddddd | Vdd.h = vtmpy(Vuu.ub,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19000020 },
		.id = HEX_INS_V6_VTMPYBUS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = VTMPy(.ub,.b)",
	},
	{
		// 00011001000tttttPP1uuuuu001xxxxx | Vxx.h += vtmpy(Vuu.ub,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19002020 },
		.id = HEX_INS_V6_VTMPYBUS_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h += VTMPy(.ub,.b)",
	},
	{
		// 00011001101tttttPP0uuuuu100ddddd | Vdd.w = vtmpy(Vuu.h,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19a00080 },
		.id = HEX_INS_V6_VTMPYHB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = VTMPy(.h,.b)",
	},
	{
		// 00011001000tttttPP1uuuuu010xxxxx | Vxx.w += vtmpy(Vuu.h,Rt.b)
		.encoding = { .mask = 0xffe020e0, .op = 0x19002040 },
		.id = HEX_INS_V6_VTMPYHB_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w += VTMPy(.h,.b)",
	},
	{
		// 0001111000000001PP0uuuuu010ddddd | Vdd.h = vunpack(Vu.b)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e010040 },
		.id = HEX_INS_V6_VUNPACKB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = vunpack(.b)",
	},
	{
		// 0001111000000001PP0uuuuu011ddddd | Vdd.w = vunpack(Vu.h)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e010060 },
		.id = HEX_INS_V6_VUNPACKH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w = vunpack(.h)",
	},
	{
		// 0001111000000000PP1uuuuu000xxxxx | Vxx.h |= vunpacko(Vu.b)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e002000 },
		.id = HEX_INS_V6_VUNPACKOB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h |= vunpacko(.b)",
	},
	{
		// 0001111000000000PP1uuuuu001xxxxx | Vxx.w |= vunpacko(Vu.h)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e002020 },
		.id = HEX_INS_V6_VUNPACKOH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".w |= vunpacko(.h)",
	},
	{
		// 0001111000000001PP0uuuuu000ddddd | Vdd.uh = vunpack(Vu.ub)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e010000 },
		.id = HEX_INS_V6_VUNPACKUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vunpack(.ub)",
	},
	{
		// 0001111000000001PP0uuuuu001ddddd | Vdd.uw = vunpack(Vu.uh)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e010020 },
		.id = HEX_INS_V6_VUNPACKUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vunpack(.uh)",
	},
	{
		// 0001111000000000PP10010010000000 | vwhist128
		.encoding = { .mask = 0xffff3fff, .op = 0x1e002480 },
		.id = HEX_INS_V6_VWHIST128,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vwhist128",
	},
	{
		// 0001111000000000PP10011i10000000 | vwhist128(Ii)
		.encoding = { .mask = 0xffff3eff, .op = 0x1e002680 },
		.id = HEX_INS_V6_VWHIST128M,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vwhist128()",
	},
	{
		// 00011110vv000010PP10010010000000 | vwhist128(Qv)
		.encoding = { .mask = 0xff3f3fff, .op = 0x1e022480 },
		.id = HEX_INS_V6_VWHIST128Q,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vwhist128()",
	},
	{
		// 00011110vv000010PP10011i10000000 | vwhist128(Qv,Ii)
		.encoding = { .mask = 0xff3f3eff, .op = 0x1e022680 },
		.id = HEX_INS_V6_VWHIST128QM,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 8 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vwhist128(,)",
	},
	{
		// 0001111000000000PP10001010000000 | vwhist256
		.encoding = { .mask = 0xffff3fff, .op = 0x1e002280 },
		.id = HEX_INS_V6_VWHIST256,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vwhist256",
	},
	{
		// 0001111000000000PP10001110000000 | vwhist256:sat
		.encoding = { .mask = 0xffff3fff, .op = 0x1e002380 },
		.id = HEX_INS_V6_VWHIST256_SAT,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vwhist256:sat",
	},
	{
		// 00011110vv000010PP10001010000000 | vwhist256(Qv)
		.encoding = { .mask = 0xff3f3fff, .op = 0x1e022280 },
		.id = HEX_INS_V6_VWHIST256Q,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vwhist256()",
	},
	{
		// 00011110vv000010PP10001110000000 | vwhist256(Qv):sat
		.encoding = { .mask = 0xff3f3fff, .op = 0x1e022380 },
		.id = HEX_INS_V6_VWHIST256Q_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 22 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vwhist256():sat",
	},
	{
		// 00011100001vvvvvPP0uuuuu111ddddd | Vd = vxor(Vu,Vv)
		.encoding = { .mask = 0xffe020e0, .op = 0x1c2000e0 },
		.id = HEX_INS_V6_VXOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vxor(,)",
	},
	{
		// 0001111000000010PP0uuuuu001ddddd | Vdd.uh = vzxt(Vu.ub)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e020020 },
		.id = HEX_INS_V6_VZB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uh = vzxt(.ub)",
	},
	{
		// 0001111000000010PP0uuuuu010ddddd | Vdd.uw = vzxt(Vu.uh)
		.encoding = { .mask = 0xffff20e0, .op = 0x1e020040 },
		.id = HEX_INS_V6_VZH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".uw = vzxt(.uh)",
	},
	{
		// 00011001101tttttPP000001001ddddd | Vd = zextract(Rt)
		.encoding = { .mask = 0xffe03fe0, .op = 0x19a00120 },
		.id = HEX_INS_V6_ZEXTRACT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zextract()",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_normal_0x2[] = {
	{
		// 0010000001ii0sssPP0tttttiiiiiii0 | if (!cmp.eq(Ns.new,Rt)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x20400000 },
		.id = HEX_INS_J4_CMPEQ_F_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.eq(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000001ii0sssPP1tttttiiiiiii0 | if (!cmp.eq(Ns.new,Rt)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x20402000 },
		.id = HEX_INS_J4_CMPEQ_F_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.eq(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000000ii0sssPP0tttttiiiiiii0 | if (cmp.eq(Ns.new,Rt)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x20000000 },
		.id = HEX_INS_J4_CMPEQ_T_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.eq(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000000ii0sssPP1tttttiiiiiii0 | if (cmp.eq(Ns.new,Rt)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x20002000 },
		.id = HEX_INS_J4_CMPEQ_T_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.eq(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010001ii0sssPP0IIIIIiiiiiii0 | if (!cmp.eq(Ns.new,II)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x24400000 },
		.id = HEX_INS_J4_CMPEQI_F_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.eq(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010001ii0sssPP1IIIIIiiiiiii0 | if (!cmp.eq(Ns.new,II)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x24402000 },
		.id = HEX_INS_J4_CMPEQI_F_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.eq(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010000ii0sssPP0IIIIIiiiiiii0 | if (cmp.eq(Ns.new,II)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x24000000 },
		.id = HEX_INS_J4_CMPEQI_T_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.eq(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010000ii0sssPP1IIIIIiiiiiii0 | if (cmp.eq(Ns.new,II)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x24002000 },
		.id = HEX_INS_J4_CMPEQI_T_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.eq(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010011001ii0sssPP000000iiiiiii0 | if (!cmp.eq(Ns.new,n1)) jump:nt Ii
		.encoding = { .mask = 0xffc83f01, .op = 0x26400000 },
		.id = HEX_INS_J4_CMPEQN1_F_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.eq(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010011001ii0sssPP100000iiiiiii0 | if (!cmp.eq(Ns.new,n1)) jump:t Ii
		.encoding = { .mask = 0xffc83f01, .op = 0x26402000 },
		.id = HEX_INS_J4_CMPEQN1_F_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.eq(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010011000ii0sssPP000000iiiiiii0 | if (cmp.eq(Ns.new,n1)) jump:nt Ii
		.encoding = { .mask = 0xffc83f01, .op = 0x26000000 },
		.id = HEX_INS_J4_CMPEQN1_T_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.eq(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010011000ii0sssPP100000iiiiiii0 | if (cmp.eq(Ns.new,n1)) jump:t Ii
		.encoding = { .mask = 0xffc83f01, .op = 0x26002000 },
		.id = HEX_INS_J4_CMPEQN1_T_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.eq(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000011ii0sssPP0tttttiiiiiii0 | if (!cmp.gt(Ns.new,Rt)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x20c00000 },
		.id = HEX_INS_J4_CMPGT_F_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.gt(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000011ii0sssPP1tttttiiiiiii0 | if (!cmp.gt(Ns.new,Rt)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x20c02000 },
		.id = HEX_INS_J4_CMPGT_F_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.gt(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000010ii0sssPP0tttttiiiiiii0 | if (cmp.gt(Ns.new,Rt)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x20800000 },
		.id = HEX_INS_J4_CMPGT_T_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.gt(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000010ii0sssPP1tttttiiiiiii0 | if (cmp.gt(Ns.new,Rt)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x20802000 },
		.id = HEX_INS_J4_CMPGT_T_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.gt(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010011ii0sssPP0IIIIIiiiiiii0 | if (!cmp.gt(Ns.new,II)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x24c00000 },
		.id = HEX_INS_J4_CMPGTI_F_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.gt(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010011ii0sssPP1IIIIIiiiiiii0 | if (!cmp.gt(Ns.new,II)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x24c02000 },
		.id = HEX_INS_J4_CMPGTI_F_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.gt(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010010ii0sssPP0IIIIIiiiiiii0 | if (cmp.gt(Ns.new,II)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x24800000 },
		.id = HEX_INS_J4_CMPGTI_T_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.gt(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010010ii0sssPP1IIIIIiiiiiii0 | if (cmp.gt(Ns.new,II)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x24802000 },
		.id = HEX_INS_J4_CMPGTI_T_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.gt(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010011011ii0sssPP000000iiiiiii0 | if (!cmp.gt(Ns.new,n1)) jump:nt Ii
		.encoding = { .mask = 0xffc83f01, .op = 0x26c00000 },
		.id = HEX_INS_J4_CMPGTN1_F_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.gt(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010011011ii0sssPP100000iiiiiii0 | if (!cmp.gt(Ns.new,n1)) jump:t Ii
		.encoding = { .mask = 0xffc83f01, .op = 0x26c02000 },
		.id = HEX_INS_J4_CMPGTN1_F_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.gt(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010011010ii0sssPP000000iiiiiii0 | if (cmp.gt(Ns.new,n1)) jump:nt Ii
		.encoding = { .mask = 0xffc83f01, .op = 0x26800000 },
		.id = HEX_INS_J4_CMPGTN1_T_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.gt(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010011010ii0sssPP100000iiiiiii0 | if (cmp.gt(Ns.new,n1)) jump:t Ii
		.encoding = { .mask = 0xffc83f01, .op = 0x26802000 },
		.id = HEX_INS_J4_CMPGTN1_T_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.gt(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000101ii0sssPP0tttttiiiiiii0 | if (!cmp.gtu(Ns.new,Rt)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x21400000 },
		.id = HEX_INS_J4_CMPGTU_F_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 29 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.gtu(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000101ii0sssPP1tttttiiiiiii0 | if (!cmp.gtu(Ns.new,Rt)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x21402000 },
		.id = HEX_INS_J4_CMPGTU_F_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.gtu(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000100ii0sssPP0tttttiiiiiii0 | if (cmp.gtu(Ns.new,Rt)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x21000000 },
		.id = HEX_INS_J4_CMPGTU_T_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.gtu(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000100ii0sssPP1tttttiiiiiii0 | if (cmp.gtu(Ns.new,Rt)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x21002000 },
		.id = HEX_INS_J4_CMPGTU_T_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.gtu(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010101ii0sssPP0IIIIIiiiiiii0 | if (!cmp.gtu(Ns.new,II)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x25400000 },
		.id = HEX_INS_J4_CMPGTUI_F_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 29 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.gtu(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010101ii0sssPP1IIIIIiiiiiii0 | if (!cmp.gtu(Ns.new,II)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x25402000 },
		.id = HEX_INS_J4_CMPGTUI_F_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.gtu(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010100ii0sssPP0IIIIIiiiiiii0 | if (cmp.gtu(Ns.new,II)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x25000000 },
		.id = HEX_INS_J4_CMPGTUI_T_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.gtu(.new,)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010100ii0sssPP1IIIIIiiiiiii0 | if (cmp.gtu(Ns.new,II)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x25002000 },
		.id = HEX_INS_J4_CMPGTUI_T_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.gtu(.new,)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000111ii0sssPP0tttttiiiiiii0 | if (!cmp.gt(Rt,Ns.new)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x21c00000 },
		.id = HEX_INS_J4_CMPLT_F_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.gt(,.new)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000111ii0sssPP1tttttiiiiiii0 | if (!cmp.gt(Rt,Ns.new)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x21c02000 },
		.id = HEX_INS_J4_CMPLT_F_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.gt(,.new)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000110ii0sssPP0tttttiiiiiii0 | if (cmp.gt(Rt,Ns.new)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x21800000 },
		.id = HEX_INS_J4_CMPLT_T_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.gt(,.new)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010000110ii0sssPP1tttttiiiiiii0 | if (cmp.gt(Rt,Ns.new)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x21802000 },
		.id = HEX_INS_J4_CMPLT_T_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.gt(,.new)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010001001ii0sssPP0tttttiiiiiii0 | if (!cmp.gtu(Rt,Ns.new)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x22400000 },
		.id = HEX_INS_J4_CMPLTU_F_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 29 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.gtu(,.new)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010001001ii0sssPP1tttttiiiiiii0 | if (!cmp.gtu(Rt,Ns.new)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x22402000 },
		.id = HEX_INS_J4_CMPLTU_F_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!cmp.gtu(,.new)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010001000ii0sssPP0tttttiiiiiii0 | if (cmp.gtu(Rt,Ns.new)) jump:nt Ii
		.encoding = { .mask = 0xffc82001, .op = 0x22000000 },
		.id = HEX_INS_J4_CMPLTU_T_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.gtu(,.new)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010001000ii0sssPP1tttttiiiiiii0 | if (cmp.gtu(Rt,Ns.new)) jump:t Ii
		.encoding = { .mask = 0xffc82001, .op = 0x22002000 },
		.id = HEX_INS_J4_CMPLTU_T_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (cmp.gtu(,.new)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010111ii0sssPP000000iiiiiii0 | if (!tstbit(Ns.new,#0)) jump:nt Ii
		.encoding = { .mask = 0xffc83f01, .op = 0x25c00000 },
		.id = HEX_INS_J4_TSTBIT0_F_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 30 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!tstbit(.new,#0)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010111ii0sssPP100000iiiiiii0 | if (!tstbit(Ns.new,#0)) jump:t Ii
		.encoding = { .mask = 0xffc83f01, .op = 0x25c02000 },
		.id = HEX_INS_J4_TSTBIT0_F_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 29 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!tstbit(.new,#0)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010110ii0sssPP000000iiiiiii0 | if (tstbit(Ns.new,#0)) jump:nt Ii
		.encoding = { .mask = 0xffc83f01, .op = 0x25800000 },
		.id = HEX_INS_J4_TSTBIT0_T_JUMPNV_NT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 29 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (tstbit(.new,#0)) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0010010110ii0sssPP100000iiiiiii0 | if (tstbit(Ns.new,#0)) jump:t Ii
		.encoding = { .mask = 0xffc83f01, .op = 0x25802000 },
		.id = HEX_INS_J4_TSTBIT0_T_JUMPNV_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x2, 20 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (tstbit(.new,#0)) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 00101000000tttttPPi00iii111ddddd | Vd = vmemu(Rt+Ii)
		.encoding = { .mask = 0xffe018e0, .op = 0x280000e0 },
		.id = HEX_INS_V6_VL32UB_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vmemu(+)",
	},
	{
		// 00101001000xxxxxPP000iii111ddddd | Vd = vmemu(Rx++Ii)
		.encoding = { .mask = 0xffe038e0, .op = 0x290000e0 },
		.id = HEX_INS_V6_VL32UB_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vmemu(++)",
	},
	{
		// 00101011000xxxxxPPu00000111ddddd | Vd = vmemu(Rx++Mu)
		.encoding = { .mask = 0xffe01fe0, .op = 0x2b0000e0 },
		.id = HEX_INS_V6_VL32UB_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vmemu(++)",
	},
	{
		// 00101000000tttttPPi00iii000ddddd | Vd = vmem(Rt+Ii)
		.encoding = { .mask = 0xffe018e0, .op = 0x28000000 },
		.id = HEX_INS_V6_VL32B_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vmem(+)",
	},
	{
		// 00101000000tttttPPi00iii001ddddd | Vd.cur = vmem(Rt+Ii)
		.encoding = { .mask = 0xffe018e0, .op = 0x28000020 },
		.id = HEX_INS_V6_VL32B_CUR_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".cur = vmem(+)",
	},
	{
		// 00101000100tttttPPivviii101ddddd | if (!Pv) Vd.cur = vmem(Rt+Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x288000a0 },
		.id = HEX_INS_V6_VL32B_CUR_NPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 20 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) .cur = vmem(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001100xxxxxPP0vviii101ddddd | if (!Pv) Vd.cur = vmem(Rx++Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x298000a0 },
		.id = HEX_INS_V6_VL32B_CUR_NPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) .cur = vmem(++)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011100xxxxxPPuvv000101ddddd | if (!Pv) Vd.cur = vmem(Rx++Mu)
		.encoding = { .mask = 0xffe007e0, .op = 0x2b8000a0 },
		.id = HEX_INS_V6_VL32B_CUR_NPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) .cur = vmem(++)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001000xxxxxPP000iii001ddddd | Vd.cur = vmem(Rx++Ii)
		.encoding = { .mask = 0xffe038e0, .op = 0x29000020 },
		.id = HEX_INS_V6_VL32B_CUR_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".cur = vmem(++)",
	},
	{
		// 00101011000xxxxxPPu00000001ddddd | Vd.cur = vmem(Rx++Mu)
		.encoding = { .mask = 0xffe01fe0, .op = 0x2b000020 },
		.id = HEX_INS_V6_VL32B_CUR_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".cur = vmem(++)",
	},
	{
		// 00101000100tttttPPivviii100ddddd | if (Pv) Vd.cur = vmem(Rt+Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x28800080 },
		.id = HEX_INS_V6_VL32B_CUR_PRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 19 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () .cur = vmem(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001100xxxxxPP0vviii100ddddd | if (Pv) Vd.cur = vmem(Rx++Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x29800080 },
		.id = HEX_INS_V6_VL32B_CUR_PRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () .cur = vmem(++)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011100xxxxxPPuvv000100ddddd | if (Pv) Vd.cur = vmem(Rx++Mu)
		.encoding = { .mask = 0xffe007e0, .op = 0x2b800080 },
		.id = HEX_INS_V6_VL32B_CUR_PRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () .cur = vmem(++)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101000100tttttPPivviii011ddddd | if (!Pv) Vd = vmem(Rt+Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x28800060 },
		.id = HEX_INS_V6_VL32B_NPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 16 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = vmem(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001100xxxxxPP0vviii011ddddd | if (!Pv) Vd = vmem(Rx++Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x29800060 },
		.id = HEX_INS_V6_VL32B_NPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = vmem(++)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011100xxxxxPPuvv000011ddddd | if (!Pv) Vd = vmem(Rx++Mu)
		.encoding = { .mask = 0xffe007e0, .op = 0x2b800060 },
		.id = HEX_INS_V6_VL32B_NPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = vmem(++)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101000010tttttPPi00iii000ddddd | Vd = vmem(Rt+Ii):nt
		.encoding = { .mask = 0xffe018e0, .op = 0x28400000 },
		.id = HEX_INS_V6_VL32B_NT_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vmem(+):nt",
	},
	{
		// 00101000010tttttPPi00iii001ddddd | Vd.cur = vmem(Rt+Ii):nt
		.encoding = { .mask = 0xffe018e0, .op = 0x28400020 },
		.id = HEX_INS_V6_VL32B_NT_CUR_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".cur = vmem(+):nt",
	},
	{
		// 00101000110tttttPPivviii101ddddd | if (!Pv) Vd.cur = vmem(Rt+Ii):nt
		.encoding = { .mask = 0xffe000e0, .op = 0x28c000a0 },
		.id = HEX_INS_V6_VL32B_NT_CUR_NPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 20 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) .cur = vmem(+):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001110xxxxxPP0vviii101ddddd | if (!Pv) Vd.cur = vmem(Rx++Ii):nt
		.encoding = { .mask = 0xffe020e0, .op = 0x29c000a0 },
		.id = HEX_INS_V6_VL32B_NT_CUR_NPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) .cur = vmem(++):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011110xxxxxPPuvv000101ddddd | if (!Pv) Vd.cur = vmem(Rx++Mu):nt
		.encoding = { .mask = 0xffe007e0, .op = 0x2bc000a0 },
		.id = HEX_INS_V6_VL32B_NT_CUR_NPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) .cur = vmem(++):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001010xxxxxPP000iii001ddddd | Vd.cur = vmem(Rx++Ii):nt
		.encoding = { .mask = 0xffe038e0, .op = 0x29400020 },
		.id = HEX_INS_V6_VL32B_NT_CUR_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".cur = vmem(++):nt",
	},
	{
		// 00101011010xxxxxPPu00000001ddddd | Vd.cur = vmem(Rx++Mu):nt
		.encoding = { .mask = 0xffe01fe0, .op = 0x2b400020 },
		.id = HEX_INS_V6_VL32B_NT_CUR_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".cur = vmem(++):nt",
	},
	{
		// 00101000110tttttPPivviii100ddddd | if (Pv) Vd.cur = vmem(Rt+Ii):nt
		.encoding = { .mask = 0xffe000e0, .op = 0x28c00080 },
		.id = HEX_INS_V6_VL32B_NT_CUR_PRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 19 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () .cur = vmem(+):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001110xxxxxPP0vviii100ddddd | if (Pv) Vd.cur = vmem(Rx++Ii):nt
		.encoding = { .mask = 0xffe020e0, .op = 0x29c00080 },
		.id = HEX_INS_V6_VL32B_NT_CUR_PRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () .cur = vmem(++):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011110xxxxxPPuvv000100ddddd | if (Pv) Vd.cur = vmem(Rx++Mu):nt
		.encoding = { .mask = 0xffe007e0, .op = 0x2bc00080 },
		.id = HEX_INS_V6_VL32B_NT_CUR_PRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () .cur = vmem(++):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101000110tttttPPivviii011ddddd | if (!Pv) Vd = vmem(Rt+Ii):nt
		.encoding = { .mask = 0xffe000e0, .op = 0x28c00060 },
		.id = HEX_INS_V6_VL32B_NT_NPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 16 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = vmem(+):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001110xxxxxPP0vviii011ddddd | if (!Pv) Vd = vmem(Rx++Ii):nt
		.encoding = { .mask = 0xffe020e0, .op = 0x29c00060 },
		.id = HEX_INS_V6_VL32B_NT_NPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = vmem(++):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011110xxxxxPPuvv000011ddddd | if (!Pv) Vd = vmem(Rx++Mu):nt
		.encoding = { .mask = 0xffe007e0, .op = 0x2bc00060 },
		.id = HEX_INS_V6_VL32B_NT_NPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = vmem(++):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001010xxxxxPP000iii000ddddd | Vd = vmem(Rx++Ii):nt
		.encoding = { .mask = 0xffe038e0, .op = 0x29400000 },
		.id = HEX_INS_V6_VL32B_NT_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vmem(++):nt",
	},
	{
		// 00101011010xxxxxPPu00000000ddddd | Vd = vmem(Rx++Mu):nt
		.encoding = { .mask = 0xffe01fe0, .op = 0x2b400000 },
		.id = HEX_INS_V6_VL32B_NT_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vmem(++):nt",
	},
	{
		// 00101000110tttttPPivviii010ddddd | if (Pv) Vd = vmem(Rt+Ii):nt
		.encoding = { .mask = 0xffe000e0, .op = 0x28c00040 },
		.id = HEX_INS_V6_VL32B_NT_PRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 15 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = vmem(+):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001110xxxxxPP0vviii010ddddd | if (Pv) Vd = vmem(Rx++Ii):nt
		.encoding = { .mask = 0xffe020e0, .op = 0x29c00040 },
		.id = HEX_INS_V6_VL32B_NT_PRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = vmem(++):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011110xxxxxPPuvv000010ddddd | if (Pv) Vd = vmem(Rx++Mu):nt
		.encoding = { .mask = 0xffe007e0, .op = 0x2bc00040 },
		.id = HEX_INS_V6_VL32B_NT_PRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = vmem(++):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101000010tttttPPi00iii010ddddd | Vd.tmp = vmem(Rt+Ii):nt
		.encoding = { .mask = 0xffe018e0, .op = 0x28400040 },
		.id = HEX_INS_V6_VL32B_NT_TMP_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".tmp = vmem(+):nt",
	},
	{
		// 00101000110tttttPPivviii111ddddd | if (!Pv) Vd.tmp = vmem(Rt+Ii):nt
		.encoding = { .mask = 0xffe000e0, .op = 0x28c000e0 },
		.id = HEX_INS_V6_VL32B_NT_TMP_NPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 20 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) .tmp = vmem(+):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001110xxxxxPP0vviii111ddddd | if (!Pv) Vd.tmp = vmem(Rx++Ii):nt
		.encoding = { .mask = 0xffe020e0, .op = 0x29c000e0 },
		.id = HEX_INS_V6_VL32B_NT_TMP_NPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) .tmp = vmem(++):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011110xxxxxPPuvv000111ddddd | if (!Pv) Vd.tmp = vmem(Rx++Mu):nt
		.encoding = { .mask = 0xffe007e0, .op = 0x2bc000e0 },
		.id = HEX_INS_V6_VL32B_NT_TMP_NPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) .tmp = vmem(++):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001010xxxxxPP000iii010ddddd | Vd.tmp = vmem(Rx++Ii):nt
		.encoding = { .mask = 0xffe038e0, .op = 0x29400040 },
		.id = HEX_INS_V6_VL32B_NT_TMP_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".tmp = vmem(++):nt",
	},
	{
		// 00101011010xxxxxPPu00000010ddddd | Vd.tmp = vmem(Rx++Mu):nt
		.encoding = { .mask = 0xffe01fe0, .op = 0x2b400040 },
		.id = HEX_INS_V6_VL32B_NT_TMP_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".tmp = vmem(++):nt",
	},
	{
		// 00101000110tttttPPivviii110ddddd | if (Pv) Vd.tmp = vmem(Rt+Ii):nt
		.encoding = { .mask = 0xffe000e0, .op = 0x28c000c0 },
		.id = HEX_INS_V6_VL32B_NT_TMP_PRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 19 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () .tmp = vmem(+):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001110xxxxxPP0vviii110ddddd | if (Pv) Vd.tmp = vmem(Rx++Ii):nt
		.encoding = { .mask = 0xffe020e0, .op = 0x29c000c0 },
		.id = HEX_INS_V6_VL32B_NT_TMP_PRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () .tmp = vmem(++):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011110xxxxxPPuvv000110ddddd | if (Pv) Vd.tmp = vmem(Rx++Mu):nt
		.encoding = { .mask = 0xffe007e0, .op = 0x2bc000c0 },
		.id = HEX_INS_V6_VL32B_NT_TMP_PRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () .tmp = vmem(++):nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001000xxxxxPP000iii000ddddd | Vd = vmem(Rx++Ii)
		.encoding = { .mask = 0xffe038e0, .op = 0x29000000 },
		.id = HEX_INS_V6_VL32B_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vmem(++)",
	},
	{
		// 00101011000xxxxxPPu00000000ddddd | Vd = vmem(Rx++Mu)
		.encoding = { .mask = 0xffe01fe0, .op = 0x2b000000 },
		.id = HEX_INS_V6_VL32B_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vmem(++)",
	},
	{
		// 00101000100tttttPPivviii010ddddd | if (Pv) Vd = vmem(Rt+Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x28800040 },
		.id = HEX_INS_V6_VL32B_PRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 15 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = vmem(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001100xxxxxPP0vviii010ddddd | if (Pv) Vd = vmem(Rx++Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x29800040 },
		.id = HEX_INS_V6_VL32B_PRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = vmem(++)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011100xxxxxPPuvv000010ddddd | if (Pv) Vd = vmem(Rx++Mu)
		.encoding = { .mask = 0xffe007e0, .op = 0x2b800040 },
		.id = HEX_INS_V6_VL32B_PRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = vmem(++)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101000000tttttPPi00iii010ddddd | Vd.tmp = vmem(Rt+Ii)
		.encoding = { .mask = 0xffe018e0, .op = 0x28000040 },
		.id = HEX_INS_V6_VL32B_TMP_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".tmp = vmem(+)",
	},
	{
		// 00101000100tttttPPivviii111ddddd | if (!Pv) Vd.tmp = vmem(Rt+Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x288000e0 },
		.id = HEX_INS_V6_VL32B_TMP_NPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 20 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) .tmp = vmem(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001100xxxxxPP0vviii111ddddd | if (!Pv) Vd.tmp = vmem(Rx++Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x298000e0 },
		.id = HEX_INS_V6_VL32B_TMP_NPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) .tmp = vmem(++)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011100xxxxxPPuvv000111ddddd | if (!Pv) Vd.tmp = vmem(Rx++Mu)
		.encoding = { .mask = 0xffe007e0, .op = 0x2b8000e0 },
		.id = HEX_INS_V6_VL32B_TMP_NPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) .tmp = vmem(++)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001000xxxxxPP000iii010ddddd | Vd.tmp = vmem(Rx++Ii)
		.encoding = { .mask = 0xffe038e0, .op = 0x29000040 },
		.id = HEX_INS_V6_VL32B_TMP_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".tmp = vmem(++)",
	},
	{
		// 00101011000xxxxxPPu00000010ddddd | Vd.tmp = vmem(Rx++Mu)
		.encoding = { .mask = 0xffe01fe0, .op = 0x2b000040 },
		.id = HEX_INS_V6_VL32B_TMP_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".tmp = vmem(++)",
	},
	{
		// 00101000100tttttPPivviii110ddddd | if (Pv) Vd.tmp = vmem(Rt+Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x288000c0 },
		.id = HEX_INS_V6_VL32B_TMP_PRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 19 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () .tmp = vmem(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001100xxxxxPP0vviii110ddddd | if (Pv) Vd.tmp = vmem(Rx++Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x298000c0 },
		.id = HEX_INS_V6_VL32B_TMP_PRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () .tmp = vmem(++)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011100xxxxxPPuvv000110ddddd | if (Pv) Vd.tmp = vmem(Rx++Mu)
		.encoding = { .mask = 0xffe007e0, .op = 0x2b8000c0 },
		.id = HEX_INS_V6_VL32B_TMP_PRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () .tmp = vmem(++)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101000001tttttPPi00iii111sssss | vmemu(Rt+Ii) = Vs
		.encoding = { .mask = 0xffe018e0, .op = 0x282000e0 },
		.id = HEX_INS_V6_VS32UB_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmemu(+) = ",
	},
	{
		// 00101000101tttttPPivviii111sssss | if (!Pv) vmemu(Rt+Ii) = Vs
		.encoding = { .mask = 0xffe000e0, .op = 0x28a000e0 },
		.id = HEX_INS_V6_VS32UB_NPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 18 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmemu(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001101xxxxxPP0vviii111sssss | if (!Pv) vmemu(Rx++Ii) = Vs
		.encoding = { .mask = 0xffe020e0, .op = 0x29a000e0 },
		.id = HEX_INS_V6_VS32UB_NPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmemu(++) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011101xxxxxPPuvv000111sssss | if (!Pv) vmemu(Rx++Mu) = Vs
		.encoding = { .mask = 0xffe007e0, .op = 0x2ba000e0 },
		.id = HEX_INS_V6_VS32UB_NPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmemu(++) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001001xxxxxPP000iii111sssss | vmemu(Rx++Ii) = Vs
		.encoding = { .mask = 0xffe038e0, .op = 0x292000e0 },
		.id = HEX_INS_V6_VS32UB_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmemu(++) = ",
	},
	{
		// 00101011001xxxxxPPu00000111sssss | vmemu(Rx++Mu) = Vs
		.encoding = { .mask = 0xffe01fe0, .op = 0x2b2000e0 },
		.id = HEX_INS_V6_VS32UB_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmemu(++) = ",
	},
	{
		// 00101000101tttttPPivviii110sssss | if (Pv) vmemu(Rt+Ii) = Vs
		.encoding = { .mask = 0xffe000e0, .op = 0x28a000c0 },
		.id = HEX_INS_V6_VS32UB_PRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmemu(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001101xxxxxPP0vviii110sssss | if (Pv) vmemu(Rx++Ii) = Vs
		.encoding = { .mask = 0xffe020e0, .op = 0x29a000c0 },
		.id = HEX_INS_V6_VS32UB_PRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmemu(++) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011101xxxxxPPuvv000110sssss | if (Pv) vmemu(Rx++Mu) = Vs
		.encoding = { .mask = 0xffe007e0, .op = 0x2ba000c0 },
		.id = HEX_INS_V6_VS32UB_PRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmemu(++) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101000001tttttPPi00iii000sssss | vmem(Rt+Ii) = Vs
		.encoding = { .mask = 0xffe018e0, .op = 0x28200000 },
		.id = HEX_INS_V6_VS32B_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(+) = ",
	},
	{
		// 00101000001tttttPPi00iii00100sss | vmem(Rt+Ii) = Os.new
		.encoding = { .mask = 0xffe018f8, .op = 0x28200020 },
		.id = HEX_INS_V6_VS32B_NEW_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(+) = .new",
	},
	{
		// 00101000101tttttPPivviii01101sss | if (!Pv) vmem(Rt+Ii) = Os.new
		.encoding = { .mask = 0xffe000f8, .op = 0x28a00068 },
		.id = HEX_INS_V6_VS32B_NEW_NPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmem(+) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001101xxxxxPP0vviii01101sss | if (!Pv) vmem(Rx++Ii) = Os.new
		.encoding = { .mask = 0xffe020f8, .op = 0x29a00068 },
		.id = HEX_INS_V6_VS32B_NEW_NPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 18 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmem(++) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011101xxxxxPPuvv00001101sss | if (!Pv) vmem(Rx++Mu) = Os.new
		.encoding = { .mask = 0xffe007f8, .op = 0x2ba00068 },
		.id = HEX_INS_V6_VS32B_NEW_NPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 18 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmem(++) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001001xxxxxPP000iii00100sss | vmem(Rx++Ii) = Os.new
		.encoding = { .mask = 0xffe038f8, .op = 0x29200020 },
		.id = HEX_INS_V6_VS32B_NEW_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(++) = .new",
	},
	{
		// 00101011001xxxxxPPu0000000100sss | vmem(Rx++Mu) = Os.new
		.encoding = { .mask = 0xffe01ff8, .op = 0x2b200020 },
		.id = HEX_INS_V6_VS32B_NEW_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(++) = .new",
	},
	{
		// 00101000101tttttPPivviii01000sss | if (Pv) vmem(Rt+Ii) = Os.new
		.encoding = { .mask = 0xffe000f8, .op = 0x28a00040 },
		.id = HEX_INS_V6_VS32B_NEW_PRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmem(+) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001101xxxxxPP0vviii01000sss | if (Pv) vmem(Rx++Ii) = Os.new
		.encoding = { .mask = 0xffe020f8, .op = 0x29a00040 },
		.id = HEX_INS_V6_VS32B_NEW_PRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmem(++) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011101xxxxxPPuvv00001000sss | if (Pv) vmem(Rx++Mu) = Os.new
		.encoding = { .mask = 0xffe007f8, .op = 0x2ba00040 },
		.id = HEX_INS_V6_VS32B_NEW_PRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmem(++) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101000101tttttPPivviii001sssss | if (!Pv) vmem(Rt+Ii) = Vs
		.encoding = { .mask = 0xffe000e0, .op = 0x28a00020 },
		.id = HEX_INS_V6_VS32B_NPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmem(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001101xxxxxPP0vviii001sssss | if (!Pv) vmem(Rx++Ii) = Vs
		.encoding = { .mask = 0xffe020e0, .op = 0x29a00020 },
		.id = HEX_INS_V6_VS32B_NPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 18 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmem(++) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011101xxxxxPPuvv000001sssss | if (!Pv) vmem(Rx++Mu) = Vs
		.encoding = { .mask = 0xffe007e0, .op = 0x2ba00020 },
		.id = HEX_INS_V6_VS32B_NPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 18 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmem(++) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101000100tttttPPivviii001sssss | if (!Qv) vmem(Rt+Ii) = Vs
		.encoding = { .mask = 0xffe000e0, .op = 0x28800020 },
		.id = HEX_INS_V6_VS32B_NQPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if (!) vmem(+) = ",
	},
	{
		// 00101001100xxxxxPP0vviii001sssss | if (!Qv) vmem(Rx++Ii) = Vs
		.encoding = { .mask = 0xffe020e0, .op = 0x29800020 },
		.id = HEX_INS_V6_VS32B_NQPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if (!) vmem(++) = ",
	},
	{
		// 00101011100xxxxxPPuvv000001sssss | if (!Qv) vmem(Rx++Mu) = Vs
		.encoding = { .mask = 0xffe007e0, .op = 0x2b800020 },
		.id = HEX_INS_V6_VS32B_NQPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if (!) vmem(++) = ",
	},
	{
		// 00101000011tttttPPi00iii000sssss | vmem(Rt+Ii):nt = Vs
		.encoding = { .mask = 0xffe018e0, .op = 0x28600000 },
		.id = HEX_INS_V6_VS32B_NT_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(+):nt = ",
	},
	{
		// 00101000011tttttPPi00iii00100sss | vmem(Rt+Ii):nt = Os.new
		.encoding = { .mask = 0xffe018f8, .op = 0x28600020 },
		.id = HEX_INS_V6_VS32B_NT_NEW_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(+):nt = .new",
	},
	{
		// 00101000111tttttPPivviii01111sss | if (!Pv) vmem(Rt+Ii):nt = Os.new
		.encoding = { .mask = 0xffe000f8, .op = 0x28e00078 },
		.id = HEX_INS_V6_VS32B_NT_NEW_NPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 20 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmem(+):nt = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001111xxxxxPP0vviii01111sss | if (!Pv) vmem(Rx++Ii):nt = Os.new
		.encoding = { .mask = 0xffe020f8, .op = 0x29e00078 },
		.id = HEX_INS_V6_VS32B_NT_NEW_NPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmem(++):nt = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011111xxxxxPPuvv00001111sss | if (!Pv) vmem(Rx++Mu):nt = Os.new
		.encoding = { .mask = 0xffe007f8, .op = 0x2be00078 },
		.id = HEX_INS_V6_VS32B_NT_NEW_NPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmem(++):nt = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001011xxxxxPP000iii00100sss | vmem(Rx++Ii):nt = Os.new
		.encoding = { .mask = 0xffe038f8, .op = 0x29600020 },
		.id = HEX_INS_V6_VS32B_NT_NEW_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(++):nt = .new",
	},
	{
		// 00101011011xxxxxPPu0000000100sss | vmem(Rx++Mu):nt = Os.new
		.encoding = { .mask = 0xffe01ff8, .op = 0x2b600020 },
		.id = HEX_INS_V6_VS32B_NT_NEW_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(++):nt = .new",
	},
	{
		// 00101000111tttttPPivviii01010sss | if (Pv) vmem(Rt+Ii):nt = Os.new
		.encoding = { .mask = 0xffe000f8, .op = 0x28e00050 },
		.id = HEX_INS_V6_VS32B_NT_NEW_PRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmem(+):nt = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001111xxxxxPP0vviii01010sss | if (Pv) vmem(Rx++Ii):nt = Os.new
		.encoding = { .mask = 0xffe020f8, .op = 0x29e00050 },
		.id = HEX_INS_V6_VS32B_NT_NEW_PRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmem(++):nt = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011111xxxxxPPuvv00001010sss | if (Pv) vmem(Rx++Mu):nt = Os.new
		.encoding = { .mask = 0xffe007f8, .op = 0x2be00050 },
		.id = HEX_INS_V6_VS32B_NT_NEW_PRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmem(++):nt = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101000111tttttPPivviii001sssss | if (!Pv) vmem(Rt+Ii):nt = Vs
		.encoding = { .mask = 0xffe000e0, .op = 0x28e00020 },
		.id = HEX_INS_V6_VS32B_NT_NPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 20 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmem(+):nt = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001111xxxxxPP0vviii001sssss | if (!Pv) vmem(Rx++Ii):nt = Vs
		.encoding = { .mask = 0xffe020e0, .op = 0x29e00020 },
		.id = HEX_INS_V6_VS32B_NT_NPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmem(++):nt = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011111xxxxxPPuvv000001sssss | if (!Pv) vmem(Rx++Mu):nt = Vs
		.encoding = { .mask = 0xffe007e0, .op = 0x2be00020 },
		.id = HEX_INS_V6_VS32B_NT_NPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_VEC_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) vmem(++):nt = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101000110tttttPPivviii001sssss | if (!Qv) vmem(Rt+Ii):nt = Vs
		.encoding = { .mask = 0xffe000e0, .op = 0x28c00020 },
		.id = HEX_INS_V6_VS32B_NT_NQPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if (!) vmem(+):nt = ",
	},
	{
		// 00101001110xxxxxPP0vviii001sssss | if (!Qv) vmem(Rx++Ii):nt = Vs
		.encoding = { .mask = 0xffe020e0, .op = 0x29c00020 },
		.id = HEX_INS_V6_VS32B_NT_NQPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if (!) vmem(++):nt = ",
	},
	{
		// 00101011110xxxxxPPuvv000001sssss | if (!Qv) vmem(Rx++Mu):nt = Vs
		.encoding = { .mask = 0xffe007e0, .op = 0x2bc00020 },
		.id = HEX_INS_V6_VS32B_NT_NQPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if (!) vmem(++):nt = ",
	},
	{
		// 00101001011xxxxxPP000iii000sssss | vmem(Rx++Ii):nt = Vs
		.encoding = { .mask = 0xffe038e0, .op = 0x29600000 },
		.id = HEX_INS_V6_VS32B_NT_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(++):nt = ",
	},
	{
		// 00101011011xxxxxPPu00000000sssss | vmem(Rx++Mu):nt = Vs
		.encoding = { .mask = 0xffe01fe0, .op = 0x2b600000 },
		.id = HEX_INS_V6_VS32B_NT_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(++):nt = ",
	},
	{
		// 00101000111tttttPPivviii000sssss | if (Pv) vmem(Rt+Ii):nt = Vs
		.encoding = { .mask = 0xffe000e0, .op = 0x28e00000 },
		.id = HEX_INS_V6_VS32B_NT_PRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmem(+):nt = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001111xxxxxPP0vviii000sssss | if (Pv) vmem(Rx++Ii):nt = Vs
		.encoding = { .mask = 0xffe020e0, .op = 0x29e00000 },
		.id = HEX_INS_V6_VS32B_NT_PRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmem(++):nt = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011111xxxxxPPuvv000000sssss | if (Pv) vmem(Rx++Mu):nt = Vs
		.encoding = { .mask = 0xffe007e0, .op = 0x2be00000 },
		.id = HEX_INS_V6_VS32B_NT_PRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmem(++):nt = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101000110tttttPPivviii000sssss | if (Qv) vmem(Rt+Ii):nt = Vs
		.encoding = { .mask = 0xffe000e0, .op = 0x28c00000 },
		.id = HEX_INS_V6_VS32B_NT_QPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () vmem(+):nt = ",
	},
	{
		// 00101001110xxxxxPP0vviii000sssss | if (Qv) vmem(Rx++Ii):nt = Vs
		.encoding = { .mask = 0xffe020e0, .op = 0x29c00000 },
		.id = HEX_INS_V6_VS32B_NT_QPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () vmem(++):nt = ",
	},
	{
		// 00101011110xxxxxPPuvv000000sssss | if (Qv) vmem(Rx++Mu):nt = Vs
		.encoding = { .mask = 0xffe007e0, .op = 0x2bc00000 },
		.id = HEX_INS_V6_VS32B_NT_QPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () vmem(++):nt = ",
	},
	{
		// 00101001001xxxxxPP000iii000sssss | vmem(Rx++Ii) = Vs
		.encoding = { .mask = 0xffe038e0, .op = 0x29200000 },
		.id = HEX_INS_V6_VS32B_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(++) = ",
	},
	{
		// 00101011001xxxxxPPu00000000sssss | vmem(Rx++Mu) = Vs
		.encoding = { .mask = 0xffe01fe0, .op = 0x2b200000 },
		.id = HEX_INS_V6_VS32B_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(++) = ",
	},
	{
		// 00101000101tttttPPivviii000sssss | if (Pv) vmem(Rt+Ii) = Vs
		.encoding = { .mask = 0xffe000e0, .op = 0x28a00000 },
		.id = HEX_INS_V6_VS32B_PRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmem(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101001101xxxxxPP0vviii000sssss | if (Pv) vmem(Rx++Ii) = Vs
		.encoding = { .mask = 0xffe020e0, .op = 0x29a00000 },
		.id = HEX_INS_V6_VS32B_PRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmem(++) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101011101xxxxxPPuvv000000sssss | if (Pv) vmem(Rx++Mu) = Vs
		.encoding = { .mask = 0xffe007e0, .op = 0x2ba00000 },
		.id = HEX_INS_V6_VS32B_PRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () vmem(++) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101000100tttttPPivviii000sssss | if (Qv) vmem(Rt+Ii) = Vs
		.encoding = { .mask = 0xffe000e0, .op = 0x28800000 },
		.id = HEX_INS_V6_VS32B_QPRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () vmem(+) = ",
	},
	{
		// 00101001100xxxxxPP0vviii000sssss | if (Qv) vmem(Rx++Ii) = Vs
		.encoding = { .mask = 0xffe020e0, .op = 0x29800000 },
		.id = HEX_INS_V6_VS32B_QPRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () vmem(++) = ",
	},
	{
		// 00101011100xxxxxPPuvv000000sssss | if (Qv) vmem(Rx++Mu) = Vs
		.encoding = { .mask = 0xffe007e0, .op = 0x2b800000 },
		.id = HEX_INS_V6_VS32B_QPRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () vmem(++) = ",
	},
	{
		// 00101000001tttttPPi00iii00101000 | vmem(Rt+Ii):scatter_release
		.encoding = { .mask = 0xffe018ff, .op = 0x28200028 },
		.id = HEX_INS_V6_VS32B_SRLS_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(+):scatter_release",
	},
	{
		// 00101001001xxxxxPP000iii00101000 | vmem(Rx++Ii):scatter_release
		.encoding = { .mask = 0xffe038ff, .op = 0x29200028 },
		.id = HEX_INS_V6_VS32B_SRLS_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(++):scatter_release",
	},
	{
		// 00101011001xxxxxPPu0000000101000 | vmem(Rx++Mu):scatter_release
		.encoding = { .mask = 0xffe01fff, .op = 0x2b200028 },
		.id = HEX_INS_V6_VS32B_SRLS_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vmem(++):scatter_release",
	},
	{
		// 00101111000tttttPPu00001000vvvvv | vtmp.h = vgather(Rt,Mu,Vv.h).h
		.encoding = { .mask = 0xffe01fe0, .op = 0x2f000100 },
		.id = HEX_INS_V6_VGATHERMH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "VTMP.h = vgather(,,.h).h",
	},
	{
		// 00101111000tttttPPu001010ssvvvvv | if (Qs) vtmp.h = vgather(Rt,Mu,Vv.h).h
		.encoding = { .mask = 0xffe01f80, .op = 0x2f000500 },
		.id = HEX_INS_V6_VGATHERMHQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () VTMP.h = vgather(,,.h).h",
	},
	{
		// 00101111000tttttPPu00010000vvvvv | vtmp.h = vgather(Rt,Mu,Vvv.w).h
		.encoding = { .mask = 0xffe01fe0, .op = 0x2f000200 },
		.id = HEX_INS_V6_VGATHERMHW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "VTMP.h = vgather(,,.w).h",
	},
	{
		// 00101111000tttttPPu001100ssvvvvv | if (Qs) vtmp.h = vgather(Rt,Mu,Vvv.w).h
		.encoding = { .mask = 0xffe01f80, .op = 0x2f000600 },
		.id = HEX_INS_V6_VGATHERMHWQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () VTMP.h = vgather(,,.w).h",
	},
	{
		// 00101111000tttttPPu00000000vvvvv | vtmp.w = vgather(Rt,Mu,Vv.w).w
		.encoding = { .mask = 0xffe01fe0, .op = 0x2f000000 },
		.id = HEX_INS_V6_VGATHERMW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "VTMP.w = vgather(,,.w).w",
	},
	{
		// 00101111000tttttPPu001000ssvvvvv | if (Qs) vtmp.w = vgather(Rt,Mu,Vv.w).w
		.encoding = { .mask = 0xffe01f80, .op = 0x2f000400 },
		.id = HEX_INS_V6_VGATHERMWQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () VTMP.w = vgather(,,.w).w",
	},
	{
		// 00101111001tttttPPuvvvvv001wwwww | vscatter(Rt,Mu,Vv.h).h = Vw
		.encoding = { .mask = 0xffe000e0, .op = 0x2f200020 },
		.id = HEX_INS_V6_VSCATTERMH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vscatter(,,.h).h = ",
	},
	{
		// 00101111001tttttPPuvvvvv101wwwww | vscatter(Rt,Mu,Vv.h).h += Vw
		.encoding = { .mask = 0xffe000e0, .op = 0x2f2000a0 },
		.id = HEX_INS_V6_VSCATTERMH_ADD,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vscatter(,,.h).h += ",
	},
	{
		// 00101111100tttttPPuvvvvv1sswwwww | if (Qs) vscatter(Rt,Mu,Vv.h).h = Vw
		.encoding = { .mask = 0xffe00080, .op = 0x2f800080 },
		.id = HEX_INS_V6_VSCATTERMHQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () vscatter(,,.h).h = ",
	},
	{
		// 00101111001tttttPPuvvvvv010wwwww | vscatter(Rt,Mu,Vvv.w).h = Vw
		.encoding = { .mask = 0xffe000e0, .op = 0x2f200040 },
		.id = HEX_INS_V6_VSCATTERMHW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vscatter(,,.w).h = ",
	},
	{
		// 00101111001tttttPPuvvvvv110wwwww | vscatter(Rt,Mu,Vvv.w).h += Vw
		.encoding = { .mask = 0xffe000e0, .op = 0x2f2000c0 },
		.id = HEX_INS_V6_VSCATTERMHW_ADD,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vscatter(,,.w).h += ",
	},
	{
		// 00101111101tttttPPuvvvvv0sswwwww | if (Qs) vscatter(Rt,Mu,Vvv.w).h = Vw
		.encoding = { .mask = 0xffe00080, .op = 0x2fa00000 },
		.id = HEX_INS_V6_VSCATTERMHWQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_WR, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () vscatter(,,.w).h = ",
	},
	{
		// 00101111001tttttPPuvvvvv000wwwww | vscatter(Rt,Mu,Vv.w).w = Vw
		.encoding = { .mask = 0xffe000e0, .op = 0x2f200000 },
		.id = HEX_INS_V6_VSCATTERMW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vscatter(,,.w).w = ",
	},
	{
		// 00101111001tttttPPuvvvvv100wwwww | vscatter(Rt,Mu,Vv.w).w += Vw
		.encoding = { .mask = 0xffe000e0, .op = 0x2f200080 },
		.id = HEX_INS_V6_VSCATTERMW_ADD,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "vscatter(,,.w).w += ",
	},
	{
		// 00101111100tttttPPuvvvvv0sswwwww | if (Qs) vscatter(Rt,Mu,Vv.w).w = Vw
		.encoding = { .mask = 0xffe00080, .op = 0x2f800000 },
		.id = HEX_INS_V6_VSCATTERMWQ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_HVX_QR, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_HVX_VR, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "if () vscatter(,,.w).w = ",
	},
	{
		// 00101100000tttttPPi00iii00000000 | z = vmem(Rt+Ii)
		.encoding = { .mask = 0xffe018ff, .op = 0x2c000000 },
		.id = HEX_INS_V6_ZLD_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "z = vmem(+)",
	},
	{
		// 00101101000xxxxxPP000iii00000000 | z = vmem(Rx++Ii)
		.encoding = { .mask = 0xffe038ff, .op = 0x2d000000 },
		.id = HEX_INS_V6_ZLD_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "z = vmem(++)",
	},
	{
		// 00101101000xxxxxPPu0000000000001 | z = vmem(Rx++Mu)
		.encoding = { .mask = 0xffe01fff, .op = 0x2d000001 },
		.id = HEX_INS_V6_ZLD_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "z = vmem(++)",
	},
	{
		// 00101100100tttttPPivviii00000000 | if (Pv) z = vmem(Rt+Ii)
		.encoding = { .mask = 0xffe000ff, .op = 0x2c800000 },
		.id = HEX_INS_V6_ZLD_PRED_AI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 }, { 0x1, 13 } }, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () z = vmem(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101101100xxxxxPP0vviii00000000 | if (Pv) z = vmem(Rx++Ii)
		.encoding = { .mask = 0xffe020ff, .op = 0x2d800000 },
		.id = HEX_INS_V6_ZLD_PRED_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () z = vmem(++)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101101100xxxxxPPuvv00000000001 | if (Pv) z = vmem(Rx++Mu)
		.encoding = { .mask = 0xffe007ff, .op = 0x2d800001 },
		.id = HEX_INS_V6_ZLD_PRED_PPU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_VEC_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () z = vmem(++)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_normal_0x3[] = {
	{
		// 00111110000sssssPP0iiiiii00ttttt | memb(Rs+Ii) += Rt
		.encoding = { .mask = 0xffe02060, .op = 0x3e000000 },
		.id = HEX_INS_L4_ADD_MEMOPB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(+) += ",
	},
	{
		// 00111110001sssssPP0iiiiii00ttttt | memh(Rs+Ii) += Rt
		.encoding = { .mask = 0xffe02060, .op = 0x3e200000 },
		.id = HEX_INS_L4_ADD_MEMOPH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 1, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(+) += ",
	},
	{
		// 00111110010sssssPP0iiiiii00ttttt | memw(Rs+Ii) += Rt
		.encoding = { .mask = 0xffe02060, .op = 0x3e400000 },
		.id = HEX_INS_L4_ADD_MEMOPW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 2, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(+) += ",
	},
	{
		// 00111110000sssssPP0iiiiii10ttttt | memb(Rs+Ii) &= Rt
		.encoding = { .mask = 0xffe02060, .op = 0x3e000040 },
		.id = HEX_INS_L4_AND_MEMOPB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(+) &= ",
	},
	{
		// 00111110001sssssPP0iiiiii10ttttt | memh(Rs+Ii) &= Rt
		.encoding = { .mask = 0xffe02060, .op = 0x3e200040 },
		.id = HEX_INS_L4_AND_MEMOPH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 1, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(+) &= ",
	},
	{
		// 00111110010sssssPP0iiiiii10ttttt | memw(Rs+Ii) &= Rt
		.encoding = { .mask = 0xffe02060, .op = 0x3e400040 },
		.id = HEX_INS_L4_AND_MEMOPW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 2, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(+) &= ",
	},
	{
		// 00111111000sssssPP0iiiiii00IIIII | memb(Rs+Ii) += II
		.encoding = { .mask = 0xffe02060, .op = 0x3f000000 },
		.id = HEX_INS_L4_IADD_MEMOPB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 0 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(+) += ",
	},
	{
		// 00111111001sssssPP0iiiiii00IIIII | memh(Rs+Ii) += II
		.encoding = { .mask = 0xffe02060, .op = 0x3f200000 },
		.id = HEX_INS_L4_IADD_MEMOPH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 1, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 0 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(+) += ",
	},
	{
		// 00111111010sssssPP0iiiiii00IIIII | memw(Rs+Ii) += II
		.encoding = { .mask = 0xffe02060, .op = 0x3f400000 },
		.id = HEX_INS_L4_IADD_MEMOPW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 2, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 0 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(+) += ",
	},
	{
		// 00111111000sssssPP0iiiiii10IIIII | memb(Rs+Ii) = clrbit(II)
		.encoding = { .mask = 0xffe02060, .op = 0x3f000040 },
		.id = HEX_INS_L4_IAND_MEMOPB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 0 } }, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(+) = clrbit()",
	},
	{
		// 00111111001sssssPP0iiiiii10IIIII | memh(Rs+Ii) = clrbit(II)
		.encoding = { .mask = 0xffe02060, .op = 0x3f200040 },
		.id = HEX_INS_L4_IAND_MEMOPH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 1, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 0 } }, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(+) = clrbit()",
	},
	{
		// 00111111010sssssPP0iiiiii10IIIII | memw(Rs+Ii) = clrbit(II)
		.encoding = { .mask = 0xffe02060, .op = 0x3f400040 },
		.id = HEX_INS_L4_IAND_MEMOPW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 2, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 0 } }, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(+) = clrbit()",
	},
	{
		// 00111111000sssssPP0iiiiii11IIIII | memb(Rs+Ii) = setbit(II)
		.encoding = { .mask = 0xffe02060, .op = 0x3f000060 },
		.id = HEX_INS_L4_IOR_MEMOPB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 0 } }, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(+) = setbit()",
	},
	{
		// 00111111001sssssPP0iiiiii11IIIII | memh(Rs+Ii) = setbit(II)
		.encoding = { .mask = 0xffe02060, .op = 0x3f200060 },
		.id = HEX_INS_L4_IOR_MEMOPH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 1, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 0 } }, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(+) = setbit()",
	},
	{
		// 00111111010sssssPP0iiiiii11IIIII | memw(Rs+Ii) = setbit(II)
		.encoding = { .mask = 0xffe02060, .op = 0x3f400060 },
		.id = HEX_INS_L4_IOR_MEMOPW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 2, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 0 } }, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(+) = setbit()",
	},
	{
		// 00111111000sssssPP0iiiiii01IIIII | memb(Rs+Ii) -= II
		.encoding = { .mask = 0xffe02060, .op = 0x3f000020 },
		.id = HEX_INS_L4_ISUB_MEMOPB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 0 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(+) -= ",
	},
	{
		// 00111111001sssssPP0iiiiii01IIIII | memh(Rs+Ii) -= II
		.encoding = { .mask = 0xffe02060, .op = 0x3f200020 },
		.id = HEX_INS_L4_ISUB_MEMOPH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 1, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 0 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(+) -= ",
	},
	{
		// 00111111010sssssPP0iiiiii01IIIII | memw(Rs+Ii) -= II
		.encoding = { .mask = 0xffe02060, .op = 0x3f400020 },
		.id = HEX_INS_L4_ISUB_MEMOPW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 2, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 0 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(+) -= ",
	},
	{
		// 00111010000sssssPPittttti00ddddd | Rd = memb(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00060, .op = 0x3a000000 },
		.id = HEX_INS_L4_LOADRB_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb(+<<)",
	},
	{
		// 00111010110sssssPPittttti00ddddd | Rdd = memd(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00060, .op = 0x3ac00000 },
		.id = HEX_INS_L4_LOADRD_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memd(+<<)",
	},
	{
		// 00111010010sssssPPittttti00ddddd | Rd = memh(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00060, .op = 0x3a400000 },
		.id = HEX_INS_L4_LOADRH_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh(+<<)",
	},
	{
		// 00111010100sssssPPittttti00ddddd | Rd = memw(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00060, .op = 0x3a800000 },
		.id = HEX_INS_L4_LOADRI_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(+<<)",
	},
	{
		// 00111010001sssssPPittttti00ddddd | Rd = memub(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00060, .op = 0x3a200000 },
		.id = HEX_INS_L4_LOADRUB_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memub(+<<)",
	},
	{
		// 00111010011sssssPPittttti00ddddd | Rd = memuh(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00060, .op = 0x3a600000 },
		.id = HEX_INS_L4_LOADRUH_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memuh(+<<)",
	},
	{
		// 00111110000sssssPP0iiiiii11ttttt | memb(Rs+Ii) |= Rt
		.encoding = { .mask = 0xffe02060, .op = 0x3e000060 },
		.id = HEX_INS_L4_OR_MEMOPB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(+) |= ",
	},
	{
		// 00111110001sssssPP0iiiiii11ttttt | memh(Rs+Ii) |= Rt
		.encoding = { .mask = 0xffe02060, .op = 0x3e200060 },
		.id = HEX_INS_L4_OR_MEMOPH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 1, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(+) |= ",
	},
	{
		// 00111110010sssssPP0iiiiii11ttttt | memw(Rs+Ii) |= Rt
		.encoding = { .mask = 0xffe02060, .op = 0x3e400060 },
		.id = HEX_INS_L4_OR_MEMOPW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 2, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(+) |= ",
	},
	{
		// 00110001000sssssPPitttttivvddddd | if (!Pv) Rd = memb(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x31000000 },
		.id = HEX_INS_L4_PLOADRBF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 18 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = memb(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110011000sssssPPitttttivvddddd | if (!Pv.new) Rd = memb(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x33000000 },
		.id = HEX_INS_L4_PLOADRBFNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 22 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = memb(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110000000sssssPPitttttivvddddd | if (Pv) Rd = memb(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x30000000 },
		.id = HEX_INS_L4_PLOADRBT_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = memb(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110010000sssssPPitttttivvddddd | if (Pv.new) Rd = memb(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x32000000 },
		.id = HEX_INS_L4_PLOADRBTNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 21 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = memb(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110001110sssssPPitttttivvddddd | if (!Pv) Rdd = memd(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x31c00000 },
		.id = HEX_INS_L4_PLOADRDF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 18 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = memd(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110011110sssssPPitttttivvddddd | if (!Pv.new) Rdd = memd(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x33c00000 },
		.id = HEX_INS_L4_PLOADRDFNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 22 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = memd(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110000110sssssPPitttttivvddddd | if (Pv) Rdd = memd(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x30c00000 },
		.id = HEX_INS_L4_PLOADRDT_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = memd(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110010110sssssPPitttttivvddddd | if (Pv.new) Rdd = memd(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x32c00000 },
		.id = HEX_INS_L4_PLOADRDTNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 21 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = memd(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110001010sssssPPitttttivvddddd | if (!Pv) Rd = memh(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x31400000 },
		.id = HEX_INS_L4_PLOADRHF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 18 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = memh(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110011010sssssPPitttttivvddddd | if (!Pv.new) Rd = memh(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x33400000 },
		.id = HEX_INS_L4_PLOADRHFNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 22 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = memh(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110000010sssssPPitttttivvddddd | if (Pv) Rd = memh(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x30400000 },
		.id = HEX_INS_L4_PLOADRHT_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = memh(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110010010sssssPPitttttivvddddd | if (Pv.new) Rd = memh(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x32400000 },
		.id = HEX_INS_L4_PLOADRHTNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 21 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = memh(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110001100sssssPPitttttivvddddd | if (!Pv) Rd = memw(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x31800000 },
		.id = HEX_INS_L4_PLOADRIF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 18 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = memw(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110011100sssssPPitttttivvddddd | if (!Pv.new) Rd = memw(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x33800000 },
		.id = HEX_INS_L4_PLOADRIFNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 22 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = memw(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110000100sssssPPitttttivvddddd | if (Pv) Rd = memw(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x30800000 },
		.id = HEX_INS_L4_PLOADRIT_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = memw(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110010100sssssPPitttttivvddddd | if (Pv.new) Rd = memw(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x32800000 },
		.id = HEX_INS_L4_PLOADRITNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 21 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = memw(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110001001sssssPPitttttivvddddd | if (!Pv) Rd = memub(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x31200000 },
		.id = HEX_INS_L4_PLOADRUBF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = memub(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110011001sssssPPitttttivvddddd | if (!Pv.new) Rd = memub(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x33200000 },
		.id = HEX_INS_L4_PLOADRUBFNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = memub(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110000001sssssPPitttttivvddddd | if (Pv) Rd = memub(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x30200000 },
		.id = HEX_INS_L4_PLOADRUBT_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = memub(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110010001sssssPPitttttivvddddd | if (Pv.new) Rd = memub(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x32200000 },
		.id = HEX_INS_L4_PLOADRUBTNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = memub(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110001011sssssPPitttttivvddddd | if (!Pv) Rd = memuh(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x31600000 },
		.id = HEX_INS_L4_PLOADRUHF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = memuh(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110011011sssssPPitttttivvddddd | if (!Pv.new) Rd = memuh(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x33600000 },
		.id = HEX_INS_L4_PLOADRUHFNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = memuh(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110000011sssssPPitttttivvddddd | if (Pv) Rd = memuh(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x30600000 },
		.id = HEX_INS_L4_PLOADRUHT_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = memuh(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110010011sssssPPitttttivvddddd | if (Pv.new) Rd = memuh(Rs+Rt<<Ii)
		.encoding = { .mask = 0xffe00000, .op = 0x32600000 },
		.id = HEX_INS_L4_PLOADRUHTNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = memuh(+<<)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111110000sssssPP0iiiiii01ttttt | memb(Rs+Ii) -= Rt
		.encoding = { .mask = 0xffe02060, .op = 0x3e000020 },
		.id = HEX_INS_L4_SUB_MEMOPB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(+) -= ",
	},
	{
		// 00111110001sssssPP0iiiiii01ttttt | memh(Rs+Ii) -= Rt
		.encoding = { .mask = 0xffe02060, .op = 0x3e200020 },
		.id = HEX_INS_L4_SUB_MEMOPH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 1, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(+) -= ",
	},
	{
		// 00111110010sssssPP0iiiiii01ttttt | memw(Rs+Ii) -= Rt
		.encoding = { .mask = 0xffe02060, .op = 0x3e400020 },
		.id = HEX_INS_L4_SUB_MEMOPW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .imm_scale = 2, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(+) -= ",
	},
	{
		// 00110101000sssssPPiuuuuuivvttttt | if (!Pv) memb(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00000, .op = 0x35000000 },
		.id = HEX_INS_S4_PSTORERBF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memb(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110111000sssssPPiuuuuuivvttttt | if (!Pv.new) memb(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00000, .op = 0x37000000 },
		.id = HEX_INS_S4_PSTORERBFNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memb(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110101101sssssPPiuuuuuivv00ttt | if (!Pv) memb(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00018, .op = 0x35a00000 },
		.id = HEX_INS_S4_PSTORERBNEWF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memb(+<<) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110111101sssssPPiuuuuuivv00ttt | if (!Pv.new) memb(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00018, .op = 0x37a00000 },
		.id = HEX_INS_S4_PSTORERBNEWFNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memb(+<<) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110100101sssssPPiuuuuuivv00ttt | if (Pv) memb(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00018, .op = 0x34a00000 },
		.id = HEX_INS_S4_PSTORERBNEWT_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memb(+<<) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110110101sssssPPiuuuuuivv00ttt | if (Pv.new) memb(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00018, .op = 0x36a00000 },
		.id = HEX_INS_S4_PSTORERBNEWTNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memb(+<<) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110100000sssssPPiuuuuuivvttttt | if (Pv) memb(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00000, .op = 0x34000000 },
		.id = HEX_INS_S4_PSTORERBT_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memb(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110110000sssssPPiuuuuuivvttttt | if (Pv.new) memb(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00000, .op = 0x36000000 },
		.id = HEX_INS_S4_PSTORERBTNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memb(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110101110sssssPPiuuuuuivvttttt | if (!Pv) memd(Rs+Ru<<Ii) = Rtt
		.encoding = { .mask = 0xffe00000, .op = 0x35c00000 },
		.id = HEX_INS_S4_PSTORERDF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memd(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110111110sssssPPiuuuuuivvttttt | if (!Pv.new) memd(Rs+Ru<<Ii) = Rtt
		.encoding = { .mask = 0xffe00000, .op = 0x37c00000 },
		.id = HEX_INS_S4_PSTORERDFNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memd(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110100110sssssPPiuuuuuivvttttt | if (Pv) memd(Rs+Ru<<Ii) = Rtt
		.encoding = { .mask = 0xffe00000, .op = 0x34c00000 },
		.id = HEX_INS_S4_PSTORERDT_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memd(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110110110sssssPPiuuuuuivvttttt | if (Pv.new) memd(Rs+Ru<<Ii) = Rtt
		.encoding = { .mask = 0xffe00000, .op = 0x36c00000 },
		.id = HEX_INS_S4_PSTORERDTNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memd(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110101011sssssPPiuuuuuivvttttt | if (!Pv) memh(Rs+Ru<<Ii) = Rt.h
		.encoding = { .mask = 0xffe00000, .op = 0x35600000 },
		.id = HEX_INS_S4_PSTORERFF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memh(+<<) = .h",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110111011sssssPPiuuuuuivvttttt | if (!Pv.new) memh(Rs+Ru<<Ii) = Rt.h
		.encoding = { .mask = 0xffe00000, .op = 0x37600000 },
		.id = HEX_INS_S4_PSTORERFFNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memh(+<<) = .h",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110100011sssssPPiuuuuuivvttttt | if (Pv) memh(Rs+Ru<<Ii) = Rt.h
		.encoding = { .mask = 0xffe00000, .op = 0x34600000 },
		.id = HEX_INS_S4_PSTORERFT_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memh(+<<) = .h",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110110011sssssPPiuuuuuivvttttt | if (Pv.new) memh(Rs+Ru<<Ii) = Rt.h
		.encoding = { .mask = 0xffe00000, .op = 0x36600000 },
		.id = HEX_INS_S4_PSTORERFTNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memh(+<<) = .h",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110101010sssssPPiuuuuuivvttttt | if (!Pv) memh(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00000, .op = 0x35400000 },
		.id = HEX_INS_S4_PSTORERHF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memh(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110111010sssssPPiuuuuuivvttttt | if (!Pv.new) memh(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00000, .op = 0x37400000 },
		.id = HEX_INS_S4_PSTORERHFNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memh(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110101101sssssPPiuuuuuivv01ttt | if (!Pv) memh(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00018, .op = 0x35a00008 },
		.id = HEX_INS_S4_PSTORERHNEWF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memh(+<<) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110111101sssssPPiuuuuuivv01ttt | if (!Pv.new) memh(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00018, .op = 0x37a00008 },
		.id = HEX_INS_S4_PSTORERHNEWFNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memh(+<<) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110100101sssssPPiuuuuuivv01ttt | if (Pv) memh(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00018, .op = 0x34a00008 },
		.id = HEX_INS_S4_PSTORERHNEWT_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memh(+<<) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110110101sssssPPiuuuuuivv01ttt | if (Pv.new) memh(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00018, .op = 0x36a00008 },
		.id = HEX_INS_S4_PSTORERHNEWTNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memh(+<<) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110100010sssssPPiuuuuuivvttttt | if (Pv) memh(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00000, .op = 0x34400000 },
		.id = HEX_INS_S4_PSTORERHT_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memh(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110110010sssssPPiuuuuuivvttttt | if (Pv.new) memh(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00000, .op = 0x36400000 },
		.id = HEX_INS_S4_PSTORERHTNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memh(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110101100sssssPPiuuuuuivvttttt | if (!Pv) memw(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00000, .op = 0x35800000 },
		.id = HEX_INS_S4_PSTORERIF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memw(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110111100sssssPPiuuuuuivvttttt | if (!Pv.new) memw(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00000, .op = 0x37800000 },
		.id = HEX_INS_S4_PSTORERIFNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memw(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110101101sssssPPiuuuuuivv10ttt | if (!Pv) memw(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00018, .op = 0x35a00010 },
		.id = HEX_INS_S4_PSTORERINEWF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memw(+<<) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110111101sssssPPiuuuuuivv10ttt | if (!Pv.new) memw(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00018, .op = 0x37a00010 },
		.id = HEX_INS_S4_PSTORERINEWFNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memw(+<<) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110100101sssssPPiuuuuuivv10ttt | if (Pv) memw(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00018, .op = 0x34a00010 },
		.id = HEX_INS_S4_PSTORERINEWT_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memw(+<<) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110110101sssssPPiuuuuuivv10ttt | if (Pv.new) memw(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00018, .op = 0x36a00010 },
		.id = HEX_INS_S4_PSTORERINEWTNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memw(+<<) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110100100sssssPPiuuuuuivvttttt | if (Pv) memw(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00000, .op = 0x34800000 },
		.id = HEX_INS_S4_PSTORERIT_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memw(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110110100sssssPPiuuuuuivvttttt | if (Pv.new) memw(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00000, .op = 0x36800000 },
		.id = HEX_INS_S4_PSTORERITNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memw(+<<) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111100000sssssPPIiiiiiiIIIIIII | memb(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x3c000000 },
		.id = HEX_INS_S4_STOREIRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 0 }, { 0x1, 13 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(+) = ",
	},
	{
		// 00111000100sssssPPIiiiiiivvIIIII | if (!Pv) memb(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x38800000 },
		.id = HEX_INS_S4_STOREIRBF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 0 }, { 0x1, 13 } }, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001100sssssPPIiiiiiivvIIIII | if (!Pv.new) memb(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x39800000 },
		.id = HEX_INS_S4_STOREIRBFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 0 }, { 0x1, 13 } }, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111000000sssssPPIiiiiiivvIIIII | if (Pv) memb(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x38000000 },
		.id = HEX_INS_S4_STOREIRBT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 0 }, { 0x1, 13 } }, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001000sssssPPIiiiiiivvIIIII | if (Pv.new) memb(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x39000000 },
		.id = HEX_INS_S4_STOREIRBTNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 0 }, { 0x1, 13 } }, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111100001sssssPPIiiiiiiIIIIIII | memh(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x3c200000 },
		.id = HEX_INS_S4_STOREIRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .imm_scale = 1, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 0 }, { 0x1, 13 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(+) = ",
	},
	{
		// 00111000101sssssPPIiiiiiivvIIIII | if (!Pv) memh(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x38a00000 },
		.id = HEX_INS_S4_STOREIRHF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .imm_scale = 1, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 0 }, { 0x1, 13 } }, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memh(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001101sssssPPIiiiiiivvIIIII | if (!Pv.new) memh(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x39a00000 },
		.id = HEX_INS_S4_STOREIRHFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .imm_scale = 1, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 0 }, { 0x1, 13 } }, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memh(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111000001sssssPPIiiiiiivvIIIII | if (Pv) memh(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x38200000 },
		.id = HEX_INS_S4_STOREIRHT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .imm_scale = 1, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 0 }, { 0x1, 13 } }, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memh(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001001sssssPPIiiiiiivvIIIII | if (Pv.new) memh(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x39200000 },
		.id = HEX_INS_S4_STOREIRHTNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .imm_scale = 1, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 0 }, { 0x1, 13 } }, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memh(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111100010sssssPPIiiiiiiIIIIIII | memw(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x3c400000 },
		.id = HEX_INS_S4_STOREIRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .imm_scale = 2, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 0 }, { 0x1, 13 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(+) = ",
	},
	{
		// 00111000110sssssPPIiiiiiivvIIIII | if (!Pv) memw(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x38c00000 },
		.id = HEX_INS_S4_STOREIRIF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .imm_scale = 2, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 0 }, { 0x1, 13 } }, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memw(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001110sssssPPIiiiiiivvIIIII | if (!Pv.new) memw(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x39c00000 },
		.id = HEX_INS_S4_STOREIRIFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .imm_scale = 2, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 0 }, { 0x1, 13 } }, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memw(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111000010sssssPPIiiiiiivvIIIII | if (Pv) memw(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x38400000 },
		.id = HEX_INS_S4_STOREIRIT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .imm_scale = 2, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 0 }, { 0x1, 13 } }, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memw(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001010sssssPPIiiiiiivvIIIII | if (Pv.new) memw(Rs+Ii) = II
		.encoding = { .mask = 0xffe00000, .op = 0x39400000 },
		.id = HEX_INS_S4_STOREIRITNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 7 } }, .imm_scale = 2, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 0 }, { 0x1, 13 } }, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memw(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111011000sssssPPiuuuuui00ttttt | memb(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00060, .op = 0x3b000000 },
		.id = HEX_INS_S4_STORERB_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(+<<) = ",
	},
	{
		// 00111011101sssssPPiuuuuui0000ttt | memb(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00078, .op = 0x3ba00000 },
		.id = HEX_INS_S4_STORERBNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(+<<) = .new",
	},
	{
		// 00111011110sssssPPiuuuuui00ttttt | memd(Rs+Ru<<Ii) = Rtt
		.encoding = { .mask = 0xffe00060, .op = 0x3bc00000 },
		.id = HEX_INS_S4_STORERD_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memd(+<<) = ",
	},
	{
		// 00111011011sssssPPiuuuuui00ttttt | memh(Rs+Ru<<Ii) = Rt.h
		.encoding = { .mask = 0xffe00060, .op = 0x3b600000 },
		.id = HEX_INS_S4_STORERF_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(+<<) = .h",
	},
	{
		// 00111011010sssssPPiuuuuui00ttttt | memh(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00060, .op = 0x3b400000 },
		.id = HEX_INS_S4_STORERH_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(+<<) = ",
	},
	{
		// 00111011101sssssPPiuuuuui0001ttt | memh(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00078, .op = 0x3ba00008 },
		.id = HEX_INS_S4_STORERHNEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(+<<) = .new",
	},
	{
		// 00111011100sssssPPiuuuuui00ttttt | memw(Rs+Ru<<Ii) = Rt
		.encoding = { .mask = 0xffe00060, .op = 0x3b800000 },
		.id = HEX_INS_S4_STORERI_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(+<<) = ",
	},
	{
		// 00111011101sssssPPiuuuuui0010ttt | memw(Rs+Ru<<Ii) = Nt.new
		.encoding = { .mask = 0xffe00078, .op = 0x3ba00010 },
		.id = HEX_INS_S4_STORERINEW_RR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x1, 7 }, { 0x1, 13 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(+<<) = .new",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_normal_0x4[] = {
	{
		// 01001ii1000iiiiiPPiiiiiiiiiddddd | Rd = memb(gp+Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x49000000 },
		.id = HEX_INS_L2_LOADRBGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x5, 16 }, { 0x2, 25 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb(GP+)",
	},
	{
		// 01001ii1110iiiiiPPiiiiiiiiiddddd | Rdd = memd(gp+Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x49c00000 },
		.id = HEX_INS_L2_LOADRDGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 3, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memd(GP+)",
	},
	{
		// 01001ii1010iiiiiPPiiiiiiiiiddddd | Rd = memh(gp+Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x49400000 },
		.id = HEX_INS_L2_LOADRHGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 1, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh(GP+)",
	},
	{
		// 01001ii1100iiiiiPPiiiiiiiiiddddd | Rd = memw(gp+Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x49800000 },
		.id = HEX_INS_L2_LOADRIGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(GP+)",
	},
	{
		// 01001ii1001iiiiiPPiiiiiiiiiddddd | Rd = memub(gp+Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x49200000 },
		.id = HEX_INS_L2_LOADRUBGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x5, 16 }, { 0x2, 25 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memub(GP+)",
	},
	{
		// 01001ii1011iiiiiPPiiiiiiiiiddddd | Rd = memuh(gp+Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x49600000 },
		.id = HEX_INS_L2_LOADRUHGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 1, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memuh(GP+)",
	},
	{
		// 01000101000sssssPP0ttiiiiiiddddd | if (!Pt) Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x45000000 },
		.id = HEX_INS_L2_PLOADRBF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .syntax = 16 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = memb(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000111000sssssPP0ttiiiiiiddddd | if (!Pt.new) Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x47000000 },
		.id = HEX_INS_L2_PLOADRBFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .syntax = 20 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = memb(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000001000sssssPP0ttiiiiiiddddd | if (Pt) Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x41000000 },
		.id = HEX_INS_L2_PLOADRBT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .syntax = 15 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = memb(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000011000sssssPP0ttiiiiiiddddd | if (Pt.new) Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x43000000 },
		.id = HEX_INS_L2_PLOADRBTNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .syntax = 19 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = memb(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000101110sssssPP0ttiiiiiiddddd | if (!Pt) Rdd = memd(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x45c00000 },
		.id = HEX_INS_L2_PLOADRDF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 3, .syntax = 16 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = memd(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000111110sssssPP0ttiiiiiiddddd | if (!Pt.new) Rdd = memd(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x47c00000 },
		.id = HEX_INS_L2_PLOADRDFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 3, .syntax = 20 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = memd(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000001110sssssPP0ttiiiiiiddddd | if (Pt) Rdd = memd(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x41c00000 },
		.id = HEX_INS_L2_PLOADRDT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 3, .syntax = 15 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = memd(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000011110sssssPP0ttiiiiiiddddd | if (Pt.new) Rdd = memd(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x43c00000 },
		.id = HEX_INS_L2_PLOADRDTNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 3, .syntax = 19 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = memd(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000101010sssssPP0ttiiiiiiddddd | if (!Pt) Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x45400000 },
		.id = HEX_INS_L2_PLOADRHF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 1, .syntax = 16 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = memh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000111010sssssPP0ttiiiiiiddddd | if (!Pt.new) Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x47400000 },
		.id = HEX_INS_L2_PLOADRHFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 1, .syntax = 20 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = memh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000001010sssssPP0ttiiiiiiddddd | if (Pt) Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x41400000 },
		.id = HEX_INS_L2_PLOADRHT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 1, .syntax = 15 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = memh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000011010sssssPP0ttiiiiiiddddd | if (Pt.new) Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x43400000 },
		.id = HEX_INS_L2_PLOADRHTNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 1, .syntax = 19 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = memh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000101100sssssPP0ttiiiiiiddddd | if (!Pt) Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x45800000 },
		.id = HEX_INS_L2_PLOADRIF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 2, .syntax = 16 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = memw(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000111100sssssPP0ttiiiiiiddddd | if (!Pt.new) Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x47800000 },
		.id = HEX_INS_L2_PLOADRIFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 2, .syntax = 20 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = memw(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000001100sssssPP0ttiiiiiiddddd | if (Pt) Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x41800000 },
		.id = HEX_INS_L2_PLOADRIT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 2, .syntax = 15 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = memw(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000011100sssssPP0ttiiiiiiddddd | if (Pt.new) Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x43800000 },
		.id = HEX_INS_L2_PLOADRITNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 2, .syntax = 19 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = memw(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000101001sssssPP0ttiiiiiiddddd | if (!Pt) Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x45200000 },
		.id = HEX_INS_L2_PLOADRUBF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = memub(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000111001sssssPP0ttiiiiiiddddd | if (!Pt.new) Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x47200000 },
		.id = HEX_INS_L2_PLOADRUBFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = memub(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000001001sssssPP0ttiiiiiiddddd | if (Pt) Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x41200000 },
		.id = HEX_INS_L2_PLOADRUBT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = memub(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000011001sssssPP0ttiiiiiiddddd | if (Pt.new) Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x43200000 },
		.id = HEX_INS_L2_PLOADRUBTNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = memub(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000101011sssssPP0ttiiiiiiddddd | if (!Pt) Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x45600000 },
		.id = HEX_INS_L2_PLOADRUHF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 1, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = memuh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000111011sssssPP0ttiiiiiiddddd | if (!Pt.new) Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x47600000 },
		.id = HEX_INS_L2_PLOADRUHFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 1, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = memuh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000001011sssssPP0ttiiiiiiddddd | if (Pt) Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x41600000 },
		.id = HEX_INS_L2_PLOADRUHT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 1, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = memuh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000011011sssssPP0ttiiiiiiddddd | if (Pt.new) Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x43600000 },
		.id = HEX_INS_L2_PLOADRUHTNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 11 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 5 } }, .imm_scale = 1, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = memuh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01001ii1000iiiiiPPiiiiiiiiiddddd | Rd = memb(Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x49000000 },
		.id = HEX_INS_PS_LOADRBABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x5, 16 }, { 0x2, 25 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb()",
	},
	{
		// 01001ii1110iiiiiPPiiiiiiiiiddddd | Rdd = memd(Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x49c00000 },
		.id = HEX_INS_PS_LOADRDABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 3, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memd()",
	},
	{
		// 01001ii1010iiiiiPPiiiiiiiiiddddd | Rd = memh(Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x49400000 },
		.id = HEX_INS_PS_LOADRHABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 1, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh()",
	},
	{
		// 01001ii1100iiiiiPPiiiiiiiiiddddd | Rd = memw(Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x49800000 },
		.id = HEX_INS_PS_LOADRIABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 2, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw()",
	},
	{
		// 01001ii1001iiiiiPPiiiiiiiiiddddd | Rd = memub(Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x49200000 },
		.id = HEX_INS_PS_LOADRUBABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x5, 16 }, { 0x2, 25 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memub()",
	},
	{
		// 01001ii1011iiiiiPPiiiiiiiiiddddd | Rd = memuh(Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x49600000 },
		.id = HEX_INS_PS_LOADRUHABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 1, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memuh()",
	},
	{
		// 01001ii0000iiiiiPPitttttiiiiiiii | memb(Ii) = Rt
		.encoding = { .mask = 0xf9e00000, .op = 0x48000000 },
		.id = HEX_INS_PS_STORERBABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb() = ",
	},
	{
		// 01001ii0101iiiiiPPi00tttiiiiiiii | memb(Ii) = Nt.new
		.encoding = { .mask = 0xf9e01800, .op = 0x48a00000 },
		.id = HEX_INS_PS_STORERBNEWABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb() = .new",
	},
	{
		// 01001ii0110iiiiiPPitttttiiiiiiii | memd(Ii) = Rtt
		.encoding = { .mask = 0xf9e00000, .op = 0x48c00000 },
		.id = HEX_INS_PS_STORERDABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 3, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memd() = ",
	},
	{
		// 01001ii0011iiiiiPPitttttiiiiiiii | memh(Ii) = Rt.h
		.encoding = { .mask = 0xf9e00000, .op = 0x48600000 },
		.id = HEX_INS_PS_STORERFABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 1, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh() = .h",
	},
	{
		// 01001ii0010iiiiiPPitttttiiiiiiii | memh(Ii) = Rt
		.encoding = { .mask = 0xf9e00000, .op = 0x48400000 },
		.id = HEX_INS_PS_STORERHABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 1, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh() = ",
	},
	{
		// 01001ii0101iiiiiPPi01tttiiiiiiii | memh(Ii) = Nt.new
		.encoding = { .mask = 0xf9e01800, .op = 0x48a00800 },
		.id = HEX_INS_PS_STORERHNEWABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 1, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh() = .new",
	},
	{
		// 01001ii0100iiiiiPPitttttiiiiiiii | memw(Ii) = Rt
		.encoding = { .mask = 0xf9e00000, .op = 0x48800000 },
		.id = HEX_INS_PS_STORERIABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 2, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw() = ",
	},
	{
		// 01001ii0101iiiiiPPi10tttiiiiiiii | memw(Ii) = Nt.new
		.encoding = { .mask = 0xf9e01800, .op = 0x48a01000 },
		.id = HEX_INS_PS_STORERINEWABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 2, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw() = .new",
	},
	{
		// 01000100000sssssPPitttttiiiii0vv | if (!Pv) memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xffe00004, .op = 0x44000000 },
		.id = HEX_INS_S2_PSTORERBF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000100101sssssPPi00tttiiiii0vv | if (!Pv) memb(Rs+Ii) = Nt.new
		.encoding = { .mask = 0xffe01804, .op = 0x44a00000 },
		.id = HEX_INS_S2_PSTORERBNEWF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memb(+) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000000101sssssPPi00tttiiiii0vv | if (Pv) memb(Rs+Ii) = Nt.new
		.encoding = { .mask = 0xffe01804, .op = 0x40a00000 },
		.id = HEX_INS_S2_PSTORERBNEWT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memb(+) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000000000sssssPPitttttiiiii0vv | if (Pv) memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xffe00004, .op = 0x40000000 },
		.id = HEX_INS_S2_PSTORERBT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000100110sssssPPitttttiiiii0vv | if (!Pv) memd(Rs+Ii) = Rtt
		.encoding = { .mask = 0xffe00004, .op = 0x44c00000 },
		.id = HEX_INS_S2_PSTORERDF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 3, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memd(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000000110sssssPPitttttiiiii0vv | if (Pv) memd(Rs+Ii) = Rtt
		.encoding = { .mask = 0xffe00004, .op = 0x40c00000 },
		.id = HEX_INS_S2_PSTORERDT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 3, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memd(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000100011sssssPPitttttiiiii0vv | if (!Pv) memh(Rs+Ii) = Rt.h
		.encoding = { .mask = 0xffe00004, .op = 0x44600000 },
		.id = HEX_INS_S2_PSTORERFF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 1, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memh(+) = .h",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000000011sssssPPitttttiiiii0vv | if (Pv) memh(Rs+Ii) = Rt.h
		.encoding = { .mask = 0xffe00004, .op = 0x40600000 },
		.id = HEX_INS_S2_PSTORERFT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 1, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memh(+) = .h",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000100010sssssPPitttttiiiii0vv | if (!Pv) memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xffe00004, .op = 0x44400000 },
		.id = HEX_INS_S2_PSTORERHF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 1, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memh(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000100101sssssPPi01tttiiiii0vv | if (!Pv) memh(Rs+Ii) = Nt.new
		.encoding = { .mask = 0xffe01804, .op = 0x44a00800 },
		.id = HEX_INS_S2_PSTORERHNEWF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 1, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memh(+) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000000101sssssPPi01tttiiiii0vv | if (Pv) memh(Rs+Ii) = Nt.new
		.encoding = { .mask = 0xffe01804, .op = 0x40a00800 },
		.id = HEX_INS_S2_PSTORERHNEWT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 1, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memh(+) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000000010sssssPPitttttiiiii0vv | if (Pv) memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xffe00004, .op = 0x40400000 },
		.id = HEX_INS_S2_PSTORERHT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 1, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memh(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000100100sssssPPitttttiiiii0vv | if (!Pv) memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xffe00004, .op = 0x44800000 },
		.id = HEX_INS_S2_PSTORERIF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 2, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memw(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000100101sssssPPi10tttiiiii0vv | if (!Pv) memw(Rs+Ii) = Nt.new
		.encoding = { .mask = 0xffe01804, .op = 0x44a01000 },
		.id = HEX_INS_S2_PSTORERINEWF_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 2, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!) memw(+) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000000101sssssPPi10tttiiiii0vv | if (Pv) memw(Rs+Ii) = Nt.new
		.encoding = { .mask = 0xffe01804, .op = 0x40a01000 },
		.id = HEX_INS_S2_PSTORERINEWT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 2, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memw(+) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000000100sssssPPitttttiiiii0vv | if (Pv) memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xffe00004, .op = 0x40800000 },
		.id = HEX_INS_S2_PSTORERIT_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 2, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if () memw(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01001ii0000iiiiiPPitttttiiiiiiii | memb(gp+Ii) = Rt
		.encoding = { .mask = 0xf9e00000, .op = 0x48000000 },
		.id = HEX_INS_S2_STORERBGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(GP+) = ",
	},
	{
		// 01001ii0101iiiiiPPi00tttiiiiiiii | memb(gp+Ii) = Nt.new
		.encoding = { .mask = 0xf9e01800, .op = 0x48a00000 },
		.id = HEX_INS_S2_STORERBNEWGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memb(GP+) = .new",
	},
	{
		// 01001ii0110iiiiiPPitttttiiiiiiii | memd(gp+Ii) = Rtt
		.encoding = { .mask = 0xf9e00000, .op = 0x48c00000 },
		.id = HEX_INS_S2_STORERDGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 3, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memd(GP+) = ",
	},
	{
		// 01001ii0011iiiiiPPitttttiiiiiiii | memh(gp+Ii) = Rt.h
		.encoding = { .mask = 0xf9e00000, .op = 0x48600000 },
		.id = HEX_INS_S2_STORERFGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 1, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(GP+) = .h",
	},
	{
		// 01001ii0010iiiiiPPitttttiiiiiiii | memh(gp+Ii) = Rt
		.encoding = { .mask = 0xf9e00000, .op = 0x48400000 },
		.id = HEX_INS_S2_STORERHGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 1, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(GP+) = ",
	},
	{
		// 01001ii0101iiiiiPPi01tttiiiiiiii | memh(gp+Ii) = Nt.new
		.encoding = { .mask = 0xf9e01800, .op = 0x48a00800 },
		.id = HEX_INS_S2_STORERHNEWGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 1, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memh(GP+) = .new",
	},
	{
		// 01001ii0100iiiiiPPitttttiiiiiiii | memw(gp+Ii) = Rt
		.encoding = { .mask = 0xf9e00000, .op = 0x48800000 },
		.id = HEX_INS_S2_STORERIGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 2, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(GP+) = ",
	},
	{
		// 01001ii0101iiiiiPPi10tttiiiiiiii | memw(gp+Ii) = Nt.new
		.encoding = { .mask = 0xf9e01800, .op = 0x48a01000 },
		.id = HEX_INS_S2_STORERINEWGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 0 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 25 } }, .imm_scale = 2, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "memw(GP+) = .new",
	},
	{
		// 01000110000sssssPPitttttiiiii0vv | if (!Pv.new) memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xffe00004, .op = 0x46000000 },
		.id = HEX_INS_S4_PSTORERBFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000110101sssssPPi00tttiiiii0vv | if (!Pv.new) memb(Rs+Ii) = Nt.new
		.encoding = { .mask = 0xffe01804, .op = 0x46a00000 },
		.id = HEX_INS_S4_PSTORERBNEWFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memb(+) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000010101sssssPPi00tttiiiii0vv | if (Pv.new) memb(Rs+Ii) = Nt.new
		.encoding = { .mask = 0xffe01804, .op = 0x42a00000 },
		.id = HEX_INS_S4_PSTORERBNEWTNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memb(+) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000010000sssssPPitttttiiiii0vv | if (Pv.new) memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xffe00004, .op = 0x42000000 },
		.id = HEX_INS_S4_PSTORERBTNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000110110sssssPPitttttiiiii0vv | if (!Pv.new) memd(Rs+Ii) = Rtt
		.encoding = { .mask = 0xffe00004, .op = 0x46c00000 },
		.id = HEX_INS_S4_PSTORERDFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 3, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memd(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000010110sssssPPitttttiiiii0vv | if (Pv.new) memd(Rs+Ii) = Rtt
		.encoding = { .mask = 0xffe00004, .op = 0x42c00000 },
		.id = HEX_INS_S4_PSTORERDTNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 3, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memd(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000110011sssssPPitttttiiiii0vv | if (!Pv.new) memh(Rs+Ii) = Rt.h
		.encoding = { .mask = 0xffe00004, .op = 0x46600000 },
		.id = HEX_INS_S4_PSTORERFFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 1, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memh(+) = .h",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000010011sssssPPitttttiiiii0vv | if (Pv.new) memh(Rs+Ii) = Rt.h
		.encoding = { .mask = 0xffe00004, .op = 0x42600000 },
		.id = HEX_INS_S4_PSTORERFTNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 1, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memh(+) = .h",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000110010sssssPPitttttiiiii0vv | if (!Pv.new) memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xffe00004, .op = 0x46400000 },
		.id = HEX_INS_S4_PSTORERHFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 1, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memh(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000110101sssssPPi01tttiiiii0vv | if (!Pv.new) memh(Rs+Ii) = Nt.new
		.encoding = { .mask = 0xffe01804, .op = 0x46a00800 },
		.id = HEX_INS_S4_PSTORERHNEWFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 1, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memh(+) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000010101sssssPPi01tttiiiii0vv | if (Pv.new) memh(Rs+Ii) = Nt.new
		.encoding = { .mask = 0xffe01804, .op = 0x42a00800 },
		.id = HEX_INS_S4_PSTORERHNEWTNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 1, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memh(+) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000010010sssssPPitttttiiiii0vv | if (Pv.new) memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xffe00004, .op = 0x42400000 },
		.id = HEX_INS_S4_PSTORERHTNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 1, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memh(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000110100sssssPPitttttiiiii0vv | if (!Pv.new) memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xffe00004, .op = 0x46800000 },
		.id = HEX_INS_S4_PSTORERIFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 2, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memw(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000110101sssssPPi10tttiiiii0vv | if (!Pv.new) memw(Rs+Ii) = Nt.new
		.encoding = { .mask = 0xffe01804, .op = 0x46a01000 },
		.id = HEX_INS_S4_PSTORERINEWFNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 2, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new) memw(+) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000010101sssssPPi10tttiiiii0vv | if (Pv.new) memw(Rs+Ii) = Nt.new
		.encoding = { .mask = 0xffe01804, .op = 0x42a01000 },
		.id = HEX_INS_S4_PSTORERINEWTNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 2, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_N_REG, .masks = { { 0x3, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memw(+) = .new",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000010100sssssPPitttttiiiii0vv | if (Pv.new) memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xffe00004, .op = 0x42800000 },
		.id = HEX_INS_S4_PSTORERITNEW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x5, 3 }, { 0x1, 13 } }, .imm_scale = 2, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new) memw(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_normal_0x5[] = {
	{
		// 0101101iiiiiiiiiPPiiiiiiiiiiiii0 | call Ii
		.encoding = { .mask = 0xfe000001, .op = 0x5a000000 },
		.id = HEX_INS_J2_CALL,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0xd, 1 }, { 0x9, 16 } }, .imm_scale = 2, .syntax = 5 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_CALL,
		.syntax = "call ",
		.flags = HEX_INSN_TEMPLATE_FLAG_CALL | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01011101ii1iiiiiPPi000uuiiiiiii0 | if (!Pu) call Ii
		.encoding = { .mask = 0xff201c01, .op = 0x5d200000 },
		.id = HEX_INS_J2_CALLF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 22 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CCALL,
		.syntax = "if (!) call ",
		.flags = HEX_INSN_TEMPLATE_FLAG_CALL | HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010000101sssssPP00000000000000 | callr Rs
		.encoding = { .mask = 0xffe03fff, .op = 0x50a00000 },
		.id = HEX_INS_J2_CALLR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RCALL,
		.syntax = "callr ",
		.flags = HEX_INSN_TEMPLATE_FLAG_CALL | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010001001sssssPP0000uu00000000 | if (!Pu) callr Rs
		.encoding = { .mask = 0xffe03cff, .op = 0x51200000 },
		.id = HEX_INS_J2_CALLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_UCCALL,
		.syntax = "if (!) callr ",
		.flags = HEX_INSN_TEMPLATE_FLAG_CALL | HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010000110sssssPP00000000000000 | callrh Rs
		.encoding = { .mask = 0xffe03fff, .op = 0x50c00000 },
		.id = HEX_INS_J2_CALLRH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RCALL,
		.syntax = "callrh ",
		.flags = HEX_INSN_TEMPLATE_FLAG_CALL | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010001000sssssPP0000uu00000000 | if (Pu) callr Rs
		.encoding = { .mask = 0xffe03cff, .op = 0x51000000 },
		.id = HEX_INS_J2_CALLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_UCCALL,
		.syntax = "if () callr ",
		.flags = HEX_INSN_TEMPLATE_FLAG_CALL | HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01011101ii0iiiiiPPi000uuiiiiiii0 | if (Pu) call Ii
		.encoding = { .mask = 0xff201c01, .op = 0x5d000000 },
		.id = HEX_INS_J2_CALLT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 22 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CCALL,
		.syntax = "if () call ",
		.flags = HEX_INSN_TEMPLATE_FLAG_CALL | HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0101100iiiiiiiiiPPiiiiiiiiiiiii0 | jump Ii
		.encoding = { .mask = 0xfe000001, .op = 0x58000000 },
		.id = HEX_INS_J2_JUMP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0xd, 1 }, { 0x9, 16 } }, .imm_scale = 2, .syntax = 5 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_JMP,
		.syntax = "jump ",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01011100ii1iiiiiPPi000uuiiiiiii0 | if (!Pu) jump:nt Ii
		.encoding = { .mask = 0xff201c01, .op = 0x5c200000 },
		.id = HEX_INS_J2_JUMPF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 22 } }, .imm_scale = 2, .syntax = 15 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01011100ii1iiiiiPPi010uuiiiiiii0 | if (!Pu.new) jump:nt Ii
		.encoding = { .mask = 0xff201c01, .op = 0x5c200800 },
		.id = HEX_INS_J2_JUMPFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 22 } }, .imm_scale = 2, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01011100ii1iiiiiPPi110uuiiiiiii0 | if (!Pu.new) jump:t Ii
		.encoding = { .mask = 0xff201c01, .op = 0x5c201800 },
		.id = HEX_INS_J2_JUMPFNEWPT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 22 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01011100ii1iiiiiPPi100uuiiiiiii0 | if (!Pu) jump:t Ii
		.encoding = { .mask = 0xff201c01, .op = 0x5c201000 },
		.id = HEX_INS_J2_JUMPFPT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 22 } }, .imm_scale = 2, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010010100sssssPP00000000000000 | jumpr Rs
		.encoding = { .mask = 0xffe03fff, .op = 0x52800000 },
		.id = HEX_INS_J2_JUMPR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RJMP,
		.syntax = "jumpr ",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010011011sssssPP0000uu00000000 | if (!Pu) jumpr:nt Rs
		.encoding = { .mask = 0xffe03cff, .op = 0x53600000 },
		.id = HEX_INS_J2_JUMPRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_RCJMP,
		.syntax = "if (!) jumpr:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010011011sssssPP0010uu00000000 | if (!Pu.new) jumpr:nt Rs
		.encoding = { .mask = 0xffe03cff, .op = 0x53600800 },
		.id = HEX_INS_J2_JUMPRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_RCJMP,
		.syntax = "if (!.new) jumpr:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010011011sssssPP0110uu00000000 | if (!Pu.new) jumpr:t Rs
		.encoding = { .mask = 0xffe03cff, .op = 0x53601800 },
		.id = HEX_INS_J2_JUMPRFNEWPT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_RCJMP,
		.syntax = "if (!.new) jumpr:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010011011sssssPP0100uu00000000 | if (!Pu) jumpr:t Rs
		.encoding = { .mask = 0xffe03cff, .op = 0x53601000 },
		.id = HEX_INS_J2_JUMPRFPT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_RCJMP,
		.syntax = "if (!) jumpr:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010010110sssssPP00000000000000 | jumprh Rs
		.encoding = { .mask = 0xffe03fff, .op = 0x52c00000 },
		.id = HEX_INS_J2_JUMPRH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RJMP,
		.syntax = "jumprh ",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010011010sssssPP0000uu00000000 | if (Pu) jumpr:nt Rs
		.encoding = { .mask = 0xffe03cff, .op = 0x53400000 },
		.id = HEX_INS_J2_JUMPRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_RCJMP,
		.syntax = "if () jumpr:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010011010sssssPP0010uu00000000 | if (Pu.new) jumpr:nt Rs
		.encoding = { .mask = 0xffe03cff, .op = 0x53400800 },
		.id = HEX_INS_J2_JUMPRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_RCJMP,
		.syntax = "if (.new) jumpr:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010011010sssssPP0110uu00000000 | if (Pu.new) jumpr:t Rs
		.encoding = { .mask = 0xffe03cff, .op = 0x53401800 },
		.id = HEX_INS_J2_JUMPRTNEWPT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_RCJMP,
		.syntax = "if (.new) jumpr:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010011010sssssPP0100uu00000000 | if (Pu) jumpr:t Rs
		.encoding = { .mask = 0xffe03cff, .op = 0x53401000 },
		.id = HEX_INS_J2_JUMPRTPT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_RCJMP,
		.syntax = "if () jumpr:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01011100ii0iiiiiPPi000uuiiiiiii0 | if (Pu) jump:nt Ii
		.encoding = { .mask = 0xff201c01, .op = 0x5c000000 },
		.id = HEX_INS_J2_JUMPT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 22 } }, .imm_scale = 2, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if () jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01011100ii0iiiiiPPi010uuiiiiiii0 | if (Pu.new) jump:nt Ii
		.encoding = { .mask = 0xff201c01, .op = 0x5c000800 },
		.id = HEX_INS_J2_JUMPTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 22 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (.new) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01011100ii0iiiiiPPi110uuiiiiiii0 | if (Pu.new) jump:t Ii
		.encoding = { .mask = 0xff201c01, .op = 0x5c001800 },
		.id = HEX_INS_J2_JUMPTNEWPT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 22 } }, .imm_scale = 2, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (.new) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01011100ii0iiiiiPPi100uuiiiiiii0 | if (Pu) jump:t Ii
		.encoding = { .mask = 0xff201c01, .op = 0x5c001000 },
		.id = HEX_INS_J2_JUMPTPT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 1 }, { 0x1, 13 }, { 0x5, 16 }, { 0x2, 22 } }, .imm_scale = 2, .syntax = 13 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if () jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010100010000iiPP0iiiii000iii00 | pause(Ii)
		.encoding = { .mask = 0xfffc20e3, .op = 0x54400000 },
		.id = HEX_INS_J2_PAUSE,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 2 }, { 0x5, 8 }, { 0x2, 16 } }, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "pause()",
	},
	{
		// 0101010000000000PP0iiiii000iii00 | trap0(Ii)
		.encoding = { .mask = 0xffff20e3, .op = 0x54000000 },
		.id = HEX_INS_J2_TRAP0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 2 }, { 0x5, 8 } }, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_TRAP,
		.syntax = "trap0()",
	},
	{
		// 01010100100xxxxxPP0iiiii000iii00 | trap1(Rx,Ii)
		.encoding = { .mask = 0xffe020e3, .op = 0x54800000 },
		.id = HEX_INS_J2_TRAP1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 2 }, { 0x5, 8 } }, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_TRAP,
		.syntax = "trap1(,)",
	},
	{
		// 0101011111100000PP01000000000000 | unpause
		.encoding = { .mask = 0xffff3fff, .op = 0x57e01000 },
		.id = HEX_INS_J2_UNPAUSE,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "unpause",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01010010101sssssPP00000000000000 | hintjr(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x52a00000 },
		.id = HEX_INS_J4_HINTJUMPR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RJMP,
		.syntax = "hintjr()",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0101010010000000PP0iiiii000iii00 | trap1(Ii)
		.encoding = { .mask = 0xffff20e3, .op = 0x54800000 },
		.id = HEX_INS_PS_TRAP1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 2 }, { 0x5, 8 } }, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_TRAP,
		.syntax = "trap1()",
	},
	{
		// 01010110110sssssPP00000000000000 | icinva(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x56c00000 },
		.id = HEX_INS_Y2_ICINVA,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "icinva()",
	},
	{
		// 0101011111000000PP00000000000010 | isync
		.encoding = { .mask = 0xffff3fff, .op = 0x57c00002 },
		.id = HEX_INS_Y2_ISYNC,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "isync",
	},
	{
		// 01010101101sssssPP000000000ddddd | Rd = icdatar(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x55a00000 },
		.id = HEX_INS_IMPORTED_RD_ICDATAR_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = icdatar()",
	},
	{
		// 01010101111sssssPP000000000ddddd | Rd = ictagr(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x55e00000 },
		.id = HEX_INS_IMPORTED_RD_ICTAGR_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ictagr()",
	},
	{
		// 01010101110sssssPP1ttttt00000000 | icdataw(Rs,Rt)
		.encoding = { .mask = 0xffe020ff, .op = 0x55c02000 },
		.id = HEX_INS_IMPORTED_ICDATAW_RS_RT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "icdataw(,)",
	},
	{
		// 01010110110sssssPP00100000000000 | icinvidx(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x56c00800 },
		.id = HEX_INS_IMPORTED_ICINVIDX_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "icinvidx()",
	},
	{
		// 0101011011000000PP01000000000000 | ickill
		.encoding = { .mask = 0xffff3fff, .op = 0x56c01000 },
		.id = HEX_INS_IMPORTED_ICKILL,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "ickill",
	},
	{
		// 01010101110sssssPP0ttttt00000000 | ictagw(Rs,Rt)
		.encoding = { .mask = 0xffe020ff, .op = 0x55c00000 },
		.id = HEX_INS_IMPORTED_ICTAGW_RS_RT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "ictagw(,)",
	},
	{
		// 0101011111100000PP00000000000000 | rte
		.encoding = { .mask = 0xffff3fff, .op = 0x57e00000 },
		.id = HEX_INS_IMPORTED_RTE,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "rte",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_normal_0x6[] = {
	{
		// 01101010000sssssPP000000000ddddd | Rd = Cs
		.encoding = { .mask = 0xffe03fe0, .op = 0x6a000000 },
		.id = HEX_INS_A2_TFRCRR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_CTR_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01100010001sssssPP000000000ddddd | Cd = Rs
		.encoding = { .mask = 0xffe03fe0, .op = 0x62200000 },
		.id = HEX_INS_A2_TFRRCR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_CTR_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01101000000sssssPP000000000ddddd | Rdd = Css
		.encoding = { .mask = 0xffe03fe0, .op = 0x68000000 },
		.id = HEX_INS_A4_TFRCPP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_CTR_REGS64, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01100011001sssssPP000000000ddddd | Cdd = Rss
		.encoding = { .mask = 0xffe03fe0, .op = 0x63200000 },
		.id = HEX_INS_A4_TFRPCP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_CTR_REGS64, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01101011101000ssPP000000000000dd | Pd = all8(Ps)
		.encoding = { .mask = 0xfffc3ffc, .op = 0x6ba00000 },
		.id = HEX_INS_C2_ALL8,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = all8()",
	},
	{
		// 01101011000000ssPP0000tt000000dd | Pd = and(Pt,Ps)
		.encoding = { .mask = 0xfffc3cfc, .op = 0x6b000000 },
		.id = HEX_INS_C2_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,)",
	},
	{
		// 01101011011000ssPP0000tt000000dd | Pd = and(Pt,!Ps)
		.encoding = { .mask = 0xfffc3cfc, .op = 0x6b600000 },
		.id = HEX_INS_C2_ANDN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,!)",
	},
	{
		// 01101011100000ssPP000000000000dd | Pd = any8(Ps)
		.encoding = { .mask = 0xfffc3ffc, .op = 0x6b800000 },
		.id = HEX_INS_C2_ANY8,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = any8()",
	},
	{
		// 01101011110000ssPP000000000000dd | Pd = not(Ps)
		.encoding = { .mask = 0xfffc3ffc, .op = 0x6bc00000 },
		.id = HEX_INS_C2_NOT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = not()",
	},
	{
		// 01101011001000ssPP0000tt000000dd | Pd = or(Pt,Ps)
		.encoding = { .mask = 0xfffc3cfc, .op = 0x6b200000 },
		.id = HEX_INS_C2_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = or(,)",
	},
	{
		// 01101011111000ssPP0000tt000000dd | Pd = or(Pt,!Ps)
		.encoding = { .mask = 0xfffc3cfc, .op = 0x6be00000 },
		.id = HEX_INS_C2_ORN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = or(,!)",
	},
	{
		// 01101011010000ssPP0000tt000000dd | Pd = xor(Ps,Pt)
		.encoding = { .mask = 0xfffc3cfc, .op = 0x6b400000 },
		.id = HEX_INS_C2_XOR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = xor(,)",
	},
	{
		// 0110101001001001PP0iiiiii00ddddd | Rd = add(pc,Ii)
		.encoding = { .mask = 0xffff2060, .op = 0x6a490000 },
		.id = HEX_INS_C4_ADDIPC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 7 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(PC,)",
	},
	{
		// 01101011000100ssPP0000ttuu0000dd | Pd = and(Ps,and(Pt,Pu))
		.encoding = { .mask = 0xfffc3c3c, .op = 0x6b100000 },
		.id = HEX_INS_C4_AND_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 6 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,and(,))",
	},
	{
		// 01101011100100ssPP0000ttuu0000dd | Pd = and(Ps,and(Pt,!Pu))
		.encoding = { .mask = 0xfffc3c3c, .op = 0x6b900000 },
		.id = HEX_INS_C4_AND_ANDN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 6 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,and(,!))",
	},
	{
		// 01101011001100ssPP0000ttuu0000dd | Pd = and(Ps,or(Pt,Pu))
		.encoding = { .mask = 0xfffc3c3c, .op = 0x6b300000 },
		.id = HEX_INS_C4_AND_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 6 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,or(,))",
	},
	{
		// 01101011101100ssPP0000ttuu0000dd | Pd = and(Ps,or(Pt,!Pu))
		.encoding = { .mask = 0xfffc3c3c, .op = 0x6bb00000 },
		.id = HEX_INS_C4_AND_ORN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 6 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,or(,!))",
	},
	{
		// 01101011000000ssPP1000tt100100dd | Pd = fastcorner9(Ps,Pt)
		.encoding = { .mask = 0xfffc3cfc, .op = 0x6b002090 },
		.id = HEX_INS_C4_FASTCORNER9,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = fastcorner9(,)",
	},
	{
		// 01101011000100ssPP1000tt100100dd | Pd = !fastcorner9(Ps,Pt)
		.encoding = { .mask = 0xfffc3cfc, .op = 0x6b102090 },
		.id = HEX_INS_C4_FASTCORNER9_NOT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = !fastcorner9(,)",
	},
	{
		// 01101011010100ssPP0000ttuu0000dd | Pd = or(Ps,and(Pt,Pu))
		.encoding = { .mask = 0xfffc3c3c, .op = 0x6b500000 },
		.id = HEX_INS_C4_OR_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 6 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = or(,and(,))",
	},
	{
		// 01101011110100ssPP0000ttuu0000dd | Pd = or(Ps,and(Pt,!Pu))
		.encoding = { .mask = 0xfffc3c3c, .op = 0x6bd00000 },
		.id = HEX_INS_C4_OR_ANDN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 6 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = or(,and(,!))",
	},
	{
		// 01101011011100ssPP0000ttuu0000dd | Pd = or(Ps,or(Pt,Pu))
		.encoding = { .mask = 0xfffc3c3c, .op = 0x6b700000 },
		.id = HEX_INS_C4_OR_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 6 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = or(,or(,))",
	},
	{
		// 01101011111100ssPP0000ttuu0000dd | Pd = or(Ps,or(Pt,!Pu))
		.encoding = { .mask = 0xfffc3c3c, .op = 0x6bf00000 },
		.id = HEX_INS_C4_OR_ORN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 6 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = or(,or(,!))",
	},
	{
		// 01101000001sssssPP000000000ddddd | Rdd = Gss
		.encoding = { .mask = 0xffe03fe0, .op = 0x68200000 },
		.id = HEX_INS_G4_TFRGCPP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_GUEST_REGS64, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01101010001sssssPP000000000ddddd | Rd = Gs
		.encoding = { .mask = 0xffe03fe0, .op = 0x6a200000 },
		.id = HEX_INS_G4_TFRGCRR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_GUEST_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01100011000sssssPP000000000ddddd | Gdd = Rss
		.encoding = { .mask = 0xffe03fe0, .op = 0x63000000 },
		.id = HEX_INS_G4_TFRGPCP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_GUEST_REGS64, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01100010000sssssPP000000000ddddd | Gd = Rs
		.encoding = { .mask = 0xffe03fe0, .op = 0x62000000 },
		.id = HEX_INS_G4_TFRGRCR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_GUEST_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 0110000101isssssPPi0iiiiiiiiiii0 | if (Rs>=#0) jump:nt Ii
		.encoding = { .mask = 0xffc01001, .op = 0x61400000 },
		.id = HEX_INS_J2_JUMPRGTEZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE, .masks = { { 0xb, 1 }, { 0x1, 13 }, { 0x1, 21 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (>=#0) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0110000101isssssPPi1iiiiiiiiiii0 | if (Rs>=#0) jump:t Ii
		.encoding = { .mask = 0xffc01001, .op = 0x61401000 },
		.id = HEX_INS_J2_JUMPRGTEZPT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE, .masks = { { 0xb, 1 }, { 0x1, 13 }, { 0x1, 21 } }, .imm_scale = 2, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (>=#0) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0110000111isssssPPi0iiiiiiiiiii0 | if (Rs<=#0) jump:nt Ii
		.encoding = { .mask = 0xffc01001, .op = 0x61c00000 },
		.id = HEX_INS_J2_JUMPRLTEZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE, .masks = { { 0xb, 1 }, { 0x1, 13 }, { 0x1, 21 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (<=#0) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0110000111isssssPPi1iiiiiiiiiii0 | if (Rs<=#0) jump:t Ii
		.encoding = { .mask = 0xffc01001, .op = 0x61c01000 },
		.id = HEX_INS_J2_JUMPRLTEZPT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE, .masks = { { 0xb, 1 }, { 0x1, 13 }, { 0x1, 21 } }, .imm_scale = 2, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (<=#0) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0110000110isssssPPi0iiiiiiiiiii0 | if (Rs==#0) jump:nt Ii
		.encoding = { .mask = 0xffc01001, .op = 0x61800000 },
		.id = HEX_INS_J2_JUMPRNZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE, .masks = { { 0xb, 1 }, { 0x1, 13 }, { 0x1, 21 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (==#0) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0110000110isssssPPi1iiiiiiiiiii0 | if (Rs==#0) jump:t Ii
		.encoding = { .mask = 0xffc01001, .op = 0x61801000 },
		.id = HEX_INS_J2_JUMPRNZPT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE, .masks = { { 0xb, 1 }, { 0x1, 13 }, { 0x1, 21 } }, .imm_scale = 2, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (==#0) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0110000100isssssPPi0iiiiiiiiiii0 | if (Rs!=#0) jump:nt Ii
		.encoding = { .mask = 0xffc01001, .op = 0x61000000 },
		.id = HEX_INS_J2_JUMPRZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE, .masks = { { 0xb, 1 }, { 0x1, 13 }, { 0x1, 21 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!=#0) jump:nt ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 0110000100isssssPPi1iiiiiiiiiii0 | if (Rs!=#0) jump:t Ii
		.encoding = { .mask = 0xffc01001, .op = 0x61001000 },
		.id = HEX_INS_J2_JUMPRZPT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE, .masks = { { 0xb, 1 }, { 0x1, 13 }, { 0x1, 21 } }, .imm_scale = 2, .syntax = 17 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CJMP,
		.syntax = "if (!=#0) jump:t ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED | HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT,
	},
	{
		// 01101001000IIIIIPP0iiiiiIIIii0II | loop0(Ii,II)
		.encoding = { .mask = 0xffe02004, .op = 0x69000000 },
		.id = HEX_INS_J2_LOOP0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x2, 3 }, { 0x5, 8 } }, .imm_scale = 2, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 0 }, { 0x3, 5 }, { 0x5, 16 } }, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_JMP,
		.syntax = "loop0(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT | HEX_INSN_TEMPLATE_FLAG_LOOP_BEGIN | HEX_INSN_TEMPLATE_FLAG_LOOP_0,
	},
	{
		// 01100000000sssssPP0iiiii000ii000 | loop0(Ii,Rs)
		.encoding = { .mask = 0xffe020e7, .op = 0x60000000 },
		.id = HEX_INS_J2_LOOP0R,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x2, 3 }, { 0x5, 8 } }, .imm_scale = 2, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_JMP,
		.syntax = "loop0(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT | HEX_INSN_TEMPLATE_FLAG_LOOP_BEGIN | HEX_INSN_TEMPLATE_FLAG_LOOP_0,
	},
	{
		// 01101001001IIIIIPP0iiiiiIIIii0II | loop1(Ii,II)
		.encoding = { .mask = 0xffe02004, .op = 0x69200000 },
		.id = HEX_INS_J2_LOOP1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x2, 3 }, { 0x5, 8 } }, .imm_scale = 2, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 0 }, { 0x3, 5 }, { 0x5, 16 } }, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_JMP,
		.syntax = "loop1(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT | HEX_INSN_TEMPLATE_FLAG_LOOP_BEGIN | HEX_INSN_TEMPLATE_FLAG_LOOP_1,
	},
	{
		// 01100000001sssssPP0iiiii000ii000 | loop1(Ii,Rs)
		.encoding = { .mask = 0xffe020e7, .op = 0x60200000 },
		.id = HEX_INS_J2_LOOP1R,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x2, 3 }, { 0x5, 8 } }, .imm_scale = 2, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_JMP,
		.syntax = "loop1(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT | HEX_INSN_TEMPLATE_FLAG_LOOP_BEGIN | HEX_INSN_TEMPLATE_FLAG_LOOP_1,
	},
	{
		// 01101001101IIIIIPP0iiiiiIIIii0II | p3 = sp1loop0(Ii,II)
		.encoding = { .mask = 0xffe02004, .op = 0x69a00000 },
		.id = HEX_INS_J2_PLOOP1SI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x2, 3 }, { 0x5, 8 } }, .imm_scale = 2, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 0 }, { 0x3, 5 }, { 0x5, 16 } }, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_JMP,
		.syntax = "P3 = sp1loop0(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT | HEX_INSN_TEMPLATE_FLAG_LOOP_BEGIN | HEX_INSN_TEMPLATE_FLAG_LOOP_0,
	},
	{
		// 01100000101sssssPP0iiiii000ii000 | p3 = sp1loop0(Ii,Rs)
		.encoding = { .mask = 0xffe020e7, .op = 0x60a00000 },
		.id = HEX_INS_J2_PLOOP1SR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x2, 3 }, { 0x5, 8 } }, .imm_scale = 2, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_JMP,
		.syntax = "P3 = sp1loop0(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT | HEX_INSN_TEMPLATE_FLAG_LOOP_BEGIN | HEX_INSN_TEMPLATE_FLAG_LOOP_0,
	},
	{
		// 01101001110IIIIIPP0iiiiiIIIii0II | p3 = sp2loop0(Ii,II)
		.encoding = { .mask = 0xffe02004, .op = 0x69c00000 },
		.id = HEX_INS_J2_PLOOP2SI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x2, 3 }, { 0x5, 8 } }, .imm_scale = 2, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 0 }, { 0x3, 5 }, { 0x5, 16 } }, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_JMP,
		.syntax = "P3 = sp2loop0(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT | HEX_INSN_TEMPLATE_FLAG_LOOP_BEGIN | HEX_INSN_TEMPLATE_FLAG_LOOP_0,
	},
	{
		// 01100000110sssssPP0iiiii000ii000 | p3 = sp2loop0(Ii,Rs)
		.encoding = { .mask = 0xffe020e7, .op = 0x60c00000 },
		.id = HEX_INS_J2_PLOOP2SR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x2, 3 }, { 0x5, 8 } }, .imm_scale = 2, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_JMP,
		.syntax = "P3 = sp2loop0(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT | HEX_INSN_TEMPLATE_FLAG_LOOP_BEGIN | HEX_INSN_TEMPLATE_FLAG_LOOP_0,
	},
	{
		// 01101001111IIIIIPP0iiiiiIIIii0II | p3 = sp3loop0(Ii,II)
		.encoding = { .mask = 0xffe02004, .op = 0x69e00000 },
		.id = HEX_INS_J2_PLOOP3SI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x2, 3 }, { 0x5, 8 } }, .imm_scale = 2, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 0 }, { 0x3, 5 }, { 0x5, 16 } }, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_JMP,
		.syntax = "P3 = sP3loop0(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT | HEX_INSN_TEMPLATE_FLAG_LOOP_BEGIN | HEX_INSN_TEMPLATE_FLAG_LOOP_0,
	},
	{
		// 01100000111sssssPP0iiiii000ii000 | p3 = sp3loop0(Ii,Rs)
		.encoding = { .mask = 0xffe020e7, .op = 0x60e00000 },
		.id = HEX_INS_J2_PLOOP3SR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x2, 3 }, { 0x5, 8 } }, .imm_scale = 2, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_JMP,
		.syntax = "P3 = sP3loop0(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT | HEX_INSN_TEMPLATE_FLAG_LOOP_BEGIN | HEX_INSN_TEMPLATE_FLAG_LOOP_0,
	},
	{
		// 0110110000100000PP00000000000000 | brkpt
		.encoding = { .mask = 0xffff3fff, .op = 0x6c200000 },
		.id = HEX_INS_Y2_BREAK,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "brkpt",
	},
	{
		// 01100101000xxxxxPP00000000000000 | crswap(Rx,sgp0)
		.encoding = { .mask = 0xffe03fff, .op = 0x65000000 },
		.id = HEX_INS_Y2_CRSWAP0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "crswap(,SGP0)",
	},
	{
		// 011011101sssssssPP000000000ddddd | Rd = Ss
		.encoding = { .mask = 0xff803fe0, .op = 0x6e800000 },
		.id = HEX_INS_Y2_TFRSCRR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x7, 16 } }, .reg_cls = HEX_REG_CLASS_SYS_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01100111000sssssPP0000000ddddddd | Sd = Rs
		.encoding = { .mask = 0xffe03f80, .op = 0x67000000 },
		.id = HEX_INS_Y2_TFRSRCR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x7, 0 } }, .reg_cls = HEX_REG_CLASS_SYS_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01100100010sssssPP00000000000000 | wait(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x64400000 },
		.id = HEX_INS_Y2_WAIT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "wait()",
	},
	{
		// 01100101001xxxxxPP00000000000000 | crswap(Rx,sgp1)
		.encoding = { .mask = 0xffe03fff, .op = 0x65200000 },
		.id = HEX_INS_Y4_CRSWAP1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "crswap(,SGP1)",
	},
	{
		// 01101101100xxxxxPP00000000000000 | crswap(Rxx,sgp1:0)
		.encoding = { .mask = 0xffe03fff, .op = 0x6d800000 },
		.id = HEX_INS_Y4_CRSWAP10,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "crswap(,SGP1:0)",
	},
	{
		// 011011110sssssssPP000000000ddddd | Rdd = Sss
		.encoding = { .mask = 0xff803fe0, .op = 0x6f000000 },
		.id = HEX_INS_Y4_TFRSCPP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x7, 16 } }, .reg_cls = HEX_REG_CLASS_SYS_REGS64, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01101101000sssssPP0000000ddddddd | Sdd = Rss
		.encoding = { .mask = 0xffe03f80, .op = 0x6d000000 },
		.id = HEX_INS_Y4_TFRSPCP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x7, 0 } }, .reg_cls = HEX_REG_CLASS_SYS_REGS64, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01100010010sssssPP00000000000000 | trace(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x62400000 },
		.id = HEX_INS_Y4_TRACE,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "trace()",
	},
	{
		// 01100010010sssssPP00000000100000 | diag(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x62400020 },
		.id = HEX_INS_Y6_DIAG,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "DIAG()",
	},
	{
		// 01100010010sssssPP0ttttt01000000 | diag0(Rss,Rtt)
		.encoding = { .mask = 0xffe020ff, .op = 0x62400040 },
		.id = HEX_INS_Y6_DIAG0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "DIAG0(,)",
	},
	{
		// 01100010010sssssPP0ttttt01100000 | diag1(Rss,Rtt)
		.encoding = { .mask = 0xffe020ff, .op = 0x62400060 },
		.id = HEX_INS_Y6_DIAG1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "DIAG1(,)",
	},
	{
		// 011011101sssssssPP000000000ddddd | Rd = Ss
		.encoding = { .mask = 0xff803fe0, .op = 0x6e800000 },
		.id = HEX_INS_IMPORTED_RD_SS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x7, 16 } }, .reg_cls = HEX_REG_CLASS_SYS_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01101100110sssssPP0ttttt000ddddd | Rd = ctlbw(Rss,Rt)
		.encoding = { .mask = 0xffe020e0, .op = 0x6cc00000 },
		.id = HEX_INS_IMPORTED_RD_CTLBW_RSS_RT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ctlbw(,)",
	},
	{
		// 01100110000sssssPP000000000ddddd | Rd = getimask(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x66000000 },
		.id = HEX_INS_IMPORTED_RD_GETIMASK_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = getimask()",
	},
	{
		// 01100110011sssssPP000000000ddddd | Rd = iassignr(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x66600000 },
		.id = HEX_INS_IMPORTED_RD_IASSIGNR_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = iassignr()",
	},
	{
		// 01101100111sssssPP000000000ddddd | Rd = tlboc(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x6ce00000 },
		.id = HEX_INS_IMPORTED_RD_TLBOC_RSS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = tlboc()",
	},
	{
		// 01101100100sssssPP000000000ddddd | Rd = tlbp(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x6c800000 },
		.id = HEX_INS_IMPORTED_RD_TLBP_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = tlbp()",
	},
	{
		// 011011110sssssssPP000000000ddddd | Rdd = Sss
		.encoding = { .mask = 0xff803fe0, .op = 0x6f000000 },
		.id = HEX_INS_IMPORTED_RDD_SSS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x7, 16 } }, .reg_cls = HEX_REG_CLASS_SYS_REGS64, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01101100010sssssPP000000000ddddd | Rdd = tlbr(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x6c400000 },
		.id = HEX_INS_IMPORTED_RDD_TLBR_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = tlbr()",
	},
	{
		// 01100111000sssssPP0000000ddddddd | Sd = Rs
		.encoding = { .mask = 0xffe03f80, .op = 0x67000000 },
		.id = HEX_INS_IMPORTED_SD_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x7, 0 } }, .reg_cls = HEX_REG_CLASS_SYS_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 0110110100-sssssPP-------ddddddd | Sdd = Rss
		.encoding = { .mask = 0xffc00000, .op = 0x6d000000 },
		.id = HEX_INS_IMPORTED_SDD_RSS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x7, 0 } }, .reg_cls = HEX_REG_CLASS_SYS_REGS64, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01100100000sssssPP00000001100000 | ciad(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x64000060 },
		.id = HEX_INS_IMPORTED_CIAD_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "ciad()",
	},
	{
		// 01100100000sssssPP00000000100000 | cswi(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x64000020 },
		.id = HEX_INS_IMPORTED_CSWI_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "CSwi()",
	},
	{
		// 01100100000sssssPP00000001000000 | iassignw(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x64000040 },
		.id = HEX_INS_IMPORTED_IASSIGNW_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "iassignw()",
	},
	{
		// 0110110000100000PP00000001100000 | k0lock
		.encoding = { .mask = 0xffff3fff, .op = 0x6c200060 },
		.id = HEX_INS_IMPORTED_K0LOCK,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "k0lock",
	},
	{
		// 0110110000100000PP00000010000000 | k0unlock
		.encoding = { .mask = 0xffff3fff, .op = 0x6c200080 },
		.id = HEX_INS_IMPORTED_K0UNLOCK,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "k0unlock",
	},
	{
		// 01100100011sssssPP00000001000000 | nmi(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x64600040 },
		.id = HEX_INS_IMPORTED_NMI_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 4 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "nmi()",
	},
	{
		// 01100100010sssssPP00000000100000 | resume(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x64400020 },
		.id = HEX_INS_IMPORTED_RESUME_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "resume()",
	},
	{
		// 01100100100sssssPP0000tt00000000 | setimask(Pt,Rs)
		.encoding = { .mask = 0xffe03cff, .op = 0x64800000 },
		.id = HEX_INS_IMPORTED_SETIMASK_PT_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "setimask(,)",
	},
	{
		// 01100100100sssssPP0000tt00100000 | setprio(Pt,Rs)
		.encoding = { .mask = 0xffe03cff, .op = 0x64800020 },
		.id = HEX_INS_IMPORTED_SETPRIO_PT_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "setprio(,)",
	},
	{
		// 01100100100sssssPP00000001100000 | siad(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x64800060 },
		.id = HEX_INS_IMPORTED_SIAD_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "siad()",
	},
	{
		// 01100100011sssssPP00000000100000 | start(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x64600020 },
		.id = HEX_INS_IMPORTED_START_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "start()",
	},
	{
		// 01100100011sssssPP00000000000000 | stop(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x64600000 },
		.id = HEX_INS_IMPORTED_STOP_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 5 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "stop()",
	},
	{
		// 01100100000sssssPP00000000000000 | swi(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x64000000 },
		.id = HEX_INS_IMPORTED_SWI_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 4 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "swi()",
	},
	{
		// 01101100101sssssPP00000000000000 | tlbinvasid(Rs)
		.encoding = { .mask = 0xffe03fff, .op = 0x6ca00000 },
		.id = HEX_INS_IMPORTED_TLBINVASID_RS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "tlbinvasid()",
	},
	{
		// 0110110000100000PP00000000100000 | tlblock
		.encoding = { .mask = 0xffff3fff, .op = 0x6c200020 },
		.id = HEX_INS_IMPORTED_TLBLOCK,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "tlblock",
	},
	{
		// 0110110000100000PP00000001000000 | tlbunlock
		.encoding = { .mask = 0xffff3fff, .op = 0x6c200040 },
		.id = HEX_INS_IMPORTED_TLBUNLOCK,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "tlbunlock",
	},
	{
		// 01101100000sssssPP0ttttt00000000 | tlbw(Rss,Rt)
		.encoding = { .mask = 0xffe020ff, .op = 0x6c000000 },
		.id = HEX_INS_IMPORTED_TLBW_RSS_RT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 8 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "tlbw(,)",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_normal_0x7[] = {
	{
		// 0111011000isssssPPiiiiiiiiiddddd | Rd = and(Rs,Ii)
		.encoding = { .mask = 0xffc00000, .op = 0x76000000 },
		.id = HEX_INS_A2_ANDIR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x1, 21 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,)",
	},
	{
		// 01110000000sssssPP000000000ddddd | Rd = aslh(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x70000000 },
		.id = HEX_INS_A2_ASLH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = aslh()",
	},
	{
		// 01110000001sssssPP000000000ddddd | Rd = asrh(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x70200000 },
		.id = HEX_INS_A2_ASRH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = asrh()",
	},
	{
		// 011111000IIIIIIIPPIiiiiiiiiddddd | Rdd = combine(Ii,II)
		.encoding = { .mask = 0xff800000, .op = 0x7c000000 },
		.id = HEX_INS_A2_COMBINEII,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 } }, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x1, 13 }, { 0x7, 16 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,)",
	},
	{
		// 0111111100000000PP00000000000000 | nop
		.encoding = { .mask = 0xffff3fff, .op = 0x7f000000 },
		.id = HEX_INS_A2_NOP,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NOP,
		.syntax = "nop",
	},
	{
		// 0111011010isssssPPiiiiiiiiiddddd | Rd = or(Rs,Ii)
		.encoding = { .mask = 0xffc00000, .op = 0x76800000 },
		.id = HEX_INS_A2_ORIR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x1, 21 } }, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = or(,)",
	},
	{
		// 011101001uusssssPP0iiiiiiiiddddd | if (!Pu) Rd = add(Rs,Ii)
		.encoding = { .mask = 0xff802000, .op = 0x74800000 },
		.id = HEX_INS_A2_PADDIF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 21 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 } }, .syntax = 15 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = add(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011101001uusssssPP1iiiiiiiiddddd | if (!Pu.new) Rd = add(Rs,Ii)
		.encoding = { .mask = 0xff802000, .op = 0x74802000 },
		.id = HEX_INS_A2_PADDIFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 21 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 } }, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = add(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011101000uusssssPP0iiiiiiiiddddd | if (Pu) Rd = add(Rs,Ii)
		.encoding = { .mask = 0xff802000, .op = 0x74000000 },
		.id = HEX_INS_A2_PADDIT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 21 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = add(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011101000uusssssPP1iiiiiiiiddddd | if (Pu.new) Rd = add(Rs,Ii)
		.encoding = { .mask = 0xff802000, .op = 0x74002000 },
		.id = HEX_INS_A2_PADDITNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 21 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 } }, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = add(,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0111011001isssssPPiiiiiiiiiddddd | Rd = sub(Ii,Rs)
		.encoding = { .mask = 0xffc00000, .op = 0x76400000 },
		.id = HEX_INS_A2_SUBRI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x1, 21 } }, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sub(,)",
	},
	{
		// 01110000101sssssPP000000000ddddd | Rd = sxtb(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x70a00000 },
		.id = HEX_INS_A2_SXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb()",
	},
	{
		// 01110000111sssssPP000000000ddddd | Rd = sxth(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x70e00000 },
		.id = HEX_INS_A2_SXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth()",
	},
	{
		// 01110000011sssssPP000000000ddddd | Rd = Rs
		.encoding = { .mask = 0xffe03fe0, .op = 0x70600000 },
		.id = HEX_INS_A2_TFR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01110010ii1xxxxxPPiiiiiiiiiiiiii | Rx.h = Ii
		.encoding = { .mask = 0xff200000, .op = 0x72200000 },
		.id = HEX_INS_A2_TFRIH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0xe, 0 }, { 0x2, 22 } }, .syntax = 5 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".h = ",
	},
	{
		// 01110001ii1xxxxxPPiiiiiiiiiiiiii | Rx.l = Ii
		.encoding = { .mask = 0xff200000, .op = 0x71200000 },
		.id = HEX_INS_A2_TFRIL,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0xe, 0 }, { 0x2, 22 } }, .syntax = 5 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ".l = ",
	},
	{
		// 01111000ii0iiiiiPPiiiiiiiiiddddd | Rd = Ii
		.encoding = { .mask = 0xff200000, .op = 0x78000000 },
		.id = HEX_INS_A2_TFRSI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x5, 16 }, { 0x2, 22 } }, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 01110000110sssssPP000000000ddddd | Rd = zxth(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x70c00000 },
		.id = HEX_INS_A2_ZXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth()",
	},
	{
		// 01111100100IIIIIPPIiiiiiiiiddddd | Rdd = combine(Ii,II)
		.encoding = { .mask = 0xffe00000, .op = 0x7c800000 },
		.id = HEX_INS_A4_COMBINEII,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x8, 5 } }, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x1, 13 }, { 0x5, 16 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,)",
	},
	{
		// 01110011001sssssPP1iiiiiiiiddddd | Rdd = combine(Ii,Rs)
		.encoding = { .mask = 0xffe02000, .op = 0x73202000 },
		.id = HEX_INS_A4_COMBINEIR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 } }, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,)",
	},
	{
		// 01110011000sssssPP1iiiiiiiiddddd | Rdd = combine(Rs,Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x73002000 },
		.id = HEX_INS_A4_COMBINERI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,)",
	},
	{
		// 01110000000sssssPP1010uu000ddddd | if (!Pu) Rd = aslh(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70002800 },
		.id = HEX_INS_A4_PASLHF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = aslh()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000000sssssPP1011uu000ddddd | if (!Pu.new) Rd = aslh(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70002c00 },
		.id = HEX_INS_A4_PASLHFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = aslh()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000000sssssPP1000uu000ddddd | if (Pu) Rd = aslh(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70002000 },
		.id = HEX_INS_A4_PASLHT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = aslh()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000000sssssPP1001uu000ddddd | if (Pu.new) Rd = aslh(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70002400 },
		.id = HEX_INS_A4_PASLHTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = aslh()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000001sssssPP1010uu000ddddd | if (!Pu) Rd = asrh(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70202800 },
		.id = HEX_INS_A4_PASRHF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = asrh()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000001sssssPP1011uu000ddddd | if (!Pu.new) Rd = asrh(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70202c00 },
		.id = HEX_INS_A4_PASRHFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = asrh()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000001sssssPP1000uu000ddddd | if (Pu) Rd = asrh(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70202000 },
		.id = HEX_INS_A4_PASRHT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = asrh()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000001sssssPP1001uu000ddddd | if (Pu.new) Rd = asrh(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70202400 },
		.id = HEX_INS_A4_PASRHTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = asrh()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000101sssssPP1010uu000ddddd | if (!Pu) Rd = sxtb(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70a02800 },
		.id = HEX_INS_A4_PSXTBF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = sxtb()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000101sssssPP1011uu000ddddd | if (!Pu.new) Rd = sxtb(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70a02c00 },
		.id = HEX_INS_A4_PSXTBFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = sxtb()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000101sssssPP1000uu000ddddd | if (Pu) Rd = sxtb(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70a02000 },
		.id = HEX_INS_A4_PSXTBT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = sxtb()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000101sssssPP1001uu000ddddd | if (Pu.new) Rd = sxtb(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70a02400 },
		.id = HEX_INS_A4_PSXTBTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = sxtb()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000111sssssPP1010uu000ddddd | if (!Pu) Rd = sxth(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70e02800 },
		.id = HEX_INS_A4_PSXTHF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = sxth()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000111sssssPP1011uu000ddddd | if (!Pu.new) Rd = sxth(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70e02c00 },
		.id = HEX_INS_A4_PSXTHFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = sxth()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000111sssssPP1000uu000ddddd | if (Pu) Rd = sxth(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70e02000 },
		.id = HEX_INS_A4_PSXTHT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = sxth()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000111sssssPP1001uu000ddddd | if (Pu.new) Rd = sxth(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70e02400 },
		.id = HEX_INS_A4_PSXTHTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = sxth()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000100sssssPP1010uu000ddddd | if (!Pu) Rd = zxtb(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70802800 },
		.id = HEX_INS_A4_PZXTBF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = zxtb()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000100sssssPP1011uu000ddddd | if (!Pu.new) Rd = zxtb(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70802c00 },
		.id = HEX_INS_A4_PZXTBFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = zxtb()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000100sssssPP1000uu000ddddd | if (Pu) Rd = zxtb(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70802000 },
		.id = HEX_INS_A4_PZXTBT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = zxtb()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000100sssssPP1001uu000ddddd | if (Pu.new) Rd = zxtb(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70802400 },
		.id = HEX_INS_A4_PZXTBTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = zxtb()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000110sssssPP1010uu000ddddd | if (!Pu) Rd = zxth(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70c02800 },
		.id = HEX_INS_A4_PZXTHF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = zxth()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000110sssssPP1011uu000ddddd | if (!Pu.new) Rd = zxth(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70c02c00 },
		.id = HEX_INS_A4_PZXTHFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = zxth()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000110sssssPP1000uu000ddddd | if (Pu) Rd = zxth(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70c02000 },
		.id = HEX_INS_A4_PZXTHT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = zxth()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110000110sssssPP1001uu000ddddd | if (Pu.new) Rd = zxth(Rs)
		.encoding = { .mask = 0xffe03ce0, .op = 0x70c02400 },
		.id = HEX_INS_A4_PZXTHTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = zxth()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01110011010sssssPP1iiiiiiiiddddd | Rd = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x73402000 },
		.id = HEX_INS_A4_RCMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = cmp.eq(,)",
	},
	{
		// 01110011011sssssPP1iiiiiiiiddddd | Rd = !cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xffe02000, .op = 0x73602000 },
		.id = HEX_INS_A4_RCMPNEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = !cmp.eq(,)",
	},
	{
		// 011111101uu0iiiiPP0iiiiiiiiddddd | if (!Pu) Rd = Ii
		.encoding = { .mask = 0xff902000, .op = 0x7e800000 },
		.id = HEX_INS_C2_CMOVEIF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 21 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 }, { 0x4, 16 } }, .syntax = 10 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!)  = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011111100uu0iiiiPP0iiiiiiiiddddd | if (Pu) Rd = Ii
		.encoding = { .mask = 0xff902000, .op = 0x7e000000 },
		.id = HEX_INS_C2_CMOVEIT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 21 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 }, { 0x4, 16 } }, .syntax = 9 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if ()  = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011111101uu0iiiiPP1iiiiiiiiddddd | if (!Pu.new) Rd = Ii
		.encoding = { .mask = 0xff902000, .op = 0x7e802000 },
		.id = HEX_INS_C2_CMOVENEWIF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 21 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 5 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 }, { 0x4, 16 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!.new)  = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011111100uu0iiiiPP1iiiiiiiiddddd | if (Pu.new) Rd = Ii
		.encoding = { .mask = 0xff902000, .op = 0x7e002000 },
		.id = HEX_INS_C2_CMOVENEWIT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 21 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 4 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 }, { 0x4, 16 } }, .syntax = 13 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (.new)  = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0111010100isssssPPiiiiiiiii000dd | Pd = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xffc0001c, .op = 0x75000000 },
		.id = HEX_INS_C2_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x1, 21 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = cmp.eq(,)",
	},
	{
		// 0111010101isssssPPiiiiiiiii000dd | Pd = cmp.gt(Rs,Ii)
		.encoding = { .mask = 0xffc0001c, .op = 0x75400000 },
		.id = HEX_INS_C2_CMPGTI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x1, 21 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = cmp.gt(,)",
	},
	{
		// 01110101100sssssPPiiiiiiiii000dd | Pd = cmp.gtu(Rs,Ii)
		.encoding = { .mask = 0xffe0001c, .op = 0x75800000 },
		.id = HEX_INS_C2_CMPGTUI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = cmp.gtu(,)",
	},
	{
		// 0111101uuIIIIIIIPPIiiiiiiiiddddd | Rd = mux(Pu,Ii,II)
		.encoding = { .mask = 0xfe000000, .op = 0x7a000000 },
		.id = HEX_INS_C2_MUXII,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 23 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x1, 13 }, { 0x7, 16 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = mux(,,)",
	},
	{
		// 011100110uusssssPP0iiiiiiiiddddd | Rd = mux(Pu,Rs,Ii)
		.encoding = { .mask = 0xff802000, .op = 0x73000000 },
		.id = HEX_INS_C2_MUXIR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 21 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = mux(,,)",
	},
	{
		// 011100111uusssssPP0iiiiiiiiddddd | Rd = mux(Pu,Ii,Rs)
		.encoding = { .mask = 0xff802000, .op = 0x73800000 },
		.id = HEX_INS_C2_MUXRI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 21 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x8, 5 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = mux(,,)",
	},
	{
		// 0111010101isssssPPiiiiiiiii100dd | Pd = !cmp.gt(Rs,Ii)
		.encoding = { .mask = 0xffc0001c, .op = 0x75400010 },
		.id = HEX_INS_C4_CMPLTEI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x1, 21 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = !cmp.gt(,)",
	},
	{
		// 01110101100sssssPPiiiiiiiii100dd | Pd = !cmp.gtu(Rs,Ii)
		.encoding = { .mask = 0xffe0001c, .op = 0x75800010 },
		.id = HEX_INS_C4_CMPLTEUI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = !cmp.gtu(,)",
	},
	{
		// 0111010100isssssPPiiiiiiiii100dd | Pd = !cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xffc0001c, .op = 0x75000010 },
		.id = HEX_INS_C4_CMPNEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x1, 21 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = !cmp.eq(,)",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_normal_0x8[] = {
	{
		// 10001100100sssssPP000000100ddddd | Rd = abs(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8c800080 },
		.id = HEX_INS_A2_ABS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = abs()",
	},
	{
		// 10000000100sssssPP000000110ddddd | Rdd = abs(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x808000c0 },
		.id = HEX_INS_A2_ABSP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = abs()",
	},
	{
		// 10001100100sssssPP000000101ddddd | Rd = abs(Rs):sat
		.encoding = { .mask = 0xffe03fe0, .op = 0x8c8000a0 },
		.id = HEX_INS_A2_ABSSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = abs():sat",
	},
	{
		// 10000000100sssssPP000000101ddddd | Rdd = neg(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x808000a0 },
		.id = HEX_INS_A2_NEGP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = neg()",
	},
	{
		// 10001100100sssssPP000000110ddddd | Rd = neg(Rs):sat
		.encoding = { .mask = 0xffe03fe0, .op = 0x8c8000c0 },
		.id = HEX_INS_A2_NEGSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = neg():sat",
	},
	{
		// 10000000100sssssPP000000100ddddd | Rdd = not(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x80800080 },
		.id = HEX_INS_A2_NOTP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = not()",
	},
	{
		// 10001000110sssssPP000000001ddddd | Rd = round(Rss):sat
		.encoding = { .mask = 0xffe03fe0, .op = 0x88c00020 },
		.id = HEX_INS_A2_ROUNDSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = round():sat",
	},
	{
		// 10001000110sssssPP000000000ddddd | Rd = sat(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88c00000 },
		.id = HEX_INS_A2_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sat()",
	},
	{
		// 10001100110sssssPP000000111ddddd | Rd = satb(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8cc000e0 },
		.id = HEX_INS_A2_SATB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = satb()",
	},
	{
		// 10001100110sssssPP000000100ddddd | Rd = sath(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8cc00080 },
		.id = HEX_INS_A2_SATH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sath()",
	},
	{
		// 10001100110sssssPP000000110ddddd | Rd = satub(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8cc000c0 },
		.id = HEX_INS_A2_SATUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = satub()",
	},
	{
		// 10001100110sssssPP000000101ddddd | Rd = satuh(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8cc000a0 },
		.id = HEX_INS_A2_SATUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = satuh()",
	},
	{
		// 10001100100sssssPP000000111ddddd | Rd = swiz(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8c8000e0 },
		.id = HEX_INS_A2_SWIZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = swiz()",
	},
	{
		// 10000100010sssssPP000000000ddddd | Rdd = sxtw(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x84400000 },
		.id = HEX_INS_A2_SXTW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtw()",
	},
	{
		// 10000000010sssssPP000000100ddddd | Rdd = vabsh(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x80400080 },
		.id = HEX_INS_A2_VABSH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vabsh()",
	},
	{
		// 10000000010sssssPP000000101ddddd | Rdd = vabsh(Rss):sat
		.encoding = { .mask = 0xffe03fe0, .op = 0x804000a0 },
		.id = HEX_INS_A2_VABSHSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vabsh():sat",
	},
	{
		// 10000000010sssssPP000000110ddddd | Rdd = vabsw(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x804000c0 },
		.id = HEX_INS_A2_VABSW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vabsw()",
	},
	{
		// 10000000010sssssPP000000111ddddd | Rdd = vabsw(Rss):sat
		.encoding = { .mask = 0xffe03fe0, .op = 0x804000e0 },
		.id = HEX_INS_A2_VABSWSAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vabsw():sat",
	},
	{
		// 10000000100sssssPP000000111ddddd | Rdd = vconj(Rss):sat
		.encoding = { .mask = 0xffe03fe0, .op = 0x808000e0 },
		.id = HEX_INS_A2_VCONJ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vconj():sat",
	},
	{
		// 10001000110sssssPP0iiiii100ddddd | Rdd = bitsplit(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x88c00080 },
		.id = HEX_INS_A4_BITSPLITI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = bitsplit(,)",
	},
	{
		// 10001100111sssssPP0iiiii000ddddd | Rd = cround(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8ce00000 },
		.id = HEX_INS_A4_CROUND_RI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = cround(,)",
	},
	{
		// 10001100111sssssPP0iiiii100ddddd | Rd = round(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8ce00080 },
		.id = HEX_INS_A4_ROUND_RI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = round(,)",
	},
	{
		// 10001100111sssssPP0iiiii110ddddd | Rd = round(Rs,Ii):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x8ce000c0 },
		.id = HEX_INS_A4_ROUND_RI_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = round(,):sat",
	},
	{
		// 10001000110sssssPP0iiiii101ddddd | Rd = clip(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x88c000a0 },
		.id = HEX_INS_A7_CLIP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = clip(,)",
	},
	{
		// 10001100111sssssPPiiiiii010ddddd | Rdd = cround(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x8ce00040 },
		.id = HEX_INS_A7_CROUNDD_RI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = cround(,)",
	},
	{
		// 10001000110sssssPP0iiiii110ddddd | Rdd = vclip(Rss,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x88c000c0 },
		.id = HEX_INS_A7_VCLIP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vclip(,)",
	},
	{
		// 10000101100sssssPPiiiiii000000dd | Pd = bitsclr(Rs,Ii)
		.encoding = { .mask = 0xffe000fc, .op = 0x85800000 },
		.id = HEX_INS_C2_BITSCLRI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = bitsclr(,)",
	},
	{
		// 1000011000000000PP0000tt000ddddd | Rdd = mask(Pt)
		.encoding = { .mask = 0xffff3ce0, .op = 0x86000000 },
		.id = HEX_INS_C2_MASK,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = mask()",
	},
	{
		// 10001001010000ssPP000000000ddddd | Rd = Ps
		.encoding = { .mask = 0xfffc3fe0, .op = 0x89400000 },
		.id = HEX_INS_C2_TFRPR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 10000101010sssssPP000000000000dd | Pd = Rs
		.encoding = { .mask = 0xffe03ffc, .op = 0x85400000 },
		.id = HEX_INS_C2_TFRRP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ",
	},
	{
		// 10001001000000ssPP0000tt000ddddd | Rd = vitpack(Ps,Pt)
		.encoding = { .mask = 0xfffc3ce0, .op = 0x89000000 },
		.id = HEX_INS_C2_VITPACK,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 16 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x2, 8 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vitpack(,)",
	},
	{
		// 10000101101sssssPPiiiiii000000dd | Pd = !bitsclr(Rs,Ii)
		.encoding = { .mask = 0xffe000fc, .op = 0x85a00000 },
		.id = HEX_INS_C4_NBITSCLRI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = !bitsclr(,)",
	},
	{
		// 10000000111sssssPP000000011ddddd | Rdd = convert_d2df(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x80e00060 },
		.id = HEX_INS_F2_CONV_D2DF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_D2df()",
	},
	{
		// 10001000010sssssPP000000001ddddd | Rd = convert_d2sf(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88400020 },
		.id = HEX_INS_F2_CONV_D2SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_D2sf()",
	},
	{
		// 10000000111sssssPP000000000ddddd | Rdd = convert_df2d(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x80e00000 },
		.id = HEX_INS_F2_CONV_DF2D,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_df2d()",
	},
	{
		// 10000000111sssssPP000000110ddddd | Rdd = convert_df2d(Rss):chop
		.encoding = { .mask = 0xffe03fe0, .op = 0x80e000c0 },
		.id = HEX_INS_F2_CONV_DF2D_CHOP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_df2d():chop",
	},
	{
		// 10001000000sssssPP000000001ddddd | Rd = convert_df2sf(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88000020 },
		.id = HEX_INS_F2_CONV_DF2SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_df2sf()",
	},
	{
		// 10000000111sssssPP000000001ddddd | Rdd = convert_df2ud(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x80e00020 },
		.id = HEX_INS_F2_CONV_DF2UD,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_df2ud()",
	},
	{
		// 10000000111sssssPP000000111ddddd | Rdd = convert_df2ud(Rss):chop
		.encoding = { .mask = 0xffe03fe0, .op = 0x80e000e0 },
		.id = HEX_INS_F2_CONV_DF2UD_CHOP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_df2ud():chop",
	},
	{
		// 10001000011sssssPP000000001ddddd | Rd = convert_df2uw(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88600020 },
		.id = HEX_INS_F2_CONV_DF2UW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_df2uw()",
	},
	{
		// 10001000101sssssPP000000001ddddd | Rd = convert_df2uw(Rss):chop
		.encoding = { .mask = 0xffe03fe0, .op = 0x88a00020 },
		.id = HEX_INS_F2_CONV_DF2UW_CHOP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_df2uw():chop",
	},
	{
		// 10001000100sssssPP000000001ddddd | Rd = convert_df2w(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88800020 },
		.id = HEX_INS_F2_CONV_DF2W,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_df2w()",
	},
	{
		// 10001000111sssssPP000000001ddddd | Rd = convert_df2w(Rss):chop
		.encoding = { .mask = 0xffe03fe0, .op = 0x88e00020 },
		.id = HEX_INS_F2_CONV_DF2W_CHOP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_df2w():chop",
	},
	{
		// 10000100100sssssPP000000100ddddd | Rdd = convert_sf2d(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x84800080 },
		.id = HEX_INS_F2_CONV_SF2D,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_sf2d()",
	},
	{
		// 10000100100sssssPP000000110ddddd | Rdd = convert_sf2d(Rs):chop
		.encoding = { .mask = 0xffe03fe0, .op = 0x848000c0 },
		.id = HEX_INS_F2_CONV_SF2D_CHOP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_sf2d():chop",
	},
	{
		// 10000100100sssssPP000000000ddddd | Rdd = convert_sf2df(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x84800000 },
		.id = HEX_INS_F2_CONV_SF2DF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_sf2df()",
	},
	{
		// 10000100100sssssPP000000011ddddd | Rdd = convert_sf2ud(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x84800060 },
		.id = HEX_INS_F2_CONV_SF2UD,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_sf2ud()",
	},
	{
		// 10000100100sssssPP000000101ddddd | Rdd = convert_sf2ud(Rs):chop
		.encoding = { .mask = 0xffe03fe0, .op = 0x848000a0 },
		.id = HEX_INS_F2_CONV_SF2UD_CHOP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_sf2ud():chop",
	},
	{
		// 10001011011sssssPP000000000ddddd | Rd = convert_sf2uw(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8b600000 },
		.id = HEX_INS_F2_CONV_SF2UW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_sf2uw()",
	},
	{
		// 10001011011sssssPP000000001ddddd | Rd = convert_sf2uw(Rs):chop
		.encoding = { .mask = 0xffe03fe0, .op = 0x8b600020 },
		.id = HEX_INS_F2_CONV_SF2UW_CHOP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_sf2uw():chop",
	},
	{
		// 10001011100sssssPP000000000ddddd | Rd = convert_sf2w(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8b800000 },
		.id = HEX_INS_F2_CONV_SF2W,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_sf2w()",
	},
	{
		// 10001011100sssssPP000000001ddddd | Rd = convert_sf2w(Rs):chop
		.encoding = { .mask = 0xffe03fe0, .op = 0x8b800020 },
		.id = HEX_INS_F2_CONV_SF2W_CHOP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_sf2w():chop",
	},
	{
		// 10000000111sssssPP000000010ddddd | Rdd = convert_ud2df(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x80e00040 },
		.id = HEX_INS_F2_CONV_UD2DF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_ud2df()",
	},
	{
		// 10001000001sssssPP000000001ddddd | Rd = convert_ud2sf(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88200020 },
		.id = HEX_INS_F2_CONV_UD2SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_ud2sf()",
	},
	{
		// 10000100100sssssPP000000001ddddd | Rdd = convert_uw2df(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x84800020 },
		.id = HEX_INS_F2_CONV_UW2DF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_uw2df()",
	},
	{
		// 10001011001sssssPP000000000ddddd | Rd = convert_uw2sf(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8b200000 },
		.id = HEX_INS_F2_CONV_UW2SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_uw2sf()",
	},
	{
		// 10000100100sssssPP000000010ddddd | Rdd = convert_w2df(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x84800040 },
		.id = HEX_INS_F2_CONV_W2DF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_W2df()",
	},
	{
		// 10001011010sssssPP000000000ddddd | Rd = convert_w2sf(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8b400000 },
		.id = HEX_INS_F2_CONV_W2SF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = convert_W2sf()",
	},
	{
		// 10000101111sssssPP0iiiii000000dd | Pd = sfclass(Rs,Ii)
		.encoding = { .mask = 0xffe020fc, .op = 0x85e00000 },
		.id = HEX_INS_F2_SFCLASS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sfclass(,)",
	},
	{
		// 10001011101sssssPP000000000ddddd | Rd = sffixupr(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8ba00000 },
		.id = HEX_INS_F2_SFFIXUPR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sffixupr()",
	},
	{
		// 10001011111sssssPP0000000eeddddd | Rd,Pe = sfinvsqrta(Rs)
		.encoding = { .mask = 0xffe03f80, .op = 0x8be00000 },
		.id = HEX_INS_F2_SFINVSQRTA,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 5 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 1 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = ", = sfinvsqrta()",
	},
	{
		// 10000000000sssssPPiiiiii010ddddd | Rdd = asl(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x80000040 },
		.id = HEX_INS_S2_ASL_I_P,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = asl(,)",
	},
	{
		// 10000010000sssssPPiiiiii110xxxxx | Rxx += asl(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x820000c0 },
		.id = HEX_INS_S2_ASL_I_P_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " += asl(,)",
	},
	{
		// 10000010010sssssPPiiiiii010xxxxx | Rxx &= asl(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x82400040 },
		.id = HEX_INS_S2_ASL_I_P_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= asl(,)",
	},
	{
		// 10000010000sssssPPiiiiii010xxxxx | Rxx -= asl(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x82000040 },
		.id = HEX_INS_S2_ASL_I_P_NAC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " -= asl(,)",
	},
	{
		// 10000010010sssssPPiiiiii110xxxxx | Rxx |= asl(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x824000c0 },
		.id = HEX_INS_S2_ASL_I_P_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= asl(,)",
	},
	{
		// 10000010100sssssPPiiiiii010xxxxx | Rxx ^= asl(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x82800040 },
		.id = HEX_INS_S2_ASL_I_P_XACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= asl(,)",
	},
	{
		// 10001100000sssssPP0iiiii010ddddd | Rd = asl(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8c000040 },
		.id = HEX_INS_S2_ASL_I_R,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = asl(,)",
	},
	{
		// 10001110000sssssPP0iiiii110xxxxx | Rx += asl(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e0000c0 },
		.id = HEX_INS_S2_ASL_I_R_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " += asl(,)",
	},
	{
		// 10001110010sssssPP0iiiii010xxxxx | Rx &= asl(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e400040 },
		.id = HEX_INS_S2_ASL_I_R_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= asl(,)",
	},
	{
		// 10001110000sssssPP0iiiii010xxxxx | Rx -= asl(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e000040 },
		.id = HEX_INS_S2_ASL_I_R_NAC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " -= asl(,)",
	},
	{
		// 10001110010sssssPP0iiiii110xxxxx | Rx |= asl(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e4000c0 },
		.id = HEX_INS_S2_ASL_I_R_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= asl(,)",
	},
	{
		// 10001100010sssssPP0iiiii010ddddd | Rd = asl(Rs,Ii):sat
		.encoding = { .mask = 0xffe020e0, .op = 0x8c400040 },
		.id = HEX_INS_S2_ASL_I_R_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = asl(,):sat",
	},
	{
		// 10001110100sssssPP0iiiii010xxxxx | Rx ^= asl(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e800040 },
		.id = HEX_INS_S2_ASL_I_R_XACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= asl(,)",
	},
	{
		// 10000000100sssssPP00iiii010ddddd | Rdd = vaslh(Rss,Ii)
		.encoding = { .mask = 0xffe030e0, .op = 0x80800040 },
		.id = HEX_INS_S2_ASL_I_VH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vaslh(,)",
	},
	{
		// 10000000010sssssPP0iiiii010ddddd | Rdd = vaslw(Rss,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x80400040 },
		.id = HEX_INS_S2_ASL_I_VW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vaslw(,)",
	},
	{
		// 10000000000sssssPPiiiiii000ddddd | Rdd = asr(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x80000000 },
		.id = HEX_INS_S2_ASR_I_P,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = asr(,)",
	},
	{
		// 10000010000sssssPPiiiiii100xxxxx | Rxx += asr(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x82000080 },
		.id = HEX_INS_S2_ASR_I_P_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " += asr(,)",
	},
	{
		// 10000010010sssssPPiiiiii000xxxxx | Rxx &= asr(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x82400000 },
		.id = HEX_INS_S2_ASR_I_P_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= asr(,)",
	},
	{
		// 10000010000sssssPPiiiiii000xxxxx | Rxx -= asr(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x82000000 },
		.id = HEX_INS_S2_ASR_I_P_NAC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " -= asr(,)",
	},
	{
		// 10000010010sssssPPiiiiii100xxxxx | Rxx |= asr(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x82400080 },
		.id = HEX_INS_S2_ASR_I_P_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= asr(,)",
	},
	{
		// 10000000110sssssPPiiiiii111ddddd | Rdd = asr(Rss,Ii):rnd
		.encoding = { .mask = 0xffe000e0, .op = 0x80c000e0 },
		.id = HEX_INS_S2_ASR_I_P_RND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = asr(,):rnd",
	},
	{
		// 10001100000sssssPP0iiiii000ddddd | Rd = asr(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8c000000 },
		.id = HEX_INS_S2_ASR_I_R,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = asr(,)",
	},
	{
		// 10001110000sssssPP0iiiii100xxxxx | Rx += asr(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e000080 },
		.id = HEX_INS_S2_ASR_I_R_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " += asr(,)",
	},
	{
		// 10001110010sssssPP0iiiii000xxxxx | Rx &= asr(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e400000 },
		.id = HEX_INS_S2_ASR_I_R_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= asr(,)",
	},
	{
		// 10001110000sssssPP0iiiii000xxxxx | Rx -= asr(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e000000 },
		.id = HEX_INS_S2_ASR_I_R_NAC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " -= asr(,)",
	},
	{
		// 10001110010sssssPP0iiiii100xxxxx | Rx |= asr(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e400080 },
		.id = HEX_INS_S2_ASR_I_R_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= asr(,)",
	},
	{
		// 10001100010sssssPP0iiiii000ddddd | Rd = asr(Rs,Ii):rnd
		.encoding = { .mask = 0xffe020e0, .op = 0x8c400000 },
		.id = HEX_INS_S2_ASR_I_R_RND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = asr(,):rnd",
	},
	{
		// 10001000110sssssPP0iiiii010ddddd | Rd = vasrw(Rss,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x88c00040 },
		.id = HEX_INS_S2_ASR_I_SVW_TRUN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vasrw(,)",
	},
	{
		// 10000000100sssssPP00iiii000ddddd | Rdd = vasrh(Rss,Ii)
		.encoding = { .mask = 0xffe030e0, .op = 0x80800000 },
		.id = HEX_INS_S2_ASR_I_VH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vasrh(,)",
	},
	{
		// 10000000010sssssPP0iiiii000ddddd | Rdd = vasrw(Rss,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x80400000 },
		.id = HEX_INS_S2_ASR_I_VW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vasrw(,)",
	},
	{
		// 10001100010sssssPP000000110ddddd | Rd = brev(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8c4000c0 },
		.id = HEX_INS_S2_BREV,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = brev()",
	},
	{
		// 10000000110sssssPP000000110ddddd | Rdd = brev(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x80c000c0 },
		.id = HEX_INS_S2_BREVP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = brev()",
	},
	{
		// 10001100000sssssPP000000101ddddd | Rd = cl0(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8c0000a0 },
		.id = HEX_INS_S2_CL0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = cl0()",
	},
	{
		// 10001000010sssssPP000000010ddddd | Rd = cl0(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88400040 },
		.id = HEX_INS_S2_CL0P,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = cl0()",
	},
	{
		// 10001100000sssssPP000000110ddddd | Rd = cl1(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8c0000c0 },
		.id = HEX_INS_S2_CL1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = cl1()",
	},
	{
		// 10001000010sssssPP000000100ddddd | Rd = cl1(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88400080 },
		.id = HEX_INS_S2_CL1P,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = cl1()",
	},
	{
		// 10001100000sssssPP000000100ddddd | Rd = clb(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8c000080 },
		.id = HEX_INS_S2_CLB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = clb()",
	},
	{
		// 10001100000sssssPP000000111ddddd | Rd = normamt(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8c0000e0 },
		.id = HEX_INS_S2_CLBNORM,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = normamt()",
	},
	{
		// 10001000010sssssPP000000000ddddd | Rd = clb(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88400000 },
		.id = HEX_INS_S2_CLBP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = clb()",
	},
	{
		// 10001100110sssssPP0iiiii001ddddd | Rd = clrbit(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8cc00020 },
		.id = HEX_INS_S2_CLRBIT_I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = clrbit(,)",
	},
	{
		// 10001100010sssssPP000000100ddddd | Rd = ct0(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8c400080 },
		.id = HEX_INS_S2_CT0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ct0()",
	},
	{
		// 10001000111sssssPP000000010ddddd | Rd = ct0(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88e00040 },
		.id = HEX_INS_S2_CT0P,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ct0()",
	},
	{
		// 10001100010sssssPP000000101ddddd | Rd = ct1(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8c4000a0 },
		.id = HEX_INS_S2_CT1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ct1()",
	},
	{
		// 10001000111sssssPP000000100ddddd | Rd = ct1(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88e00080 },
		.id = HEX_INS_S2_CT1P,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = ct1()",
	},
	{
		// 10000000110sssssPP000000100ddddd | Rdd = deinterleave(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x80c00080 },
		.id = HEX_INS_S2_DEINTERLEAVE,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = deinterleave()",
	},
	{
		// 100011010IIsssssPP0iiiiiIIIddddd | Rd = extractu(Rs,Ii,II)
		.encoding = { .mask = 0xff802000, .op = 0x8d000000 },
		.id = HEX_INS_S2_EXTRACTU,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 5 }, { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = extractu(,,)",
	},
	{
		// 10000001IIIsssssPPiiiiiiIIIddddd | Rdd = extractu(Rss,Ii,II)
		.encoding = { .mask = 0xff000000, .op = 0x81000000 },
		.id = HEX_INS_S2_EXTRACTUP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 8 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 5 }, { 0x3, 21 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = extractu(,,)",
	},
	{
		// 100011110IIsssssPP0iiiiiIIIxxxxx | Rx = insert(Rs,Ii,II)
		.encoding = { .mask = 0xff802000, .op = 0x8f000000 },
		.id = HEX_INS_S2_INSERT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 5 }, { 0x2, 21 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = insert(,,)",
	},
	{
		// 10000011IIIsssssPPiiiiiiIIIxxxxx | Rxx = insert(Rss,Ii,II)
		.encoding = { .mask = 0xff000000, .op = 0x83000000 },
		.id = HEX_INS_S2_INSERTP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 8 } }, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 5 }, { 0x3, 21 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = insert(,,)",
	},
	{
		// 10000000110sssssPP000000101ddddd | Rdd = interleave(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x80c000a0 },
		.id = HEX_INS_S2_INTERLEAVE,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = interleave()",
	},
	{
		// 10000000000sssssPPiiiiii001ddddd | Rdd = lsr(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x80000020 },
		.id = HEX_INS_S2_LSR_I_P,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = lsr(,)",
	},
	{
		// 10000010000sssssPPiiiiii101xxxxx | Rxx += lsr(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x820000a0 },
		.id = HEX_INS_S2_LSR_I_P_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " += lsr(,)",
	},
	{
		// 10000010010sssssPPiiiiii001xxxxx | Rxx &= lsr(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x82400020 },
		.id = HEX_INS_S2_LSR_I_P_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= lsr(,)",
	},
	{
		// 10000010000sssssPPiiiiii001xxxxx | Rxx -= lsr(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x82000020 },
		.id = HEX_INS_S2_LSR_I_P_NAC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " -= lsr(,)",
	},
	{
		// 10000010010sssssPPiiiiii101xxxxx | Rxx |= lsr(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x824000a0 },
		.id = HEX_INS_S2_LSR_I_P_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= lsr(,)",
	},
	{
		// 10000010100sssssPPiiiiii001xxxxx | Rxx ^= lsr(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x82800020 },
		.id = HEX_INS_S2_LSR_I_P_XACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= lsr(,)",
	},
	{
		// 10001100000sssssPP0iiiii001ddddd | Rd = lsr(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8c000020 },
		.id = HEX_INS_S2_LSR_I_R,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = lsr(,)",
	},
	{
		// 10001110000sssssPP0iiiii101xxxxx | Rx += lsr(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e0000a0 },
		.id = HEX_INS_S2_LSR_I_R_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " += lsr(,)",
	},
	{
		// 10001110010sssssPP0iiiii001xxxxx | Rx &= lsr(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e400020 },
		.id = HEX_INS_S2_LSR_I_R_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= lsr(,)",
	},
	{
		// 10001110000sssssPP0iiiii001xxxxx | Rx -= lsr(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e000020 },
		.id = HEX_INS_S2_LSR_I_R_NAC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " -= lsr(,)",
	},
	{
		// 10001110010sssssPP0iiiii101xxxxx | Rx |= lsr(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e4000a0 },
		.id = HEX_INS_S2_LSR_I_R_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= lsr(,)",
	},
	{
		// 10001110100sssssPP0iiiii001xxxxx | Rx ^= lsr(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e800020 },
		.id = HEX_INS_S2_LSR_I_R_XACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= lsr(,)",
	},
	{
		// 10000000100sssssPP00iiii001ddddd | Rdd = vlsrh(Rss,Ii)
		.encoding = { .mask = 0xffe030e0, .op = 0x80800020 },
		.id = HEX_INS_S2_LSR_I_VH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vlsrh(,)",
	},
	{
		// 10000000010sssssPP0iiiii001ddddd | Rdd = vlsrw(Rss,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x80400020 },
		.id = HEX_INS_S2_LSR_I_VW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vlsrw(,)",
	},
	{
		// 100011010II00000PP1iiiiiIIIddddd | Rd = mask(Ii,II)
		.encoding = { .mask = 0xff9f2000, .op = 0x8d002000 },
		.id = HEX_INS_S2_MASK,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 5 }, { 0x2, 21 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = mask(,)",
	},
	{
		// 10001100110sssssPP0iiiii000ddddd | Rd = setbit(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8cc00000 },
		.id = HEX_INS_S2_SETBIT_I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = setbit(,)",
	},
	{
		// 10001100100sssssPP000000000ddddd | Rd = vsathb(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8c800000 },
		.id = HEX_INS_S2_SVSATHB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsathb()",
	},
	{
		// 10001100100sssssPP000000010ddddd | Rd = vsathub(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8c800040 },
		.id = HEX_INS_S2_SVSATHUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsathub()",
	},
	{
		// 1000011100isssssPPIIIIIIiiixxxxx | Rx = tableidxb(Rs,Ii,II):raw
		.encoding = { .mask = 0xffc00000, .op = 0x87000000 },
		.id = HEX_INS_S2_TABLEIDXB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 5 }, { 0x1, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 8 } }, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = tableidxb(,,):raw",
	},
	{
		// 1000011111isssssPPIIIIIIiiixxxxx | Rx = tableidxd(Rs,Ii,II):raw
		.encoding = { .mask = 0xffc00000, .op = 0x87c00000 },
		.id = HEX_INS_S2_TABLEIDXD,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 5 }, { 0x1, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 8 } }, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = tableidxd(,,):raw",
	},
	{
		// 1000011101isssssPPIIIIIIiiixxxxx | Rx = tableidxh(Rs,Ii,II):raw
		.encoding = { .mask = 0xffc00000, .op = 0x87400000 },
		.id = HEX_INS_S2_TABLEIDXH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 5 }, { 0x1, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 8 } }, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = tableidxh(,,):raw",
	},
	{
		// 1000011110isssssPPIIIIIIiiixxxxx | Rx = tableidxw(Rs,Ii,II):raw
		.encoding = { .mask = 0xffc00000, .op = 0x87800000 },
		.id = HEX_INS_S2_TABLEIDXW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 5 }, { 0x1, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 8 } }, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = tableidxw(,,):raw",
	},
	{
		// 10001100110sssssPP0iiiii010ddddd | Rd = togglebit(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8cc00040 },
		.id = HEX_INS_S2_TOGGLEBIT_I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = togglebit(,)",
	},
	{
		// 10000101000sssssPP0iiiii000000dd | Pd = tstbit(Rs,Ii)
		.encoding = { .mask = 0xffe020fc, .op = 0x85000000 },
		.id = HEX_INS_S2_TSTBIT_I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = tstbit(,)",
	},
	{
		// 10001000100sssssPP000000100ddddd | Rd = vrndwh(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88800080 },
		.id = HEX_INS_S2_VRNDPACKWH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vrndwh()",
	},
	{
		// 10001000100sssssPP000000110ddddd | Rd = vrndwh(Rss):sat
		.encoding = { .mask = 0xffe03fe0, .op = 0x888000c0 },
		.id = HEX_INS_S2_VRNDPACKWHS,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vrndwh():sat",
	},
	{
		// 10001000000sssssPP000000110ddddd | Rd = vsathb(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x880000c0 },
		.id = HEX_INS_S2_VSATHB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsathb()",
	},
	{
		// 10000000000sssssPP000000111ddddd | Rdd = vsathb(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x800000e0 },
		.id = HEX_INS_S2_VSATHB_NOPACK,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsathb()",
	},
	{
		// 10001000000sssssPP000000000ddddd | Rd = vsathub(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88000000 },
		.id = HEX_INS_S2_VSATHUB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsathub()",
	},
	{
		// 10000000000sssssPP000000100ddddd | Rdd = vsathub(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x80000080 },
		.id = HEX_INS_S2_VSATHUB_NOPACK,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsathub()",
	},
	{
		// 10001000000sssssPP000000010ddddd | Rd = vsatwh(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88000040 },
		.id = HEX_INS_S2_VSATWH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsatwh()",
	},
	{
		// 10000000000sssssPP000000110ddddd | Rdd = vsatwh(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x800000c0 },
		.id = HEX_INS_S2_VSATWH_NOPACK,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsatwh()",
	},
	{
		// 10001000000sssssPP000000100ddddd | Rd = vsatwuh(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88000080 },
		.id = HEX_INS_S2_VSATWUH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsatwuh()",
	},
	{
		// 10000000000sssssPP000000101ddddd | Rdd = vsatwuh(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x800000a0 },
		.id = HEX_INS_S2_VSATWUH_NOPACK,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsatwuh()",
	},
	{
		// 10001100010sssssPP000000111ddddd | Rd = vsplatb(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x8c4000e0 },
		.id = HEX_INS_S2_VSPLATRB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsplatb()",
	},
	{
		// 10000100010sssssPP000000010ddddd | Rdd = vsplath(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x84400040 },
		.id = HEX_INS_S2_VSPLATRH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsplath()",
	},
	{
		// 10000100000sssssPP000000000ddddd | Rdd = vsxtbh(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x84000000 },
		.id = HEX_INS_S2_VSXTBH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsxtbh()",
	},
	{
		// 10000100000sssssPP000000100ddddd | Rdd = vsxthw(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x84000080 },
		.id = HEX_INS_S2_VSXTHW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsxthw()",
	},
	{
		// 10001000100sssssPP000000010ddddd | Rd = vtrunehb(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88800040 },
		.id = HEX_INS_S2_VTRUNEHB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vtrunehb()",
	},
	{
		// 10001000100sssssPP000000000ddddd | Rd = vtrunohb(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88800000 },
		.id = HEX_INS_S2_VTRUNOHB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vtrunohb()",
	},
	{
		// 10000100000sssssPP000000010ddddd | Rdd = vzxtbh(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x84000040 },
		.id = HEX_INS_S2_VZXTBH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vzxtbh()",
	},
	{
		// 10000100000sssssPP000000110ddddd | Rdd = vzxthw(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x840000c0 },
		.id = HEX_INS_S2_VZXTHW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vzxthw()",
	},
	{
		// 10001100001sssssPPiiiiii000ddddd | Rd = add(clb(Rs),Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x8c200000 },
		.id = HEX_INS_S4_CLBADDI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(clb(),)",
	},
	{
		// 10001000011sssssPPiiiiii010ddddd | Rd = add(clb(Rss),Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x88600040 },
		.id = HEX_INS_S4_CLBPADDI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(clb(),)",
	},
	{
		// 10001000011sssssPP000000000ddddd | Rd = normamt(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88600000 },
		.id = HEX_INS_S4_CLBPNORM,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = normamt()",
	},
	{
		// 100011011IIsssssPP0iiiiiIIIddddd | Rd = extract(Rs,Ii,II)
		.encoding = { .mask = 0xff802000, .op = 0x8d800000 },
		.id = HEX_INS_S4_EXTRACT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 8 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 5 }, { 0x2, 21 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = extract(,,)",
	},
	{
		// 10001010IIIsssssPPiiiiiiIIIddddd | Rdd = extract(Rss,Ii,II)
		.encoding = { .mask = 0xff000000, .op = 0x8a000000 },
		.id = HEX_INS_S4_EXTRACTP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 8 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 5 }, { 0x3, 21 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = extract(,,)",
	},
	{
		// 10000101001sssssPP0iiiii000000dd | Pd = !tstbit(Rs,Ii)
		.encoding = { .mask = 0xffe020fc, .op = 0x85200000 },
		.id = HEX_INS_S4_NTSTBIT_I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x2, 0 } }, .reg_cls = HEX_REG_CLASS_PRED_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = !tstbit(,)",
	},
	{
		// 10001000011sssssPP00iiii100ddddd | Rd = vasrhub(Rss,Ii):raw
		.encoding = { .mask = 0xffe030e0, .op = 0x88600080 },
		.id = HEX_INS_S5_ASRHUB_RND_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vasrhub(,):raw",
	},
	{
		// 10001000011sssssPP00iiii101ddddd | Rd = vasrhub(Rss,Ii):sat
		.encoding = { .mask = 0xffe030e0, .op = 0x886000a0 },
		.id = HEX_INS_S5_ASRHUB_SAT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vasrhub(,):sat",
	},
	{
		// 10001000011sssssPP000000011ddddd | Rd = popcount(Rss)
		.encoding = { .mask = 0xffe03fe0, .op = 0x88600060 },
		.id = HEX_INS_S5_POPCOUNTP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = popcount()",
	},
	{
		// 10000000001sssssPP00iiii000ddddd | Rdd = vasrh(Rss,Ii):raw
		.encoding = { .mask = 0xffe030e0, .op = 0x80200000 },
		.id = HEX_INS_S5_VASRHRND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vasrh(,):raw",
	},
	{
		// 10000000000sssssPPiiiiii011ddddd | Rdd = rol(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x80000060 },
		.id = HEX_INS_S6_ROL_I_P,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = rol(,)",
	},
	{
		// 10000010000sssssPPiiiiii111xxxxx | Rxx += rol(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x820000e0 },
		.id = HEX_INS_S6_ROL_I_P_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " += rol(,)",
	},
	{
		// 10000010010sssssPPiiiiii011xxxxx | Rxx &= rol(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x82400060 },
		.id = HEX_INS_S6_ROL_I_P_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= rol(,)",
	},
	{
		// 10000010000sssssPPiiiiii011xxxxx | Rxx -= rol(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x82000060 },
		.id = HEX_INS_S6_ROL_I_P_NAC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " -= rol(,)",
	},
	{
		// 10000010010sssssPPiiiiii111xxxxx | Rxx |= rol(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x824000e0 },
		.id = HEX_INS_S6_ROL_I_P_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= rol(,)",
	},
	{
		// 10000010100sssssPPiiiiii011xxxxx | Rxx ^= rol(Rss,Ii)
		.encoding = { .mask = 0xffe000e0, .op = 0x82800060 },
		.id = HEX_INS_S6_ROL_I_P_XACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= rol(,)",
	},
	{
		// 10001100000sssssPP0iiiii011ddddd | Rd = rol(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8c000060 },
		.id = HEX_INS_S6_ROL_I_R,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = rol(,)",
	},
	{
		// 10001110000sssssPP0iiiii111xxxxx | Rx += rol(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e0000e0 },
		.id = HEX_INS_S6_ROL_I_R_ACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " += rol(,)",
	},
	{
		// 10001110010sssssPP0iiiii011xxxxx | Rx &= rol(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e400060 },
		.id = HEX_INS_S6_ROL_I_R_AND,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " &= rol(,)",
	},
	{
		// 10001110000sssssPP0iiiii011xxxxx | Rx -= rol(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e000060 },
		.id = HEX_INS_S6_ROL_I_R_NAC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " -= rol(,)",
	},
	{
		// 10001110010sssssPP0iiiii111xxxxx | Rx |= rol(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e4000e0 },
		.id = HEX_INS_S6_ROL_I_R_OR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " |= rol(,)",
	},
	{
		// 10001110100sssssPP0iiiii011xxxxx | Rx ^= rol(Rs,Ii)
		.encoding = { .mask = 0xffe020e0, .op = 0x8e800060 },
		.id = HEX_INS_S6_ROL_I_R_XACC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 8 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " ^= rol(,)",
	},
	{
		// 10000100010sssssPP000000100ddddd | Rdd = vsplatb(Rs)
		.encoding = { .mask = 0xffe03fe0, .op = 0x84400080 },
		.id = HEX_INS_S6_VSPLATRBP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = vsplatb()",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_normal_0x9[] = {
	{
		// 10010000000sssssPP000000000ddddd | Rdd = deallocframe(Rs):raw
		.encoding = { .mask = 0xffe03fe0, .op = 0x90000000 },
		.id = HEX_INS_L2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = deallocframe():raw",
	},
	{
		// 10010ii0100sssssPPiiiiiiiiiyyyyy | Ryy = memb_fifo(Rs+Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x90800000 },
		.id = HEX_INS_L2_LOADALIGNB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x2, 25 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb_fifo(+)",
	},
	{
		// 10011110100xxxxxPPu00000000yyyyy | Ryy = memb_fifo(Rx++Mu:brev)
		.encoding = { .mask = 0xffe01fe0, .op = 0x9e800000 },
		.id = HEX_INS_L2_LOADALIGNB_PBR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb_fifo(++:brev)",
	},
	{
		// 10011000100xxxxxPPu0000iiiiyyyyy | Ryy = memb_fifo(Rx++Ii:circ(Mu))
		.encoding = { .mask = 0xffe01e00, .op = 0x98800000 },
		.id = HEX_INS_L2_LOADALIGNB_PCI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 5 } }, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb_fifo(++:circ())",
	},
	{
		// 10011000100xxxxxPPu00010000yyyyy | Ryy = memb_fifo(Rx++I:circ(Mu))
		.encoding = { .mask = 0xffe01fe0, .op = 0x98800200 },
		.id = HEX_INS_L2_LOADALIGNB_PCR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb_fifo(++I:circ())",
	},
	{
		// 10011010100xxxxxPP00000iiiiyyyyy | Ryy = memb_fifo(Rx++Ii)
		.encoding = { .mask = 0xffe03e00, .op = 0x9a800000 },
		.id = HEX_INS_L2_LOADALIGNB_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 5 } }, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb_fifo(++)",
	},
	{
		// 10011100100xxxxxPPu00000000yyyyy | Ryy = memb_fifo(Rx++Mu)
		.encoding = { .mask = 0xffe01fe0, .op = 0x9c800000 },
		.id = HEX_INS_L2_LOADALIGNB_PR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb_fifo(++)",
	},
	{
		// 10010ii0010sssssPPiiiiiiiiiyyyyy | Ryy = memh_fifo(Rs+Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x90400000 },
		.id = HEX_INS_L2_LOADALIGNH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x2, 25 } }, .imm_scale = 1, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh_fifo(+)",
	},
	{
		// 10011110010xxxxxPPu00000000yyyyy | Ryy = memh_fifo(Rx++Mu:brev)
		.encoding = { .mask = 0xffe01fe0, .op = 0x9e400000 },
		.id = HEX_INS_L2_LOADALIGNH_PBR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh_fifo(++:brev)",
	},
	{
		// 10011000010xxxxxPPu0000iiiiyyyyy | Ryy = memh_fifo(Rx++Ii:circ(Mu))
		.encoding = { .mask = 0xffe01e00, .op = 0x98400000 },
		.id = HEX_INS_L2_LOADALIGNH_PCI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 5 } }, .imm_scale = 1, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh_fifo(++:circ())",
	},
	{
		// 10011000010xxxxxPPu00010000yyyyy | Ryy = memh_fifo(Rx++I:circ(Mu))
		.encoding = { .mask = 0xffe01fe0, .op = 0x98400200 },
		.id = HEX_INS_L2_LOADALIGNH_PCR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh_fifo(++I:circ())",
	},
	{
		// 10011010010xxxxxPP00000iiiiyyyyy | Ryy = memh_fifo(Rx++Ii)
		.encoding = { .mask = 0xffe03e00, .op = 0x9a400000 },
		.id = HEX_INS_L2_LOADALIGNH_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 5 } }, .imm_scale = 1, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh_fifo(++)",
	},
	{
		// 10011100010xxxxxPPu00000000yyyyy | Ryy = memh_fifo(Rx++Mu)
		.encoding = { .mask = 0xffe01fe0, .op = 0x9c400000 },
		.id = HEX_INS_L2_LOADALIGNH_PR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh_fifo(++)",
	},
	{
		// 10010ii0001sssssPPiiiiiiiiiddddd | Rd = membh(Rs+Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x90200000 },
		.id = HEX_INS_L2_LOADBSW2_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x2, 25 } }, .imm_scale = 1, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = membh(+)",
	},
	{
		// 10011110001xxxxxPPu00000000ddddd | Rd = membh(Rx++Mu:brev)
		.encoding = { .mask = 0xffe01fe0, .op = 0x9e200000 },
		.id = HEX_INS_L2_LOADBSW2_PBR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = membh(++:brev)",
	},
	{
		// 10011000001xxxxxPPu0000iiiiddddd | Rd = membh(Rx++Ii:circ(Mu))
		.encoding = { .mask = 0xffe01e00, .op = 0x98200000 },
		.id = HEX_INS_L2_LOADBSW2_PCI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 5 } }, .imm_scale = 1, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = membh(++:circ())",
	},
	{
		// 10011000001xxxxxPPu00010000ddddd | Rd = membh(Rx++I:circ(Mu))
		.encoding = { .mask = 0xffe01fe0, .op = 0x98200200 },
		.id = HEX_INS_L2_LOADBSW2_PCR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = membh(++I:circ())",
	},
	{
		// 10011010001xxxxxPP00000iiiiddddd | Rd = membh(Rx++Ii)
		.encoding = { .mask = 0xffe03e00, .op = 0x9a200000 },
		.id = HEX_INS_L2_LOADBSW2_PI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 5 } }, .imm_scale = 1, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = membh(++)",
	},
	{
		// 10011100001xxxxxPPu00000000ddddd | Rd = membh(Rx++Mu)
		.encoding = { .mask = 0xffe01fe0, .op = 0x9c200000 },
		.id = HEX_INS_L2_LOADBSW2_PR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = membh(++)",
	},
	{
		// 10010ii0111sssssPPiiiiiiiiiddddd | Rdd = membh(Rs+Ii)
		.encoding = { .mask = 0xf9e00000, .op = 0x90e00000 },
		.id = HEX_INS_L2_LOADBSW4_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x9, 5 }, { 0x2, 25 } }, .imm_scale = 2, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = membh(+)",
	},
	{
		// 10011110111xxxxxPPu00000000ddddd | Rdd = membh(Rx++Mu:brev)
		.encoding = { .mask = 0xffe01fe0, .op = 0x9ee00000 },
		.id = HEX_INS_L2_LOADBSW4_PBR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = membh(++:brev)",
	},
	{
		// 10011000111xxxxxPPu0000iiiiddddd | Rdd = membh(Rx++Ii:circ(Mu))
		.encoding = { .mask = 0xffe01e00, .op = 0x98e00000 },
		.id = HEX_INS_L2_LOADBSW4_PCI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 5 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = membh(++:circ())",
	},
	{
		// 10011000111xxxxxPPu00010000ddddd | Rdd = membh(Rx++I:circ(Mu))
		.encoding = { .mask = 0xffe01fe0, .op = 0x98e00200 },
		.id = HEX_INS_L2_LOADBSW4_PCR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x5, 0 } }, .reg_cls = HEX_REG_CLASS_DOUBLE_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x5, 16 } }, .reg_cls = HEX_REG_CLASS_INT_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x1, 13 } }, .reg_cls = HEX_REG_CLASS_MOD_REGS, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = membh(++I:circ())",