// SPDX-FileCopyrightText: 2023 RizinOrg <info@rizin.re>
// SPDX-License-Identifier: LGPL-3.0-only

#include "minunit.h"

mu_demangle_tests(borland,
#if 0
	// these are some weird c++ encodings.
	// we will skip them.
	mu_demangle_test("@%foo_enum$6MyEnum$i1$%$qv$v", "void foo_enum<(MyEnum)1>(void)"),
	mu_demangle_test("@%foo_int$i$i-1$%$qv$v", "void foo_int<-1>(void)"),
	mu_demangle_test("@%foo_int$i$i1$%$qv$v", "void foo_int<1>(void)"),
	mu_demangle_test("@foo4$qpqv$pqpi$v", "foo4(void (*(*)(void))(int *))"),
	mu_demangle_test("@foo5$qpxpqv$vpxpqv$v", "foo5(void (* const(*))(void), void (* const(*))(void))"),
	mu_demangle_test("@foo6$qpqv$pqpi$pqpd$v", "foo6(void (*(*(*)(void))(int *))(double *))"),
	mu_demangle_test("@Unit1@foo_AnsiString_$qqr27System@%AnsiStringT$us$i0$%", "__fastcall Unit1::foo_AnsiString_(System::AnsiStringT<0>)"),
	mu_demangle_test("@Unit1@foo_RawByteString_$qqr31System@%AnsiStringT$us$i65535$%", "__fastcall Unit1::foo_RawByteString_(System::AnsiStringT<65535>)"),
	mu_demangle_test("@Unit1@foo_ShortString_$qqrr29System@%SmallString$uc$i255$%", "__fastcall Unit1::foo_ShortString_(System::SmallString<255> &)"),
	mu_demangle_test("@Unit1@foo_UTF8String_$qqr31System@%AnsiStringT$us$i65001$%", "__fastcall Unit1::foo_UTF8String_(System::AnsiStringT<65001>)"),
#endif
	// must succeeds
	mu_demangle_test("@$badd$q3Bart1", "operator+(Bar, Bar)"),
	mu_demangle_test("@%$badd$3Bar%$q3Bart1$3Bar", "Bar operator+<Bar>(Bar, Bar)"),
	mu_demangle_test("@%adder$iVii%$qiii$i", "int adder<int, int, int>(int, int, int)"),
	mu_demangle_test("@%foo$60std@%basic_string$c19std@%char_traits$c%17std@%allocator$c%%%$q60std@%basic_string$c19std@%char_traits$c%17std@%allocator$c%%$v", "void foo<std::basic_string<char, std::char_traits<char>, std::allocator<char>>>(std::basic_string<char, std::char_traits<char>, std::allocator<char>>)"),
	mu_demangle_test("@%foo$60std@%basic_string$c19std@%char_traits$c%17std@%allocator$c%%t1%$qv$v", "void foo<std::basic_string<char, std::char_traits<char>, std::allocator<char>>, std::basic_string<char, std::char_traits<char>, std::allocator<char>>>(void)"),
	mu_demangle_test("@%foo$N%$qN$v", "void foo<nullptr_t>(nullptr_t)"),
	mu_demangle_test("@%foo2$20std@%basic_string$c%i%$qv$v", "void foo2<std::basic_string<char>, int>(void)"),
	mu_demangle_test("@%foo2$32std@%basic_string$c10%my_tmp$c%%i%$qv$v", "void foo2<std::basic_string<char, my_tmp<char>>, int>(void)"),
	mu_demangle_test("@%foo2$60std@%basic_string$c19std@%char_traits$c%17std@%allocator$c%%i%$qv$v", "void foo2<std::basic_string<char, std::char_traits<char>, std::allocator<char>>, int>(void)"),
	mu_demangle_test("@%myFunc_template_$i%$qi$d", "double myFunc_template_<int>(int)"),
	mu_demangle_test("@bar$q4Foo14Foo24Foo34Foo44Foo54Foo64Foo74Foo84Foo95Foo105Foo115Foo125Foo135Foo145Foo155Foo165Foo175Foo185Foo19tftgtht1tjta", "bar(Foo1, Foo2, Foo3, Foo4, Foo5, Foo6, Foo7, Foo8, Foo9, Foo10, Foo11, Foo12, Foo13, Foo14, Foo15, Foo16, Foo17, Foo18, Foo19, Foo15, Foo16, Foo17, Foo1, Foo19, Foo10)"),
	mu_demangle_test("@bar@%f$i%$qii$d", "double bar::f<int>(int, int)"),
	mu_demangle_test("@bar@foo$qi", "bar::foo(int)"),
	mu_demangle_test("@Bar@foo$wxqqrv", "__fastcall Bar::foo(void) volatile const"),
	mu_demangle_test("@Bar@foo7$xqv", "Bar::foo7(void) const"),
	mu_demangle_test("@Bar@foo8$wqv", "Bar::foo8(void) volatile"),
	mu_demangle_test("@Bar@foo9$wxqv", "Bar::foo9(void) volatile const"),
	mu_demangle_test("@Baz@foo$qd", "Baz::foo(double)"),
	mu_demangle_test("@Dateutils@TryRecodeDateTime$qqrx16System@TDateTimexusxusxusxusxusxusxusr16System@TDateTime", "__fastcall Dateutils::TryRecodeDateTime(const System::TDateTime, const unsigned short, const unsigned short, const unsigned short, const unsigned short, const unsigned short, const unsigned short, const unsigned short, System::TDateTime &)"),
	mu_demangle_test("@Dbxmysqlmetadatareader@TDBXMySqlCustomMetaDataReader@TDBXMySql4IndexesCursor@FindStringSize$qqrxix61System@%DynamicArray$p36Dbxtablestorage@TDBXColumnDescriptor%", "__fastcall Dbxmysqlmetadatareader::TDBXMySqlCustomMetaDataReader::TDBXMySql4IndexesCursor::FindStringSize(const int, const System::DynamicArray<Dbxtablestorage::TDBXColumnDescriptor *>)"),
	mu_demangle_test("@Dbxmysqlmetadatareader@TDBXMySqlCustomMetaDataReader@TDBXMySql4IndexesCursor@FindStringSize$qqrxix62System@%DynamicArray$tp36Dbxtablestorage@TDBXColumnDescriptor%", "__fastcall Dbxmysqlmetadatareader::TDBXMySqlCustomMetaDataReader::TDBXMySql4IndexesCursor::FindStringSize(const int, const System::DynamicArray<Dbxtablestorage::TDBXColumnDescriptor *>)"),
	mu_demangle_test("@Dbxtablestorage@TDBXDelegateTableStorage@SetColumns$qqrx61System@%DynamicArray$p36Dbxtablestorage@TDBXColumnDescriptor%", "__fastcall Dbxtablestorage::TDBXDelegateTableStorage::SetColumns(const System::DynamicArray<Dbxtablestorage::TDBXColumnDescriptor *>)"),
	mu_demangle_test("@Dbxtablestorage@TDBXDelegateTableStorage@SetColumns$qqrx62System@%DynamicArray$tp36Dbxtablestorage@TDBXColumnDescriptor%", "__fastcall Dbxtablestorage::TDBXDelegateTableStorage::SetColumns(const System::DynamicArray<Dbxtablestorage::TDBXColumnDescriptor *>)"),
	mu_demangle_test("@foo$q10ns@Bar@Baz", "foo(ns::Bar::Baz)"),
	mu_demangle_test("@foo$qie", "foo(int, ...)"),
	mu_demangle_test("@foo$qN", "foo(nullptr_t)"),
	mu_demangle_test("@foo$qpa3$i", "foo(int [3] *)"),
	mu_demangle_test("@foo$qpx10ns@Bar@Baz", "foo(const ns::Bar::Baz *)"),
	mu_demangle_test("@foo$qri", "foo(int &)"),
	mu_demangle_test("@foo1$qpa3$a5$c", "foo1(char [3][5] *)"),
	mu_demangle_test("@foo1$qpqv$i", "foo1(int (*)(void))"),
	mu_demangle_test("@foo1$qpxi", "foo1(const int *)"),
	mu_demangle_test("@foo10$qpa3$d", "foo10(double [3] *)"),
	mu_demangle_test("@foo10$qpwxi", "foo10(volatile const int *)"),
	mu_demangle_test("@foo11$qpwxi", "foo11(volatile const int *)"),
	mu_demangle_test("@foo2$qrqv$i", "foo2(int (&)(void))"),
	mu_demangle_test("@foo2$qxpi", "foo2(int * const)"),
	mu_demangle_test("@foo3$qb", "foo3(wchar_t)"),
	mu_demangle_test("@foo3$qhqv$i", "foo3(int (&&)(void))"),
	mu_demangle_test("@foo3$qpxa3$i", "foo3(const int [3] *)"),
	mu_demangle_test("@foo3$qxpxi", "foo3(const int * const)"),
	mu_demangle_test("@foo4$qpa3500$a6$i", "foo4(int [3500][6] *)"),
	mu_demangle_test("@foo4$qpwi", "foo4(volatile int *)"),
	mu_demangle_test("@foo5$qra5$a5$i", "foo5(int [5][5] &)"),
	mu_demangle_test("@foo5$qwpi", "foo5(int * volatile)"),
	mu_demangle_test("@foo6$qrxa5$a5$i", "foo6(int [5][5] & const)"),
	mu_demangle_test("@foo6$qwpwi", "foo6(volatile int * volatile)"),
	mu_demangle_test("@foo7$qha5$a5$i", "foo7(int [5][5] &&)"),
	mu_demangle_test("@foo8$qxpxa5$i", "foo8(const int [5] * const)"),
	mu_demangle_test("@Foo@$badd$q3Foo", "Foo::operator+(Foo)"),
	mu_demangle_test("@Foo@$badr$qv", "Foo::operator&(void)"),
	mu_demangle_test("@Foo@$band$q3Foo", "Foo::operator&(Foo)"),
	mu_demangle_test("@Foo@$barow$qv", "Foo::operator->(void)"),
	mu_demangle_test("@Foo@$barwm$q3Foo", "Foo::operator->*(Foo)"),
	mu_demangle_test("@Foo@$basg$q3Foo", "Foo::operator=(Foo)"),
	mu_demangle_test("@Foo@$bcall$qi", "Foo::operator()(int)"),
	mu_demangle_test("@Foo@$bcmp$qv", "Foo::operator~(void)"),
	mu_demangle_test("@Foo@$bcoma$q3Foo", "Foo::operator,(Foo)"),
	mu_demangle_test("@Foo@$bctr$qv", "Foo::Foo(void)"),
	mu_demangle_test("@Foo@$bctr2$qv", "Foo::Foo(void)"),
	mu_demangle_test("@Foo@$bdec$qi", "Foo::operator--(int)"),
	mu_demangle_test("@Foo@$bdele$qpv", "Foo::operator delete(void *)"),
	mu_demangle_test("@Foo@$bdiv$q3Foo", "Foo::operator/(Foo)"),
	mu_demangle_test("@Foo@$bdla$qpv", "Foo::operator delete[](void *)"),
	mu_demangle_test("@Foo@$bdtr1$qv", "Foo::~Foo(void)"),
	mu_demangle_test("@Foo@$bdtr2$qv", "Foo::~Foo(void)"),
	mu_demangle_test("@Foo@$beql$q3Foo", "Foo::operator==(Foo)"),
	mu_demangle_test("@Foo@$bgeq$q3Foo", "Foo::operator>=(Foo)"),
	mu_demangle_test("@Foo@$bgtr$q3Foo", "Foo::operator>(Foo)"),
	mu_demangle_test("@Foo@$binc$qi", "Foo::operator++(int)"),
	mu_demangle_test("@Foo@$bind$qv", "Foo::operator*(void)"),
	mu_demangle_test("@Foo@$bland$q3Foo", "Foo::operator&&(Foo)"),
	mu_demangle_test("@Foo@$bleq$q3Foo", "Foo::operator<=(Foo)"),
	mu_demangle_test("@Foo@$blor$q3Foo", "Foo::operator||(Foo)"),
	mu_demangle_test("@Foo@$blsh$q3Foo", "Foo::operator<<(Foo)"),
	mu_demangle_test("@Foo@$blss$q3Foo", "Foo::operator<(Foo)"),
	mu_demangle_test("@Foo@$bmod$q3Foo", "Foo::operator%(Foo)"),
	mu_demangle_test("@Foo@$bmul$q3Foo", "Foo::operator*(Foo)"),
	mu_demangle_test("@Foo@$bneq$q3Foo", "Foo::operator!=(Foo)"),
	mu_demangle_test("@Foo@$bnew$qui", "Foo::operator new(unsigned int)"),
	mu_demangle_test("@Foo@$bnot$qv", "Foo::operator!(void)"),
	mu_demangle_test("@Foo@$bnwa$qui", "Foo::operator new[](unsigned int)"),
	mu_demangle_test("@Foo@$bor$q3Foo", "Foo::operator|(Foo)"),
	mu_demangle_test("@Foo@$brand$q3Foo", "Foo::operator&=(Foo)"),
	mu_demangle_test("@Foo@$brdiv$q3Foo", "Foo::operator/=(Foo)"),
	mu_demangle_test("@Foo@$brlsh$q3Foo", "Foo::operator<<=(Foo)"),
	mu_demangle_test("@Foo@$brmin$q3Foo", "Foo::operator-=(Foo)"),
	mu_demangle_test("@Foo@$brmod$q3Foo", "Foo::operator%=(Foo)"),
	mu_demangle_test("@Foo@$brmul$q3Foo", "Foo::operator*=(Foo)"),
	mu_demangle_test("@Foo@$bror$q3Foo", "Foo::operator|=(Foo)"),
	mu_demangle_test("@Foo@$brplu$q3Foo", "Foo::operator+=(Foo)"),
	mu_demangle_test("@Foo@$brrsh$q3Foo", "Foo::operator>>=(Foo)"),
	mu_demangle_test("@Foo@$brsh$q3Foo", "Foo::operator>>(Foo)"),
	mu_demangle_test("@Foo@$brxor$q3Foo", "Foo::operator^=(Foo)"),
	mu_demangle_test("@Foo@$bsub$q3Foo", "Foo::operator-(Foo)"),
	mu_demangle_test("@Foo@$bsubs$q3Foo", "Foo::operator[](Foo)"),
	mu_demangle_test("@Foo@$bxor$q3Foo", "Foo::operator^(Foo)"),
	mu_demangle_test("@Foo@$o3Bar$qv", "Foo::operator Bar(void)"),
	mu_demangle_test("@Foo@$oi$qv", "Foo::operator int(void)"),
	mu_demangle_test("@foonew$qrwxpi", "foonew(int * volatile const &)"),
	mu_demangle_test("@HTTPParse@_16402", "HTTPParse::_16402"),
	mu_demangle_test("@Idimap4@TIdImapSubSection@$bleq$qqrv", "__fastcall Idimap4::TIdImapSubSection::operator<=(void)"),
	mu_demangle_test("@Idimap4@TIdImapSubSection@$brrsh$qqrv", "__fastcall Idimap4::TIdImapSubSection::operator>>=(void)"),
	mu_demangle_test("@Idimap4@TIdImapSubSection@bagr$qqriipa15$a89$a2$ipa10$a666$25System@%DynamicArray$tuc%", "__fastcall Idimap4::TIdImapSubSection::bagr(int, int, int [15][89][2] *, System::DynamicArray<unsigned char> [10][666] *)"),
	mu_demangle_test("@myFunc_all_$qsusiuiluljujzcuccfdgoCsCib", "myFunc_all_(short, unsigned short, int, unsigned int, long, unsigned long, long long, unsigned long long, signed char, unsigned char, char, float, double, long double, bool, char16_t, char32_t, wchar_t)"),
	mu_demangle_test("@myFunc_bool_$qo", "myFunc_bool_(bool)"),
	mu_demangle_test("@myFunc_cdecl_$qv", "myFunc_cdecl_(void)"),
	mu_demangle_test("@myFunc_char_$qc", "myFunc_char_(char)"),
	mu_demangle_test("@myFunc_double_$qd", "myFunc_double_(double)"),
	mu_demangle_test("@myFunc_empty_$qv", "myFunc_empty_(void)"),
	mu_demangle_test("@myFunc_fastcall_$qqrv", "__fastcall myFunc_fastcall_(void)"),
	mu_demangle_test("@myFunc_float_$qf", "myFunc_float_(float)"),
	mu_demangle_test("@myFunc_i_$qiii", "myFunc_i_(int, int, int)"),
	mu_demangle_test("@myFunc_int_$qi", "myFunc_int_(int)"),
	mu_demangle_test("@myFunc_long_double_$qg", "myFunc_long_double_(long double)"),
	mu_demangle_test("@myFunc_long_int_$ql", "myFunc_long_int_(long)"),
	mu_demangle_test("@myFunc_long_long_int_$qj", "myFunc_long_long_int_(long long)"),
	mu_demangle_test("@myFunc_pascal_$qv", "myFunc_pascal_(void)"),
	mu_demangle_test("@myFunc_ref1_$qr3Tmp", "myFunc_ref1_(Tmp &)"),
	mu_demangle_test("@myFunc_ref2_$qh3Tmp", "myFunc_ref2_(Tmp &&)"),
	mu_demangle_test("@myFunc_s_$q60std@%basic_string$c19std@%char_traits$c%17std@%allocator$c%%t1t1", "myFunc_s_(std::basic_string<char, std::char_traits<char>, std::allocator<char>>, std::basic_string<char, std::char_traits<char>, std::allocator<char>>, std::basic_string<char, std::char_traits<char>, std::allocator<char>>)"),
	mu_demangle_test("@myFunc_short_int_$qs", "myFunc_short_int_(short)"),
	mu_demangle_test("@myFunc_signed_char_$qzc", "myFunc_signed_char_(signed char)"),
	mu_demangle_test("@myFunc_std__string_$q60std@%basic_string$c19std@%char_traits$c%17std@%allocator$c%%", "myFunc_std__string_(std::basic_string<char, std::char_traits<char>, std::allocator<char>>)"),
	mu_demangle_test("@myFunc_stdcall_$qqsv", "__stdcall myFunc_stdcall_(void)"),
	mu_demangle_test("@myFunc_unsigned_$qui", "myFunc_unsigned_(unsigned int)"),
	mu_demangle_test("@myFunc_unsigned_char_$quc", "myFunc_unsigned_char_(unsigned char)"),
	mu_demangle_test("@myFunc_unsigned_long_int_$qul", "myFunc_unsigned_long_int_(unsigned long)"),
	mu_demangle_test("@myFunc_unsigned_long_long_$quj", "myFunc_unsigned_long_long_(unsigned long long)"),
	mu_demangle_test("@myFunc_unsigned_short_int_$qus", "myFunc_unsigned_short_int_(unsigned short)"),
	mu_demangle_test("@myFunc_void123_$qpvppvpppv", "myFunc_void123_(void *, void * *, void * * *)"),
	mu_demangle_test("@myFunc_void1_$qpv", "myFunc_void1_(void *)"),
	mu_demangle_test("@myFunc_void2_$qppv", "myFunc_void2_(void * *)"),
	mu_demangle_test("@ns1@ns2@ns3@%foo3$c%$qv$v", "void ns1::ns2::ns3::foo3<char>(void)"),
	mu_demangle_test("@ns@%myFunc_template_$i%$qi$d", "double ns::myFunc_template_<int>(int)"),
	mu_demangle_test("@ns@ns1@ns2@%myFunc_template_$i%$qi$d", "double ns::ns1::ns2::myFunc_template_<int>(int)"),
	mu_demangle_test("@Sqlexpr@TSQLConnection@SQLError$qqrus25Sqlexpr@TSQLExceptionTypex47System@%DelphiInterface$20Dbxpress@ISQLCommand%", "__fastcall Sqlexpr::TSQLConnection::SQLError(unsigned short, Sqlexpr::TSQLExceptionType, const System::DelphiInterface<Dbxpress::ISQLCommand>)"),
	mu_demangle_test("@Sqlexpr@TSQLConnection@SQLError$qqrus25Sqlexpr@TSQLExceptionTypex48System@%DelphiInterface$t20Dbxpress@ISQLCommand%", "__fastcall Sqlexpr::TSQLConnection::SQLError(unsigned short, Sqlexpr::TSQLExceptionType, const System::DelphiInterface<Dbxpress::ISQLCommand>)"),
	mu_demangle_test("@std@$bror$qr22std@%_Iosb$i%@_Iostate22std@%_Iosb$i%@_Iostate", "std::operator|=(std::_Iosb<int>::_Iostate &, std::_Iosb<int>::_Iostate)"),
	mu_demangle_test("@std@%basic_ios$c19std@%char_traits$c%%@fill$xqv", "std::basic_ios<char, std::char_traits<char>>::fill(void) const"),
	mu_demangle_test("@std@%basic_string$c19std@%char_traits$c%17std@%allocator$c%%@_Xlen$xqv", "std::basic_string<char, std::char_traits<char>, std::allocator<char>>::_Xlen(void) const"),
	mu_demangle_test("@std@_Xlength_error$qpxc", "std::_Xlength_error(const char *)"),
	mu_demangle_test("@std@error_category@$beql$xqrx18std@error_category", "std::error_category::operator==(std::error_category & const) const"),
	mu_demangle_test("@Themes@TThemeServices@GetElementDetails$qqr25Themes@TThemedExplorerBar", "__fastcall Themes::TThemeServices::GetElementDetails(Themes::TThemedExplorerBar)"),
	mu_demangle_test("@Unit1@foo_Comp_$qqr11System@Comp", "__fastcall Unit1::foo_Comp_(System::Comp)"),
	mu_demangle_test("@Unit1@foo_Currency_$qqr15System@Currency", "__fastcall Unit1::foo_Currency_(System::Currency)"),
	mu_demangle_test("@Unit1@foo_UnicodeString_$qqr20System@UnicodeString", "__fastcall Unit1::foo_UnicodeString_(System::UnicodeString)"),
	mu_demangle_test("@Unit1@foo_WideString_$qqr17System@WideString", "__fastcall Unit1::foo_WideString_(System::WideString)"),
	mu_demangle_test("@Webscriptas@TActiveScriptObjectFactory@CreateProducerObject$qqr32Webscript@TGlobalScriptVariables51System@%DelphiInterface$24Httpprod@IScriptProducer%", "__fastcall Webscriptas::TActiveScriptObjectFactory::CreateProducerObject(Webscript::TGlobalScriptVariables, System::DelphiInterface<Httpprod::IScriptProducer>)"),
	mu_demangle_test("@Webscriptas@TActiveScriptObjectFactory@CreateProducerObject$qqr32Webscript@TGlobalScriptVariables52System@%DelphiInterface$t24Httpprod@IScriptProducer%", "__fastcall Webscriptas::TActiveScriptObjectFactory::CreateProducerObject(Webscript::TGlobalScriptVariables, System::DelphiInterface<Httpprod::IScriptProducer>)"),
	mu_demangle_test("@Webservexp@TWebServExp@GenerateNestedArraySchema$qqr50System@%DelphiInterface$23Xmlschema@IXMLSchemaDef%55System@%DelphiInterface$28Xmlschema@IXMLComplexTypeDef%px17Typinfo@TTypeInfori17System@WideString", "__fastcall Webservexp::TWebServExp::GenerateNestedArraySchema(System::DelphiInterface<Xmlschema::IXMLSchemaDef>, System::DelphiInterface<Xmlschema::IXMLComplexTypeDef>, const Typinfo::TTypeInfo *, int &, System::WideString)"),
	mu_demangle_test("@Webservexp@TWebServExp@GenerateNestedArraySchema$qqr51System@%DelphiInterface$t23Xmlschema@IXMLSchemaDef%56System@%DelphiInterface$t28Xmlschema@IXMLComplexTypeDef%px17Typinfo@TTypeInfori17System@WideString", "__fastcall Webservexp::TWebServExp::GenerateNestedArraySchema(System::DelphiInterface<Xmlschema::IXMLSchemaDef>, System::DelphiInterface<Xmlschema::IXMLComplexTypeDef>, const Typinfo::TTypeInfo *, int &, System::WideString)"),
	mu_demangle_test("@Lllvm@workaround@fake@stub@%$badd$3Bar%$q3Bart1$3Bar", "Bar Lllvm::workaround::fake::stub::operator+<Bar>(Bar, Bar)"),
	mu_demangle_test("@Lllvm@workaround@fake@stub@Bar@$bctr$qv", "Lllvm::workaround::fake::stub::Bar::Bar(void)"),
	// must fails
	mu_demangle_test("@foo$q010ns@Bar@Baz", NULL),
	mu_demangle_test("@%foo2$20std@%basic_string$c10%my_tmp$c%%i%$qv$v", NULL),
	mu_demangle_test("@foo$q14std@%tmp$c%", NULL),
	mu_demangle_test("@foo$q14std@%tmp$c11std@%tmp$c%", NULL),
	mu_demangle_test("@foo$q14std@%tmp$c11std@%tmp$c%%", NULL),
	// end
);

mu_main(borland, cxx);
