/*
For general Scribus (>=1.3.2) copyright and licensing information please refer
to the COPYING file provided with the program. Following this notice may exist
a copyright and/or license notice that predates the release of Scribus 1.3.2
for which a new license (GPL+exception) is in place.
*/

#include "sce308tables.h"

QVector<int> ScE308Table::wavelengths() const
{
	QVector<int> wls;
	wls.reserve(m_wy.count());

	QMap<int, double>::const_iterator iter;
	for (iter = m_wy.begin(); iter!= m_wy.end(); ++iter)
		wls.append(iter.key());

	return wls;
}

ScE308Table5_D50_2deg::ScE308Table5_D50_2deg()
                     : ScE308Table()
{
	m_wx[360] = 0.000, m_wy[360] = 0.000, m_wz[360] =  0.001;
	m_wx[370] = 0.001, m_wy[370] = 0.000, m_wz[370] =  0.005;
	m_wx[380] = 0.003, m_wy[380] = 0.000, m_wz[380] =  0.013;
	m_wx[390] = 0.012, m_wy[390] = 0.000, m_wz[390] =  0.057;
	
	m_wx[400] = 0.060, m_wy[400] = 0.002, m_wz[400] =  0.285;
	m_wx[410] = 0.234, m_wy[410] = 0.006, m_wz[410] =  1.113;
	m_wx[420] = 0.775, m_wy[420] = 0.023, m_wz[420] =  3.723;
	m_wx[430] = 1.610, m_wy[430] = 0.066, m_wz[430] =  7.862;
	m_wx[440] = 2.453, m_wy[440] = 0.162, m_wz[440] = 12.309;
	
	m_wx[450] = 2.777, m_wy[450] = 0.313, m_wz[450] = 14.647;
	m_wx[460] = 2.500, m_wy[460] = 0.514, m_wz[460] = 14.346;
	m_wx[470] = 1.717, m_wy[470] = 0.798, m_wz[470] = 11.299;
	m_wx[480] = 0.861, m_wy[480] = 1.239, m_wz[480] =  7.309;
	m_wx[490] = 0.283, m_wy[490] = 1.839, m_wz[490] =  4.128;
	
	m_wx[500] = 0.040, m_wy[500] = 2.948, m_wz[500] =  2.466;
	m_wx[510] = 0.088, m_wy[510] = 4.632, m_wz[510] =  1.447;
	m_wx[520] = 0.593, m_wy[520] = 6.587, m_wz[520] =  0.736;
	m_wx[530] = 1.590, m_wy[530] = 8.308, m_wz[530] =  0.401;
	m_wx[540] = 2.799, m_wy[540] = 9.197, m_wz[540] =  0.196;
	
	m_wx[550] = 4.207, m_wy[550] = 9.650, m_wz[550] =  0.085;
	m_wx[560] = 5.657, m_wy[560] = 9.471, m_wz[560] =  0.037;
	m_wx[570] = 7.132, m_wy[570] = 8.902, m_wz[570] =  0.020;
	m_wx[580] = 8.540, m_wy[580] = 8.112, m_wz[580] =  0.015;
	m_wx[590] = 9.255, m_wy[590] = 6.829, m_wz[590] =  0.010;

	m_wx[600] = 9.835, m_wy[600] = 5.838, m_wz[600] =  0.007;
	m_wx[610] = 9.468, m_wy[610] = 4.753, m_wz[610] =  0.004;
	m_wx[620] = 8.009, m_wy[620] = 3.573, m_wz[620] =  0.002;
	m_wx[630] = 5.926, m_wy[630] = 2.443, m_wz[630] =  0.001;
	m_wx[640] = 4.171, m_wy[640] = 1.629, m_wz[640] =  0.000;
	
	m_wx[650] = 2.609, m_wy[650] = 0.984, m_wz[650] =  0.000;
	m_wx[660] = 1.541, m_wy[660] = 0.570, m_wz[660] =  0.000;
	m_wx[670] = 0.855, m_wy[670] = 0.313, m_wz[670] =  0.000;
	m_wx[680] = 0.434, m_wy[680] = 0.158, m_wz[680] =  0.000;
	m_wx[690] = 0.194, m_wy[690] = 0.070, m_wz[690] =  0.000;

	m_wx[700] = 0.097, m_wy[700] = 0.035, m_wz[700] =  0.000;
	m_wx[710] = 0.050, m_wy[710] = 0.018, m_wz[710] =  0.000;
	m_wx[720] = 0.022, m_wy[720] = 0.008, m_wz[720] =  0.000;
	m_wx[730] = 0.012, m_wy[730] = 0.004, m_wz[730] =  0.000;
	m_wx[740] = 0.006, m_wy[740] = 0.002, m_wz[740] =  0.000;

	m_wx[750] = 0.002, m_wy[750] = 0.001, m_wz[750] =  0.000;
	m_wx[760] = 0.001, m_wy[760] = 0.000, m_wz[760] =  0.000;
	m_wx[770] = 0.001, m_wy[770] = 0.000, m_wz[770] =  0.000;
	m_wx[780] = 0.000, m_wy[780] = 0.000, m_wz[780] =  0.000;
}

ScE308Table5_D50_10deg::ScE308Table5_D50_10deg()
                     : ScE308Table()
{
	m_wx[360] = 0.000, m_wy[360] = 0.000, m_wz[360] =  0.000;
	m_wx[370] = 0.000, m_wy[370] = 0.000, m_wz[370] =  0.000;
	m_wx[380] = 0.000, m_wy[380] = 0.000, m_wz[380] = -0.002;
	m_wx[390] = 0.004, m_wy[390] = 0.000, m_wz[390] =  0.017;
	
	m_wx[400] = 0.083, m_wy[400] = 0.009, m_wz[400] =  0.371;
	m_wx[410] = 0.427, m_wy[410] = 0.044, m_wz[410] =  1.966;
	m_wx[420] = 1.049, m_wy[420] = 0.110, m_wz[420] =  4.989;
	m_wx[430] = 1.668, m_wy[430] = 0.204, m_wz[430] =  8.231;
	m_wx[440] = 2.487, m_wy[440] = 0.403, m_wz[440] = 12.758;
	
	m_wx[450] = 2.814, m_wy[450] = 0.677, m_wz[450] = 15.129;
	m_wx[460] = 2.404, m_wy[460] = 1.012, m_wz[460] = 13.886;
	m_wx[470] = 1.565, m_wy[470] = 1.490, m_wz[470] = 10.528;
	m_wx[480] = 0.671, m_wy[480] = 2.108, m_wz[480] =  6.442;
	m_wx[490] = 0.135, m_wy[490] = 2.779, m_wz[490] =  3.392;
	
	m_wx[500] = 0.035, m_wy[500] = 3.850, m_wz[500] =  1.824;
	m_wx[510] = 0.317, m_wy[510] = 5.143, m_wz[510] =  0.960;
	m_wx[520] = 1.010, m_wy[520] = 6.513, m_wz[520] =  0.513;
	m_wx[530] = 2.098, m_wy[530] = 7.791, m_wz[530] =  0.269;
	m_wx[540] = 3.341, m_wy[540] = 8.525, m_wz[540] =  0.120;
	
	m_wx[550] = 4.745, m_wy[550] = 8.877, m_wz[550] =  0.035;
	m_wx[560] = 6.183, m_wy[560] = 8.742, m_wz[560] =  0.001;
	m_wx[570] = 7.560, m_wy[570] = 8.222, m_wz[570] =  0.000;
	m_wx[580] = 8.733, m_wy[580] = 7.485, m_wz[580] =  0.000;
	m_wx[590] = 9.273, m_wy[590] = 6.449, m_wz[590] =  0.000;

	m_wx[600] = 9.586, m_wy[600] = 5.613, m_wz[600] =  0.000;
	m_wx[610] = 8.959, m_wy[610] = 4.592, m_wz[610] =  0.000;
	m_wx[620] = 7.419, m_wy[620] = 3.452, m_wz[620] =  0.000;
	m_wx[630] = 5.471, m_wy[630] = 2.392, m_wz[630] =  0.000;
	m_wx[640] = 3.721, m_wy[640] = 1.550, m_wz[640] =  0.000;
	
	m_wx[650] = 2.268, m_wy[650] = 0.910, m_wz[650] =  0.000;
	m_wx[660] = 1.316, m_wy[660] = 0.519, m_wz[660] =  0.000;
	m_wx[670] = 0.728, m_wy[670] = 0.285, m_wz[670] =  0.000;
	m_wx[680] = 0.354, m_wy[680] = 0.138, m_wz[680] =  0.000;
	m_wx[690] = 0.155, m_wy[690] = 0.060, m_wz[690] =  0.000;

	m_wx[700] = 0.076, m_wy[700] = 0.029, m_wz[700] =  0.000;
	m_wx[710] = 0.036, m_wy[710] = 0.014, m_wz[710] =  0.000;
	m_wx[720] = 0.015, m_wy[720] = 0.006, m_wz[720] =  0.000;
	m_wx[730] = 0.008, m_wy[730] = 0.003, m_wz[730] =  0.000;
	m_wx[740] = 0.004, m_wy[740] = 0.002, m_wz[740] =  0.000;

	m_wx[750] = 0.002, m_wy[750] = 0.001, m_wz[750] =  0.000;
	m_wx[760] = 0.001, m_wy[760] = 0.000, m_wz[760] =  0.000;
	m_wx[770] = 0.000, m_wy[770] = 0.000, m_wz[770] =  0.000;
	m_wx[780] = 0.000, m_wy[780] = 0.000, m_wz[780] =  0.000;
}

ScE308Table6_D50_2deg::ScE308Table6_D50_2deg()
                     : ScE308Table()
{
	m_wx[360] = 0.000, m_wy[360] = 0.000, m_wz[360] =  0.000;
	m_wx[370] = 0.001, m_wy[370] = 0.000, m_wz[370] =  0.005;
	m_wx[380] = 0.003, m_wy[380] = 0.000, m_wz[380] =  0.014;
	m_wx[390] = 0.008, m_wy[390] = 0.000, m_wz[390] =  0.039;
	
	m_wx[400] = 0.058, m_wy[400] = 0.002, m_wz[400] =  0.277;
	m_wx[410] = 0.191, m_wy[410] = 0.005, m_wz[410] =  0.906;
	m_wx[420] = 0.751, m_wy[420] = 0.021, m_wz[420] =  3.603;
	m_wx[430] = 1.592, m_wy[430] = 0.060, m_wz[430] =  7.747;
	m_wx[440] = 2.519, m_wy[440] = 0.158, m_wz[440] = 12.593;
	
	m_wx[450] = 2.824, m_wy[450] = 0.310, m_wz[450] = 14.834;
	m_wx[460] = 2.556, m_wy[460] = 0.511, m_wz[460] = 14.659;
	m_wx[470] = 1.717, m_wy[470] = 0.776, m_wz[470] = 11.344;
	m_wx[480] = 0.832, m_wy[480] = 1.246, m_wz[480] =  7.240;
	m_wx[490] = 0.250, m_wy[490] = 1.783, m_wz[490] =  3.934;
	
	m_wx[500] = 0.025, m_wy[500] = 2.892, m_wz[500] =  2.477;
	m_wx[510] = 0.047, m_wy[510] = 4.610, m_wz[510] =  1.432;
	m_wx[520] = 0.538, m_wy[520] = 6.586, m_wz[520] =  0.688;
	m_wx[530] = 1.590, m_wy[530] = 8.435, m_wz[530] =  0.403;
	m_wx[540] = 2.770, m_wy[540] = 9.185, m_wz[540] =  0.186;
	
	m_wx[550] = 4.210, m_wy[550] = 9.733, m_wz[550] =  0.080;
	m_wx[560] = 5.662, m_wy[560] = 9.503, m_wz[560] =  0.035;
	m_wx[570] = 7.092, m_wy[570] = 8.882, m_wz[570] =  0.019;
	m_wx[580] = 8.681, m_wy[580] = 8.225, m_wz[580] =  0.019;
	m_wx[590] = 9.175, m_wy[590] = 6.728, m_wz[590] =  0.010;

	m_wx[600] = 9.966, m_wy[600] = 5.884, m_wz[600] =  0.008;
	m_wx[610] = 9.556, m_wy[610] = 4.752, m_wz[610] =  0.003;
	m_wx[620] = 8.099, m_wy[620] = 3.584, m_wz[620] =  0.002;
	m_wx[630] = 5.835, m_wy[630] = 2.392, m_wz[630] =  0.000;
	m_wx[640] = 4.199, m_wy[640] = 1.633, m_wz[640] =  0.000;
	
	m_wx[650] = 2.539, m_wy[650] = 0.954, m_wz[650] =  0.000;
	m_wx[660] = 1.517, m_wy[660] = 0.560, m_wz[660] =  0.000;
	m_wx[670] = 0.831, m_wy[670] = 0.304, m_wz[670] =  0.000;
	m_wx[680] = 0.423, m_wy[680] = 0.153, m_wz[680] =  0.000;
	m_wx[690] = 0.178, m_wy[690] = 0.064, m_wz[690] =  0.000;

	m_wx[700] = 0.096, m_wy[700] = 0.035, m_wz[700] =  0.000;
	m_wx[710] = 0.049, m_wy[710] = 0.018, m_wz[710] =  0.000;
	m_wx[720] = 0.020, m_wy[720] = 0.007, m_wz[720] =  0.000;
	m_wx[730] = 0.012, m_wy[730] = 0.004, m_wz[730] =  0.000;
	m_wx[740] = 0.006, m_wy[740] = 0.002, m_wz[740] =  0.000;

	m_wx[750] = 0.002, m_wy[750] = 0.001, m_wz[750] =  0.000;
	m_wx[760] = 0.001, m_wy[760] = 0.000, m_wz[760] =  0.000;
	m_wx[770] = 0.001, m_wy[770] = 0.000, m_wz[770] =  0.000;
	m_wx[780] = 0.000, m_wy[780] = 0.000, m_wz[780] =  0.000;
}

ScE308Table6_D50_10deg::ScE308Table6_D50_10deg()
                     : ScE308Table()
{
	m_wx[360] = 0.000, m_wy[360] = 0.000, m_wz[360] =  0.000;
	m_wx[370] = 0.000, m_wy[370] = 0.000, m_wz[370] =  0.000;
	m_wx[380] = 0.001, m_wy[380] = 0.000, m_wz[380] =  0.002;
	m_wx[390] = 0.002, m_wy[390] = 0.000, m_wz[390] =  0.009;
	
	m_wx[400] = 0.059, m_wy[400] = 0.006, m_wz[400] =  0.263;
	m_wx[410] = 0.385, m_wy[410] = 0.040, m_wz[410] =  1.751;
	m_wx[420] = 1.087, m_wy[420] = 0.112, m_wz[420] =  5.154;
	m_wx[430] = 1.597, m_wy[430] = 0.190, m_wz[430] =  7.864;
	m_wx[440] = 2.556, m_wy[440] = 0.398, m_wz[440] = 13.066;
	
	m_wx[450] = 2.888, m_wy[450] = 0.675, m_wz[450] = 15.511;
	m_wx[460] = 2.437, m_wy[460] = 1.000, m_wz[460] = 14.023;
	m_wx[470] = 1.574, m_wy[470] = 1.469, m_wz[470] = 10.623;
	m_wx[480] = 0.630, m_wy[480] = 2.130, m_wz[480] =  6.312;
	m_wx[490] = 0.096, m_wy[490] = 2.715, m_wz[490] =  3.227;
	
	m_wx[500] = 0.006, m_wy[500] = 3.842, m_wz[500] =  1.796;
	m_wx[510] = 0.284, m_wy[510] = 5.138, m_wz[510] =  0.919;
	m_wx[520] = 0.965, m_wy[520] = 6.500, m_wz[520] =  0.501;
	m_wx[530] = 2.101, m_wy[530] = 7.872, m_wz[530] =  0.263;
	m_wx[540] = 3.317, m_wy[540] = 8.532, m_wz[540] =  0.114;
	
	m_wx[550] = 4.745, m_wy[550] = 8.931, m_wz[550] =  0.031;
	m_wx[560] = 6.194, m_wy[560] = 8.780, m_wz[560] = -0.003;
	m_wx[570] = 7.547, m_wy[570] = 8.214, m_wz[570] =  0.001;
	m_wx[580] = 8.847, m_wy[580] = 7.557, m_wz[580] =  0.000;
	m_wx[590] = 9.218, m_wy[590] = 6.375, m_wz[590] =  0.000;

	m_wx[600] = 9.712, m_wy[600] = 5.663, m_wz[600] =  0.000;
	m_wx[610] = 9.035, m_wy[610] = 4.597, m_wz[610] =  0.000;
	m_wx[620] = 7.465, m_wy[620] = 3.447, m_wz[620] =  0.000;
	m_wx[630] = 5.426, m_wy[630] = 2.366, m_wz[630] =  0.000;
	m_wx[640] = 3.713, m_wy[640] = 1.541, m_wz[640] =  0.000;
	
	m_wx[650] = 2.208, m_wy[650] = 0.882, m_wz[650] =  0.000;
	m_wx[660] = 1.289, m_wy[660] = 0.509, m_wz[660] =  0.000;
	m_wx[670] = 0.714, m_wy[670] = 0.279, m_wz[670] =  0.000;
	m_wx[680] = 0.338, m_wy[680] = 0.131, m_wz[680] =  0.000;
	m_wx[690] = 0.144, m_wy[690] = 0.056, m_wz[690] =  0.000;

	m_wx[700] = 0.075, m_wy[700] = 0.029, m_wz[700] =  0.000;
	m_wx[710] = 0.035, m_wy[710] = 0.014, m_wz[710] =  0.000;
	m_wx[720] = 0.014, m_wy[720] = 0.005, m_wz[720] =  0.000;
	m_wx[730] = 0.008, m_wy[730] = 0.003, m_wz[730] =  0.000;
	m_wx[740] = 0.004, m_wy[740] = 0.002, m_wz[740] =  0.000;

	m_wx[750] = 0.002, m_wy[750] = 0.001, m_wz[750] =  0.000;
	m_wx[760] = 0.001, m_wy[760] = 0.000, m_wz[760] =  0.000;
	m_wx[770] = 0.000, m_wy[770] = 0.000, m_wz[770] =  0.000;
	m_wx[780] = 0.000, m_wy[780] = 0.000, m_wz[780] =  0.000;
}