/*
 * Decompiled with CFR 0.152.
 */
package slothLib.NLP;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import slothLib.NLP.AbstractStringFilter;

public class StopWordFilter
extends AbstractStringFilter {
    private Map<String, Boolean> wordList = new HashMap<String, Boolean>();
    private List<String> symbolList = new ArrayList<String>();

    @Override
    public String doFilter(String str) {
        String lower = str.toLowerCase();
        if (this.wordList.containsKey(lower)) {
            return null;
        }
        for (String s : this.symbolList) {
            if (lower.indexOf(s) < 0) continue;
            return null;
        }
        return str;
    }

    public void addToWordList(String ... words) {
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (word.length() > 0 && !this.wordList.containsKey(word)) {
                this.wordList.put(word, false);
            }
            ++n2;
        }
    }

    public void removeFromWordList(String ... words) {
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (this.wordList.containsKey(word)) {
                this.wordList.remove(word);
            }
            ++n2;
        }
    }

    public void clearWordList() {
        this.wordList.clear();
    }

    public void addToSymbolList(String ... words) {
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (word.length() > 0 && !this.symbolList.contains(word)) {
                this.symbolList.add(word);
            }
            ++n2;
        }
    }

    public void removeFromSymbolList(String ... words) {
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (this.symbolList.contains(word)) {
                this.symbolList.remove(word);
            }
            ++n2;
        }
    }

    public void clearSymbolList() {
        this.symbolList.clear();
    }

    public boolean loadWordList(String[] filePaths) {
        boolean result = true;
        String[] stringArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File f = new File(path);
            if (f.exists()) {
                try {
                    String str;
                    LineNumberReader sr = new LineNumberReader(new FileReader(f));
                    while ((str = sr.readLine()) != null) {
                        if (str.length() <= 0 || this.wordList.containsKey(str)) continue;
                        this.wordList.put(str, false);
                    }
                    sr.close();
                }
                catch (IOException e) {
                    result = false;
                }
            } else {
                result = false;
            }
            ++n2;
        }
        return result;
    }

    public void loadWordList(String dirPath) throws IOException {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            throw new FileNotFoundException("\u6307\u5b9a\u3055\u308c\u305f\u30b9\u30c8\u30c3\u30d7\u30ef\u30fc\u30c9\u30ea\u30b9\u30c8\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        this.loadWordList(dir.list());
    }

    public boolean loadSymbolList(String[] filePaths) {
        boolean result = true;
        String[] stringArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File f = new File(path);
            if (f.exists()) {
                try {
                    String str;
                    LineNumberReader sr = new LineNumberReader(new FileReader(f));
                    while ((str = sr.readLine()) != null) {
                        if (str.length() <= 0 || this.symbolList.contains(str)) continue;
                        this.symbolList.add(str);
                    }
                    sr.close();
                }
                catch (IOException e) {
                    result = false;
                }
            } else {
                result = false;
            }
            ++n2;
        }
        return result;
    }

    public void loadSymbolList(String dirPath) throws IOException {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            throw new FileNotFoundException("\u6307\u5b9a\u3055\u308c\u305f\u8a18\u53f7\u30ea\u30b9\u30c8\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        this.loadSymbolList(dir.list());
    }
}

