/*
 * Decompiled with CFR 0.152.
 */
package slothLib.io;

import java.util.HashMap;
import java.util.Map;
import slothLib.SlothLibException;
import slothLib.io.IContentReader;
import slothLib.portUtil.PortUtil;

public abstract class AbstractContentReader
implements IContentReader {
    private Map<String, Boolean> readableExtensionMap = new HashMap<String, Boolean>();

    public AbstractContentReader() {
    }

    public AbstractContentReader(String ... readableExtensions) {
        this();
        String[] stringArray = readableExtensions;
        int n = readableExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            this.readableExtensionMap.put(ext.toLowerCase(), false);
            ++n2;
        }
    }

    @Override
    public boolean isReadable(String extension) {
        return this.readableExtensionMap.containsKey(extension.toLowerCase());
    }

    @Override
    public String read(String filePath) throws SlothLibException {
        if (!PortUtil.fileExists(filePath)) {
            throw new SlothLibException("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + filePath);
        }
        String fileExt = filePath.substring(filePath.lastIndexOf(".")).toLowerCase();
        if (!this.isReadable(fileExt)) {
            throw new IllegalArgumentException("\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u8aad\u307f\u8fbc\u307f\u3067\u304d\u306a\u3044\u30d5\u30a1\u30a4\u30eb\u3067\u3059\u3002");
        }
        return this.process(filePath);
    }

    protected abstract String process(String var1) throws SlothLibException;
}

