/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.featureVector;

import java.util.Collection;
import slothLib.linearAlgebra.featureVector.BasicVector;
import slothLib.linearAlgebra.featureVector.DocumentFrequencyVector;
import slothLib.linearAlgebra.featureVector.IDocumentFrequencyVector;
import slothLib.linearAlgebra.featureVector.IVector;

public class InverseDFVector<T>
extends BasicVector<T>
implements IDocumentFrequencyVector<T> {
    private int _vectorCount = 0;

    public InverseDFVector() {
    }

    public InverseDFVector(double baseValue, double addValue, IDocumentFrequencyVector<T> dfVector) {
        this.calculate(baseValue, addValue, dfVector);
    }

    public InverseDFVector(double baseValue, double addValue, Collection<IVector<T>> vectors) {
        this.calculate(baseValue, addValue, vectors);
    }

    public InverseDFVector(IDocumentFrequencyVector<T> dfVector) {
        this(2.0, 1.0, dfVector);
    }

    public InverseDFVector(Collection<IVector<T>> vectors) {
        this(2.0, 1.0, vectors);
    }

    private void calculate(double baseValue, double addValue, Collection<IVector<T>> vectors) {
        this.calculate(baseValue, addValue, new DocumentFrequencyVector<T>(vectors));
    }

    private void calculate(double baseValue, double addValue, IDocumentFrequencyVector<T> dfVector) {
        for (Object key : dfVector.keys()) {
            double val = Math.log((double)dfVector.vectorCount() / dfVector.get(key) + addValue) / Math.log(baseValue);
            this.set(key, val);
        }
        this._vectorCount = dfVector.vectorCount();
    }

    @Override
    public int vectorCount() {
        return this._vectorCount;
    }
}

