/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.featureVector;

import slothLib.linearAlgebra.featureVector.IVector;

public class VectorOperator {
    public static <T> double GetPNorm(IVector<T> vector, double p) {
        double d = 0.0;
        for (T key : vector.keys()) {
            d += Math.pow(vector.get(key), p);
        }
        return Math.pow(d, 1.0 / p);
    }

    public static <T> double getEuclideanDistance(IVector<T> vector) {
        double d = 0.0;
        for (T key : vector.keys()) {
            d += Math.pow(vector.get(key), 2.0);
        }
        return Math.sqrt(d);
    }

    public static <T> double getMaxElement(IVector<T> vector) {
        return vector.get(VectorOperator.getMaxElementKey(vector));
    }

    private static <T> T getMaxElementKey(IVector<T> vector) {
        double max = 0.0;
        T maxkey = null;
        for (T key : vector.keys()) {
            if (!(max < vector.get(key))) continue;
            max = vector.get(key);
            maxkey = key;
        }
        return maxkey;
    }

    public static <T> T getMinElementKey(IVector<T> vector) {
        double min = 0.0;
        T minkey = null;
        for (T key : vector.keys()) {
            if (!(min > vector.get(key))) continue;
            min = vector.get(key);
            minkey = key;
        }
        return minkey;
    }

    public static <T> double getMinElement(IVector<T> vector) {
        T key = VectorOperator.getMinElementKey(vector);
        return vector.get(key);
    }

    public static <T> T getMaxAbsElementKey(IVector<T> vector) {
        double absmax = 0.0;
        T absmaxkey = null;
        for (T key : vector.keys()) {
            if (!(absmax < Math.abs(vector.get(key)))) continue;
            absmax = Math.abs(vector.get(key));
            absmaxkey = key;
        }
        return absmaxkey;
    }

    public static <T> double getMaxNorm(IVector<T> vector) {
        return vector.get(VectorOperator.getMaxAbsElementKey(vector));
    }

    public static <T> double getAllElementSum(IVector<T> vector) {
        double sum = 0.0;
        for (T key : vector.keys()) {
            sum += vector.get(key);
        }
        return sum;
    }

    public static <T> double getEuclideanDistance(IVector<T> vector1, IVector<T> vector2) {
        IVector<T> sub = VectorOperator.subtract(vector1, vector2);
        return VectorOperator.getEuclideanDistance(sub);
    }

    public static <T> double getManhattanDistance(IVector<T> vector1, IVector<T> vector2) {
        double d = 0.0;
        IVector<T> sub = VectorOperator.subtract(vector1, vector2);
        for (T key : sub.keys()) {
            d += Math.abs(vector1.get(key));
        }
        return d;
    }

    public static <T> double getInnerProduct(IVector<T> vector1, IVector<T> vector2) {
        double ip = 0.0;
        for (T key : vector1.keys()) {
            ip += vector1.get(key) * vector2.get(key);
        }
        return ip;
    }

    public static <T> double getCosine(IVector<T> vector1, IVector<T> vector2) {
        double ip = VectorOperator.getInnerProduct(vector1, vector2);
        if (ip == 0.0) {
            return 0.0;
        }
        double v1Length = VectorOperator.getEuclideanDistance(vector1);
        double v2Length = VectorOperator.getEuclideanDistance(vector2);
        double cos = ip / (v1Length * v2Length);
        return cos;
    }

    public static <T> double getJaccardCoefficient(IVector<T> vector1, IVector<T> vector2) {
        double v1 = 0.0;
        double v2 = 0.0;
        double inner = VectorOperator.getInnerProduct(vector1, vector2);
        for (T key : vector1.keys()) {
            v1 += vector1.get(key) * vector1.get(key);
        }
        for (T key : vector2.keys()) {
            v2 += vector2.get(key) * vector2.get(key);
        }
        return inner / (v1 + v2 - inner);
    }

    public static <T> double getDiceCoefficient(IVector<T> vector1, IVector<T> vector2) {
        double v1 = 0.0;
        double v2 = 0.0;
        for (T key : vector1.keys()) {
            v1 += vector1.get(key) * vector1.get(key);
        }
        for (T key : vector2.keys()) {
            v2 += vector2.get(key) * vector2.get(key);
        }
        return 2.0 * VectorOperator.getInnerProduct(vector1, vector2) / v1 / v2;
    }

    public static <T> IVector<T> add(IVector<T> vector1, IVector<T> vector2) {
        IVector r = (IVector)vector1.clone();
        for (T key : vector2.keys()) {
            r.set(key, r.get(key) + vector2.get(key));
        }
        return r;
    }

    public static <T> IVector<T> subtract(IVector<T> vector1, IVector<T> vector2) {
        return VectorOperator.add(vector1, VectorOperator.negate(vector2));
    }

    public static <T> IVector<T> negate(IVector<T> vector) {
        IVector r = (IVector)vector.clone();
        for (T key : vector.keys()) {
            r.set(key, -vector.get(key));
        }
        return r;
    }

    public static <T> IVector<T> multiply(double scalar, IVector<T> vector) {
        IVector r = (IVector)vector.clone();
        for (T key : vector.keys()) {
            r.set(key, scalar * r.get(key));
        }
        return r;
    }
}

