/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.matrix;

import slothLib.linearAlgebra.matrix.IMatrix;

public class MatrixOperator {
    static double getMaxElement(IMatrix matrix) {
        double max = Double.MIN_VALUE;
        int i = 0;
        while (i < matrix.rowCount()) {
            int j = 0;
            while (j < matrix.columnCount()) {
                if (max < matrix.get(i, j)) {
                    max = matrix.get(i, j);
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    static double getMinElement(IMatrix matrix) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < matrix.rowCount()) {
            int j = 0;
            while (j < matrix.columnCount()) {
                if (min > matrix.get(i, j)) {
                    min = matrix.get(i, j);
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    public static double getMaxNorm(IMatrix matrix) {
        double absMax = Double.MIN_VALUE;
        int i = 0;
        while (i < matrix.rowCount()) {
            int j = 0;
            while (j < matrix.columnCount()) {
                if (absMax < Math.abs(matrix.get(i, j))) {
                    absMax = Math.abs(matrix.get(i, j));
                }
                ++j;
            }
            ++i;
        }
        return absMax;
    }

    public static double getAllElementSum(IMatrix matrix) {
        double sum = 0.0;
        int i = 0;
        while (i < matrix.rowCount()) {
            int j = 0;
            while (j < matrix.columnCount()) {
                sum += matrix.get(i, j);
                ++j;
            }
            ++i;
        }
        return sum;
    }

    public static IMatrix add(IMatrix matrix1, IMatrix matrix2) {
        if (matrix1.rowCount() != matrix2.rowCount() || matrix1.columnCount() != matrix2.columnCount()) {
            throw new IllegalArgumentException("\u5de6\u884c\u5217\u3068\u53f3\u884c\u5217\u3068\u3067\u884c\u6570\u53ca\u3073\u5217\u6570\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
        }
        IMatrix resultMatrix = (IMatrix)matrix1.clone();
        int i = 0;
        while (i < resultMatrix.rowCount()) {
            int j = 0;
            while (j < resultMatrix.columnCount()) {
                resultMatrix.set(i, j, resultMatrix.get(i, j) + matrix2.get(i, j));
                ++j;
            }
            ++i;
        }
        return resultMatrix;
    }

    public static IMatrix subtract(IMatrix matrix1, IMatrix matrix2) {
        if (matrix1.rowCount() != matrix2.rowCount() || matrix1.columnCount() != matrix2.columnCount()) {
            throw new IllegalArgumentException("\u5de6\u884c\u5217\u3068\u53f3\u884c\u5217\u3068\u3067\u884c\u6570\u53ca\u3073\u5217\u6570\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
        }
        IMatrix resultMatrix = (IMatrix)matrix1.clone();
        int i = 0;
        while (i < resultMatrix.rowCount()) {
            int j = 0;
            while (j < resultMatrix.columnCount()) {
                resultMatrix.set(i, j, resultMatrix.get(i, j) - matrix2.get(i, j));
                ++j;
            }
            ++i;
        }
        return resultMatrix;
    }

    public static IMatrix negate(IMatrix matrix) {
        IMatrix resultMatrix = (IMatrix)matrix.clone();
        int i = 0;
        while (i < resultMatrix.rowCount()) {
            int j = 0;
            while (j < resultMatrix.columnCount()) {
                resultMatrix.set(i, j, -matrix.get(i, j));
                ++j;
            }
            ++i;
        }
        return resultMatrix;
    }

    public static IMatrix multiply(double scalar, IMatrix matrix) {
        IMatrix resultMatrix = (IMatrix)matrix.clone();
        int i = 0;
        while (i < resultMatrix.rowCount()) {
            int j = 0;
            while (j < resultMatrix.columnCount()) {
                resultMatrix.set(i, j, scalar * matrix.get(i, j));
                ++j;
            }
            ++i;
        }
        return resultMatrix;
    }
}

