// -----------------------------------------------------------------------------------------------------
// Copyright (c) 2006-2021, Knut Reinert & Freie Universität Berlin
// Copyright (c) 2016-2021, Knut Reinert & MPI für molekulare Genetik
// This file may be used, modified and/or redistributed under the terms of the 3-clause BSD-License
// shipped with this file and also available at: https://github.com/seqan/seqan3/blob/master/LICENSE.md
// -----------------------------------------------------------------------------------------------------

/*!\file
 * \author Rene Rahn <rene.rahn AT fu-berlin.de>
 * \brief Provides metaprogramming utilities for template parameter packs.
 */

#include <seqan3/utility/type_pack/traits.hpp>

/*!\defgroup type_pack Type Pack
 * \brief Provides metaprogramming utilities for working on template parameter packs.
 * \ingroup utility
 *
 * \details
 *
 * This module contains auxiliary functions, algorithms and traits on
 * [template parameter packs](https://en.cppreference.com/w/cpp/language/parameter_pack).
 * All traits on a template parameter pack are defined in the header `<seqan3/utility/type_pack/traits.hpp>`.
 */

/*!\namespace seqan3::pack_traits
 * \brief Namespace containing traits for working on type packs.
 * \ingroup type_pack
 */
