/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.invalidation;

import java.util.Calendar;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.internal.helper.JavaPlatform;
import org.eclipse.persistence.internal.identitymaps.CacheKey;

public class DailyCacheInvalidationPolicy
extends CacheInvalidationPolicy {
    protected Calendar expiryTime = null;
    protected Calendar previousExpiry = null;

    public DailyCacheInvalidationPolicy() {
        this.expiryTime = Calendar.getInstance();
        this.previousExpiry = (Calendar)this.expiryTime.clone();
        this.previousExpiry.add(6, -1);
    }

    public DailyCacheInvalidationPolicy(int hour, int minute, int second, int millisecond) {
        this.setExpiryTime(hour, minute, second, millisecond);
    }

    public long getExpiryTimeInMillis(CacheKey key) {
        this.incrementExpiry();
        return JavaPlatform.getTimeInMillis(this.expiryTime);
    }

    public Calendar getExpiryTime() {
        return this.expiryTime;
    }

    public boolean isInvalidated(CacheKey key, long currentTimeMillis) {
        if (key.getInvalidationState() == -1) {
            return true;
        }
        long expiryMillis = JavaPlatform.getTimeInMillis(this.expiryTime);
        long readTime = key.getReadTime();
        if (currentTimeMillis < expiryMillis) {
            long previousExpiryMillis = JavaPlatform.getTimeInMillis(this.previousExpiry);
            if (readTime >= previousExpiryMillis) {
                return false;
            }
            return currentTimeMillis >= previousExpiryMillis;
        }
        if (readTime < expiryMillis) {
            this.incrementExpiry();
            return true;
        }
        this.incrementExpiry();
        return false;
    }

    public void incrementExpiry() {
        long expiryInMillis;
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis <= (expiryInMillis = JavaPlatform.getTimeInMillis(this.expiryTime))) {
            return;
        }
        while (currentTimeMillis > JavaPlatform.getTimeInMillis(this.expiryTime)) {
            this.previousExpiry.add(6, 1);
            this.expiryTime.add(6, 1);
        }
    }

    public void setExpiryTime(int hour, int minute, int second, int millisecond) {
        this.expiryTime = Calendar.getInstance();
        this.expiryTime.set(11, hour);
        this.expiryTime.set(12, minute);
        this.expiryTime.set(13, second);
        this.expiryTime.set(14, millisecond);
        this.previousExpiry = (Calendar)this.expiryTime.clone();
        this.previousExpiry.add(6, -1);
        this.incrementExpiry();
    }

    public void setExpiryTime(Calendar calendar) {
        this.setExpiryTime(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }
}

