/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.converters.Converter;

public class BasicMapAccessor
extends BasicCollectionAccessor {
    private ColumnMetadata m_keyColumn;
    private String m_keyConverter;
    private String m_valueConverter;
    private boolean m_keyContextProcessing;

    public BasicMapAccessor() {
        super("<basic-map>");
    }

    public BasicMapAccessor(Annotation basicMap, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(basicMap, accessibleObject, classAccessor);
        this.m_keyColumn = new ColumnMetadata((Annotation)MetadataHelper.invokeMethod("keyColumn", basicMap), accessibleObject, this.getAttributeName());
        Annotation keyConvert = (Annotation)MetadataHelper.invokeMethod("keyConverter", basicMap);
        this.m_keyConverter = (String)MetadataHelper.invokeMethod("value", keyConvert);
        Annotation valueConvert = (Annotation)MetadataHelper.invokeMethod("valueConverter", basicMap);
        this.m_valueConverter = (String)MetadataHelper.invokeMethod("value", valueConvert);
        this.setValueColumn(new ColumnMetadata((Annotation)MetadataHelper.invokeMethod("valueColumn", basicMap), accessibleObject, this.getAttributeName()));
        this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", basicMap));
    }

    protected ColumnMetadata getColumn(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_value_column")) {
            return super.getColumn(loggingCtx);
        }
        return this.m_keyColumn == null ? new ColumnMetadata(this.getAccessibleObject(), this.getAttributeName()) : this.m_keyColumn;
    }

    protected String getDefaultCollectionTableName() {
        if (this.m_keyColumn != null && this.m_keyColumn.getTable() != null && !this.m_keyColumn.getTable().equals("")) {
            return this.m_keyColumn.getTable();
        }
        return super.getDefaultCollectionTableName();
    }

    public ColumnMetadata getKeyColumn() {
        return this.m_keyColumn;
    }

    public String getKeyConverter() {
        return this.m_keyConverter;
    }

    public Class getReferenceClass() {
        if (this.m_keyContextProcessing) {
            return this.getAccessibleObject().getMapKeyClass(this.getDescriptor());
        }
        return this.getReferenceClassFromGeneric();
    }

    public String getValueConverter() {
        return this.m_valueConverter;
    }

    protected boolean hasConvert() {
        return true;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.initXMLObject(this.m_keyColumn, accessibleObject);
        if (this.m_keyColumn != null) {
            this.m_keyColumn.setAttributeName(this.getAttributeName());
        }
    }

    protected boolean isValidBasicMapType(Class cls) {
        return cls.equals(Map.class);
    }

    public void process() {
        DirectMapMapping mapping;
        if (this.isValidBasicMapType(this.getRawClass())) {
            mapping = new DirectMapMapping();
            this.process(mapping);
            if (this.usesIndirection()) {
                mapping.useTransparentMap();
            } else {
                mapping.dontUseIndirection();
                mapping.useMapClass(Hashtable.class);
            }
        } else {
            throw ValidationException.invalidTypeForBasicMapAttribute(this.getAttributeName(), this.getRawClass(), this.getJavaClass());
        }
        mapping.setDirectKeyField(this.getDatabaseField(mapping.getReferenceTable(), "metadata_default_key_column"));
        this.processMappingConverter(mapping, this.m_keyConverter);
        mapping.setDirectField(this.getDatabaseField(mapping.getReferenceTable(), "metadata_default_value_column"));
        this.processMappingConverter(mapping, this.m_valueConverter);
        this.processProperties(mapping);
    }

    public void processConvert() {
        DatabaseMapping mapping = this.getDescriptor().getMappingForAttributeName(this.getAttributeName());
        this.m_keyContextProcessing = true;
        this.processConvert(mapping, this.m_keyConverter);
        this.m_keyContextProcessing = false;
        this.processConvert(mapping, this.m_valueConverter);
    }

    public void setConverter(DatabaseMapping mapping, Converter converter) {
        if (this.m_keyContextProcessing) {
            ((DirectMapMapping)mapping).setKeyConverter(converter);
        } else {
            ((DirectMapMapping)mapping).setValueConverter(converter);
        }
    }

    public void setConverterClassName(DatabaseMapping mapping, String converterClassName) {
        if (this.m_keyContextProcessing) {
            ((DirectMapMapping)mapping).setKeyConverterClassName(converterClassName);
        } else {
            ((DirectMapMapping)mapping).setValueConverterClassName(converterClassName);
        }
    }

    public void setFieldClassification(DatabaseMapping mapping, Class classification) {
        if (this.m_keyContextProcessing) {
            ((DirectMapMapping)mapping).setDirectFieldClassification(classification);
        } else {
            ((DirectMapMapping)mapping).setDirectFieldClassification(classification);
        }
    }

    public void setKeyColumn(ColumnMetadata keyColumn) {
        this.m_keyColumn = keyColumn;
    }

    public void setKeyConverter(String keyConverter) {
        this.m_keyConverter = keyConverter;
    }

    public void setValueConverter(String valueConverter) {
        this.m_valueConverter = valueConverter;
    }
}

