/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.MethodIndex;
import org.jruby.util.WeakIdentityHashMap;

public class CacheMap {
    private final Map mappings = new WeakHashMap();
    private final Ruby runtime;

    public CacheMap(Ruby runtime) {
        this.runtime = runtime;
    }

    public void add(DynamicMethod method, RubyModule module) {
        Map classList = (Map)this.mappings.get(method);
        if (classList == null) {
            classList = new WeakIdentityHashMap();
            this.mappings.put(method, classList);
        }
        classList.put(module, null);
    }

    public void remove(String name, DynamicMethod method) {
        Map classList = (Map)this.mappings.remove(method);
        if (classList == null) {
            return;
        }
        Iterator iter = classList.keySet().iterator();
        while (iter.hasNext()) {
            RubyModule module = (RubyModule)iter.next();
            if (module == null) continue;
            module.removeCachedMethod(name);
            if (module.index == 0) continue;
            this.runtime.getSelectorTable().table[module.index][MethodIndex.getIndex((String)name)] = 0;
        }
    }
}

