/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.ast.executable.Script;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Constants;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.ClassExtensionLibrary;
import org.jruby.runtime.load.ExternalScript;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.load.JarredScript;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.util.BuiltinScript;
import org.jruby.util.JRubyFile;

public class LoadService {
    protected static final String JRUBY_BUILTIN_SUFFIX = ".rb";
    protected static final String[] sourceSuffixes = new String[]{".rb"};
    protected static final String[] extensionSuffixes = new String[]{".so", ".jar"};
    protected static final String[] allSuffixes = new String[]{".rb", ".so", ".jar"};
    protected static final Pattern sourcePattern = Pattern.compile("\\.(?:rb)$");
    protected static final Pattern extensionPattern = Pattern.compile("\\.(?:so|o|dll|jar)$");
    protected final RubyArray loadPath;
    protected final RubyArray loadedFeatures;
    protected final Set loadedFeaturesInternal = Collections.synchronizedSet(new HashSet());
    protected final Set firstLineLoadedFeatures = Collections.synchronizedSet(new HashSet());
    protected final Map builtinLibraries = new HashMap();
    protected final Map jarFiles = new HashMap();
    protected final Map autoloadMap = new HashMap();
    protected final Ruby runtime;

    public LoadService(Ruby runtime) {
        this.runtime = runtime;
        this.loadPath = RubyArray.newArray(runtime);
        this.loadedFeatures = RubyArray.newArray(runtime);
    }

    public void init(List additionalDirectories) {
        String jrubyHome;
        RubyString env_rubylib;
        Iterator iter = additionalDirectories.iterator();
        while (iter.hasNext()) {
            this.addPath((String)iter.next());
        }
        RubyHash env = (RubyHash)this.runtime.getObject().getConstant("ENV");
        if (env.has_key(env_rubylib = this.runtime.newString("RUBYLIB")).isTrue()) {
            String rubylib = env.aref(env_rubylib).toString();
            String[] paths = rubylib.split(File.pathSeparator);
            for (int i = 0; i < paths.length; ++i) {
                this.addPath(paths[i]);
            }
        }
        if (!Ruby.isSecurityRestricted() && (jrubyHome = this.runtime.getJRubyHome()) != null) {
            char sep = '/';
            String rubyDir = jrubyHome + sep + "lib" + sep + "ruby" + sep;
            this.addPath(rubyDir + "site_ruby" + sep + Constants.RUBY_MAJOR_VERSION);
            this.addPath(rubyDir + "site_ruby");
            this.addPath(rubyDir + Constants.RUBY_MAJOR_VERSION);
            this.addPath(rubyDir + Constants.RUBY_MAJOR_VERSION + sep + "java");
            this.addPath("lib" + sep + "ruby" + sep + Constants.RUBY_MAJOR_VERSION);
        }
        if (this.runtime.getSafeLevel() == 0) {
            this.addPath(".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPath(String path) {
        if (path == null || path.length() == 0) {
            return;
        }
        RubyArray rubyArray = this.loadPath;
        synchronized (rubyArray) {
            this.loadPath.add(this.runtime.newString(path.replace('\\', '/')));
        }
    }

    public void load(String file) {
        if (!this.runtime.getProfile().allowLoad(file)) {
            throw this.runtime.newLoadError("No such file to load -- " + file);
        }
        Library library = null;
        library = this.findLibrary(file);
        if (library == null && (library = this.findLibraryWithClassloaders(file)) == null) {
            throw this.runtime.newLoadError("No such file to load -- " + file);
        }
        try {
            library.load(this.runtime);
        }
        catch (IOException e) {
            throw this.runtime.newLoadError("IO error -- " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean smartLoad(String file) {
        Object className;
        int i;
        if (this.firstLineLoadedFeatures.contains(file)) {
            return false;
        }
        Library library = null;
        String loadName = file;
        String[] extensionsToSearch = null;
        if (file.lastIndexOf(46) > file.lastIndexOf(47)) {
            Matcher matcher = null;
            matcher = sourcePattern.matcher(file);
            if (matcher.find()) {
                extensionsToSearch = sourceSuffixes;
                file = file.substring(0, matcher.start());
            } else {
                matcher = extensionPattern.matcher(file);
                if (matcher.find()) {
                    extensionsToSearch = extensionSuffixes;
                    file = file.substring(0, matcher.start());
                } else {
                    extensionsToSearch = allSuffixes;
                }
            }
        } else {
            extensionsToSearch = allSuffixes;
        }
        for (i = 0; i < extensionsToSearch.length; ++i) {
            library = this.findLibrary(file + extensionsToSearch[i]);
            if (library == null) continue;
            loadName = file + extensionsToSearch[i];
            break;
        }
        if (library == null) {
            for (i = 0; i < extensionsToSearch.length; ++i) {
                library = this.findLibraryWithClassloaders(file + extensionsToSearch[i]);
                if (library == null) continue;
                loadName = file + extensionsToSearch[i];
                break;
            }
        }
        library = this.tryLoadExtension(library, file);
        Script script = null;
        if (library == null) {
            className = file;
            if (file.lastIndexOf(".") > file.lastIndexOf("/")) {
                className = file.substring(file.lastIndexOf(".") + 1);
            }
            className = ((String)className).replace('/', '.');
            try {
                Class<?> scriptClass = Class.forName((String)className);
                script = (Script)scriptClass.newInstance();
            }
            catch (Exception cnfe) {
                throw this.runtime.newLoadError("no such file to load -- " + file);
            }
        }
        if (this.loadedFeaturesInternal.contains(loadName) || this.loadedFeatures.include_p(this.runtime.newString(loadName)).isTrue()) {
            return false;
        }
        try {
            this.loadedFeaturesInternal.add(loadName);
            this.firstLineLoadedFeatures.add(file);
            className = this.loadedFeatures;
            synchronized (className) {
                this.loadedFeatures.append(this.runtime.newString(loadName));
            }
            if (script != null) {
                this.runtime.loadScript(script);
                return true;
            }
            library.load(this.runtime);
            return true;
        }
        catch (Exception e) {
            if (library instanceof JarredScript && file.endsWith(".jar")) {
                return true;
            }
            this.loadedFeaturesInternal.remove(loadName);
            this.firstLineLoadedFeatures.remove(file);
            RubyArray cnfe = this.loadedFeatures;
            synchronized (cnfe) {
                this.loadedFeatures.remove(this.runtime.newString(loadName));
            }
            if (e instanceof RaiseException) {
                throw (RaiseException)e;
            }
            if (this.runtime.getDebug().isTrue()) {
                e.printStackTrace();
            }
            RaiseException re = this.runtime.newLoadError("IO error -- " + file);
            re.initCause(e);
            throw re;
        }
    }

    public boolean require(String file) {
        if (!this.runtime.getProfile().allowRequire(file)) {
            throw this.runtime.newLoadError("No such file to load -- " + file);
        }
        return this.smartLoad(file);
    }

    public IRubyObject getLoadPath() {
        return this.loadPath;
    }

    public IRubyObject getLoadedFeatures() {
        return this.loadedFeatures;
    }

    public IAutoloadMethod autoloadFor(String name) {
        return (IAutoloadMethod)this.autoloadMap.get(name);
    }

    public void removeAutoLoadFor(String name) {
        this.autoloadMap.remove(name);
    }

    public IRubyObject autoload(String name) {
        IAutoloadMethod loadMethod = (IAutoloadMethod)this.autoloadMap.remove(name);
        if (loadMethod != null) {
            return loadMethod.load(this.runtime, name);
        }
        return null;
    }

    public void addAutoload(String name, IAutoloadMethod loadMethod) {
        this.autoloadMap.put(name, loadMethod);
    }

    public void registerBuiltin(String name, Library library) {
        this.builtinLibraries.put(name, library);
    }

    public void registerRubyBuiltin(String libraryName) {
        this.registerBuiltin(libraryName + JRUBY_BUILTIN_SUFFIX, new BuiltinScript(libraryName));
    }

    private Library findLibrary(String file) {
        if (this.builtinLibraries.containsKey(file)) {
            return (Library)this.builtinLibraries.get(file);
        }
        LoadServiceResource resource = this.findFile(file);
        if (resource == null) {
            return null;
        }
        if (file.endsWith(".jar")) {
            return new JarredScript(resource);
        }
        return new ExternalScript(resource, file);
    }

    private Library findLibraryWithClassloaders(String file) {
        LoadServiceResource resource = this.findFileInClasspath(file);
        if (resource == null) {
            return null;
        }
        if (file.endsWith(".jar")) {
            return new JarredScript(resource);
        }
        return new ExternalScript(resource, file);
    }

    private LoadServiceResource findFile(String name) {
        if (name.startsWith("jar:")) {
            try {
                return new LoadServiceResource(new URL(name), name);
            }
            catch (MalformedURLException e) {
                throw this.runtime.newIOErrorFromException(e);
            }
        }
        try {
            JRubyFile file = JRubyFile.create(this.runtime.getCurrentDirectory(), name);
            if (file.isFile() && file.isAbsolute()) {
                try {
                    return new LoadServiceResource(file.toURI().toURL(), name);
                }
                catch (MalformedURLException e) {
                    throw this.runtime.newIOErrorFromException(e);
                }
            }
        }
        catch (IllegalArgumentException illArgEx) {
        }
        catch (SecurityException secEx) {
            // empty catch block
        }
        Iterator pathIter = this.loadPath.getList().iterator();
        while (pathIter.hasNext()) {
            Object current;
            String entry = pathIter.next().toString();
            if (entry.startsWith("jar:")) {
                current = (JarFile)this.jarFiles.get(entry);
                if (null == current) {
                    try {
                        current = new JarFile(entry.substring(4));
                        this.jarFiles.put(entry, current);
                    }
                    catch (FileNotFoundException ignored) {
                    }
                    catch (IOException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                }
                if (((JarFile)current).getJarEntry(name) != null) {
                    try {
                        return new LoadServiceResource(new URL("jar:file:" + entry.substring(4) + "!/" + name), entry + name);
                    }
                    catch (MalformedURLException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                }
            }
            try {
                current = JRubyFile.create(JRubyFile.create(this.runtime.getCurrentDirectory(), entry).getAbsolutePath(), name);
                if (!((File)current).isFile()) continue;
                try {
                    return new LoadServiceResource(((File)current).toURI().toURL(), ((JRubyFile)current).getPath());
                }
                catch (MalformedURLException e) {
                    throw this.runtime.newIOErrorFromException(e);
                }
            }
            catch (SecurityException secEx) {
            }
        }
        return null;
    }

    private LoadServiceResource findFileInClasspath(String name) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator pathIter = this.loadPath.getList().iterator();
        while (pathIter.hasNext()) {
            URL loc;
            String entry = pathIter.next().toString();
            if (entry.charAt(0) == '/' || entry.length() > 1 && entry.charAt(1) == ':' || !this.isRequireable(loc = classLoader.getResource(entry + "/" + name))) continue;
            return new LoadServiceResource(loc, loc.getPath());
        }
        if (name.charAt(0) == '/' || name.length() > 1 && name.charAt(1) == ':') {
            return null;
        }
        URL loc = classLoader.getResource(name);
        return this.isRequireable(loc) ? new LoadServiceResource(loc, loc.getPath()) : null;
    }

    private Library tryLoadExtension(Library library, String file) {
        Library oldLibrary = library;
        if ((library == null || library instanceof JarredScript) && !file.equalsIgnoreCase("")) {
            String[] all = file.split("/");
            StringBuffer finName = new StringBuffer();
            int j = all.length - 1;
            for (int i = 0; i < j; ++i) {
                finName.append(all[i].toLowerCase()).append(".");
            }
            String[] last = all[all.length - 1].split("_");
            int j2 = last.length;
            for (int i = 0; i < j2; ++i) {
                finName.append(Character.toUpperCase(last[i].charAt(0))).append(last[i].substring(1));
            }
            finName.append("Service");
            String className = finName.toString().replaceAll("^\\.*", "");
            if (library instanceof JarredScript) {
                this.runtime.getJavaSupport().addToClasspath(((JarredScript)library).getResource().getURL());
            }
            try {
                Class theClass = this.runtime.getJavaSupport().loadJavaClass(className);
                library = new ClassExtensionLibrary(theClass);
            }
            catch (Exception ee) {
                library = null;
                this.runtime.getGlobalVariables().set("$!", this.runtime.getNil());
            }
        }
        if (library == null && oldLibrary != null) {
            library = oldLibrary;
        }
        return library;
    }

    private boolean isRequireable(URL loc) {
        if (loc != null) {
            if (loc.getProtocol().equals("file") && new File(loc.getFile()).isDirectory()) {
                return false;
            }
            try {
                loc.openConnection();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

