/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.util.ByteList;
import org.jruby.util.IOHandler;
import org.jruby.util.IOHandlerJavaIO;
import org.jruby.util.IOModes;
import org.jruby.util.RubyInputStream;

public class IOHandlerUnseekable
extends IOHandlerJavaIO {
    protected InputStream input = null;
    protected OutputStream output = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IOHandlerUnseekable(Ruby runtime, InputStream inStream, OutputStream outStream) throws IOException {
        super(runtime);
        String mode = "";
        if (inStream != null) {
            this.input = inStream instanceof BufferedInputStream ? inStream : new BufferedInputStream(inStream);
            mode = mode + "r";
            this.isOpen = true;
        }
        if (outStream != null) {
            this.output = outStream;
            mode = mode + "w";
            this.isOpen = true;
        }
        if ("rw".equals(mode)) {
            this.modes = new IOModes(runtime, 2L);
            this.isOpen = true;
        } else {
            if (!this.isOpen) {
                throw new IOException("Opening nothing?");
            }
            this.modes = new IOModes(runtime, mode);
        }
        this.fileno = RubyIO.getNewFileno();
    }

    public IOHandlerUnseekable(Ruby runtime, int fileno) throws IOException {
        super(runtime);
        switch (fileno) {
            case 0: {
                this.input = new RubyInputStream(runtime.getIn());
                this.modes = new IOModes(runtime, "r");
                this.isOpen = true;
                break;
            }
            case 1: {
                this.output = runtime.getOut();
                this.modes = new IOModes(runtime, "w");
                this.isOpen = true;
                break;
            }
            case 2: {
                this.output = runtime.getErr();
                this.modes = new IOModes(runtime, "w");
                this.isOpen = true;
                break;
            }
            default: {
                throw new IOException("Bad file descriptor");
            }
        }
        this.fileno = fileno;
    }

    public IOHandlerUnseekable(Ruby runtime, int fileno, String mode) throws IOException {
        super(runtime);
        this.modes = new IOModes(runtime, mode);
        if (fileno < 0 || fileno > 2) {
            throw new IOException("Bad file descriptor");
        }
        if (this.modes.isReadable()) {
            this.input = new RubyInputStream(System.in);
            this.isOpen = true;
            if (this.modes.isWriteable()) {
                this.output = System.out;
            }
        } else if (this.isWriteable()) {
            this.output = System.out;
            this.isOpen = true;
        }
        this.fileno = fileno;
    }

    public ByteList getsEntireStream() throws IOException {
        ByteList b1 = new ByteList();
        byte[] buf = new byte[2048];
        boolean read = false;
        int n = 0;
        if (this.ungotc != -1) {
            b1.append(this.ungotc);
            read = true;
            this.ungotc = -1;
        }
        while (true) {
            if ((n = this.input.read(buf, 0, 2048)) == -1) {
                if (read) break;
                throw new EOFException();
            }
            read = true;
            b1.append(buf, 0, n);
        }
        return b1;
    }

    public IOHandler cloneIOHandler() throws IOException {
        return new IOHandlerUnseekable(this.getRuntime(), this.input, this.output);
    }

    public void close() throws IOException, IOHandler.BadDescriptorException {
        if (!this.isOpen()) {
            throw new IOHandler.BadDescriptorException();
        }
        this.isOpen = false;
        if (this.modes.isReadable() && this.input != System.in) {
            this.input.close();
        }
        if (this.modes.isWriteable() && this.output != System.out && this.output != System.err) {
            this.output.close();
        }
    }

    public void flush() throws IOException, IOHandler.BadDescriptorException {
        this.checkWriteable();
        this.output.flush();
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public boolean isEOF() throws IOException, IOHandler.BadDescriptorException {
        this.checkReadable();
        int c = this.input.read();
        if (c == -1) {
            return true;
        }
        this.ungetc(c);
        return false;
    }

    public int pid() {
        return -1;
    }

    public long pos() throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    public void resetByModes(IOModes newModes) {
    }

    public void rewind() throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    public void seek(long offset, int type) throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    public void sync() throws IOException {
        this.output.flush();
        if (this.output instanceof FileOutputStream) {
            ((FileOutputStream)this.output).getFD().sync();
        }
    }

    protected void sysread(ByteList buf, int off, int length) throws IOException {
        int read;
        int n;
        for (read = 0; read < length; read += n) {
            n = this.input.read(buf.bytes, buf.begin + off + read, length - read);
            if (n != -1) continue;
            if (read != 0) break;
            throw new EOFException();
        }
        buf.realSize += read;
    }

    public ByteList sysread(int number) throws IOException, IOHandler.BadDescriptorException {
        int read;
        int n;
        this.checkReadable();
        byte[] buf = new byte[number];
        for (read = 0; read < number; read += n) {
            n = this.input.read(buf, read, number - read);
            if (n != -1) continue;
            if (read != 0) break;
            throw new EOFException();
        }
        return new ByteList(buf, 0, read, false);
    }

    public int sysread() throws IOException {
        return this.input.read();
    }

    public int syswrite(ByteList buf) throws IOException, IOHandler.BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWriteable();
        if (buf == null || buf.realSize == 0) {
            return 0;
        }
        this.output.write(buf.bytes, buf.begin, buf.realSize);
        if (this.isSync) {
            this.sync();
        }
        return buf.realSize;
    }

    public int syswrite(int c) throws IOException, IOHandler.BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWriteable();
        this.output.write(c);
        if (this.isSync) {
            this.sync();
        }
        return c;
    }

    public void truncate(long newLength) throws IOException, IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    public FileChannel getFileChannel() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"No file channel for unseekable IO");
        }
        return null;
    }

    static {
        $assertionsDisabled = !IOHandlerUnseekable.class.desiredAssertionStatus();
    }
}

