/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jruby.util.ByteList;
import org.jvyamlb.Resolver;
import org.jvyamlb.ResolverException;
import org.jvyamlb.ResolverScanner;
import org.jvyamlb.nodes.MappingNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;
import org.jvyamlb.nodes.SequenceNode;

public class ResolverImpl
implements Resolver {
    private static final Map yamlPathResolvers = new HashMap();
    private static final ResolverScanner SCANNER = new ResolverScanner();
    private List resolverExactPaths = new LinkedList();
    private List resolverPrefixPaths = new LinkedList();

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addPathResolver(String tag, List path, Class kind) {
        LinkedList<Object[]> newPath = new LinkedList<Object[]>();
        Object var4_4 = null;
        Boolean indexCheck = null;
        Iterator iter = path.iterator();
        while (iter.hasNext()) {
            void var4_14;
            void var4_10;
            Object element = iter.next();
            if (element instanceof List) {
                List eList = (List)element;
                if (eList.size() == 2) {
                    Object e = eList.get(0);
                    indexCheck = (Boolean)eList.get(1);
                } else {
                    if (eList.size() != 1) throw new ResolverException("Invalid path element: " + element);
                    Object e = eList.get(0);
                    indexCheck = Boolean.TRUE;
                }
            } else {
                Object var4_9 = null;
                indexCheck = (Boolean)element;
            }
            if (var4_10 instanceof String || var4_10 instanceof ByteList) {
                Class clazz = class$org$jvyamlb$nodes$ScalarNode == null ? ResolverImpl.class$("org.jvyamlb.nodes.ScalarNode") : class$org$jvyamlb$nodes$ScalarNode;
            } else if (var4_10 instanceof List) {
                Class clazz = class$org$jvyamlb$nodes$SequenceNode == null ? ResolverImpl.class$("org.jvyamlb.nodes.SequenceNode") : class$org$jvyamlb$nodes$SequenceNode;
            } else if (var4_10 instanceof Map) {
                Class clazz = class$org$jvyamlb$nodes$MappingNode == null ? ResolverImpl.class$("org.jvyamlb.nodes.MappingNode") : class$org$jvyamlb$nodes$MappingNode;
            } else if (!(null == var4_10 || (class$org$jvyamlb$nodes$ScalarNode == null ? ResolverImpl.class$("org.jvyamlb.nodes.ScalarNode") : class$org$jvyamlb$nodes$ScalarNode).equals(var4_10) || (class$org$jvyamlb$nodes$SequenceNode == null ? ResolverImpl.class$("org.jvyamlb.nodes.SequenceNode") : class$org$jvyamlb$nodes$SequenceNode).equals(var4_10) || (class$org$jvyamlb$nodes$MappingNode == null ? ResolverImpl.class$("org.jvyamlb.nodes.MappingNode") : class$org$jvyamlb$nodes$MappingNode).equals(var4_10))) {
                throw new ResolverException("Invalid node checker: " + var4_10);
            }
            if (!(indexCheck instanceof String || var4_14 instanceof ByteList || indexCheck instanceof Integer || null == indexCheck)) {
                throw new ResolverException("Invalid index checker: " + indexCheck);
            }
            newPath.add(new Object[]{var4_14, indexCheck});
        }
        Class newKind = null;
        if (String.class.equals(kind) || ByteList.class.equals(kind)) {
            newKind = ScalarNode.class;
        } else if (List.class.equals(kind)) {
            newKind = SequenceNode.class;
        } else if (Map.class.equals(kind)) {
            newKind = MappingNode.class;
        } else {
            if (!(kind == null || ScalarNode.class.equals(kind) || SequenceNode.class.equals(kind) || MappingNode.class.equals(kind))) {
                throw new ResolverException("Invalid node kind: " + kind);
            }
            newKind = kind;
        }
        ArrayList<LinkedList<Object[]>> x = new ArrayList<LinkedList<Object[]>>(1);
        x.add(newPath);
        ArrayList<Serializable> y = new ArrayList<Serializable>(2);
        y.add(x);
        y.add(kind);
        yamlPathResolvers.put(y, tag);
    }

    public void descendResolver(Node currentNode, Object currentIndex) {
        HashMap exactPaths = new HashMap();
        LinkedList<Object> prefixPaths = new LinkedList<Object>();
        if (null != currentNode) {
            int depth = this.resolverPrefixPaths.size();
            Iterator iter = ((List)this.resolverPrefixPaths.get(0)).iterator();
            while (iter.hasNext()) {
                Object[] obj = (Object[])iter.next();
                List path = (List)obj[0];
                if (!this.checkResolverPrefix(depth, path, (Class)obj[1], currentNode, currentIndex)) continue;
                if (path.size() > depth) {
                    prefixPaths.add(new Object[]{path, obj[1]});
                    continue;
                }
                ArrayList<Object> resPath = new ArrayList<Object>(2);
                resPath.add(path);
                resPath.add(obj[1]);
                exactPaths.put(obj[1], yamlPathResolvers.get(resPath));
            }
        } else {
            Iterator iter = yamlPathResolvers.keySet().iterator();
            while (iter.hasNext()) {
                List key = (List)iter.next();
                List path = (List)key.get(0);
                Class kind = (Class)key.get(1);
                if (null == path) {
                    exactPaths.put(kind, yamlPathResolvers.get(key));
                    continue;
                }
                prefixPaths.add(key);
            }
        }
        this.resolverExactPaths.add(0, exactPaths);
        this.resolverPrefixPaths.add(0, prefixPaths);
    }

    public void ascendResolver() {
        this.resolverExactPaths.remove(0);
        this.resolverPrefixPaths.remove(0);
    }

    public boolean checkResolverPrefix(int depth, List path, Class kind, Node currentNode, Object currentIndex) {
        Object[] check = (Object[])path.get(depth - 1);
        Object nodeCheck = check[0];
        Object indexCheck = check[1];
        if (nodeCheck instanceof String ? !currentNode.getTag().equals(nodeCheck) : null != nodeCheck && !((Class)nodeCheck).isInstance(currentNode)) {
            return false;
        }
        if (indexCheck == Boolean.TRUE && currentIndex != null) {
            return false;
        }
        if (indexCheck == Boolean.FALSE && currentIndex == null) {
            return false;
        }
        return !(indexCheck instanceof String ? !(currentIndex instanceof ScalarNode) || !indexCheck.equals(((ScalarNode)currentIndex).getValue()) : (indexCheck instanceof ByteList ? !(currentIndex instanceof ScalarNode) || !indexCheck.equals(((ScalarNode)currentIndex).getValue()) : indexCheck instanceof Integer && !currentIndex.equals(indexCheck)));
    }

    public String resolve(Class kind, ByteList value, boolean[] implicit) {
        String resolv;
        Object resolvers = null;
        if (kind.equals(ScalarNode.class) && implicit[0] && (resolv = SCANNER.recognize(value)) != null) {
            return resolv;
        }
        Map exactPaths = (Map)this.resolverExactPaths.get(0);
        if (exactPaths.containsKey(kind)) {
            return (String)exactPaths.get(kind);
        }
        if (exactPaths.containsKey(null)) {
            return (String)exactPaths.get(null);
        }
        if (kind.equals(ScalarNode.class)) {
            return "tag:yaml.org,2002:str";
        }
        if (kind.equals(SequenceNode.class)) {
            return "tag:yaml.org,2002:seq";
        }
        if (kind.equals(MappingNode.class)) {
            return "tag:yaml.org,2002:map";
        }
        return null;
    }

    private static ByteList s(String se) {
        return new ByteList(se.getBytes());
    }

    public static void main(String[] args) {
        ByteList[] strings = new ByteList[]{ResolverImpl.s("yes"), ResolverImpl.s("NO"), ResolverImpl.s("booooooooooooooooooooooooooooooooooooooooooooooool"), ResolverImpl.s("false"), ResolverImpl.s(""), ResolverImpl.s("~"), ResolverImpl.s("~a"), ResolverImpl.s("<<"), ResolverImpl.s("10.1"), ResolverImpl.s("10000000000003435345.2324E+13"), ResolverImpl.s(".23"), ResolverImpl.s(".nan"), ResolverImpl.s("null"), ResolverImpl.s("124233333333333333"), ResolverImpl.s("0b030323"), ResolverImpl.s("+0b0111111011010101"), ResolverImpl.s("0xaafffdf"), ResolverImpl.s("2005-05-03"), ResolverImpl.s("2005-05-03a"), ResolverImpl.s(".nana"), ResolverImpl.s("2005-03-05T05:23:22"), ResolverImpl.s("="), ResolverImpl.s("= "), ResolverImpl.s("=a")};
        boolean[] implicit = new boolean[]{true, true};
        ResolverImpl res = new ResolverImpl();
        res.descendResolver(null, null);
        Class s = ScalarNode.class;
        long before = System.currentTimeMillis();
        int NUM = 100000;
        for (int j = 0; j < 100000; ++j) {
            for (int i = 0; i < strings.length; ++i) {
                res.resolve(s, strings[i % strings.length], implicit);
            }
        }
        long after = System.currentTimeMillis();
        long time = after - before;
        double timeS = (double)(after - before) / 1000.0;
        System.out.println("Resolving " + 100000 * strings.length + " nodes took " + time + "ms, or " + timeS + " seconds");
    }
}

