/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.SQLException;
import java.util.LinkedList;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.LockException;
import org.apache.openjpa.util.ObjectExistsException;
import org.apache.openjpa.util.ObjectNotFoundException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.OptimisticException;
import org.apache.openjpa.util.ReferentialIntegrityException;
import org.apache.openjpa.util.StoreException;

public class SQLExceptions {
    private static final SQLException[] EMPTY_EXCEPS = new SQLException[0];

    public static OpenJPAException getStore(SQLException se) {
        return SQLExceptions.getStore(se, null, null);
    }

    public static OpenJPAException getStore(SQLException se, Object failed) {
        return SQLExceptions.getStore(se, failed, null);
    }

    public static OpenJPAException getStore(SQLException se, DBDictionary dict) {
        return SQLExceptions.getStore(se.getMessage(), se, dict);
    }

    public static OpenJPAException getStore(SQLException se, Object failed, DBDictionary dict) {
        return SQLExceptions.getStore(se.getMessage(), se, failed, dict);
    }

    public static OpenJPAException getStore(Localizer.Message msg, SQLException se, DBDictionary dict) {
        return SQLExceptions.getStore(msg.getMessage(), se, null, dict);
    }

    public static OpenJPAException getStore(String msg, SQLException se, DBDictionary dict) {
        return SQLExceptions.getStore(msg, se, null, dict);
    }

    public static OpenJPAException getStore(String msg, SQLException se, Object failed, DBDictionary dict) {
        if (msg == null) {
            msg = se.getClass().getName();
        }
        Throwable[] ses = SQLExceptions.getSQLExceptions(se);
        if (dict == null) {
            return new StoreException(msg).setFailedObject(failed).setNestedThrowables(ses);
        }
        return dict.newStoreException(msg, (SQLException[])ses, failed);
    }

    private static SQLException[] getSQLExceptions(SQLException se) {
        if (se == null) {
            return EMPTY_EXCEPS;
        }
        LinkedList<SQLException> errs = new LinkedList<SQLException>();
        while (se != null && !errs.contains(se)) {
            errs.add(se);
            se = se.getNextException();
        }
        return errs.toArray(new SQLException[errs.size()]);
    }

    public static OpenJPAException narrow(String msg, SQLException se, DBDictionary dict) {
        String e = se.getSQLState();
        if (dict.getSQLStates(1).contains(e)) {
            return new LockException((Object)msg);
        }
        if (dict.getSQLStates(5).contains(e)) {
            return new ObjectExistsException(msg);
        }
        if (dict.getSQLStates(2).contains(e)) {
            return new ObjectNotFoundException((Object)msg);
        }
        if (dict.getSQLStates(3).contains(e)) {
            return new OptimisticException((Object)msg);
        }
        if (dict.getSQLStates(4).contains(e)) {
            return new ReferentialIntegrityException(msg);
        }
        return new StoreException(msg);
    }
}

