/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.portlet.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletContext;
import org.apache.tiles.context.MapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PortletApplicationScopeMap
implements Map<String, Object> {
    private PortletContext context = null;

    public PortletApplicationScopeMap(PortletContext context) {
        this.context = context;
    }

    @Override
    public void clear() {
        Iterator<String> keys = this.keySet().iterator();
        while (keys.hasNext()) {
            this.context.removeAttribute(keys.next());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.context.getAttribute(this.key(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Enumeration keys = this.context.getAttributeNames();
        while (keys.hasMoreElements()) {
            Object next = this.context.getAttribute((String)keys.nextElement());
            if (next != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>();
        Enumeration keys = this.context.getAttributeNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            set.add(new MapEntry<String, Object>(key, this.context.getAttribute(key), true));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        PortletContext otherContext = ((PortletApplicationScopeMap)o).context;
        boolean retValue = true;
        PortletContext portletContext = this.context;
        synchronized (portletContext) {
            Enumeration attribs = this.context.getAttributeNames();
            while (attribs.hasMoreElements() && retValue) {
                String parameterName = (String)attribs.nextElement();
                retValue = this.context.getAttribute(parameterName).equals(otherContext.getAttribute(parameterName));
            }
        }
        return retValue;
    }

    @Override
    public Object get(Object key) {
        return this.context.getAttribute(this.key(key));
    }

    @Override
    public int hashCode() {
        return this.context.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        Enumeration keys = this.context.getAttributeNames();
        while (keys.hasMoreElements()) {
            set.add((String)keys.nextElement());
        }
        return set;
    }

    @Override
    public Object put(String key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        String skey = this.key(key);
        Object previous = this.context.getAttribute(skey);
        this.context.setAttribute(skey, value);
        return previous;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        for (String string : map.keySet()) {
            this.context.setAttribute(string, map.get(string));
        }
    }

    @Override
    public Object remove(Object key) {
        String skey = this.key(key);
        Object previous = this.context.getAttribute(skey);
        this.context.removeAttribute(skey);
        return previous;
    }

    @Override
    public int size() {
        int n = 0;
        Enumeration keys = this.context.getAttributeNames();
        while (keys.hasMoreElements()) {
            keys.nextElement();
            ++n;
        }
        return n;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> list = new ArrayList<Object>();
        Enumeration keys = this.context.getAttributeNames();
        while (keys.hasMoreElements()) {
            list.add(this.context.getAttribute((String)keys.nextElement()));
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }
}

