/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.ProfileProviderException;
import com.sun.jmx.remote.generic.ProfileServer;
import com.sun.jmx.remote.generic.ProfileServerProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ProfileServerFactory {
    public static final String PROFILE_PROVIDER_PACKAGES = "jmx.remote.profile.provider.pkgs";
    public static final String PROFILE_PROVIDER_CLASS_LOADER = "jmx.remote.profile.provider.class.loader";
    private static final String PROFILE_PROVIDER_DEFAULT_PACKAGE = "com.sun.jmx.remote.profile";
    static /* synthetic */ Class class$com$sun$jmx$remote$generic$ProfileServerProvider;
    static /* synthetic */ Class class$com$sun$jmx$remote$generic$ProfileServerFactory;

    private ProfileServerFactory() {
    }

    public static ProfileServer createProfile(String string, Map map) throws ProfileProviderException {
        String string2 = ProfileServerFactory.resolvePkgs(map);
        ClassLoader classLoader = ProfileServerFactory.resolveClassLoader(map);
        map = map == null ? new HashMap<String, ClassLoader>() : new HashMap(map);
        map.put(PROFILE_PROVIDER_CLASS_LOADER, classLoader);
        map = Collections.unmodifiableMap(map);
        ProfileServerProvider profileServerProvider = ProfileServerFactory.getProvider(string, string2, classLoader);
        if (profileServerProvider == null) {
            throw new IllegalArgumentException("Unsupported profile: " + string);
        }
        return profileServerProvider.createProfile(string, map);
    }

    private static final String resolvePkgs(Map map) {
        String string = null;
        if (map != null) {
            string = (String)map.get(PROFILE_PROVIDER_PACKAGES);
        }
        if (string == null) {
            string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(ProfileServerFactory.PROFILE_PROVIDER_PACKAGES);
                }
            });
        }
        string = string == null || string.trim().equals("") ? PROFILE_PROVIDER_DEFAULT_PACKAGE : string + "|com.sun.jmx.remote.profile";
        return string;
    }

    private static final ProfileServerProvider getProvider(String string, String string2, ClassLoader classLoader) throws ProfileProviderException {
        Class<?> clazz = null;
        Object var4_4 = null;
        Object object = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        String string3 = string.toLowerCase();
        if (string3.indexOf("/") != -1) {
            string3 = string3.substring(0, string3.indexOf("/"));
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            String string5 = string4 + "." + string3 + ".ServerProvider";
            try {
                clazz = classLoader.loadClass(string5);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            try {
                object = clazz.newInstance();
            }
            catch (Exception exception) {
                String string6 = "Exception when instantiating provider [" + string5 + "]";
                throw new ProfileProviderException(string6, exception);
            }
            if (!(object instanceof ProfileServerProvider)) {
                String string7 = "Provider not an instance of " + (class$com$sun$jmx$remote$generic$ProfileServerProvider == null ? (class$com$sun$jmx$remote$generic$ProfileServerProvider = ProfileServerFactory.class$("com.sun.jmx.remote.generic.ProfileServerProvider")) : class$com$sun$jmx$remote$generic$ProfileServerProvider).getName() + ": " + object.getClass().getName();
                throw new IllegalArgumentException(string7);
            }
            return (ProfileServerProvider)object;
        }
        return null;
    }

    private static final ClassLoader resolveClassLoader(Map map) {
        ClassLoader classLoader = null;
        if (map != null) {
            try {
                classLoader = (ClassLoader)map.get(PROFILE_PROVIDER_CLASS_LOADER);
            }
            catch (ClassCastException classCastException) {
                String string = "ClassLoader not an instance of java.lang.ClassLoader : " + classLoader.getClass().getName();
                throw new IllegalArgumentException(string);
            }
        }
        if (classLoader == null) {
            classLoader = (class$com$sun$jmx$remote$generic$ProfileServerFactory == null ? (class$com$sun$jmx$remote$generic$ProfileServerFactory = ProfileServerFactory.class$("com.sun.jmx.remote.generic.ProfileServerFactory")) : class$com$sun$jmx$remote$generic$ProfileServerFactory).getClassLoader();
        }
        return classLoader;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

