/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.opt.util.ClassLogger;
import java.io.IOException;
import java.io.OutputStream;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;

public class SASLOutputStream
extends OutputStream {
    private int rawSendSize = 65536;
    private byte[] lenBuf = new byte[4];
    private OutputStream out;
    private SaslClient sc;
    private SaslServer ss;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "SASLOutputStream");

    public SASLOutputStream(SaslClient saslClient, OutputStream outputStream) throws IOException {
        this.out = outputStream;
        this.sc = saslClient;
        this.ss = null;
        String string = (String)saslClient.getNegotiatedProperty("javax.security.sasl.rawsendsize");
        if (string != null) {
            try {
                this.rawSendSize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("javax.security.sasl.rawsendsize property must be numeric string: " + string);
            }
        }
    }

    public SASLOutputStream(SaslServer saslServer, OutputStream outputStream) throws IOException {
        this.out = outputStream;
        this.ss = saslServer;
        this.sc = null;
        String string = (String)saslServer.getNegotiatedProperty("javax.security.sasl.rawsendsize");
        if (string != null) {
            try {
                this.rawSendSize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("javax.security.sasl.rawsendsize property must be numeric string: " + string);
            }
        }
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (logger.traceOn()) {
            logger.trace("write", "Total size: " + n2);
        }
        for (int i = 0; i < n2; i += this.rawSendSize) {
            int n3 = n2 - i < this.rawSendSize ? n2 - i : this.rawSendSize;
            byte[] byArray2 = this.sc != null ? this.sc.wrap(byArray, n + i, n3) : this.ss.wrap(byArray, n + i, n3);
            this.intToNetworkByteOrder(byArray2.length, this.lenBuf, 0, 4);
            if (logger.traceOn()) {
                logger.trace("write", "sending size: " + byArray2.length);
            }
            this.out.write(this.lenBuf, 0, 4);
            this.out.write(byArray2, 0, byArray2.length);
        }
    }

    public void close() throws IOException {
        if (this.sc != null) {
            this.sc.dispose();
        } else {
            this.ss.dispose();
        }
        this.out.close();
    }

    private void intToNetworkByteOrder(int n, byte[] byArray, int n2, int n3) {
        if (n3 > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        for (int i = n3 - 1; i >= 0; --i) {
            byArray[n2 + i] = (byte)(n & 0xFF);
            n >>>= 8;
        }
    }
}

