/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CliquePotentialFunction;

public class NoisyLabelLinearCliquePotentialFunction
implements CliquePotentialFunction {
    private final double[][] weights;
    private final int[] docLabels;
    private final double[][] errorMatrix;

    public NoisyLabelLinearCliquePotentialFunction(double[][] weights, int[] docLabels, double[][] errorMatrix) {
        this.weights = weights;
        this.docLabels = docLabels;
        this.errorMatrix = errorMatrix;
    }

    private double g(int labelIndex, int posInSent) {
        if (this.errorMatrix == null) {
            return 0.0;
        }
        int observed = this.docLabels[posInSent];
        return this.errorMatrix[labelIndex][observed];
    }

    @Override
    public double computeCliquePotential(int cliqueSize, int labelIndex, int[] cliqueFeatures, double[] featureVal, int posInSent) {
        double output = 0.0;
        double dotProd = 0.0;
        for (int cliqueFeature : cliqueFeatures) {
            dotProd = this.weights[cliqueFeature][labelIndex];
            output += dotProd;
        }
        if (cliqueSize == 1) {
            output += this.g(labelIndex, posInSent);
        }
        return output;
    }
}

