/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.pipeline.CoreMapAttributeAggregator;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.HasInterval;
import edu.stanford.nlp.util.Interval;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class CoreMapAggregator
implements Function<List<? extends CoreMap>, CoreMap> {
    public static final CoreMapAggregator DEFAULT_AGGREGATOR = CoreMapAggregator.getAggregator(CoreMapAttributeAggregator.getDefaultAggregators());
    Map<Class, CoreMapAttributeAggregator> aggregators;
    Class mergedKey = null;

    public CoreMapAggregator(Map<Class, CoreMapAttributeAggregator> aggregators) {
        this.aggregators = aggregators;
    }

    public CoreMapAggregator(Map<Class, CoreMapAttributeAggregator> aggregators, Class mergedKey) {
        this.aggregators = aggregators;
        this.mergedKey = mergedKey;
    }

    public CoreMap merge(List<? extends CoreMap> in, int start, int end) {
        CoreMap merged = ChunkAnnotationUtils.getMergedChunk(in, start, end, this.aggregators);
        if (this.mergedKey != null) {
            merged.set(this.mergedKey, new ArrayList<CoreMap>(in.subList(start, end)));
        }
        return merged;
    }

    @Override
    public CoreMap apply(List<? extends CoreMap> in) {
        return this.merge(in, 0, in.size());
    }

    public static CoreMapAggregator getDefaultAggregator() {
        return DEFAULT_AGGREGATOR;
    }

    public static CoreMapAggregator getAggregator(Map<Class, CoreMapAttributeAggregator> aggregators) {
        return new CoreMapAggregator(aggregators);
    }

    public static CoreMapAggregator getAggregator(Map<Class, CoreMapAttributeAggregator> aggregators, Class key) {
        return new CoreMapAggregator(aggregators, key);
    }

    public List<CoreMap> merge(List<? extends CoreMap> list, List<? extends HasInterval<Integer>> matched) {
        return CollectionUtils.mergeList(list, matched, this);
    }

    public <M> List<CoreMap> merge(List<? extends CoreMap> list, List<M> matched, Function<M, Interval<Integer>> toIntervalFunc) {
        return CollectionUtils.mergeList(list, matched, toIntervalFunc, this);
    }
}

