/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ChineseGrammaticalRelations {
    private static final TregexPatternCompiler tregexCompiler = new TregexPatternCompiler((HeadFinder)null);
    public static final GrammaticalRelation ARGUMENT = new GrammaticalRelation(Language.Chinese, "arg", "argument", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation SUBJECT = new GrammaticalRelation(Language.Chinese, "subj", "subject", ARGUMENT);
    public static final GrammaticalRelation NOMINAL_SUBJECT = new GrammaticalRelation(Language.Chinese, "nsubj", "nominal subject", SUBJECT, "IP|VP", tregexCompiler, "IP <( ( NP|QP=target!< NT ) $++ ( /^VP|VCD|IP/  !< VE !<VC !<SB !<LB  ))", "NP !$+ VP < ( (  NP|DP|QP=target !< NT ) $+ ( /^VP|VCD/ !<VE !< VC !<SB !<LB))", "IP < (/^NP/=target $+ (VP < VC))");
    public static final GrammaticalRelation NOMINAL_PASSIVE_SUBJECT = new GrammaticalRelation(Language.Chinese, "nsubjpass", "nominal passive subject", NOMINAL_SUBJECT, "IP", tregexCompiler, "IP < (NP=target $+ (VP|IP < SB|LB))");
    public static final GrammaticalRelation COMPLEMENT = new GrammaticalRelation(Language.Chinese, "comp", "complement", ARGUMENT);
    public static final GrammaticalRelation OBJECT = new GrammaticalRelation(Language.Chinese, "obj", "object", COMPLEMENT);
    public static final GrammaticalRelation DIRECT_OBJECT = new GrammaticalRelation(Language.Chinese, "dobj", "direct object", OBJECT, "CP|VP", tregexCompiler, "VP < ( /^V*/ $+ NP $+ NP|DP=target ) !< VC ", " VP < ( /^V*/ $+ NP|DP=target ! $+ NP|DP) !< VC ", "CP < (IP $++ NP=target ) !<< VC");
    public static final GrammaticalRelation INDIRECT_OBJECT = new GrammaticalRelation(Language.Chinese, "iobj", "indirect object", OBJECT, "VP", tregexCompiler, " CP !> VP < ( VV $+ ( NP|DP|QP|CLP=target . NP|DP ) )");
    public static final GrammaticalRelation RANGE = new GrammaticalRelation(Language.Chinese, "range", "range", INDIRECT_OBJECT, "VP", tregexCompiler, "VP < ( NP|DP|QP $+ NP|DP|QP=target)", "VP < ( VV $+ QP=target )");
    public static final GrammaticalRelation CLAUSAL_COMPLEMENT = new GrammaticalRelation(Language.Chinese, "ccomp", "clausal complement", COMPLEMENT, "VP|ADJP|IP", tregexCompiler, "  VP  < VV|VC|VRD|VCD  !< NP|QP|LCP  < IP|VP|VRD|VCD=target > IP|VP ");
    public static final GrammaticalRelation MODIFIER = new GrammaticalRelation(Language.Chinese, "mod", "modifier", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation NUMERIC_MODIFIER = new GrammaticalRelation(Language.Chinese, "nummod", "numeric modifier", MODIFIER, "QP|NP", tregexCompiler, "QP < CD=target", "NP < ( QP=target !<< CLP )");
    public static final GrammaticalRelation ORDINAL_MODIFIER = new GrammaticalRelation(Language.Chinese, "ordmod", "ordinal numeric modifier", NUMERIC_MODIFIER, "NP|QP", tregexCompiler, "NP < QP=target < ( OD !$+ CLP )", "QP < (OD=target $+ CLP)");
    public static final GrammaticalRelation APPOSITIONAL_MODIFIER = new GrammaticalRelation(Language.Chinese, "appos", "appositional modifier", MODIFIER);
    public static final GrammaticalRelation PARENTHETICAL_MODIFIER = new GrammaticalRelation(Language.Chinese, "prnmod", "parenthetical modifier", MODIFIER, "NP", tregexCompiler, "NP < PRN=target ");
    public static final GrammaticalRelation NOUN_MODIFIER = new GrammaticalRelation(Language.Chinese, "nmod", "noun modifier", MODIFIER);
    public static final GrammaticalRelation ASSOCIATIVE_MODIFIER = new GrammaticalRelation(Language.Chinese, "assmod", "associative modifier (examples: \u4e0a\u6d77\u5e02/Shanghai[modifier] \u7684 \u89c4\u5b9a/law[head])", NOUN_MODIFIER, "NP|QP", tregexCompiler, "NP|QP < ( DNP =target $++ NP|QP ) ");
    public static final GrammaticalRelation TEMPORAL_MODIFIER = new GrammaticalRelation(Language.Chinese, "tmod", "temporal modifier", NOUN_MODIFIER, "VP|IP", tregexCompiler, "VP|IP < (NP=target < NT !.. /^VC$/ $++  VP)");
    public static final GrammaticalRelation RELATIVE_CLAUSE_MODIFIER = new GrammaticalRelation(Language.Chinese, "relcl", "relative clause modifier", MODIFIER, "NP", tregexCompiler, "NP  $++ (CP=target ) > NP ", "NP  < ( CP=target $++ NP )");
    public static final GrammaticalRelation NONFINITE_CLAUSE_MODIFIER = new GrammaticalRelation(Language.Chinese, "nfincl", "non-finite clause modifier (examples: stores[head] based[modifier] in Boston", MODIFIER, "NP", tregexCompiler, "NP < IP=target ");
    public static final GrammaticalRelation ADJECTIVAL_MODIFIER = new GrammaticalRelation(Language.Chinese, "amod", "adjectival modifier", MODIFIER, "NP|CLP|QP", tregexCompiler, "NP|CLP|QP < (ADJP=target $++ NP|CLP|QP ) ");
    public static final GrammaticalRelation DETERMINER = new GrammaticalRelation(Language.Chinese, "det", "determiner", MODIFIER, "^NP|DP", tregexCompiler, "/^NP/ < (DP=target $++ NP )");
    public static final GrammaticalRelation NEGATION_MODIFIER = new GrammaticalRelation(Language.Chinese, "neg", "negation modifier", MODIFIER, "VP|ADJP|IP", tregexCompiler, "VP|ADJP|IP < (AD|VV=target < /^(\\u4e0d|\\u6CA1|\\u6CA1\\u6709)$/)", "VP|ADJP|IP < (ADVP|VV=target < (AD < /^(\\u4e0d|\\u6CA1|\\u6CA1\\u6709)$/))");
    public static final GrammaticalRelation ADVERBIAL_MODIFIER = new GrammaticalRelation(Language.Chinese, "advmod", "adverbial modifier", MODIFIER, "VP|ADJP|IP|CP|PP|NP|QP", tregexCompiler, "VP|ADJP|IP|CP|PP|NP < (ADVP=target !< (AD < /^(\\u4e0d|\\u6CA1|\\u6CA1\\u6709)$/))", "VP|ADJP < AD|CS=target", "QP < (ADVP=target $+ QP)", "QP < ( QP $+ ADVP=target)");
    public static final GrammaticalRelation DVPM_MODIFIER = new GrammaticalRelation(Language.Chinese, "dvpmod", "dvp modifier", ADVERBIAL_MODIFIER, "VP", tregexCompiler, " VP < ( DVP=target $+ VP) ");
    public static final GrammaticalRelation AUX_MODIFIER = new GrammaticalRelation(Language.Chinese, "aux", "auxiliary (example: should[modifier] leave[head])", GrammaticalRelation.DEPENDENT, "VP", tregexCompiler, new String[0]);
    public static final GrammaticalRelation MODAL_VERB = new GrammaticalRelation(Language.Chinese, "mmod", "modal verb", AUX_MODIFIER, "VP", tregexCompiler, "VP < ( VV=target !< /^\u6ca1\u6709$/ $+ VP|VRD )");
    public static final GrammaticalRelation ASPECT_MARKER = new GrammaticalRelation(Language.Chinese, "asp", "aspect", AUX_MODIFIER, "VP", tregexCompiler, "VP < ( /^V*/ $+ AS=target)");
    public static final GrammaticalRelation AUX_PASSIVE_MODIFIER = new GrammaticalRelation(Language.Chinese, "auxpass", "auxiliary passive", MODIFIER, "VP", tregexCompiler, "VP < SB|LB=target");
    public static final GrammaticalRelation COPULA = new GrammaticalRelation(Language.Chinese, "cop", "copula", GrammaticalRelation.DEPENDENT, "VP", tregexCompiler, " VP < VC=target");
    public static final GrammaticalRelation MARK = new GrammaticalRelation(Language.Chinese, "mark", "marker (examples: that[modifier] expanded[head]; \u5f00\u53d1/expand[head] \u6d66\u4e1c/Pudong \u7684[modifier])", GrammaticalRelation.DEPENDENT, "^PP|^LCP|^CP|^DVP", tregexCompiler, "/^PP/ < (P=target $+ VP)", "/^LCP/ < (P=target $+ VP)", "/^CP/ < (__  $++ DEC=target)", "DVP < (__ $+ DEV=target)");
    public static final GrammaticalRelation PUNCTUATION = new GrammaticalRelation(Language.Chinese, "punct", "punctuation", GrammaticalRelation.DEPENDENT, ".*", tregexCompiler, "__ < PU=target");
    public static final GrammaticalRelation COMPOUND = new GrammaticalRelation(Language.Chinese, "compound", "compound (examples: phone book, three thousand)", ARGUMENT);
    public static final GrammaticalRelation NOUN_COMPOUND = new GrammaticalRelation(Language.Chinese, "nn", "noun compound", COMPOUND, "^NP", tregexCompiler, "NP < (NN|NR|NT=target $+ NN|NR|NT)", "NP < (NN|NR|NT $+ FW=target)", "NP < (NP=target !$+ PU|CC $++ NP|PRN)");
    public static final GrammaticalRelation VERB_COMPOUND = new GrammaticalRelation(Language.Chinese, "comod", "coordinated verb compound", COMPOUND, "VCD", tregexCompiler, "VCD < ( VV|VA $+  VV|VA=target)");
    public static final GrammaticalRelation CONJUNCT = new GrammaticalRelation(Language.Chinese, "conj", "conjunct", GrammaticalRelation.DEPENDENT, "FRAG|INC|IP|VP|NP|ADJP|PP|ADVP|UCP", tregexCompiler, "NP|ADJP|PP|ADVP|UCP < (!PU|CC=target $+ CC)", "VP < (!PU|CC=target !$- VP $+ CC)", "VP|NP|ADJP|PP|ADVP|UCP < ( __=target $+ PU $+ CC)", "VP   < ( /^V/=target  $+ ((PU < \u3001) $+ /^V/))", "NP   < ( /^N/=target  $+ ((PU < \u3001) $+ /^N/))", "ADJP < ( JJ|ADJP=target  $+ ((PU < \u3001) $+ JJ|ADJP))", "PP   < ( /^P/=target  $+ ((PU < \u3001) $+ /^P/))", "ADVP < ( /^AD/ $+ ((PU < \u3001) $+ /^AD/=target))", "UCP  < ( !PU|CC=target    $+ (PU < \u3001) )", "PP < (PP $+ PP=target )", "NP <( NP=target $+ ((PU < \u3001) $+ NP) )", "NP <( NN|NR|NT|PN=target $+ ((PU < \uff0c|\u3001) $+ NN|NR|NT|PN) )", "VP < (CC $+ VV=target)", "FRAG|INC|IP|VP < (VP  < VV|VC|VRD|VCD|VE|VA < NP|QP|LCP  $ IP|VP|VRD|VCD|VE|VC|VA=target)  ", "IP|VP < ( IP|VP < NP|QP|LCP $ IP|VP=target )");
    public static final GrammaticalRelation COORDINATION = new GrammaticalRelation(Language.Chinese, "cc", "coordination", GrammaticalRelation.DEPENDENT, "VP|NP|ADJP|PP|ADVP|UCP|IP|QP", tregexCompiler, "VP|NP|ADJP|PP|ADVP|UCP|IP|QP < (CC=target)");
    public static final GrammaticalRelation CASE = new GrammaticalRelation(Language.Chinese, "case", "case marking (examples: Chair[head] 's[modifier], \u6839\u636e/according[modifier] ... \u89c4\u5b9a/rule[head]; \u8fd1\u5e74/this year[head] \u6765[modifier])", GrammaticalRelation.DEPENDENT, "^PP|^LCP|^DNP", tregexCompiler, "/^PP/ < P=target", "/^LCP/ < LC=target", "/^DNP/ < DEG=target");
    public static final GrammaticalRelation PREPOSITIONAL_LOCALIZER_MODIFIER = new GrammaticalRelation(Language.Chinese, "plmod", "prepositional localizer modifier", MODIFIER, "PP", tregexCompiler, "PP < ( P $++ LCP=target )");
    public static final GrammaticalRelation LOCALIZER_COMPLEMENT = new GrammaticalRelation(Language.Chinese, "loc", "localizer complement", COMPLEMENT, "VP|IP", tregexCompiler, "VP|IP < LCP=target ");
    public static final GrammaticalRelation RESULTATIVE_COMPLEMENT = new GrammaticalRelation(Language.Chinese, "rcomp", "result verb", COMPLEMENT, "VRD", tregexCompiler, "VRD < ( /V*/ $+ /V*/=target )");
    public static final GrammaticalRelation BA = new GrammaticalRelation(Language.Chinese, "ba", "ba", GrammaticalRelation.DEPENDENT, "VP|IP", tregexCompiler, "VP|IP < BA=target ");
    public static final GrammaticalRelation CLASSIFIER_MODIFIER = new GrammaticalRelation(Language.Chinese, "clf", "classifier modifier", MODIFIER, "^NP|DP|QP", tregexCompiler, "NP|QP < ( QP  =target << M $++ NN|NP|QP)", "DP < ( DT $+ CLP=target )");
    public static final GrammaticalRelation PREPOSITIONAL_MODIFIER = new GrammaticalRelation(Language.Chinese, "prep", "prepositional modifier", MARK, "^NP|VP|IP", tregexCompiler, "/^NP/ < /^PP/=target", "VP < /^PP/=target", "IP < /^PP/=target ");
    public static final GrammaticalRelation PART_VERB = new GrammaticalRelation(Language.Chinese, "prtmod", "particle verb", MODIFIER, "VP|IP", tregexCompiler, "VP|IP < ( MSP=target )");
    public static final GrammaticalRelation ETC = new GrammaticalRelation(Language.Chinese, "etc", "ETC", MODIFIER, "^NP", tregexCompiler, "/^NP/ < (NN|NR . ETC=target)");
    public static final GrammaticalRelation CONTROLLED_SUBJECT = new GrammaticalRelation(Language.Chinese, "xsubj", "controlled subject", GrammaticalRelation.DEPENDENT, "VP", tregexCompiler, "VP !< NP < VP > (IP !$- NP !< NP !>> (VP < VC ) >+(VP) (VP $-- NP=target))");
    private static final GrammaticalRelation chineseOnly = null;
    private static final GrammaticalRelation[] rawValues = new GrammaticalRelation[]{GrammaticalRelation.DEPENDENT, ARGUMENT, SUBJECT, NOMINAL_SUBJECT, NOMINAL_PASSIVE_SUBJECT, COMPLEMENT, OBJECT, DIRECT_OBJECT, INDIRECT_OBJECT, RANGE, CLAUSAL_COMPLEMENT, MODIFIER, NUMERIC_MODIFIER, ORDINAL_MODIFIER, chineseOnly, APPOSITIONAL_MODIFIER, PARENTHETICAL_MODIFIER, chineseOnly, NOUN_MODIFIER, ASSOCIATIVE_MODIFIER, chineseOnly, TEMPORAL_MODIFIER, chineseOnly, RELATIVE_CLAUSE_MODIFIER, NONFINITE_CLAUSE_MODIFIER, ADJECTIVAL_MODIFIER, DETERMINER, NEGATION_MODIFIER, ADVERBIAL_MODIFIER, DVPM_MODIFIER, chineseOnly, AUX_MODIFIER, MODAL_VERB, chineseOnly, ASPECT_MARKER, chineseOnly, AUX_PASSIVE_MODIFIER, COPULA, MARK, PUNCTUATION, COMPOUND, NOUN_COMPOUND, chineseOnly, VERB_COMPOUND, chineseOnly, CONJUNCT, COORDINATION, CASE, PREPOSITIONAL_LOCALIZER_MODIFIER, chineseOnly, LOCALIZER_COMPLEMENT, chineseOnly, RESULTATIVE_COMPLEMENT, chineseOnly, BA, chineseOnly, CLASSIFIER_MODIFIER, chineseOnly, PREPOSITIONAL_MODIFIER, chineseOnly, PART_VERB, chineseOnly, ETC, chineseOnly, CONTROLLED_SUBJECT, chineseOnly};
    private static final List<GrammaticalRelation> values = new ArrayList<GrammaticalRelation>();
    public static final Set<GrammaticalRelation> universalValues = new HashSet<GrammaticalRelation>();
    public static final Map<String, GrammaticalRelation> shortNameToGRel = new ConcurrentHashMap<String, GrammaticalRelation>();

    private ChineseGrammaticalRelations() {
    }

    public static List<GrammaticalRelation> values() {
        return Collections.unmodifiableList(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrammaticalRelation valueOf(String s) {
        List<GrammaticalRelation> list = values;
        synchronized (list) {
            return GrammaticalRelation.valueOf(s, ChineseGrammaticalRelations.values());
        }
    }

    public static void main(String[] args) {
        System.out.println(GrammaticalRelation.DEPENDENT.toPrettyString());
    }

    static {
        for (int i = 0; i < rawValues.length; ++i) {
            GrammaticalRelation gr = rawValues[i];
            if (gr == chineseOnly) continue;
            values.add(gr);
            if (i + 1 != rawValues.length && rawValues[i + 1] == chineseOnly) continue;
            universalValues.add(gr);
        }
        for (GrammaticalRelation gr : ChineseGrammaticalRelations.values()) {
            shortNameToGRel.put(gr.getShortName(), gr);
        }
    }
}

