/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CliquePotentialFunction;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.sequences.SeqClassifierFlags;

public class NonLinearSecondOrderCliquePotentialFunction
implements CliquePotentialFunction {
    private final double[][] inputLayerWeights4Edge;
    private final double[][] outputLayerWeights4Edge;
    private final double[][] inputLayerWeights;
    private final double[][] outputLayerWeights;
    private double[] layerOneCache;
    private double[] hiddenLayerCache;
    private double[] layerOneCache4Edge;
    private double[] hiddenLayerCache4Edge;
    private final SeqClassifierFlags flags;

    public NonLinearSecondOrderCliquePotentialFunction(double[][] inputLayerWeights4Edge, double[][] outputLayerWeights4Edge, double[][] inputLayerWeights, double[][] outputLayerWeights, SeqClassifierFlags flags) {
        this.inputLayerWeights4Edge = inputLayerWeights4Edge;
        this.outputLayerWeights4Edge = outputLayerWeights4Edge;
        this.inputLayerWeights = inputLayerWeights;
        this.outputLayerWeights = outputLayerWeights;
        this.flags = flags;
    }

    public double[] hiddenLayerOutput(double[][] inputLayerWeights, int[] nodeCliqueFeatures, SeqClassifierFlags aFlag, double[] featureVal, int cliqueSize) {
        int i;
        double[] layerCache = null;
        double[] hlCache = null;
        int layerOneSize = inputLayerWeights.length;
        if (cliqueSize > 1) {
            if (this.layerOneCache4Edge == null || layerOneSize != this.layerOneCache4Edge.length) {
                this.layerOneCache4Edge = new double[layerOneSize];
            }
            layerCache = this.layerOneCache4Edge;
        } else {
            if (this.layerOneCache == null || layerOneSize != this.layerOneCache.length) {
                this.layerOneCache = new double[layerOneSize];
            }
            layerCache = this.layerOneCache;
        }
        for (i = 0; i < layerOneSize; ++i) {
            double[] ws = inputLayerWeights[i];
            double lOneW = 0.0;
            double dotProd = 0.0;
            for (int m = 0; m < nodeCliqueFeatures.length; ++m) {
                dotProd = ws[nodeCliqueFeatures[m]];
                if (featureVal != null) {
                    dotProd *= featureVal[m];
                }
                lOneW += dotProd;
            }
            layerCache[i] = lOneW;
        }
        if (!aFlag.useHiddenLayer) {
            return layerCache;
        }
        if (cliqueSize > 1) {
            if (this.hiddenLayerCache4Edge == null || layerOneSize != this.hiddenLayerCache4Edge.length) {
                this.hiddenLayerCache4Edge = new double[layerOneSize];
            }
            hlCache = this.hiddenLayerCache4Edge;
        } else {
            if (this.hiddenLayerCache == null || layerOneSize != this.hiddenLayerCache.length) {
                this.hiddenLayerCache = new double[layerOneSize];
            }
            hlCache = this.hiddenLayerCache;
        }
        for (i = 0; i < layerOneSize; ++i) {
            hlCache[i] = aFlag.useSigmoid ? NonLinearSecondOrderCliquePotentialFunction.sigmoid(layerCache[i]) : Math.tanh(layerCache[i]);
        }
        return hlCache;
    }

    private static double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    @Override
    public double computeCliquePotential(int cliqueSize, int labelIndex, int[] cliqueFeatures, double[] featureVal, int posInSent) {
        double[][] inputWeights;
        double output = 0.0;
        double[][] outputWeights = null;
        if (cliqueSize > 1) {
            inputWeights = this.inputLayerWeights4Edge;
            outputWeights = this.outputLayerWeights4Edge;
        } else {
            inputWeights = this.inputLayerWeights;
            outputWeights = this.outputLayerWeights;
        }
        double[] hiddenLayer = this.hiddenLayerOutput(inputWeights, cliqueFeatures, this.flags, featureVal, cliqueSize);
        int outputLayerSize = inputWeights.length / outputWeights[0].length;
        if (this.flags.useOutputLayer) {
            double[] outputWs = null;
            outputWs = this.flags.tieOutputLayer ? outputWeights[0] : outputWeights[labelIndex];
            if (this.flags.softmaxOutputLayer) {
                outputWs = ArrayMath.softmax(outputWs);
            }
            for (int i = 0; i < inputWeights.length; ++i) {
                if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                    if (i % outputLayerSize != labelIndex) continue;
                    output += outputWs[i / outputLayerSize] * hiddenLayer[i];
                    continue;
                }
                output += outputWs[i] * hiddenLayer[i];
            }
        } else {
            output = hiddenLayer[labelIndex];
        }
        return output;
    }
}

