/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalStructure;
import java.util.function.Predicate;

public class UniversalEnglishGrammaticalStructureFactory
implements GrammaticalStructureFactory {
    private final Predicate<String> puncFilter;
    private final HeadFinder hf;

    public UniversalEnglishGrammaticalStructureFactory() {
        this(null, null);
    }

    public UniversalEnglishGrammaticalStructureFactory(Predicate<String> puncFilter) {
        this(puncFilter, null);
    }

    public UniversalEnglishGrammaticalStructureFactory(Predicate<String> puncFilter, HeadFinder hf) {
        this.puncFilter = puncFilter;
        this.hf = hf;
    }

    @Override
    public UniversalEnglishGrammaticalStructure newGrammaticalStructure(Tree t) {
        if (this.puncFilter == null && this.hf == null) {
            return new UniversalEnglishGrammaticalStructure(t);
        }
        if (this.hf == null) {
            return new UniversalEnglishGrammaticalStructure(t, this.puncFilter);
        }
        return new UniversalEnglishGrammaticalStructure(t, this.puncFilter, this.hf);
    }
}

