/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.util.Generics;
import java.time.ZoneId;
import java.util.Set;
import java.util.TimeZone;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.Instant;
import org.joda.time.Partial;
import org.joda.time.Period;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.OffsetDateTimeField;
import org.joda.time.field.RemainderDateTimeField;
import org.joda.time.field.ScaledDurationField;

public class JodaTimeUtils {
    protected static final ZoneId UTC = ZoneId.of("UTC");
    protected static final DateTimeFieldType[] standardISOFields = new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.monthOfYear(), DateTimeFieldType.dayOfMonth(), DateTimeFieldType.hourOfDay(), DateTimeFieldType.minuteOfHour(), DateTimeFieldType.secondOfMinute(), DateTimeFieldType.millisOfSecond()};
    protected static final DateTimeFieldType[] standardISOWeekFields = new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.weekOfWeekyear(), DateTimeFieldType.dayOfWeek(), DateTimeFieldType.hourOfDay(), DateTimeFieldType.minuteOfHour(), DateTimeFieldType.secondOfMinute(), DateTimeFieldType.millisOfSecond()};
    protected static final DateTimeFieldType[] standardISODateFields = new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.monthOfYear(), DateTimeFieldType.dayOfMonth()};
    protected static final DateTimeFieldType[] standardISOTimeFields = new DateTimeFieldType[]{DateTimeFieldType.hourOfDay(), DateTimeFieldType.minuteOfHour(), DateTimeFieldType.secondOfMinute(), DateTimeFieldType.millisOfSecond()};
    public static final Partial EMPTY_ISO_PARTIAL = new Partial(standardISOFields, new int[]{0, 1, 1, 0, 0, 0, 0});
    public static final Partial EMPTY_ISO_WEEK_PARTIAL = new Partial(standardISOWeekFields, new int[]{0, 1, 1, 0, 0, 0, 0});
    public static final Partial EMPTY_ISO_DATE_PARTIAL = new Partial(standardISODateFields, new int[]{0, 1, 1});
    public static final Partial EMPTY_ISO_TIME_PARTIAL = new Partial(standardISOTimeFields, new int[]{0, 0, 0, 0});
    public static final Instant INSTANT_ZERO = new Instant(0L);
    public static final DurationFieldType Quarters = new DurationFieldType("quarters"){
        private static final long serialVersionUID = -8167713675442491871L;

        public DurationField getField(Chronology chronology) {
            return new ScaledDurationField(chronology.months(), Quarters, 3);
        }
    };
    public static final DurationFieldType HalfYears = new DurationFieldType("halfyear"){
        private static final long serialVersionUID = -8167713675442491872L;

        public DurationField getField(Chronology chronology) {
            return new ScaledDurationField(chronology.months(), HalfYears, 6);
        }
    };
    public static final DurationFieldType Decades = new DurationFieldType("decades"){
        private static final long serialVersionUID = -4594189766036833410L;

        public DurationField getField(Chronology chronology) {
            return new ScaledDurationField(chronology.years(), Decades, 10);
        }
    };
    public static final DurationFieldType Centuries = new DurationFieldType("centuries"){
        private static final long serialVersionUID = -7268694266711862790L;

        public DurationField getField(Chronology chronology) {
            return new ScaledDurationField(chronology.years(), Centuries, 100);
        }
    };
    public static final DateTimeFieldType QuarterOfYear = new DateTimeFieldType("quarterOfYear"){
        private static final long serialVersionUID = -5677872459807379123L;

        public DurationFieldType getDurationType() {
            return Quarters;
        }

        public DurationFieldType getRangeDurationType() {
            return DurationFieldType.years();
        }

        public DateTimeField getField(Chronology chronology) {
            return new OffsetDateTimeField((DateTimeField)new DividedDateTimeField((DateTimeField)new OffsetDateTimeField(chronology.monthOfYear(), -1), QuarterOfYear, 3), 1);
        }
    };
    public static final DateTimeFieldType HalfYearOfYear = new DateTimeFieldType("halfYearOfYear"){
        private static final long serialVersionUID = -5677872459807379123L;

        public DurationFieldType getDurationType() {
            return HalfYears;
        }

        public DurationFieldType getRangeDurationType() {
            return DurationFieldType.years();
        }

        public DateTimeField getField(Chronology chronology) {
            return new OffsetDateTimeField((DateTimeField)new DividedDateTimeField((DateTimeField)new OffsetDateTimeField(chronology.monthOfYear(), -1), HalfYearOfYear, 6), 1);
        }
    };
    public static final DateTimeFieldType MonthOfQuarter = new DateTimeFieldType("monthOfQuarter"){
        private static final long serialVersionUID = -5677872459807379123L;

        public DurationFieldType getDurationType() {
            return DurationFieldType.months();
        }

        public DurationFieldType getRangeDurationType() {
            return Quarters;
        }

        public DateTimeField getField(Chronology chronology) {
            return new OffsetDateTimeField((DateTimeField)new RemainderDateTimeField((DateTimeField)new OffsetDateTimeField(chronology.monthOfYear(), -1), MonthOfQuarter, 3), 1);
        }
    };
    public static final DateTimeFieldType MonthOfHalfYear = new DateTimeFieldType("monthOfHalfYear"){
        private static final long serialVersionUID = -5677872459807379123L;

        public DurationFieldType getDurationType() {
            return DurationFieldType.months();
        }

        public DurationFieldType getRangeDurationType() {
            return HalfYears;
        }

        public DateTimeField getField(Chronology chronology) {
            return new OffsetDateTimeField((DateTimeField)new RemainderDateTimeField((DateTimeField)new OffsetDateTimeField(chronology.monthOfYear(), -1), MonthOfHalfYear, 6), 1);
        }
    };
    public static final DateTimeFieldType WeekOfMonth = new DateTimeFieldType("weekOfMonth"){
        private static final long serialVersionUID = 8676056306203579438L;

        public DurationFieldType getDurationType() {
            return DurationFieldType.weeks();
        }

        public DurationFieldType getRangeDurationType() {
            return DurationFieldType.months();
        }

        public DateTimeField getField(Chronology chronology) {
            return new OffsetDateTimeField((DateTimeField)new RemainderDateTimeField((DateTimeField)new OffsetDateTimeField(chronology.weekOfWeekyear(), -1), WeekOfMonth, 4), 1);
        }
    };
    public static final DateTimeFieldType DecadeOfCentury = new DateTimeFieldType("decadeOfCentury"){
        private static final long serialVersionUID = 4301444712229535664L;

        public DurationFieldType getDurationType() {
            return Decades;
        }

        public DurationFieldType getRangeDurationType() {
            return DurationFieldType.centuries();
        }

        public DateTimeField getField(Chronology chronology) {
            return new DividedDateTimeField(chronology.yearOfCentury(), DecadeOfCentury, 10);
        }
    };
    public static final DateTimeFieldType YearOfDecade = new DateTimeFieldType("yearOfDecade"){
        private static final long serialVersionUID = 4301444712229535664L;

        public DurationFieldType getDurationType() {
            return DurationFieldType.years();
        }

        public DurationFieldType getRangeDurationType() {
            return Decades;
        }

        public DateTimeField getField(Chronology chronology) {
            return new DividedDateTimeField(chronology.yearOfCentury(), YearOfDecade, 10);
        }
    };

    private JodaTimeUtils() {
    }

    protected static boolean hasField(ReadablePartial base, DateTimeFieldType field) {
        if (base == null) {
            return false;
        }
        return base.isSupported(field);
    }

    protected static boolean hasYYYYMMDD(ReadablePartial base) {
        if (base == null) {
            return false;
        }
        return base.isSupported(DateTimeFieldType.year()) && base.isSupported(DateTimeFieldType.monthOfYear()) && base.isSupported(DateTimeFieldType.dayOfMonth());
    }

    protected static boolean hasYYMMDD(ReadablePartial base) {
        if (base == null) {
            return false;
        }
        return base.isSupported(DateTimeFieldType.yearOfCentury()) && base.isSupported(DateTimeFieldType.monthOfYear()) && base.isSupported(DateTimeFieldType.dayOfMonth());
    }

    protected static boolean hasField(ReadablePeriod base, DurationFieldType field) {
        if (base == null) {
            return false;
        }
        return base.isSupported(field);
    }

    protected static Partial setField(Partial base, DateTimeFieldType field, int value) {
        if (base == null) {
            return new Partial(field, value);
        }
        return base.with(field, value);
    }

    public static Set<DurationFieldType> getSupportedDurationFields(Partial p) {
        Set<DurationFieldType> supportedDurations = Generics.newHashSet();
        for (int i = 0; i < p.size(); ++i) {
            supportedDurations.add(p.getFieldType(i).getDurationType());
        }
        return supportedDurations;
    }

    public static Period getUnsupportedDurationPeriod(Partial p, Period offset) {
        if (offset == null) {
            return null;
        }
        Set<DurationFieldType> supported = JodaTimeUtils.getSupportedDurationFields(p);
        Period res = null;
        for (int i = 0; i < offset.size(); ++i) {
            if (supported.contains(offset.getFieldType(i)) || offset.getValue(i) == 0) continue;
            if (res == null) {
                res = new Period();
            }
            res = res.withField(offset.getFieldType(i), offset.getValue(i));
        }
        return res;
    }

    public static Partial combine(Partial p1, Partial p2) {
        if (p1 == null) {
            return p2;
        }
        if (p2 == null) {
            return p1;
        }
        Partial p = p1;
        for (int i = 0; i < p2.size(); ++i) {
            DateTimeFieldType fieldType = p2.getFieldType(i);
            if (fieldType == DateTimeFieldType.year()) {
                if (p.isSupported(DateTimeFieldType.yearOfCentury())) {
                    int century;
                    int y2;
                    if (p.isSupported(DateTimeFieldType.centuryOfEra())) continue;
                    int yoc = p.get(DateTimeFieldType.yearOfCentury());
                    int refYear = p2.getValue(i);
                    if (refYear < (y2 = yoc + (century = refYear / 100) * 100)) {
                        y2 -= 100;
                    }
                    p = p.without(DateTimeFieldType.yearOfCentury());
                    p = p.with(DateTimeFieldType.year(), y2);
                    continue;
                }
                if (p.isSupported(DateTimeFieldType.centuryOfEra())) {
                    continue;
                }
            } else if (fieldType != DateTimeFieldType.yearOfCentury() ? fieldType == DateTimeFieldType.centuryOfEra() && p.isSupported(DateTimeFieldType.year()) : p.isSupported(DateTimeFieldType.year())) continue;
            if (p.isSupported(fieldType)) continue;
            p = p.with(fieldType, p2.getValue(i));
        }
        if (!p.isSupported(DateTimeFieldType.year()) && p.isSupported(DateTimeFieldType.yearOfCentury()) && p.isSupported(DateTimeFieldType.centuryOfEra())) {
            int year = p.get(DateTimeFieldType.yearOfCentury()) + p.get(DateTimeFieldType.centuryOfEra()) * 100;
            p = p.with(DateTimeFieldType.year(), year);
            p = p.without(DateTimeFieldType.yearOfCentury());
            p = p.without(DateTimeFieldType.centuryOfEra());
        }
        if (p.isSupported(DateTimeFieldType.halfdayOfDay())) {
            int hour = -1;
            if (p.isSupported(DateTimeFieldType.hourOfHalfday())) {
                hour = p.get(DateTimeFieldType.hourOfHalfday());
                p = p.without(DateTimeFieldType.hourOfHalfday());
            } else if (p.isSupported(DateTimeFieldType.clockhourOfHalfday())) {
                hour = p.get(DateTimeFieldType.clockhourOfHalfday()) - 1;
                p = p.without(DateTimeFieldType.clockhourOfHalfday());
            } else if (p.isSupported(DateTimeFieldType.clockhourOfDay())) {
                hour = p.get(DateTimeFieldType.clockhourOfDay()) - 1;
                p = p.without(DateTimeFieldType.clockhourOfDay());
            } else if (p.isSupported(DateTimeFieldType.hourOfDay())) {
                hour = p.get(DateTimeFieldType.hourOfDay());
                p = p.without(DateTimeFieldType.hourOfDay());
            }
            if (hour >= 0) {
                if (p.get(DateTimeFieldType.halfdayOfDay()) == 1) {
                    if (hour < 12) {
                        hour += 12;
                    }
                } else if (hour == 12) {
                    hour = 0;
                }
                p = hour < 24 ? p.with(DateTimeFieldType.hourOfDay(), hour) : p.with(DateTimeFieldType.clockhourOfDay(), hour);
            }
        }
        return p;
    }

    protected static DateTimeFieldType getMostGeneral(Partial p) {
        if (p.size() > 0) {
            return p.getFieldType(0);
        }
        return null;
    }

    protected static DateTimeFieldType getMostSpecific(Partial p) {
        if (p.size() > 0) {
            return p.getFieldType(p.size() - 1);
        }
        return null;
    }

    protected static DurationFieldType getMostGeneral(Period p) {
        for (int i = 0; i < p.size(); ++i) {
            if (p.getValue(i) == 0) continue;
            return p.getFieldType(i);
        }
        return null;
    }

    protected static DurationFieldType getMostSpecific(Period p) {
        for (int i = p.size() - 1; i >= 0; --i) {
            if (p.getValue(i) == 0) continue;
            return p.getFieldType(i);
        }
        return null;
    }

    protected static Period getJodaTimePeriod(Partial p) {
        if (p.size() > 0) {
            Period period = new Period();
            DateTimeFieldType dtType = p.getFieldType(p.size() - 1);
            DurationFieldType dType = dtType.getDurationType();
            if (period.isSupported(dType)) {
                return period.withField(dType, 1);
            }
            DurationField df = dType.getField(p.getChronology());
            if (df instanceof ScaledDurationField) {
                ScaledDurationField sdf = (ScaledDurationField)df;
                return period.withField(sdf.getWrappedField().getType(), sdf.getScalar());
            }
        }
        return null;
    }

    public static Partial combineMoreGeneralFields(Partial p1, Partial p2) {
        return JodaTimeUtils.combineMoreGeneralFields(p1, p2, null);
    }

    public static Partial combineMoreGeneralFields(Partial p1, Partial p2, DateTimeFieldType mgf) {
        Chronology c2;
        Partial p = p1;
        Chronology c1 = p1.getChronology();
        if (!c1.equals(c2 = p2.getChronology())) {
            throw new RuntimeException("Different chronology: c1=" + c1 + ", c2=" + c2);
        }
        DateTimeFieldType p1MostGeneralField = null;
        if (p1.size() > 0) {
            p1MostGeneralField = p1.getFieldType(0);
        }
        if (mgf == null || p1MostGeneralField != null && JodaTimeUtils.isMoreGeneral(p1MostGeneralField, mgf, c1)) {
            mgf = p1MostGeneralField;
        }
        for (int i = 0; i < p2.size(); ++i) {
            DateTimeFieldType fieldType = p2.getFieldType(i);
            if (fieldType == DateTimeFieldType.year()) {
                int century;
                int y2;
                int refYear;
                if (p.isSupported(DateTimeFieldType.yearOfCentury())) {
                    if (p.isSupported(DateTimeFieldType.centuryOfEra())) continue;
                    int yoc = p.get(DateTimeFieldType.yearOfCentury());
                    refYear = p2.getValue(i);
                    if (refYear < (y2 = yoc + (century = refYear / 100) * 100)) {
                        y2 -= 100;
                    }
                    p = p.without(DateTimeFieldType.yearOfCentury());
                    p = p.with(DateTimeFieldType.year(), y2);
                    continue;
                }
                if (p.isSupported(DecadeOfCentury)) {
                    if (p.isSupported(DateTimeFieldType.centuryOfEra())) continue;
                    int decade = p.get(DecadeOfCentury);
                    refYear = p2.getValue(i);
                    if (refYear < (y2 = decade * 10 + (century = refYear / 100) * 100)) {
                        --century;
                    }
                    p = p.with(DateTimeFieldType.centuryOfEra(), century);
                    continue;
                }
            }
            if (mgf != null && !JodaTimeUtils.isMoreGeneral(fieldType, mgf, c1)) break;
            if (p.isSupported(fieldType)) continue;
            p = p.with(fieldType, p2.getValue(i));
        }
        if (!p.isSupported(DateTimeFieldType.year()) && p.isSupported(DateTimeFieldType.yearOfCentury()) && p.isSupported(DateTimeFieldType.centuryOfEra())) {
            int year = p.get(DateTimeFieldType.yearOfCentury()) + p.get(DateTimeFieldType.centuryOfEra()) * 100;
            p = p.with(DateTimeFieldType.year(), year);
            p = p.without(DateTimeFieldType.yearOfCentury());
            p = p.without(DateTimeFieldType.centuryOfEra());
        }
        return p;
    }

    public static Partial discardMoreSpecificFields(Partial p, DateTimeFieldType d) {
        Partial res = new Partial();
        for (int i = 0; i < p.size(); ++i) {
            DateTimeFieldType fieldType = p.getFieldType(i);
            if (!fieldType.equals(d) && !JodaTimeUtils.isMoreGeneral(fieldType, d, p.getChronology())) continue;
            res = res.with(fieldType, p.getValue(i));
        }
        if (res.isSupported(DecadeOfCentury) && !res.isSupported(DateTimeFieldType.centuryOfEra()) && p.isSupported(DateTimeFieldType.year())) {
            res = res.with(DateTimeFieldType.centuryOfEra(), p.get(DateTimeFieldType.year()) / 100);
        }
        return res;
    }

    public static Partial discardMoreSpecificFields(Partial p, DurationFieldType dft) {
        DurationField df = dft.getField(p.getChronology());
        Partial res = new Partial();
        for (int i = 0; i < p.size(); ++i) {
            DateTimeFieldType fieldType = p.getFieldType(i);
            DurationField f = fieldType.getDurationType().getField(p.getChronology());
            int cmp = df.compareTo((Object)f);
            if (cmp > 0) continue;
            res = res.with(fieldType, p.getValue(i));
        }
        return res;
    }

    public static Period discardMoreSpecificFields(Period p, DurationFieldType dft, Chronology chronology) {
        DurationField df = dft.getField(chronology);
        Period res = new Period();
        for (int i = 0; i < p.size(); ++i) {
            DurationFieldType fieldType = p.getFieldType(i);
            DurationField f = fieldType.getField(chronology);
            int cmp = df.compareTo((Object)f);
            if (cmp > 0) continue;
            res = res.withField(fieldType, p.getValue(i));
        }
        return res;
    }

    public static Partial padMoreSpecificFields(Partial p, Period granularity) {
        DateTimeFieldType msf = JodaTimeUtils.getMostSpecific(p);
        if ((JodaTimeUtils.isMoreGeneral(msf, DateTimeFieldType.year(), p.getChronology()) || JodaTimeUtils.isMoreGeneral(msf, DateTimeFieldType.yearOfCentury(), p.getChronology())) && !p.isSupported(DateTimeFieldType.yearOfCentury())) {
            int year;
            if (p.isSupported(DecadeOfCentury)) {
                if (p.isSupported(DateTimeFieldType.centuryOfEra())) {
                    year = p.get(DateTimeFieldType.centuryOfEra()) * 100 + p.get(DecadeOfCentury) * 10;
                    p = p.without(DecadeOfCentury);
                    p = p.without(DateTimeFieldType.centuryOfEra());
                    p = p.with(DateTimeFieldType.year(), year);
                } else {
                    year = p.get(DecadeOfCentury) * 10;
                    p = p.without(DecadeOfCentury);
                    p = p.with(DateTimeFieldType.yearOfCentury(), year);
                }
            } else if (p.isSupported(DateTimeFieldType.centuryOfEra())) {
                year = p.get(DateTimeFieldType.centuryOfEra()) * 100;
                p = p.without(DateTimeFieldType.centuryOfEra());
                p = p.with(DateTimeFieldType.year(), year);
            }
        }
        boolean useWeek = false;
        if (p.isSupported(DateTimeFieldType.weekOfWeekyear())) {
            if (!p.isSupported(DateTimeFieldType.dayOfMonth()) && !p.isSupported(DateTimeFieldType.dayOfWeek()) && (p = p.with(DateTimeFieldType.dayOfWeek(), 1)).isSupported(DateTimeFieldType.monthOfYear())) {
                p = p.without(DateTimeFieldType.monthOfYear());
            }
            useWeek = true;
        }
        Partial p2 = useWeek ? EMPTY_ISO_WEEK_PARTIAL : EMPTY_ISO_PARTIAL;
        for (int i = 0; i < p2.size(); ++i) {
            DateTimeFieldType fieldType = p2.getFieldType(i);
            if (msf != null && !JodaTimeUtils.isMoreSpecific(fieldType, msf, p.getChronology()) || p.isSupported(fieldType)) continue;
            if (fieldType == DateTimeFieldType.monthOfYear()) {
                if (p.isSupported(QuarterOfYear)) {
                    p = p.with(DateTimeFieldType.monthOfYear(), (p.get(QuarterOfYear) - 1) * 3 + 1);
                    continue;
                }
                if (p.isSupported(HalfYearOfYear)) {
                    p = p.with(DateTimeFieldType.monthOfYear(), (p.get(HalfYearOfYear) - 1) * 6 + 1);
                    continue;
                }
            }
            p = p.with(fieldType, p2.getValue(i));
        }
        if (granularity != null) {
            DurationFieldType mostSpecific = JodaTimeUtils.getMostSpecific(granularity);
            p = JodaTimeUtils.discardMoreSpecificFields(p, mostSpecific);
        }
        return p;
    }

    public static boolean isCompatible(Partial p1, Partial p2) {
        if (p1 == null) {
            return true;
        }
        if (p2 == null) {
            return true;
        }
        for (int i = 0; i < p1.size(); ++i) {
            DateTimeFieldType type = p1.getFieldType(i);
            int v = p1.getValue(i);
            if (!JodaTimeUtils.hasField((ReadablePartial)p2, type) || v == p2.get(type)) continue;
            return false;
        }
        return true;
    }

    public static Partial resolveDowToDay(Partial p1, Partial p2) {
        if (JodaTimeUtils.isCompatible(p1, p2 = JodaTimeUtils.discardMoreSpecificFields(p2, DateTimeFieldType.dayOfMonth())) && p1.isSupported(DateTimeFieldType.dayOfWeek()) && !p1.isSupported(DateTimeFieldType.dayOfMonth()) && p2.isSupported(DateTimeFieldType.dayOfMonth()) && p2.isSupported(DateTimeFieldType.monthOfYear()) && p2.isSupported(DateTimeFieldType.year())) {
            Instant t2 = JodaTimeUtils.getInstant(p2);
            DateTime t1 = p1.toDateTime((ReadableInstant)t2);
            return JodaTimeUtils.getPartial(t1.toInstant(), p1.with(DateTimeFieldType.dayOfMonth(), 1));
        }
        return p1;
    }

    public static Partial withWeekYear(Partial p) {
        Partial res = new Partial();
        for (int i = 0; i < p.size(); ++i) {
            DateTimeFieldType fieldType = p.getFieldType(i);
            res = fieldType == DateTimeFieldType.year() ? res.with(DateTimeFieldType.weekyear(), p.getValue(i)) : res.with(fieldType, p.getValue(i));
        }
        return res;
    }

    public static Partial resolveDowToDay(Partial p) {
        if (p.isSupported(DateTimeFieldType.dayOfWeek()) && !p.isSupported(DateTimeFieldType.dayOfMonth()) && p.isSupported(DateTimeFieldType.weekOfWeekyear()) && p.isSupported(DateTimeFieldType.year())) {
            Partial pwy = JodaTimeUtils.withWeekYear(p);
            Instant t2 = JodaTimeUtils.getInstant(pwy);
            DateTime t1 = pwy.toDateTime((ReadableInstant)t2);
            Partial res = JodaTimeUtils.getPartial(t1.toInstant(), EMPTY_ISO_PARTIAL);
            DateTimeFieldType mostSpecific = JodaTimeUtils.getMostSpecific(p);
            res = JodaTimeUtils.discardMoreSpecificFields(res, mostSpecific.getDurationType());
            return res;
        }
        return p;
    }

    public static Partial resolveWeek(Partial p1, Partial p2) {
        if (JodaTimeUtils.isCompatible(p1, p2) && !p1.isSupported(DateTimeFieldType.dayOfMonth()) && p2.isSupported(DateTimeFieldType.dayOfMonth()) && p2.isSupported(DateTimeFieldType.monthOfYear()) && p2.isSupported(DateTimeFieldType.year())) {
            Instant t2 = JodaTimeUtils.getInstant(p2);
            DateTime t1 = p1.toDateTime((ReadableInstant)t2);
            return JodaTimeUtils.getPartial(t1.toInstant(), p1.without(DateTimeFieldType.dayOfMonth()).without(DateTimeFieldType.monthOfYear()).with(DateTimeFieldType.weekOfWeekyear(), 1));
        }
        return p1;
    }

    public static Partial resolveWeek(Partial p) {
        if (p.isSupported(DateTimeFieldType.dayOfMonth()) && p.isSupported(DateTimeFieldType.monthOfYear()) && p.isSupported(DateTimeFieldType.year())) {
            Instant t = JodaTimeUtils.getInstant(p);
            return JodaTimeUtils.getPartial(t.toInstant(), p.with(DateTimeFieldType.weekOfWeekyear(), 1));
        }
        return p;
    }

    public static Instant getInstant(Partial p) {
        return JodaTimeUtils.getInstant(p, UTC);
    }

    public static Instant getInstant(Partial p, ZoneId timezone) {
        int moy;
        int year;
        if (p == null) {
            return null;
        }
        int n = year = p.isSupported(DateTimeFieldType.year()) ? p.get(DateTimeFieldType.year()) : 0;
        if (!p.isSupported(DateTimeFieldType.year())) {
            if (p.isSupported(DateTimeFieldType.centuryOfEra())) {
                year += 100 * p.get(DateTimeFieldType.centuryOfEra());
            }
            if (p.isSupported(DateTimeFieldType.yearOfCentury())) {
                year += p.get(DateTimeFieldType.yearOfCentury());
            } else if (p.isSupported(DecadeOfCentury)) {
                year += 10 * p.get(DecadeOfCentury);
            }
        }
        int n2 = moy = p.isSupported(DateTimeFieldType.monthOfYear()) ? p.get(DateTimeFieldType.monthOfYear()) : 1;
        if (!p.isSupported(DateTimeFieldType.monthOfYear()) && p.isSupported(QuarterOfYear)) {
            moy += 3 * (p.get(QuarterOfYear) - 1);
        }
        int dom = p.isSupported(DateTimeFieldType.dayOfMonth()) ? p.get(DateTimeFieldType.dayOfMonth()) : 1;
        int hod = p.isSupported(DateTimeFieldType.hourOfDay()) ? p.get(DateTimeFieldType.hourOfDay()) : 0;
        int moh = p.isSupported(DateTimeFieldType.minuteOfHour()) ? p.get(DateTimeFieldType.minuteOfHour()) : 0;
        int som = p.isSupported(DateTimeFieldType.secondOfMinute()) ? p.get(DateTimeFieldType.secondOfMinute()) : 0;
        int msos = p.isSupported(DateTimeFieldType.millisOfSecond()) ? p.get(DateTimeFieldType.millisOfSecond()) : 0;
        return new DateTime(year, moy, dom, hod, moh, som, msos, (Chronology)JodaTimeUtils.fromTimezone(timezone)).toInstant();
    }

    private static ISOChronology fromTimezone(ZoneId timezone) {
        if (timezone == UTC) {
            return ISOChronology.getInstanceUTC();
        }
        return ISOChronology.getInstance((DateTimeZone)DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(timezone)));
    }

    public static Partial getPartial(Instant t, Partial p) {
        Partial res = new Partial((ReadablePartial)p);
        for (int i = 0; i < p.size(); ++i) {
            res = res.withField(p.getFieldType(i), t.get(p.getFieldType(i)));
        }
        return res;
    }

    public static Partial addForce(Partial p, Period d, int scalar) {
        Instant t = JodaTimeUtils.getInstant(p);
        t = t.withDurationAdded((ReadableDuration)d.toDurationFrom((ReadableInstant)INSTANT_ZERO), scalar);
        return JodaTimeUtils.getPartial(t, p);
    }

    public static boolean isMoreGeneral(DateTimeFieldType df1, DateTimeFieldType df2, Chronology chronology) {
        DurationFieldType df1DurationFieldType = df1.getDurationType();
        DurationFieldType df2DurationFieldType = df2.getDurationType();
        if (!df2DurationFieldType.equals(df1DurationFieldType)) {
            DurationField df2Unit;
            int cmp;
            DurationField df1Unit = df1DurationFieldType.getField(chronology);
            DurationFieldType p = df2.getRangeDurationType();
            if (p != null && (cmp = df1Unit.compareTo((Object)(df2Unit = df2DurationFieldType.getField(chronology)))) > 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMoreSpecific(DateTimeFieldType df1, DateTimeFieldType df2, Chronology chronology) {
        DurationFieldType df1DurationFieldType = df1.getDurationType();
        DurationFieldType df2DurationFieldType = df2.getDurationType();
        if (!df2DurationFieldType.equals(df1DurationFieldType)) {
            DurationField df1Unit;
            int cmp;
            DurationField df2Unit = df2DurationFieldType.getField(chronology);
            DurationFieldType p = df1.getRangeDurationType();
            if (p != null && (cmp = (df1Unit = df1DurationFieldType.getField(chronology)).compareTo((Object)df2Unit)) < 0) {
                return true;
            }
        }
        return false;
    }

    private static String zeroPad(int value, int padding) {
        StringBuilder b = new StringBuilder();
        b.append(value);
        while (b.length() < padding) {
            b.insert(0, "0");
        }
        return b.toString();
    }

    private static boolean noFurtherFields(DateTimeFieldType smallestFieldSet, ReadableDateTime begin, ReadableDateTime end) {
        int i;
        int indexInStandard = -1;
        for (int i2 = 0; i2 < standardISOFields.length; ++i2) {
            if (standardISOFields[i2] != smallestFieldSet) continue;
            indexInStandard = i2 + 1;
        }
        int indexInWeek = -1;
        for (i = 0; i < standardISOWeekFields.length; ++i) {
            if (standardISOWeekFields[i] != smallestFieldSet) continue;
            indexInWeek = i + 1;
        }
        if (smallestFieldSet == QuarterOfYear) {
            for (i = 0; i < standardISOFields.length; ++i) {
                if (standardISOFields[i] != DateTimeFieldType.monthOfYear()) continue;
                indexInStandard = i;
            }
        }
        int index = -1;
        DateTimeFieldType[] toCheck = null;
        if (indexInStandard >= 0) {
            index = indexInStandard;
            toCheck = standardISOFields;
        } else if (indexInWeek >= 0) {
            index = indexInWeek;
            toCheck = standardISOWeekFields;
        } else {
            throw new IllegalArgumentException("Field is not in my list of fields: " + smallestFieldSet);
        }
        for (int i3 = index; i3 < toCheck.length; ++i3) {
            int minValue = JodaTimeUtils.minimumValue(toCheck[i3], begin);
            if (begin.get(toCheck[i3]) == minValue && end.get(toCheck[i3]) == minValue) continue;
            return false;
        }
        return true;
    }

    public static int minimumValue(DateTimeFieldType type, ReadableDateTime reference) {
        return reference.toDateTime().property(type).getMinimumValue();
    }

    public static int maximumValue(DateTimeFieldType type, ReadableDateTime reference) {
        return reference.toDateTime().property(type).getMaximumValue();
    }

    public static String timexTimeValue(ReadableDateTime time) {
        return String.valueOf(time.getYear()) + '-' + JodaTimeUtils.zeroPad(time.getMonthOfYear(), 2) + '-' + JodaTimeUtils.zeroPad(time.getDayOfMonth(), 2) + 'T' + JodaTimeUtils.zeroPad(time.getHourOfDay(), 2) + ':' + JodaTimeUtils.zeroPad(time.getMinuteOfHour(), 2);
    }

    public static String timexDateValue(ReadableDateTime begin, ReadableDateTime end) {
        return JodaTimeUtils.timexDateValue(begin, end, new ConversionOptions());
    }

    public static String timexDateValue(ReadableDateTime begin, ReadableDateTime end, ConversionOptions opts) {
        int minDiff;
        int hrDiff;
        int dayDiff;
        StringBuilder value;
        block42: {
            block44: {
                boolean weekTerminal;
                boolean monthTerminal;
                int weekDiff;
                int monthDiff;
                block46: {
                    block45: {
                        block43: {
                            if (begin.getYear() < -100000) {
                                return "PAST_REF";
                            }
                            if (end.getYear() > 100000) {
                                return "FUTURE_REF";
                            }
                            if (begin.equals(end)) {
                                return JodaTimeUtils.timexTimeValue(begin);
                            }
                            value = new StringBuilder();
                            boolean shouldBeDone = false;
                            monthDiff = end.getMonthOfYear() - begin.getMonthOfYear() + (end.getYear() - begin.getYear()) * 12;
                            weekDiff = end.getWeekOfWeekyear() - begin.getWeekOfWeekyear() + (end.getYear() - begin.getYear()) * JodaTimeUtils.maximumValue(DateTimeFieldType.weekOfWeekyear(), begin);
                            dayDiff = end.getDayOfMonth() - begin.getDayOfMonth() + monthDiff * JodaTimeUtils.maximumValue(DateTimeFieldType.dayOfMonth(), begin);
                            hrDiff = end.getHourOfDay() - begin.getHourOfDay() + dayDiff * 24;
                            minDiff = end.getMinuteOfHour() - begin.getMinuteOfHour() + hrDiff * 60;
                            int secDiff = end.getSecondOfMinute() - begin.getSecondOfMinute() + minDiff * 60;
                            if (JodaTimeUtils.noFurtherFields(DateTimeFieldType.year(), begin, end)) {
                                int diff = end.getYear() - begin.getYear();
                                if (diff == 100 && (opts.forceDate || begin.getYear() % 100 == 0)) {
                                    value.append(begin.getYear() / 100).append("XX");
                                } else if (diff == 10 && (opts.forceDate || begin.getYear() % 10 == 0)) {
                                    value.append(begin.getYear() / 10);
                                } else if (diff == 1 || opts.forceDate) {
                                    value.append(begin.getYear());
                                } else {
                                    return JodaTimeUtils.timexDurationValue(begin, end);
                                }
                                return value.toString();
                            }
                            if (monthDiff >= 12 && !opts.forceDate) {
                                return JodaTimeUtils.timexDurationValue(begin, end);
                            }
                            value.append(begin.getYear());
                            value.append("-");
                            if (!JodaTimeUtils.noFurtherFields(DateTimeFieldType.monthOfYear(), begin, end) && !JodaTimeUtils.noFurtherFields(DateTimeFieldType.weekOfWeekyear(), begin, end)) break block42;
                            monthTerminal = JodaTimeUtils.noFurtherFields(DateTimeFieldType.monthOfYear(), begin, end);
                            weekTerminal = JodaTimeUtils.noFurtherFields(DateTimeFieldType.weekOfWeekyear(), begin, end);
                            if (!monthTerminal || monthDiff != 6 || (begin.getMonthOfYear() - 1) % 6 != 0) break block43;
                            value.append("H").append((begin.getMonthOfYear() - 1) / 6 + 1);
                            break block44;
                        }
                        if (!monthTerminal || monthDiff != 3 || (begin.getMonthOfYear() - 1) % 3 != 0) break block45;
                        value.append("Q").append((begin.getMonthOfYear() - 1) / 3 + 1);
                        break block44;
                    }
                    if (!monthTerminal || monthDiff != 3 || begin.getMonthOfYear() % 3 != 0) break block46;
                    switch (begin.getMonthOfYear()) {
                        case 12: {
                            value.append("WI");
                            break block44;
                        }
                        case 3: {
                            value.append("SP");
                            break block44;
                        }
                        case 6: {
                            value.append("SU");
                            break block44;
                        }
                        case 9: {
                            value.append("FA");
                            break block44;
                        }
                        default: {
                            throw new IllegalStateException("Season start month is unknown");
                        }
                    }
                }
                if (weekTerminal && weekDiff == 1) {
                    value.append("W").append(JodaTimeUtils.zeroPad(begin.getWeekOfWeekyear(), 2));
                } else if (monthTerminal && monthDiff == 1 && weekDiff != 1 || opts.forceDate) {
                    value.append(JodaTimeUtils.zeroPad(begin.getMonthOfYear(), 2));
                } else {
                    return JodaTimeUtils.timexDurationValue(begin, end);
                }
            }
            return value.toString();
        }
        if (JodaTimeUtils.noFurtherFields(DateTimeFieldType.dayOfWeek(), begin, end) && dayDiff == 2 && begin.getDayOfWeek() == 6) {
            value.append("W").append(JodaTimeUtils.zeroPad(begin.getWeekOfWeekyear(), 2)).append("-WE");
            return value.toString();
        }
        if (dayDiff >= JodaTimeUtils.maximumValue(DateTimeFieldType.dayOfMonth(), begin) && !opts.forceDate) {
            return JodaTimeUtils.timexDurationValue(begin, end);
        }
        value.append(JodaTimeUtils.zeroPad(begin.getMonthOfYear(), 2));
        value.append("-");
        if (JodaTimeUtils.noFurtherFields(DateTimeFieldType.dayOfMonth(), begin, end)) {
            if (dayDiff != 1 && !opts.forceDate) {
                return JodaTimeUtils.timexDurationValue(begin, end);
            }
            value.append(JodaTimeUtils.zeroPad(begin.getDayOfMonth(), 2));
            return value.toString();
        }
        if (hrDiff >= 24 && !opts.forceDate) {
            return JodaTimeUtils.timexDurationValue(begin, end);
        }
        value.append(JodaTimeUtils.zeroPad(begin.getDayOfMonth(), 2));
        value.append("T");
        if (JodaTimeUtils.noFurtherFields(DateTimeFieldType.hourOfDay(), begin, end)) {
            if (hrDiff == 12 && begin.getHourOfDay() == 0) {
                value.append("H1");
            } else if (hrDiff == 12 && begin.getHourOfDay() == 12) {
                value.append("H2");
            } else if (hrDiff == 4 && begin.getHourOfDay() == 8) {
                value.append("MO");
            } else if (hrDiff == 4 && begin.getHourOfDay() == 12) {
                value.append("AF");
            } else if (hrDiff == 4 && begin.getHourOfDay() == 16) {
                value.append("EV");
            } else if (hrDiff == 4 && begin.getHourOfDay() == 20) {
                value.append("NI");
            } else if (hrDiff == 1 || opts.forceDate) {
                value.append(JodaTimeUtils.zeroPad(begin.getHourOfDay() + 1, 2));
            } else {
                return JodaTimeUtils.timexDurationValue(begin, end);
            }
            return value.toString();
        }
        if (minDiff > 60 && !opts.forceDate) {
            return JodaTimeUtils.timexDurationValue(begin, end);
        }
        value.append(JodaTimeUtils.zeroPad(begin.getHourOfDay(), 2));
        value.append(":");
        value.append(JodaTimeUtils.zeroPad(begin.getMinuteOfHour(), 2));
        return value.toString();
    }

    private static boolean consistentWithForced(String cand, String[] forcedList) {
        for (String forced : forcedList) {
            if (!forced.equals(cand)) continue;
            return true;
        }
        String[] ordering = new String[]{"L", "C", "E", "Y", "Q", "M", "W", "D", "H", "m", "S"};
        int candIndex = -1;
        for (int i = 0; i < ordering.length; ++i) {
            if (!ordering[i].equals(cand)) continue;
            candIndex = i;
            break;
        }
        assert (candIndex >= 0);
        for (int candI = candIndex + 1; candI < ordering.length; ++candI) {
            for (String forced : forcedList) {
                if (!ordering[candI].equals(forced)) continue;
                return false;
            }
        }
        return true;
    }

    public static String timexDurationValue(ReadablePeriod duration, ConversionOptions opts) {
        int months;
        StringBuilder b = new StringBuilder().append("P");
        boolean seenTime = false;
        int years = duration.get(DurationFieldType.years());
        if (years >= 1000 && JodaTimeUtils.consistentWithForced("L", opts.forceUnits)) {
            b.append(opts.approximate ? "X" : Integer.valueOf(years / 1000)).append("L");
            years %= 1000;
        }
        if (years >= 100 && JodaTimeUtils.consistentWithForced("C", opts.forceUnits)) {
            b.append(opts.approximate ? "X" : Integer.valueOf(years / 100)).append("C");
            years %= 100;
        }
        if (years >= 10 && JodaTimeUtils.consistentWithForced("E", opts.forceUnits)) {
            b.append(opts.approximate ? "X" : Integer.valueOf(years / 10)).append("E");
            years %= 10;
        }
        if (years != 0 && JodaTimeUtils.consistentWithForced("Y", opts.forceUnits)) {
            b.append(opts.approximate ? "X" : Integer.valueOf(years)).append("Y");
        }
        if ((months = duration.get(DurationFieldType.months())) != 0) {
            if (months % 3 == 0 && JodaTimeUtils.consistentWithForced("Q", opts.forceUnits)) {
                b.append(opts.approximate ? "X" : Integer.valueOf(months / 3)).append("Q");
                months %= 3;
            } else {
                b.append(opts.approximate ? "X" : Integer.valueOf(months)).append("M");
            }
        }
        if (duration.get(DurationFieldType.weeks()) != 0) {
            b.append(opts.approximate ? "X" : Integer.valueOf(duration.get(DurationFieldType.weeks()))).append("W");
        }
        if (duration.get(DurationFieldType.days()) != 0) {
            b.append(opts.approximate ? "X" : Integer.valueOf(duration.get(DurationFieldType.days()))).append("D");
        }
        if (duration.get(DurationFieldType.hours()) != 0) {
            if (!seenTime) {
                b.append("T");
                seenTime = true;
            }
            b.append(opts.approximate ? "X" : Integer.valueOf(duration.get(DurationFieldType.hours()))).append("H");
        }
        if (duration.get(DurationFieldType.minutes()) != 0) {
            if (!seenTime) {
                b.append("T");
                seenTime = true;
            }
            b.append(opts.approximate ? "X" : Integer.valueOf(duration.get(DurationFieldType.minutes()))).append("M");
        }
        if (duration.get(DurationFieldType.seconds()) != 0) {
            if (!seenTime) {
                b.append("T");
                seenTime = true;
            }
            b.append(opts.approximate ? "X" : Integer.valueOf(duration.get(DurationFieldType.seconds()))).append("S");
        }
        return b.toString();
    }

    public static String timexDurationValue(ReadablePeriod duration) {
        return JodaTimeUtils.timexDurationValue(duration, new ConversionOptions());
    }

    public static String timexDurationValue(ReadableDateTime begin, ReadableDateTime end) {
        return JodaTimeUtils.timexDurationValue((ReadablePeriod)new Period(end.getMillis() - begin.getMillis()));
    }

    public static class ConversionOptions {
        public boolean forceDate = false;
        public String[] forceUnits = new String[0];
        public boolean approximate = false;
    }
}

