/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache<VALUE> {
    private Map<String, VALUE> cachingMap = new HashMap<String, VALUE>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VALUE get(ValueHandler<VALUE> valueHandler) {
        String key = valueHandler.getKey();
        try {
            this.readLock();
            if (!this.containsKey(key)) {
                this.readUnlockWriteLock();
                if (!this.containsKey(key)) {
                    this.putValue(key, valueHandler.createValue());
                }
                this.readLockWriteUnlock();
            }
            VALUE VALUE = this.getValue(key);
            return VALUE;
        }
        finally {
            this.unlockBoth();
        }
    }

    private void unlockBoth() {
        this.writeUnlock();
        this.readUnlock();
    }

    private void readLockWriteUnlock() {
        this.readLock();
        this.writeUnlock();
    }

    private void readUnlockWriteLock() {
        this.readUnlock();
        this.writeLock();
    }

    private VALUE getValue(String key) {
        return this.cachingMap.get(key);
    }

    private void putValue(String key, VALUE value) {
        this.cachingMap.put(key, value);
    }

    private boolean containsKey(String key) {
        return this.cachingMap.containsKey(key);
    }

    private void writeUnlock() {
        if (this.lock.isWriteLockedByCurrentThread()) {
            this.lock.writeLock().unlock();
        }
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void readLock() {
        this.lock.readLock().lock();
    }

    private void readUnlock() {
        if (this.lock.getReadHoldCount() > 0) {
            this.lock.readLock().unlock();
        }
    }

    public void clear() {
        this.writeLock();
        this.cachingMap.clear();
        this.writeUnlock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ValueHandler<VALUE> {
        public abstract String getKey();

        public abstract VALUE createValue();
    }
}

