<!--
Filename:       README.md
Author:         Shiro Takeda
e-mail          <shiro.takeda@gmail.com>
First-written:  <2017-07-30>
Time-stamp:     <2018-12-07 17:12:31 st>
-->

econ.bst
==============================

`econ.bst` is a BibTeX style file for economics. It provids the following
features:

* The author-year type citation (you need `natbib.sty` as well).
* Reference style used in economics papers (`econ.bst` is not a BibTeX style for a specific journal).
* Highly customizable.  You can easily customize reference style as you wish.
* You can use "certified random order" proposed by [Ray ⓡ Robson (2018), AER](http://dx.doi.org/10.1257/aer.20161492).


## Explanation of files

| File                                 | Explanation                                                         |
|:-----------------------------------------|:-------------------------------------------------------------|
| `econ.bst`                              | This is the main bst file.                                |
| `econ-example.tex`                      | This file explains how to use econ.bst.                          |
| [`econ-example.pdf`](econ-example.pdf) | A PDF file created fom `econ-example.tex`.                 |
| `econ-example.bib`                      | This is a bibliography database file.                                        |
| `customization`                          | This folder contains customized bst files.                      |
| [`CHANGES.md`](CHANGES.md)               | Changelog file.                               |
| `README.md`                              | This file.                                          |


<!--
--------------------
Local Variables:
mode: markdown
fill-column: 80
coding: utf-8-dos
End:
-->


