/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.model;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.islandoftex.arara.localization.LanguageController;
import org.islandoftex.arara.localization.Messages;
import org.islandoftex.arara.model.AraraException;
import org.islandoftex.arara.ruleset.Directive;
import org.islandoftex.arara.ruleset.DirectiveUtils;
import org.islandoftex.arara.utils.CommonUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/islandoftex/arara/model/Extractor;", "", "()V", "messages", "Lorg/islandoftex/arara/localization/LanguageController;", "extract", "", "Lorg/islandoftex/arara/ruleset/Directive;", "file", "Ljava/io/File;", "charset", "Ljava/nio/charset/Charset;", "application"})
public final class Extractor {
    private static final LanguageController messages;
    public static final Extractor INSTANCE;

    @NotNull
    public final List<Directive> extract(@NotNull File file2, @NotNull Charset charset) throws AraraException {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        try {
            List<String> content = CollectionsKt.toMutableList((Collection)CommonUtils.INSTANCE.getPreambleContent());
            content.addAll((Collection)FilesKt.readLines(file2, charset));
            return DirectiveUtils.INSTANCE.extractDirectives(content);
        }
        catch (IOException ioexception) {
            throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_EXTRACTOR_IO_ERROR), ioexception);
        }
    }

    public static /* synthetic */ List extract$default(Extractor extractor, File file2, Charset charset, int n, Object object) throws AraraException {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return extractor.extract(file2, charset);
    }

    private Extractor() {
    }

    static {
        Extractor extractor;
        INSTANCE = extractor = new Extractor();
        messages = LanguageController.INSTANCE;
    }
}

