/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.visage;

import de.cinderella.api.visage.Edge;
import de.cinderella.api.visage.GraphAlgorithm;
import de.cinderella.api.visage.Vertex;
import de.cinderella.proguard.Applet;
import de.cinderella.proguard.Application;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;

@Applet
@Application
public class BipartiteGraph
extends GraphAlgorithm {
    @Override
    public Color getDefaultEdgeColor() {
        return Color.gray;
    }

    @Override
    public Color getDefaultVertexColor() {
        return Color.black;
    }

    @Override
    public String intlKey() {
        return "BipartiteMatching";
    }

    @Override
    public boolean modeDirectedEdges() {
        return false;
    }

    @Override
    public int modeSpecialVertices() {
        return 0;
    }

    @Override
    public boolean modeUndirectedEdges() {
        return true;
    }

    @Override
    protected final void runAlgorithm() {
        boolean bl2 = true;
        Iterator<Object> iterator = this.g.vertices().iterator();
        while (iterator.hasNext()) {
            boolean bl3;
            block9: {
                Vertex vertex;
                Vertex vertex2 = vertex = iterator.next();
                BipartiteGraph bipartiteGraph = this;
                if (vertex2.getAttribute("bipartiteness").equals("unknown")) {
                    bipartiteGraph.flash(vertex2, Color.red, 100L);
                    vertex2.setAttribute("bipartiteness", "red");
                    vertex2.setColor(Color.red);
                    LinkedList<Vertex> linkedList = new LinkedList<Vertex>();
                    linkedList.addLast(vertex2);
                    while (!linkedList.isEmpty()) {
                        Vertex vertex3 = (Vertex)linkedList.removeFirst();
                        String string = vertex3.getAttribute("bipartiteness");
                        for (Edge edge : bipartiteGraph.g.outgoing(vertex3)) {
                            if (edge.getAttribute("visited").equals("v")) continue;
                            Vertex vertex4 = edge.otherVertex(vertex3);
                            String string2 = vertex4.getAttribute("bipartiteness");
                            if (string2.equals(string)) {
                                edge.flash(Color.red, 1000L);
                                edge.setColor(Color.red);
                                bl3 = false;
                                break block9;
                            }
                            if (!string2.equals("unknown")) continue;
                            if (string.equals("red")) {
                                vertex4.setAttribute("bipartiteness", "black");
                                vertex4.setColor(Color.white);
                            } else {
                                vertex4.setAttribute("bipartiteness", "red");
                                vertex4.setColor(Color.red);
                            }
                            linkedList.addLast(vertex4);
                        }
                    }
                }
                bl3 = true;
            }
            bl2 &= bl3;
        }
        if (!bl2) {
            return;
        }
        for (Edge edge : this.g.edges()) {
            edge.setAttribute("visited", "nv");
        }
        this.r();
    }

    protected void r() {
    }

    @Override
    protected void init() {
        for (Edge object : this.g.edges()) {
            object.setColor(this.getDefaultEdgeColor());
            object.setSize(1);
            object.setAttribute("matching", "no");
            object.setAttribute("visited", "nv");
        }
        for (Vertex vertex : this.g.vertices()) {
            vertex.setColor(this.getDefaultVertexColor());
            vertex.setSize(5);
            vertex.setAttribute("bipartiteness", "unknown");
        }
    }

    protected static boolean a(Vertex vertex) {
        return vertex.getAttribute("bipartiteness").equals("black");
    }
}

