/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.DifferentiableUnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealSolverImpl;
import org.apache.commons.math.analysis.UnivariateRealSolverUtils;

public class NewtonSolver
extends UnivariateRealSolverImpl {
    static final long serialVersionUID = 2606474895443431607L;
    private UnivariateRealFunction derivative;

    public NewtonSolver(DifferentiableUnivariateRealFunction f) {
        super(f, 100, 1.0E-6);
        this.derivative = f.derivative();
    }

    public double solve(double min, double max) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(min, max, UnivariateRealSolverUtils.midpoint(min, max));
    }

    public double solve(double min, double max, double startValue) throws ConvergenceException, FunctionEvaluationException {
        int i;
        this.clearResult();
        this.verifySequence(min, startValue, max);
        double x0 = startValue;
        for (i = 0; i < this.maximalIterationCount; ++i) {
            double x1 = x0 - this.f.value(x0) / this.derivative.value(x0);
            if (Math.abs(x1 - x0) <= this.absoluteAccuracy) {
                this.setResult(x1, i);
                return x1;
            }
            x0 = x1;
        }
        throw new ConvergenceException("Maximum number of iterations exceeded " + i);
    }
}

