Пояснения к формулам в LaTeX
========

Пакет распространяется по лицензии Creative Commons
Attribution-ShareAlike 4.0 International (CC BY-SA 4.0).

Пакет был разработан в качестве ответа на вопрос [на tex.stackexchange.com](https://tex.stackexchange.com/q/95838/119485)

Пакет `eqexpl` был разработан для того, чтобы обеспечить возможность
давать формулам более осмысленные пояснения, оформление которых
отличается от простого перечисления.

                I = U / Rs,            (1)

    где   U --- напряжение на участке, В;
	     Rs --- суммарное   сопротивление
                участка, Ом.

Требования к оформлению:
1. Поясняемые переменные выравниваются по правому краю.
2. Тире пояснения выравниваются по центру друг под другом.
3. Пояснения выравниваются по ширине, последняя строка выравнивается
   по левому краю, при этом
   - если левый край пояснения занимает более одной строки, строки
     должны быть выровнены слева (второе пояснение).

Пакет добавляет новое окружение `eqexpl`, внутри которого команда
перечисления `\item` имеет обязательный параметр --- поясняемую
переменную.  Пояснение выше выполненяется следующим образом

    \begin{eqexpl}
      \item{U} напряжение на участке, В;
	  \item{Rs} суммарное сопротивление участка, Ом.
	\end{exqexpl}

Подробнее смотрите `eqexpl.tex`.  Вы можете собрать его с помощью
команды `pdflatex eqexpl.tex`.
