This package provides the hecthese class, a class based on memoir
and compatible with LaTeX. With this class, postgraduate students
at HEC Montréal will be able to write their dissertation or thesis
while complying to all the presentation standards required by the
University.

LICENCE

LaTeX Project Public License, version 1.3c or (at your option) any
later version.

VERSION

1.3.2

******************************************************************
La version française de cette description est à la suite de la
version anglaise.
******************************************************************

*** ENGLISH VERSION ***

DESCRIPTION

The LaTeX hecthese document class has been created in order to
allow graduate students from HEC Montréal to write their dissertation
or thesis with the typesetting system while complying with the
presentation standards required by the University. As such, the class
fully complies to the "Guidelines for Writing an Academic Work at
a Graduate Level".

ARCHIVE CONTENTS

- hecthese-fr.ins : the installation file for the French version of the
  class;
- hecthese-en.ins : the installation file for the English version of the
  class;
- hecthese.dtx : the bilingual documented source code of the class;
- hecthese.pdf : the French version of the class' documentation;
- hecthese-en.pdf : the English version of the class' documentation;
- README.md : this file.

CLASS INSTALLATION

Follow these steps to install the class:
1. Create a working directory.
2. Extract the .zip archive in the working directory.
3. Open a command-line editor.
4. Change directories to get to your working directory.
5. Type the following command in the editor:

	latex hecthese-en.ins
	
The command will generate multiple files:

1. the class itself:
	- hecthese.cls
	
2. one template for each dissertation or thesis type:
	- template-phd-classic.tex
	- template-phd-articles.tex
	- template-msc-classic.tex
	- template-msc-articles.tex
	
3. one file for each section of your work:
	- abstract-french.tex
	- abstract-english.tex
	- acronym-list.tex
	- dedication.tex
	- acknowledgements.tex
	- preface.tex
	- introduction.tex
	- theoretical-framework.tex
	- literature-review.tex
	- chapter-1.tex
	- chapter-2.tex
	- chapter-3.tex	
	- article-1.tex
	- article-2.tex
	- article-3.tex
	- conclusion.tex
	- appendix.tex
	
DOCUMENTATION

The documentation provided with this class was written to help your
work with the hecthese document class.

*** VERSION FRANÇAISE ***

DESCRIPTION

La classe LaTeX hecthese a été conçue pour permettre aux étudiants
de HEC Montréal de rédiger leur thèse ou mémoire à l'aide du système
de préparation de documents tout en se conformant aux règles de
présentation en vigueur à l'École. À ce titre, la classe répond en
tous points aux normes de présentation énoncées dans le "Guide pour
la rédaction d'un travail universitaire de 1er, 2e et 3e cycles".

CONTENU DE L'ARCHIVE

- hecthese-fr.ins : le fichier d'installation de la version
  française de la classe;
- hecthese-en.ins : le fichier d'installation de la version
  anglaise de la classe;
- hecthese.dtx : le code source documenté bilingue de la classe;
- hecthese.pdf : la version française de la documentation de la classe;
- hecthese-en.pdf : la version anglaise de la documentation de la classe;
- README.md : le présent fichier.

INSTALLATION DE LA CLASSE

Suivez les étapes suivantes pour installer la classe :
1. Créez-vous un répertoire de travail.
2. Décompressez l'archive .zip dans votre répertoire de travail.
3. Ouvrez un éditeur de ligne de commande.
4. Changez de répertoire pour atteindre votre répertoire de travail.
5. Saisissez la commande suivante dans l'éditeur :

	latex hecthese-fr.ins
	
La commande générera plusieurs fichiers :

1. la classe elle-même :
	- hecthese.cls

2. un gabarit pour chaque type de thèse ou mémoire possible :
	- gabarit-these-classique.tex
	- gabarit-these-articles.tex
	- gabarit-memoire-classique.tex
	- gabarit-memoire-articles.tex
	
3. un fichier pour chaque section de votre travail :
	- resume-francais.tex
	- resume-anglais.tex
	- liste-abreviations.tex
	- dedicace.tex
	- remerciements.tex
	- avant-propos.tex
	- introduction.tex
	- cadre-theorique.tex
	- revue-litterature.tex
	- chapitre-1.tex
	- chapitre-2.tex
	- chapitre-3.tex
	- article-1.tex
	- article-2.tex
	- article-3.tex
	- conclusion.tex
	- annexe.tex
	
DOCUMENTATION

La documentation jointe à cette classe a pour but de vous permettre
de travailler avec la classe hecthese.