/*
 * Copyright (C) 2017 Yusuke Suzuki <utatane.tea@gmail.com>.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

namespace JSC {

class CallFrame;
class JSObject;
using ExecState = CallFrame;

namespace Yarr {

enum class ErrorCode : uint8_t {
    NoError = 0,
    PatternTooLarge,
    QuantifierOutOfOrder,
    QuantifierWithoutAtom,
    QuantifierTooLarge,
    MissingParentheses,
    ParenthesesUnmatched,
    ParenthesesTypeInvalid,
    InvalidGroupName,
    DuplicateGroupName,
    CharacterClassUnmatched,
    CharacterClassOutOfOrder,
    EscapeUnterminated,
    InvalidUnicodeEscape,
    InvalidBackreference,
    InvalidIdentityEscape,
    InvalidUnicodePropertyExpression,
    TooManyDisjunctions,
    OffsetTooLarge,
    InvalidRegularExpressionFlags,
};

JS_EXPORT_PRIVATE const char* errorMessage(ErrorCode);
inline bool hasError(ErrorCode errorCode)
{
    return errorCode != ErrorCode::NoError;
}

inline bool hasHardError(ErrorCode errorCode)
{
    // TooManyDisjunctions means that we ran out stack compiling.
    // All other errors are due to problems in the expression.
    return hasError(errorCode) && errorCode != ErrorCode::TooManyDisjunctions;
}
JS_EXPORT_PRIVATE JSObject* errorToThrow(ExecState*, ErrorCode);

} } // namespace JSC::Yarr
