// GENERATED FILE - DO NOT EDIT.
// Generated by gen_gl_enum_utils.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// gl_enum_utils_autogen.cpp:
//   mapping of GLenum value to string.

#include "libANGLE/gl_enum_utils_autogen.h"

#include <sstream>

#include "common/bitset_utils.h"

namespace gl
{

namespace
{
constexpr char kEnumUnknown[] = "EnumUnknown";
}  // anonymous namespace

void OutputGLenumString(std::ostream &out, GLenumGroup enumGroup, unsigned int value)
{
    const char *enumStr = GLenumToString(enumGroup, value);
    if (enumStr != kEnumUnknown)
    {
        out << enumStr;
    }
    else
    {
        out << std::hex << value << std::dec;
    }
}

void OutputGLbitfieldString(std::ostream &out, GLenumGroup enumGroup, unsigned int value)
{
    out << GLbitfieldToString(enumGroup, value);
}

const char *GLbooleanToString(unsigned int value)
{
    switch (value)
    {
        case 0x0:
            return "GL_FALSE";
        case 0x1:
            return "GL_TRUE";
        default:
            return kEnumUnknown;
    }
}

const char *GLenumToString(GLenumGroup enumGroup, unsigned int value)
{
    switch (enumGroup)
    {
        case GLenumGroup::AccumOp:
        {
            switch (value)
            {
                case 0x100:
                    return "GL_ACCUM";
                case 0x101:
                    return "GL_LOAD";
                case 0x102:
                    return "GL_RETURN";
                case 0x103:
                    return "GL_MULT";
                case 0x104:
                    return "GL_ADD";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::AlphaFunction:
        {
            switch (value)
            {
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::AtomicCounterBufferPName:
        {
            switch (value)
            {
                case 0x90ed:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER";
                case 0x92c1:
                    return "GL_ATOMIC_COUNTER_BUFFER_BINDING";
                case 0x92c4:
                    return "GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE";
                case 0x92c5:
                    return "GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS";
                case 0x92c6:
                    return "GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES";
                case 0x92c7:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER";
                case 0x92c8:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER";
                case 0x92c9:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER";
                case 0x92ca:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER";
                case 0x92cb:
                    return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::AttribMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_CURRENT_BIT";
                case 0x2:
                    return "GL_POINT_BIT";
                case 0x4:
                    return "GL_LINE_BIT";
                case 0x8:
                    return "GL_POLYGON_BIT";
                case 0x10:
                    return "GL_POLYGON_STIPPLE_BIT";
                case 0x20:
                    return "GL_PIXEL_MODE_BIT";
                case 0x40:
                    return "GL_LIGHTING_BIT";
                case 0x80:
                    return "GL_FOG_BIT";
                case 0x100:
                    return "GL_DEPTH_BUFFER_BIT";
                case 0x200:
                    return "GL_ACCUM_BUFFER_BIT";
                case 0x400:
                    return "GL_STENCIL_BUFFER_BIT";
                case 0x800:
                    return "GL_VIEWPORT_BIT";
                case 0x1000:
                    return "GL_TRANSFORM_BIT";
                case 0x2000:
                    return "GL_ENABLE_BIT";
                case 0x4000:
                    return "GL_COLOR_BUFFER_BIT";
                case 0x8000:
                    return "GL_HINT_BIT";
                case 0x10000:
                    return "GL_EVAL_BIT";
                case 0x20000:
                    return "GL_LIST_BIT";
                case 0x40000:
                    return "GL_TEXTURE_BIT";
                case 0x80000:
                    return "GL_SCISSOR_BIT";
                case 0x20000000:
                    return "GL_MULTISAMPLE_BIT";
                case 0xffffffff:
                    return "GL_ALL_ATTRIB_BITS";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::AttributeType:
        {
            switch (value)
            {
                case 0x8b50:
                    return "GL_FLOAT_VEC2";
                case 0x8b51:
                    return "GL_FLOAT_VEC3";
                case 0x8b52:
                    return "GL_FLOAT_VEC4";
                case 0x8b53:
                    return "GL_INT_VEC2";
                case 0x8b54:
                    return "GL_INT_VEC3";
                case 0x8b55:
                    return "GL_INT_VEC4";
                case 0x8b56:
                    return "GL_BOOL";
                case 0x8b57:
                    return "GL_BOOL_VEC2";
                case 0x8b58:
                    return "GL_BOOL_VEC3";
                case 0x8b59:
                    return "GL_BOOL_VEC4";
                case 0x8b5a:
                    return "GL_FLOAT_MAT2";
                case 0x8b5b:
                    return "GL_FLOAT_MAT3";
                case 0x8b5c:
                    return "GL_FLOAT_MAT4";
                case 0x8b5d:
                    return "GL_SAMPLER_1D";
                case 0x8b5e:
                    return "GL_SAMPLER_2D";
                case 0x8b5f:
                    return "GL_SAMPLER_3D";
                case 0x8b60:
                    return "GL_SAMPLER_CUBE";
                case 0x8b61:
                    return "GL_SAMPLER_1D_SHADOW";
                case 0x8b62:
                    return "GL_SAMPLER_2D_SHADOW";
                case 0x8b63:
                    return "GL_SAMPLER_2D_RECT";
                case 0x8b64:
                    return "GL_SAMPLER_2D_RECT_SHADOW";
                case 0x8b65:
                    return "GL_FLOAT_MAT2x3";
                case 0x8b66:
                    return "GL_FLOAT_MAT2x4";
                case 0x8b67:
                    return "GL_FLOAT_MAT3x2";
                case 0x8b68:
                    return "GL_FLOAT_MAT3x4";
                case 0x8b69:
                    return "GL_FLOAT_MAT4x2";
                case 0x8b6a:
                    return "GL_FLOAT_MAT4x3";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::BindTransformFeedbackTarget:
        {
            switch (value)
            {
                case 0x8e22:
                    return "GL_TRANSFORM_FEEDBACK";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::BlendEquationModeEXT:
        {
            switch (value)
            {
                case 0xbf1:
                    return "GL_LOGIC_OP";
                case 0x8006:
                    return "GL_FUNC_ADD";
                case 0x800a:
                    return "GL_FUNC_SUBTRACT";
                case 0x800b:
                    return "GL_FUNC_REVERSE_SUBTRACT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::BlendingFactor:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_ZERO";
                case 0x1:
                    return "GL_ONE";
                case 0x300:
                    return "GL_SRC_COLOR";
                case 0x301:
                    return "GL_ONE_MINUS_SRC_COLOR";
                case 0x302:
                    return "GL_SRC_ALPHA";
                case 0x303:
                    return "GL_ONE_MINUS_SRC_ALPHA";
                case 0x304:
                    return "GL_DST_ALPHA";
                case 0x305:
                    return "GL_ONE_MINUS_DST_ALPHA";
                case 0x306:
                    return "GL_DST_COLOR";
                case 0x307:
                    return "GL_ONE_MINUS_DST_COLOR";
                case 0x308:
                    return "GL_SRC_ALPHA_SATURATE";
                case 0x8001:
                    return "GL_CONSTANT_COLOR";
                case 0x8002:
                    return "GL_ONE_MINUS_CONSTANT_COLOR";
                case 0x8003:
                    return "GL_CONSTANT_ALPHA";
                case 0x8004:
                    return "GL_ONE_MINUS_CONSTANT_ALPHA";
                case 0x8589:
                    return "GL_SRC1_ALPHA";
                case 0x88f9:
                    return "GL_SRC1_COLOR";
                case 0x88fa:
                    return "GL_ONE_MINUS_SRC1_COLOR";
                case 0x88fb:
                    return "GL_ONE_MINUS_SRC1_ALPHA";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::BlitFramebufferFilter:
        {
            switch (value)
            {
                case 0x2600:
                    return "GL_NEAREST";
                case 0x2601:
                    return "GL_LINEAR";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::Boolean:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_FALSE";
                case 0x1:
                    return "GL_TRUE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::Buffer:
        {
            switch (value)
            {
                case 0x1800:
                    return "GL_COLOR";
                case 0x1801:
                    return "GL_DEPTH";
                case 0x1802:
                    return "GL_STENCIL";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::BufferAccessARB:
        {
            switch (value)
            {
                case 0x88b8:
                    return "GL_READ_ONLY";
                case 0x88b9:
                    return "GL_WRITE_ONLY";
                case 0x88ba:
                    return "GL_READ_WRITE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::BufferAccessMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_MAP_READ_BIT";
                case 0x2:
                    return "GL_MAP_WRITE_BIT";
                case 0x4:
                    return "GL_MAP_INVALIDATE_RANGE_BIT";
                case 0x8:
                    return "GL_MAP_INVALIDATE_BUFFER_BIT";
                case 0x10:
                    return "GL_MAP_FLUSH_EXPLICIT_BIT";
                case 0x20:
                    return "GL_MAP_UNSYNCHRONIZED_BIT";
                case 0x40:
                    return "GL_MAP_PERSISTENT_BIT";
                case 0x80:
                    return "GL_MAP_COHERENT_BIT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::BufferStorageTarget:
        {
            switch (value)
            {
                case 0x8892:
                    return "GL_ARRAY_BUFFER";
                case 0x8893:
                    return "GL_ELEMENT_ARRAY_BUFFER";
                case 0x88eb:
                    return "GL_PIXEL_PACK_BUFFER";
                case 0x88ec:
                    return "GL_PIXEL_UNPACK_BUFFER";
                case 0x8a11:
                    return "GL_UNIFORM_BUFFER";
                case 0x8c2a:
                    return "GL_TEXTURE_BUFFER";
                case 0x8c8e:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x8f36:
                    return "GL_COPY_READ_BUFFER";
                case 0x8f37:
                    return "GL_COPY_WRITE_BUFFER";
                case 0x8f3f:
                    return "GL_DRAW_INDIRECT_BUFFER";
                case 0x90d2:
                    return "GL_SHADER_STORAGE_BUFFER";
                case 0x90ee:
                    return "GL_DISPATCH_INDIRECT_BUFFER";
                case 0x9192:
                    return "GL_QUERY_BUFFER";
                case 0x92c0:
                    return "GL_ATOMIC_COUNTER_BUFFER";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::BufferTargetARB:
        {
            switch (value)
            {
                case 0x8892:
                    return "GL_ARRAY_BUFFER";
                case 0x8893:
                    return "GL_ELEMENT_ARRAY_BUFFER";
                case 0x88eb:
                    return "GL_PIXEL_PACK_BUFFER";
                case 0x88ec:
                    return "GL_PIXEL_UNPACK_BUFFER";
                case 0x8a11:
                    return "GL_UNIFORM_BUFFER";
                case 0x8c2a:
                    return "GL_TEXTURE_BUFFER";
                case 0x8c8e:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x8f36:
                    return "GL_COPY_READ_BUFFER";
                case 0x8f37:
                    return "GL_COPY_WRITE_BUFFER";
                case 0x8f3f:
                    return "GL_DRAW_INDIRECT_BUFFER";
                case 0x90d2:
                    return "GL_SHADER_STORAGE_BUFFER";
                case 0x90ee:
                    return "GL_DISPATCH_INDIRECT_BUFFER";
                case 0x9192:
                    return "GL_QUERY_BUFFER";
                case 0x92c0:
                    return "GL_ATOMIC_COUNTER_BUFFER";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::BufferUsageARB:
        {
            switch (value)
            {
                case 0x88e0:
                    return "GL_STREAM_DRAW";
                case 0x88e1:
                    return "GL_STREAM_READ";
                case 0x88e2:
                    return "GL_STREAM_COPY";
                case 0x88e4:
                    return "GL_STATIC_DRAW";
                case 0x88e5:
                    return "GL_STATIC_READ";
                case 0x88e6:
                    return "GL_STATIC_COPY";
                case 0x88e8:
                    return "GL_DYNAMIC_DRAW";
                case 0x88e9:
                    return "GL_DYNAMIC_READ";
                case 0x88ea:
                    return "GL_DYNAMIC_COPY";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::CheckFramebufferStatusTarget:
        {
            switch (value)
            {
                case 0x8ca8:
                    return "GL_READ_FRAMEBUFFER";
                case 0x8ca9:
                    return "GL_DRAW_FRAMEBUFFER";
                case 0x8d40:
                    return "GL_FRAMEBUFFER";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ClearBufferMask:
        {
            switch (value)
            {
                case 0x100:
                    return "GL_DEPTH_BUFFER_BIT";
                case 0x200:
                    return "GL_ACCUM_BUFFER_BIT";
                case 0x400:
                    return "GL_STENCIL_BUFFER_BIT";
                case 0x4000:
                    return "GL_COLOR_BUFFER_BIT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ClientAttribMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_CLIENT_PIXEL_STORE_BIT";
                case 0x2:
                    return "GL_CLIENT_VERTEX_ARRAY_BIT";
                case 0xffffffff:
                    return "GL_CLIENT_ALL_ATTRIB_BITS";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ClipControlDepth:
        {
            switch (value)
            {
                case 0x935e:
                    return "GL_NEGATIVE_ONE_TO_ONE";
                case 0x935f:
                    return "GL_ZERO_TO_ONE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ClipControlOrigin:
        {
            switch (value)
            {
                case 0x8ca1:
                    return "GL_LOWER_LEFT";
                case 0x8ca2:
                    return "GL_UPPER_LEFT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ClipPlaneName:
        {
            switch (value)
            {
                case 0x3000:
                    return "GL_CLIP_DISTANCE0";
                case 0x3001:
                    return "GL_CLIP_DISTANCE1";
                case 0x3002:
                    return "GL_CLIP_DISTANCE2";
                case 0x3003:
                    return "GL_CLIP_DISTANCE3";
                case 0x3004:
                    return "GL_CLIP_DISTANCE4";
                case 0x3005:
                    return "GL_CLIP_DISTANCE5";
                case 0x3006:
                    return "GL_CLIP_DISTANCE6";
                case 0x3007:
                    return "GL_CLIP_DISTANCE7";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ColorBuffer:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x400:
                    return "GL_FRONT_LEFT";
                case 0x401:
                    return "GL_FRONT_RIGHT";
                case 0x402:
                    return "GL_BACK_LEFT";
                case 0x403:
                    return "GL_BACK_RIGHT";
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x406:
                    return "GL_LEFT";
                case 0x407:
                    return "GL_RIGHT";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                case 0x8ce0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8ce1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8ce2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8ce3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8ce4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8ce5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8ce6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8ce7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8ce8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8ce9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8cea:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8ceb:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8cec:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8ced:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8cee:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8cef:
                    return "GL_COLOR_ATTACHMENT15";
                case 0x8cf0:
                    return "GL_COLOR_ATTACHMENT16";
                case 0x8cf1:
                    return "GL_COLOR_ATTACHMENT17";
                case 0x8cf2:
                    return "GL_COLOR_ATTACHMENT18";
                case 0x8cf3:
                    return "GL_COLOR_ATTACHMENT19";
                case 0x8cf4:
                    return "GL_COLOR_ATTACHMENT20";
                case 0x8cf5:
                    return "GL_COLOR_ATTACHMENT21";
                case 0x8cf6:
                    return "GL_COLOR_ATTACHMENT22";
                case 0x8cf7:
                    return "GL_COLOR_ATTACHMENT23";
                case 0x8cf8:
                    return "GL_COLOR_ATTACHMENT24";
                case 0x8cf9:
                    return "GL_COLOR_ATTACHMENT25";
                case 0x8cfa:
                    return "GL_COLOR_ATTACHMENT26";
                case 0x8cfb:
                    return "GL_COLOR_ATTACHMENT27";
                case 0x8cfc:
                    return "GL_COLOR_ATTACHMENT28";
                case 0x8cfd:
                    return "GL_COLOR_ATTACHMENT29";
                case 0x8cfe:
                    return "GL_COLOR_ATTACHMENT30";
                case 0x8cff:
                    return "GL_COLOR_ATTACHMENT31";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ColorMaterialFace:
        {
            switch (value)
            {
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ColorMaterialParameter:
        {
            switch (value)
            {
                case 0x1200:
                    return "GL_AMBIENT";
                case 0x1201:
                    return "GL_DIFFUSE";
                case 0x1202:
                    return "GL_SPECULAR";
                case 0x1600:
                    return "GL_EMISSION";
                case 0x1602:
                    return "GL_AMBIENT_AND_DIFFUSE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ColorPointerType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140a:
                    return "GL_DOUBLE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ContextFlagMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT";
                case 0x2:
                    return "GL_CONTEXT_FLAG_DEBUG_BIT";
                case 0x4:
                    return "GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT";
                case 0x8:
                    return "GL_CONTEXT_FLAG_NO_ERROR_BIT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ContextProfileMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_CONTEXT_CORE_PROFILE_BIT";
                case 0x2:
                    return "GL_CONTEXT_COMPATIBILITY_PROFILE_BIT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::CopyBufferSubDataTarget:
        {
            switch (value)
            {
                case 0x8892:
                    return "GL_ARRAY_BUFFER";
                case 0x8893:
                    return "GL_ELEMENT_ARRAY_BUFFER";
                case 0x88eb:
                    return "GL_PIXEL_PACK_BUFFER";
                case 0x88ec:
                    return "GL_PIXEL_UNPACK_BUFFER";
                case 0x8a11:
                    return "GL_UNIFORM_BUFFER";
                case 0x8c2a:
                    return "GL_TEXTURE_BUFFER";
                case 0x8c8e:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x8f36:
                    return "GL_COPY_READ_BUFFER";
                case 0x8f37:
                    return "GL_COPY_WRITE_BUFFER";
                case 0x8f3f:
                    return "GL_DRAW_INDIRECT_BUFFER";
                case 0x90d2:
                    return "GL_SHADER_STORAGE_BUFFER";
                case 0x90ee:
                    return "GL_DISPATCH_INDIRECT_BUFFER";
                case 0x9192:
                    return "GL_QUERY_BUFFER";
                case 0x92c0:
                    return "GL_ATOMIC_COUNTER_BUFFER";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::CullFaceMode:
        {
            switch (value)
            {
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::DebugSeverity:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x9146:
                    return "GL_DEBUG_SEVERITY_HIGH";
                case 0x9147:
                    return "GL_DEBUG_SEVERITY_MEDIUM";
                case 0x9148:
                    return "GL_DEBUG_SEVERITY_LOW";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::DebugSource:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x8246:
                    return "GL_DEBUG_SOURCE_API";
                case 0x8247:
                    return "GL_DEBUG_SOURCE_WINDOW_SYSTEM";
                case 0x8248:
                    return "GL_DEBUG_SOURCE_SHADER_COMPILER";
                case 0x8249:
                    return "GL_DEBUG_SOURCE_THIRD_PARTY";
                case 0x824a:
                    return "GL_DEBUG_SOURCE_APPLICATION";
                case 0x824b:
                    return "GL_DEBUG_SOURCE_OTHER";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::DebugType:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x824c:
                    return "GL_DEBUG_TYPE_ERROR";
                case 0x824d:
                    return "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR";
                case 0x824e:
                    return "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR";
                case 0x824f:
                    return "GL_DEBUG_TYPE_PORTABILITY";
                case 0x8250:
                    return "GL_DEBUG_TYPE_PERFORMANCE";
                case 0x8251:
                    return "GL_DEBUG_TYPE_OTHER";
                case 0x8268:
                    return "GL_DEBUG_TYPE_MARKER";
                case 0x8269:
                    return "GL_DEBUG_TYPE_PUSH_GROUP";
                case 0x826a:
                    return "GL_DEBUG_TYPE_POP_GROUP";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::DefaultGroup:
        {
            switch (value)
            {
                case 0x16:
                    return "GL_UUID_SIZE_EXT";
                case 0x308:
                    return "GL_SRC_ALPHA_SATURATE_EXT";
                case 0x503:
                    return "GL_STACK_OVERFLOW_KHR";
                case 0x504:
                    return "GL_STACK_UNDERFLOW_KHR";
                case 0x507:
                    return "GL_CONTEXT_LOST";
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR_OES";
                case 0x1006:
                    return "GL_TEXTURE_TARGET";
                case 0x2500:
                    return "GL_TEXTURE_GEN_MODE_OES";
                case 0x8005:
                    return "GL_BLEND_COLOR";
                case 0x8007:
                    return "GL_MIN";
                case 0x8008:
                    return "GL_MAX";
                case 0x8009:
                    return "GL_BLEND_EQUATION";
                case 0x803a:
                    return "GL_RESCALE_NORMAL";
                case 0x803c:
                    return "GL_ALPHA8_EXT";
                case 0x8040:
                    return "GL_LUMINANCE8_EXT";
                case 0x8045:
                    return "GL_LUMINANCE8_ALPHA8_EXT";
                case 0x8055:
                    return "GL_RGBA2";
                case 0x806a:
                    return "GL_TEXTURE_BINDING_3D_OES";
                case 0x8071:
                    return "GL_TEXTURE_DEPTH";
                case 0x8073:
                    return "GL_MAX_3D_TEXTURE_SIZE";
                case 0x8074:
                    return "GL_VERTEX_ARRAY_KHR";
                case 0x809d:
                    return "GL_MULTISAMPLE";
                case 0x809e:
                    return "GL_SAMPLE_ALPHA_TO_COVERAGE";
                case 0x809f:
                    return "GL_SAMPLE_ALPHA_TO_ONE";
                case 0x80a0:
                    return "GL_SAMPLE_COVERAGE";
                case 0x80aa:
                    return "GL_SAMPLE_COVERAGE_VALUE";
                case 0x80ab:
                    return "GL_SAMPLE_COVERAGE_INVERT";
                case 0x80c8:
                    return "GL_BLEND_DST_RGB";
                case 0x80c9:
                    return "GL_BLEND_SRC_RGB";
                case 0x80ca:
                    return "GL_BLEND_DST_ALPHA";
                case 0x80cb:
                    return "GL_BLEND_SRC_ALPHA";
                case 0x80e0:
                    return "GL_BGR";
                case 0x80e1:
                    return "GL_BGRA";
                case 0x80e8:
                    return "GL_MAX_ELEMENTS_VERTICES";
                case 0x80e9:
                    return "GL_MAX_ELEMENTS_INDICES";
                case 0x80ee:
                    return "GL_PARAMETER_BUFFER";
                case 0x80ef:
                    return "GL_PARAMETER_BUFFER_BINDING";
                case 0x812d:
                    return "GL_CLAMP_TO_BORDER_OES";
                case 0x81a6:
                    return "GL_DEPTH_COMPONENT24";
                case 0x81a7:
                    return "GL_DEPTH_COMPONENT32";
                case 0x8218:
                    return "GL_FRAMEBUFFER_DEFAULT";
                case 0x821a:
                    return "GL_DEPTH_STENCIL_ATTACHMENT";
                case 0x821b:
                    return "GL_MAJOR_VERSION";
                case 0x821c:
                    return "GL_MINOR_VERSION";
                case 0x821d:
                    return "GL_NUM_EXTENSIONS";
                case 0x821e:
                    return "GL_CONTEXT_FLAGS";
                case 0x8221:
                    return "GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED";
                case 0x8222:
                    return "GL_INDEX";
                case 0x8228:
                    return "GL_RG_INTEGER";
                case 0x8242:
                    return "GL_DEBUG_OUTPUT_SYNCHRONOUS";
                case 0x8243:
                    return "GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH";
                case 0x8244:
                    return "GL_DEBUG_CALLBACK_FUNCTION_KHR";
                case 0x8245:
                    return "GL_DEBUG_CALLBACK_USER_PARAM_KHR";
                case 0x8246:
                    return "GL_DEBUG_SOURCE_API_KHR";
                case 0x8247:
                    return "GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR";
                case 0x8248:
                    return "GL_DEBUG_SOURCE_SHADER_COMPILER_KHR";
                case 0x8249:
                    return "GL_DEBUG_SOURCE_THIRD_PARTY_KHR";
                case 0x824a:
                    return "GL_DEBUG_SOURCE_APPLICATION_KHR";
                case 0x824b:
                    return "GL_DEBUG_SOURCE_OTHER_KHR";
                case 0x824c:
                    return "GL_DEBUG_TYPE_ERROR_KHR";
                case 0x824d:
                    return "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR";
                case 0x824e:
                    return "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR";
                case 0x824f:
                    return "GL_DEBUG_TYPE_PORTABILITY_KHR";
                case 0x8250:
                    return "GL_DEBUG_TYPE_PERFORMANCE_KHR";
                case 0x8251:
                    return "GL_DEBUG_TYPE_OTHER_KHR";
                case 0x8252:
                    return "GL_LOSE_CONTEXT_ON_RESET";
                case 0x8253:
                    return "GL_GUILTY_CONTEXT_RESET_EXT";
                case 0x8254:
                    return "GL_INNOCENT_CONTEXT_RESET_EXT";
                case 0x8255:
                    return "GL_UNKNOWN_CONTEXT_RESET_EXT";
                case 0x8256:
                    return "GL_RESET_NOTIFICATION_STRATEGY";
                case 0x825a:
                    return "GL_PROGRAM_PIPELINE_BINDING";
                case 0x825b:
                    return "GL_MAX_VIEWPORTS";
                case 0x825c:
                    return "GL_VIEWPORT_SUBPIXEL_BITS";
                case 0x825d:
                    return "GL_VIEWPORT_BOUNDS_RANGE";
                case 0x825e:
                    return "GL_LAYER_PROVOKING_VERTEX";
                case 0x825f:
                    return "GL_VIEWPORT_INDEX_PROVOKING_VERTEX";
                case 0x8260:
                    return "GL_UNDEFINED_VERTEX";
                case 0x8261:
                    return "GL_NO_RESET_NOTIFICATION";
                case 0x8262:
                    return "GL_MAX_COMPUTE_SHARED_MEMORY_SIZE";
                case 0x8263:
                    return "GL_MAX_COMPUTE_UNIFORM_COMPONENTS";
                case 0x8264:
                    return "GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS";
                case 0x8265:
                    return "GL_MAX_COMPUTE_ATOMIC_COUNTERS";
                case 0x8266:
                    return "GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS";
                case 0x8268:
                    return "GL_DEBUG_TYPE_MARKER_KHR";
                case 0x8269:
                    return "GL_DEBUG_TYPE_PUSH_GROUP_KHR";
                case 0x826a:
                    return "GL_DEBUG_TYPE_POP_GROUP_KHR";
                case 0x826b:
                    return "GL_DEBUG_SEVERITY_NOTIFICATION";
                case 0x826c:
                    return "GL_MAX_DEBUG_GROUP_STACK_DEPTH";
                case 0x826d:
                    return "GL_DEBUG_GROUP_STACK_DEPTH";
                case 0x826e:
                    return "GL_MAX_UNIFORM_LOCATIONS";
                case 0x8282:
                    return "GL_MAX_COMBINED_DIMENSIONS";
                case 0x8284:
                    return "GL_DEPTH_COMPONENTS";
                case 0x8285:
                    return "GL_STENCIL_COMPONENTS";
                case 0x8294:
                    return "GL_MANUAL_GENERATE_MIPMAP";
                case 0x82b7:
                    return "GL_FULL_SUPPORT";
                case 0x82b8:
                    return "GL_CAVEAT_SUPPORT";
                case 0x82b9:
                    return "GL_IMAGE_CLASS_4_X_32";
                case 0x82ba:
                    return "GL_IMAGE_CLASS_2_X_32";
                case 0x82bb:
                    return "GL_IMAGE_CLASS_1_X_32";
                case 0x82bc:
                    return "GL_IMAGE_CLASS_4_X_16";
                case 0x82bd:
                    return "GL_IMAGE_CLASS_2_X_16";
                case 0x82be:
                    return "GL_IMAGE_CLASS_1_X_16";
                case 0x82bf:
                    return "GL_IMAGE_CLASS_4_X_8";
                case 0x82c0:
                    return "GL_IMAGE_CLASS_2_X_8";
                case 0x82c1:
                    return "GL_IMAGE_CLASS_1_X_8";
                case 0x82c2:
                    return "GL_IMAGE_CLASS_11_11_10";
                case 0x82c3:
                    return "GL_IMAGE_CLASS_10_10_10_2";
                case 0x82c4:
                    return "GL_VIEW_CLASS_128_BITS";
                case 0x82c5:
                    return "GL_VIEW_CLASS_96_BITS";
                case 0x82c6:
                    return "GL_VIEW_CLASS_64_BITS";
                case 0x82c7:
                    return "GL_VIEW_CLASS_48_BITS";
                case 0x82c8:
                    return "GL_VIEW_CLASS_32_BITS";
                case 0x82c9:
                    return "GL_VIEW_CLASS_24_BITS";
                case 0x82ca:
                    return "GL_VIEW_CLASS_16_BITS";
                case 0x82cb:
                    return "GL_VIEW_CLASS_8_BITS";
                case 0x82cc:
                    return "GL_VIEW_CLASS_S3TC_DXT1_RGB";
                case 0x82cd:
                    return "GL_VIEW_CLASS_S3TC_DXT1_RGBA";
                case 0x82ce:
                    return "GL_VIEW_CLASS_S3TC_DXT3_RGBA";
                case 0x82cf:
                    return "GL_VIEW_CLASS_S3TC_DXT5_RGBA";
                case 0x82d0:
                    return "GL_VIEW_CLASS_RGTC1_RED";
                case 0x82d1:
                    return "GL_VIEW_CLASS_RGTC2_RG";
                case 0x82d2:
                    return "GL_VIEW_CLASS_BPTC_UNORM";
                case 0x82d3:
                    return "GL_VIEW_CLASS_BPTC_FLOAT";
                case 0x82d4:
                    return "GL_VERTEX_ATTRIB_BINDING";
                case 0x82d6:
                    return "GL_VERTEX_BINDING_DIVISOR";
                case 0x82d7:
                    return "GL_VERTEX_BINDING_OFFSET";
                case 0x82d8:
                    return "GL_VERTEX_BINDING_STRIDE";
                case 0x82d9:
                    return "GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET";
                case 0x82da:
                    return "GL_MAX_VERTEX_ATTRIB_BINDINGS";
                case 0x82db:
                    return "GL_TEXTURE_VIEW_MIN_LEVEL";
                case 0x82dc:
                    return "GL_TEXTURE_VIEW_NUM_LEVELS";
                case 0x82dd:
                    return "GL_TEXTURE_VIEW_MIN_LAYER";
                case 0x82de:
                    return "GL_TEXTURE_VIEW_NUM_LAYERS";
                case 0x82df:
                    return "GL_TEXTURE_IMMUTABLE_LEVELS";
                case 0x82e0:
                    return "GL_BUFFER_KHR";
                case 0x82e1:
                    return "GL_SHADER_KHR";
                case 0x82e2:
                    return "GL_PROGRAM_KHR";
                case 0x82e3:
                    return "GL_QUERY_KHR";
                case 0x82e4:
                    return "GL_PROGRAM_PIPELINE_KHR";
                case 0x82e5:
                    return "GL_MAX_VERTEX_ATTRIB_STRIDE";
                case 0x82e6:
                    return "GL_SAMPLER_KHR";
                case 0x82e7:
                    return "GL_DISPLAY_LIST";
                case 0x82e8:
                    return "GL_MAX_LABEL_LENGTH";
                case 0x82e9:
                    return "GL_NUM_SHADING_LANGUAGE_VERSIONS";
                case 0x82ec:
                    return "GL_TRANSFORM_FEEDBACK_OVERFLOW";
                case 0x82ed:
                    return "GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW";
                case 0x82ee:
                    return "GL_VERTICES_SUBMITTED";
                case 0x82ef:
                    return "GL_PRIMITIVES_SUBMITTED";
                case 0x82f0:
                    return "GL_VERTEX_SHADER_INVOCATIONS";
                case 0x82f1:
                    return "GL_TESS_CONTROL_SHADER_PATCHES";
                case 0x82f2:
                    return "GL_TESS_EVALUATION_SHADER_INVOCATIONS";
                case 0x82f3:
                    return "GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED";
                case 0x82f4:
                    return "GL_FRAGMENT_SHADER_INVOCATIONS";
                case 0x82f5:
                    return "GL_COMPUTE_SHADER_INVOCATIONS";
                case 0x82f6:
                    return "GL_CLIPPING_INPUT_PRIMITIVES";
                case 0x82f7:
                    return "GL_CLIPPING_OUTPUT_PRIMITIVES";
                case 0x82f9:
                    return "GL_MAX_CULL_DISTANCES";
                case 0x82fa:
                    return "GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES";
                case 0x82fb:
                    return "GL_CONTEXT_RELEASE_BEHAVIOR";
                case 0x82fc:
                    return "GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH";
                case 0x8362:
                    return "GL_UNSIGNED_BYTE_2_3_3_REV";
                case 0x8363:
                    return "GL_UNSIGNED_SHORT_5_6_5";
                case 0x8364:
                    return "GL_UNSIGNED_SHORT_5_6_5_REV";
                case 0x8365:
                    return "GL_UNSIGNED_SHORT_4_4_4_4_REV";
                case 0x8366:
                    return "GL_UNSIGNED_SHORT_1_5_5_5_REV";
                case 0x8367:
                    return "GL_UNSIGNED_INT_8_8_8_8_REV";
                case 0x8370:
                    return "GL_MIRRORED_REPEAT";
                case 0x8450:
                    return "GL_FOG_COORDINATE_SOURCE";
                case 0x8451:
                    return "GL_FOG_COORD";
                case 0x8452:
                    return "GL_FRAGMENT_DEPTH";
                case 0x8453:
                    return "GL_CURRENT_FOG_COORD";
                case 0x8454:
                    return "GL_FOG_COORDINATE_ARRAY_TYPE";
                case 0x8455:
                    return "GL_FOG_COORDINATE_ARRAY_STRIDE";
                case 0x8456:
                    return "GL_FOG_COORDINATE_ARRAY_POINTER";
                case 0x8457:
                    return "GL_FOG_COORDINATE_ARRAY";
                case 0x8458:
                    return "GL_COLOR_SUM";
                case 0x8459:
                    return "GL_CURRENT_SECONDARY_COLOR";
                case 0x845a:
                    return "GL_SECONDARY_COLOR_ARRAY_SIZE";
                case 0x845b:
                    return "GL_SECONDARY_COLOR_ARRAY_TYPE";
                case 0x845c:
                    return "GL_SECONDARY_COLOR_ARRAY_STRIDE";
                case 0x845d:
                    return "GL_SECONDARY_COLOR_ARRAY_POINTER";
                case 0x845e:
                    return "GL_SECONDARY_COLOR_ARRAY";
                case 0x845f:
                    return "GL_CURRENT_RASTER_SECONDARY_COLOR";
                case 0x84e0:
                    return "GL_ACTIVE_TEXTURE";
                case 0x84e1:
                    return "GL_CLIENT_ACTIVE_TEXTURE";
                case 0x84e2:
                    return "GL_MAX_TEXTURE_UNITS";
                case 0x84e3:
                    return "GL_TRANSPOSE_MODELVIEW_MATRIX";
                case 0x84e4:
                    return "GL_TRANSPOSE_PROJECTION_MATRIX";
                case 0x84e5:
                    return "GL_TRANSPOSE_TEXTURE_MATRIX";
                case 0x84e6:
                    return "GL_TRANSPOSE_COLOR_MATRIX";
                case 0x84e7:
                    return "GL_SUBTRACT";
                case 0x84e8:
                    return "GL_MAX_RENDERBUFFER_SIZE";
                case 0x84e9:
                    return "GL_COMPRESSED_ALPHA";
                case 0x84ea:
                    return "GL_COMPRESSED_LUMINANCE";
                case 0x84eb:
                    return "GL_COMPRESSED_LUMINANCE_ALPHA";
                case 0x84ec:
                    return "GL_COMPRESSED_INTENSITY";
                case 0x84f2:
                    return "GL_ALL_COMPLETED_NV";
                case 0x84f3:
                    return "GL_FENCE_STATUS_NV";
                case 0x84f4:
                    return "GL_FENCE_CONDITION_NV";
                case 0x84f6:
                    return "GL_TEXTURE_BINDING_RECTANGLE";
                case 0x84f8:
                    return "GL_MAX_RECTANGLE_TEXTURE_SIZE";
                case 0x84fa:
                    return "GL_UNSIGNED_INT_24_8";
                case 0x84fd:
                    return "GL_MAX_TEXTURE_LOD_BIAS";
                case 0x84fe:
                    return "GL_TEXTURE_MAX_ANISOTROPY";
                case 0x84ff:
                    return "GL_MAX_TEXTURE_MAX_ANISOTROPY";
                case 0x8500:
                    return "GL_TEXTURE_FILTER_CONTROL";
                case 0x8507:
                    return "GL_INCR_WRAP";
                case 0x8508:
                    return "GL_DECR_WRAP";
                case 0x8511:
                    return "GL_NORMAL_MAP";
                case 0x8512:
                    return "GL_REFLECTION_MAP";
                case 0x8513:
                    return "GL_TEXTURE_CUBE_MAP_OES";
                case 0x8514:
                    return "GL_TEXTURE_BINDING_CUBE_MAP";
                case 0x8515:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_X_OES";
                case 0x8516:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_X_OES";
                case 0x8517:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Y_OES";
                case 0x8518:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES";
                case 0x8519:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Z_OES";
                case 0x851a:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES";
                case 0x851c:
                    return "GL_MAX_CUBE_MAP_TEXTURE_SIZE";
                case 0x8570:
                    return "GL_COMBINE";
                case 0x8571:
                    return "GL_COMBINE_RGB";
                case 0x8572:
                    return "GL_COMBINE_ALPHA";
                case 0x8573:
                    return "GL_RGB_SCALE";
                case 0x8574:
                    return "GL_ADD_SIGNED";
                case 0x8575:
                    return "GL_INTERPOLATE";
                case 0x8578:
                    return "GL_PREVIOUS";
                case 0x8580:
                    return "GL_SOURCE0_RGB";
                case 0x8581:
                    return "GL_SOURCE1_RGB";
                case 0x8582:
                    return "GL_SOURCE2_RGB";
                case 0x8588:
                    return "GL_SOURCE0_ALPHA";
                case 0x8589:
                    return "GL_SOURCE1_ALPHA";
                case 0x858a:
                    return "GL_SOURCE2_ALPHA";
                case 0x8590:
                    return "GL_OPERAND0_RGB";
                case 0x8591:
                    return "GL_OPERAND1_RGB";
                case 0x8592:
                    return "GL_OPERAND2_RGB";
                case 0x8598:
                    return "GL_OPERAND0_ALPHA";
                case 0x8599:
                    return "GL_OPERAND1_ALPHA";
                case 0x859a:
                    return "GL_OPERAND2_ALPHA";
                case 0x85b5:
                    return "GL_VERTEX_ARRAY_BINDING";
                case 0x8642:
                    return "GL_PROGRAM_POINT_SIZE";
                case 0x8643:
                    return "GL_VERTEX_PROGRAM_TWO_SIDE";
                case 0x8645:
                    return "GL_VERTEX_ATTRIB_ARRAY_POINTER";
                case 0x864f:
                    return "GL_DEPTH_CLAMP";
                case 0x86a0:
                    return "GL_TEXTURE_COMPRESSED_IMAGE_SIZE";
                case 0x86a2:
                    return "GL_NUM_COMPRESSED_TEXTURE_FORMATS";
                case 0x86a3:
                    return "GL_COMPRESSED_TEXTURE_FORMATS";
                case 0x86a4:
                    return "GL_MAX_VERTEX_UNITS_OES";
                case 0x86a9:
                    return "GL_WEIGHT_ARRAY_TYPE_OES";
                case 0x86aa:
                    return "GL_WEIGHT_ARRAY_STRIDE_OES";
                case 0x86ab:
                    return "GL_WEIGHT_ARRAY_SIZE_OES";
                case 0x86ac:
                    return "GL_WEIGHT_ARRAY_POINTER_OES";
                case 0x86ad:
                    return "GL_WEIGHT_ARRAY_OES";
                case 0x86ae:
                    return "GL_DOT3_RGB";
                case 0x86af:
                    return "GL_DOT3_RGBA";
                case 0x8741:
                    return "GL_PROGRAM_BINARY_LENGTH_OES";
                case 0x8743:
                    return "GL_MIRROR_CLAMP_TO_EDGE";
                case 0x87fe:
                    return "GL_NUM_PROGRAM_BINARY_FORMATS";
                case 0x87ff:
                    return "GL_PROGRAM_BINARY_FORMATS";
                case 0x8800:
                    return "GL_STENCIL_BACK_FUNC";
                case 0x8801:
                    return "GL_STENCIL_BACK_FAIL";
                case 0x8802:
                    return "GL_STENCIL_BACK_PASS_DEPTH_FAIL";
                case 0x8803:
                    return "GL_STENCIL_BACK_PASS_DEPTH_PASS";
                case 0x8815:
                    return "GL_RGB32F";
                case 0x8816:
                    return "GL_ALPHA32F_EXT";
                case 0x8818:
                    return "GL_LUMINANCE32F_EXT";
                case 0x8819:
                    return "GL_LUMINANCE_ALPHA32F_EXT";
                case 0x881c:
                    return "GL_ALPHA16F_EXT";
                case 0x881e:
                    return "GL_LUMINANCE16F_EXT";
                case 0x881f:
                    return "GL_LUMINANCE_ALPHA16F_EXT";
                case 0x8824:
                    return "GL_MAX_DRAW_BUFFERS";
                case 0x8825:
                    return "GL_DRAW_BUFFER0";
                case 0x8826:
                    return "GL_DRAW_BUFFER1";
                case 0x8827:
                    return "GL_DRAW_BUFFER2";
                case 0x8828:
                    return "GL_DRAW_BUFFER3";
                case 0x8829:
                    return "GL_DRAW_BUFFER4";
                case 0x882a:
                    return "GL_DRAW_BUFFER5";
                case 0x882b:
                    return "GL_DRAW_BUFFER6";
                case 0x882c:
                    return "GL_DRAW_BUFFER7";
                case 0x882d:
                    return "GL_DRAW_BUFFER8";
                case 0x882e:
                    return "GL_DRAW_BUFFER9";
                case 0x882f:
                    return "GL_DRAW_BUFFER10";
                case 0x8830:
                    return "GL_DRAW_BUFFER11";
                case 0x8831:
                    return "GL_DRAW_BUFFER12";
                case 0x8832:
                    return "GL_DRAW_BUFFER13";
                case 0x8833:
                    return "GL_DRAW_BUFFER14";
                case 0x8834:
                    return "GL_DRAW_BUFFER15";
                case 0x883d:
                    return "GL_BLEND_EQUATION_ALPHA";
                case 0x8840:
                    return "GL_MATRIX_PALETTE_OES";
                case 0x8842:
                    return "GL_MAX_PALETTE_MATRICES_OES";
                case 0x8843:
                    return "GL_CURRENT_PALETTE_MATRIX_OES";
                case 0x8844:
                    return "GL_MATRIX_INDEX_ARRAY_OES";
                case 0x8846:
                    return "GL_MATRIX_INDEX_ARRAY_SIZE_OES";
                case 0x8847:
                    return "GL_MATRIX_INDEX_ARRAY_TYPE_OES";
                case 0x8848:
                    return "GL_MATRIX_INDEX_ARRAY_STRIDE_OES";
                case 0x8849:
                    return "GL_MATRIX_INDEX_ARRAY_POINTER_OES";
                case 0x884a:
                    return "GL_TEXTURE_DEPTH_SIZE";
                case 0x884b:
                    return "GL_DEPTH_TEXTURE_MODE";
                case 0x884e:
                    return "GL_COMPARE_REF_TO_TEXTURE";
                case 0x884f:
                    return "GL_TEXTURE_CUBE_MAP_SEAMLESS";
                case 0x8861:
                    return "GL_POINT_SPRITE";
                case 0x8862:
                    return "GL_COORD_REPLACE";
                case 0x8864:
                    return "GL_QUERY_COUNTER_BITS_EXT";
                case 0x8865:
                    return "GL_CURRENT_QUERY_EXT";
                case 0x8866:
                    return "GL_QUERY_RESULT_EXT";
                case 0x8867:
                    return "GL_QUERY_RESULT_AVAILABLE_EXT";
                case 0x8869:
                    return "GL_MAX_VERTEX_ATTRIBS";
                case 0x886c:
                    return "GL_MAX_TESS_CONTROL_INPUT_COMPONENTS";
                case 0x886d:
                    return "GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS";
                case 0x8871:
                    return "GL_MAX_TEXTURE_COORDS";
                case 0x8872:
                    return "GL_MAX_TEXTURE_IMAGE_UNITS";
                case 0x887f:
                    return "GL_GEOMETRY_SHADER_INVOCATIONS";
                case 0x8894:
                    return "GL_ARRAY_BUFFER_BINDING";
                case 0x8895:
                    return "GL_ELEMENT_ARRAY_BUFFER_BINDING";
                case 0x8896:
                    return "GL_VERTEX_ARRAY_BUFFER_BINDING";
                case 0x8897:
                    return "GL_NORMAL_ARRAY_BUFFER_BINDING";
                case 0x8898:
                    return "GL_COLOR_ARRAY_BUFFER_BINDING";
                case 0x8899:
                    return "GL_INDEX_ARRAY_BUFFER_BINDING";
                case 0x889a:
                    return "GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING";
                case 0x889b:
                    return "GL_EDGE_FLAG_ARRAY_BUFFER_BINDING";
                case 0x889c:
                    return "GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING";
                case 0x889d:
                    return "GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING";
                case 0x889e:
                    return "GL_WEIGHT_ARRAY_BUFFER_BINDING";
                case 0x88b9:
                    return "GL_WRITE_ONLY_OES";
                case 0x88bb:
                    return "GL_BUFFER_ACCESS_OES";
                case 0x88bc:
                    return "GL_BUFFER_MAPPED_OES";
                case 0x88bd:
                    return "GL_BUFFER_MAP_POINTER";
                case 0x88bf:
                    return "GL_TIME_ELAPSED_EXT";
                case 0x88ed:
                    return "GL_PIXEL_PACK_BUFFER_BINDING";
                case 0x88ef:
                    return "GL_PIXEL_UNPACK_BUFFER_BINDING";
                case 0x88f1:
                    return "GL_TEXTURE_STENCIL_SIZE";
                case 0x88f9:
                    return "GL_SRC1_COLOR_EXT";
                case 0x88fa:
                    return "GL_ONE_MINUS_SRC1_COLOR_EXT";
                case 0x88fb:
                    return "GL_ONE_MINUS_SRC1_ALPHA_EXT";
                case 0x88fc:
                    return "GL_MAX_DUAL_SOURCE_DRAW_BUFFERS";
                case 0x88fe:
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE";
                case 0x88ff:
                    return "GL_MAX_ARRAY_TEXTURE_LAYERS";
                case 0x8904:
                    return "GL_MIN_PROGRAM_TEXEL_OFFSET";
                case 0x8905:
                    return "GL_MAX_PROGRAM_TEXEL_OFFSET";
                case 0x8916:
                    return "GL_GEOMETRY_LINKED_VERTICES_OUT_EXT";
                case 0x8917:
                    return "GL_GEOMETRY_LINKED_INPUT_TYPE_EXT";
                case 0x8918:
                    return "GL_GEOMETRY_LINKED_OUTPUT_TYPE_EXT";
                case 0x8919:
                    return "GL_SAMPLER_BINDING";
                case 0x891a:
                    return "GL_CLAMP_VERTEX_COLOR";
                case 0x891b:
                    return "GL_CLAMP_FRAGMENT_COLOR";
                case 0x891c:
                    return "GL_CLAMP_READ_COLOR";
                case 0x891d:
                    return "GL_FIXED_ONLY";
                case 0x898a:
                    return "GL_POINT_SIZE_ARRAY_TYPE_OES";
                case 0x898b:
                    return "GL_POINT_SIZE_ARRAY_STRIDE_OES";
                case 0x898c:
                    return "GL_POINT_SIZE_ARRAY_POINTER_OES";
                case 0x8a28:
                    return "GL_UNIFORM_BUFFER_BINDING";
                case 0x8a29:
                    return "GL_UNIFORM_BUFFER_START";
                case 0x8a2a:
                    return "GL_UNIFORM_BUFFER_SIZE";
                case 0x8a2b:
                    return "GL_MAX_VERTEX_UNIFORM_BLOCKS";
                case 0x8a2c:
                    return "GL_MAX_GEOMETRY_UNIFORM_BLOCKS";
                case 0x8a2d:
                    return "GL_MAX_FRAGMENT_UNIFORM_BLOCKS";
                case 0x8a2e:
                    return "GL_MAX_COMBINED_UNIFORM_BLOCKS";
                case 0x8a2f:
                    return "GL_MAX_UNIFORM_BUFFER_BINDINGS";
                case 0x8a30:
                    return "GL_MAX_UNIFORM_BLOCK_SIZE";
                case 0x8a31:
                    return "GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS";
                case 0x8a32:
                    return "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS";
                case 0x8a33:
                    return "GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS";
                case 0x8a34:
                    return "GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT";
                case 0x8b49:
                    return "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS";
                case 0x8b4a:
                    return "GL_MAX_VERTEX_UNIFORM_COMPONENTS";
                case 0x8b4b:
                    return "GL_MAX_VARYING_COMPONENTS";
                case 0x8b4c:
                    return "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS";
                case 0x8b4d:
                    return "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS";
                case 0x8b8d:
                    return "GL_CURRENT_PROGRAM";
                case 0x8b9c:
                    return "GL_POINT_SIZE_ARRAY_OES";
                case 0x8b9d:
                    return "GL_TEXTURE_CROP_RECT_OES";
                case 0x8b9e:
                    return "GL_MATRIX_INDEX_ARRAY_BUFFER_BINDING_OES";
                case 0x8b9f:
                    return "GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES";
                case 0x8c10:
                    return "GL_TEXTURE_RED_TYPE";
                case 0x8c11:
                    return "GL_TEXTURE_GREEN_TYPE";
                case 0x8c12:
                    return "GL_TEXTURE_BLUE_TYPE";
                case 0x8c13:
                    return "GL_TEXTURE_ALPHA_TYPE";
                case 0x8c14:
                    return "GL_TEXTURE_LUMINANCE_TYPE";
                case 0x8c15:
                    return "GL_TEXTURE_INTENSITY_TYPE";
                case 0x8c16:
                    return "GL_TEXTURE_DEPTH_TYPE";
                case 0x8c17:
                    return "GL_UNSIGNED_NORMALIZED";
                case 0x8c1c:
                    return "GL_TEXTURE_BINDING_1D_ARRAY";
                case 0x8c1d:
                    return "GL_TEXTURE_BINDING_2D_ARRAY";
                case 0x8c29:
                    return "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS";
                case 0x8c2a:
                    return "GL_TEXTURE_BUFFER_BINDING";
                case 0x8c2b:
                    return "GL_MAX_TEXTURE_BUFFER_SIZE";
                case 0x8c2c:
                    return "GL_TEXTURE_BINDING_BUFFER";
                case 0x8c2d:
                    return "GL_TEXTURE_BUFFER_DATA_STORE_BINDING";
                case 0x8c2f:
                    return "GL_ANY_SAMPLES_PASSED_EXT";
                case 0x8c36:
                    return "GL_SAMPLE_SHADING";
                case 0x8c37:
                    return "GL_MIN_SAMPLE_SHADING_VALUE";
                case 0x8c3e:
                    return "GL_UNSIGNED_INT_5_9_9_9_REV";
                case 0x8c3f:
                    return "GL_TEXTURE_SHARED_SIZE";
                case 0x8c44:
                    return "GL_SLUMINANCE_ALPHA";
                case 0x8c45:
                    return "GL_SLUMINANCE8_ALPHA8";
                case 0x8c46:
                    return "GL_SLUMINANCE";
                case 0x8c47:
                    return "GL_SLUMINANCE8";
                case 0x8c4a:
                    return "GL_COMPRESSED_SLUMINANCE";
                case 0x8c4b:
                    return "GL_COMPRESSED_SLUMINANCE_ALPHA";
                case 0x8c80:
                    return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS";
                case 0x8c87:
                    return "GL_PRIMITIVES_GENERATED_EXT";
                case 0x8c89:
                    return "GL_RASTERIZER_DISCARD";
                case 0x8c8a:
                    return "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS";
                case 0x8c8b:
                    return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS";
                case 0x8c8c:
                    return "GL_INTERLEAVED_ATTRIBS";
                case 0x8c8d:
                    return "GL_SEPARATE_ATTRIBS";
                case 0x8ca0:
                    return "GL_POINT_SPRITE_COORD_ORIGIN";
                case 0x8ca3:
                    return "GL_STENCIL_BACK_REF";
                case 0x8ca4:
                    return "GL_STENCIL_BACK_VALUE_MASK";
                case 0x8ca5:
                    return "GL_STENCIL_BACK_WRITEMASK";
                case 0x8ca6:
                    return "GL_DRAW_FRAMEBUFFER_BINDING";
                case 0x8ca7:
                    return "GL_RENDERBUFFER_BINDING";
                case 0x8ca8:
                    return "GL_READ_FRAMEBUFFER_ANGLE";
                case 0x8ca9:
                    return "GL_DRAW_FRAMEBUFFER_ANGLE";
                case 0x8caa:
                    return "GL_READ_FRAMEBUFFER_BINDING";
                case 0x8cab:
                    return "GL_RENDERBUFFER_SAMPLES_ANGLE";
                case 0x8cd0:
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE";
                case 0x8cd1:
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_OES";
                case 0x8cd2:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_OES";
                case 0x8cd3:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_OES";
                case 0x8cd4:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES";
                case 0x8cd5:
                    return "GL_FRAMEBUFFER_COMPLETE_OES";
                case 0x8cd6:
                    return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_OES";
                case 0x8cd7:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_OES";
                case 0x8cd9:
                    return "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS";
                case 0x8cda:
                    return "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_OES";
                case 0x8cdd:
                    return "GL_FRAMEBUFFER_UNSUPPORTED_OES";
                case 0x8d20:
                    return "GL_STENCIL_ATTACHMENT";
                case 0x8d40:
                    return "GL_FRAMEBUFFER_OES";
                case 0x8d41:
                    return "GL_RENDERBUFFER_OES";
                case 0x8d42:
                    return "GL_RENDERBUFFER_WIDTH_OES";
                case 0x8d43:
                    return "GL_RENDERBUFFER_HEIGHT_OES";
                case 0x8d44:
                    return "GL_RENDERBUFFER_INTERNAL_FORMAT_OES";
                case 0x8d46:
                    return "GL_STENCIL_INDEX1";
                case 0x8d47:
                    return "GL_STENCIL_INDEX4";
                case 0x8d48:
                    return "GL_STENCIL_INDEX8";
                case 0x8d49:
                    return "GL_STENCIL_INDEX16";
                case 0x8d50:
                    return "GL_RENDERBUFFER_RED_SIZE_OES";
                case 0x8d51:
                    return "GL_RENDERBUFFER_GREEN_SIZE_OES";
                case 0x8d52:
                    return "GL_RENDERBUFFER_BLUE_SIZE_OES";
                case 0x8d53:
                    return "GL_RENDERBUFFER_ALPHA_SIZE_OES";
                case 0x8d54:
                    return "GL_RENDERBUFFER_DEPTH_SIZE_OES";
                case 0x8d55:
                    return "GL_RENDERBUFFER_STENCIL_SIZE_OES";
                case 0x8d56:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE";
                case 0x8d57:
                    return "GL_MAX_SAMPLES";
                case 0x8d60:
                    return "GL_TEXTURE_GEN_STR_OES";
                case 0x8d62:
                    return "GL_RGB565";
                case 0x8d69:
                    return "GL_PRIMITIVE_RESTART_FIXED_INDEX";
                case 0x8d6a:
                    return "GL_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT";
                case 0x8d6b:
                    return "GL_MAX_ELEMENT_INDEX";
                case 0x8d94:
                    return "GL_RED_INTEGER";
                case 0x8d95:
                    return "GL_GREEN_INTEGER";
                case 0x8d96:
                    return "GL_BLUE_INTEGER";
                case 0x8d97:
                    return "GL_ALPHA_INTEGER";
                case 0x8d98:
                    return "GL_RGB_INTEGER";
                case 0x8d99:
                    return "GL_RGBA_INTEGER";
                case 0x8d9a:
                    return "GL_BGR_INTEGER";
                case 0x8d9b:
                    return "GL_BGRA_INTEGER";
                case 0x8da7:
                    return "GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT";
                case 0x8da8:
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT";
                case 0x8dad:
                    return "GL_FLOAT_32_UNSIGNED_INT_24_8_REV";
                case 0x8db9:
                    return "GL_FRAMEBUFFER_SRGB";
                case 0x8dc0:
                    return "GL_SAMPLER_1D_ARRAY";
                case 0x8dc1:
                    return "GL_SAMPLER_2D_ARRAY";
                case 0x8dc2:
                    return "GL_SAMPLER_BUFFER";
                case 0x8dc3:
                    return "GL_SAMPLER_1D_ARRAY_SHADOW";
                case 0x8dc4:
                    return "GL_SAMPLER_2D_ARRAY_SHADOW";
                case 0x8dc5:
                    return "GL_SAMPLER_CUBE_SHADOW";
                case 0x8dc6:
                    return "GL_UNSIGNED_INT_VEC2";
                case 0x8dc7:
                    return "GL_UNSIGNED_INT_VEC3";
                case 0x8dc8:
                    return "GL_UNSIGNED_INT_VEC4";
                case 0x8dc9:
                    return "GL_INT_SAMPLER_1D";
                case 0x8dca:
                    return "GL_INT_SAMPLER_2D";
                case 0x8dcb:
                    return "GL_INT_SAMPLER_3D";
                case 0x8dcc:
                    return "GL_INT_SAMPLER_CUBE";
                case 0x8dcd:
                    return "GL_INT_SAMPLER_2D_RECT";
                case 0x8dce:
                    return "GL_INT_SAMPLER_1D_ARRAY";
                case 0x8dcf:
                    return "GL_INT_SAMPLER_2D_ARRAY";
                case 0x8dd0:
                    return "GL_INT_SAMPLER_BUFFER";
                case 0x8dd1:
                    return "GL_UNSIGNED_INT_SAMPLER_1D";
                case 0x8dd2:
                    return "GL_UNSIGNED_INT_SAMPLER_2D";
                case 0x8dd3:
                    return "GL_UNSIGNED_INT_SAMPLER_3D";
                case 0x8dd4:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE";
                case 0x8dd5:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_RECT";
                case 0x8dd6:
                    return "GL_UNSIGNED_INT_SAMPLER_1D_ARRAY";
                case 0x8dd7:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY";
                case 0x8dd8:
                    return "GL_UNSIGNED_INT_SAMPLER_BUFFER";
                case 0x8dd9:
                    return "GL_GEOMETRY_SHADER_EXT";
                case 0x8ddf:
                    return "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS";
                case 0x8de0:
                    return "GL_MAX_GEOMETRY_OUTPUT_VERTICES";
                case 0x8de1:
                    return "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS";
                case 0x8de7:
                    return "GL_MAX_SUBROUTINES";
                case 0x8de8:
                    return "GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS";
                case 0x8df8:
                    return "GL_SHADER_BINARY_FORMATS";
                case 0x8df9:
                    return "GL_NUM_SHADER_BINARY_FORMATS";
                case 0x8dfa:
                    return "GL_SHADER_COMPILER";
                case 0x8dfb:
                    return "GL_MAX_VERTEX_UNIFORM_VECTORS";
                case 0x8dfc:
                    return "GL_MAX_VARYING_VECTORS";
                case 0x8dfd:
                    return "GL_MAX_FRAGMENT_UNIFORM_VECTORS";
                case 0x8e17:
                    return "GL_QUERY_WAIT_INVERTED";
                case 0x8e18:
                    return "GL_QUERY_NO_WAIT_INVERTED";
                case 0x8e19:
                    return "GL_QUERY_BY_REGION_WAIT_INVERTED";
                case 0x8e1a:
                    return "GL_QUERY_BY_REGION_NO_WAIT_INVERTED";
                case 0x8e1b:
                    return "GL_POLYGON_OFFSET_CLAMP";
                case 0x8e1e:
                    return "GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS";
                case 0x8e1f:
                    return "GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS";
                case 0x8e23:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED";
                case 0x8e24:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE";
                case 0x8e25:
                    return "GL_TRANSFORM_FEEDBACK_BINDING";
                case 0x8e28:
                    return "GL_TIMESTAMP";
                case 0x8e4c:
                    return "GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION";
                case 0x8e4d:
                    return "GL_FIRST_VERTEX_CONVENTION_EXT";
                case 0x8e4e:
                    return "GL_LAST_VERTEX_CONVENTION_EXT";
                case 0x8e4f:
                    return "GL_PROVOKING_VERTEX";
                case 0x8e50:
                    return "GL_SAMPLE_POSITION";
                case 0x8e51:
                    return "GL_SAMPLE_MASK";
                case 0x8e52:
                    return "GL_SAMPLE_MASK_VALUE";
                case 0x8e59:
                    return "GL_MAX_SAMPLE_MASK_WORDS";
                case 0x8e5a:
                    return "GL_MAX_GEOMETRY_SHADER_INVOCATIONS";
                case 0x8e5b:
                    return "GL_MIN_FRAGMENT_INTERPOLATION_OFFSET";
                case 0x8e5c:
                    return "GL_MAX_FRAGMENT_INTERPOLATION_OFFSET";
                case 0x8e5d:
                    return "GL_FRAGMENT_INTERPOLATION_OFFSET_BITS";
                case 0x8e5e:
                    return "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET";
                case 0x8e5f:
                    return "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET";
                case 0x8e70:
                    return "GL_MAX_TRANSFORM_FEEDBACK_BUFFERS";
                case 0x8e71:
                    return "GL_MAX_VERTEX_STREAMS";
                case 0x8e75:
                    return "GL_TESS_CONTROL_OUTPUT_VERTICES";
                case 0x8e76:
                    return "GL_TESS_GEN_MODE";
                case 0x8e77:
                    return "GL_TESS_GEN_SPACING";
                case 0x8e78:
                    return "GL_TESS_GEN_VERTEX_ORDER";
                case 0x8e79:
                    return "GL_TESS_GEN_POINT_MODE";
                case 0x8e7a:
                    return "GL_ISOLINES";
                case 0x8e7b:
                    return "GL_FRACTIONAL_ODD";
                case 0x8e7c:
                    return "GL_FRACTIONAL_EVEN";
                case 0x8e7d:
                    return "GL_MAX_PATCH_VERTICES";
                case 0x8e7e:
                    return "GL_MAX_TESS_GEN_LEVEL";
                case 0x8e7f:
                    return "GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS";
                case 0x8e80:
                    return "GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS";
                case 0x8e81:
                    return "GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS";
                case 0x8e82:
                    return "GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS";
                case 0x8e83:
                    return "GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS";
                case 0x8e84:
                    return "GL_MAX_TESS_PATCH_COMPONENTS";
                case 0x8e85:
                    return "GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS";
                case 0x8e86:
                    return "GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS";
                case 0x8e89:
                    return "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS";
                case 0x8e8a:
                    return "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS";
                case 0x8f36:
                    return "GL_COPY_READ_BUFFER_BINDING";
                case 0x8f37:
                    return "GL_COPY_WRITE_BUFFER_BINDING";
                case 0x8f38:
                    return "GL_MAX_IMAGE_UNITS";
                case 0x8f39:
                    return "GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS";
                case 0x8f3a:
                    return "GL_IMAGE_BINDING_NAME";
                case 0x8f3b:
                    return "GL_IMAGE_BINDING_LEVEL";
                case 0x8f3c:
                    return "GL_IMAGE_BINDING_LAYERED";
                case 0x8f3d:
                    return "GL_IMAGE_BINDING_LAYER";
                case 0x8f3e:
                    return "GL_IMAGE_BINDING_ACCESS";
                case 0x8f43:
                    return "GL_DRAW_INDIRECT_BUFFER_BINDING";
                case 0x8f46:
                    return "GL_DOUBLE_MAT2";
                case 0x8f47:
                    return "GL_DOUBLE_MAT3";
                case 0x8f48:
                    return "GL_DOUBLE_MAT4";
                case 0x8f49:
                    return "GL_DOUBLE_MAT2x3";
                case 0x8f4a:
                    return "GL_DOUBLE_MAT2x4";
                case 0x8f4b:
                    return "GL_DOUBLE_MAT3x2";
                case 0x8f4c:
                    return "GL_DOUBLE_MAT3x4";
                case 0x8f4d:
                    return "GL_DOUBLE_MAT4x2";
                case 0x8f4e:
                    return "GL_DOUBLE_MAT4x3";
                case 0x8f4f:
                    return "GL_VERTEX_BINDING_BUFFER";
                case 0x8f9b:
                    return "GL_RGBA16_SNORM";
                case 0x8f9c:
                    return "GL_SIGNED_NORMALIZED";
                case 0x8f9d:
                    return "GL_PRIMITIVE_RESTART";
                case 0x8f9e:
                    return "GL_PRIMITIVE_RESTART_INDEX";
                case 0x8fbb:
                    return "GL_GPU_DISJOINT_EXT";
                case 0x8ffc:
                    return "GL_DOUBLE_VEC2";
                case 0x8ffd:
                    return "GL_DOUBLE_VEC3";
                case 0x8ffe:
                    return "GL_DOUBLE_VEC4";
                case 0x900a:
                    return "GL_TEXTURE_BINDING_CUBE_MAP_ARRAY";
                case 0x900c:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900d:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW";
                case 0x900e:
                    return "GL_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900f:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x904c:
                    return "GL_IMAGE_1D";
                case 0x904d:
                    return "GL_IMAGE_2D";
                case 0x904e:
                    return "GL_IMAGE_3D";
                case 0x904f:
                    return "GL_IMAGE_2D_RECT";
                case 0x9050:
                    return "GL_IMAGE_CUBE";
                case 0x9051:
                    return "GL_IMAGE_BUFFER";
                case 0x9052:
                    return "GL_IMAGE_1D_ARRAY";
                case 0x9053:
                    return "GL_IMAGE_2D_ARRAY";
                case 0x9054:
                    return "GL_IMAGE_CUBE_MAP_ARRAY";
                case 0x9055:
                    return "GL_IMAGE_2D_MULTISAMPLE";
                case 0x9056:
                    return "GL_IMAGE_2D_MULTISAMPLE_ARRAY";
                case 0x9057:
                    return "GL_INT_IMAGE_1D";
                case 0x9058:
                    return "GL_INT_IMAGE_2D";
                case 0x9059:
                    return "GL_INT_IMAGE_3D";
                case 0x905a:
                    return "GL_INT_IMAGE_2D_RECT";
                case 0x905b:
                    return "GL_INT_IMAGE_CUBE";
                case 0x905c:
                    return "GL_INT_IMAGE_BUFFER";
                case 0x905d:
                    return "GL_INT_IMAGE_1D_ARRAY";
                case 0x905e:
                    return "GL_INT_IMAGE_2D_ARRAY";
                case 0x905f:
                    return "GL_INT_IMAGE_CUBE_MAP_ARRAY";
                case 0x9060:
                    return "GL_INT_IMAGE_2D_MULTISAMPLE";
                case 0x9061:
                    return "GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY";
                case 0x9062:
                    return "GL_UNSIGNED_INT_IMAGE_1D";
                case 0x9063:
                    return "GL_UNSIGNED_INT_IMAGE_2D";
                case 0x9064:
                    return "GL_UNSIGNED_INT_IMAGE_3D";
                case 0x9065:
                    return "GL_UNSIGNED_INT_IMAGE_2D_RECT";
                case 0x9066:
                    return "GL_UNSIGNED_INT_IMAGE_CUBE";
                case 0x9067:
                    return "GL_UNSIGNED_INT_IMAGE_BUFFER";
                case 0x9068:
                    return "GL_UNSIGNED_INT_IMAGE_1D_ARRAY";
                case 0x9069:
                    return "GL_UNSIGNED_INT_IMAGE_2D_ARRAY";
                case 0x906a:
                    return "GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY";
                case 0x906b:
                    return "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE";
                case 0x906c:
                    return "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY";
                case 0x906d:
                    return "GL_MAX_IMAGE_SAMPLES";
                case 0x906e:
                    return "GL_IMAGE_BINDING_FORMAT";
                case 0x90bc:
                    return "GL_MIN_MAP_BUFFER_ALIGNMENT";
                case 0x90c8:
                    return "GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE";
                case 0x90c9:
                    return "GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS";
                case 0x90ca:
                    return "GL_MAX_VERTEX_IMAGE_UNIFORMS";
                case 0x90cb:
                    return "GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS";
                case 0x90cc:
                    return "GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS";
                case 0x90cd:
                    return "GL_MAX_GEOMETRY_IMAGE_UNIFORMS";
                case 0x90ce:
                    return "GL_MAX_FRAGMENT_IMAGE_UNIFORMS";
                case 0x90cf:
                    return "GL_MAX_COMBINED_IMAGE_UNIFORMS";
                case 0x90d3:
                    return "GL_SHADER_STORAGE_BUFFER_BINDING";
                case 0x90d4:
                    return "GL_SHADER_STORAGE_BUFFER_START";
                case 0x90d5:
                    return "GL_SHADER_STORAGE_BUFFER_SIZE";
                case 0x90d6:
                    return "GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS";
                case 0x90d7:
                    return "GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS";
                case 0x90d8:
                    return "GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS";
                case 0x90d9:
                    return "GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS";
                case 0x90da:
                    return "GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS";
                case 0x90db:
                    return "GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS";
                case 0x90dc:
                    return "GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS";
                case 0x90dd:
                    return "GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS";
                case 0x90de:
                    return "GL_MAX_SHADER_STORAGE_BLOCK_SIZE";
                case 0x90df:
                    return "GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT";
                case 0x90eb:
                    return "GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS";
                case 0x90ef:
                    return "GL_DISPATCH_INDIRECT_BUFFER_BINDING";
                case 0x90f3:
                    return "GL_CONTEXT_ROBUST_ACCESS";
                case 0x9102:
                    return "GL_TEXTURE_2D_MULTISAMPLE_ARRAY_OES";
                case 0x9104:
                    return "GL_TEXTURE_BINDING_2D_MULTISAMPLE";
                case 0x9105:
                    return "GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY";
                case 0x9106:
                    return "GL_TEXTURE_SAMPLES";
                case 0x9107:
                    return "GL_TEXTURE_FIXED_SAMPLE_LOCATIONS";
                case 0x9108:
                    return "GL_SAMPLER_2D_MULTISAMPLE";
                case 0x9109:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910a:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910b:
                    return "GL_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910c:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910d:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910e:
                    return "GL_MAX_COLOR_TEXTURE_SAMPLES";
                case 0x910f:
                    return "GL_MAX_DEPTH_TEXTURE_SAMPLES";
                case 0x9110:
                    return "GL_MAX_INTEGER_SAMPLES";
                case 0x9111:
                    return "GL_MAX_SERVER_WAIT_TIMEOUT";
                case 0x9116:
                    return "GL_SYNC_FENCE";
                case 0x9118:
                    return "GL_UNSIGNALED";
                case 0x9119:
                    return "GL_SIGNALED";
                case 0x9122:
                    return "GL_MAX_VERTEX_OUTPUT_COMPONENTS";
                case 0x9123:
                    return "GL_MAX_GEOMETRY_INPUT_COMPONENTS";
                case 0x9124:
                    return "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS";
                case 0x9125:
                    return "GL_MAX_FRAGMENT_INPUT_COMPONENTS";
                case 0x9126:
                    return "GL_CONTEXT_PROFILE_MASK";
                case 0x9127:
                    return "GL_UNPACK_COMPRESSED_BLOCK_WIDTH";
                case 0x9128:
                    return "GL_UNPACK_COMPRESSED_BLOCK_HEIGHT";
                case 0x9129:
                    return "GL_UNPACK_COMPRESSED_BLOCK_DEPTH";
                case 0x912a:
                    return "GL_UNPACK_COMPRESSED_BLOCK_SIZE";
                case 0x912b:
                    return "GL_PACK_COMPRESSED_BLOCK_WIDTH";
                case 0x912c:
                    return "GL_PACK_COMPRESSED_BLOCK_HEIGHT";
                case 0x912d:
                    return "GL_PACK_COMPRESSED_BLOCK_DEPTH";
                case 0x912e:
                    return "GL_PACK_COMPRESSED_BLOCK_SIZE";
                case 0x912f:
                    return "GL_TEXTURE_IMMUTABLE_FORMAT";
                case 0x9143:
                    return "GL_MAX_DEBUG_MESSAGE_LENGTH";
                case 0x9144:
                    return "GL_MAX_DEBUG_LOGGED_MESSAGES";
                case 0x9145:
                    return "GL_DEBUG_LOGGED_MESSAGES";
                case 0x9146:
                    return "GL_DEBUG_SEVERITY_HIGH_KHR";
                case 0x9147:
                    return "GL_DEBUG_SEVERITY_MEDIUM_KHR";
                case 0x9148:
                    return "GL_DEBUG_SEVERITY_LOW_KHR";
                case 0x9193:
                    return "GL_QUERY_BUFFER_BINDING";
                case 0x919d:
                    return "GL_TEXTURE_BUFFER_OFFSET";
                case 0x919e:
                    return "GL_TEXTURE_BUFFER_SIZE";
                case 0x919f:
                    return "GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT";
                case 0x91b0:
                    return "GL_MAX_SHADER_COMPILER_THREADS_KHR";
                case 0x91b1:
                    return "GL_COMPLETION_STATUS_KHR";
                case 0x91bb:
                    return "GL_MAX_COMPUTE_UNIFORM_BLOCKS";
                case 0x91bc:
                    return "GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS";
                case 0x91bd:
                    return "GL_MAX_COMPUTE_IMAGE_UNIFORMS";
                case 0x91be:
                    return "GL_MAX_COMPUTE_WORK_GROUP_COUNT";
                case 0x91bf:
                    return "GL_MAX_COMPUTE_WORK_GROUP_SIZE";
                case 0x9294:
                    return "GL_MULTIPLY";
                case 0x9295:
                    return "GL_SCREEN";
                case 0x9296:
                    return "GL_OVERLAY";
                case 0x9297:
                    return "GL_DARKEN";
                case 0x9298:
                    return "GL_LIGHTEN";
                case 0x9299:
                    return "GL_COLORDODGE";
                case 0x929a:
                    return "GL_COLORBURN";
                case 0x929b:
                    return "GL_HARDLIGHT";
                case 0x929c:
                    return "GL_SOFTLIGHT";
                case 0x929e:
                    return "GL_DIFFERENCE";
                case 0x92a0:
                    return "GL_EXCLUSION";
                case 0x92ad:
                    return "GL_HSL_HUE";
                case 0x92ae:
                    return "GL_HSL_SATURATION";
                case 0x92af:
                    return "GL_HSL_COLOR";
                case 0x92b0:
                    return "GL_HSL_LUMINOSITY";
                case 0x92be:
                    return "GL_PRIMITIVE_BOUNDING_BOX";
                case 0x92c2:
                    return "GL_ATOMIC_COUNTER_BUFFER_START";
                case 0x92c3:
                    return "GL_ATOMIC_COUNTER_BUFFER_SIZE";
                case 0x92cc:
                    return "GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS";
                case 0x92cd:
                    return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS";
                case 0x92ce:
                    return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS";
                case 0x92cf:
                    return "GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS";
                case 0x92d0:
                    return "GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS";
                case 0x92d1:
                    return "GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS";
                case 0x92d2:
                    return "GL_MAX_VERTEX_ATOMIC_COUNTERS";
                case 0x92d3:
                    return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS";
                case 0x92d4:
                    return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS";
                case 0x92d5:
                    return "GL_MAX_GEOMETRY_ATOMIC_COUNTERS";
                case 0x92d6:
                    return "GL_MAX_FRAGMENT_ATOMIC_COUNTERS";
                case 0x92d7:
                    return "GL_MAX_COMBINED_ATOMIC_COUNTERS";
                case 0x92d8:
                    return "GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE";
                case 0x92db:
                    return "GL_UNSIGNED_INT_ATOMIC_COUNTER";
                case 0x92dc:
                    return "GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS";
                case 0x92e0:
                    return "GL_DEBUG_OUTPUT";
                case 0x92e7:
                    return "GL_IS_PER_PATCH";
                case 0x92f9:
                    return "GL_NAME_LENGTH";
                case 0x92fa:
                    return "GL_TYPE";
                case 0x92fb:
                    return "GL_ARRAY_SIZE";
                case 0x92fc:
                    return "GL_OFFSET";
                case 0x92fd:
                    return "GL_BLOCK_INDEX";
                case 0x92fe:
                    return "GL_ARRAY_STRIDE";
                case 0x92ff:
                    return "GL_MATRIX_STRIDE";
                case 0x9300:
                    return "GL_IS_ROW_MAJOR";
                case 0x9301:
                    return "GL_ATOMIC_COUNTER_BUFFER_INDEX";
                case 0x9302:
                    return "GL_BUFFER_BINDING";
                case 0x9303:
                    return "GL_BUFFER_DATA_SIZE";
                case 0x9304:
                    return "GL_NUM_ACTIVE_VARIABLES";
                case 0x9305:
                    return "GL_ACTIVE_VARIABLES";
                case 0x9306:
                    return "GL_REFERENCED_BY_VERTEX_SHADER";
                case 0x9307:
                    return "GL_REFERENCED_BY_TESS_CONTROL_SHADER";
                case 0x9308:
                    return "GL_REFERENCED_BY_TESS_EVALUATION_SHADER";
                case 0x9309:
                    return "GL_REFERENCED_BY_GEOMETRY_SHADER";
                case 0x930a:
                    return "GL_REFERENCED_BY_FRAGMENT_SHADER";
                case 0x930b:
                    return "GL_REFERENCED_BY_COMPUTE_SHADER";
                case 0x930c:
                    return "GL_TOP_LEVEL_ARRAY_SIZE";
                case 0x930d:
                    return "GL_TOP_LEVEL_ARRAY_STRIDE";
                case 0x930e:
                    return "GL_LOCATION";
                case 0x930f:
                    return "GL_LOCATION_INDEX";
                case 0x9312:
                    return "GL_FRAMEBUFFER_DEFAULT_LAYERS_EXT";
                case 0x9315:
                    return "GL_MAX_FRAMEBUFFER_WIDTH";
                case 0x9316:
                    return "GL_MAX_FRAMEBUFFER_HEIGHT";
                case 0x9317:
                    return "GL_MAX_FRAMEBUFFER_LAYERS";
                case 0x9318:
                    return "GL_MAX_FRAMEBUFFER_SAMPLES";
                case 0x934a:
                    return "GL_LOCATION_COMPONENT";
                case 0x934b:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_INDEX";
                case 0x934c:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE";
                case 0x935c:
                    return "GL_CLIP_ORIGIN";
                case 0x935d:
                    return "GL_CLIP_DEPTH_MODE";
                case 0x9381:
                    return "GL_MULTISAMPLE_LINE_WIDTH_RANGE";
                case 0x9382:
                    return "GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY";
                case 0x93a0:
                    return "GL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE";
                case 0x93a1:
                    return "GL_BGRA8_EXT";
                case 0x93a6:
                    return "GL_PROGRAM_BINARY_ANGLE";
                case 0x93b0:
                    return "GL_COMPRESSED_RGBA_ASTC_4x4";
                case 0x93b1:
                    return "GL_COMPRESSED_RGBA_ASTC_5x4";
                case 0x93b2:
                    return "GL_COMPRESSED_RGBA_ASTC_5x5";
                case 0x93b3:
                    return "GL_COMPRESSED_RGBA_ASTC_6x5";
                case 0x93b4:
                    return "GL_COMPRESSED_RGBA_ASTC_6x6";
                case 0x93b5:
                    return "GL_COMPRESSED_RGBA_ASTC_8x5";
                case 0x93b6:
                    return "GL_COMPRESSED_RGBA_ASTC_8x6";
                case 0x93b7:
                    return "GL_COMPRESSED_RGBA_ASTC_8x8";
                case 0x93b8:
                    return "GL_COMPRESSED_RGBA_ASTC_10x5";
                case 0x93b9:
                    return "GL_COMPRESSED_RGBA_ASTC_10x6";
                case 0x93ba:
                    return "GL_COMPRESSED_RGBA_ASTC_10x8";
                case 0x93bb:
                    return "GL_COMPRESSED_RGBA_ASTC_10x10";
                case 0x93bc:
                    return "GL_COMPRESSED_RGBA_ASTC_12x10";
                case 0x93bd:
                    return "GL_COMPRESSED_RGBA_ASTC_12x12";
                case 0x93d0:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4";
                case 0x93d1:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4";
                case 0x93d2:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5";
                case 0x93d3:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5";
                case 0x93d4:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6";
                case 0x93d5:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5";
                case 0x93d6:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6";
                case 0x93d7:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8";
                case 0x93d8:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5";
                case 0x93d9:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6";
                case 0x93da:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8";
                case 0x93db:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10";
                case 0x93dc:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10";
                case 0x93dd:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12";
                case 0x9551:
                    return "GL_SHADER_BINARY_FORMAT_SPIR_V";
                case 0x9552:
                    return "GL_SPIR_V_BINARY";
                case 0x9553:
                    return "GL_SPIR_V_EXTENSIONS";
                case 0x9554:
                    return "GL_NUM_SPIR_V_EXTENSIONS";
                case 0x9582:
                    return "GL_NUM_TILING_TYPES_EXT";
                case 0x9583:
                    return "GL_TILING_TYPES_EXT";
                case 0x9584:
                    return "GL_OPTIMAL_TILING_EXT";
                case 0x9585:
                    return "GL_LINEAR_TILING_EXT";
                case 0x9630:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR";
                case 0x9631:
                    return "GL_MAX_VIEWS_OVR";
                case 0x9632:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR";
                case 0x9633:
                    return "GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::DepthFunction:
        {
            switch (value)
            {
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::DrawBufferMode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x400:
                    return "GL_FRONT_LEFT";
                case 0x401:
                    return "GL_FRONT_RIGHT";
                case 0x402:
                    return "GL_BACK_LEFT";
                case 0x403:
                    return "GL_BACK_RIGHT";
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x406:
                    return "GL_LEFT";
                case 0x407:
                    return "GL_RIGHT";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                case 0x409:
                    return "GL_AUX0";
                case 0x40a:
                    return "GL_AUX1";
                case 0x40b:
                    return "GL_AUX2";
                case 0x40c:
                    return "GL_AUX3";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::DrawElementsType:
        {
            switch (value)
            {
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::EnableCap:
        {
            switch (value)
            {
                case 0xb10:
                    return "GL_POINT_SMOOTH";
                case 0xb20:
                    return "GL_LINE_SMOOTH";
                case 0xb24:
                    return "GL_LINE_STIPPLE";
                case 0xb41:
                    return "GL_POLYGON_SMOOTH";
                case 0xb42:
                    return "GL_POLYGON_STIPPLE";
                case 0xb44:
                    return "GL_CULL_FACE";
                case 0xb50:
                    return "GL_LIGHTING";
                case 0xb57:
                    return "GL_COLOR_MATERIAL";
                case 0xb60:
                    return "GL_FOG";
                case 0xb71:
                    return "GL_DEPTH_TEST";
                case 0xb90:
                    return "GL_STENCIL_TEST";
                case 0xba1:
                    return "GL_NORMALIZE";
                case 0xbc0:
                    return "GL_ALPHA_TEST";
                case 0xbd0:
                    return "GL_DITHER";
                case 0xbe2:
                    return "GL_BLEND";
                case 0xbf1:
                    return "GL_INDEX_LOGIC_OP";
                case 0xbf2:
                    return "GL_COLOR_LOGIC_OP";
                case 0xc11:
                    return "GL_SCISSOR_TEST";
                case 0xc60:
                    return "GL_TEXTURE_GEN_S";
                case 0xc61:
                    return "GL_TEXTURE_GEN_T";
                case 0xc62:
                    return "GL_TEXTURE_GEN_R";
                case 0xc63:
                    return "GL_TEXTURE_GEN_Q";
                case 0xd80:
                    return "GL_AUTO_NORMAL";
                case 0xd90:
                    return "GL_MAP1_COLOR_4";
                case 0xd91:
                    return "GL_MAP1_INDEX";
                case 0xd92:
                    return "GL_MAP1_NORMAL";
                case 0xd93:
                    return "GL_MAP1_TEXTURE_COORD_1";
                case 0xd94:
                    return "GL_MAP1_TEXTURE_COORD_2";
                case 0xd95:
                    return "GL_MAP1_TEXTURE_COORD_3";
                case 0xd96:
                    return "GL_MAP1_TEXTURE_COORD_4";
                case 0xd97:
                    return "GL_MAP1_VERTEX_3";
                case 0xd98:
                    return "GL_MAP1_VERTEX_4";
                case 0xdb0:
                    return "GL_MAP2_COLOR_4";
                case 0xdb1:
                    return "GL_MAP2_INDEX";
                case 0xdb2:
                    return "GL_MAP2_NORMAL";
                case 0xdb3:
                    return "GL_MAP2_TEXTURE_COORD_1";
                case 0xdb4:
                    return "GL_MAP2_TEXTURE_COORD_2";
                case 0xdb5:
                    return "GL_MAP2_TEXTURE_COORD_3";
                case 0xdb6:
                    return "GL_MAP2_TEXTURE_COORD_4";
                case 0xdb7:
                    return "GL_MAP2_VERTEX_3";
                case 0xdb8:
                    return "GL_MAP2_VERTEX_4";
                case 0xde0:
                    return "GL_TEXTURE_1D";
                case 0xde1:
                    return "GL_TEXTURE_2D";
                case 0x2a01:
                    return "GL_POLYGON_OFFSET_POINT";
                case 0x2a02:
                    return "GL_POLYGON_OFFSET_LINE";
                case 0x3000:
                    return "GL_CLIP_PLANE0";
                case 0x3001:
                    return "GL_CLIP_PLANE1";
                case 0x3002:
                    return "GL_CLIP_PLANE2";
                case 0x3003:
                    return "GL_CLIP_PLANE3";
                case 0x3004:
                    return "GL_CLIP_PLANE4";
                case 0x3005:
                    return "GL_CLIP_PLANE5";
                case 0x4000:
                    return "GL_LIGHT0";
                case 0x4001:
                    return "GL_LIGHT1";
                case 0x4002:
                    return "GL_LIGHT2";
                case 0x4003:
                    return "GL_LIGHT3";
                case 0x4004:
                    return "GL_LIGHT4";
                case 0x4005:
                    return "GL_LIGHT5";
                case 0x4006:
                    return "GL_LIGHT6";
                case 0x4007:
                    return "GL_LIGHT7";
                case 0x8037:
                    return "GL_POLYGON_OFFSET_FILL";
                case 0x8074:
                    return "GL_VERTEX_ARRAY";
                case 0x8075:
                    return "GL_NORMAL_ARRAY";
                case 0x8076:
                    return "GL_COLOR_ARRAY";
                case 0x8077:
                    return "GL_INDEX_ARRAY";
                case 0x8078:
                    return "GL_TEXTURE_COORD_ARRAY";
                case 0x8079:
                    return "GL_EDGE_FLAG_ARRAY";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ErrorCode:
        {
            switch (value)
            {
                case 0x500:
                    return "GL_INVALID_ENUM";
                case 0x501:
                    return "GL_INVALID_VALUE";
                case 0x502:
                    return "GL_INVALID_OPERATION";
                case 0x503:
                    return "GL_STACK_OVERFLOW";
                case 0x504:
                    return "GL_STACK_UNDERFLOW";
                case 0x505:
                    return "GL_OUT_OF_MEMORY";
                case 0x506:
                    return "GL_INVALID_FRAMEBUFFER_OPERATION";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ExternalHandleType:
        {
            switch (value)
            {
                case 0x9586:
                    return "GL_HANDLE_TYPE_OPAQUE_FD_EXT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::FeedBackToken:
        {
            switch (value)
            {
                case 0x700:
                    return "GL_PASS_THROUGH_TOKEN";
                case 0x701:
                    return "GL_POINT_TOKEN";
                case 0x702:
                    return "GL_LINE_TOKEN";
                case 0x703:
                    return "GL_POLYGON_TOKEN";
                case 0x704:
                    return "GL_BITMAP_TOKEN";
                case 0x705:
                    return "GL_DRAW_PIXEL_TOKEN";
                case 0x706:
                    return "GL_COPY_PIXEL_TOKEN";
                case 0x707:
                    return "GL_LINE_RESET_TOKEN";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::FeedbackType:
        {
            switch (value)
            {
                case 0x600:
                    return "GL_2D";
                case 0x601:
                    return "GL_3D";
                case 0x602:
                    return "GL_3D_COLOR";
                case 0x603:
                    return "GL_3D_COLOR_TEXTURE";
                case 0x604:
                    return "GL_4D_COLOR_TEXTURE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::FogCoordinatePointerType:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140a:
                    return "GL_DOUBLE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::FogMode:
        {
            switch (value)
            {
                case 0x800:
                    return "GL_EXP";
                case 0x801:
                    return "GL_EXP2";
                case 0x2601:
                    return "GL_LINEAR";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::FogPName:
        {
            switch (value)
            {
                case 0xb61:
                    return "GL_FOG_INDEX";
                case 0xb62:
                    return "GL_FOG_DENSITY";
                case 0xb63:
                    return "GL_FOG_START";
                case 0xb64:
                    return "GL_FOG_END";
                case 0xb65:
                    return "GL_FOG_MODE";
                case 0x8450:
                    return "GL_FOG_COORD_SRC";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::FogParameter:
        {
            switch (value)
            {
                case 0xb61:
                    return "GL_FOG_INDEX";
                case 0xb62:
                    return "GL_FOG_DENSITY";
                case 0xb63:
                    return "GL_FOG_START";
                case 0xb64:
                    return "GL_FOG_END";
                case 0xb65:
                    return "GL_FOG_MODE";
                case 0xb66:
                    return "GL_FOG_COLOR";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::FogPointerTypeEXT:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140a:
                    return "GL_DOUBLE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::FogPointerTypeIBM:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140a:
                    return "GL_DOUBLE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::FramebufferAttachment:
        {
            switch (value)
            {
                case 0x8cdf:
                    return "GL_MAX_COLOR_ATTACHMENTS";
                case 0x8ce0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8ce1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8ce2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8ce3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8ce4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8ce5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8ce6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8ce7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8ce8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8ce9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8cea:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8ceb:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8cec:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8ced:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8cee:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8cef:
                    return "GL_COLOR_ATTACHMENT15";
                case 0x8cf0:
                    return "GL_COLOR_ATTACHMENT16";
                case 0x8cf1:
                    return "GL_COLOR_ATTACHMENT17";
                case 0x8cf2:
                    return "GL_COLOR_ATTACHMENT18";
                case 0x8cf3:
                    return "GL_COLOR_ATTACHMENT19";
                case 0x8cf4:
                    return "GL_COLOR_ATTACHMENT20";
                case 0x8cf5:
                    return "GL_COLOR_ATTACHMENT21";
                case 0x8cf6:
                    return "GL_COLOR_ATTACHMENT22";
                case 0x8cf7:
                    return "GL_COLOR_ATTACHMENT23";
                case 0x8cf8:
                    return "GL_COLOR_ATTACHMENT24";
                case 0x8cf9:
                    return "GL_COLOR_ATTACHMENT25";
                case 0x8cfa:
                    return "GL_COLOR_ATTACHMENT26";
                case 0x8cfb:
                    return "GL_COLOR_ATTACHMENT27";
                case 0x8cfc:
                    return "GL_COLOR_ATTACHMENT28";
                case 0x8cfd:
                    return "GL_COLOR_ATTACHMENT29";
                case 0x8cfe:
                    return "GL_COLOR_ATTACHMENT30";
                case 0x8cff:
                    return "GL_COLOR_ATTACHMENT31";
                case 0x8d00:
                    return "GL_DEPTH_ATTACHMENT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::FramebufferAttachmentParameterName:
        {
            switch (value)
            {
                case 0x8210:
                    return "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING";
                case 0x8211:
                    return "GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE";
                case 0x8212:
                    return "GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE";
                case 0x8213:
                    return "GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE";
                case 0x8214:
                    return "GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE";
                case 0x8215:
                    return "GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE";
                case 0x8216:
                    return "GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE";
                case 0x8217:
                    return "GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE";
                case 0x8cd1:
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME";
                case 0x8cd2:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL";
                case 0x8cd3:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE";
                case 0x8cd4:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER";
                case 0x8da7:
                    return "GL_FRAMEBUFFER_ATTACHMENT_LAYERED";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::FramebufferParameterName:
        {
            switch (value)
            {
                case 0x9310:
                    return "GL_FRAMEBUFFER_DEFAULT_WIDTH";
                case 0x9311:
                    return "GL_FRAMEBUFFER_DEFAULT_HEIGHT";
                case 0x9312:
                    return "GL_FRAMEBUFFER_DEFAULT_LAYERS";
                case 0x9313:
                    return "GL_FRAMEBUFFER_DEFAULT_SAMPLES";
                case 0x9314:
                    return "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::FramebufferStatus:
        {
            switch (value)
            {
                case 0x8219:
                    return "GL_FRAMEBUFFER_UNDEFINED";
                case 0x8cd5:
                    return "GL_FRAMEBUFFER_COMPLETE";
                case 0x8cd6:
                    return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
                case 0x8cd7:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                case 0x8cdb:
                    return "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER";
                case 0x8cdc:
                    return "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER";
                case 0x8cdd:
                    return "GL_FRAMEBUFFER_UNSUPPORTED";
                case 0x8d56:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE";
                case 0x8da8:
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::FramebufferTarget:
        {
            switch (value)
            {
                case 0x8ca8:
                    return "GL_READ_FRAMEBUFFER";
                case 0x8ca9:
                    return "GL_DRAW_FRAMEBUFFER";
                case 0x8d40:
                    return "GL_FRAMEBUFFER";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::FrontFaceDirection:
        {
            switch (value)
            {
                case 0x900:
                    return "GL_CW";
                case 0x901:
                    return "GL_CCW";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::GetFramebufferParameter:
        {
            switch (value)
            {
                case 0xc32:
                    return "GL_DOUBLEBUFFER";
                case 0xc33:
                    return "GL_STEREO";
                case 0x80a8:
                    return "GL_SAMPLE_BUFFERS";
                case 0x80a9:
                    return "GL_SAMPLES";
                case 0x8b9a:
                    return "GL_IMPLEMENTATION_COLOR_READ_TYPE";
                case 0x8b9b:
                    return "GL_IMPLEMENTATION_COLOR_READ_FORMAT";
                case 0x9310:
                    return "GL_FRAMEBUFFER_DEFAULT_WIDTH";
                case 0x9311:
                    return "GL_FRAMEBUFFER_DEFAULT_HEIGHT";
                case 0x9312:
                    return "GL_FRAMEBUFFER_DEFAULT_LAYERS";
                case 0x9313:
                    return "GL_FRAMEBUFFER_DEFAULT_SAMPLES";
                case 0x9314:
                    return "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::GetMapQuery:
        {
            switch (value)
            {
                case 0xa00:
                    return "GL_COEFF";
                case 0xa01:
                    return "GL_ORDER";
                case 0xa02:
                    return "GL_DOMAIN";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::GetPName:
        {
            switch (value)
            {
                case 0xb00:
                    return "GL_CURRENT_COLOR";
                case 0xb01:
                    return "GL_CURRENT_INDEX";
                case 0xb02:
                    return "GL_CURRENT_NORMAL";
                case 0xb03:
                    return "GL_CURRENT_TEXTURE_COORDS";
                case 0xb04:
                    return "GL_CURRENT_RASTER_COLOR";
                case 0xb05:
                    return "GL_CURRENT_RASTER_INDEX";
                case 0xb06:
                    return "GL_CURRENT_RASTER_TEXTURE_COORDS";
                case 0xb07:
                    return "GL_CURRENT_RASTER_POSITION";
                case 0xb08:
                    return "GL_CURRENT_RASTER_POSITION_VALID";
                case 0xb09:
                    return "GL_CURRENT_RASTER_DISTANCE";
                case 0xb10:
                    return "GL_POINT_SMOOTH";
                case 0xb11:
                    return "GL_POINT_SIZE";
                case 0xb12:
                    return "GL_POINT_SIZE_RANGE";
                case 0xb13:
                    return "GL_POINT_SIZE_GRANULARITY";
                case 0xb20:
                    return "GL_LINE_SMOOTH";
                case 0xb21:
                    return "GL_LINE_WIDTH";
                case 0xb22:
                    return "GL_LINE_WIDTH_RANGE";
                case 0xb23:
                    return "GL_LINE_WIDTH_GRANULARITY";
                case 0xb24:
                    return "GL_LINE_STIPPLE";
                case 0xb25:
                    return "GL_LINE_STIPPLE_PATTERN";
                case 0xb26:
                    return "GL_LINE_STIPPLE_REPEAT";
                case 0xb30:
                    return "GL_LIST_MODE";
                case 0xb31:
                    return "GL_MAX_LIST_NESTING";
                case 0xb32:
                    return "GL_LIST_BASE";
                case 0xb33:
                    return "GL_LIST_INDEX";
                case 0xb40:
                    return "GL_POLYGON_MODE";
                case 0xb41:
                    return "GL_POLYGON_SMOOTH";
                case 0xb42:
                    return "GL_POLYGON_STIPPLE";
                case 0xb43:
                    return "GL_EDGE_FLAG";
                case 0xb44:
                    return "GL_CULL_FACE";
                case 0xb45:
                    return "GL_CULL_FACE_MODE";
                case 0xb46:
                    return "GL_FRONT_FACE";
                case 0xb50:
                    return "GL_LIGHTING";
                case 0xb51:
                    return "GL_LIGHT_MODEL_LOCAL_VIEWER";
                case 0xb52:
                    return "GL_LIGHT_MODEL_TWO_SIDE";
                case 0xb53:
                    return "GL_LIGHT_MODEL_AMBIENT";
                case 0xb54:
                    return "GL_SHADE_MODEL";
                case 0xb55:
                    return "GL_COLOR_MATERIAL_FACE";
                case 0xb56:
                    return "GL_COLOR_MATERIAL_PARAMETER";
                case 0xb57:
                    return "GL_COLOR_MATERIAL";
                case 0xb60:
                    return "GL_FOG";
                case 0xb61:
                    return "GL_FOG_INDEX";
                case 0xb62:
                    return "GL_FOG_DENSITY";
                case 0xb63:
                    return "GL_FOG_START";
                case 0xb64:
                    return "GL_FOG_END";
                case 0xb65:
                    return "GL_FOG_MODE";
                case 0xb66:
                    return "GL_FOG_COLOR";
                case 0xb70:
                    return "GL_DEPTH_RANGE";
                case 0xb71:
                    return "GL_DEPTH_TEST";
                case 0xb72:
                    return "GL_DEPTH_WRITEMASK";
                case 0xb73:
                    return "GL_DEPTH_CLEAR_VALUE";
                case 0xb74:
                    return "GL_DEPTH_FUNC";
                case 0xb80:
                    return "GL_ACCUM_CLEAR_VALUE";
                case 0xb90:
                    return "GL_STENCIL_TEST";
                case 0xb91:
                    return "GL_STENCIL_CLEAR_VALUE";
                case 0xb92:
                    return "GL_STENCIL_FUNC";
                case 0xb93:
                    return "GL_STENCIL_VALUE_MASK";
                case 0xb94:
                    return "GL_STENCIL_FAIL";
                case 0xb95:
                    return "GL_STENCIL_PASS_DEPTH_FAIL";
                case 0xb96:
                    return "GL_STENCIL_PASS_DEPTH_PASS";
                case 0xb97:
                    return "GL_STENCIL_REF";
                case 0xb98:
                    return "GL_STENCIL_WRITEMASK";
                case 0xba0:
                    return "GL_MATRIX_MODE";
                case 0xba1:
                    return "GL_NORMALIZE";
                case 0xba2:
                    return "GL_VIEWPORT";
                case 0xba3:
                    return "GL_MODELVIEW_STACK_DEPTH";
                case 0xba4:
                    return "GL_PROJECTION_STACK_DEPTH";
                case 0xba5:
                    return "GL_TEXTURE_STACK_DEPTH";
                case 0xba6:
                    return "GL_MODELVIEW_MATRIX";
                case 0xba7:
                    return "GL_PROJECTION_MATRIX";
                case 0xba8:
                    return "GL_TEXTURE_MATRIX";
                case 0xbb0:
                    return "GL_ATTRIB_STACK_DEPTH";
                case 0xbb1:
                    return "GL_CLIENT_ATTRIB_STACK_DEPTH";
                case 0xbc0:
                    return "GL_ALPHA_TEST";
                case 0xbc1:
                    return "GL_ALPHA_TEST_FUNC";
                case 0xbc2:
                    return "GL_ALPHA_TEST_REF";
                case 0xbd0:
                    return "GL_DITHER";
                case 0xbe0:
                    return "GL_BLEND_DST";
                case 0xbe1:
                    return "GL_BLEND_SRC";
                case 0xbe2:
                    return "GL_BLEND";
                case 0xbf0:
                    return "GL_LOGIC_OP_MODE";
                case 0xbf1:
                    return "GL_INDEX_LOGIC_OP";
                case 0xbf2:
                    return "GL_COLOR_LOGIC_OP";
                case 0xc00:
                    return "GL_AUX_BUFFERS";
                case 0xc01:
                    return "GL_DRAW_BUFFER";
                case 0xc02:
                    return "GL_READ_BUFFER";
                case 0xc10:
                    return "GL_SCISSOR_BOX";
                case 0xc11:
                    return "GL_SCISSOR_TEST";
                case 0xc20:
                    return "GL_INDEX_CLEAR_VALUE";
                case 0xc21:
                    return "GL_INDEX_WRITEMASK";
                case 0xc22:
                    return "GL_COLOR_CLEAR_VALUE";
                case 0xc23:
                    return "GL_COLOR_WRITEMASK";
                case 0xc30:
                    return "GL_INDEX_MODE";
                case 0xc31:
                    return "GL_RGBA_MODE";
                case 0xc32:
                    return "GL_DOUBLEBUFFER";
                case 0xc33:
                    return "GL_STEREO";
                case 0xc40:
                    return "GL_RENDER_MODE";
                case 0xc50:
                    return "GL_PERSPECTIVE_CORRECTION_HINT";
                case 0xc51:
                    return "GL_POINT_SMOOTH_HINT";
                case 0xc52:
                    return "GL_LINE_SMOOTH_HINT";
                case 0xc53:
                    return "GL_POLYGON_SMOOTH_HINT";
                case 0xc54:
                    return "GL_FOG_HINT";
                case 0xc60:
                    return "GL_TEXTURE_GEN_S";
                case 0xc61:
                    return "GL_TEXTURE_GEN_T";
                case 0xc62:
                    return "GL_TEXTURE_GEN_R";
                case 0xc63:
                    return "GL_TEXTURE_GEN_Q";
                case 0xcb0:
                    return "GL_PIXEL_MAP_I_TO_I_SIZE";
                case 0xcb1:
                    return "GL_PIXEL_MAP_S_TO_S_SIZE";
                case 0xcb2:
                    return "GL_PIXEL_MAP_I_TO_R_SIZE";
                case 0xcb3:
                    return "GL_PIXEL_MAP_I_TO_G_SIZE";
                case 0xcb4:
                    return "GL_PIXEL_MAP_I_TO_B_SIZE";
                case 0xcb5:
                    return "GL_PIXEL_MAP_I_TO_A_SIZE";
                case 0xcb6:
                    return "GL_PIXEL_MAP_R_TO_R_SIZE";
                case 0xcb7:
                    return "GL_PIXEL_MAP_G_TO_G_SIZE";
                case 0xcb8:
                    return "GL_PIXEL_MAP_B_TO_B_SIZE";
                case 0xcb9:
                    return "GL_PIXEL_MAP_A_TO_A_SIZE";
                case 0xcf0:
                    return "GL_UNPACK_SWAP_BYTES";
                case 0xcf1:
                    return "GL_UNPACK_LSB_FIRST";
                case 0xcf2:
                    return "GL_UNPACK_ROW_LENGTH";
                case 0xcf3:
                    return "GL_UNPACK_SKIP_ROWS";
                case 0xcf4:
                    return "GL_UNPACK_SKIP_PIXELS";
                case 0xcf5:
                    return "GL_UNPACK_ALIGNMENT";
                case 0xd00:
                    return "GL_PACK_SWAP_BYTES";
                case 0xd01:
                    return "GL_PACK_LSB_FIRST";
                case 0xd02:
                    return "GL_PACK_ROW_LENGTH";
                case 0xd03:
                    return "GL_PACK_SKIP_ROWS";
                case 0xd04:
                    return "GL_PACK_SKIP_PIXELS";
                case 0xd05:
                    return "GL_PACK_ALIGNMENT";
                case 0xd10:
                    return "GL_MAP_COLOR";
                case 0xd11:
                    return "GL_MAP_STENCIL";
                case 0xd12:
                    return "GL_INDEX_SHIFT";
                case 0xd13:
                    return "GL_INDEX_OFFSET";
                case 0xd14:
                    return "GL_RED_SCALE";
                case 0xd15:
                    return "GL_RED_BIAS";
                case 0xd16:
                    return "GL_ZOOM_X";
                case 0xd17:
                    return "GL_ZOOM_Y";
                case 0xd18:
                    return "GL_GREEN_SCALE";
                case 0xd19:
                    return "GL_GREEN_BIAS";
                case 0xd1a:
                    return "GL_BLUE_SCALE";
                case 0xd1b:
                    return "GL_BLUE_BIAS";
                case 0xd1c:
                    return "GL_ALPHA_SCALE";
                case 0xd1d:
                    return "GL_ALPHA_BIAS";
                case 0xd1e:
                    return "GL_DEPTH_SCALE";
                case 0xd1f:
                    return "GL_DEPTH_BIAS";
                case 0xd30:
                    return "GL_MAX_EVAL_ORDER";
                case 0xd31:
                    return "GL_MAX_LIGHTS";
                case 0xd32:
                    return "GL_MAX_CLIP_DISTANCES";
                case 0xd33:
                    return "GL_MAX_TEXTURE_SIZE";
                case 0xd34:
                    return "GL_MAX_PIXEL_MAP_TABLE";
                case 0xd35:
                    return "GL_MAX_ATTRIB_STACK_DEPTH";
                case 0xd36:
                    return "GL_MAX_MODELVIEW_STACK_DEPTH";
                case 0xd37:
                    return "GL_MAX_NAME_STACK_DEPTH";
                case 0xd38:
                    return "GL_MAX_PROJECTION_STACK_DEPTH";
                case 0xd39:
                    return "GL_MAX_TEXTURE_STACK_DEPTH";
                case 0xd3a:
                    return "GL_MAX_VIEWPORT_DIMS";
                case 0xd3b:
                    return "GL_MAX_CLIENT_ATTRIB_STACK_DEPTH";
                case 0xd50:
                    return "GL_SUBPIXEL_BITS";
                case 0xd51:
                    return "GL_INDEX_BITS";
                case 0xd52:
                    return "GL_RED_BITS";
                case 0xd53:
                    return "GL_GREEN_BITS";
                case 0xd54:
                    return "GL_BLUE_BITS";
                case 0xd55:
                    return "GL_ALPHA_BITS";
                case 0xd56:
                    return "GL_DEPTH_BITS";
                case 0xd57:
                    return "GL_STENCIL_BITS";
                case 0xd58:
                    return "GL_ACCUM_RED_BITS";
                case 0xd59:
                    return "GL_ACCUM_GREEN_BITS";
                case 0xd5a:
                    return "GL_ACCUM_BLUE_BITS";
                case 0xd5b:
                    return "GL_ACCUM_ALPHA_BITS";
                case 0xd70:
                    return "GL_NAME_STACK_DEPTH";
                case 0xd80:
                    return "GL_AUTO_NORMAL";
                case 0xd90:
                    return "GL_MAP1_COLOR_4";
                case 0xd91:
                    return "GL_MAP1_INDEX";
                case 0xd92:
                    return "GL_MAP1_NORMAL";
                case 0xd93:
                    return "GL_MAP1_TEXTURE_COORD_1";
                case 0xd94:
                    return "GL_MAP1_TEXTURE_COORD_2";
                case 0xd95:
                    return "GL_MAP1_TEXTURE_COORD_3";
                case 0xd96:
                    return "GL_MAP1_TEXTURE_COORD_4";
                case 0xd97:
                    return "GL_MAP1_VERTEX_3";
                case 0xd98:
                    return "GL_MAP1_VERTEX_4";
                case 0xdb0:
                    return "GL_MAP2_COLOR_4";
                case 0xdb1:
                    return "GL_MAP2_INDEX";
                case 0xdb2:
                    return "GL_MAP2_NORMAL";
                case 0xdb3:
                    return "GL_MAP2_TEXTURE_COORD_1";
                case 0xdb4:
                    return "GL_MAP2_TEXTURE_COORD_2";
                case 0xdb5:
                    return "GL_MAP2_TEXTURE_COORD_3";
                case 0xdb6:
                    return "GL_MAP2_TEXTURE_COORD_4";
                case 0xdb7:
                    return "GL_MAP2_VERTEX_3";
                case 0xdb8:
                    return "GL_MAP2_VERTEX_4";
                case 0xdd0:
                    return "GL_MAP1_GRID_DOMAIN";
                case 0xdd1:
                    return "GL_MAP1_GRID_SEGMENTS";
                case 0xdd2:
                    return "GL_MAP2_GRID_DOMAIN";
                case 0xdd3:
                    return "GL_MAP2_GRID_SEGMENTS";
                case 0xde0:
                    return "GL_TEXTURE_1D";
                case 0xde1:
                    return "GL_TEXTURE_2D";
                case 0xdf1:
                    return "GL_FEEDBACK_BUFFER_SIZE";
                case 0xdf2:
                    return "GL_FEEDBACK_BUFFER_TYPE";
                case 0xdf4:
                    return "GL_SELECTION_BUFFER_SIZE";
                case 0x2a00:
                    return "GL_POLYGON_OFFSET_UNITS";
                case 0x2a01:
                    return "GL_POLYGON_OFFSET_POINT";
                case 0x2a02:
                    return "GL_POLYGON_OFFSET_LINE";
                case 0x3000:
                    return "GL_CLIP_PLANE0";
                case 0x3001:
                    return "GL_CLIP_PLANE1";
                case 0x3002:
                    return "GL_CLIP_PLANE2";
                case 0x3003:
                    return "GL_CLIP_PLANE3";
                case 0x3004:
                    return "GL_CLIP_PLANE4";
                case 0x3005:
                    return "GL_CLIP_PLANE5";
                case 0x4000:
                    return "GL_LIGHT0";
                case 0x4001:
                    return "GL_LIGHT1";
                case 0x4002:
                    return "GL_LIGHT2";
                case 0x4003:
                    return "GL_LIGHT3";
                case 0x4004:
                    return "GL_LIGHT4";
                case 0x4005:
                    return "GL_LIGHT5";
                case 0x4006:
                    return "GL_LIGHT6";
                case 0x4007:
                    return "GL_LIGHT7";
                case 0x8037:
                    return "GL_POLYGON_OFFSET_FILL";
                case 0x8038:
                    return "GL_POLYGON_OFFSET_FACTOR";
                case 0x8068:
                    return "GL_TEXTURE_BINDING_1D";
                case 0x8069:
                    return "GL_TEXTURE_BINDING_2D";
                case 0x806a:
                    return "GL_TEXTURE_BINDING_3D";
                case 0x8074:
                    return "GL_VERTEX_ARRAY";
                case 0x8075:
                    return "GL_NORMAL_ARRAY";
                case 0x8076:
                    return "GL_COLOR_ARRAY";
                case 0x8077:
                    return "GL_INDEX_ARRAY";
                case 0x8078:
                    return "GL_TEXTURE_COORD_ARRAY";
                case 0x8079:
                    return "GL_EDGE_FLAG_ARRAY";
                case 0x807a:
                    return "GL_VERTEX_ARRAY_SIZE";
                case 0x807b:
                    return "GL_VERTEX_ARRAY_TYPE";
                case 0x807c:
                    return "GL_VERTEX_ARRAY_STRIDE";
                case 0x807e:
                    return "GL_NORMAL_ARRAY_TYPE";
                case 0x807f:
                    return "GL_NORMAL_ARRAY_STRIDE";
                case 0x8081:
                    return "GL_COLOR_ARRAY_SIZE";
                case 0x8082:
                    return "GL_COLOR_ARRAY_TYPE";
                case 0x8083:
                    return "GL_COLOR_ARRAY_STRIDE";
                case 0x8085:
                    return "GL_INDEX_ARRAY_TYPE";
                case 0x8086:
                    return "GL_INDEX_ARRAY_STRIDE";
                case 0x8088:
                    return "GL_TEXTURE_COORD_ARRAY_SIZE";
                case 0x8089:
                    return "GL_TEXTURE_COORD_ARRAY_TYPE";
                case 0x808a:
                    return "GL_TEXTURE_COORD_ARRAY_STRIDE";
                case 0x808c:
                    return "GL_EDGE_FLAG_ARRAY_STRIDE";
                case 0x81f8:
                    return "GL_LIGHT_MODEL_COLOR_CONTROL";
                case 0x846d:
                    return "GL_ALIASED_POINT_SIZE_RANGE";
                case 0x846e:
                    return "GL_ALIASED_LINE_WIDTH_RANGE";
                case 0x9596:
                    return "GL_NUM_DEVICE_UUIDS_EXT";
                case 0x9597:
                    return "GL_DEVICE_UUID_EXT";
                case 0x9598:
                    return "GL_DRIVER_UUID_EXT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::GetPixelMap:
        {
            switch (value)
            {
                case 0xc70:
                    return "GL_PIXEL_MAP_I_TO_I";
                case 0xc71:
                    return "GL_PIXEL_MAP_S_TO_S";
                case 0xc72:
                    return "GL_PIXEL_MAP_I_TO_R";
                case 0xc73:
                    return "GL_PIXEL_MAP_I_TO_G";
                case 0xc74:
                    return "GL_PIXEL_MAP_I_TO_B";
                case 0xc75:
                    return "GL_PIXEL_MAP_I_TO_A";
                case 0xc76:
                    return "GL_PIXEL_MAP_R_TO_R";
                case 0xc77:
                    return "GL_PIXEL_MAP_G_TO_G";
                case 0xc78:
                    return "GL_PIXEL_MAP_B_TO_B";
                case 0xc79:
                    return "GL_PIXEL_MAP_A_TO_A";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::GetPointervPName:
        {
            switch (value)
            {
                case 0xdf0:
                    return "GL_FEEDBACK_BUFFER_POINTER";
                case 0xdf3:
                    return "GL_SELECTION_BUFFER_POINTER";
                case 0x808e:
                    return "GL_VERTEX_ARRAY_POINTER";
                case 0x808f:
                    return "GL_NORMAL_ARRAY_POINTER";
                case 0x8090:
                    return "GL_COLOR_ARRAY_POINTER";
                case 0x8091:
                    return "GL_INDEX_ARRAY_POINTER";
                case 0x8092:
                    return "GL_TEXTURE_COORD_ARRAY_POINTER";
                case 0x8093:
                    return "GL_EDGE_FLAG_ARRAY_POINTER";
                case 0x8244:
                    return "GL_DEBUG_CALLBACK_FUNCTION";
                case 0x8245:
                    return "GL_DEBUG_CALLBACK_USER_PARAM";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::GetTextureParameter:
        {
            switch (value)
            {
                case 0x1000:
                    return "GL_TEXTURE_WIDTH";
                case 0x1001:
                    return "GL_TEXTURE_HEIGHT";
                case 0x1003:
                    return "GL_TEXTURE_COMPONENTS";
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR";
                case 0x1005:
                    return "GL_TEXTURE_BORDER";
                case 0x2800:
                    return "GL_TEXTURE_MAG_FILTER";
                case 0x2801:
                    return "GL_TEXTURE_MIN_FILTER";
                case 0x2802:
                    return "GL_TEXTURE_WRAP_S";
                case 0x2803:
                    return "GL_TEXTURE_WRAP_T";
                case 0x805c:
                    return "GL_TEXTURE_RED_SIZE";
                case 0x805d:
                    return "GL_TEXTURE_GREEN_SIZE";
                case 0x805e:
                    return "GL_TEXTURE_BLUE_SIZE";
                case 0x805f:
                    return "GL_TEXTURE_ALPHA_SIZE";
                case 0x8060:
                    return "GL_TEXTURE_LUMINANCE_SIZE";
                case 0x8061:
                    return "GL_TEXTURE_INTENSITY_SIZE";
                case 0x8066:
                    return "GL_TEXTURE_PRIORITY";
                case 0x8067:
                    return "GL_TEXTURE_RESIDENT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::GraphicsResetStatus:
        {
            switch (value)
            {
                case 0x8253:
                    return "GL_GUILTY_CONTEXT_RESET";
                case 0x8254:
                    return "GL_INNOCENT_CONTEXT_RESET";
                case 0x8255:
                    return "GL_UNKNOWN_CONTEXT_RESET";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::HintMode:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x1101:
                    return "GL_FASTEST";
                case 0x1102:
                    return "GL_NICEST";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::HintTarget:
        {
            switch (value)
            {
                case 0xc50:
                    return "GL_PERSPECTIVE_CORRECTION_HINT";
                case 0xc51:
                    return "GL_POINT_SMOOTH_HINT";
                case 0xc52:
                    return "GL_LINE_SMOOTH_HINT";
                case 0xc53:
                    return "GL_POLYGON_SMOOTH_HINT";
                case 0xc54:
                    return "GL_FOG_HINT";
                case 0x8192:
                    return "GL_GENERATE_MIPMAP_HINT";
                case 0x8257:
                    return "GL_PROGRAM_BINARY_RETRIEVABLE_HINT";
                case 0x84ef:
                    return "GL_TEXTURE_COMPRESSION_HINT";
                case 0x8b8b:
                    return "GL_FRAGMENT_SHADER_DERIVATIVE_HINT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::IndexPointerType:
        {
            switch (value)
            {
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140a:
                    return "GL_DOUBLE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::InterleavedArrayFormat:
        {
            switch (value)
            {
                case 0x2a20:
                    return "GL_V2F";
                case 0x2a21:
                    return "GL_V3F";
                case 0x2a22:
                    return "GL_C4UB_V2F";
                case 0x2a23:
                    return "GL_C4UB_V3F";
                case 0x2a24:
                    return "GL_C3F_V3F";
                case 0x2a25:
                    return "GL_N3F_V3F";
                case 0x2a26:
                    return "GL_C4F_N3F_V3F";
                case 0x2a27:
                    return "GL_T2F_V3F";
                case 0x2a28:
                    return "GL_T4F_V4F";
                case 0x2a29:
                    return "GL_T2F_C4UB_V3F";
                case 0x2a2a:
                    return "GL_T2F_C3F_V3F";
                case 0x2a2b:
                    return "GL_T2F_N3F_V3F";
                case 0x2a2c:
                    return "GL_T2F_C4F_N3F_V3F";
                case 0x2a2d:
                    return "GL_T4F_C4F_N3F_V4F";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::InternalFormat:
        {
            switch (value)
            {
                case 0x1902:
                    return "GL_DEPTH_COMPONENT";
                case 0x1903:
                    return "GL_RED";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                case 0x2a10:
                    return "GL_R3_G3_B2";
                case 0x803b:
                    return "GL_ALPHA4";
                case 0x803c:
                    return "GL_ALPHA8";
                case 0x803d:
                    return "GL_ALPHA12";
                case 0x803e:
                    return "GL_ALPHA16";
                case 0x803f:
                    return "GL_LUMINANCE4";
                case 0x8040:
                    return "GL_LUMINANCE8";
                case 0x8041:
                    return "GL_LUMINANCE12";
                case 0x8042:
                    return "GL_LUMINANCE16";
                case 0x8043:
                    return "GL_LUMINANCE4_ALPHA4";
                case 0x8044:
                    return "GL_LUMINANCE6_ALPHA2";
                case 0x8045:
                    return "GL_LUMINANCE8_ALPHA8";
                case 0x8046:
                    return "GL_LUMINANCE12_ALPHA4";
                case 0x8047:
                    return "GL_LUMINANCE12_ALPHA12";
                case 0x8048:
                    return "GL_LUMINANCE16_ALPHA16";
                case 0x8049:
                    return "GL_INTENSITY";
                case 0x804a:
                    return "GL_INTENSITY4";
                case 0x804b:
                    return "GL_INTENSITY8";
                case 0x804c:
                    return "GL_INTENSITY12";
                case 0x804d:
                    return "GL_INTENSITY16";
                case 0x804f:
                    return "GL_RGB4";
                case 0x8050:
                    return "GL_RGB5";
                case 0x8051:
                    return "GL_RGB8";
                case 0x8052:
                    return "GL_RGB10";
                case 0x8053:
                    return "GL_RGB12";
                case 0x8054:
                    return "GL_RGB16";
                case 0x8056:
                    return "GL_RGBA4";
                case 0x8057:
                    return "GL_RGB5_A1";
                case 0x8058:
                    return "GL_RGBA8";
                case 0x8059:
                    return "GL_RGB10_A2";
                case 0x805a:
                    return "GL_RGBA12";
                case 0x805b:
                    return "GL_RGBA16";
                case 0x81a5:
                    return "GL_DEPTH_COMPONENT16";
                case 0x8225:
                    return "GL_COMPRESSED_RED";
                case 0x8226:
                    return "GL_COMPRESSED_RG";
                case 0x8227:
                    return "GL_RG";
                case 0x8229:
                    return "GL_R8";
                case 0x822a:
                    return "GL_R16";
                case 0x822b:
                    return "GL_RG8";
                case 0x822c:
                    return "GL_RG16";
                case 0x822d:
                    return "GL_R16F";
                case 0x822e:
                    return "GL_R32F";
                case 0x822f:
                    return "GL_RG16F";
                case 0x8230:
                    return "GL_RG32F";
                case 0x8231:
                    return "GL_R8I";
                case 0x8232:
                    return "GL_R8UI";
                case 0x8233:
                    return "GL_R16I";
                case 0x8234:
                    return "GL_R16UI";
                case 0x8235:
                    return "GL_R32I";
                case 0x8236:
                    return "GL_R32UI";
                case 0x8237:
                    return "GL_RG8I";
                case 0x8238:
                    return "GL_RG8UI";
                case 0x8239:
                    return "GL_RG16I";
                case 0x823a:
                    return "GL_RG16UI";
                case 0x823b:
                    return "GL_RG32I";
                case 0x823c:
                    return "GL_RG32UI";
                case 0x84ed:
                    return "GL_COMPRESSED_RGB";
                case 0x84ee:
                    return "GL_COMPRESSED_RGBA";
                case 0x84f9:
                    return "GL_DEPTH_STENCIL";
                case 0x8814:
                    return "GL_RGBA32F";
                case 0x881a:
                    return "GL_RGBA16F";
                case 0x881b:
                    return "GL_RGB16F";
                case 0x88f0:
                    return "GL_DEPTH24_STENCIL8";
                case 0x8c3a:
                    return "GL_R11F_G11F_B10F";
                case 0x8c3d:
                    return "GL_RGB9_E5";
                case 0x8c40:
                    return "GL_SRGB";
                case 0x8c41:
                    return "GL_SRGB8";
                case 0x8c42:
                    return "GL_SRGB_ALPHA";
                case 0x8c43:
                    return "GL_SRGB8_ALPHA8";
                case 0x8c48:
                    return "GL_COMPRESSED_SRGB";
                case 0x8c49:
                    return "GL_COMPRESSED_SRGB_ALPHA";
                case 0x8cac:
                    return "GL_DEPTH_COMPONENT32F";
                case 0x8cad:
                    return "GL_DEPTH32F_STENCIL8";
                case 0x8d70:
                    return "GL_RGBA32UI";
                case 0x8d71:
                    return "GL_RGB32UI";
                case 0x8d76:
                    return "GL_RGBA16UI";
                case 0x8d77:
                    return "GL_RGB16UI";
                case 0x8d7c:
                    return "GL_RGBA8UI";
                case 0x8d7d:
                    return "GL_RGB8UI";
                case 0x8d82:
                    return "GL_RGBA32I";
                case 0x8d83:
                    return "GL_RGB32I";
                case 0x8d88:
                    return "GL_RGBA16I";
                case 0x8d89:
                    return "GL_RGB16I";
                case 0x8d8e:
                    return "GL_RGBA8I";
                case 0x8d8f:
                    return "GL_RGB8I";
                case 0x8dbb:
                    return "GL_COMPRESSED_RED_RGTC1";
                case 0x8dbc:
                    return "GL_COMPRESSED_SIGNED_RED_RGTC1";
                case 0x8dbd:
                    return "GL_COMPRESSED_RG_RGTC2";
                case 0x8dbe:
                    return "GL_COMPRESSED_SIGNED_RG_RGTC2";
                case 0x8e8c:
                    return "GL_COMPRESSED_RGBA_BPTC_UNORM";
                case 0x8e8d:
                    return "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM";
                case 0x8e8e:
                    return "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT";
                case 0x8e8f:
                    return "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT";
                case 0x8f94:
                    return "GL_R8_SNORM";
                case 0x8f95:
                    return "GL_RG8_SNORM";
                case 0x8f96:
                    return "GL_RGB8_SNORM";
                case 0x8f97:
                    return "GL_RGBA8_SNORM";
                case 0x8f98:
                    return "GL_R16_SNORM";
                case 0x8f99:
                    return "GL_RG16_SNORM";
                case 0x8f9a:
                    return "GL_RGB16_SNORM";
                case 0x906f:
                    return "GL_RGB10_A2UI";
                case 0x9270:
                    return "GL_COMPRESSED_R11_EAC";
                case 0x9271:
                    return "GL_COMPRESSED_SIGNED_R11_EAC";
                case 0x9272:
                    return "GL_COMPRESSED_RG11_EAC";
                case 0x9273:
                    return "GL_COMPRESSED_SIGNED_RG11_EAC";
                case 0x9274:
                    return "GL_COMPRESSED_RGB8_ETC2";
                case 0x9275:
                    return "GL_COMPRESSED_SRGB8_ETC2";
                case 0x9276:
                    return "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9277:
                    return "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9278:
                    return "GL_COMPRESSED_RGBA8_ETC2_EAC";
                case 0x9279:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::InternalFormatPName:
        {
            switch (value)
            {
                case 0x80a9:
                    return "GL_SAMPLES";
                case 0x8191:
                    return "GL_GENERATE_MIPMAP";
                case 0x826f:
                    return "GL_INTERNALFORMAT_SUPPORTED";
                case 0x8270:
                    return "GL_INTERNALFORMAT_PREFERRED";
                case 0x8271:
                    return "GL_INTERNALFORMAT_RED_SIZE";
                case 0x8272:
                    return "GL_INTERNALFORMAT_GREEN_SIZE";
                case 0x8273:
                    return "GL_INTERNALFORMAT_BLUE_SIZE";
                case 0x8274:
                    return "GL_INTERNALFORMAT_ALPHA_SIZE";
                case 0x8275:
                    return "GL_INTERNALFORMAT_DEPTH_SIZE";
                case 0x8276:
                    return "GL_INTERNALFORMAT_STENCIL_SIZE";
                case 0x8277:
                    return "GL_INTERNALFORMAT_SHARED_SIZE";
                case 0x8278:
                    return "GL_INTERNALFORMAT_RED_TYPE";
                case 0x8279:
                    return "GL_INTERNALFORMAT_GREEN_TYPE";
                case 0x827a:
                    return "GL_INTERNALFORMAT_BLUE_TYPE";
                case 0x827b:
                    return "GL_INTERNALFORMAT_ALPHA_TYPE";
                case 0x827c:
                    return "GL_INTERNALFORMAT_DEPTH_TYPE";
                case 0x827d:
                    return "GL_INTERNALFORMAT_STENCIL_TYPE";
                case 0x827e:
                    return "GL_MAX_WIDTH";
                case 0x827f:
                    return "GL_MAX_HEIGHT";
                case 0x8280:
                    return "GL_MAX_DEPTH";
                case 0x8281:
                    return "GL_MAX_LAYERS";
                case 0x8283:
                    return "GL_COLOR_COMPONENTS";
                case 0x8286:
                    return "GL_COLOR_RENDERABLE";
                case 0x8287:
                    return "GL_DEPTH_RENDERABLE";
                case 0x8288:
                    return "GL_STENCIL_RENDERABLE";
                case 0x8289:
                    return "GL_FRAMEBUFFER_RENDERABLE";
                case 0x828a:
                    return "GL_FRAMEBUFFER_RENDERABLE_LAYERED";
                case 0x828b:
                    return "GL_FRAMEBUFFER_BLEND";
                case 0x828c:
                    return "GL_READ_PIXELS";
                case 0x828d:
                    return "GL_READ_PIXELS_FORMAT";
                case 0x828e:
                    return "GL_READ_PIXELS_TYPE";
                case 0x828f:
                    return "GL_TEXTURE_IMAGE_FORMAT";
                case 0x8290:
                    return "GL_TEXTURE_IMAGE_TYPE";
                case 0x8291:
                    return "GL_GET_TEXTURE_IMAGE_FORMAT";
                case 0x8292:
                    return "GL_GET_TEXTURE_IMAGE_TYPE";
                case 0x8293:
                    return "GL_MIPMAP";
                case 0x8295:
                    return "GL_AUTO_GENERATE_MIPMAP";
                case 0x8296:
                    return "GL_COLOR_ENCODING";
                case 0x8297:
                    return "GL_SRGB_READ";
                case 0x8298:
                    return "GL_SRGB_WRITE";
                case 0x829a:
                    return "GL_FILTER";
                case 0x829b:
                    return "GL_VERTEX_TEXTURE";
                case 0x829c:
                    return "GL_TESS_CONTROL_TEXTURE";
                case 0x829d:
                    return "GL_TESS_EVALUATION_TEXTURE";
                case 0x829e:
                    return "GL_GEOMETRY_TEXTURE";
                case 0x829f:
                    return "GL_FRAGMENT_TEXTURE";
                case 0x82a0:
                    return "GL_COMPUTE_TEXTURE";
                case 0x82a1:
                    return "GL_TEXTURE_SHADOW";
                case 0x82a2:
                    return "GL_TEXTURE_GATHER";
                case 0x82a3:
                    return "GL_TEXTURE_GATHER_SHADOW";
                case 0x82a4:
                    return "GL_SHADER_IMAGE_LOAD";
                case 0x82a5:
                    return "GL_SHADER_IMAGE_STORE";
                case 0x82a6:
                    return "GL_SHADER_IMAGE_ATOMIC";
                case 0x82a7:
                    return "GL_IMAGE_TEXEL_SIZE";
                case 0x82a8:
                    return "GL_IMAGE_COMPATIBILITY_CLASS";
                case 0x82a9:
                    return "GL_IMAGE_PIXEL_FORMAT";
                case 0x82aa:
                    return "GL_IMAGE_PIXEL_TYPE";
                case 0x82ac:
                    return "GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST";
                case 0x82ad:
                    return "GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST";
                case 0x82ae:
                    return "GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE";
                case 0x82af:
                    return "GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE";
                case 0x82b1:
                    return "GL_TEXTURE_COMPRESSED_BLOCK_WIDTH";
                case 0x82b2:
                    return "GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT";
                case 0x82b3:
                    return "GL_TEXTURE_COMPRESSED_BLOCK_SIZE";
                case 0x82b4:
                    return "GL_CLEAR_BUFFER";
                case 0x82b5:
                    return "GL_TEXTURE_VIEW";
                case 0x82b6:
                    return "GL_VIEW_COMPATIBILITY_CLASS";
                case 0x86a1:
                    return "GL_TEXTURE_COMPRESSED";
                case 0x90c7:
                    return "GL_IMAGE_FORMAT_COMPATIBILITY_TYPE";
                case 0x9365:
                    return "GL_CLEAR_TEXTURE";
                case 0x9380:
                    return "GL_NUM_SAMPLE_COUNTS";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::LightEnvModeSGIX:
        {
            switch (value)
            {
                case 0x104:
                    return "GL_ADD";
                case 0x1e01:
                    return "GL_REPLACE";
                case 0x2100:
                    return "GL_MODULATE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::LightModelColorControl:
        {
            switch (value)
            {
                case 0x81f9:
                    return "GL_SINGLE_COLOR";
                case 0x81fa:
                    return "GL_SEPARATE_SPECULAR_COLOR";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::LightModelParameter:
        {
            switch (value)
            {
                case 0xb51:
                    return "GL_LIGHT_MODEL_LOCAL_VIEWER";
                case 0xb52:
                    return "GL_LIGHT_MODEL_TWO_SIDE";
                case 0xb53:
                    return "GL_LIGHT_MODEL_AMBIENT";
                case 0x81f8:
                    return "GL_LIGHT_MODEL_COLOR_CONTROL";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::LightName:
        {
            switch (value)
            {
                case 0x4000:
                    return "GL_LIGHT0";
                case 0x4001:
                    return "GL_LIGHT1";
                case 0x4002:
                    return "GL_LIGHT2";
                case 0x4003:
                    return "GL_LIGHT3";
                case 0x4004:
                    return "GL_LIGHT4";
                case 0x4005:
                    return "GL_LIGHT5";
                case 0x4006:
                    return "GL_LIGHT6";
                case 0x4007:
                    return "GL_LIGHT7";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::LightParameter:
        {
            switch (value)
            {
                case 0x1200:
                    return "GL_AMBIENT";
                case 0x1201:
                    return "GL_DIFFUSE";
                case 0x1202:
                    return "GL_SPECULAR";
                case 0x1203:
                    return "GL_POSITION";
                case 0x1204:
                    return "GL_SPOT_DIRECTION";
                case 0x1205:
                    return "GL_SPOT_EXPONENT";
                case 0x1206:
                    return "GL_SPOT_CUTOFF";
                case 0x1207:
                    return "GL_CONSTANT_ATTENUATION";
                case 0x1208:
                    return "GL_LINEAR_ATTENUATION";
                case 0x1209:
                    return "GL_QUADRATIC_ATTENUATION";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ListMode:
        {
            switch (value)
            {
                case 0x1300:
                    return "GL_COMPILE";
                case 0x1301:
                    return "GL_COMPILE_AND_EXECUTE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ListNameType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x1407:
                    return "GL_2_BYTES";
                case 0x1408:
                    return "GL_3_BYTES";
                case 0x1409:
                    return "GL_4_BYTES";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::LogicOp:
        {
            switch (value)
            {
                case 0x1500:
                    return "GL_CLEAR";
                case 0x1501:
                    return "GL_AND";
                case 0x1502:
                    return "GL_AND_REVERSE";
                case 0x1503:
                    return "GL_COPY";
                case 0x1504:
                    return "GL_AND_INVERTED";
                case 0x1505:
                    return "GL_NOOP";
                case 0x1506:
                    return "GL_XOR";
                case 0x1507:
                    return "GL_OR";
                case 0x1508:
                    return "GL_NOR";
                case 0x1509:
                    return "GL_EQUIV";
                case 0x150a:
                    return "GL_INVERT";
                case 0x150b:
                    return "GL_OR_REVERSE";
                case 0x150c:
                    return "GL_COPY_INVERTED";
                case 0x150d:
                    return "GL_OR_INVERTED";
                case 0x150e:
                    return "GL_NAND";
                case 0x150f:
                    return "GL_SET";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::MapBufferUsageMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_MAP_READ_BIT";
                case 0x2:
                    return "GL_MAP_WRITE_BIT";
                case 0x4:
                    return "GL_MAP_INVALIDATE_RANGE_BIT";
                case 0x8:
                    return "GL_MAP_INVALIDATE_BUFFER_BIT";
                case 0x10:
                    return "GL_MAP_FLUSH_EXPLICIT_BIT";
                case 0x20:
                    return "GL_MAP_UNSYNCHRONIZED_BIT";
                case 0x40:
                    return "GL_MAP_PERSISTENT_BIT";
                case 0x80:
                    return "GL_MAP_COHERENT_BIT";
                case 0x100:
                    return "GL_DYNAMIC_STORAGE_BIT";
                case 0x200:
                    return "GL_CLIENT_STORAGE_BIT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::MapQuery:
        {
            switch (value)
            {
                case 0xa00:
                    return "GL_COEFF";
                case 0xa01:
                    return "GL_ORDER";
                case 0xa02:
                    return "GL_DOMAIN";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::MapTarget:
        {
            switch (value)
            {
                case 0xd90:
                    return "GL_MAP1_COLOR_4";
                case 0xd91:
                    return "GL_MAP1_INDEX";
                case 0xd92:
                    return "GL_MAP1_NORMAL";
                case 0xd93:
                    return "GL_MAP1_TEXTURE_COORD_1";
                case 0xd94:
                    return "GL_MAP1_TEXTURE_COORD_2";
                case 0xd95:
                    return "GL_MAP1_TEXTURE_COORD_3";
                case 0xd96:
                    return "GL_MAP1_TEXTURE_COORD_4";
                case 0xd97:
                    return "GL_MAP1_VERTEX_3";
                case 0xd98:
                    return "GL_MAP1_VERTEX_4";
                case 0xdb0:
                    return "GL_MAP2_COLOR_4";
                case 0xdb1:
                    return "GL_MAP2_INDEX";
                case 0xdb2:
                    return "GL_MAP2_NORMAL";
                case 0xdb3:
                    return "GL_MAP2_TEXTURE_COORD_1";
                case 0xdb4:
                    return "GL_MAP2_TEXTURE_COORD_2";
                case 0xdb5:
                    return "GL_MAP2_TEXTURE_COORD_3";
                case 0xdb6:
                    return "GL_MAP2_TEXTURE_COORD_4";
                case 0xdb7:
                    return "GL_MAP2_VERTEX_3";
                case 0xdb8:
                    return "GL_MAP2_VERTEX_4";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::MaterialFace:
        {
            switch (value)
            {
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::MaterialParameter:
        {
            switch (value)
            {
                case 0x1200:
                    return "GL_AMBIENT";
                case 0x1201:
                    return "GL_DIFFUSE";
                case 0x1202:
                    return "GL_SPECULAR";
                case 0x1600:
                    return "GL_EMISSION";
                case 0x1601:
                    return "GL_SHININESS";
                case 0x1602:
                    return "GL_AMBIENT_AND_DIFFUSE";
                case 0x1603:
                    return "GL_COLOR_INDEXES";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::MatrixMode:
        {
            switch (value)
            {
                case 0x1700:
                    return "GL_MODELVIEW";
                case 0x1701:
                    return "GL_PROJECTION";
                case 0x1702:
                    return "GL_TEXTURE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::MemoryBarrierMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT";
                case 0x2:
                    return "GL_ELEMENT_ARRAY_BARRIER_BIT";
                case 0x4:
                    return "GL_UNIFORM_BARRIER_BIT";
                case 0x8:
                    return "GL_TEXTURE_FETCH_BARRIER_BIT";
                case 0x20:
                    return "GL_SHADER_IMAGE_ACCESS_BARRIER_BIT";
                case 0x40:
                    return "GL_COMMAND_BARRIER_BIT";
                case 0x80:
                    return "GL_PIXEL_BUFFER_BARRIER_BIT";
                case 0x100:
                    return "GL_TEXTURE_UPDATE_BARRIER_BIT";
                case 0x200:
                    return "GL_BUFFER_UPDATE_BARRIER_BIT";
                case 0x400:
                    return "GL_FRAMEBUFFER_BARRIER_BIT";
                case 0x800:
                    return "GL_TRANSFORM_FEEDBACK_BARRIER_BIT";
                case 0x1000:
                    return "GL_ATOMIC_COUNTER_BARRIER_BIT";
                case 0x2000:
                    return "GL_SHADER_STORAGE_BARRIER_BIT";
                case 0x4000:
                    return "GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT";
                case 0x8000:
                    return "GL_QUERY_BUFFER_BARRIER_BIT";
                case 0xffffffff:
                    return "GL_ALL_BARRIER_BITS";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::MemoryObjectParameterName:
        {
            switch (value)
            {
                case 0x9581:
                    return "GL_DEDICATED_MEMORY_OBJECT_EXT";
                case 0x959b:
                    return "GL_PROTECTED_MEMORY_OBJECT_EXT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::MeshMode1:
        {
            switch (value)
            {
                case 0x1b00:
                    return "GL_POINT";
                case 0x1b01:
                    return "GL_LINE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::MeshMode2:
        {
            switch (value)
            {
                case 0x1b00:
                    return "GL_POINT";
                case 0x1b01:
                    return "GL_LINE";
                case 0x1b02:
                    return "GL_FILL";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::NormalPointerType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140a:
                    return "GL_DOUBLE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ObjectIdentifier:
        {
            switch (value)
            {
                case 0x1702:
                    return "GL_TEXTURE";
                case 0x8074:
                    return "GL_VERTEX_ARRAY";
                case 0x82e0:
                    return "GL_BUFFER";
                case 0x82e1:
                    return "GL_SHADER";
                case 0x82e2:
                    return "GL_PROGRAM";
                case 0x82e3:
                    return "GL_QUERY";
                case 0x82e4:
                    return "GL_PROGRAM_PIPELINE";
                case 0x82e6:
                    return "GL_SAMPLER";
                case 0x8d40:
                    return "GL_FRAMEBUFFER";
                case 0x8d41:
                    return "GL_RENDERBUFFER";
                case 0x8e22:
                    return "GL_TRANSFORM_FEEDBACK";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PatchParameterName:
        {
            switch (value)
            {
                case 0x8e72:
                    return "GL_PATCH_VERTICES";
                case 0x8e73:
                    return "GL_PATCH_DEFAULT_INNER_LEVEL";
                case 0x8e74:
                    return "GL_PATCH_DEFAULT_OUTER_LEVEL";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PathColor:
        {
            switch (value)
            {
                case 0x8577:
                    return "GL_PRIMARY_COLOR";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PathFillMode:
        {
            switch (value)
            {
                case 0x150a:
                    return "GL_INVERT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PathFontStyle:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PathGenMode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x2400:
                    return "GL_EYE_LINEAR";
                case 0x2401:
                    return "GL_OBJECT_LINEAR";
                case 0x8576:
                    return "GL_CONSTANT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PathTransformType:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PipelineParameterName:
        {
            switch (value)
            {
                case 0x8259:
                    return "GL_ACTIVE_PROGRAM";
                case 0x8b30:
                    return "GL_FRAGMENT_SHADER";
                case 0x8b31:
                    return "GL_VERTEX_SHADER";
                case 0x8b84:
                    return "GL_INFO_LOG_LENGTH";
                case 0x8dd9:
                    return "GL_GEOMETRY_SHADER";
                case 0x8e87:
                    return "GL_TESS_EVALUATION_SHADER";
                case 0x8e88:
                    return "GL_TESS_CONTROL_SHADER";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PixelCopyType:
        {
            switch (value)
            {
                case 0x1800:
                    return "GL_COLOR";
                case 0x1801:
                    return "GL_DEPTH";
                case 0x1802:
                    return "GL_STENCIL";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PixelFormat:
        {
            switch (value)
            {
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1900:
                    return "GL_COLOR_INDEX";
                case 0x1901:
                    return "GL_STENCIL_INDEX";
                case 0x1902:
                    return "GL_DEPTH_COMPONENT";
                case 0x1903:
                    return "GL_RED";
                case 0x1904:
                    return "GL_GREEN";
                case 0x1905:
                    return "GL_BLUE";
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                case 0x1909:
                    return "GL_LUMINANCE";
                case 0x190a:
                    return "GL_LUMINANCE_ALPHA";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PixelMap:
        {
            switch (value)
            {
                case 0xc70:
                    return "GL_PIXEL_MAP_I_TO_I";
                case 0xc71:
                    return "GL_PIXEL_MAP_S_TO_S";
                case 0xc72:
                    return "GL_PIXEL_MAP_I_TO_R";
                case 0xc73:
                    return "GL_PIXEL_MAP_I_TO_G";
                case 0xc74:
                    return "GL_PIXEL_MAP_I_TO_B";
                case 0xc75:
                    return "GL_PIXEL_MAP_I_TO_A";
                case 0xc76:
                    return "GL_PIXEL_MAP_R_TO_R";
                case 0xc77:
                    return "GL_PIXEL_MAP_G_TO_G";
                case 0xc78:
                    return "GL_PIXEL_MAP_B_TO_B";
                case 0xc79:
                    return "GL_PIXEL_MAP_A_TO_A";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PixelStoreParameter:
        {
            switch (value)
            {
                case 0xcf0:
                    return "GL_UNPACK_SWAP_BYTES";
                case 0xcf1:
                    return "GL_UNPACK_LSB_FIRST";
                case 0xcf2:
                    return "GL_UNPACK_ROW_LENGTH";
                case 0xcf3:
                    return "GL_UNPACK_SKIP_ROWS";
                case 0xcf4:
                    return "GL_UNPACK_SKIP_PIXELS";
                case 0xcf5:
                    return "GL_UNPACK_ALIGNMENT";
                case 0xd00:
                    return "GL_PACK_SWAP_BYTES";
                case 0xd01:
                    return "GL_PACK_LSB_FIRST";
                case 0xd02:
                    return "GL_PACK_ROW_LENGTH";
                case 0xd03:
                    return "GL_PACK_SKIP_ROWS";
                case 0xd04:
                    return "GL_PACK_SKIP_PIXELS";
                case 0xd05:
                    return "GL_PACK_ALIGNMENT";
                case 0x806b:
                    return "GL_PACK_SKIP_IMAGES";
                case 0x806c:
                    return "GL_PACK_IMAGE_HEIGHT";
                case 0x806d:
                    return "GL_UNPACK_SKIP_IMAGES";
                case 0x806e:
                    return "GL_UNPACK_IMAGE_HEIGHT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PixelTexGenMode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                case 0x1909:
                    return "GL_LUMINANCE";
                case 0x190a:
                    return "GL_LUMINANCE_ALPHA";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PixelTransferParameter:
        {
            switch (value)
            {
                case 0xd10:
                    return "GL_MAP_COLOR";
                case 0xd11:
                    return "GL_MAP_STENCIL";
                case 0xd12:
                    return "GL_INDEX_SHIFT";
                case 0xd13:
                    return "GL_INDEX_OFFSET";
                case 0xd14:
                    return "GL_RED_SCALE";
                case 0xd15:
                    return "GL_RED_BIAS";
                case 0xd18:
                    return "GL_GREEN_SCALE";
                case 0xd19:
                    return "GL_GREEN_BIAS";
                case 0xd1a:
                    return "GL_BLUE_SCALE";
                case 0xd1b:
                    return "GL_BLUE_BIAS";
                case 0xd1c:
                    return "GL_ALPHA_SCALE";
                case 0xd1d:
                    return "GL_ALPHA_BIAS";
                case 0xd1e:
                    return "GL_DEPTH_SCALE";
                case 0xd1f:
                    return "GL_DEPTH_BIAS";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PixelType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x1a00:
                    return "GL_BITMAP";
                case 0x8032:
                    return "GL_UNSIGNED_BYTE_3_3_2";
                case 0x8033:
                    return "GL_UNSIGNED_SHORT_4_4_4_4";
                case 0x8034:
                    return "GL_UNSIGNED_SHORT_5_5_5_1";
                case 0x8035:
                    return "GL_UNSIGNED_INT_8_8_8_8";
                case 0x8036:
                    return "GL_UNSIGNED_INT_10_10_10_2";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PointParameterNameSGIS:
        {
            switch (value)
            {
                case 0x8126:
                    return "GL_POINT_SIZE_MIN";
                case 0x8127:
                    return "GL_POINT_SIZE_MAX";
                case 0x8128:
                    return "GL_POINT_FADE_THRESHOLD_SIZE";
                case 0x8129:
                    return "GL_POINT_DISTANCE_ATTENUATION";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PolygonMode:
        {
            switch (value)
            {
                case 0x1b00:
                    return "GL_POINT";
                case 0x1b01:
                    return "GL_LINE";
                case 0x1b02:
                    return "GL_FILL";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PrecisionType:
        {
            switch (value)
            {
                case 0x8df0:
                    return "GL_LOW_FLOAT";
                case 0x8df1:
                    return "GL_MEDIUM_FLOAT";
                case 0x8df2:
                    return "GL_HIGH_FLOAT";
                case 0x8df3:
                    return "GL_LOW_INT";
                case 0x8df4:
                    return "GL_MEDIUM_INT";
                case 0x8df5:
                    return "GL_HIGH_INT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::PrimitiveType:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_POINTS";
                case 0x1:
                    return "GL_LINES";
                case 0x2:
                    return "GL_LINE_LOOP";
                case 0x3:
                    return "GL_LINE_STRIP";
                case 0x4:
                    return "GL_TRIANGLES";
                case 0x5:
                    return "GL_TRIANGLE_STRIP";
                case 0x6:
                    return "GL_TRIANGLE_FAN";
                case 0x7:
                    return "GL_QUADS";
                case 0x8:
                    return "GL_QUAD_STRIP";
                case 0x9:
                    return "GL_POLYGON";
                case 0xa:
                    return "GL_LINES_ADJACENCY";
                case 0xb:
                    return "GL_LINE_STRIP_ADJACENCY";
                case 0xc:
                    return "GL_TRIANGLES_ADJACENCY";
                case 0xd:
                    return "GL_TRIANGLE_STRIP_ADJACENCY";
                case 0xe:
                    return "GL_PATCHES";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ProgramInterface:
        {
            switch (value)
            {
                case 0x8c8e:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x92e1:
                    return "GL_UNIFORM";
                case 0x92e2:
                    return "GL_UNIFORM_BLOCK";
                case 0x92e3:
                    return "GL_PROGRAM_INPUT";
                case 0x92e4:
                    return "GL_PROGRAM_OUTPUT";
                case 0x92e5:
                    return "GL_BUFFER_VARIABLE";
                case 0x92e6:
                    return "GL_SHADER_STORAGE_BLOCK";
                case 0x92e8:
                    return "GL_VERTEX_SUBROUTINE";
                case 0x92e9:
                    return "GL_TESS_CONTROL_SUBROUTINE";
                case 0x92ea:
                    return "GL_TESS_EVALUATION_SUBROUTINE";
                case 0x92eb:
                    return "GL_GEOMETRY_SUBROUTINE";
                case 0x92ec:
                    return "GL_FRAGMENT_SUBROUTINE";
                case 0x92ed:
                    return "GL_COMPUTE_SUBROUTINE";
                case 0x92ee:
                    return "GL_VERTEX_SUBROUTINE_UNIFORM";
                case 0x92ef:
                    return "GL_TESS_CONTROL_SUBROUTINE_UNIFORM";
                case 0x92f0:
                    return "GL_TESS_EVALUATION_SUBROUTINE_UNIFORM";
                case 0x92f1:
                    return "GL_GEOMETRY_SUBROUTINE_UNIFORM";
                case 0x92f2:
                    return "GL_FRAGMENT_SUBROUTINE_UNIFORM";
                case 0x92f3:
                    return "GL_COMPUTE_SUBROUTINE_UNIFORM";
                case 0x92f4:
                    return "GL_TRANSFORM_FEEDBACK_VARYING";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ProgramInterfacePName:
        {
            switch (value)
            {
                case 0x92f5:
                    return "GL_ACTIVE_RESOURCES";
                case 0x92f6:
                    return "GL_MAX_NAME_LENGTH";
                case 0x92f7:
                    return "GL_MAX_NUM_ACTIVE_VARIABLES";
                case 0x92f8:
                    return "GL_MAX_NUM_COMPATIBLE_SUBROUTINES";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ProgramParameterPName:
        {
            switch (value)
            {
                case 0x8257:
                    return "GL_PROGRAM_BINARY_RETRIEVABLE_HINT";
                case 0x8258:
                    return "GL_PROGRAM_SEPARABLE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ProgramPropertyARB:
        {
            switch (value)
            {
                case 0x8267:
                    return "GL_COMPUTE_WORK_GROUP_SIZE";
                case 0x8741:
                    return "GL_PROGRAM_BINARY_LENGTH";
                case 0x8916:
                    return "GL_GEOMETRY_VERTICES_OUT";
                case 0x8917:
                    return "GL_GEOMETRY_INPUT_TYPE";
                case 0x8918:
                    return "GL_GEOMETRY_OUTPUT_TYPE";
                case 0x8a35:
                    return "GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH";
                case 0x8a36:
                    return "GL_ACTIVE_UNIFORM_BLOCKS";
                case 0x8b80:
                    return "GL_DELETE_STATUS";
                case 0x8b82:
                    return "GL_LINK_STATUS";
                case 0x8b83:
                    return "GL_VALIDATE_STATUS";
                case 0x8b84:
                    return "GL_INFO_LOG_LENGTH";
                case 0x8b85:
                    return "GL_ATTACHED_SHADERS";
                case 0x8b86:
                    return "GL_ACTIVE_UNIFORMS";
                case 0x8b87:
                    return "GL_ACTIVE_UNIFORM_MAX_LENGTH";
                case 0x8b89:
                    return "GL_ACTIVE_ATTRIBUTES";
                case 0x8b8a:
                    return "GL_ACTIVE_ATTRIBUTE_MAX_LENGTH";
                case 0x8c76:
                    return "GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH";
                case 0x8c7f:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_MODE";
                case 0x8c83:
                    return "GL_TRANSFORM_FEEDBACK_VARYINGS";
                case 0x92d9:
                    return "GL_ACTIVE_ATOMIC_COUNTER_BUFFERS";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ProgramStagePName:
        {
            switch (value)
            {
                case 0x8de5:
                    return "GL_ACTIVE_SUBROUTINES";
                case 0x8de6:
                    return "GL_ACTIVE_SUBROUTINE_UNIFORMS";
                case 0x8e47:
                    return "GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS";
                case 0x8e48:
                    return "GL_ACTIVE_SUBROUTINE_MAX_LENGTH";
                case 0x8e49:
                    return "GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::QueryObjectParameterName:
        {
            switch (value)
            {
                case 0x82ea:
                    return "GL_QUERY_TARGET";
                case 0x8866:
                    return "GL_QUERY_RESULT";
                case 0x8867:
                    return "GL_QUERY_RESULT_AVAILABLE";
                case 0x9194:
                    return "GL_QUERY_RESULT_NO_WAIT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::QueryParameterName:
        {
            switch (value)
            {
                case 0x8864:
                    return "GL_QUERY_COUNTER_BITS";
                case 0x8865:
                    return "GL_CURRENT_QUERY";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::QueryTarget:
        {
            switch (value)
            {
                case 0x88bf:
                    return "GL_TIME_ELAPSED";
                case 0x8914:
                    return "GL_SAMPLES_PASSED";
                case 0x8c2f:
                    return "GL_ANY_SAMPLES_PASSED";
                case 0x8c87:
                    return "GL_PRIMITIVES_GENERATED";
                case 0x8c88:
                    return "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN";
                case 0x8d6a:
                    return "GL_ANY_SAMPLES_PASSED_CONSERVATIVE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ReadBufferMode:
        {
            switch (value)
            {
                case 0x400:
                    return "GL_FRONT_LEFT";
                case 0x401:
                    return "GL_FRONT_RIGHT";
                case 0x402:
                    return "GL_BACK_LEFT";
                case 0x403:
                    return "GL_BACK_RIGHT";
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x406:
                    return "GL_LEFT";
                case 0x407:
                    return "GL_RIGHT";
                case 0x409:
                    return "GL_AUX0";
                case 0x40a:
                    return "GL_AUX1";
                case 0x40b:
                    return "GL_AUX2";
                case 0x40c:
                    return "GL_AUX3";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::RenderbufferParameterName:
        {
            switch (value)
            {
                case 0x8cab:
                    return "GL_RENDERBUFFER_SAMPLES";
                case 0x8d42:
                    return "GL_RENDERBUFFER_WIDTH";
                case 0x8d43:
                    return "GL_RENDERBUFFER_HEIGHT";
                case 0x8d44:
                    return "GL_RENDERBUFFER_INTERNAL_FORMAT";
                case 0x8d50:
                    return "GL_RENDERBUFFER_RED_SIZE";
                case 0x8d51:
                    return "GL_RENDERBUFFER_GREEN_SIZE";
                case 0x8d52:
                    return "GL_RENDERBUFFER_BLUE_SIZE";
                case 0x8d53:
                    return "GL_RENDERBUFFER_ALPHA_SIZE";
                case 0x8d54:
                    return "GL_RENDERBUFFER_DEPTH_SIZE";
                case 0x8d55:
                    return "GL_RENDERBUFFER_STENCIL_SIZE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::RenderbufferTarget:
        {
            switch (value)
            {
                case 0x8d41:
                    return "GL_RENDERBUFFER";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::RenderingMode:
        {
            switch (value)
            {
                case 0x1c00:
                    return "GL_RENDER";
                case 0x1c01:
                    return "GL_FEEDBACK";
                case 0x1c02:
                    return "GL_SELECT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::SamplerParameterName:
        {
            switch (value)
            {
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR";
                case 0x2800:
                    return "GL_TEXTURE_MAG_FILTER";
                case 0x2801:
                    return "GL_TEXTURE_MIN_FILTER";
                case 0x2802:
                    return "GL_TEXTURE_WRAP_S";
                case 0x2803:
                    return "GL_TEXTURE_WRAP_T";
                case 0x8072:
                    return "GL_TEXTURE_WRAP_R";
                case 0x813a:
                    return "GL_TEXTURE_MIN_LOD";
                case 0x813b:
                    return "GL_TEXTURE_MAX_LOD";
                case 0x884c:
                    return "GL_TEXTURE_COMPARE_MODE";
                case 0x884d:
                    return "GL_TEXTURE_COMPARE_FUNC";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ShaderParameterName:
        {
            switch (value)
            {
                case 0x8b4f:
                    return "GL_SHADER_TYPE";
                case 0x8b80:
                    return "GL_DELETE_STATUS";
                case 0x8b81:
                    return "GL_COMPILE_STATUS";
                case 0x8b84:
                    return "GL_INFO_LOG_LENGTH";
                case 0x8b88:
                    return "GL_SHADER_SOURCE_LENGTH";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ShaderType:
        {
            switch (value)
            {
                case 0x8b30:
                    return "GL_FRAGMENT_SHADER";
                case 0x8b31:
                    return "GL_VERTEX_SHADER";
                case 0x8dd9:
                    return "GL_GEOMETRY_SHADER";
                case 0x8e87:
                    return "GL_TESS_EVALUATION_SHADER";
                case 0x8e88:
                    return "GL_TESS_CONTROL_SHADER";
                case 0x91b9:
                    return "GL_COMPUTE_SHADER";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::ShadingModel:
        {
            switch (value)
            {
                case 0x1d00:
                    return "GL_FLAT";
                case 0x1d01:
                    return "GL_SMOOTH";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::StencilFaceDirection:
        {
            switch (value)
            {
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::StencilFunction:
        {
            switch (value)
            {
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::StencilOp:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_ZERO";
                case 0x150a:
                    return "GL_INVERT";
                case 0x1e00:
                    return "GL_KEEP";
                case 0x1e01:
                    return "GL_REPLACE";
                case 0x1e02:
                    return "GL_INCR";
                case 0x1e03:
                    return "GL_DECR";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::StringName:
        {
            switch (value)
            {
                case 0x1f00:
                    return "GL_VENDOR";
                case 0x1f01:
                    return "GL_RENDERER";
                case 0x1f02:
                    return "GL_VERSION";
                case 0x1f03:
                    return "GL_EXTENSIONS";
                case 0x8b8c:
                    return "GL_SHADING_LANGUAGE_VERSION";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::SubroutineParameterName:
        {
            switch (value)
            {
                case 0x8a38:
                    return "GL_UNIFORM_SIZE";
                case 0x8a39:
                    return "GL_UNIFORM_NAME_LENGTH";
                case 0x8e4a:
                    return "GL_NUM_COMPATIBLE_SUBROUTINES";
                case 0x8e4b:
                    return "GL_COMPATIBLE_SUBROUTINES";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::SyncCondition:
        {
            switch (value)
            {
                case 0x9117:
                    return "GL_SYNC_GPU_COMMANDS_COMPLETE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::SyncObjectMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_SYNC_FLUSH_COMMANDS_BIT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::SyncParameterName:
        {
            switch (value)
            {
                case 0x9112:
                    return "GL_OBJECT_TYPE";
                case 0x9113:
                    return "GL_SYNC_CONDITION";
                case 0x9114:
                    return "GL_SYNC_STATUS";
                case 0x9115:
                    return "GL_SYNC_FLAGS";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::SyncStatus:
        {
            switch (value)
            {
                case 0x911a:
                    return "GL_ALREADY_SIGNALED";
                case 0x911b:
                    return "GL_TIMEOUT_EXPIRED";
                case 0x911c:
                    return "GL_CONDITION_SATISFIED";
                case 0x911d:
                    return "GL_WAIT_FAILED";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TexCoordPointerType:
        {
            switch (value)
            {
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140a:
                    return "GL_DOUBLE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TextureCoordName:
        {
            switch (value)
            {
                case 0x2000:
                    return "GL_S";
                case 0x2001:
                    return "GL_T";
                case 0x2002:
                    return "GL_R";
                case 0x2003:
                    return "GL_Q";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TextureEnvMode:
        {
            switch (value)
            {
                case 0x104:
                    return "GL_ADD";
                case 0xbe2:
                    return "GL_BLEND";
                case 0x2100:
                    return "GL_MODULATE";
                case 0x2101:
                    return "GL_DECAL";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TextureEnvParameter:
        {
            switch (value)
            {
                case 0x2200:
                    return "GL_TEXTURE_ENV_MODE";
                case 0x2201:
                    return "GL_TEXTURE_ENV_COLOR";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TextureEnvTarget:
        {
            switch (value)
            {
                case 0x2300:
                    return "GL_TEXTURE_ENV";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TextureGenMode:
        {
            switch (value)
            {
                case 0x2400:
                    return "GL_EYE_LINEAR";
                case 0x2401:
                    return "GL_OBJECT_LINEAR";
                case 0x2402:
                    return "GL_SPHERE_MAP";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TextureGenParameter:
        {
            switch (value)
            {
                case 0x2500:
                    return "GL_TEXTURE_GEN_MODE";
                case 0x2501:
                    return "GL_OBJECT_PLANE";
                case 0x2502:
                    return "GL_EYE_PLANE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TextureLayout:
        {
            switch (value)
            {
                case 0x9530:
                    return "GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT";
                case 0x9531:
                    return "GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT";
                case 0x958d:
                    return "GL_LAYOUT_GENERAL_EXT";
                case 0x958e:
                    return "GL_LAYOUT_COLOR_ATTACHMENT_EXT";
                case 0x958f:
                    return "GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT";
                case 0x9590:
                    return "GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT";
                case 0x9591:
                    return "GL_LAYOUT_SHADER_READ_ONLY_EXT";
                case 0x9592:
                    return "GL_LAYOUT_TRANSFER_SRC_EXT";
                case 0x9593:
                    return "GL_LAYOUT_TRANSFER_DST_EXT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TextureMagFilter:
        {
            switch (value)
            {
                case 0x2600:
                    return "GL_NEAREST";
                case 0x2601:
                    return "GL_LINEAR";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TextureMinFilter:
        {
            switch (value)
            {
                case 0x2600:
                    return "GL_NEAREST";
                case 0x2601:
                    return "GL_LINEAR";
                case 0x2700:
                    return "GL_NEAREST_MIPMAP_NEAREST";
                case 0x2701:
                    return "GL_LINEAR_MIPMAP_NEAREST";
                case 0x2702:
                    return "GL_NEAREST_MIPMAP_LINEAR";
                case 0x2703:
                    return "GL_LINEAR_MIPMAP_LINEAR";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TextureParameterName:
        {
            switch (value)
            {
                case 0x1000:
                    return "GL_TEXTURE_WIDTH";
                case 0x1001:
                    return "GL_TEXTURE_HEIGHT";
                case 0x1003:
                    return "GL_TEXTURE_COMPONENTS";
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR";
                case 0x1005:
                    return "GL_TEXTURE_BORDER";
                case 0x2800:
                    return "GL_TEXTURE_MAG_FILTER";
                case 0x2801:
                    return "GL_TEXTURE_MIN_FILTER";
                case 0x2802:
                    return "GL_TEXTURE_WRAP_S";
                case 0x2803:
                    return "GL_TEXTURE_WRAP_T";
                case 0x805c:
                    return "GL_TEXTURE_RED_SIZE";
                case 0x805d:
                    return "GL_TEXTURE_GREEN_SIZE";
                case 0x805e:
                    return "GL_TEXTURE_BLUE_SIZE";
                case 0x805f:
                    return "GL_TEXTURE_ALPHA_SIZE";
                case 0x8060:
                    return "GL_TEXTURE_LUMINANCE_SIZE";
                case 0x8061:
                    return "GL_TEXTURE_INTENSITY_SIZE";
                case 0x8066:
                    return "GL_TEXTURE_PRIORITY";
                case 0x8067:
                    return "GL_TEXTURE_RESIDENT";
                case 0x8072:
                    return "GL_TEXTURE_WRAP_R";
                case 0x813a:
                    return "GL_TEXTURE_MIN_LOD";
                case 0x813b:
                    return "GL_TEXTURE_MAX_LOD";
                case 0x813c:
                    return "GL_TEXTURE_BASE_LEVEL";
                case 0x813d:
                    return "GL_TEXTURE_MAX_LEVEL";
                case 0x8191:
                    return "GL_GENERATE_MIPMAP";
                case 0x8501:
                    return "GL_TEXTURE_LOD_BIAS";
                case 0x884c:
                    return "GL_TEXTURE_COMPARE_MODE";
                case 0x884d:
                    return "GL_TEXTURE_COMPARE_FUNC";
                case 0x8e42:
                    return "GL_TEXTURE_SWIZZLE_R";
                case 0x8e43:
                    return "GL_TEXTURE_SWIZZLE_G";
                case 0x8e44:
                    return "GL_TEXTURE_SWIZZLE_B";
                case 0x8e45:
                    return "GL_TEXTURE_SWIZZLE_A";
                case 0x8e46:
                    return "GL_TEXTURE_SWIZZLE_RGBA";
                case 0x90ea:
                    return "GL_DEPTH_STENCIL_TEXTURE_MODE";
                case 0x9580:
                    return "GL_TEXTURE_TILING_EXT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TextureTarget:
        {
            switch (value)
            {
                case 0xde0:
                    return "GL_TEXTURE_1D";
                case 0xde1:
                    return "GL_TEXTURE_2D";
                case 0x8063:
                    return "GL_PROXY_TEXTURE_1D";
                case 0x8064:
                    return "GL_PROXY_TEXTURE_2D";
                case 0x806f:
                    return "GL_TEXTURE_3D";
                case 0x8070:
                    return "GL_PROXY_TEXTURE_3D";
                case 0x84f5:
                    return "GL_TEXTURE_RECTANGLE";
                case 0x84f7:
                    return "GL_PROXY_TEXTURE_RECTANGLE";
                case 0x8513:
                    return "GL_TEXTURE_CUBE_MAP";
                case 0x8515:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_X";
                case 0x8516:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_X";
                case 0x8517:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Y";
                case 0x8518:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y";
                case 0x8519:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Z";
                case 0x851a:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z";
                case 0x851b:
                    return "GL_PROXY_TEXTURE_CUBE_MAP";
                case 0x8c18:
                    return "GL_TEXTURE_1D_ARRAY";
                case 0x8c19:
                    return "GL_PROXY_TEXTURE_1D_ARRAY";
                case 0x8c1a:
                    return "GL_TEXTURE_2D_ARRAY";
                case 0x8c1b:
                    return "GL_PROXY_TEXTURE_2D_ARRAY";
                case 0x9009:
                    return "GL_TEXTURE_CUBE_MAP_ARRAY";
                case 0x900b:
                    return "GL_PROXY_TEXTURE_CUBE_MAP_ARRAY";
                case 0x9100:
                    return "GL_TEXTURE_2D_MULTISAMPLE";
                case 0x9101:
                    return "GL_PROXY_TEXTURE_2D_MULTISAMPLE";
                case 0x9102:
                    return "GL_TEXTURE_2D_MULTISAMPLE_ARRAY";
                case 0x9103:
                    return "GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TextureUnit:
        {
            switch (value)
            {
                case 0x84c0:
                    return "GL_TEXTURE0";
                case 0x84c1:
                    return "GL_TEXTURE1";
                case 0x84c2:
                    return "GL_TEXTURE2";
                case 0x84c3:
                    return "GL_TEXTURE3";
                case 0x84c4:
                    return "GL_TEXTURE4";
                case 0x84c5:
                    return "GL_TEXTURE5";
                case 0x84c6:
                    return "GL_TEXTURE6";
                case 0x84c7:
                    return "GL_TEXTURE7";
                case 0x84c8:
                    return "GL_TEXTURE8";
                case 0x84c9:
                    return "GL_TEXTURE9";
                case 0x84ca:
                    return "GL_TEXTURE10";
                case 0x84cb:
                    return "GL_TEXTURE11";
                case 0x84cc:
                    return "GL_TEXTURE12";
                case 0x84cd:
                    return "GL_TEXTURE13";
                case 0x84ce:
                    return "GL_TEXTURE14";
                case 0x84cf:
                    return "GL_TEXTURE15";
                case 0x84d0:
                    return "GL_TEXTURE16";
                case 0x84d1:
                    return "GL_TEXTURE17";
                case 0x84d2:
                    return "GL_TEXTURE18";
                case 0x84d3:
                    return "GL_TEXTURE19";
                case 0x84d4:
                    return "GL_TEXTURE20";
                case 0x84d5:
                    return "GL_TEXTURE21";
                case 0x84d6:
                    return "GL_TEXTURE22";
                case 0x84d7:
                    return "GL_TEXTURE23";
                case 0x84d8:
                    return "GL_TEXTURE24";
                case 0x84d9:
                    return "GL_TEXTURE25";
                case 0x84da:
                    return "GL_TEXTURE26";
                case 0x84db:
                    return "GL_TEXTURE27";
                case 0x84dc:
                    return "GL_TEXTURE28";
                case 0x84dd:
                    return "GL_TEXTURE29";
                case 0x84de:
                    return "GL_TEXTURE30";
                case 0x84df:
                    return "GL_TEXTURE31";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TextureWrapMode:
        {
            switch (value)
            {
                case 0x2900:
                    return "GL_CLAMP";
                case 0x2901:
                    return "GL_REPEAT";
                case 0x812d:
                    return "GL_CLAMP_TO_BORDER";
                case 0x812f:
                    return "GL_CLAMP_TO_EDGE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TransformFeedbackPName:
        {
            switch (value)
            {
                case 0x8c84:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_START";
                case 0x8c85:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE";
                case 0x8c8f:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING";
                case 0x8e23:
                    return "GL_TRANSFORM_FEEDBACK_PAUSED";
                case 0x8e24:
                    return "GL_TRANSFORM_FEEDBACK_ACTIVE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::TypeEnum:
        {
            switch (value)
            {
                case 0x8e13:
                    return "GL_QUERY_WAIT";
                case 0x8e14:
                    return "GL_QUERY_NO_WAIT";
                case 0x8e15:
                    return "GL_QUERY_BY_REGION_WAIT";
                case 0x8e16:
                    return "GL_QUERY_BY_REGION_NO_WAIT";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::UniformBlockPName:
        {
            switch (value)
            {
                case 0x84f0:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER";
                case 0x84f1:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER";
                case 0x8a3f:
                    return "GL_UNIFORM_BLOCK_BINDING";
                case 0x8a40:
                    return "GL_UNIFORM_BLOCK_DATA_SIZE";
                case 0x8a41:
                    return "GL_UNIFORM_BLOCK_NAME_LENGTH";
                case 0x8a42:
                    return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS";
                case 0x8a43:
                    return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES";
                case 0x8a44:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER";
                case 0x8a45:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER";
                case 0x8a46:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER";
                case 0x90ec:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::UniformPName:
        {
            switch (value)
            {
                case 0x8a37:
                    return "GL_UNIFORM_TYPE";
                case 0x8a38:
                    return "GL_UNIFORM_SIZE";
                case 0x8a39:
                    return "GL_UNIFORM_NAME_LENGTH";
                case 0x8a3a:
                    return "GL_UNIFORM_BLOCK_INDEX";
                case 0x8a3b:
                    return "GL_UNIFORM_OFFSET";
                case 0x8a3c:
                    return "GL_UNIFORM_ARRAY_STRIDE";
                case 0x8a3d:
                    return "GL_UNIFORM_MATRIX_STRIDE";
                case 0x8a3e:
                    return "GL_UNIFORM_IS_ROW_MAJOR";
                case 0x92da:
                    return "GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::UseProgramStageMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_VERTEX_SHADER_BIT";
                case 0x2:
                    return "GL_FRAGMENT_SHADER_BIT";
                case 0x4:
                    return "GL_GEOMETRY_SHADER_BIT";
                case 0x8:
                    return "GL_TESS_CONTROL_SHADER_BIT";
                case 0x10:
                    return "GL_TESS_EVALUATION_SHADER_BIT";
                case 0x20:
                    return "GL_COMPUTE_SHADER_BIT";
                case 0xffffffff:
                    return "GL_ALL_SHADER_BITS";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::VertexArrayPName:
        {
            switch (value)
            {
                case 0x82d5:
                    return "GL_VERTEX_ATTRIB_RELATIVE_OFFSET";
                case 0x8622:
                    return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
                case 0x8623:
                    return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
                case 0x8624:
                    return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
                case 0x8625:
                    return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
                case 0x874e:
                    return "GL_VERTEX_ATTRIB_ARRAY_LONG";
                case 0x886a:
                    return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
                case 0x88fd:
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
                case 0x88fe:
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::VertexAttribEnum:
        {
            switch (value)
            {
                case 0x8622:
                    return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
                case 0x8623:
                    return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
                case 0x8624:
                    return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
                case 0x8625:
                    return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
                case 0x8626:
                    return "GL_CURRENT_VERTEX_ATTRIB";
                case 0x886a:
                    return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
                case 0x889f:
                    return "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING";
                case 0x88fd:
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
                case 0x88fe:
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::VertexAttribPointerType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140a:
                    return "GL_DOUBLE";
                case 0x140b:
                    return "GL_HALF_FLOAT";
                case 0x140c:
                    return "GL_FIXED";
                case 0x8368:
                    return "GL_UNSIGNED_INT_2_10_10_10_REV";
                case 0x8c3b:
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
                case 0x8d9f:
                    return "GL_INT_2_10_10_10_REV";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::VertexAttribType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140a:
                    return "GL_DOUBLE";
                case 0x140b:
                    return "GL_HALF_FLOAT";
                case 0x140c:
                    return "GL_FIXED";
                case 0x8368:
                    return "GL_UNSIGNED_INT_2_10_10_10_REV";
                case 0x8c3b:
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
                case 0x8d9f:
                    return "GL_INT_2_10_10_10_REV";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::VertexBufferObjectParameter:
        {
            switch (value)
            {
                case 0x821f:
                    return "GL_BUFFER_IMMUTABLE_STORAGE";
                case 0x8220:
                    return "GL_BUFFER_STORAGE_FLAGS";
                case 0x8764:
                    return "GL_BUFFER_SIZE";
                case 0x8765:
                    return "GL_BUFFER_USAGE";
                case 0x88bb:
                    return "GL_BUFFER_ACCESS";
                case 0x88bc:
                    return "GL_BUFFER_MAPPED";
                case 0x911f:
                    return "GL_BUFFER_ACCESS_FLAGS";
                case 0x9120:
                    return "GL_BUFFER_MAP_LENGTH";
                case 0x9121:
                    return "GL_BUFFER_MAP_OFFSET";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::VertexBufferObjectUsage:
        {
            switch (value)
            {
                case 0x88e0:
                    return "GL_STREAM_DRAW";
                case 0x88e1:
                    return "GL_STREAM_READ";
                case 0x88e2:
                    return "GL_STREAM_COPY";
                case 0x88e4:
                    return "GL_STATIC_DRAW";
                case 0x88e5:
                    return "GL_STATIC_READ";
                case 0x88e6:
                    return "GL_STATIC_COPY";
                case 0x88e8:
                    return "GL_DYNAMIC_DRAW";
                case 0x88e9:
                    return "GL_DYNAMIC_READ";
                case 0x88ea:
                    return "GL_DYNAMIC_COPY";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::VertexPointerType:
        {
            switch (value)
            {
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140a:
                    return "GL_DOUBLE";
                default:
                    return kEnumUnknown;
            }
        }

        case GLenumGroup::VertexProvokingMode:
        {
            switch (value)
            {
                case 0x8e4d:
                    return "GL_FIRST_VERTEX_CONVENTION";
                case 0x8e4e:
                    return "GL_LAST_VERTEX_CONVENTION";
                default:
                    return kEnumUnknown;
            }
        }

        default:
            return kEnumUnknown;
    }
}

std::string GLbitfieldToString(GLenumGroup enumGroup, unsigned int value)
{
    std::stringstream st;

    const angle::BitSet<32> bitSet(value);
    bool first = true;
    for (const auto index : bitSet)
    {
        if (!first)
        {
            st << " | ";
        }
        first = false;

        unsigned int mask = 1u << index;
        OutputGLenumString(st, enumGroup, mask);
    }

    return st.str();
}

}  // namespace gl
