// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_function_declarations.txt.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_test_ESSL_autogen.cpp:
//   Tests for matching script-generated hashes with runtime computed hashes.

#include "compiler/translator/ImmutableString.h"
#include "gtest/gtest.h"

namespace sh
{

TEST(ImmutableStringTest, ScriptGeneratedHashesMatch)
{
    ASSERT_EQ(0x0000026cu, ImmutableString("radians(00B").mangledNameHash());
    ASSERT_EQ(0x00000146u, ImmutableString("radians(10B").mangledNameHash());
    ASSERT_EQ(0x00000108u, ImmutableString("radians(20B").mangledNameHash());
    ASSERT_EQ(0x0000039bu, ImmutableString("radians(30B").mangledNameHash());
    ASSERT_EQ(0x000001d8u, ImmutableString("degrees(00B").mangledNameHash());
    ASSERT_EQ(0x0000031cu, ImmutableString("degrees(10B").mangledNameHash());
    ASSERT_EQ(0x00000046u, ImmutableString("degrees(20B").mangledNameHash());
    ASSERT_EQ(0x00000168u, ImmutableString("degrees(30B").mangledNameHash());
    ASSERT_EQ(0x00000347u, ImmutableString("sin(00B").mangledNameHash());
    ASSERT_EQ(0x00000203u, ImmutableString("sin(10B").mangledNameHash());
    ASSERT_EQ(0x00000224u, ImmutableString("sin(20B").mangledNameHash());
    ASSERT_EQ(0x0000010fu, ImmutableString("sin(30B").mangledNameHash());
    ASSERT_EQ(0x0000020fu, ImmutableString("cos(00B").mangledNameHash());
    ASSERT_EQ(0x00000356u, ImmutableString("cos(10B").mangledNameHash());
    ASSERT_EQ(0x00000399u, ImmutableString("cos(20B").mangledNameHash());
    ASSERT_EQ(0x000002b3u, ImmutableString("cos(30B").mangledNameHash());
    ASSERT_EQ(0x00000206u, ImmutableString("tan(00B").mangledNameHash());
    ASSERT_EQ(0x0000034du, ImmutableString("tan(10B").mangledNameHash());
    ASSERT_EQ(0x0000039du, ImmutableString("tan(20B").mangledNameHash());
    ASSERT_EQ(0x000000f4u, ImmutableString("tan(30B").mangledNameHash());
    ASSERT_EQ(0x00000231u, ImmutableString("asin(00B").mangledNameHash());
    ASSERT_EQ(0x00000378u, ImmutableString("asin(10B").mangledNameHash());
    ASSERT_EQ(0x00000018u, ImmutableString("asin(20B").mangledNameHash());
    ASSERT_EQ(0x00000136u, ImmutableString("asin(30B").mangledNameHash());
    ASSERT_EQ(0x00000060u, ImmutableString("acos(00B").mangledNameHash());
    ASSERT_EQ(0x000002e6u, ImmutableString("acos(10B").mangledNameHash());
    ASSERT_EQ(0x00000288u, ImmutableString("acos(20B").mangledNameHash());
    ASSERT_EQ(0x00000166u, ImmutableString("acos(30B").mangledNameHash());
    ASSERT_EQ(0x000001f2u, ImmutableString("atan(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000031u, ImmutableString("atan(10B10B").mangledNameHash());
    ASSERT_EQ(0x000001c7u, ImmutableString("atan(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000131u, ImmutableString("atan(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001dfu, ImmutableString("atan(00B").mangledNameHash());
    ASSERT_EQ(0x00000070u, ImmutableString("atan(10B").mangledNameHash());
    ASSERT_EQ(0x00000086u, ImmutableString("atan(20B").mangledNameHash());
    ASSERT_EQ(0x00000323u, ImmutableString("atan(30B").mangledNameHash());
    ASSERT_EQ(0x0000028au, ImmutableString("sinh(00B").mangledNameHash());
    ASSERT_EQ(0x00000322u, ImmutableString("sinh(10B").mangledNameHash());
    ASSERT_EQ(0x0000017eu, ImmutableString("sinh(20B").mangledNameHash());
    ASSERT_EQ(0x000000ecu, ImmutableString("sinh(30B").mangledNameHash());
    ASSERT_EQ(0x00000158u, ImmutableString("cosh(00B").mangledNameHash());
    ASSERT_EQ(0x00000306u, ImmutableString("cosh(10B").mangledNameHash());
    ASSERT_EQ(0x00000335u, ImmutableString("cosh(20B").mangledNameHash());
    ASSERT_EQ(0x00000267u, ImmutableString("cosh(30B").mangledNameHash());
    ASSERT_EQ(0x00000047u, ImmutableString("tanh(00B").mangledNameHash());
    ASSERT_EQ(0x00000167u, ImmutableString("tanh(10B").mangledNameHash());
    ASSERT_EQ(0x0000027cu, ImmutableString("tanh(20B").mangledNameHash());
    ASSERT_EQ(0x0000000du, ImmutableString("tanh(30B").mangledNameHash());
    ASSERT_EQ(0x00000261u, ImmutableString("asinh(00B").mangledNameHash());
    ASSERT_EQ(0x000003a1u, ImmutableString("asinh(10B").mangledNameHash());
    ASSERT_EQ(0x000000f1u, ImmutableString("asinh(20B").mangledNameHash());
    ASSERT_EQ(0x0000020au, ImmutableString("asinh(30B").mangledNameHash());
    ASSERT_EQ(0x0000017bu, ImmutableString("acosh(00B").mangledNameHash());
    ASSERT_EQ(0x000000abu, ImmutableString("acosh(10B").mangledNameHash());
    ASSERT_EQ(0x0000001du, ImmutableString("acosh(20B").mangledNameHash());
    ASSERT_EQ(0x000002a3u, ImmutableString("acosh(30B").mangledNameHash());
    ASSERT_EQ(0x00000082u, ImmutableString("atanh(00B").mangledNameHash());
    ASSERT_EQ(0x0000001eu, ImmutableString("atanh(10B").mangledNameHash());
    ASSERT_EQ(0x000002cbu, ImmutableString("atanh(20B").mangledNameHash());
    ASSERT_EQ(0x00000193u, ImmutableString("atanh(30B").mangledNameHash());
    ASSERT_EQ(0x0000018du, ImmutableString("pow(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000008du, ImmutableString("pow(10B10B").mangledNameHash());
    ASSERT_EQ(0x000002feu, ImmutableString("pow(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000217u, ImmutableString("pow(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000030bu, ImmutableString("exp(00B").mangledNameHash());
    ASSERT_EQ(0x00000077u, ImmutableString("exp(10B").mangledNameHash());
    ASSERT_EQ(0x00000178u, ImmutableString("exp(20B").mangledNameHash());
    ASSERT_EQ(0x00000295u, ImmutableString("exp(30B").mangledNameHash());
    ASSERT_EQ(0x0000029cu, ImmutableString("log(00B").mangledNameHash());
    ASSERT_EQ(0x0000017cu, ImmutableString("log(10B").mangledNameHash());
    ASSERT_EQ(0x00000135u, ImmutableString("log(20B").mangledNameHash());
    ASSERT_EQ(0x000000ccu, ImmutableString("log(30B").mangledNameHash());
    ASSERT_EQ(0x0000039au, ImmutableString("exp2(00B").mangledNameHash());
    ASSERT_EQ(0x000000f9u, ImmutableString("exp2(10B").mangledNameHash());
    ASSERT_EQ(0x00000144u, ImmutableString("exp2(20B").mangledNameHash());
    ASSERT_EQ(0x00000258u, ImmutableString("exp2(30B").mangledNameHash());
    ASSERT_EQ(0x00000162u, ImmutableString("log2(00B").mangledNameHash());
    ASSERT_EQ(0x0000008au, ImmutableString("log2(10B").mangledNameHash());
    ASSERT_EQ(0x00000317u, ImmutableString("log2(20B").mangledNameHash());
    ASSERT_EQ(0x000001b3u, ImmutableString("log2(30B").mangledNameHash());
    ASSERT_EQ(0x000001d4u, ImmutableString("sqrt(00B").mangledNameHash());
    ASSERT_EQ(0x000000b8u, ImmutableString("sqrt(10B").mangledNameHash());
    ASSERT_EQ(0x0000007eu, ImmutableString("sqrt(20B").mangledNameHash());
    ASSERT_EQ(0x00000307u, ImmutableString("sqrt(30B").mangledNameHash());
    ASSERT_EQ(0x0000004cu, ImmutableString("inversesqrt(00B").mangledNameHash());
    ASSERT_EQ(0x000002e4u, ImmutableString("inversesqrt(10B").mangledNameHash());
    ASSERT_EQ(0x0000023eu, ImmutableString("inversesqrt(20B").mangledNameHash());
    ASSERT_EQ(0x0000016eu, ImmutableString("inversesqrt(30B").mangledNameHash());
    ASSERT_EQ(0x00000280u, ImmutableString("abs(00B").mangledNameHash());
    ASSERT_EQ(0x00000165u, ImmutableString("abs(10B").mangledNameHash());
    ASSERT_EQ(0x0000004bu, ImmutableString("abs(20B").mangledNameHash());
    ASSERT_EQ(0x000002eau, ImmutableString("abs(30B").mangledNameHash());
    ASSERT_EQ(0x0000027fu, ImmutableString("abs(00D").mangledNameHash());
    ASSERT_EQ(0x00000164u, ImmutableString("abs(10D").mangledNameHash());
    ASSERT_EQ(0x0000004au, ImmutableString("abs(20D").mangledNameHash());
    ASSERT_EQ(0x000002e7u, ImmutableString("abs(30D").mangledNameHash());
    ASSERT_EQ(0x0000029bu, ImmutableString("sign(00B").mangledNameHash());
    ASSERT_EQ(0x0000038cu, ImmutableString("sign(10B").mangledNameHash());
    ASSERT_EQ(0x0000007fu, ImmutableString("sign(20B").mangledNameHash());
    ASSERT_EQ(0x0000018bu, ImmutableString("sign(30B").mangledNameHash());
    ASSERT_EQ(0x0000029eu, ImmutableString("sign(00D").mangledNameHash());
    ASSERT_EQ(0x00000309u, ImmutableString("sign(10D").mangledNameHash());
    ASSERT_EQ(0x00000081u, ImmutableString("sign(20D").mangledNameHash());
    ASSERT_EQ(0x0000018cu, ImmutableString("sign(30D").mangledNameHash());
    ASSERT_EQ(0x000003a3u, ImmutableString("floor(00B").mangledNameHash());
    ASSERT_EQ(0x00000202u, ImmutableString("floor(10B").mangledNameHash());
    ASSERT_EQ(0x0000021eu, ImmutableString("floor(20B").mangledNameHash());
    ASSERT_EQ(0x00000110u, ImmutableString("floor(30B").mangledNameHash());
    ASSERT_EQ(0x000000ebu, ImmutableString("trunc(00B").mangledNameHash());
    ASSERT_EQ(0x0000037au, ImmutableString("trunc(10B").mangledNameHash());
    ASSERT_EQ(0x00000343u, ImmutableString("trunc(20B").mangledNameHash());
    ASSERT_EQ(0x000001f9u, ImmutableString("trunc(30B").mangledNameHash());
    ASSERT_EQ(0x000000d0u, ImmutableString("round(00B").mangledNameHash());
    ASSERT_EQ(0x00000363u, ImmutableString("round(10B").mangledNameHash());
    ASSERT_EQ(0x00000226u, ImmutableString("round(20B").mangledNameHash());
    ASSERT_EQ(0x0000010cu, ImmutableString("round(30B").mangledNameHash());
    ASSERT_EQ(0x000002c8u, ImmutableString("roundEven(00B").mangledNameHash());
    ASSERT_EQ(0x00000191u, ImmutableString("roundEven(10B").mangledNameHash());
    ASSERT_EQ(0x0000013bu, ImmutableString("roundEven(20B").mangledNameHash());
    ASSERT_EQ(0x0000001cu, ImmutableString("roundEven(30B").mangledNameHash());
    ASSERT_EQ(0x00000232u, ImmutableString("ceil(00B").mangledNameHash());
    ASSERT_EQ(0x00000325u, ImmutableString("ceil(10B").mangledNameHash());
    ASSERT_EQ(0x00000098u, ImmutableString("ceil(20B").mangledNameHash());
    ASSERT_EQ(0x0000014bu, ImmutableString("ceil(30B").mangledNameHash());
    ASSERT_EQ(0x00000175u, ImmutableString("fract(00B").mangledNameHash());
    ASSERT_EQ(0x00000061u, ImmutableString("fract(10B").mangledNameHash());
    ASSERT_EQ(0x000002e9u, ImmutableString("fract(20B").mangledNameHash());
    ASSERT_EQ(0x000001b6u, ImmutableString("fract(30B").mangledNameHash());
    ASSERT_EQ(0x0000018eu, ImmutableString("mod(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000154u, ImmutableString("mod(10B00B").mangledNameHash());
    ASSERT_EQ(0x000000b3u, ImmutableString("mod(20B00B").mangledNameHash());
    ASSERT_EQ(0x0000019fu, ImmutableString("mod(30B00B").mangledNameHash());
    ASSERT_EQ(0x000002aau, ImmutableString("mod(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000207u, ImmutableString("mod(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000189u, ImmutableString("mod(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001d0u, ImmutableString("min(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000319u, ImmutableString("min(10B00B").mangledNameHash());
    ASSERT_EQ(0x000000aeu, ImmutableString("min(20B00B").mangledNameHash());
    ASSERT_EQ(0x00000072u, ImmutableString("min(30B00B").mangledNameHash());
    ASSERT_EQ(0x0000008bu, ImmutableString("min(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000210u, ImmutableString("min(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000005bu, ImmutableString("min(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000340u, ImmutableString("min(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000045u, ImmutableString("min(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000270u, ImmutableString("min(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000240u, ImmutableString("min(30D30D").mangledNameHash());
    ASSERT_EQ(0x000002c3u, ImmutableString("min(10D00D").mangledNameHash());
    ASSERT_EQ(0x00000039u, ImmutableString("min(20D00D").mangledNameHash());
    ASSERT_EQ(0x0000038au, ImmutableString("min(30D00D").mangledNameHash());
    ASSERT_EQ(0x0000030cu, ImmutableString("min(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000035cu, ImmutableString("min(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000017u, ImmutableString("min(20E20E").mangledNameHash());
    ASSERT_EQ(0x000001ccu, ImmutableString("min(30E30E").mangledNameHash());
    ASSERT_EQ(0x000000cbu, ImmutableString("min(10E00E").mangledNameHash());
    ASSERT_EQ(0x000001dau, ImmutableString("min(20E00E").mangledNameHash());
    ASSERT_EQ(0x00000177u, ImmutableString("min(30E00E").mangledNameHash());
    ASSERT_EQ(0x0000013au, ImmutableString("max(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000251u, ImmutableString("max(10B00B").mangledNameHash());
    ASSERT_EQ(0x00000032u, ImmutableString("max(20B00B").mangledNameHash());
    ASSERT_EQ(0x0000026fu, ImmutableString("max(30B00B").mangledNameHash());
    ASSERT_EQ(0x00000372u, ImmutableString("max(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000290u, ImmutableString("max(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000011cu, ImmutableString("max(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000149u, ImmutableString("max(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000214u, ImmutableString("max(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000212u, ImmutableString("max(20D20D").mangledNameHash());
    ASSERT_EQ(0x0000030du, ImmutableString("max(30D30D").mangledNameHash());
    ASSERT_EQ(0x0000010au, ImmutableString("max(10D00D").mangledNameHash());
    ASSERT_EQ(0x000000bcu, ImmutableString("max(20D00D").mangledNameHash());
    ASSERT_EQ(0x00000053u, ImmutableString("max(30D00D").mangledNameHash());
    ASSERT_EQ(0x0000038du, ImmutableString("max(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000011bu, ImmutableString("max(10E10E").mangledNameHash());
    ASSERT_EQ(0x0000015bu, ImmutableString("max(20E20E").mangledNameHash());
    ASSERT_EQ(0x000001c3u, ImmutableString("max(30E30E").mangledNameHash());
    ASSERT_EQ(0x000001e9u, ImmutableString("max(10E00E").mangledNameHash());
    ASSERT_EQ(0x000002c6u, ImmutableString("max(20E00E").mangledNameHash());
    ASSERT_EQ(0x00000143u, ImmutableString("max(30E00E").mangledNameHash());
    ASSERT_EQ(0x00000171u, ImmutableString("clamp(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000383u, ImmutableString("clamp(10B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000027bu, ImmutableString("clamp(20B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000100u, ImmutableString("clamp(30B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000020u, ImmutableString("clamp(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000033au, ImmutableString("clamp(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000033u, ImmutableString("clamp(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x0000010eu, ImmutableString("clamp(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000002u, ImmutableString("clamp(10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002cdu, ImmutableString("clamp(20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000382u, ImmutableString("clamp(30D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000009au, ImmutableString("clamp(10D10D10D").mangledNameHash());
    ASSERT_EQ(0x000001e6u, ImmutableString("clamp(20D20D20D").mangledNameHash());
    ASSERT_EQ(0x000002f1u, ImmutableString("clamp(30D30D30D").mangledNameHash());
    ASSERT_EQ(0x00000011u, ImmutableString("clamp(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x000002ccu, ImmutableString("clamp(10E00E00E").mangledNameHash());
    ASSERT_EQ(0x000002f8u, ImmutableString("clamp(20E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000230u, ImmutableString("clamp(30E00E00E").mangledNameHash());
    ASSERT_EQ(0x0000011du, ImmutableString("clamp(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x000000bau, ImmutableString("clamp(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x000000a3u, ImmutableString("clamp(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x00000220u, ImmutableString("mix(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000002efu, ImmutableString("mix(10B10B00B").mangledNameHash());
    ASSERT_EQ(0x0000001fu, ImmutableString("mix(20B20B00B").mangledNameHash());
    ASSERT_EQ(0x0000031au, ImmutableString("mix(30B30B00B").mangledNameHash());
    ASSERT_EQ(0x000001afu, ImmutableString("mix(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000024fu, ImmutableString("mix(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000357u, ImmutableString("mix(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x00000055u, ImmutableString("mix(00B00B00F").mangledNameHash());
    ASSERT_EQ(0x000001aeu, ImmutableString("mix(10B10B10F").mangledNameHash());
    ASSERT_EQ(0x0000024cu, ImmutableString("mix(20B20B20F").mangledNameHash());
    ASSERT_EQ(0x000002fbu, ImmutableString("mix(30B30B30F").mangledNameHash());
    ASSERT_EQ(0x00000197u, ImmutableString("step(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000271u, ImmutableString("step(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000282u, ImmutableString("step(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000273u, ImmutableString("step(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000079u, ImmutableString("step(00B10B").mangledNameHash());
    ASSERT_EQ(0x00000024u, ImmutableString("step(00B20B").mangledNameHash());
    ASSERT_EQ(0x00000298u, ImmutableString("step(00B30B").mangledNameHash());
    ASSERT_EQ(0x00000332u, ImmutableString("smoothstep(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000219u, ImmutableString("smoothstep(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000390u, ImmutableString("smoothstep(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000338u, ImmutableString("smoothstep(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000001eau, ImmutableString("smoothstep(00B00B10B").mangledNameHash());
    ASSERT_EQ(0x000000d1u, ImmutableString("smoothstep(00B00B20B").mangledNameHash());
    ASSERT_EQ(0x00000314u, ImmutableString("smoothstep(00B00B30B").mangledNameHash());
    ASSERT_EQ(0x00000005u, ImmutableString("modf(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000071u, ImmutableString("modf(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000239u, ImmutableString("modf(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000138u, ImmutableString("modf(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000022cu, ImmutableString("isnan(00B").mangledNameHash());
    ASSERT_EQ(0x00000370u, ImmutableString("isnan(10B").mangledNameHash());
    ASSERT_EQ(0x00000139u, ImmutableString("isnan(20B").mangledNameHash());
    ASSERT_EQ(0x000001c4u, ImmutableString("isnan(30B").mangledNameHash());
    ASSERT_EQ(0x0000019au, ImmutableString("isinf(00B").mangledNameHash());
    ASSERT_EQ(0x000002cfu, ImmutableString("isinf(10B").mangledNameHash());
    ASSERT_EQ(0x00000355u, ImmutableString("isinf(20B").mangledNameHash());
    ASSERT_EQ(0x000000c1u, ImmutableString("isinf(30B").mangledNameHash());
    ASSERT_EQ(0x0000038bu, ImmutableString("floatBitsToInt(00B").mangledNameHash());
    ASSERT_EQ(0x00000250u, ImmutableString("floatBitsToInt(10B").mangledNameHash());
    ASSERT_EQ(0x00000315u, ImmutableString("floatBitsToInt(20B").mangledNameHash());
    ASSERT_EQ(0x00000140u, ImmutableString("floatBitsToInt(30B").mangledNameHash());
    ASSERT_EQ(0x00000395u, ImmutableString("floatBitsToUint(00B").mangledNameHash());
    ASSERT_EQ(0x000000b6u, ImmutableString("floatBitsToUint(10B").mangledNameHash());
    ASSERT_EQ(0x00000041u, ImmutableString("floatBitsToUint(20B").mangledNameHash());
    ASSERT_EQ(0x0000025du, ImmutableString("floatBitsToUint(30B").mangledNameHash());
    ASSERT_EQ(0x00000063u, ImmutableString("intBitsToFloat(00D").mangledNameHash());
    ASSERT_EQ(0x000001a7u, ImmutableString("intBitsToFloat(10D").mangledNameHash());
    ASSERT_EQ(0x00000174u, ImmutableString("intBitsToFloat(20D").mangledNameHash());
    ASSERT_EQ(0x00000058u, ImmutableString("intBitsToFloat(30D").mangledNameHash());
    ASSERT_EQ(0x0000003bu, ImmutableString("uintBitsToFloat(00E").mangledNameHash());
    ASSERT_EQ(0x00000155u, ImmutableString("uintBitsToFloat(10E").mangledNameHash());
    ASSERT_EQ(0x000002a6u, ImmutableString("uintBitsToFloat(20E").mangledNameHash());
    ASSERT_EQ(0x00000026u, ImmutableString("uintBitsToFloat(30E").mangledNameHash());
    ASSERT_EQ(0x00000093u, ImmutableString("frexp(00B00D").mangledNameHash());
    ASSERT_EQ(0x000001e8u, ImmutableString("frexp(10B10D").mangledNameHash());
    ASSERT_EQ(0x00000173u, ImmutableString("frexp(20B20D").mangledNameHash());
    ASSERT_EQ(0x000001cau, ImmutableString("frexp(30B30D").mangledNameHash());
    ASSERT_EQ(0x00000013u, ImmutableString("ldexp(00B00D").mangledNameHash());
    ASSERT_EQ(0x00000318u, ImmutableString("ldexp(10B10D").mangledNameHash());
    ASSERT_EQ(0x00000350u, ImmutableString("ldexp(20B20D").mangledNameHash());
    ASSERT_EQ(0x0000026eu, ImmutableString("ldexp(30B30D").mangledNameHash());
    ASSERT_EQ(0x0000025cu, ImmutableString("packSnorm2x16(10B").mangledNameHash());
    ASSERT_EQ(0x000002d4u, ImmutableString("packHalf2x16(10B").mangledNameHash());
    ASSERT_EQ(0x000001efu, ImmutableString("unpackSnorm2x16(00E").mangledNameHash());
    ASSERT_EQ(0x00000103u, ImmutableString("unpackHalf2x16(00E").mangledNameHash());
    ASSERT_EQ(0x000002afu, ImmutableString("packUnorm2x16(10B").mangledNameHash());
    ASSERT_EQ(0x0000007cu, ImmutableString("unpackUnorm2x16(00E").mangledNameHash());
    ASSERT_EQ(0x00000091u, ImmutableString("packUnorm4x8(30B").mangledNameHash());
    ASSERT_EQ(0x000002eeu, ImmutableString("packSnorm4x8(30B").mangledNameHash());
    ASSERT_EQ(0x000002a7u, ImmutableString("unpackUnorm4x8(00E").mangledNameHash());
    ASSERT_EQ(0x00000132u, ImmutableString("unpackSnorm4x8(00E").mangledNameHash());
    ASSERT_EQ(0x000001fbu, ImmutableString("length(00B").mangledNameHash());
    ASSERT_EQ(0x000000edu, ImmutableString("length(10B").mangledNameHash());
    ASSERT_EQ(0x0000037eu, ImmutableString("length(20B").mangledNameHash());
    ASSERT_EQ(0x00000248u, ImmutableString("length(30B").mangledNameHash());
    ASSERT_EQ(0x00000234u, ImmutableString("distance(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000152u, ImmutableString("distance(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000019cu, ImmutableString("distance(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000e7u, ImmutableString("distance(30B30B").mangledNameHash());
    ASSERT_EQ(0x000000f0u, ImmutableString("dot(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000102u, ImmutableString("dot(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000032bu, ImmutableString("dot(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000f2u, ImmutableString("dot(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000279u, ImmutableString("cross(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000a7u, ImmutableString("normalize(00B").mangledNameHash());
    ASSERT_EQ(0x000001eeu, ImmutableString("normalize(10B").mangledNameHash());
    ASSERT_EQ(0x000001d5u, ImmutableString("normalize(20B").mangledNameHash());
    ASSERT_EQ(0x00000337u, ImmutableString("normalize(30B").mangledNameHash());
    ASSERT_EQ(0x000002b0u, ImmutableString("faceforward(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000002bbu, ImmutableString("faceforward(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000286u, ImmutableString("faceforward(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000022eu, ImmutableString("faceforward(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000000b2u, ImmutableString("reflect(00B00B").mangledNameHash());
    ASSERT_EQ(0x000000b5u, ImmutableString("reflect(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000153u, ImmutableString("reflect(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000180u, ImmutableString("reflect(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001abu, ImmutableString("refract(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000000d9u, ImmutableString("refract(10B10B00B").mangledNameHash());
    ASSERT_EQ(0x000001a9u, ImmutableString("refract(20B20B00B").mangledNameHash());
    ASSERT_EQ(0x0000021cu, ImmutableString("refract(30B30B00B").mangledNameHash());
    ASSERT_EQ(0x00000367u, ImmutableString("matrixCompMult(50B50B").mangledNameHash());
    ASSERT_EQ(0x00000104u, ImmutableString("matrixCompMult(A0BA0B").mangledNameHash());
    ASSERT_EQ(0x0000027eu, ImmutableString("matrixCompMult(F0BF0B").mangledNameHash());
    ASSERT_EQ(0x00000227u, ImmutableString("matrixCompMult(90B90B").mangledNameHash());
    ASSERT_EQ(0x000001ecu, ImmutableString("matrixCompMult(60B60B").mangledNameHash());
    ASSERT_EQ(0x0000004du, ImmutableString("matrixCompMult(D0BD0B").mangledNameHash());
    ASSERT_EQ(0x0000015cu, ImmutableString("matrixCompMult(70B70B").mangledNameHash());
    ASSERT_EQ(0x000001fau, ImmutableString("matrixCompMult(E0BE0B").mangledNameHash());
    ASSERT_EQ(0x00000277u, ImmutableString("matrixCompMult(B0BB0B").mangledNameHash());
    ASSERT_EQ(0x00000341u, ImmutableString("outerProduct(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000130u, ImmutableString("outerProduct(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000292u, ImmutableString("outerProduct(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000184u, ImmutableString("outerProduct(20B10B").mangledNameHash());
    ASSERT_EQ(0x000000fcu, ImmutableString("outerProduct(10B20B").mangledNameHash());
    ASSERT_EQ(0x0000013fu, ImmutableString("outerProduct(30B10B").mangledNameHash());
    ASSERT_EQ(0x0000020bu, ImmutableString("outerProduct(10B30B").mangledNameHash());
    ASSERT_EQ(0x00000181u, ImmutableString("outerProduct(30B20B").mangledNameHash());
    ASSERT_EQ(0x00000019u, ImmutableString("outerProduct(20B30B").mangledNameHash());
    ASSERT_EQ(0x00000012u, ImmutableString("transpose(50B").mangledNameHash());
    ASSERT_EQ(0x000002fdu, ImmutableString("transpose(A0B").mangledNameHash());
    ASSERT_EQ(0x0000009du, ImmutableString("transpose(F0B").mangledNameHash());
    ASSERT_EQ(0x000002a0u, ImmutableString("transpose(60B").mangledNameHash());
    ASSERT_EQ(0x0000032cu, ImmutableString("transpose(90B").mangledNameHash());
    ASSERT_EQ(0x0000002au, ImmutableString("transpose(70B").mangledNameHash());
    ASSERT_EQ(0x000001b2u, ImmutableString("transpose(D0B").mangledNameHash());
    ASSERT_EQ(0x00000311u, ImmutableString("transpose(B0B").mangledNameHash());
    ASSERT_EQ(0x00000062u, ImmutableString("transpose(E0B").mangledNameHash());
    ASSERT_EQ(0x00000073u, ImmutableString("determinant(50B").mangledNameHash());
    ASSERT_EQ(0x0000000bu, ImmutableString("determinant(A0B").mangledNameHash());
    ASSERT_EQ(0x000002fcu, ImmutableString("determinant(F0B").mangledNameHash());
    ASSERT_EQ(0x00000101u, ImmutableString("inverse(50B").mangledNameHash());
    ASSERT_EQ(0x000001c0u, ImmutableString("inverse(A0B").mangledNameHash());
    ASSERT_EQ(0x000001d9u, ImmutableString("inverse(F0B").mangledNameHash());
    ASSERT_EQ(0x000002ebu, ImmutableString("lessThan(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000074u, ImmutableString("lessThan(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000c3u, ImmutableString("lessThan(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000124u, ImmutableString("lessThan(10D10D").mangledNameHash());
    ASSERT_EQ(0x000000b4u, ImmutableString("lessThan(20D20D").mangledNameHash());
    ASSERT_EQ(0x000001f1u, ImmutableString("lessThan(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000097u, ImmutableString("lessThan(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000278u, ImmutableString("lessThan(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000025u, ImmutableString("lessThan(30E30E").mangledNameHash());
    ASSERT_EQ(0x0000004eu, ImmutableString("lessThanEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000003cu, ImmutableString("lessThanEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000015u, ImmutableString("lessThanEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000342u, ImmutableString("lessThanEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000303u, ImmutableString("lessThanEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x0000025eu, ImmutableString("lessThanEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x0000023du, ImmutableString("lessThanEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000293u, ImmutableString("lessThanEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x000000c9u, ImmutableString("lessThanEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000377u, ImmutableString("greaterThan(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000069u, ImmutableString("greaterThan(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000eau, ImmutableString("greaterThan(30B30B").mangledNameHash());
    ASSERT_EQ(0x000000dcu, ImmutableString("greaterThan(10D10D").mangledNameHash());
    ASSERT_EQ(0x000000e8u, ImmutableString("greaterThan(20D20D").mangledNameHash());
    ASSERT_EQ(0x000000dbu, ImmutableString("greaterThan(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000387u, ImmutableString("greaterThan(10E10E").mangledNameHash());
    ASSERT_EQ(0x000001a4u, ImmutableString("greaterThan(20E20E").mangledNameHash());
    ASSERT_EQ(0x000001e7u, ImmutableString("greaterThan(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000328u, ImmutableString("greaterThanEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000222u, ImmutableString("greaterThanEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x000002dau, ImmutableString("greaterThanEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000015fu, ImmutableString("greaterThanEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000016u, ImmutableString("greaterThanEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000351u, ImmutableString("greaterThanEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000263u, ImmutableString("greaterThanEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000123u, ImmutableString("greaterThanEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000249u, ImmutableString("greaterThanEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x0000036du, ImmutableString("equal(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000179u, ImmutableString("equal(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000036au, ImmutableString("equal(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000052u, ImmutableString("equal(10D10D").mangledNameHash());
    ASSERT_EQ(0x000002b8u, ImmutableString("equal(20D20D").mangledNameHash());
    ASSERT_EQ(0x0000025au, ImmutableString("equal(30D30D").mangledNameHash());
    ASSERT_EQ(0x0000035bu, ImmutableString("equal(10E10E").mangledNameHash());
    ASSERT_EQ(0x0000021fu, ImmutableString("equal(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000029au, ImmutableString("equal(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000157u, ImmutableString("equal(10F10F").mangledNameHash());
    ASSERT_EQ(0x00000368u, ImmutableString("equal(20F20F").mangledNameHash());
    ASSERT_EQ(0x000002deu, ImmutableString("equal(30F30F").mangledNameHash());
    ASSERT_EQ(0x000001f5u, ImmutableString("notEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000352u, ImmutableString("notEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000190u, ImmutableString("notEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x000002acu, ImmutableString("notEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000007u, ImmutableString("notEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x000000d8u, ImmutableString("notEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000365u, ImmutableString("notEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x000001beu, ImmutableString("notEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000023bu, ImmutableString("notEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x0000032fu, ImmutableString("notEqual(10F10F").mangledNameHash());
    ASSERT_EQ(0x00000188u, ImmutableString("notEqual(20F20F").mangledNameHash());
    ASSERT_EQ(0x000002e1u, ImmutableString("notEqual(30F30F").mangledNameHash());
    ASSERT_EQ(0x00000254u, ImmutableString("any(10F").mangledNameHash());
    ASSERT_EQ(0x000001fcu, ImmutableString("any(20F").mangledNameHash());
    ASSERT_EQ(0x000000e6u, ImmutableString("any(30F").mangledNameHash());
    ASSERT_EQ(0x0000027au, ImmutableString("all(10F").mangledNameHash());
    ASSERT_EQ(0x000002ceu, ImmutableString("all(20F").mangledNameHash());
    ASSERT_EQ(0x00000049u, ImmutableString("all(30F").mangledNameHash());
    ASSERT_EQ(0x00000095u, ImmutableString("not(10F").mangledNameHash());
    ASSERT_EQ(0x00000129u, ImmutableString("not(20F").mangledNameHash());
    ASSERT_EQ(0x0000032du, ImmutableString("not(30F").mangledNameHash());
    ASSERT_EQ(0x000002dfu, ImmutableString("bitfieldExtract(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000018au, ImmutableString("bitfieldExtract(10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001f3u, ImmutableString("bitfieldExtract(20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002c2u, ImmutableString("bitfieldExtract(30D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001f7u, ImmutableString("bitfieldExtract(00E00D00D").mangledNameHash());
    ASSERT_EQ(0x000000dfu, ImmutableString("bitfieldExtract(10E00D00D").mangledNameHash());
    ASSERT_EQ(0x000002a5u, ImmutableString("bitfieldExtract(20E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000015du, ImmutableString("bitfieldExtract(30E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000001au, ImmutableString("bitfieldInsert(00D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000339u, ImmutableString("bitfieldInsert(10D10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000042u, ImmutableString("bitfieldInsert(20D20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000d4u, ImmutableString("bitfieldInsert(30D30D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000067u, ImmutableString("bitfieldInsert(00E00E00D00D").mangledNameHash());
    ASSERT_EQ(0x000002edu, ImmutableString("bitfieldInsert(10E10E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000021du, ImmutableString("bitfieldInsert(20E20E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000037fu, ImmutableString("bitfieldInsert(30E30E00D00D").mangledNameHash());
    ASSERT_EQ(0x00000159u, ImmutableString("bitfieldReverse(00D").mangledNameHash());
    ASSERT_EQ(0x00000275u, ImmutableString("bitfieldReverse(10D").mangledNameHash());
    ASSERT_EQ(0x0000004fu, ImmutableString("bitfieldReverse(20D").mangledNameHash());
    ASSERT_EQ(0x0000016du, ImmutableString("bitfieldReverse(30D").mangledNameHash());
    ASSERT_EQ(0x0000015au, ImmutableString("bitfieldReverse(00E").mangledNameHash());
    ASSERT_EQ(0x00000274u, ImmutableString("bitfieldReverse(10E").mangledNameHash());
    ASSERT_EQ(0x00000050u, ImmutableString("bitfieldReverse(20E").mangledNameHash());
    ASSERT_EQ(0x0000016cu, ImmutableString("bitfieldReverse(30E").mangledNameHash());
    ASSERT_EQ(0x00000023u, ImmutableString("bitCount(00D").mangledNameHash());
    ASSERT_EQ(0x00000299u, ImmutableString("bitCount(10D").mangledNameHash());
    ASSERT_EQ(0x00000196u, ImmutableString("bitCount(20D").mangledNameHash());
    ASSERT_EQ(0x0000007au, ImmutableString("bitCount(30D").mangledNameHash());
    ASSERT_EQ(0x000000f3u, ImmutableString("bitCount(00E").mangledNameHash());
    ASSERT_EQ(0x0000014eu, ImmutableString("bitCount(10E").mangledNameHash());
    ASSERT_EQ(0x000002b6u, ImmutableString("bitCount(20E").mangledNameHash());
    ASSERT_EQ(0x00000133u, ImmutableString("bitCount(30E").mangledNameHash());
    ASSERT_EQ(0x000002d7u, ImmutableString("findLSB(00D").mangledNameHash());
    ASSERT_EQ(0x000001acu, ImmutableString("findLSB(10D").mangledNameHash());
    ASSERT_EQ(0x0000008fu, ImmutableString("findLSB(20D").mangledNameHash());
    ASSERT_EQ(0x000002b4u, ImmutableString("findLSB(30D").mangledNameHash());
    ASSERT_EQ(0x000002d6u, ImmutableString("findLSB(00E").mangledNameHash());
    ASSERT_EQ(0x000001adu, ImmutableString("findLSB(10E").mangledNameHash());
    ASSERT_EQ(0x0000008eu, ImmutableString("findLSB(20E").mangledNameHash());
    ASSERT_EQ(0x000002b5u, ImmutableString("findLSB(30E").mangledNameHash());
    ASSERT_EQ(0x000002a1u, ImmutableString("findMSB(00D").mangledNameHash());
    ASSERT_EQ(0x000000efu, ImmutableString("findMSB(10D").mangledNameHash());
    ASSERT_EQ(0x0000012bu, ImmutableString("findMSB(20D").mangledNameHash());
    ASSERT_EQ(0x00000246u, ImmutableString("findMSB(30D").mangledNameHash());
    ASSERT_EQ(0x000002a4u, ImmutableString("findMSB(00E").mangledNameHash());
    ASSERT_EQ(0x000000eeu, ImmutableString("findMSB(10E").mangledNameHash());
    ASSERT_EQ(0x0000012cu, ImmutableString("findMSB(20E").mangledNameHash());
    ASSERT_EQ(0x00000245u, ImmutableString("findMSB(30E").mangledNameHash());
    ASSERT_EQ(0x00000223u, ImmutableString("uaddCarry(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x0000034cu, ImmutableString("uaddCarry(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x00000371u, ImmutableString("uaddCarry(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x0000019eu, ImmutableString("uaddCarry(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x000001c8u, ImmutableString("usubBorrow(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x0000036cu, ImmutableString("usubBorrow(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x000000f6u, ImmutableString("usubBorrow(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x0000026bu, ImmutableString("usubBorrow(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x0000030eu, ImmutableString("umulExtended(00E00E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000185u, ImmutableString("umulExtended(10E10E10E10E").mangledNameHash());
    ASSERT_EQ(0x000002b1u, ImmutableString("umulExtended(20E20E20E20E").mangledNameHash());
    ASSERT_EQ(0x0000022du, ImmutableString("umulExtended(30E30E30E30E").mangledNameHash());
    ASSERT_EQ(0x000001c5u, ImmutableString("imulExtended(00D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000085u, ImmutableString("imulExtended(10D10D10D10D").mangledNameHash());
    ASSERT_EQ(0x000000e5u, ImmutableString("imulExtended(20D20D20D20D").mangledNameHash());
    ASSERT_EQ(0x00000027u, ImmutableString("imulExtended(30D30D30D30D").mangledNameHash());
    ASSERT_EQ(0x00000094u, ImmutableString("texture2D(00I10B").mangledNameHash());
    ASSERT_EQ(0x00000127u, ImmutableString("texture2DProj(00I20B").mangledNameHash());
    ASSERT_EQ(0x00000238u, ImmutableString("texture2DProj(00I30B").mangledNameHash());
    ASSERT_EQ(0x0000020cu, ImmutableString("textureCube(00K20B").mangledNameHash());
    ASSERT_EQ(0x0000033fu, ImmutableString("texture2D(00M10B").mangledNameHash());
    ASSERT_EQ(0x000002a8u, ImmutableString("texture2DProj(00M20B").mangledNameHash());
    ASSERT_EQ(0x000002adu, ImmutableString("texture2DProj(00M30B").mangledNameHash());
    ASSERT_EQ(0x000000e4u, ImmutableString("texture2DRect(00O10B").mangledNameHash());
    ASSERT_EQ(0x0000039cu, ImmutableString("texture2DRectProj(00O20B").mangledNameHash());
    ASSERT_EQ(0x00000107u, ImmutableString("texture2DRectProj(00O30B").mangledNameHash());
    ASSERT_EQ(0x0000009cu, ImmutableString("texture(00O10B").mangledNameHash());
    ASSERT_EQ(0x000000fau, ImmutableString("textureProj(00O20B").mangledNameHash());
    ASSERT_EQ(0x0000021au, ImmutableString("textureProj(00O30B").mangledNameHash());
    ASSERT_EQ(0x00000066u, ImmutableString("texture2DGradEXT(00I10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000002ffu, ImmutableString("texture2DProjGradEXT(00I20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000006cu, ImmutableString("texture2DProjGradEXT(00I30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001ceu, ImmutableString("textureCubeGradEXT(00K20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000001e4u, ImmutableString("texture2D(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x000002d5u, ImmutableString("texture2DProj(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000001cdu, ImmutableString("texture2DProj(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x0000032au, ImmutableString("textureCube(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x0000027du, ImmutableString("dFdx(00B").mangledNameHash());
    ASSERT_EQ(0x0000016au, ImmutableString("dFdx(10B").mangledNameHash());
    ASSERT_EQ(0x00000119u, ImmutableString("dFdx(20B").mangledNameHash());
    ASSERT_EQ(0x00000010u, ImmutableString("dFdx(30B").mangledNameHash());
    ASSERT_EQ(0x00000389u, ImmutableString("dFdy(00B").mangledNameHash());
    ASSERT_EQ(0x0000013eu, ImmutableString("dFdy(10B").mangledNameHash());
    ASSERT_EQ(0x00000194u, ImmutableString("dFdy(20B").mangledNameHash());
    ASSERT_EQ(0x000002cau, ImmutableString("dFdy(30B").mangledNameHash());
    ASSERT_EQ(0x0000013cu, ImmutableString("fwidth(00B").mangledNameHash());
    ASSERT_EQ(0x000000d6u, ImmutableString("fwidth(10B").mangledNameHash());
    ASSERT_EQ(0x00000312u, ImmutableString("fwidth(20B").mangledNameHash());
    ASSERT_EQ(0x0000024au, ImmutableString("fwidth(30B").mangledNameHash());
    ASSERT_EQ(0x000002c9u, ImmutableString("texture2DLodEXT(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x000002e0u, ImmutableString("texture2DProjLodEXT(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x00000192u, ImmutableString("texture2DProjLodEXT(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000349u, ImmutableString("textureCubeLodEXT(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000001b1u, ImmutableString("texture3D(00J20B").mangledNameHash());
    ASSERT_EQ(0x00000276u, ImmutableString("texture3DProj(00J30B").mangledNameHash());
    ASSERT_EQ(0x00000233u, ImmutableString("texture3D(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x0000025bu, ImmutableString("texture3DProj(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x000003a6u, ImmutableString("texture3DLod(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x00000128u, ImmutableString("texture3DProjLod(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x0000028cu, ImmutableString("texture2DLod(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x00000105u, ImmutableString("texture2DProjLod(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x0000036fu, ImmutableString("texture2DProjLod(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000391u, ImmutableString("textureCubeLod(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000001cfu, ImmutableString("texture(00I10B").mangledNameHash());
    ASSERT_EQ(0x00000269u, ImmutableString("texture(00R10B").mangledNameHash());
    ASSERT_EQ(0x000002f9u, ImmutableString("texture(00X10B").mangledNameHash());
    ASSERT_EQ(0x00000117u, ImmutableString("texture(00J20B").mangledNameHash());
    ASSERT_EQ(0x00000183u, ImmutableString("texture(00S20B").mangledNameHash());
    ASSERT_EQ(0x00000090u, ImmutableString("texture(00Y20B").mangledNameHash());
    ASSERT_EQ(0x0000031fu, ImmutableString("texture(00K20B").mangledNameHash());
    ASSERT_EQ(0x00000089u, ImmutableString("texture(00T20B").mangledNameHash());
    ASSERT_EQ(0x00000044u, ImmutableString("texture(00Z20B").mangledNameHash());
    ASSERT_EQ(0x00000120u, ImmutableString("texture(00L20B").mangledNameHash());
    ASSERT_EQ(0x000000ddu, ImmutableString("texture(00U20B").mangledNameHash());
    ASSERT_EQ(0x00000235u, ImmutableString("texture(00a20B").mangledNameHash());
    ASSERT_EQ(0x0000002fu, ImmutableString("texture(00d20B").mangledNameHash());
    ASSERT_EQ(0x00000358u, ImmutableString("texture(00e30B").mangledNameHash());
    ASSERT_EQ(0x00000331u, ImmutableString("texture(00f30B").mangledNameHash());
    ASSERT_EQ(0x00000059u, ImmutableString("textureProj(00I20B").mangledNameHash());
    ASSERT_EQ(0x00000384u, ImmutableString("textureProj(00R20B").mangledNameHash());
    ASSERT_EQ(0x0000011au, ImmutableString("textureProj(00X20B").mangledNameHash());
    ASSERT_EQ(0x00000213u, ImmutableString("textureProj(00I30B").mangledNameHash());
    ASSERT_EQ(0x00000366u, ImmutableString("textureProj(00R30B").mangledNameHash());
    ASSERT_EQ(0x0000037cu, ImmutableString("textureProj(00X30B").mangledNameHash());
    ASSERT_EQ(0x00000141u, ImmutableString("textureProj(00J30B").mangledNameHash());
    ASSERT_EQ(0x000002c7u, ImmutableString("textureProj(00S30B").mangledNameHash());
    ASSERT_EQ(0x00000195u, ImmutableString("textureProj(00Y30B").mangledNameHash());
    ASSERT_EQ(0x000002fau, ImmutableString("textureProj(00d30B").mangledNameHash());
    ASSERT_EQ(0x0000015eu, ImmutableString("textureLod(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x00000281u, ImmutableString("textureLod(00R10B00B").mangledNameHash());
    ASSERT_EQ(0x00000294u, ImmutableString("textureLod(00X10B00B").mangledNameHash());
    ASSERT_EQ(0x000000b7u, ImmutableString("textureLod(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x00000304u, ImmutableString("textureLod(00S20B00B").mangledNameHash());
    ASSERT_EQ(0x00000035u, ImmutableString("textureLod(00Y20B00B").mangledNameHash());
    ASSERT_EQ(0x00000397u, ImmutableString("textureLod(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000000f5u, ImmutableString("textureLod(00T20B00B").mangledNameHash());
    ASSERT_EQ(0x0000029du, ImmutableString("textureLod(00Z20B00B").mangledNameHash());
    ASSERT_EQ(0x00000009u, ImmutableString("textureLod(00L20B00B").mangledNameHash());
    ASSERT_EQ(0x0000036bu, ImmutableString("textureLod(00U20B00B").mangledNameHash());
    ASSERT_EQ(0x00000253u, ImmutableString("textureLod(00a20B00B").mangledNameHash());
    ASSERT_EQ(0x00000145u, ImmutableString("textureLod(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x000000bdu, ImmutableString("textureSize(00I00D").mangledNameHash());
    ASSERT_EQ(0x000000a5u, ImmutableString("textureSize(00R00D").mangledNameHash());
    ASSERT_EQ(0x00000376u, ImmutableString("textureSize(00X00D").mangledNameHash());
    ASSERT_EQ(0x000001b8u, ImmutableString("textureSize(00J00D").mangledNameHash());
    ASSERT_EQ(0x00000326u, ImmutableString("textureSize(00S00D").mangledNameHash());
    ASSERT_EQ(0x0000002du, ImmutableString("textureSize(00Y00D").mangledNameHash());
    ASSERT_EQ(0x00000028u, ImmutableString("textureSize(00K00D").mangledNameHash());
    ASSERT_EQ(0x00000359u, ImmutableString("textureSize(00T00D").mangledNameHash());
    ASSERT_EQ(0x000002c0u, ImmutableString("textureSize(00Z00D").mangledNameHash());
    ASSERT_EQ(0x000002bcu, ImmutableString("textureSize(00L00D").mangledNameHash());
    ASSERT_EQ(0x000002dbu, ImmutableString("textureSize(00U00D").mangledNameHash());
    ASSERT_EQ(0x000000deu, ImmutableString("textureSize(00a00D").mangledNameHash());
    ASSERT_EQ(0x00000346u, ImmutableString("textureSize(00d00D").mangledNameHash());
    ASSERT_EQ(0x000001bdu, ImmutableString("textureSize(00e00D").mangledNameHash());
    ASSERT_EQ(0x000002f3u, ImmutableString("textureSize(00f00D").mangledNameHash());
    ASSERT_EQ(0x0000007bu, ImmutableString("textureProjLod(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000000d7u, ImmutableString("textureProjLod(00R20B00B").mangledNameHash());
    ASSERT_EQ(0x0000022au, ImmutableString("textureProjLod(00X20B00B").mangledNameHash());
    ASSERT_EQ(0x000001aau, ImmutableString("textureProjLod(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x000001dbu, ImmutableString("textureProjLod(00R30B00B").mangledNameHash());
    ASSERT_EQ(0x0000002cu, ImmutableString("textureProjLod(00X30B00B").mangledNameHash());
    ASSERT_EQ(0x000000e3u, ImmutableString("textureProjLod(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x000000b9u, ImmutableString("textureProjLod(00S30B00B").mangledNameHash());
    ASSERT_EQ(0x00000305u, ImmutableString("textureProjLod(00Y30B00B").mangledNameHash());
    ASSERT_EQ(0x00000228u, ImmutableString("textureProjLod(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x0000005au, ImmutableString("texelFetch(00I10D00D").mangledNameHash());
    ASSERT_EQ(0x00000334u, ImmutableString("texelFetch(00R10D00D").mangledNameHash());
    ASSERT_EQ(0x00000289u, ImmutableString("texelFetch(00X10D00D").mangledNameHash());
    ASSERT_EQ(0x00000393u, ImmutableString("texelFetch(00J20D00D").mangledNameHash());
    ASSERT_EQ(0x0000024du, ImmutableString("texelFetch(00S20D00D").mangledNameHash());
    ASSERT_EQ(0x0000006bu, ImmutableString("texelFetch(00Y20D00D").mangledNameHash());
    ASSERT_EQ(0x00000198u, ImmutableString("texelFetch(00L20D00D").mangledNameHash());
    ASSERT_EQ(0x00000147u, ImmutableString("texelFetch(00U20D00D").mangledNameHash());
    ASSERT_EQ(0x00000038u, ImmutableString("texelFetch(00a20D00D").mangledNameHash());
    ASSERT_EQ(0x00000021u, ImmutableString("textureGrad(00I10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000033cu, ImmutableString("textureGrad(00R10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000247u, ImmutableString("textureGrad(00X10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001b4u, ImmutableString("textureGrad(00J20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000109u, ImmutableString("textureGrad(00S20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000112u, ImmutableString("textureGrad(00Y20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000024bu, ImmutableString("textureGrad(00K20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000035eu, ImmutableString("textureGrad(00T20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000156u, ImmutableString("textureGrad(00Z20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000006du, ImmutableString("textureGrad(00d20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000242u, ImmutableString("textureGrad(00e30B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000033bu, ImmutableString("textureGrad(00L20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000019du, ImmutableString("textureGrad(00U20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001a5u, ImmutableString("textureGrad(00a20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000237u, ImmutableString("textureGrad(00f30B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000033du, ImmutableString("textureProjGrad(00I20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000330u, ImmutableString("textureProjGrad(00R20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001c2u, ImmutableString("textureProjGrad(00X20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000000cu, ImmutableString("textureProjGrad(00I30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000000f8u, ImmutableString("textureProjGrad(00R30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000003a2u, ImmutableString("textureProjGrad(00X30B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000013du, ImmutableString("textureProjGrad(00J30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000051u, ImmutableString("textureProjGrad(00S30B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000001bu, ImmutableString("textureProjGrad(00Y30B20B20B").mangledNameHash());
    ASSERT_EQ(0x000001b5u, ImmutableString("textureProjGrad(00d30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001dcu, ImmutableString("textureSize(00P").mangledNameHash());
    ASSERT_EQ(0x000002aeu, ImmutableString("textureSize(00V").mangledNameHash());
    ASSERT_EQ(0x0000020eu, ImmutableString("textureSize(00b").mangledNameHash());
    ASSERT_EQ(0x00000225u, ImmutableString("textureSize(00Q").mangledNameHash());
    ASSERT_EQ(0x00000229u, ImmutableString("textureSize(00W").mangledNameHash());
    ASSERT_EQ(0x0000020du, ImmutableString("textureSize(00c").mangledNameHash());
    ASSERT_EQ(0x00000096u, ImmutableString("texelFetch(00P10D00D").mangledNameHash());
    ASSERT_EQ(0x0000012fu, ImmutableString("texelFetch(00V10D00D").mangledNameHash());
    ASSERT_EQ(0x0000028du, ImmutableString("texelFetch(00b10D00D").mangledNameHash());
    ASSERT_EQ(0x000002c5u, ImmutableString("texelFetch(00Q20D00D").mangledNameHash());
    ASSERT_EQ(0x00000106u, ImmutableString("texelFetch(00W20D00D").mangledNameHash());
    ASSERT_EQ(0x000001d2u, ImmutableString("texelFetch(00c20D00D").mangledNameHash());
    ASSERT_EQ(0x000000b1u, ImmutableString("texture(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x00000004u, ImmutableString("texture(00R10B00B").mangledNameHash());
    ASSERT_EQ(0x00000092u, ImmutableString("texture(00X10B00B").mangledNameHash());
    ASSERT_EQ(0x000001a8u, ImmutableString("texture(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x0000014fu, ImmutableString("texture(00S20B00B").mangledNameHash());
    ASSERT_EQ(0x0000018fu, ImmutableString("texture(00Y20B00B").mangledNameHash());
    ASSERT_EQ(0x000001a0u, ImmutableString("texture(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000000c7u, ImmutableString("texture(00T20B00B").mangledNameHash());
    ASSERT_EQ(0x00000186u, ImmutableString("texture(00Z20B00B").mangledNameHash());
    ASSERT_EQ(0x000001f4u, ImmutableString("texture(00L20B00B").mangledNameHash());
    ASSERT_EQ(0x00000182u, ImmutableString("texture(00U20B00B").mangledNameHash());
    ASSERT_EQ(0x0000038eu, ImmutableString("texture(00a20B00B").mangledNameHash());
    ASSERT_EQ(0x00000386u, ImmutableString("textureProj(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x00000285u, ImmutableString("textureProj(00R20B00B").mangledNameHash());
    ASSERT_EQ(0x000001e5u, ImmutableString("textureProj(00X20B00B").mangledNameHash());
    ASSERT_EQ(0x000000aau, ImmutableString("textureProj(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000000u, ImmutableString("textureProj(00R30B00B").mangledNameHash());
    ASSERT_EQ(0x000001ffu, ImmutableString("textureProj(00X30B00B").mangledNameHash());
    ASSERT_EQ(0x00000030u, ImmutableString("textureProj(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x00000111u, ImmutableString("textureProj(00S30B00B").mangledNameHash());
    ASSERT_EQ(0x000001b0u, ImmutableString("textureProj(00Y30B00B").mangledNameHash());
    ASSERT_EQ(0x000002abu, ImmutableString("texture(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x00000160u, ImmutableString("texture(00e30B00B").mangledNameHash());
    ASSERT_EQ(0x000002f7u, ImmutableString("textureProj(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x0000038fu, ImmutableString("texture(00M10B00B").mangledNameHash());
    ASSERT_EQ(0x00000394u, ImmutableString("textureProj(00M20B00B").mangledNameHash());
    ASSERT_EQ(0x000000afu, ImmutableString("textureProj(00M30B00B").mangledNameHash());
    ASSERT_EQ(0x00000001u, ImmutableString("texture(00N10B00B").mangledNameHash());
    ASSERT_EQ(0x000002f4u, ImmutableString("textureProj(00N20B00B").mangledNameHash());
    ASSERT_EQ(0x000000a4u, ImmutableString("textureProj(00N30B00B").mangledNameHash());
    ASSERT_EQ(0x000000a8u, ImmutableString("textureOffset(00I10B10D").mangledNameHash());
    ASSERT_EQ(0x00000262u, ImmutableString("textureOffset(00R10B10D").mangledNameHash());
    ASSERT_EQ(0x00000266u, ImmutableString("textureOffset(00X10B10D").mangledNameHash());
    ASSERT_EQ(0x00000392u, ImmutableString("textureOffset(00J20B20D").mangledNameHash());
    ASSERT_EQ(0x00000380u, ImmutableString("textureOffset(00S20B20D").mangledNameHash());
    ASSERT_EQ(0x0000029fu, ImmutableString("textureOffset(00Y20B20D").mangledNameHash());
    ASSERT_EQ(0x0000000fu, ImmutableString("textureOffset(00d20B10D").mangledNameHash());
    ASSERT_EQ(0x000000c8u, ImmutableString("textureOffset(00L20B10D").mangledNameHash());
    ASSERT_EQ(0x0000006fu, ImmutableString("textureOffset(00U20B10D").mangledNameHash());
    ASSERT_EQ(0x000000e9u, ImmutableString("textureOffset(00a20B10D").mangledNameHash());
    ASSERT_EQ(0x000000dau, ImmutableString("textureProjOffset(00I20B10D").mangledNameHash());
    ASSERT_EQ(0x000000a1u, ImmutableString("textureProjOffset(00R20B10D").mangledNameHash());
    ASSERT_EQ(0x00000381u, ImmutableString("textureProjOffset(00X20B10D").mangledNameHash());
    ASSERT_EQ(0x0000016bu, ImmutableString("textureProjOffset(00I30B10D").mangledNameHash());
    ASSERT_EQ(0x0000006eu, ImmutableString("textureProjOffset(00R30B10D").mangledNameHash());
    ASSERT_EQ(0x000002d8u, ImmutableString("textureProjOffset(00X30B10D").mangledNameHash());
    ASSERT_EQ(0x00000360u, ImmutableString("textureProjOffset(00J30B20D").mangledNameHash());
    ASSERT_EQ(0x000000ceu, ImmutableString("textureProjOffset(00S30B20D").mangledNameHash());
    ASSERT_EQ(0x00000321u, ImmutableString("textureProjOffset(00Y30B20D").mangledNameHash());
    ASSERT_EQ(0x00000364u, ImmutableString("textureProjOffset(00d30B10D").mangledNameHash());
    ASSERT_EQ(0x0000006au, ImmutableString("textureLodOffset(00I10B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000099u, ImmutableString("textureLodOffset(00R10B00B10D").mangledNameHash());
    ASSERT_EQ(0x000000c6u, ImmutableString("textureLodOffset(00X10B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000023fu, ImmutableString("textureLodOffset(00J20B00B20D").mangledNameHash());
    ASSERT_EQ(0x0000005eu, ImmutableString("textureLodOffset(00S20B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000161u, ImmutableString("textureLodOffset(00Y20B00B20D").mangledNameHash());
    ASSERT_EQ(0x000001bfu, ImmutableString("textureLodOffset(00d20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000034eu, ImmutableString("textureLodOffset(00L20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000284u, ImmutableString("textureLodOffset(00U20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000036u, ImmutableString("textureLodOffset(00a20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000032eu, ImmutableString("textureProjLodOffset(00I20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000134u, ImmutableString("textureProjLodOffset(00R20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000017au, ImmutableString("textureProjLodOffset(00X20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000336u, ImmutableString("textureProjLodOffset(00I30B00B10D").mangledNameHash());
    ASSERT_EQ(0x000001deu, ImmutableString("textureProjLodOffset(00R30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000354u, ImmutableString("textureProjLodOffset(00X30B00B10D").mangledNameHash());
    ASSERT_EQ(0x000001c9u, ImmutableString("textureProjLodOffset(00J30B00B20D").mangledNameHash());
    ASSERT_EQ(0x0000017du, ImmutableString("textureProjLodOffset(00S30B00B20D").mangledNameHash());
    ASSERT_EQ(0x000001bcu, ImmutableString("textureProjLodOffset(00Y30B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000333u, ImmutableString("textureProjLodOffset(00d30B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000012du, ImmutableString("texelFetchOffset(00I10D00D10D").mangledNameHash());
    ASSERT_EQ(0x000000c0u, ImmutableString("texelFetchOffset(00R10D00D10D").mangledNameHash());
    ASSERT_EQ(0x000002a9u, ImmutableString("texelFetchOffset(00X10D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000205u, ImmutableString("texelFetchOffset(00J20D00D20D").mangledNameHash());
    ASSERT_EQ(0x0000011eu, ImmutableString("texelFetchOffset(00S20D00D20D").mangledNameHash());
    ASSERT_EQ(0x00000037u, ImmutableString("texelFetchOffset(00Y20D00D20D").mangledNameHash());
    ASSERT_EQ(0x00000259u, ImmutableString("texelFetchOffset(00L20D00D10D").mangledNameHash());
    ASSERT_EQ(0x000001bbu, ImmutableString("texelFetchOffset(00U20D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000125u, ImmutableString("texelFetchOffset(00a20D00D10D").mangledNameHash());
    ASSERT_EQ(0x0000023au, ImmutableString("textureGradOffset(00I10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000002dcu, ImmutableString("textureGradOffset(00R10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000083u, ImmutableString("textureGradOffset(00X10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000064u, ImmutableString("textureGradOffset(00J20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x0000009fu, ImmutableString("textureGradOffset(00S20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x0000022fu, ImmutableString("textureGradOffset(00Y20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x000001ddu, ImmutableString("textureGradOffset(00d20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000324u, ImmutableString("textureGradOffset(00L20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000024eu, ImmutableString("textureGradOffset(00U20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000187u, ImmutableString("textureGradOffset(00a20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000211u, ImmutableString("textureGradOffset(00f30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000036eu,
              ImmutableString("textureProjGradOffset(00I20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000056u,
              ImmutableString("textureProjGradOffset(00R20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000126u,
              ImmutableString("textureProjGradOffset(00X20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000264u,
              ImmutableString("textureProjGradOffset(00I30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000396u,
              ImmutableString("textureProjGradOffset(00R30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000000feu,
              ImmutableString("textureProjGradOffset(00X30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000003a0u,
              ImmutableString("textureProjGradOffset(00J30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000115u,
              ImmutableString("textureProjGradOffset(00S30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x0000035du,
              ImmutableString("textureProjGradOffset(00Y30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000255u,
              ImmutableString("textureProjGradOffset(00d30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000000ffu, ImmutableString("textureOffset(00I10B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000241u, ImmutableString("textureOffset(00R10B10D00B").mangledNameHash());
    ASSERT_EQ(0x000002b2u, ImmutableString("textureOffset(00X10B10D00B").mangledNameHash());
    ASSERT_EQ(0x000000cau, ImmutableString("textureOffset(00J20B20D00B").mangledNameHash());
    ASSERT_EQ(0x0000026au, ImmutableString("textureOffset(00S20B20D00B").mangledNameHash());
    ASSERT_EQ(0x0000009eu, ImmutableString("textureOffset(00Y20B20D00B").mangledNameHash());
    ASSERT_EQ(0x00000268u, ImmutableString("textureOffset(00d20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000000c5u, ImmutableString("textureOffset(00L20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000001a6u, ImmutableString("textureOffset(00U20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000215u, ImmutableString("textureOffset(00a20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000078u, ImmutableString("textureProjOffset(00I20B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000026du, ImmutableString("textureProjOffset(00R20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000000fbu, ImmutableString("textureProjOffset(00X20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000345u, ImmutableString("textureProjOffset(00I30B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000388u, ImmutableString("textureProjOffset(00R30B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000398u, ImmutableString("textureProjOffset(00X30B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000048u, ImmutableString("textureProjOffset(00J30B20D00B").mangledNameHash());
    ASSERT_EQ(0x0000002bu, ImmutableString("textureProjOffset(00S30B20D00B").mangledNameHash());
    ASSERT_EQ(0x000002b9u, ImmutableString("textureProjOffset(00Y30B20D00B").mangledNameHash());
    ASSERT_EQ(0x00000362u, ImmutableString("textureProjOffset(00d30B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000087u, ImmutableString("texture(00M10B").mangledNameHash());
    ASSERT_EQ(0x000000b0u, ImmutableString("textureProj(00M20B").mangledNameHash());
    ASSERT_EQ(0x0000030au, ImmutableString("textureProj(00M30B").mangledNameHash());
    ASSERT_EQ(0x00000316u, ImmutableString("textureSize(00M00D").mangledNameHash());
    ASSERT_EQ(0x0000009bu, ImmutableString("texelFetch(00M10D00D").mangledNameHash());
    ASSERT_EQ(0x0000011fu, ImmutableString("texture(00N10B").mangledNameHash());
    ASSERT_EQ(0x0000034bu, ImmutableString("textureProj(00N20B").mangledNameHash());
    ASSERT_EQ(0x00000256u, ImmutableString("textureProj(00N30B").mangledNameHash());
    ASSERT_EQ(0x0000007du, ImmutableString("rgb_2_yuv(20B00H").mangledNameHash());
    ASSERT_EQ(0x000001a2u, ImmutableString("yuv_2_rgb(20B00H").mangledNameHash());
    ASSERT_EQ(0x00000204u, ImmutableString("textureSize(00N00D").mangledNameHash());
    ASSERT_EQ(0x0000003du, ImmutableString("texelFetch(00N10D00D").mangledNameHash());
    ASSERT_EQ(0x0000023cu, ImmutableString("textureGather(00I10B").mangledNameHash());
    ASSERT_EQ(0x00000302u, ImmutableString("textureGather(00R10B").mangledNameHash());
    ASSERT_EQ(0x00000216u, ImmutableString("textureGather(00X10B").mangledNameHash());
    ASSERT_EQ(0x0000012eu, ImmutableString("textureGather(00I10B00D").mangledNameHash());
    ASSERT_EQ(0x000002beu, ImmutableString("textureGather(00R10B00D").mangledNameHash());
    ASSERT_EQ(0x000001bau, ImmutableString("textureGather(00X10B00D").mangledNameHash());
    ASSERT_EQ(0x0000017fu, ImmutableString("textureGather(00L20B").mangledNameHash());
    ASSERT_EQ(0x000002c1u, ImmutableString("textureGather(00U20B").mangledNameHash());
    ASSERT_EQ(0x00000218u, ImmutableString("textureGather(00a20B").mangledNameHash());
    ASSERT_EQ(0x00000114u, ImmutableString("textureGather(00L20B00D").mangledNameHash());
    ASSERT_EQ(0x000002f2u, ImmutableString("textureGather(00U20B00D").mangledNameHash());
    ASSERT_EQ(0x0000039fu, ImmutableString("textureGather(00a20B00D").mangledNameHash());
    ASSERT_EQ(0x000000d3u, ImmutableString("textureGather(00K20B").mangledNameHash());
    ASSERT_EQ(0x0000039eu, ImmutableString("textureGather(00T20B").mangledNameHash());
    ASSERT_EQ(0x00000265u, ImmutableString("textureGather(00Z20B").mangledNameHash());
    ASSERT_EQ(0x00000014u, ImmutableString("textureGather(00K20B00D").mangledNameHash());
    ASSERT_EQ(0x0000034au, ImmutableString("textureGather(00T20B00D").mangledNameHash());
    ASSERT_EQ(0x00000301u, ImmutableString("textureGather(00Z20B00D").mangledNameHash());
    ASSERT_EQ(0x00000172u, ImmutableString("textureGather(00d10B").mangledNameHash());
    ASSERT_EQ(0x00000379u, ImmutableString("textureGather(00d10B00B").mangledNameHash());
    ASSERT_EQ(0x00000137u, ImmutableString("textureGather(00f20B").mangledNameHash());
    ASSERT_EQ(0x000001a3u, ImmutableString("textureGather(00f20B00B").mangledNameHash());
    ASSERT_EQ(0x0000033eu, ImmutableString("textureGather(00e20B").mangledNameHash());
    ASSERT_EQ(0x00000150u, ImmutableString("textureGather(00e20B00B").mangledNameHash());
    ASSERT_EQ(0x000000c4u, ImmutableString("textureGatherOffset(00I10B10D").mangledNameHash());
    ASSERT_EQ(0x0000005fu, ImmutableString("textureGatherOffset(00R10B10D").mangledNameHash());
    ASSERT_EQ(0x000002ecu, ImmutableString("textureGatherOffset(00X10B10D").mangledNameHash());
    ASSERT_EQ(0x000001b9u, ImmutableString("textureGatherOffset(00I10B10D00D").mangledNameHash());
    ASSERT_EQ(0x000001e1u, ImmutableString("textureGatherOffset(00R10B10D00D").mangledNameHash());
    ASSERT_EQ(0x0000035au, ImmutableString("textureGatherOffset(00X10B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000252u, ImmutableString("textureGatherOffset(00L20B10D").mangledNameHash());
    ASSERT_EQ(0x000002bau, ImmutableString("textureGatherOffset(00U20B10D").mangledNameHash());
    ASSERT_EQ(0x00000236u, ImmutableString("textureGatherOffset(00a20B10D").mangledNameHash());
    ASSERT_EQ(0x00000022u, ImmutableString("textureGatherOffset(00L20B10D00D").mangledNameHash());
    ASSERT_EQ(0x000000e1u, ImmutableString("textureGatherOffset(00U20B10D00D").mangledNameHash());
    ASSERT_EQ(0x000000c2u, ImmutableString("textureGatherOffset(00a20B10D00D").mangledNameHash());
    ASSERT_EQ(0x0000021bu, ImmutableString("textureGatherOffset(00d10B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000291u, ImmutableString("textureGatherOffset(00f20B00B10D").mangledNameHash());
    ASSERT_EQ(0x000000cdu, ImmutableString("atomicCounter(00G").mangledNameHash());
    ASSERT_EQ(0x0000034fu, ImmutableString("atomicCounterIncrement(00G").mangledNameHash());
    ASSERT_EQ(0x00000329u, ImmutableString("atomicCounterDecrement(00G").mangledNameHash());
    ASSERT_EQ(0x00000243u, ImmutableString("atomicAdd(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000003eu, ImmutableString("atomicAdd(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000014cu, ImmutableString("atomicMin(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000375u, ImmutableString("atomicMin(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000373u, ImmutableString("atomicMax(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000200u, ImmutableString("atomicMax(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000bbu, ImmutableString("atomicAnd(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000075u, ImmutableString("atomicAnd(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000adu, ImmutableString("atomicOr(00E00E").mangledNameHash());
    ASSERT_EQ(0x000003a5u, ImmutableString("atomicOr(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000a0u, ImmutableString("atomicXor(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000068u, ImmutableString("atomicXor(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000a9u, ImmutableString("atomicExchange(00E00E").mangledNameHash());
    ASSERT_EQ(0x000001e0u, ImmutableString("atomicExchange(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000320u, ImmutableString("atomicCompSwap(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x000001f8u, ImmutableString("atomicCompSwap(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000199u, ImmutableString("imageSize(00y").mangledNameHash());
    ASSERT_EQ(0x0000019bu, ImmutableString("imageSize(00z").mangledNameHash());
    ASSERT_EQ(0x0000028bu, ImmutableString("imageSize(01A").mangledNameHash());
    ASSERT_EQ(0x00000221u, ImmutableString("imageSize(01B").mangledNameHash());
    ASSERT_EQ(0x000002d9u, ImmutableString("imageSize(01C").mangledNameHash());
    ASSERT_EQ(0x00000297u, ImmutableString("imageSize(01D").mangledNameHash());
    ASSERT_EQ(0x00000287u, ImmutableString("imageSize(01E").mangledNameHash());
    ASSERT_EQ(0x0000028eu, ImmutableString("imageSize(01F").mangledNameHash());
    ASSERT_EQ(0x000002ddu, ImmutableString("imageSize(01G").mangledNameHash());
    ASSERT_EQ(0x000002d2u, ImmutableString("imageSize(01H").mangledNameHash());
    ASSERT_EQ(0x000002d3u, ImmutableString("imageSize(01I").mangledNameHash());
    ASSERT_EQ(0x000002d1u, ImmutableString("imageSize(01J").mangledNameHash());
    ASSERT_EQ(0x00000260u, ImmutableString("imageLoad(00y10D").mangledNameHash());
    ASSERT_EQ(0x000001f0u, ImmutableString("imageLoad(00z10D").mangledNameHash());
    ASSERT_EQ(0x00000057u, ImmutableString("imageLoad(01A10D").mangledNameHash());
    ASSERT_EQ(0x000002f6u, ImmutableString("imageLoad(01B20D").mangledNameHash());
    ASSERT_EQ(0x000002d0u, ImmutableString("imageLoad(01C20D").mangledNameHash());
    ASSERT_EQ(0x00000353u, ImmutableString("imageLoad(01D20D").mangledNameHash());
    ASSERT_EQ(0x000002f0u, ImmutableString("imageLoad(01E20D").mangledNameHash());
    ASSERT_EQ(0x0000003au, ImmutableString("imageLoad(01F20D").mangledNameHash());
    ASSERT_EQ(0x000001f6u, ImmutableString("imageLoad(01G20D").mangledNameHash());
    ASSERT_EQ(0x000000d2u, ImmutableString("imageLoad(01H20D").mangledNameHash());
    ASSERT_EQ(0x000000cfu, ImmutableString("imageLoad(01I20D").mangledNameHash());
    ASSERT_EQ(0x00000208u, ImmutableString("imageLoad(01J20D").mangledNameHash());
    ASSERT_EQ(0x000001e2u, ImmutableString("imageStore(00y10D30B").mangledNameHash());
    ASSERT_EQ(0x000000f7u, ImmutableString("imageStore(00z10D30D").mangledNameHash());
    ASSERT_EQ(0x00000116u, ImmutableString("imageStore(01A10D30E").mangledNameHash());
    ASSERT_EQ(0x00000080u, ImmutableString("imageStore(01B20D30B").mangledNameHash());
    ASSERT_EQ(0x000002e5u, ImmutableString("imageStore(01C20D30D").mangledNameHash());
    ASSERT_EQ(0x00000327u, ImmutableString("imageStore(01D20D30E").mangledNameHash());
    ASSERT_EQ(0x000001c1u, ImmutableString("imageStore(01E20D30B").mangledNameHash());
    ASSERT_EQ(0x00000385u, ImmutableString("imageStore(01F20D30D").mangledNameHash());
    ASSERT_EQ(0x000000d5u, ImmutableString("imageStore(01G20D30E").mangledNameHash());
    ASSERT_EQ(0x000002c4u, ImmutableString("imageStore(01H20D30B").mangledNameHash());
    ASSERT_EQ(0x0000005cu, ImmutableString("imageStore(01I20D30D").mangledNameHash());
    ASSERT_EQ(0x0000010bu, ImmutableString("imageStore(01J20D30E").mangledNameHash());
    ASSERT_EQ(0x000001fdu, ImmutableString("memoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x00000065u, ImmutableString("memoryBarrierAtomicCounter(").mangledNameHash());
    ASSERT_EQ(0x000002bfu, ImmutableString("memoryBarrierBuffer(").mangledNameHash());
    ASSERT_EQ(0x0000035fu, ImmutableString("memoryBarrierImage(").mangledNameHash());
    ASSERT_EQ(0x00000121u, ImmutableString("barrier(").mangledNameHash());
    ASSERT_EQ(0x000001edu, ImmutableString("memoryBarrierShared(").mangledNameHash());
    ASSERT_EQ(0x00000054u, ImmutableString("groupMemoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x00000361u, ImmutableString("EmitVertex(").mangledNameHash());
    ASSERT_EQ(0x00000034u, ImmutableString("EndPrimitive(").mangledNameHash());
    ASSERT_EQ(0x00000151u, ImmutableString("gl_DepthRangeParameters").mangledNameHash());
    ASSERT_EQ(0x00000084u, ImmutableString("gl_DepthRange").mangledNameHash());
    ASSERT_EQ(0x0000030fu, ImmutableString("gl_MaxVertexAttribs").mangledNameHash());
    ASSERT_EQ(0x00000348u, ImmutableString("gl_MaxVertexUniformVectors").mangledNameHash());
    ASSERT_EQ(0x00000043u, ImmutableString("gl_MaxVertexTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000014du, ImmutableString("gl_MaxCombinedTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000031du, ImmutableString("gl_MaxTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x000002e8u, ImmutableString("gl_MaxFragmentUniformVectors").mangledNameHash());
    ASSERT_EQ(0x00000344u, ImmutableString("gl_MaxVaryingVectors").mangledNameHash());
    ASSERT_EQ(0x000000e0u, ImmutableString("gl_MaxDrawBuffers").mangledNameHash());
    ASSERT_EQ(0x00000272u, ImmutableString("gl_MaxDualSourceDrawBuffersEXT").mangledNameHash());
    ASSERT_EQ(0x00000088u, ImmutableString("gl_MaxVertexOutputVectors").mangledNameHash());
    ASSERT_EQ(0x00000369u, ImmutableString("gl_MaxFragmentInputVectors").mangledNameHash());
    ASSERT_EQ(0x0000002eu, ImmutableString("gl_MinProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x00000257u, ImmutableString("gl_MaxProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x0000008cu, ImmutableString("gl_MaxImageUnits").mangledNameHash());
    ASSERT_EQ(0x000001d3u, ImmutableString("gl_MaxVertexImageUniforms").mangledNameHash());
    ASSERT_EQ(0x000000a6u, ImmutableString("gl_MaxFragmentImageUniforms").mangledNameHash());
    ASSERT_EQ(0x00000008u, ImmutableString("gl_MaxComputeImageUniforms").mangledNameHash());
    ASSERT_EQ(0x000001a1u, ImmutableString("gl_MaxCombinedImageUniforms").mangledNameHash());
    ASSERT_EQ(0x000000acu,
              ImmutableString("gl_MaxCombinedShaderOutputResources").mangledNameHash());
    ASSERT_EQ(0x000000e2u, ImmutableString("gl_MaxComputeWorkGroupCount").mangledNameHash());
    ASSERT_EQ(0x00000148u, ImmutableString("gl_MaxComputeWorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x000002bdu, ImmutableString("gl_MaxComputeUniformComponents").mangledNameHash());
    ASSERT_EQ(0x0000010du, ImmutableString("gl_MaxComputeTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000037bu, ImmutableString("gl_MaxComputeAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x000000beu, ImmutableString("gl_MaxComputeAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000037du, ImmutableString("gl_MaxVertexAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000283u, ImmutableString("gl_MaxFragmentAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000113u, ImmutableString("gl_MaxCombinedAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000006u, ImmutableString("gl_MaxAtomicCounterBindings").mangledNameHash());
    ASSERT_EQ(0x0000005du, ImmutableString("gl_MaxVertexAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x000001d6u, ImmutableString("gl_MaxFragmentAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000022bu, ImmutableString("gl_MaxCombinedAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000028fu, ImmutableString("gl_MaxAtomicCounterBufferSize").mangledNameHash());
    ASSERT_EQ(0x00000244u, ImmutableString("gl_MaxGeometryInputComponents").mangledNameHash());
    ASSERT_EQ(0x0000003fu, ImmutableString("gl_MaxGeometryOutputComponents").mangledNameHash());
    ASSERT_EQ(0x0000025fu, ImmutableString("gl_MaxGeometryImageUniforms").mangledNameHash());
    ASSERT_EQ(0x00000040u, ImmutableString("gl_MaxGeometryTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000029u, ImmutableString("gl_MaxGeometryOutputVertices").mangledNameHash());
    ASSERT_EQ(0x000002a2u,
              ImmutableString("gl_MaxGeometryTotalOutputComponents").mangledNameHash());
    ASSERT_EQ(0x00000122u, ImmutableString("gl_MaxGeometryUniformComponents").mangledNameHash());
    ASSERT_EQ(0x000001e3u, ImmutableString("gl_MaxGeometryAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x000000fdu, ImmutableString("gl_MaxGeometryAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x000000a2u, ImmutableString("gl_FragCoord").mangledNameHash());
    ASSERT_EQ(0x000002e2u, ImmutableString("gl_FrontFacing").mangledNameHash());
    ASSERT_EQ(0x00000118u, ImmutableString("gl_PointCoord").mangledNameHash());
    ASSERT_EQ(0x00000076u, ImmutableString("gl_FragColor").mangledNameHash());
    ASSERT_EQ(0x000002f5u, ImmutableString("gl_FragData").mangledNameHash());
    ASSERT_EQ(0x00000176u, ImmutableString("gl_FragDepth").mangledNameHash());
    ASSERT_EQ(0x000002e3u, ImmutableString("gl_SecondaryFragColorEXT").mangledNameHash());
    ASSERT_EQ(0x000001cbu, ImmutableString("gl_SecondaryFragDataEXT").mangledNameHash());
    ASSERT_EQ(0x00000169u, ImmutableString("gl_FragDepthEXT").mangledNameHash());
    ASSERT_EQ(0x0000014au, ImmutableString("gl_LastFragData").mangledNameHash());
    ASSERT_EQ(0x00000163u, ImmutableString("gl_LastFragColor").mangledNameHash());
    ASSERT_EQ(0x00000300u, ImmutableString("gl_LastFragColorARM").mangledNameHash());
    ASSERT_EQ(0x00000003u, ImmutableString("gl_PrimitiveID").mangledNameHash());
    ASSERT_EQ(0x0000000eu, ImmutableString("gl_Layer").mangledNameHash());
    ASSERT_EQ(0x0000031eu, ImmutableString("gl_Position").mangledNameHash());
    ASSERT_EQ(0x00000374u, ImmutableString("gl_PointSize").mangledNameHash());
    ASSERT_EQ(0x000001d1u, ImmutableString("gl_InstanceID").mangledNameHash());
    ASSERT_EQ(0x00000308u, ImmutableString("gl_VertexID").mangledNameHash());
    ASSERT_EQ(0x000003a4u, ImmutableString("gl_DrawID").mangledNameHash());
    ASSERT_EQ(0x00000296u, ImmutableString("gl_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x00000310u, ImmutableString("gl_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x0000000au, ImmutableString("angle_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x0000031bu, ImmutableString("angle_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x000002b7u, ImmutableString("gl_NumWorkGroups").mangledNameHash());
    ASSERT_EQ(0x00000209u, ImmutableString("gl_WorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x000001d7u, ImmutableString("gl_WorkGroupID").mangledNameHash());
    ASSERT_EQ(0x0000016fu, ImmutableString("gl_LocalInvocationID").mangledNameHash());
    ASSERT_EQ(0x000001ebu, ImmutableString("gl_GlobalInvocationID").mangledNameHash());
    ASSERT_EQ(0x000001b7u, ImmutableString("gl_LocalInvocationIndex").mangledNameHash());
    ASSERT_EQ(0x000000bfu, ImmutableString("gl_PrimitiveIDIn").mangledNameHash());
    ASSERT_EQ(0x00000142u, ImmutableString("gl_InvocationID").mangledNameHash());
    ASSERT_EQ(0x000001feu, ImmutableString("gl_PerVertex").mangledNameHash());
    ASSERT_EQ(0x000001c6u, ImmutableString("gl_in").mangledNameHash());
    ASSERT_EQ(0x00000201u, ImmutableString("gl_ViewID_OVR").mangledNameHash());
    ASSERT_EQ(0x0000001cu, ImmutableString("radians").unmangledNameHash());
    ASSERT_EQ(0x0000000fu, ImmutableString("degrees").unmangledNameHash());
    ASSERT_EQ(0x0000007du, ImmutableString("sin").unmangledNameHash());
    ASSERT_EQ(0x00000042u, ImmutableString("cos").unmangledNameHash());
    ASSERT_EQ(0x00000072u, ImmutableString("tan").unmangledNameHash());
    ASSERT_EQ(0x0000002bu, ImmutableString("asin").unmangledNameHash());
    ASSERT_EQ(0x00000049u, ImmutableString("acos").unmangledNameHash());
    ASSERT_EQ(0x00000080u, ImmutableString("atan").unmangledNameHash());
    ASSERT_EQ(0x0000003fu, ImmutableString("sinh").unmangledNameHash());
    ASSERT_EQ(0x00000029u, ImmutableString("cosh").unmangledNameHash());
    ASSERT_EQ(0x00000067u, ImmutableString("tanh").unmangledNameHash());
    ASSERT_EQ(0x0000006fu, ImmutableString("asinh").unmangledNameHash());
    ASSERT_EQ(0x00000028u, ImmutableString("acosh").unmangledNameHash());
    ASSERT_EQ(0x00000079u, ImmutableString("atanh").unmangledNameHash());
    ASSERT_EQ(0x0000004eu, ImmutableString("pow").unmangledNameHash());
    ASSERT_EQ(0x00000090u, ImmutableString("exp").unmangledNameHash());
    ASSERT_EQ(0x00000057u, ImmutableString("log").unmangledNameHash());
    ASSERT_EQ(0x00000059u, ImmutableString("exp2").unmangledNameHash());
    ASSERT_EQ(0x00000037u, ImmutableString("log2").unmangledNameHash());
    ASSERT_EQ(0x0000007bu, ImmutableString("sqrt").unmangledNameHash());
    ASSERT_EQ(0x00000065u, ImmutableString("inversesqrt").unmangledNameHash());
    ASSERT_EQ(0x00000034u, ImmutableString("abs").unmangledNameHash());
    ASSERT_EQ(0x00000064u, ImmutableString("sign").unmangledNameHash());
    ASSERT_EQ(0x00000077u, ImmutableString("floor").unmangledNameHash());
    ASSERT_EQ(0x00000041u, ImmutableString("trunc").unmangledNameHash());
    ASSERT_EQ(0x00000023u, ImmutableString("round").unmangledNameHash());
    ASSERT_EQ(0x00000014u, ImmutableString("roundEven").unmangledNameHash());
    ASSERT_EQ(0x00000017u, ImmutableString("ceil").unmangledNameHash());
    ASSERT_EQ(0x0000005bu, ImmutableString("fract").unmangledNameHash());
    ASSERT_EQ(0x0000001au, ImmutableString("mod").unmangledNameHash());
    ASSERT_EQ(0x0000008du, ImmutableString("min").unmangledNameHash());
    ASSERT_EQ(0x00000035u, ImmutableString("max").unmangledNameHash());
    ASSERT_EQ(0x00000025u, ImmutableString("clamp").unmangledNameHash());
    ASSERT_EQ(0x0000007cu, ImmutableString("mix").unmangledNameHash());
    ASSERT_EQ(0x0000003eu, ImmutableString("step").unmangledNameHash());
    ASSERT_EQ(0x0000001du, ImmutableString("smoothstep").unmangledNameHash());
    ASSERT_EQ(0x00000021u, ImmutableString("modf").unmangledNameHash());
    ASSERT_EQ(0x0000002cu, ImmutableString("isnan").unmangledNameHash());
    ASSERT_EQ(0x00000083u, ImmutableString("isinf").unmangledNameHash());
    ASSERT_EQ(0x0000001bu, ImmutableString("floatBitsToInt").unmangledNameHash());
    ASSERT_EQ(0x00000051u, ImmutableString("floatBitsToUint").unmangledNameHash());
    ASSERT_EQ(0x0000006bu, ImmutableString("intBitsToFloat").unmangledNameHash());
    ASSERT_EQ(0x0000004au, ImmutableString("uintBitsToFloat").unmangledNameHash());
    ASSERT_EQ(0x0000000eu, ImmutableString("frexp").unmangledNameHash());
    ASSERT_EQ(0x00000050u, ImmutableString("ldexp").unmangledNameHash());
    ASSERT_EQ(0x0000008fu, ImmutableString("packSnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000093u, ImmutableString("packHalf2x16").unmangledNameHash());
    ASSERT_EQ(0x00000036u, ImmutableString("unpackSnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x0000004cu, ImmutableString("unpackHalf2x16").unmangledNameHash());
    ASSERT_EQ(0x0000004bu, ImmutableString("packUnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000081u, ImmutableString("unpackUnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000063u, ImmutableString("packUnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x0000000au, ImmutableString("packSnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000002u, ImmutableString("unpackUnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000022u, ImmutableString("unpackSnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000047u, ImmutableString("length").unmangledNameHash());
    ASSERT_EQ(0x00000066u, ImmutableString("distance").unmangledNameHash());
    ASSERT_EQ(0x00000095u, ImmutableString("dot").unmangledNameHash());
    ASSERT_EQ(0x0000007au, ImmutableString("cross").unmangledNameHash());
    ASSERT_EQ(0x00000075u, ImmutableString("normalize").unmangledNameHash());
    ASSERT_EQ(0x00000033u, ImmutableString("faceforward").unmangledNameHash());
    ASSERT_EQ(0x00000082u, ImmutableString("reflect").unmangledNameHash());
    ASSERT_EQ(0x0000008cu, ImmutableString("refract").unmangledNameHash());
    ASSERT_EQ(0x0000004du, ImmutableString("matrixCompMult").unmangledNameHash());
    ASSERT_EQ(0x0000008au, ImmutableString("outerProduct").unmangledNameHash());
    ASSERT_EQ(0x0000003du, ImmutableString("transpose").unmangledNameHash());
    ASSERT_EQ(0x0000005du, ImmutableString("determinant").unmangledNameHash());
    ASSERT_EQ(0x0000000bu, ImmutableString("inverse").unmangledNameHash());
    ASSERT_EQ(0x0000001fu, ImmutableString("lessThan").unmangledNameHash());
    ASSERT_EQ(0x0000003cu, ImmutableString("lessThanEqual").unmangledNameHash());
    ASSERT_EQ(0x00000060u, ImmutableString("greaterThan").unmangledNameHash());
    ASSERT_EQ(0x0000005fu, ImmutableString("greaterThanEqual").unmangledNameHash());
    ASSERT_EQ(0x00000043u, ImmutableString("equal").unmangledNameHash());
    ASSERT_EQ(0x00000089u, ImmutableString("notEqual").unmangledNameHash());
    ASSERT_EQ(0x00000073u, ImmutableString("any").unmangledNameHash());
    ASSERT_EQ(0x00000000u, ImmutableString("all").unmangledNameHash());
    ASSERT_EQ(0x00000018u, ImmutableString("not").unmangledNameHash());
    ASSERT_EQ(0x0000006cu, ImmutableString("bitfieldExtract").unmangledNameHash());
    ASSERT_EQ(0x00000061u, ImmutableString("bitfieldInsert").unmangledNameHash());
    ASSERT_EQ(0x0000002eu, ImmutableString("bitfieldReverse").unmangledNameHash());
    ASSERT_EQ(0x00000058u, ImmutableString("bitCount").unmangledNameHash());
    ASSERT_EQ(0x00000007u, ImmutableString("findLSB").unmangledNameHash());
    ASSERT_EQ(0x00000026u, ImmutableString("findMSB").unmangledNameHash());
    ASSERT_EQ(0x0000002au, ImmutableString("uaddCarry").unmangledNameHash());
    ASSERT_EQ(0x00000045u, ImmutableString("usubBorrow").unmangledNameHash());
    ASSERT_EQ(0x00000085u, ImmutableString("umulExtended").unmangledNameHash());
    ASSERT_EQ(0x00000010u, ImmutableString("imulExtended").unmangledNameHash());
    ASSERT_EQ(0x00000070u, ImmutableString("texture2D").unmangledNameHash());
    ASSERT_EQ(0x0000003au, ImmutableString("texture2DProj").unmangledNameHash());
    ASSERT_EQ(0x0000008eu, ImmutableString("textureCube").unmangledNameHash());
    ASSERT_EQ(0x00000027u, ImmutableString("texture2DRect").unmangledNameHash());
    ASSERT_EQ(0x00000019u, ImmutableString("texture2DRectProj").unmangledNameHash());
    ASSERT_EQ(0x0000000du, ImmutableString("texture").unmangledNameHash());
    ASSERT_EQ(0x00000001u, ImmutableString("textureProj").unmangledNameHash());
    ASSERT_EQ(0x00000068u, ImmutableString("texture2DGradEXT").unmangledNameHash());
    ASSERT_EQ(0x00000011u, ImmutableString("texture2DProjGradEXT").unmangledNameHash());
    ASSERT_EQ(0x00000008u, ImmutableString("textureCubeGradEXT").unmangledNameHash());
    ASSERT_EQ(0x0000002fu, ImmutableString("dFdx").unmangledNameHash());
    ASSERT_EQ(0x00000020u, ImmutableString("dFdy").unmangledNameHash());
    ASSERT_EQ(0x00000003u, ImmutableString("fwidth").unmangledNameHash());
    ASSERT_EQ(0x00000044u, ImmutableString("texture2DLodEXT").unmangledNameHash());
    ASSERT_EQ(0x00000015u, ImmutableString("texture2DProjLodEXT").unmangledNameHash());
    ASSERT_EQ(0x00000053u, ImmutableString("textureCubeLodEXT").unmangledNameHash());
    ASSERT_EQ(0x00000084u, ImmutableString("texture3D").unmangledNameHash());
    ASSERT_EQ(0x00000062u, ImmutableString("texture3DProj").unmangledNameHash());
    ASSERT_EQ(0x00000031u, ImmutableString("texture3DLod").unmangledNameHash());
    ASSERT_EQ(0x0000006du, ImmutableString("texture3DProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000094u, ImmutableString("texture2DLod").unmangledNameHash());
    ASSERT_EQ(0x0000004fu, ImmutableString("texture2DProjLod").unmangledNameHash());
    ASSERT_EQ(0x0000000cu, ImmutableString("textureCubeLod").unmangledNameHash());
    ASSERT_EQ(0x00000032u, ImmutableString("textureLod").unmangledNameHash());
    ASSERT_EQ(0x00000048u, ImmutableString("textureSize").unmangledNameHash());
    ASSERT_EQ(0x00000052u, ImmutableString("textureProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000087u, ImmutableString("texelFetch").unmangledNameHash());
    ASSERT_EQ(0x00000038u, ImmutableString("textureGrad").unmangledNameHash());
    ASSERT_EQ(0x0000001eu, ImmutableString("textureProjGrad").unmangledNameHash());
    ASSERT_EQ(0x00000024u, ImmutableString("textureOffset").unmangledNameHash());
    ASSERT_EQ(0x00000040u, ImmutableString("textureProjOffset").unmangledNameHash());
    ASSERT_EQ(0x00000078u, ImmutableString("textureLodOffset").unmangledNameHash());
    ASSERT_EQ(0x00000056u, ImmutableString("textureProjLodOffset").unmangledNameHash());
    ASSERT_EQ(0x00000046u, ImmutableString("texelFetchOffset").unmangledNameHash());
    ASSERT_EQ(0x0000007fu, ImmutableString("textureGradOffset").unmangledNameHash());
    ASSERT_EQ(0x00000013u, ImmutableString("textureProjGradOffset").unmangledNameHash());
    ASSERT_EQ(0x00000004u, ImmutableString("rgb_2_yuv").unmangledNameHash());
    ASSERT_EQ(0x00000006u, ImmutableString("yuv_2_rgb").unmangledNameHash());
    ASSERT_EQ(0x0000005eu, ImmutableString("textureGather").unmangledNameHash());
    ASSERT_EQ(0x00000055u, ImmutableString("textureGatherOffset").unmangledNameHash());
    ASSERT_EQ(0x0000006au, ImmutableString("atomicCounter").unmangledNameHash());
    ASSERT_EQ(0x00000005u, ImmutableString("atomicCounterIncrement").unmangledNameHash());
    ASSERT_EQ(0x0000003bu, ImmutableString("atomicCounterDecrement").unmangledNameHash());
    ASSERT_EQ(0x0000006eu, ImmutableString("atomicAdd").unmangledNameHash());
    ASSERT_EQ(0x00000092u, ImmutableString("atomicMin").unmangledNameHash());
    ASSERT_EQ(0x0000002du, ImmutableString("atomicMax").unmangledNameHash());
    ASSERT_EQ(0x00000012u, ImmutableString("atomicAnd").unmangledNameHash());
    ASSERT_EQ(0x00000086u, ImmutableString("atomicOr").unmangledNameHash());
    ASSERT_EQ(0x00000074u, ImmutableString("atomicXor").unmangledNameHash());
    ASSERT_EQ(0x0000007eu, ImmutableString("atomicExchange").unmangledNameHash());
    ASSERT_EQ(0x0000005au, ImmutableString("atomicCompSwap").unmangledNameHash());
    ASSERT_EQ(0x0000008bu, ImmutableString("imageSize").unmangledNameHash());
    ASSERT_EQ(0x00000076u, ImmutableString("imageLoad").unmangledNameHash());
    ASSERT_EQ(0x00000054u, ImmutableString("imageStore").unmangledNameHash());
    ASSERT_EQ(0x00000069u, ImmutableString("memoryBarrier").unmangledNameHash());
    ASSERT_EQ(0x00000016u, ImmutableString("memoryBarrierAtomicCounter").unmangledNameHash());
    ASSERT_EQ(0x00000071u, ImmutableString("memoryBarrierBuffer").unmangledNameHash());
    ASSERT_EQ(0x00000009u, ImmutableString("memoryBarrierImage").unmangledNameHash());
    ASSERT_EQ(0x00000039u, ImmutableString("barrier").unmangledNameHash());
    ASSERT_EQ(0x00000030u, ImmutableString("memoryBarrierShared").unmangledNameHash());
    ASSERT_EQ(0x00000091u, ImmutableString("groupMemoryBarrier").unmangledNameHash());
    ASSERT_EQ(0x0000005cu, ImmutableString("EmitVertex").unmangledNameHash());
    ASSERT_EQ(0x00000088u, ImmutableString("EndPrimitive").unmangledNameHash());
}

}  // namespace sh
