/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-ngap.c                                                              */
/* asn2wrs.py -q -L -p ngap -c ./ngap.cnf -s ./packet-ngap-template -D . -O ../.. NGAP-CommonDataTypes.asn NGAP-Constants.asn NGAP-Containers.asn NGAP-IEs.asn NGAP-PDU-Contents.asn NGAP-PDU-Descriptions.asn */

/* packet-ngap.c
 * Routines for NG-RAN NG Application Protocol (NGAP) packet dissection
 * Copyright 2018, Anders Broman <anders.broman@ericsson.com>
 * Copyright 2018-2024, Pascal Quantin <pascal@wireshark.org>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * References: 3GPP TS 38.413 v18.2.0 (2024-06)
 */

#include "config.h"
#include <stdio.h>

#include <epan/packet.h>
#include <epan/strutil.h>
#include <epan/asn1.h>
#include <epan/prefs.h>
#include <epan/sctpppids.h>
#include <epan/expert.h>
#include <epan/proto_data.h>
#include <epan/conversation.h>
#include <epan/exceptions.h>
#include <epan/show_exception.h>
#include <epan/tap.h>
#include <epan/stats_tree.h>
#include <epan/tfs.h>
#include <epan/unit_strings.h>
#include <wsutil/wsjson.h>
#include <wsutil/array.h>

#include "packet-ngap.h"
#include "packet-per.h"
#include "packet-e212.h"
#include "packet-s1ap.h"
#include "packet-ranap.h"
#include "packet-rrc.h"
#include "packet-lte-rrc.h"
#include "packet-nr-rrc.h"
#include "packet-gsm_map.h"
#include "packet-cell_broadcast.h"
#include "packet-ntp.h"
#include "packet-gsm_a_common.h"
#include "packet-media-type.h"

#define PNAME  "NG Application Protocol"
#define PSNAME "NGAP"
#define PFNAME "ngap"

/* Dissector will use SCTP PPID 18 or SCTP port. IANA assigned port = 36412 */
#define SCTP_PORT_NGAP 38412

void proto_register_ngap(void);
void proto_reg_handoff_ngap(void);

static dissector_handle_t ngap_handle;
static dissector_handle_t ngap_media_type_handle;
static dissector_handle_t nas_5gs_handle;
static dissector_handle_t nr_rrc_ue_radio_paging_info_handle;
static dissector_handle_t nr_rrc_ue_radio_access_cap_info_handle;
static dissector_handle_t lte_rrc_ue_radio_paging_info_handle;
static dissector_handle_t lte_rrc_ue_radio_access_cap_info_handle;
static dissector_handle_t lte_rrc_ue_radio_paging_info_nb_handle;
static dissector_handle_t lte_rrc_ue_radio_access_cap_info_nb_handle;
static dissector_handle_t nrppa_handle;

static int proto_json;

#define maxPrivateIEs                  65535
#define maxProtocolExtensions          65535
#define maxProtocolIEs                 65535
#define maxnoofAllowedAreas            16
#define maxnoofAllowedCAGsperPLMN      256
#define maxnoofAllowedS_NSSAIs         8
#define maxnoofBluetoothName           4
#define maxnoofBPLMNs                  12
#define maxnoofCAGSperCell             64
#define maxnoofCellIDforMDT            32
#define maxnoofCellIDforWarning        65535
#define maxnoofCellinAoI               256
#define maxnoofCellinEAI               65535
#define maxnoofCellinTAI               65535
#define maxnoofCellsforMBS             8192
#define maxnoofCellsingNB              16384
#define maxnoofCellsinngeNB            256
#define maxnoofCellsinNGRANNode        16384
#define maxnoofCellsinUEHistoryInfo    16
#define maxnoofCellsUEMovingTrajectory 16
#define maxnoofDRBs                    32
#define maxnoofEmergencyAreaID         65535
#define maxnoofEAIforRestart           256
#define maxnoofEPLMNs                  15
#define maxnoofEPLMNsPlusOne           16
#define maxnoofE_RABs                  256
#define maxnoofErrors                  256
#define maxnoofExtSliceItems           65535
#define maxnoofForbTACs                4096
#define maxnoofFreqforMDT              8
#define maxnoofMBSAreaSessionIDs       256
#define maxnoofMBSFSAs                 64
#define maxnoofMBSQoSFlows             64
#define maxnoofMBSSessions             32
#define maxnoofMBSSessionsofUE         256
#define maxnoofMBSServiceAreaInformation 256
#define maxnoofMDTPLMNs                16
#define maxnoofMRBs                    32
#define maxnoofMultiConnectivity       4
#define maxnoofMultiConnectivityMinusOne 3
#define maxnoofNeighPCIforMDT          32
#define maxnoofNGAPIESupportInfo       32
#define maxnoofNGConnectionsToReset    65536
#define maxnoofNRCellBands             32
#define maxnoofNSAGs                   256
#define maxnoofPagingAreas             64
#define maxnoofPC5QoSFlows             2048
#define maxnoofPDUSessions             256
#define maxnoofPLMNs                   12
#define maxnoofPSCellsPerPrimaryCellinUEHistoryInfo 8
#define maxnoofQosFlows                64
#define maxnoofQosParaSets             8
#define maxnoofRANNodeinAoI            64
#define maxnoofRecommendedCells        16
#define maxnoofRecommendedRANNodes     16
#define maxnoofAoI                     64
#define maxnoofAoIMinusOne             63
#define maxnoofReportedCells           256
#define maxnoofSensorName              3
#define maxnoofServedGUAMIs            256
#define maxnoofSliceItems              1024
#define maxnoofSuccessfulHOReports     64
#define maxnoofTACs                    256
#define maxnoofTACsinNTN               12
#define maxnoofTAforMDT                8
#define maxnoofTAIforInactive          16
#define maxnoofTAIforMBS               1024
#define maxnoofTAIforPaging            16
#define maxnoofTAIforRestart           2048
#define maxnoofTAIforWarning           65535
#define maxnoofTAIinAoI                16
#define maxnoofTimePeriods             2
#define maxnoofTNLAssociations         32
#define maxnoofUEsforPaging            4096
#define maxnoofUETypes                 8
#define maxnoofWLANName                4
#define maxnoofXnExtTLAs               16
#define maxnoofXnGTP_TLAs              16
#define maxnoofXnTLAs                  2
#define maxnoofCandidateCells          32
#define maxnoofTargetS_NSSAIs          8
#define maxNRARFCN                     3279165
#define maxnoofCellIDforQMC            32
#define maxnoofPLMNforQMC              16
#define maxnoofUEAppLayerMeas          16
#define maxnoofSNSSAIforQMC            16
#define maxnoofTAforQMC                8
#define maxnoofThresholdsForExcessPacketDelay 255
#define maxnoofESNPNs                  15
#define maxnoofCandidateRelayUEs       32
#define maxnoofSuccessfulPSCellChangeReports 64
#define maxnoofCellsTSS                16384
#define maxnoofPeriodicities           8
#define maxnoofCAGforMDT               256
#define maxnoofMDTSNPNs                16
#define maxnoofPartiallyAllowedS_NSSAIs 8
#define maxnoofRSPPQoSFlows            2048

typedef enum _ProcedureCode_enum {
  id_AMFConfigurationUpdate =   0,
  id_AMFStatusIndication =   1,
  id_CellTrafficTrace =   2,
  id_DeactivateTrace =   3,
  id_DownlinkNASTransport =   4,
  id_DownlinkNonUEAssociatedNRPPaTransport =   5,
  id_DownlinkRANConfigurationTransfer =   6,
  id_DownlinkRANStatusTransfer =   7,
  id_DownlinkUEAssociatedNRPPaTransport =   8,
  id_ErrorIndication =   9,
  id_HandoverCancel =  10,
  id_HandoverNotification =  11,
  id_HandoverPreparation =  12,
  id_HandoverResourceAllocation =  13,
  id_InitialContextSetup =  14,
  id_InitialUEMessage =  15,
  id_LocationReportingControl =  16,
  id_LocationReportingFailureIndication =  17,
  id_LocationReport =  18,
  id_NASNonDeliveryIndication =  19,
  id_NGReset   =  20,
  id_NGSetup   =  21,
  id_OverloadStart =  22,
  id_OverloadStop =  23,
  id_Paging    =  24,
  id_PathSwitchRequest =  25,
  id_PDUSessionResourceModify =  26,
  id_PDUSessionResourceModifyIndication =  27,
  id_PDUSessionResourceRelease =  28,
  id_PDUSessionResourceSetup =  29,
  id_PDUSessionResourceNotify =  30,
  id_PrivateMessage =  31,
  id_PWSCancel =  32,
  id_PWSFailureIndication =  33,
  id_PWSRestartIndication =  34,
  id_RANConfigurationUpdate =  35,
  id_RerouteNASRequest =  36,
  id_RRCInactiveTransitionReport =  37,
  id_TraceFailureIndication =  38,
  id_TraceStart =  39,
  id_UEContextModification =  40,
  id_UEContextRelease =  41,
  id_UEContextReleaseRequest =  42,
  id_UERadioCapabilityCheck =  43,
  id_UERadioCapabilityInfoIndication =  44,
  id_UETNLABindingRelease =  45,
  id_UplinkNASTransport =  46,
  id_UplinkNonUEAssociatedNRPPaTransport =  47,
  id_UplinkRANConfigurationTransfer =  48,
  id_UplinkRANStatusTransfer =  49,
  id_UplinkUEAssociatedNRPPaTransport =  50,
  id_WriteReplaceWarning =  51,
  id_SecondaryRATDataUsageReport =  52,
  id_UplinkRIMInformationTransfer =  53,
  id_DownlinkRIMInformationTransfer =  54,
  id_RetrieveUEInformation =  55,
  id_UEInformationTransfer =  56,
  id_RANCPRelocationIndication =  57,
  id_UEContextResume =  58,
  id_UEContextSuspend =  59,
  id_UERadioCapabilityIDMapping =  60,
  id_HandoverSuccess =  61,
  id_UplinkRANEarlyStatusTransfer =  62,
  id_DownlinkRANEarlyStatusTransfer =  63,
  id_AMFCPRelocationIndication =  64,
  id_ConnectionEstablishmentIndication =  65,
  id_BroadcastSessionModification =  66,
  id_BroadcastSessionRelease =  67,
  id_BroadcastSessionSetup =  68,
  id_DistributionSetup =  69,
  id_DistributionRelease =  70,
  id_MulticastSessionActivation =  71,
  id_MulticastSessionDeactivation =  72,
  id_MulticastSessionUpdate =  73,
  id_MulticastGroupPaging =  74,
  id_BroadcastSessionReleaseRequired =  75,
  id_TimingSynchronisationStatus =  76,
  id_TimingSynchronisationStatusReport =  77,
  id_MTCommunicationHandling =  78,
  id_RANPagingRequest =  79,
  id_BroadcastSessionTransport =  80
} ProcedureCode_enum;

typedef enum _ProtocolIE_ID_enum {
  id_AllowedNSSAI =   0,
  id_AMFName   =   1,
  id_AMFOverloadResponse =   2,
  id_AMFSetID  =   3,
  id_AMF_TNLAssociationFailedToSetupList =   4,
  id_AMF_TNLAssociationSetupList =   5,
  id_AMF_TNLAssociationToAddList =   6,
  id_AMF_TNLAssociationToRemoveList =   7,
  id_AMF_TNLAssociationToUpdateList =   8,
  id_AMFTrafficLoadReductionIndication =   9,
  id_AMF_UE_NGAP_ID =  10,
  id_AssistanceDataForPaging =  11,
  id_BroadcastCancelledAreaList =  12,
  id_BroadcastCompletedAreaList =  13,
  id_CancelAllWarningMessages =  14,
  id_Cause     =  15,
  id_CellIDListForRestart =  16,
  id_ConcurrentWarningMessageInd =  17,
  id_CoreNetworkAssistanceInformationForInactive =  18,
  id_CriticalityDiagnostics =  19,
  id_DataCodingScheme =  20,
  id_DefaultPagingDRX =  21,
  id_DirectForwardingPathAvailability =  22,
  id_EmergencyAreaIDListForRestart =  23,
  id_EmergencyFallbackIndicator =  24,
  id_EUTRA_CGI =  25,
  id_FiveG_S_TMSI =  26,
  id_GlobalRANNodeID =  27,
  id_GUAMI     =  28,
  id_HandoverType =  29,
  id_IMSVoiceSupportIndicator =  30,
  id_IndexToRFSP =  31,
  id_InfoOnRecommendedCellsAndRANNodesForPaging =  32,
  id_LocationReportingRequestType =  33,
  id_MaskedIMEISV =  34,
  id_MessageIdentifier =  35,
  id_MobilityRestrictionList =  36,
  id_NASC      =  37,
  id_NAS_PDU   =  38,
  id_NASSecurityParametersFromNGRAN =  39,
  id_NewAMF_UE_NGAP_ID =  40,
  id_NewSecurityContextInd =  41,
  id_NGAP_Message =  42,
  id_NGRAN_CGI =  43,
  id_NGRANTraceID =  44,
  id_NR_CGI    =  45,
  id_NRPPa_PDU =  46,
  id_NumberOfBroadcastsRequested =  47,
  id_OldAMF    =  48,
  id_OverloadStartNSSAIList =  49,
  id_PagingDRX =  50,
  id_PagingOrigin =  51,
  id_PagingPriority =  52,
  id_PDUSessionResourceAdmittedList =  53,
  id_PDUSessionResourceFailedToModifyListModRes =  54,
  id_PDUSessionResourceFailedToSetupListCxtRes =  55,
  id_PDUSessionResourceFailedToSetupListHOAck =  56,
  id_PDUSessionResourceFailedToSetupListPSReq =  57,
  id_PDUSessionResourceFailedToSetupListSURes =  58,
  id_PDUSessionResourceHandoverList =  59,
  id_PDUSessionResourceListCxtRelCpl =  60,
  id_PDUSessionResourceListHORqd =  61,
  id_PDUSessionResourceModifyListModCfm =  62,
  id_PDUSessionResourceModifyListModInd =  63,
  id_PDUSessionResourceModifyListModReq =  64,
  id_PDUSessionResourceModifyListModRes =  65,
  id_PDUSessionResourceNotifyList =  66,
  id_PDUSessionResourceReleasedListNot =  67,
  id_PDUSessionResourceReleasedListPSAck =  68,
  id_PDUSessionResourceReleasedListPSFail =  69,
  id_PDUSessionResourceReleasedListRelRes =  70,
  id_PDUSessionResourceSetupListCxtReq =  71,
  id_PDUSessionResourceSetupListCxtRes =  72,
  id_PDUSessionResourceSetupListHOReq =  73,
  id_PDUSessionResourceSetupListSUReq =  74,
  id_PDUSessionResourceSetupListSURes =  75,
  id_PDUSessionResourceToBeSwitchedDLList =  76,
  id_PDUSessionResourceSwitchedList =  77,
  id_PDUSessionResourceToReleaseListHOCmd =  78,
  id_PDUSessionResourceToReleaseListRelCmd =  79,
  id_PLMNSupportList =  80,
  id_PWSFailedCellIDList =  81,
  id_RANNodeName =  82,
  id_RANPagingPriority =  83,
  id_RANStatusTransfer_TransparentContainer =  84,
  id_RAN_UE_NGAP_ID =  85,
  id_RelativeAMFCapacity =  86,
  id_RepetitionPeriod =  87,
  id_ResetType =  88,
  id_RoutingID =  89,
  id_RRCEstablishmentCause =  90,
  id_RRCInactiveTransitionReportRequest =  91,
  id_RRCState  =  92,
  id_SecurityContext =  93,
  id_SecurityKey =  94,
  id_SerialNumber =  95,
  id_ServedGUAMIList =  96,
  id_SliceSupportList =  97,
  id_SONConfigurationTransferDL =  98,
  id_SONConfigurationTransferUL =  99,
  id_SourceAMF_UE_NGAP_ID = 100,
  id_SourceToTarget_TransparentContainer = 101,
  id_SupportedTAList = 102,
  id_TAIListForPaging = 103,
  id_TAIListForRestart = 104,
  id_TargetID  = 105,
  id_TargetToSource_TransparentContainer = 106,
  id_TimeToWait = 107,
  id_TraceActivation = 108,
  id_TraceCollectionEntityIPAddress = 109,
  id_UEAggregateMaximumBitRate = 110,
  id_UE_associatedLogicalNG_connectionList = 111,
  id_UEContextRequest = 112,
  id_Unknown_113 = 113,
  id_UE_NGAP_IDs = 114,
  id_UEPagingIdentity = 115,
  id_UEPresenceInAreaOfInterestList = 116,
  id_UERadioCapability = 117,
  id_UERadioCapabilityForPaging = 118,
  id_UESecurityCapabilities = 119,
  id_UnavailableGUAMIList = 120,
  id_UserLocationInformation = 121,
  id_WarningAreaList = 122,
  id_WarningMessageContents = 123,
  id_WarningSecurityInfo = 124,
  id_WarningType = 125,
  id_AdditionalUL_NGU_UP_TNLInformation = 126,
  id_DataForwardingNotPossible = 127,
  id_DL_NGU_UP_TNLInformation = 128,
  id_NetworkInstance = 129,
  id_PDUSessionAggregateMaximumBitRate = 130,
  id_PDUSessionResourceFailedToModifyListModCfm = 131,
  id_PDUSessionResourceFailedToSetupListCxtFail = 132,
  id_PDUSessionResourceListCxtRelReq = 133,
  id_PDUSessionType = 134,
  id_QosFlowAddOrModifyRequestList = 135,
  id_QosFlowSetupRequestList = 136,
  id_QosFlowToReleaseList = 137,
  id_SecurityIndication = 138,
  id_UL_NGU_UP_TNLInformation = 139,
  id_UL_NGU_UP_TNLModifyList = 140,
  id_WarningAreaCoordinates = 141,
  id_PDUSessionResourceSecondaryRATUsageList = 142,
  id_HandoverFlag = 143,
  id_SecondaryRATUsageInformation = 144,
  id_PDUSessionResourceReleaseResponseTransfer = 145,
  id_RedirectionVoiceFallback = 146,
  id_UERetentionInformation = 147,
  id_S_NSSAI   = 148,
  id_PSCellInformation = 149,
  id_LastEUTRAN_PLMNIdentity = 150,
  id_MaximumIntegrityProtectedDataRate_DL = 151,
  id_AdditionalDLForwardingUPTNLInformation = 152,
  id_AdditionalDLUPTNLInformationForHOList = 153,
  id_AdditionalNGU_UP_TNLInformation = 154,
  id_AdditionalDLQosFlowPerTNLInformation = 155,
  id_SecurityResult = 156,
  id_ENDC_SONConfigurationTransferDL = 157,
  id_ENDC_SONConfigurationTransferUL = 158,
  id_OldAssociatedQosFlowList_ULendmarkerexpected = 159,
  id_CNTypeRestrictionsForEquivalent = 160,
  id_CNTypeRestrictionsForServing = 161,
  id_NewGUAMI  = 162,
  id_ULForwarding = 163,
  id_ULForwardingUP_TNLInformation = 164,
  id_CNAssistedRANTuning = 165,
  id_CommonNetworkInstance = 166,
  id_NGRAN_TNLAssociationToRemoveList = 167,
  id_TNLAssociationTransportLayerAddressNGRAN = 168,
  id_EndpointIPAddressAndPort = 169,
  id_LocationReportingAdditionalInfo = 170,
  id_SourceToTarget_AMFInformationReroute = 171,
  id_AdditionalULForwardingUPTNLInformation = 172,
  id_SCTP_TLAs = 173,
  id_SelectedPLMNIdentity = 174,
  id_RIMInformationTransfer = 175,
  id_GUAMIType = 176,
  id_SRVCCOperationPossible = 177,
  id_TargetRNC_ID = 178,
  id_RAT_Information = 179,
  id_ExtendedRATRestrictionInformation = 180,
  id_QosMonitoringRequest = 181,
  id_SgNB_UE_X2AP_ID = 182,
  id_AdditionalRedundantDL_NGU_UP_TNLInformation = 183,
  id_AdditionalRedundantDLQosFlowPerTNLInformation = 184,
  id_AdditionalRedundantNGU_UP_TNLInformation = 185,
  id_AdditionalRedundantUL_NGU_UP_TNLInformation = 186,
  id_CNPacketDelayBudgetDL = 187,
  id_CNPacketDelayBudgetUL = 188,
  id_ExtendedPacketDelayBudget = 189,
  id_RedundantCommonNetworkInstance = 190,
  id_RedundantDL_NGU_TNLInformationReused = 191,
  id_RedundantDL_NGU_UP_TNLInformation = 192,
  id_RedundantDLQosFlowPerTNLInformation = 193,
  id_RedundantQosFlowIndicator = 194,
  id_RedundantUL_NGU_UP_TNLInformation = 195,
  id_TSCTrafficCharacteristics = 196,
  id_RedundantPDUSessionInformation = 197,
  id_UsedRSNInformation = 198,
  id_IAB_Authorized = 199,
  id_IAB_Supported = 200,
  id_IABNodeIndication = 201,
  id_NB_IoT_PagingDRX = 202,
  id_NB_IoT_Paging_eDRXInfo = 203,
  id_NB_IoT_DefaultPagingDRX = 204,
  id_Enhanced_CoverageRestriction = 205,
  id_Extended_ConnectedTime = 206,
  id_PagingAssisDataforCEcapabUE = 207,
  id_WUS_Assistance_Information = 208,
  id_UE_DifferentiationInfo = 209,
  id_NB_IoT_UEPriority = 210,
  id_UL_CP_SecurityInformation = 211,
  id_DL_CP_SecurityInformation = 212,
  id_TAI       = 213,
  id_UERadioCapabilityForPagingOfNB_IoT = 214,
  id_LTEV2XServicesAuthorized = 215,
  id_NRV2XServicesAuthorized = 216,
  id_LTEUESidelinkAggregateMaximumBitrate = 217,
  id_NRUESidelinkAggregateMaximumBitrate = 218,
  id_PC5QoSParameters = 219,
  id_AlternativeQoSParaSetList = 220,
  id_CurrentQoSParaSetIndex = 221,
  id_CEmodeBrestricted = 222,
  id_EUTRA_PagingeDRXInformation = 223,
  id_CEmodeBSupport_Indicator = 224,
  id_LTEM_Indication = 225,
  id_EndIndication = 226,
  id_EDT_Session = 227,
  id_UECapabilityInfoRequest = 228,
  id_PDUSessionResourceFailedToResumeListRESReq = 229,
  id_PDUSessionResourceFailedToResumeListRESRes = 230,
  id_PDUSessionResourceSuspendListSUSReq = 231,
  id_PDUSessionResourceResumeListRESReq = 232,
  id_PDUSessionResourceResumeListRESRes = 233,
  id_UE_UP_CIoT_Support = 234,
  id_Suspend_Request_Indication = 235,
  id_Suspend_Response_Indication = 236,
  id_RRC_Resume_Cause = 237,
  id_RGLevelWirelineAccessCharacteristics = 238,
  id_W_AGFIdentityInformation = 239,
  id_GlobalTNGF_ID = 240,
  id_GlobalTWIF_ID = 241,
  id_GlobalW_AGF_ID = 242,
  id_UserLocationInformationW_AGF = 243,
  id_UserLocationInformationTNGF = 244,
  id_AuthenticatedIndication = 245,
  id_TNGFIdentityInformation = 246,
  id_TWIFIdentityInformation = 247,
  id_UserLocationInformationTWIF = 248,
  id_DataForwardingResponseERABList = 249,
  id_IntersystemSONConfigurationTransferDL = 250,
  id_IntersystemSONConfigurationTransferUL = 251,
  id_SONInformationReport = 252,
  id_UEHistoryInformationFromTheUE = 253,
  id_ManagementBasedMDTPLMNList = 254,
  id_MDTConfiguration = 255,
  id_PrivacyIndicator = 256,
  id_TraceCollectionEntityURI = 257,
  id_NPN_Support = 258,
  id_NPN_AccessInformation = 259,
  id_NPN_PagingAssistanceInformation = 260,
  id_NPN_MobilityInformation = 261,
  id_TargettoSource_Failure_TransparentContainer = 262,
  id_NID       = 263,
  id_UERadioCapabilityID = 264,
  id_UERadioCapability_EUTRA_Format = 265,
  id_DAPSRequestInfo = 266,
  id_DAPSResponseInfoList = 267,
  id_EarlyStatusTransfer_TransparentContainer = 268,
  id_NotifySourceNGRANNode = 269,
  id_ExtendedSliceSupportList = 270,
  id_ExtendedTAISliceSupportList = 271,
  id_ConfiguredTACIndication = 272,
  id_Extended_RANNodeName = 273,
  id_Extended_AMFName = 274,
  id_GlobalCable_ID = 275,
  id_QosMonitoringReportingFrequency = 276,
  id_QosFlowParametersList = 277,
  id_QosFlowFeedbackList = 278,
  id_BurstArrivalTimeDownlink = 279,
  id_ExtendedUEIdentityIndexValue = 280,
  id_PduSessionExpectedUEActivityBehaviour = 281,
  id_MicoAllPLMN = 282,
  id_QosFlowFailedToSetupList = 283,
  id_SourceTNLAddrInfo = 284,
  id_ExtendedReportIntervalMDT = 285,
  id_SourceNodeID = 286,
  id_NRNTNTAIInformation = 287,
  id_UEContextReferenceAtSource = 288,
  id_LastVisitedPSCellList = 289,
  id_IntersystemSONInformationRequest = 290,
  id_IntersystemSONInformationReply = 291,
  id_EnergySavingIndication = 292,
  id_IntersystemResourceStatusUpdate = 293,
  id_SuccessfulHandoverReportList = 294,
  id_MBS_AreaSessionID = 295,
  id_MBS_QoSFlowsToBeSetupList = 296,
  id_MBS_QoSFlowsToBeSetupModList = 297,
  id_MBS_ServiceArea = 298,
  id_MBS_SessionID = 299,
  id_MBS_DistributionReleaseRequestTransfer = 300,
  id_MBS_DistributionSetupRequestTransfer = 301,
  id_MBS_DistributionSetupResponseTransfer = 302,
  id_MBS_DistributionSetupUnsuccessfulTransfer = 303,
  id_MulticastSessionActivationRequestTransfer = 304,
  id_MulticastSessionDeactivationRequestTransfer = 305,
  id_MulticastSessionUpdateRequestTransfer = 306,
  id_MulticastGroupPagingAreaList = 307,
  id_Unknown_308 = 308,
  id_MBS_SupportIndicator = 309,
  id_MBSSessionFailedtoSetupList = 310,
  id_MBSSessionFailedtoSetuporModifyList = 311,
  id_MBSSessionSetupResponseList = 312,
  id_MBSSessionSetuporModifyResponseList = 313,
  id_MBSSessionSetupFailureTransfer = 314,
  id_MBSSessionSetupRequestTransfer = 315,
  id_MBSSessionSetupResponseTransfer = 316,
  id_MBSSessionToReleaseList = 317,
  id_MBSSessionSetupRequestList = 318,
  id_MBSSessionSetuporModifyRequestList = 319,
  id_Unknown_320 = 320,
  id_Unknown_321 = 321,
  id_Unknown_322 = 322,
  id_MBS_ActiveSessionInformation_SourcetoTargetList = 323,
  id_MBS_ActiveSessionInformation_TargettoSourceList = 324,
  id_OnboardingSupport = 325,
  id_TimeSyncAssistanceInfo = 326,
  id_SurvivalTime = 327,
  id_QMCConfigInfo = 328,
  id_QMCDeactivation = 329,
  id_Unknown_330 = 330,
  id_PDUSessionPairID = 331,
  id_NR_PagingeDRXInformation = 332,
  id_RedCapIndication = 333,
  id_TargetNSSAIInformation = 334,
  id_UESliceMaximumBitRateList = 335,
  id_M4ReportAmount = 336,
  id_M5ReportAmount = 337,
  id_M6ReportAmount = 338,
  id_M7ReportAmount = 339,
  id_IncludeBeamMeasurementsIndication = 340,
  id_ExcessPacketDelayThresholdConfiguration = 341,
  id_PagingCause = 342,
  id_PagingCauseIndicationForVoiceService = 343,
  id_PEIPSassistanceInformation = 344,
  id_FiveG_ProSeAuthorized = 345,
  id_FiveG_ProSeUEPC5AggregateMaximumBitRate = 346,
  id_FiveG_ProSePC5QoSParameters = 347,
  id_MBSSessionModificationFailureTransfer = 348,
  id_MBSSessionModificationRequestTransfer = 349,
  id_MBSSessionModificationResponseTransfer = 350,
  id_MBS_QoSFlowToReleaseList = 351,
  id_MBS_SessionTNLInfo5GC = 352,
  id_TAINSAGSupportList = 353,
  id_SourceNodeTNLAddrInfo = 354,
  id_NGAPIESupportInformationRequestList = 355,
  id_NGAPIESupportInformationResponseList = 356,
  id_MBS_SessionFSAIDList = 357,
  id_MBSSessionReleaseResponseTransfer = 358,
  id_ManagementBasedMDTPLMNModificationList = 359,
  id_EarlyMeasurement = 360,
  id_BeamMeasurementsReportConfiguration = 361,
  id_HFCNode_ID_new = 362,
  id_GlobalCable_ID_new = 363,
  id_TargetHomeENB_ID = 364,
  id_HashedUEIdentityIndexValue = 365,
  id_ExtendedMobilityInformation = 366,
  id_NetworkControlledRepeaterAuthorized = 367,
  id_AdditionalCancelledlocationReportingReferenceIDList = 368,
  id_Selected_Target_SNPN_Identity = 369,
  id_EquivalentSNPNsList = 370,
  id_SelectedNID = 371,
  id_SupportedUETypeList = 372,
  id_AerialUEsubscriptionInformation = 373,
  id_NR_A2X_ServicesAuthorized = 374,
  id_LTE_A2X_ServicesAuthorized = 375,
  id_NR_A2X_UE_PC5_AggregateMaximumBitRate = 376,
  id_LTE_A2X_UE_PC5_AggregateMaximumBitRate = 377,
  id_A2X_PC5_QoS_Parameters = 378,
  id_FiveGProSeLayer2Multipath = 379,
  id_FiveGProSeLayer2UEtoUERelay = 380,
  id_FiveGProSeLayer2UEtoUERemote = 381,
  id_CandidateRelayUEInformationList = 382,
  id_SuccessfulPSCellChangeReportList = 383,
  id_IntersystemMobilityFailureforVoiceFallback = 384,
  id_TargetCellCRNTI = 385,
  id_TimeSinceFailure = 386,
  id_RANTimingSynchronisationStatusInfo = 387,
  id_RAN_TSSRequestType = 388,
  id_RAN_TSSScope = 389,
  id_ClockQualityReportingControlInfo = 390,
  id_RANfeedbacktype = 391,
  id_QoSFlowTSCList = 392,
  id_TSCTrafficCharacteristicsFeedback = 393,
  id_DownlinkTLContainer = 394,
  id_UplinkTLContainer = 395,
  id_ANPacketDelayBudgetUL = 396,
  id_QosFlowAdditionalInfoList = 397,
  id_AssistanceInformationQoE_Meas = 398,
  id_MBSCommServiceType = 399,
  id_MobileIAB_Authorized = 400,
  id_MobileIAB_MTUserLocationInformation = 401,
  id_MobileIABNodeIndication = 402,
  id_NoPDUSessionIndication = 403,
  id_MobileIAB_Supported = 404,
  id_CN_MT_CommunicationHandling = 405,
  id_FiveGCAction = 406,
  id_PagingPolicyDifferentiation = 407,
  id_DL_Signalling = 408,
  id_PNI_NPN_AreaScopeofMDT = 409,
  id_PNI_NPNBasedMDT = 410,
  id_SNPN_CellBasedMDT = 411,
  id_SNPN_TAIBasedMDT = 412,
  id_SNPN_BasedMDT = 413,
  id_Partially_Allowed_NSSAI = 414,
  id_AssociatedSessionID = 415,
  id_MBS_AssistanceInformation = 416,
  id_BroadcastTransportFailureTransfer = 417,
  id_BroadcastTransportRequestTransfer = 418,
  id_BroadcastTransportResponseTransfer = 419,
  id_TimeBasedHandoverInformation = 420,
  id_DLDiscarding = 421,
  id_PDUsetQoSParameters = 422,
  id_PDUSetbasedHandlingIndicator = 423,
  id_N6JitterInformation = 424,
  id_ECNMarkingorCongestionInformationReportingRequest = 425,
  id_ECNMarkingorCongestionInformationReportingStatus = 426,
  id_ERedCapIndication = 427,
  id_XrDeviceWith2Rx = 428,
  id_UserPlaneErrorIndicator = 429,
  id_SLPositioningRangingServiceInfo = 430,
  id_PDUSessionListMTCommHReq = 431,
  id_MaximumDataBurstVolume = 432,
  id_MN_only_MDT_collection = 433,
  id_MBS_NGUFailureIndication = 434,
  id_UserPlaneFailureIndication = 435,
  id_UserPlaneFailureIndicationReport = 436,
  id_SourceSN_to_TargetSN_QMCInfo = 437,
  id_QoERVQoEReportingPaths = 438
} ProtocolIE_ID_enum;

typedef enum _GlobalRANNodeID_enum {
  globalGNB_ID =   0,
  globalNgENB_ID =   1,
  globalN3IWF_ID =   2,
  choice_Extensions =   3
} GlobalRANNodeID_enum;

typedef enum _HandoverType_enum {
  intra5gs     =   0,
  fivegs_to_eps =   1,
  eps_to_5gs   =   2,
  fivegs_to_utran =   3
} HandoverType_enum;

typedef enum _RAT_Information_enum {
  unlicensed   =   0,
  nb_IoT       =   1,
  nR_LEO       =   2,
  nR_MEO       =   3,
  nR_GEO       =   4,
  nR_OTHERSAT  =   5
} RAT_Information_enum;

/* Initialize the protocol and registered fields */
static int proto_ngap;
static int hf_ngap_transportLayerAddressIPv4;
static int hf_ngap_transportLayerAddressIPv6;
static int hf_ngap_SerialNumber_gs;
static int hf_ngap_SerialNumber_msg_code;
static int hf_ngap_SerialNumber_upd_nb;
static int hf_ngap_WarningType_value;
static int hf_ngap_WarningType_emergency_user_alert;
static int hf_ngap_WarningType_popup;
static int hf_ngap_WarningMessageContents_nb_pages;
static int hf_ngap_WarningMessageContents_decoded_page;
static int hf_ngap_NGRANTraceID_TraceID;
static int hf_ngap_NGRANTraceID_TraceRecordingSessionReference;
static int hf_ngap_InterfacesToTrace_NG_C;
static int hf_ngap_InterfacesToTrace_Xn_C;
static int hf_ngap_InterfacesToTrace_Uu;
static int hf_ngap_InterfacesToTrace_F1_C;
static int hf_ngap_InterfacesToTrace_E1;
static int hf_ngap_InterfacesToTrace_reserved;
static int hf_ngap_RATRestrictionInformation_e_UTRA;
static int hf_ngap_RATRestrictionInformation_nR;
static int hf_ngap_RATRestrictionInformation_nR_unlicensed;
static int hf_ngap_RATRestrictionInformation_reserved;
static int hf_ngap_primaryRATRestriction_e_UTRA;
static int hf_ngap_primaryRATRestriction_nR;
static int hf_ngap_primaryRATRestriction_nR_unlicensed;
static int hf_ngap_primaryRATRestriction_nR_LEO;
static int hf_ngap_primaryRATRestriction_nR_MEO;
static int hf_ngap_primaryRATRestriction_nR_GEO;
static int hf_ngap_primaryRATRestriction_nR_OTHERSAT;
static int hf_ngap_primaryRATRestriction_e_UTRA_LEO;
static int hf_ngap_primaryRATRestriction_e_UTRA_MEO;
static int hf_ngap_primaryRATRestriction_e_UTRA_GEO;
static int hf_ngap_primaryRATRestriction_e_UTRA_OTHERSAT;
static int hf_ngap_primaryRATRestriction_reserved;
static int hf_ngap_secondaryRATRestriction_e_UTRA;
static int hf_ngap_secondaryRATRestriction_nR;
static int hf_ngap_secondaryRATRestriction_e_UTRA_unlicensed;
static int hf_ngap_secondaryRATRestriction_nR_unlicensed;
static int hf_ngap_secondaryRATRestriction_reserved;
static int hf_ngap_NrencryptionAlgorithms_nea1;
static int hf_ngap_NrencryptionAlgorithms_nea2;
static int hf_ngap_NrencryptionAlgorithms_nea3;
static int hf_ngap_NrencryptionAlgorithms_reserved;
static int hf_ngap_NrintegrityProtectionAlgorithms_nia1;
static int hf_ngap_NrintegrityProtectionAlgorithms_nia2;
static int hf_ngap_NrintegrityProtectionAlgorithms_nia3;
static int hf_ngap_NrintegrityProtectionAlgorithms_reserved;
static int hf_ngap_EUTRAencryptionAlgorithms_eea1;
static int hf_ngap_EUTRAencryptionAlgorithms_eea2;
static int hf_ngap_EUTRAencryptionAlgorithms_eea3;
static int hf_ngap_EUTRAencryptionAlgorithms_reserved;
static int hf_ngap_EUTRAintegrityProtectionAlgorithms_eia1;
static int hf_ngap_EUTRAintegrityProtectionAlgorithms_eia2;
static int hf_ngap_EUTRAintegrityProtectionAlgorithms_eia3;
static int hf_ngap_EUTRAintegrityProtectionAlgorithms_eia7;
static int hf_ngap_EUTRAintegrityProtectionAlgorithms_reserved;
static int hf_ngap_MeasurementsToActivate_M1;
static int hf_ngap_MeasurementsToActivate_M2;
static int hf_ngap_MeasurementsToActivate_M4;
static int hf_ngap_MeasurementsToActivate_M5;
static int hf_ngap_MeasurementsToActivate_M6;
static int hf_ngap_MeasurementsToActivate_M7;
static int hf_ngap_MeasurementsToActivate_M1_from_event;
static int hf_ngap_MeasurementsToActivate_reserved;
static int hf_ngap_MDT_Location_Information_GNSS;
static int hf_ngap_MDT_Location_Information_reserved;
static int hf_ngap_GlobalCable_ID_str;
static int hf_ngap_UpdateFeedback_CN_PDB_DL;
static int hf_ngap_UpdateFeedback_CN_PDB_UL;
static int hf_ngap_UpdateFeedback_reserved;
static int hf_ngap_AdditionalDLUPTNLInformationForHOList_PDU;  /* AdditionalDLUPTNLInformationForHOList */
static int hf_ngap_AerialUEsubscriptionInformation_PDU;  /* AerialUEsubscriptionInformation */
static int hf_ngap_A2X_PC5_QoS_Parameters_PDU;    /* A2X_PC5_QoS_Parameters */
static int hf_ngap_AdditionalCancelledlocationReportingReferenceIDList_PDU;  /* AdditionalCancelledlocationReportingReferenceIDList */
static int hf_ngap_AllowedNSSAI_PDU;              /* AllowedNSSAI */
static int hf_ngap_AlternativeQoSParaSetIndex_PDU;  /* AlternativeQoSParaSetIndex */
static int hf_ngap_AlternativeQoSParaSetList_PDU;  /* AlternativeQoSParaSetList */
static int hf_ngap_AssistanceInformationQoE_Meas_PDU;  /* AssistanceInformationQoE_Meas */
static int hf_ngap_AMFName_PDU;                   /* AMFName */
static int hf_ngap_AMFSetID_PDU;                  /* AMFSetID */
static int hf_ngap_AMF_TNLAssociationSetupList_PDU;  /* AMF_TNLAssociationSetupList */
static int hf_ngap_AMF_TNLAssociationToAddList_PDU;  /* AMF_TNLAssociationToAddList */
static int hf_ngap_AMF_TNLAssociationToRemoveList_PDU;  /* AMF_TNLAssociationToRemoveList */
static int hf_ngap_AMF_TNLAssociationToUpdateList_PDU;  /* AMF_TNLAssociationToUpdateList */
static int hf_ngap_AMF_UE_NGAP_ID_PDU;            /* AMF_UE_NGAP_ID */
static int hf_ngap_AssistanceDataForPaging_PDU;   /* AssistanceDataForPaging */
static int hf_ngap_AssociatedQosFlowList_PDU;     /* AssociatedQosFlowList */
static int hf_ngap_AssociatedSessionID_PDU;       /* AssociatedSessionID */
static int hf_ngap_AuthenticatedIndication_PDU;   /* AuthenticatedIndication */
static int hf_ngap_BeamMeasurementsReportConfiguration_PDU;  /* BeamMeasurementsReportConfiguration */
static int hf_ngap_BroadcastCancelledAreaList_PDU;  /* BroadcastCancelledAreaList */
static int hf_ngap_BroadcastCompletedAreaList_PDU;  /* BroadcastCompletedAreaList */
static int hf_ngap_BurstArrivalTime_PDU;          /* BurstArrivalTime */
static int hf_ngap_CandidateRelayUEInformationList_PDU;  /* CandidateRelayUEInformationList */
static int hf_ngap_CancelAllWarningMessages_PDU;  /* CancelAllWarningMessages */
static int hf_ngap_Cause_PDU;                     /* Cause */
static int hf_ngap_CellIDListForRestart_PDU;      /* CellIDListForRestart */
static int hf_ngap_CEmodeBSupport_Indicator_PDU;  /* CEmodeBSupport_Indicator */
static int hf_ngap_CEmodeBrestricted_PDU;         /* CEmodeBrestricted */
static int hf_ngap_ClockQualityReportingControlInfo_PDU;  /* ClockQualityReportingControlInfo */
static int hf_ngap_CNAssistedRANTuning_PDU;       /* CNAssistedRANTuning */
static int hf_ngap_CNTypeRestrictionsForEquivalent_PDU;  /* CNTypeRestrictionsForEquivalent */
static int hf_ngap_CNTypeRestrictionsForServing_PDU;  /* CNTypeRestrictionsForServing */
static int hf_ngap_CommonNetworkInstance_PDU;     /* CommonNetworkInstance */
static int hf_ngap_ConcurrentWarningMessageInd_PDU;  /* ConcurrentWarningMessageInd */
static int hf_ngap_ConfiguredTACIndication_PDU;   /* ConfiguredTACIndication */
static int hf_ngap_CoreNetworkAssistanceInformationForInactive_PDU;  /* CoreNetworkAssistanceInformationForInactive */
static int hf_ngap_CN_MT_CommunicationHandling_PDU;  /* CN_MT_CommunicationHandling */
static int hf_ngap_CPTransportLayerInformation_PDU;  /* CPTransportLayerInformation */
static int hf_ngap_CriticalityDiagnostics_PDU;    /* CriticalityDiagnostics */
static int hf_ngap_C_RNTI_PDU;                    /* C_RNTI */
static int hf_ngap_DataCodingScheme_PDU;          /* DataCodingScheme */
static int hf_ngap_DataForwardingNotPossible_PDU;  /* DataForwardingNotPossible */
static int hf_ngap_DAPSRequestInfo_PDU;           /* DAPSRequestInfo */
static int hf_ngap_DAPSResponseInfoList_PDU;      /* DAPSResponseInfoList */
static int hf_ngap_DataForwardingResponseERABList_PDU;  /* DataForwardingResponseERABList */
static int hf_ngap_DL_CP_SecurityInformation_PDU;  /* DL_CP_SecurityInformation */
static int hf_ngap_DL_Signalling_PDU;             /* DL_Signalling */
static int hf_ngap_DL_NGU_TNLInformationReused_PDU;  /* DL_NGU_TNLInformationReused */
static int hf_ngap_DirectForwardingPathAvailability_PDU;  /* DirectForwardingPathAvailability */
static int hf_ngap_EarlyMeasurement_PDU;          /* EarlyMeasurement */
static int hf_ngap_EarlyStatusTransfer_TransparentContainer_PDU;  /* EarlyStatusTransfer_TransparentContainer */
static int hf_ngap_DLDiscarding_PDU;              /* DLDiscarding */
static int hf_ngap_ECNMarkingorCongestionInformationReportingRequest_PDU;  /* ECNMarkingorCongestionInformationReportingRequest */
static int hf_ngap_ECNMarkingorCongestionInformationReportingStatus_PDU;  /* ECNMarkingorCongestionInformationReportingStatus */
static int hf_ngap_EDT_Session_PDU;               /* EDT_Session */
static int hf_ngap_EmergencyAreaIDListForRestart_PDU;  /* EmergencyAreaIDListForRestart */
static int hf_ngap_EmergencyFallbackIndicator_PDU;  /* EmergencyFallbackIndicator */
static int hf_ngap_Enhanced_CoverageRestriction_PDU;  /* Enhanced_CoverageRestriction */
static int hf_ngap_Extended_ConnectedTime_PDU;    /* Extended_ConnectedTime */
static int hf_ngap_EN_DCSONConfigurationTransfer_PDU;  /* EN_DCSONConfigurationTransfer */
static int hf_ngap_EndpointIPAddressAndPort_PDU;  /* EndpointIPAddressAndPort */
static int hf_ngap_EndIndication_PDU;             /* EndIndication */
static int hf_ngap_ERedCapIndication_PDU;         /* ERedCapIndication */
static int hf_ngap_EUTRA_CGI_PDU;                 /* EUTRA_CGI */
static int hf_ngap_EUTRA_PagingeDRXInformation_PDU;  /* EUTRA_PagingeDRXInformation */
static int hf_ngap_ExcessPacketDelayThresholdConfiguration_PDU;  /* ExcessPacketDelayThresholdConfiguration */
static int hf_ngap_ExpectedUEActivityBehaviour_PDU;  /* ExpectedUEActivityBehaviour */
static int hf_ngap_Extended_AMFName_PDU;          /* Extended_AMFName */
static int hf_ngap_ExtendedPacketDelayBudget_PDU;  /* ExtendedPacketDelayBudget */
static int hf_ngap_Extended_RANNodeName_PDU;      /* Extended_RANNodeName */
static int hf_ngap_ExtendedRATRestrictionInformation_PDU;  /* ExtendedRATRestrictionInformation */
static int hf_ngap_ExtendedSliceSupportList_PDU;  /* ExtendedSliceSupportList */
static int hf_ngap_ExtendedUEIdentityIndexValue_PDU;  /* ExtendedUEIdentityIndexValue */
static int hf_ngap_EquivalentSNPNsList_PDU;       /* EquivalentSNPNsList */
static int hf_ngap_FiveGCAction_PDU;              /* FiveGCAction */
static int hf_ngap_FiveG_ProSeAuthorized_PDU;     /* FiveG_ProSeAuthorized */
static int hf_ngap_FiveGProSeLayer2Multipath_PDU;  /* FiveGProSeLayer2Multipath */
static int hf_ngap_FiveGProSeLayer2UEtoUERelay_PDU;  /* FiveGProSeLayer2UEtoUERelay */
static int hf_ngap_FiveGProSeLayer2UEtoUERemote_PDU;  /* FiveGProSeLayer2UEtoUERemote */
static int hf_ngap_FiveG_ProSePC5QoSParameters_PDU;  /* FiveG_ProSePC5QoSParameters */
static int hf_ngap_FiveG_S_TMSI_PDU;              /* FiveG_S_TMSI */
static int hf_ngap_GlobalCable_ID_PDU;            /* GlobalCable_ID */
static int hf_ngap_GlobalCable_ID_new_PDU;        /* GlobalCable_ID_new */
static int hf_ngap_GlobalRANNodeID_PDU;           /* GlobalRANNodeID */
static int hf_ngap_GlobalTNGF_ID_PDU;             /* GlobalTNGF_ID */
static int hf_ngap_GlobalTWIF_ID_PDU;             /* GlobalTWIF_ID */
static int hf_ngap_GlobalW_AGF_ID_PDU;            /* GlobalW_AGF_ID */
static int hf_ngap_GUAMI_PDU;                     /* GUAMI */
static int hf_ngap_GUAMIType_PDU;                 /* GUAMIType */
static int hf_ngap_HandoverCommandTransfer_PDU;   /* HandoverCommandTransfer */
static int hf_ngap_HandoverFlag_PDU;              /* HandoverFlag */
static int hf_ngap_HandoverPreparationUnsuccessfulTransfer_PDU;  /* HandoverPreparationUnsuccessfulTransfer */
static int hf_ngap_HandoverRequestAcknowledgeTransfer_PDU;  /* HandoverRequestAcknowledgeTransfer */
static int hf_ngap_HandoverRequiredTransfer_PDU;  /* HandoverRequiredTransfer */
static int hf_ngap_HandoverResourceAllocationUnsuccessfulTransfer_PDU;  /* HandoverResourceAllocationUnsuccessfulTransfer */
static int hf_ngap_HandoverType_PDU;              /* HandoverType */
static int hf_ngap_HashedUEIdentityIndexValue_PDU;  /* HashedUEIdentityIndexValue */
static int hf_ngap_HFCNode_ID_new_PDU;            /* HFCNode_ID_new */
static int hf_ngap_IAB_Authorized_PDU;            /* IAB_Authorized */
static int hf_ngap_MobileIAB_MTUserLocationInformation_PDU;  /* MobileIAB_MTUserLocationInformation */
static int hf_ngap_IAB_Supported_PDU;             /* IAB_Supported */
static int hf_ngap_IABNodeIndication_PDU;         /* IABNodeIndication */
static int hf_ngap_IMSVoiceSupportIndicator_PDU;  /* IMSVoiceSupportIndicator */
static int hf_ngap_IndexToRFSP_PDU;               /* IndexToRFSP */
static int hf_ngap_InfoOnRecommendedCellsAndRANNodesForPaging_PDU;  /* InfoOnRecommendedCellsAndRANNodesForPaging */
static int hf_ngap_IntersystemSONConfigurationTransfer_PDU;  /* IntersystemSONConfigurationTransfer */
static int hf_ngap_IntersystemSONInformationRequest_PDU;  /* IntersystemSONInformationRequest */
static int hf_ngap_IntersystemSONInformationReply_PDU;  /* IntersystemSONInformationReply */
static int hf_ngap_IntersystemCellStateIndication_PDU;  /* IntersystemCellStateIndication */
static int hf_ngap_IntersystemResourceStatusReport_PDU;  /* IntersystemResourceStatusReport */
static int hf_ngap_IntersystemMobilityFailureforVoiceFallback_PDU;  /* IntersystemMobilityFailureforVoiceFallback */
static int hf_ngap_ngap_LastVisitedNGRANCellInformation_PDU;  /* LastVisitedNGRANCellInformation */
static int hf_ngap_LastVisitedPSCellList_PDU;     /* LastVisitedPSCellList */
static int hf_ngap_ngap_LastVisitedPSCellInformation_PDU;  /* LastVisitedPSCellInformation */
static int hf_ngap_LocationReportingAdditionalInfo_PDU;  /* LocationReportingAdditionalInfo */
static int hf_ngap_LocationReportingRequestType_PDU;  /* LocationReportingRequestType */
static int hf_ngap_LTEM_Indication_PDU;           /* LTEM_Indication */
static int hf_ngap_LTEV2XServicesAuthorized_PDU;  /* LTEV2XServicesAuthorized */
static int hf_ngap_LTEUESidelinkAggregateMaximumBitrate_PDU;  /* LTEUESidelinkAggregateMaximumBitrate */
static int hf_ngap_LTE_A2X_ServicesAuthorized_PDU;  /* LTE_A2X_ServicesAuthorized */
static int hf_ngap_MaskedIMEISV_PDU;              /* MaskedIMEISV */
static int hf_ngap_MaximumDataBurstVolume_PDU;    /* MaximumDataBurstVolume */
static int hf_ngap_MessageIdentifier_PDU;         /* MessageIdentifier */
static int hf_ngap_MaximumIntegrityProtectedDataRate_PDU;  /* MaximumIntegrityProtectedDataRate */
static int hf_ngap_MBS_AreaSessionID_PDU;         /* MBS_AreaSessionID */
static int hf_ngap_MBSCommServiceType_PDU;        /* MBSCommServiceType */
static int hf_ngap_MBS_QoSFlowsToBeSetupList_PDU;  /* MBS_QoSFlowsToBeSetupList */
static int hf_ngap_MBS_ServiceArea_PDU;           /* MBS_ServiceArea */
static int hf_ngap_MBS_SessionID_PDU;             /* MBS_SessionID */
static int hf_ngap_MBSSessionFailedtoSetupList_PDU;  /* MBSSessionFailedtoSetupList */
static int hf_ngap_MBS_ActiveSessionInformation_SourcetoTargetList_PDU;  /* MBS_ActiveSessionInformation_SourcetoTargetList */
static int hf_ngap_MBS_ActiveSessionInformation_TargettoSourceList_PDU;  /* MBS_ActiveSessionInformation_TargettoSourceList */
static int hf_ngap_MBS_AssistanceInformation_PDU;  /* MBS_AssistanceInformation */
static int hf_ngap_MBSSessionSetupOrModFailureTransfer_PDU;  /* MBSSessionSetupOrModFailureTransfer */
static int hf_ngap_MBSSessionSetupResponseList_PDU;  /* MBSSessionSetupResponseList */
static int hf_ngap_MBSSessionSetupOrModRequestTransfer_PDU;  /* MBSSessionSetupOrModRequestTransfer */
static int hf_ngap_SupportedUETypeList_PDU;       /* SupportedUETypeList */
static int hf_ngap_MBS_SessionFSAIDList_PDU;      /* MBS_SessionFSAIDList */
static int hf_ngap_MBSSessionReleaseResponseTransfer_PDU;  /* MBSSessionReleaseResponseTransfer */
static int hf_ngap_MBSSessionSetupOrModResponseTransfer_PDU;  /* MBSSessionSetupOrModResponseTransfer */
static int hf_ngap_MBS_SupportIndicator_PDU;      /* MBS_SupportIndicator */
static int hf_ngap_MBS_SessionTNLInfo5GC_PDU;     /* MBS_SessionTNLInfo5GC */
static int hf_ngap_MBS_NGUFailureIndication_PDU;  /* MBS_NGUFailureIndication */
static int hf_ngap_MBSSessionSetupRequestList_PDU;  /* MBSSessionSetupRequestList */
static int hf_ngap_MBSSessionSetuporModifyRequestList_PDU;  /* MBSSessionSetuporModifyRequestList */
static int hf_ngap_MBSSessionToReleaseList_PDU;   /* MBSSessionToReleaseList */
static int hf_ngap_MicoAllPLMN_PDU;               /* MicoAllPLMN */
static int hf_ngap_ExtendedMobilityInformation_PDU;  /* ExtendedMobilityInformation */
static int hf_ngap_ngap_MobilityRestrictionList_PDU;  /* MobilityRestrictionList */
static int hf_ngap_MDTPLMNList_PDU;               /* MDTPLMNList */
static int hf_ngap_MDTPLMNModificationList_PDU;   /* MDTPLMNModificationList */
static int hf_ngap_ngap_MDT_Configuration_PDU;    /* MDT_Configuration */
static int hf_ngap_MN_only_MDT_collection_PDU;    /* MN_only_MDT_collection */
static int hf_ngap_MobileIAB_Authorized_PDU;      /* MobileIAB_Authorized */
static int hf_ngap_MobileIABNodeIndication_PDU;   /* MobileIABNodeIndication */
static int hf_ngap_MobileIAB_Supported_PDU;       /* MobileIAB_Supported */
static int hf_ngap_MulticastGroupPagingAreaList_PDU;  /* MulticastGroupPagingAreaList */
static int hf_ngap_IncludeBeamMeasurementsIndication_PDU;  /* IncludeBeamMeasurementsIndication */
static int hf_ngap_M4ReportAmountMDT_PDU;         /* M4ReportAmountMDT */
static int hf_ngap_M5ReportAmountMDT_PDU;         /* M5ReportAmountMDT */
static int hf_ngap_M6ReportAmountMDT_PDU;         /* M6ReportAmountMDT */
static int hf_ngap_M7ReportAmountMDT_PDU;         /* M7ReportAmountMDT */
static int hf_ngap_N6JitterInformation_PDU;       /* N6JitterInformation */
static int hf_ngap_NAS_PDU_PDU;                   /* NAS_PDU */
static int hf_ngap_NASSecurityParametersFromNGRAN_PDU;  /* NASSecurityParametersFromNGRAN */
static int hf_ngap_NB_IoT_DefaultPagingDRX_PDU;   /* NB_IoT_DefaultPagingDRX */
static int hf_ngap_NB_IoT_PagingDRX_PDU;          /* NB_IoT_PagingDRX */
static int hf_ngap_NB_IoT_Paging_eDRXInfo_PDU;    /* NB_IoT_Paging_eDRXInfo */
static int hf_ngap_NB_IoT_UEPriority_PDU;         /* NB_IoT_UEPriority */
static int hf_ngap_NetworkControlledRepeaterAuthorized_PDU;  /* NetworkControlledRepeaterAuthorized */
static int hf_ngap_NetworkInstance_PDU;           /* NetworkInstance */
static int hf_ngap_NewSecurityContextInd_PDU;     /* NewSecurityContextInd */
static int hf_ngap_NGAPIESupportInformationRequestList_PDU;  /* NGAPIESupportInformationRequestList */
static int hf_ngap_NGAPIESupportInformationResponseList_PDU;  /* NGAPIESupportInformationResponseList */
static int hf_ngap_NotifySourceNGRANNode_PDU;     /* NotifySourceNGRANNode */
static int hf_ngap_ngap_NGRAN_CGI_PDU;            /* NGRAN_CGI */
static int hf_ngap_NGRAN_TNLAssociationToRemoveList_PDU;  /* NGRAN_TNLAssociationToRemoveList */
static int hf_ngap_NGRANTraceID_PDU;              /* NGRANTraceID */
static int hf_ngap_NID_PDU;                       /* NID */
static int hf_ngap_NoPDUSessionIndication_PDU;    /* NoPDUSessionIndication */
static int hf_ngap_NPN_AccessInformation_PDU;     /* NPN_AccessInformation */
static int hf_ngap_NPN_MobilityInformation_PDU;   /* NPN_MobilityInformation */
static int hf_ngap_NPN_PagingAssistanceInformation_PDU;  /* NPN_PagingAssistanceInformation */
static int hf_ngap_NPN_Support_PDU;               /* NPN_Support */
static int hf_ngap_NR_CGI_PDU;                    /* NR_CGI */
static int hf_ngap_NR_PagingeDRXInformation_PDU;  /* NR_PagingeDRXInformation */
static int hf_ngap_NRPPa_PDU_PDU;                 /* NRPPa_PDU */
static int hf_ngap_NRNTNTAIInformation_PDU;       /* NRNTNTAIInformation */
static int hf_ngap_NumberOfBroadcastsRequested_PDU;  /* NumberOfBroadcastsRequested */
static int hf_ngap_NRV2XServicesAuthorized_PDU;   /* NRV2XServicesAuthorized */
static int hf_ngap_NRUESidelinkAggregateMaximumBitrate_PDU;  /* NRUESidelinkAggregateMaximumBitrate */
static int hf_ngap_NR_A2X_ServicesAuthorized_PDU;  /* NR_A2X_ServicesAuthorized */
static int hf_ngap_OnboardingSupport_PDU;         /* OnboardingSupport */
static int hf_ngap_OverloadResponse_PDU;          /* OverloadResponse */
static int hf_ngap_OverloadStartNSSAIList_PDU;    /* OverloadStartNSSAIList */
static int hf_ngap_PagingAssisDataforCEcapabUE_PDU;  /* PagingAssisDataforCEcapabUE */
static int hf_ngap_PagingCause_PDU;               /* PagingCause */
static int hf_ngap_PagingCauseIndicationForVoiceService_PDU;  /* PagingCauseIndicationForVoiceService */
static int hf_ngap_PagingDRX_PDU;                 /* PagingDRX */
static int hf_ngap_PagingOrigin_PDU;              /* PagingOrigin */
static int hf_ngap_PagingPolicyDifferentiation_PDU;  /* PagingPolicyDifferentiation */
static int hf_ngap_PagingPriority_PDU;            /* PagingPriority */
static int hf_ngap_Partially_Allowed_NSSAI_PDU;   /* Partially_Allowed_NSSAI */
static int hf_ngap_PathSwitchRequestAcknowledgeTransfer_PDU;  /* PathSwitchRequestAcknowledgeTransfer */
static int hf_ngap_PathSwitchRequestSetupFailedTransfer_PDU;  /* PathSwitchRequestSetupFailedTransfer */
static int hf_ngap_PathSwitchRequestTransfer_PDU;  /* PathSwitchRequestTransfer */
static int hf_ngap_PathSwitchRequestUnsuccessfulTransfer_PDU;  /* PathSwitchRequestUnsuccessfulTransfer */
static int hf_ngap_PC5QoSParameters_PDU;          /* PC5QoSParameters */
static int hf_ngap_PrivacyIndicator_PDU;          /* PrivacyIndicator */
static int hf_ngap_PDUSessionAggregateMaximumBitRate_PDU;  /* PDUSessionAggregateMaximumBitRate */
static int hf_ngap_PDUSessionPairID_PDU;          /* PDUSessionPairID */
static int hf_ngap_PDUSessionResourceAdmittedList_PDU;  /* PDUSessionResourceAdmittedList */
static int hf_ngap_PDUSessionResourceFailedToModifyListModCfm_PDU;  /* PDUSessionResourceFailedToModifyListModCfm */
static int hf_ngap_PDUSessionResourceFailedToModifyListModRes_PDU;  /* PDUSessionResourceFailedToModifyListModRes */
static int hf_ngap_PDUSessionResourceFailedToResumeListRESReq_PDU;  /* PDUSessionResourceFailedToResumeListRESReq */
static int hf_ngap_PDUSessionResourceFailedToResumeListRESRes_PDU;  /* PDUSessionResourceFailedToResumeListRESRes */
static int hf_ngap_PDUSessionResourceFailedToSetupListCxtFail_PDU;  /* PDUSessionResourceFailedToSetupListCxtFail */
static int hf_ngap_PDUSessionResourceFailedToSetupListCxtRes_PDU;  /* PDUSessionResourceFailedToSetupListCxtRes */
static int hf_ngap_PDUSessionResourceFailedToSetupListHOAck_PDU;  /* PDUSessionResourceFailedToSetupListHOAck */
static int hf_ngap_PDUSessionResourceFailedToSetupListPSReq_PDU;  /* PDUSessionResourceFailedToSetupListPSReq */
static int hf_ngap_PDUSessionResourceFailedToSetupListSURes_PDU;  /* PDUSessionResourceFailedToSetupListSURes */
static int hf_ngap_PDUSessionResourceHandoverList_PDU;  /* PDUSessionResourceHandoverList */
static int hf_ngap_PDUSessionResourceListCxtRelCpl_PDU;  /* PDUSessionResourceListCxtRelCpl */
static int hf_ngap_PDUSessionResourceReleaseResponseTransfer_OCTET_STRING_PDU;  /* PDUSessionResourceReleaseResponseTransfer_OCTET_STRING */
static int hf_ngap_PDUSessionResourceListCxtRelReq_PDU;  /* PDUSessionResourceListCxtRelReq */
static int hf_ngap_PDUSessionResourceListHORqd_PDU;  /* PDUSessionResourceListHORqd */
static int hf_ngap_PDUSessionListMTCommHReq_PDU;  /* PDUSessionListMTCommHReq */
static int hf_ngap_PDUSessionResourceModifyConfirmTransfer_PDU;  /* PDUSessionResourceModifyConfirmTransfer */
static int hf_ngap_PDUSessionResourceModifyIndicationUnsuccessfulTransfer_PDU;  /* PDUSessionResourceModifyIndicationUnsuccessfulTransfer */
static int hf_ngap_PDUSessionResourceModifyRequestTransfer_PDU;  /* PDUSessionResourceModifyRequestTransfer */
static int hf_ngap_PDUSessionResourceModifyResponseTransfer_PDU;  /* PDUSessionResourceModifyResponseTransfer */
static int hf_ngap_PDUSessionResourceModifyIndicationTransfer_PDU;  /* PDUSessionResourceModifyIndicationTransfer */
static int hf_ngap_PDUSessionResourceModifyListModCfm_PDU;  /* PDUSessionResourceModifyListModCfm */
static int hf_ngap_PDUSessionResourceModifyListModInd_PDU;  /* PDUSessionResourceModifyListModInd */
static int hf_ngap_PDUSessionResourceModifyListModReq_PDU;  /* PDUSessionResourceModifyListModReq */
static int hf_ngap_PDUSessionResourceModifyListModRes_PDU;  /* PDUSessionResourceModifyListModRes */
static int hf_ngap_PDUSessionResourceModifyUnsuccessfulTransfer_PDU;  /* PDUSessionResourceModifyUnsuccessfulTransfer */
static int hf_ngap_PDUSessionResourceNotifyList_PDU;  /* PDUSessionResourceNotifyList */
static int hf_ngap_PDUSessionResourceNotifyReleasedTransfer_PDU;  /* PDUSessionResourceNotifyReleasedTransfer */
static int hf_ngap_UserPlaneErrorIndicator_PDU;   /* UserPlaneErrorIndicator */
static int hf_ngap_PDUSessionResourceNotifyTransfer_PDU;  /* PDUSessionResourceNotifyTransfer */
static int hf_ngap_PDUSessionResourceReleaseCommandTransfer_PDU;  /* PDUSessionResourceReleaseCommandTransfer */
static int hf_ngap_PDUSessionResourceReleasedListNot_PDU;  /* PDUSessionResourceReleasedListNot */
static int hf_ngap_PDUSessionResourceReleasedListPSAck_PDU;  /* PDUSessionResourceReleasedListPSAck */
static int hf_ngap_PDUSessionResourceReleasedListPSFail_PDU;  /* PDUSessionResourceReleasedListPSFail */
static int hf_ngap_PDUSessionResourceReleasedListRelRes_PDU;  /* PDUSessionResourceReleasedListRelRes */
static int hf_ngap_PDUSessionResourceReleaseResponseTransfer_PDU;  /* PDUSessionResourceReleaseResponseTransfer */
static int hf_ngap_PDUSessionResourceResumeListRESReq_PDU;  /* PDUSessionResourceResumeListRESReq */
static int hf_ngap_PDUSessionResourceResumeListRESRes_PDU;  /* PDUSessionResourceResumeListRESRes */
static int hf_ngap_PDUSessionResourceSecondaryRATUsageList_PDU;  /* PDUSessionResourceSecondaryRATUsageList */
static int hf_ngap_PDUSessionResourceSetupListCxtReq_PDU;  /* PDUSessionResourceSetupListCxtReq */
static int hf_ngap_PDUSessionResourceSetupListCxtRes_PDU;  /* PDUSessionResourceSetupListCxtRes */
static int hf_ngap_PDUSessionResourceSetupListHOReq_PDU;  /* PDUSessionResourceSetupListHOReq */
static int hf_ngap_PDUSessionResourceSetupListSUReq_PDU;  /* PDUSessionResourceSetupListSUReq */
static int hf_ngap_PDUSessionResourceSetupListSURes_PDU;  /* PDUSessionResourceSetupListSURes */
static int hf_ngap_PDUSessionResourceSetupRequestTransfer_PDU;  /* PDUSessionResourceSetupRequestTransfer */
static int hf_ngap_PDUSessionResourceSetupResponseTransfer_PDU;  /* PDUSessionResourceSetupResponseTransfer */
static int hf_ngap_PDUSessionResourceSetupUnsuccessfulTransfer_PDU;  /* PDUSessionResourceSetupUnsuccessfulTransfer */
static int hf_ngap_PDUSessionResourceSuspendListSUSReq_PDU;  /* PDUSessionResourceSuspendListSUSReq */
static int hf_ngap_PDUSessionResourceSwitchedList_PDU;  /* PDUSessionResourceSwitchedList */
static int hf_ngap_PDUSessionResourceToBeSwitchedDLList_PDU;  /* PDUSessionResourceToBeSwitchedDLList */
static int hf_ngap_PDUSessionResourceToReleaseListHOCmd_PDU;  /* PDUSessionResourceToReleaseListHOCmd */
static int hf_ngap_PDUSessionResourceToReleaseListRelCmd_PDU;  /* PDUSessionResourceToReleaseListRelCmd */
static int hf_ngap_PDUSessionType_PDU;            /* PDUSessionType */
static int hf_ngap_PDUsetQoSParameters_PDU;       /* PDUsetQoSParameters */
static int hf_ngap_PDUSetbasedHandlingIndicator_PDU;  /* PDUSetbasedHandlingIndicator */
static int hf_ngap_PEIPSassistanceInformation_PDU;  /* PEIPSassistanceInformation */
static int hf_ngap_PLMNIdentity_PDU;              /* PLMNIdentity */
static int hf_ngap_PLMNSupportList_PDU;           /* PLMNSupportList */
static int hf_ngap_PWSFailedCellIDList_PDU;       /* PWSFailedCellIDList */
static int hf_ngap_PNI_NPN_AreaScopeofMDT_PDU;    /* PNI_NPN_AreaScopeofMDT */
static int hf_ngap_PNI_NPNBasedMDT_PDU;           /* PNI_NPNBasedMDT */
static int hf_ngap_QMCConfigInfo_PDU;             /* QMCConfigInfo */
static int hf_ngap_QMCDeactivation_PDU;           /* QMCDeactivation */
static int hf_ngap_QoERVQoEReportingPaths_PDU;    /* QoERVQoEReportingPaths */
static int hf_ngap_QosFlowAdditionalInfoListRelCom_PDU;  /* QosFlowAdditionalInfoListRelCom */
static int hf_ngap_QosFlowAdditionalInfoListRelRes_PDU;  /* QosFlowAdditionalInfoListRelRes */
static int hf_ngap_QosFlowAddOrModifyRequestList_PDU;  /* QosFlowAddOrModifyRequestList */
static int hf_ngap_QosFlowFeedbackList_PDU;       /* QosFlowFeedbackList */
static int hf_ngap_QosMonitoringRequest_PDU;      /* QosMonitoringRequest */
static int hf_ngap_QosMonitoringReportingFrequency_PDU;  /* QosMonitoringReportingFrequency */
static int hf_ngap_QosFlowListWithCause_PDU;      /* QosFlowListWithCause */
static int hf_ngap_QosFlowParametersList_PDU;     /* QosFlowParametersList */
static int hf_ngap_QosFlowPerTNLInformation_PDU;  /* QosFlowPerTNLInformation */
static int hf_ngap_QosFlowPerTNLInformationList_PDU;  /* QosFlowPerTNLInformationList */
static int hf_ngap_QosFlowSetupRequestList_PDU;   /* QosFlowSetupRequestList */
static int hf_ngap_QoSFlowTSCList_PDU;            /* QoSFlowTSCList */
static int hf_ngap_RANfeedbacktype_PDU;           /* RANfeedbacktype */
static int hf_ngap_RANNodeName_PDU;               /* RANNodeName */
static int hf_ngap_RANPagingPriority_PDU;         /* RANPagingPriority */
static int hf_ngap_RANStatusTransfer_TransparentContainer_PDU;  /* RANStatusTransfer_TransparentContainer */
static int hf_ngap_RANTimingSynchronisationStatusInfo_PDU;  /* RANTimingSynchronisationStatusInfo */
static int hf_ngap_RAN_TSSRequestType_PDU;        /* RAN_TSSRequestType */
static int hf_ngap_RAN_TSSScope_PDU;              /* RAN_TSSScope */
static int hf_ngap_RAN_UE_NGAP_ID_PDU;            /* RAN_UE_NGAP_ID */
static int hf_ngap_RAT_Information_PDU;           /* RAT_Information */
static int hf_ngap_RedCapIndication_PDU;          /* RedCapIndication */
static int hf_ngap_RedirectionVoiceFallback_PDU;  /* RedirectionVoiceFallback */
static int hf_ngap_RedundantPDUSessionInformation_PDU;  /* RedundantPDUSessionInformation */
static int hf_ngap_RedundantQosFlowIndicator_PDU;  /* RedundantQosFlowIndicator */
static int hf_ngap_RelativeAMFCapacity_PDU;       /* RelativeAMFCapacity */
static int hf_ngap_RepetitionPeriod_PDU;          /* RepetitionPeriod */
static int hf_ngap_ExtendedReportIntervalMDT_PDU;  /* ExtendedReportIntervalMDT */
static int hf_ngap_ResetType_PDU;                 /* ResetType */
static int hf_ngap_RGLevelWirelineAccessCharacteristics_PDU;  /* RGLevelWirelineAccessCharacteristics */
static int hf_ngap_RoutingID_PDU;                 /* RoutingID */
static int hf_ngap_RRCEstablishmentCause_PDU;     /* RRCEstablishmentCause */
static int hf_ngap_RRCInactiveTransitionReportRequest_PDU;  /* RRCInactiveTransitionReportRequest */
static int hf_ngap_RRCState_PDU;                  /* RRCState */
static int hf_ngap_RIMInformationTransfer_PDU;    /* RIMInformationTransfer */
static int hf_ngap_SCTP_TLAs_PDU;                 /* SCTP_TLAs */
static int hf_ngap_SecondaryRATUsageInformation_PDU;  /* SecondaryRATUsageInformation */
static int hf_ngap_SecondaryRATDataUsageReportTransfer_PDU;  /* SecondaryRATDataUsageReportTransfer */
static int hf_ngap_SecurityContext_PDU;           /* SecurityContext */
static int hf_ngap_SecurityIndication_PDU;        /* SecurityIndication */
static int hf_ngap_SecurityKey_PDU;               /* SecurityKey */
static int hf_ngap_SecurityResult_PDU;            /* SecurityResult */
static int hf_ngap_SerialNumber_PDU;              /* SerialNumber */
static int hf_ngap_ServedGUAMIList_PDU;           /* ServedGUAMIList */
static int hf_ngap_SgNB_UE_X2AP_ID_PDU;           /* SgNB_UE_X2AP_ID */
static int hf_ngap_SliceSupportList_PDU;          /* SliceSupportList */
static int hf_ngap_S_NSSAI_PDU;                   /* S_NSSAI */
static int hf_ngap_ngap_SONConfigurationTransfer_PDU;  /* SONConfigurationTransfer */
static int hf_ngap_SONInformationReport_PDU;      /* SONInformationReport */
static int hf_ngap_SNPN_CellBasedMDT_PDU;         /* SNPN_CellBasedMDT */
static int hf_ngap_SNPN_TAIBasedMDT_PDU;          /* SNPN_TAIBasedMDT */
static int hf_ngap_SNPN_BasedMDT_PDU;             /* SNPN_BasedMDT */
static int hf_ngap_SuccessfulHandoverReportList_PDU;  /* SuccessfulHandoverReportList */
static int hf_ngap_SuccessfulPSCellChangeReportList_PDU;  /* SuccessfulPSCellChangeReportList */
static int hf_ngap_ngap_SourceNGRANNode_ToTargetNGRANNode_TransparentContainer_PDU;  /* SourceNGRANNode_ToTargetNGRANNode_TransparentContainer */
static int hf_ngap_SourceNodeID_PDU;              /* SourceNodeID */
static int hf_ngap_SourceToTarget_TransparentContainer_PDU;  /* SourceToTarget_TransparentContainer */
static int hf_ngap_SourceToTarget_AMFInformationReroute_PDU;  /* SourceToTarget_AMFInformationReroute */
static int hf_ngap_SRVCCOperationPossible_PDU;    /* SRVCCOperationPossible */
static int hf_ngap_SupportedTAList_PDU;           /* SupportedTAList */
static int hf_ngap_Suspend_Request_Indication_PDU;  /* Suspend_Request_Indication */
static int hf_ngap_Suspend_Response_Indication_PDU;  /* Suspend_Response_Indication */
static int hf_ngap_SurvivalTime_PDU;              /* SurvivalTime */
static int hf_ngap_SLPositioningRangingServiceInfo_PDU;  /* SLPositioningRangingServiceInfo */
static int hf_ngap_TAI_PDU;                       /* TAI */
static int hf_ngap_TAIListForPaging_PDU;          /* TAIListForPaging */
static int hf_ngap_TAIListForRestart_PDU;         /* TAIListForRestart */
static int hf_ngap_TAINSAGSupportList_PDU;        /* TAINSAGSupportList */
static int hf_ngap_TargetHomeENB_ID_PDU;          /* TargetHomeENB_ID */
static int hf_ngap_TargetID_PDU;                  /* TargetID */
static int hf_ngap_ngap_TargetNGRANNode_ToSourceNGRANNode_TransparentContainer_PDU;  /* TargetNGRANNode_ToSourceNGRANNode_TransparentContainer */
static int hf_ngap_TargetNGRANNode_ToSourceNGRANNode_FailureTransparentContainer_PDU;  /* TargetNGRANNode_ToSourceNGRANNode_FailureTransparentContainer */
static int hf_ngap_TargetNSSAIInformation_PDU;    /* TargetNSSAIInformation */
static int hf_ngap_TargetRNC_ID_PDU;              /* TargetRNC_ID */
static int hf_ngap_TargetToSource_TransparentContainer_PDU;  /* TargetToSource_TransparentContainer */
static int hf_ngap_TargettoSource_Failure_TransparentContainer_PDU;  /* TargettoSource_Failure_TransparentContainer */
static int hf_ngap_TimeBasedHandoverInformation_PDU;  /* TimeBasedHandoverInformation */
static int hf_ngap_TimeSinceFailure_PDU;          /* TimeSinceFailure */
static int hf_ngap_TimeSyncAssistanceInfo_PDU;    /* TimeSyncAssistanceInfo */
static int hf_ngap_TimeToWait_PDU;                /* TimeToWait */
static int hf_ngap_TNLAssociationList_PDU;        /* TNLAssociationList */
static int hf_ngap_TraceActivation_PDU;           /* TraceActivation */
static int hf_ngap_TrafficLoadReductionIndication_PDU;  /* TrafficLoadReductionIndication */
static int hf_ngap_TransportLayerAddress_PDU;     /* TransportLayerAddress */
static int hf_ngap_TLContainer_PDU;               /* TLContainer */
static int hf_ngap_TSCTrafficCharacteristics_PDU;  /* TSCTrafficCharacteristics */
static int hf_ngap_TSCTrafficCharacteristicsFeedback_PDU;  /* TSCTrafficCharacteristicsFeedback */
static int hf_ngap_UEAggregateMaximumBitRate_PDU;  /* UEAggregateMaximumBitRate */
static int hf_ngap_UE_associatedLogicalNG_connectionList_PDU;  /* UE_associatedLogicalNG_connectionList */
static int hf_ngap_UECapabilityInfoRequest_PDU;   /* UECapabilityInfoRequest */
static int hf_ngap_UEContextRequest_PDU;          /* UEContextRequest */
static int hf_ngap_UEContextResumeRequestTransfer_PDU;  /* UEContextResumeRequestTransfer */
static int hf_ngap_UEContextResumeResponseTransfer_PDU;  /* UEContextResumeResponseTransfer */
static int hf_ngap_UEContextSuspendRequestTransfer_PDU;  /* UEContextSuspendRequestTransfer */
static int hf_ngap_UE_DifferentiationInfo_PDU;    /* UE_DifferentiationInfo */
static int hf_ngap_UEHistoryInformationFromTheUE_PDU;  /* UEHistoryInformationFromTheUE */
static int hf_ngap_UE_NGAP_IDs_PDU;               /* UE_NGAP_IDs */
static int hf_ngap_UEPagingIdentity_PDU;          /* UEPagingIdentity */
static int hf_ngap_UEPresenceInAreaOfInterestList_PDU;  /* UEPresenceInAreaOfInterestList */
static int hf_ngap_UERadioCapability_PDU;         /* UERadioCapability */
static int hf_ngap_UERadioCapabilityForPaging_PDU;  /* UERadioCapabilityForPaging */
static int hf_ngap_UERadioCapabilityForPagingOfNB_IoT_PDU;  /* UERadioCapabilityForPagingOfNB_IoT */
static int hf_ngap_UERadioCapabilityID_PDU;       /* UERadioCapabilityID */
static int hf_ngap_UERetentionInformation_PDU;    /* UERetentionInformation */
static int hf_ngap_UESecurityCapabilities_PDU;    /* UESecurityCapabilities */
static int hf_ngap_UESliceMaximumBitRateList_PDU;  /* UESliceMaximumBitRateList */
static int hf_ngap_UE_UP_CIoT_Support_PDU;        /* UE_UP_CIoT_Support */
static int hf_ngap_UL_CP_SecurityInformation_PDU;  /* UL_CP_SecurityInformation */
static int hf_ngap_UL_NGU_UP_TNLModifyList_PDU;   /* UL_NGU_UP_TNLModifyList */
static int hf_ngap_UnavailableGUAMIList_PDU;      /* UnavailableGUAMIList */
static int hf_ngap_ULForwarding_PDU;              /* ULForwarding */
static int hf_ngap_UPTransportLayerInformation_PDU;  /* UPTransportLayerInformation */
static int hf_ngap_UPTransportLayerInformationList_PDU;  /* UPTransportLayerInformationList */
static int hf_ngap_UPTransportLayerInformationPairList_PDU;  /* UPTransportLayerInformationPairList */
static int hf_ngap_URI_address_PDU;               /* URI_address */
static int hf_ngap_UserLocationInformation_PDU;   /* UserLocationInformation */
static int hf_ngap_UserLocationInformationTNGF_PDU;  /* UserLocationInformationTNGF */
static int hf_ngap_UserLocationInformationTWIF_PDU;  /* UserLocationInformationTWIF */
static int hf_ngap_UserLocationInformationW_AGF_PDU;  /* UserLocationInformationW_AGF */
static int hf_ngap_UserPlaneFailureIndication_PDU;  /* UserPlaneFailureIndication */
static int hf_ngap_UserPlaneFailureIndicationReport_PDU;  /* UserPlaneFailureIndicationReport */
static int hf_ngap_WarningAreaCoordinates_PDU;    /* WarningAreaCoordinates */
static int hf_ngap_WarningAreaList_PDU;           /* WarningAreaList */
static int hf_ngap_WarningMessageContents_PDU;    /* WarningMessageContents */
static int hf_ngap_WarningSecurityInfo_PDU;       /* WarningSecurityInfo */
static int hf_ngap_WarningType_PDU;               /* WarningType */
static int hf_ngap_WUS_Assistance_Information_PDU;  /* WUS_Assistance_Information */
static int hf_ngap_XrDeviceWith2Rx_PDU;           /* XrDeviceWith2Rx */
static int hf_ngap_PDUSessionResourceSetupRequest_PDU;  /* PDUSessionResourceSetupRequest */
static int hf_ngap_PDUSessionResourceSetupResponse_PDU;  /* PDUSessionResourceSetupResponse */
static int hf_ngap_PDUSessionResourceReleaseCommand_PDU;  /* PDUSessionResourceReleaseCommand */
static int hf_ngap_PDUSessionResourceReleaseResponse_PDU;  /* PDUSessionResourceReleaseResponse */
static int hf_ngap_PDUSessionResourceModifyRequest_PDU;  /* PDUSessionResourceModifyRequest */
static int hf_ngap_PDUSessionResourceModifyResponse_PDU;  /* PDUSessionResourceModifyResponse */
static int hf_ngap_PDUSessionResourceNotify_PDU;  /* PDUSessionResourceNotify */
static int hf_ngap_PDUSessionResourceModifyIndication_PDU;  /* PDUSessionResourceModifyIndication */
static int hf_ngap_PDUSessionResourceModifyConfirm_PDU;  /* PDUSessionResourceModifyConfirm */
static int hf_ngap_InitialContextSetupRequest_PDU;  /* InitialContextSetupRequest */
static int hf_ngap_InitialContextSetupResponse_PDU;  /* InitialContextSetupResponse */
static int hf_ngap_InitialContextSetupFailure_PDU;  /* InitialContextSetupFailure */
static int hf_ngap_UEContextReleaseRequest_PDU;   /* UEContextReleaseRequest */
static int hf_ngap_UEContextReleaseCommand_PDU;   /* UEContextReleaseCommand */
static int hf_ngap_UEContextReleaseComplete_PDU;  /* UEContextReleaseComplete */
static int hf_ngap_UEContextResumeRequest_PDU;    /* UEContextResumeRequest */
static int hf_ngap_UEContextResumeResponse_PDU;   /* UEContextResumeResponse */
static int hf_ngap_UEContextResumeFailure_PDU;    /* UEContextResumeFailure */
static int hf_ngap_UEContextSuspendRequest_PDU;   /* UEContextSuspendRequest */
static int hf_ngap_UEContextSuspendResponse_PDU;  /* UEContextSuspendResponse */
static int hf_ngap_UEContextSuspendFailure_PDU;   /* UEContextSuspendFailure */
static int hf_ngap_UEContextModificationRequest_PDU;  /* UEContextModificationRequest */
static int hf_ngap_UEContextModificationResponse_PDU;  /* UEContextModificationResponse */
static int hf_ngap_UEContextModificationFailure_PDU;  /* UEContextModificationFailure */
static int hf_ngap_RRCInactiveTransitionReport_PDU;  /* RRCInactiveTransitionReport */
static int hf_ngap_RetrieveUEInformation_PDU;     /* RetrieveUEInformation */
static int hf_ngap_UEInformationTransfer_PDU;     /* UEInformationTransfer */
static int hf_ngap_RANCPRelocationIndication_PDU;  /* RANCPRelocationIndication */
static int hf_ngap_HandoverRequired_PDU;          /* HandoverRequired */
static int hf_ngap_HandoverCommand_PDU;           /* HandoverCommand */
static int hf_ngap_HandoverPreparationFailure_PDU;  /* HandoverPreparationFailure */
static int hf_ngap_HandoverRequest_PDU;           /* HandoverRequest */
static int hf_ngap_HandoverRequestAcknowledge_PDU;  /* HandoverRequestAcknowledge */
static int hf_ngap_HandoverFailure_PDU;           /* HandoverFailure */
static int hf_ngap_HandoverNotify_PDU;            /* HandoverNotify */
static int hf_ngap_PathSwitchRequest_PDU;         /* PathSwitchRequest */
static int hf_ngap_PathSwitchRequestAcknowledge_PDU;  /* PathSwitchRequestAcknowledge */
static int hf_ngap_PathSwitchRequestFailure_PDU;  /* PathSwitchRequestFailure */
static int hf_ngap_HandoverCancel_PDU;            /* HandoverCancel */
static int hf_ngap_HandoverCancelAcknowledge_PDU;  /* HandoverCancelAcknowledge */
static int hf_ngap_HandoverSuccess_PDU;           /* HandoverSuccess */
static int hf_ngap_UplinkRANEarlyStatusTransfer_PDU;  /* UplinkRANEarlyStatusTransfer */
static int hf_ngap_DownlinkRANEarlyStatusTransfer_PDU;  /* DownlinkRANEarlyStatusTransfer */
static int hf_ngap_UplinkRANStatusTransfer_PDU;   /* UplinkRANStatusTransfer */
static int hf_ngap_DownlinkRANStatusTransfer_PDU;  /* DownlinkRANStatusTransfer */
static int hf_ngap_Paging_PDU;                    /* Paging */
static int hf_ngap_InitialUEMessage_PDU;          /* InitialUEMessage */
static int hf_ngap_DownlinkNASTransport_PDU;      /* DownlinkNASTransport */
static int hf_ngap_UplinkNASTransport_PDU;        /* UplinkNASTransport */
static int hf_ngap_W_AGFIdentityInformation_PDU;  /* W_AGFIdentityInformation */
static int hf_ngap_TNGFIdentityInformation_PDU;   /* TNGFIdentityInformation */
static int hf_ngap_TWIFIdentityInformation_PDU;   /* TWIFIdentityInformation */
static int hf_ngap_NASNonDeliveryIndication_PDU;  /* NASNonDeliveryIndication */
static int hf_ngap_RerouteNASRequest_PDU;         /* RerouteNASRequest */
static int hf_ngap_NGAP_Message_PDU;              /* NGAP_Message */
static int hf_ngap_NGSetupRequest_PDU;            /* NGSetupRequest */
static int hf_ngap_NGSetupResponse_PDU;           /* NGSetupResponse */
static int hf_ngap_NGSetupFailure_PDU;            /* NGSetupFailure */
static int hf_ngap_RANConfigurationUpdate_PDU;    /* RANConfigurationUpdate */
static int hf_ngap_RANConfigurationUpdateAcknowledge_PDU;  /* RANConfigurationUpdateAcknowledge */
static int hf_ngap_RANConfigurationUpdateFailure_PDU;  /* RANConfigurationUpdateFailure */
static int hf_ngap_AMFConfigurationUpdate_PDU;    /* AMFConfigurationUpdate */
static int hf_ngap_AMFConfigurationUpdateAcknowledge_PDU;  /* AMFConfigurationUpdateAcknowledge */
static int hf_ngap_AMFConfigurationUpdateFailure_PDU;  /* AMFConfigurationUpdateFailure */
static int hf_ngap_AMFStatusIndication_PDU;       /* AMFStatusIndication */
static int hf_ngap_NGReset_PDU;                   /* NGReset */
static int hf_ngap_NGResetAcknowledge_PDU;        /* NGResetAcknowledge */
static int hf_ngap_ErrorIndication_PDU;           /* ErrorIndication */
static int hf_ngap_OverloadStart_PDU;             /* OverloadStart */
static int hf_ngap_OverloadStop_PDU;              /* OverloadStop */
static int hf_ngap_UplinkRANConfigurationTransfer_PDU;  /* UplinkRANConfigurationTransfer */
static int hf_ngap_DownlinkRANConfigurationTransfer_PDU;  /* DownlinkRANConfigurationTransfer */
static int hf_ngap_WriteReplaceWarningRequest_PDU;  /* WriteReplaceWarningRequest */
static int hf_ngap_WriteReplaceWarningResponse_PDU;  /* WriteReplaceWarningResponse */
static int hf_ngap_PWSCancelRequest_PDU;          /* PWSCancelRequest */
static int hf_ngap_PWSCancelResponse_PDU;         /* PWSCancelResponse */
static int hf_ngap_PWSRestartIndication_PDU;      /* PWSRestartIndication */
static int hf_ngap_PWSFailureIndication_PDU;      /* PWSFailureIndication */
static int hf_ngap_DownlinkUEAssociatedNRPPaTransport_PDU;  /* DownlinkUEAssociatedNRPPaTransport */
static int hf_ngap_UplinkUEAssociatedNRPPaTransport_PDU;  /* UplinkUEAssociatedNRPPaTransport */
static int hf_ngap_DownlinkNonUEAssociatedNRPPaTransport_PDU;  /* DownlinkNonUEAssociatedNRPPaTransport */
static int hf_ngap_UplinkNonUEAssociatedNRPPaTransport_PDU;  /* UplinkNonUEAssociatedNRPPaTransport */
static int hf_ngap_TraceStart_PDU;                /* TraceStart */
static int hf_ngap_TraceFailureIndication_PDU;    /* TraceFailureIndication */
static int hf_ngap_DeactivateTrace_PDU;           /* DeactivateTrace */
static int hf_ngap_CellTrafficTrace_PDU;          /* CellTrafficTrace */
static int hf_ngap_LocationReportingControl_PDU;  /* LocationReportingControl */
static int hf_ngap_LocationReportingFailureIndication_PDU;  /* LocationReportingFailureIndication */
static int hf_ngap_LocationReport_PDU;            /* LocationReport */
static int hf_ngap_UETNLABindingReleaseRequest_PDU;  /* UETNLABindingReleaseRequest */
static int hf_ngap_UERadioCapabilityInfoIndication_PDU;  /* UERadioCapabilityInfoIndication */
static int hf_ngap_UERadioCapabilityCheckRequest_PDU;  /* UERadioCapabilityCheckRequest */
static int hf_ngap_UERadioCapabilityCheckResponse_PDU;  /* UERadioCapabilityCheckResponse */
static int hf_ngap_PrivateMessage_PDU;            /* PrivateMessage */
static int hf_ngap_SecondaryRATDataUsageReport_PDU;  /* SecondaryRATDataUsageReport */
static int hf_ngap_UplinkRIMInformationTransfer_PDU;  /* UplinkRIMInformationTransfer */
static int hf_ngap_DownlinkRIMInformationTransfer_PDU;  /* DownlinkRIMInformationTransfer */
static int hf_ngap_ConnectionEstablishmentIndication_PDU;  /* ConnectionEstablishmentIndication */
static int hf_ngap_UERadioCapabilityIDMappingRequest_PDU;  /* UERadioCapabilityIDMappingRequest */
static int hf_ngap_UERadioCapabilityIDMappingResponse_PDU;  /* UERadioCapabilityIDMappingResponse */
static int hf_ngap_AMFCPRelocationIndication_PDU;  /* AMFCPRelocationIndication */
static int hf_ngap_BroadcastSessionSetupRequest_PDU;  /* BroadcastSessionSetupRequest */
static int hf_ngap_MBSSessionSetupOrModRequestTransfer_OCTET_STRING_PDU;  /* MBSSessionSetupOrModRequestTransfer_OCTET_STRING */
static int hf_ngap_BroadcastSessionSetupResponse_PDU;  /* BroadcastSessionSetupResponse */
static int hf_ngap_MBSSessionSetupOrModResponseTransfer_OCTET_STRING_PDU;  /* MBSSessionSetupOrModResponseTransfer_OCTET_STRING */
static int hf_ngap_BroadcastSessionSetupFailure_PDU;  /* BroadcastSessionSetupFailure */
static int hf_ngap_MBSSessionSetupOrModFailureTransfer_OCTET_STRING_PDU;  /* MBSSessionSetupOrModFailureTransfer_OCTET_STRING */
static int hf_ngap_BroadcastSessionModificationRequest_PDU;  /* BroadcastSessionModificationRequest */
static int hf_ngap_BroadcastSessionModificationResponse_PDU;  /* BroadcastSessionModificationResponse */
static int hf_ngap_BroadcastSessionModificationFailure_PDU;  /* BroadcastSessionModificationFailure */
static int hf_ngap_BroadcastSessionReleaseRequest_PDU;  /* BroadcastSessionReleaseRequest */
static int hf_ngap_BroadcastSessionReleaseRequired_PDU;  /* BroadcastSessionReleaseRequired */
static int hf_ngap_BroadcastSessionReleaseResponse_PDU;  /* BroadcastSessionReleaseResponse */
static int hf_ngap_MBSSessionReleaseResponseTransfer_OCTET_STRING_PDU;  /* MBSSessionReleaseResponseTransfer_OCTET_STRING */
static int hf_ngap_BroadcastSessionTransportRequest_PDU;  /* BroadcastSessionTransportRequest */
static int hf_ngap_BroadcastTransportRequestTransfer_OCTET_STRING_PDU;  /* BroadcastTransportRequestTransfer_OCTET_STRING */
static int hf_ngap_BroadcastSessionTransportResponse_PDU;  /* BroadcastSessionTransportResponse */
static int hf_ngap_BroadcastTransportResponseTransfer_OCTET_STRING_PDU;  /* BroadcastTransportResponseTransfer_OCTET_STRING */
static int hf_ngap_BroadcastSessionTransportFailure_PDU;  /* BroadcastSessionTransportFailure */
static int hf_ngap_BroadcastTransportFailureTransfer_OCTET_STRING_PDU;  /* BroadcastTransportFailureTransfer_OCTET_STRING */
static int hf_ngap_DistributionSetupRequest_PDU;  /* DistributionSetupRequest */
static int hf_ngap_MBS_DistributionSetupRequestTransfer_OCTET_STRING_PDU;  /* MBS_DistributionSetupRequestTransfer_OCTET_STRING */
static int hf_ngap_DistributionSetupResponse_PDU;  /* DistributionSetupResponse */
static int hf_ngap_MBS_DistributionSetupResponseTransfer_OCTET_STRING_PDU;  /* MBS_DistributionSetupResponseTransfer_OCTET_STRING */
static int hf_ngap_DistributionSetupFailure_PDU;  /* DistributionSetupFailure */
static int hf_ngap_MBS_DistributionSetupUnsuccessfulTransfer_OCTET_STRING_PDU;  /* MBS_DistributionSetupUnsuccessfulTransfer_OCTET_STRING */
static int hf_ngap_DistributionReleaseRequest_PDU;  /* DistributionReleaseRequest */
static int hf_ngap_MBS_DistributionReleaseRequestTransfer_OCTET_STRING_PDU;  /* MBS_DistributionReleaseRequestTransfer_OCTET_STRING */
static int hf_ngap_DistributionReleaseResponse_PDU;  /* DistributionReleaseResponse */
static int hf_ngap_MulticastSessionActivationRequest_PDU;  /* MulticastSessionActivationRequest */
static int hf_ngap_MulticastSessionActivationRequestTransfer_OCTET_STRING_PDU;  /* MulticastSessionActivationRequestTransfer_OCTET_STRING */
static int hf_ngap_MulticastSessionActivationResponse_PDU;  /* MulticastSessionActivationResponse */
static int hf_ngap_MulticastSessionActivationFailure_PDU;  /* MulticastSessionActivationFailure */
static int hf_ngap_MulticastSessionDeactivationRequest_PDU;  /* MulticastSessionDeactivationRequest */
static int hf_ngap_MulticastSessionDeactivationRequestTransfer_OCTET_STRING_PDU;  /* MulticastSessionDeactivationRequestTransfer_OCTET_STRING */
static int hf_ngap_MulticastSessionDeactivationResponse_PDU;  /* MulticastSessionDeactivationResponse */
static int hf_ngap_MulticastSessionUpdateRequest_PDU;  /* MulticastSessionUpdateRequest */
static int hf_ngap_MulticastSessionUpdateRequestTransfer_OCTET_STRING_PDU;  /* MulticastSessionUpdateRequestTransfer_OCTET_STRING */
static int hf_ngap_MulticastSessionUpdateResponse_PDU;  /* MulticastSessionUpdateResponse */
static int hf_ngap_MulticastSessionUpdateFailure_PDU;  /* MulticastSessionUpdateFailure */
static int hf_ngap_MulticastGroupPaging_PDU;      /* MulticastGroupPaging */
static int hf_ngap_TimingSynchronisationStatusRequest_PDU;  /* TimingSynchronisationStatusRequest */
static int hf_ngap_TimingSynchronisationStatusResponse_PDU;  /* TimingSynchronisationStatusResponse */
static int hf_ngap_TimingSynchronisationStatusFailure_PDU;  /* TimingSynchronisationStatusFailure */
static int hf_ngap_TimingSynchronisationStatusReport_PDU;  /* TimingSynchronisationStatusReport */
static int hf_ngap_MTCommunicationHandlingRequest_PDU;  /* MTCommunicationHandlingRequest */
static int hf_ngap_MTCommunicationHandlingResponse_PDU;  /* MTCommunicationHandlingResponse */
static int hf_ngap_MTCommunicationHandlingFailure_PDU;  /* MTCommunicationHandlingFailure */
static int hf_ngap_RANPagingRequest_PDU;          /* RANPagingRequest */
static int hf_ngap_NGAP_PDU_PDU;                  /* NGAP_PDU */
static int hf_ngap_BroadcastTransportRequestTransfer_PDU;  /* BroadcastTransportRequestTransfer */
static int hf_ngap_BroadcastTransportResponseTransfer_PDU;  /* BroadcastTransportResponseTransfer */
static int hf_ngap_BroadcastTransportFailureTransfer_PDU;  /* BroadcastTransportFailureTransfer */
static int hf_ngap_MBS_DistributionSetupRequestTransfer_PDU;  /* MBS_DistributionSetupRequestTransfer */
static int hf_ngap_MBS_DistributionSetupResponseTransfer_PDU;  /* MBS_DistributionSetupResponseTransfer */
static int hf_ngap_MBS_DistributionSetupUnsuccessfulTransfer_PDU;  /* MBS_DistributionSetupUnsuccessfulTransfer */
static int hf_ngap_MBS_DistributionReleaseRequestTransfer_PDU;  /* MBS_DistributionReleaseRequestTransfer */
static int hf_ngap_MulticastSessionActivationRequestTransfer_PDU;  /* MulticastSessionActivationRequestTransfer */
static int hf_ngap_MulticastSessionDeactivationRequestTransfer_PDU;  /* MulticastSessionDeactivationRequestTransfer */
static int hf_ngap_MulticastSessionUpdateRequestTransfer_PDU;  /* MulticastSessionUpdateRequestTransfer */
static int hf_ngap_local;                         /* INTEGER_0_65535 */
static int hf_ngap_global;                        /* OBJECT_IDENTIFIER */
static int hf_ngap_ProtocolIE_Container_item;     /* ProtocolIE_Field */
static int hf_ngap_id;                            /* ProtocolIE_ID */
static int hf_ngap_criticality;                   /* Criticality */
static int hf_ngap_ie_field_value;                /* T_ie_field_value */
static int hf_ngap_ProtocolExtensionContainer_item;  /* ProtocolExtensionField */
static int hf_ngap_ext_id;                        /* ProtocolExtensionID */
static int hf_ngap_extensionValue;                /* T_extensionValue */
static int hf_ngap_PrivateIE_Container_item;      /* PrivateIE_Field */
static int hf_ngap_private_id;                    /* PrivateIE_ID */
static int hf_ngap_private_value;                 /* T_private_value */
static int hf_ngap_AdditionalDLUPTNLInformationForHOList_item;  /* AdditionalDLUPTNLInformationForHOItem */
static int hf_ngap_additionalDL_NGU_UP_TNLInformation;  /* UPTransportLayerInformation */
static int hf_ngap_additionalQosFlowSetupResponseList;  /* QosFlowListWithDataForwarding */
static int hf_ngap_additionalDLForwardingUPTNLInformation;  /* UPTransportLayerInformation */
static int hf_ngap_iE_Extensions;                 /* ProtocolExtensionContainer */
static int hf_ngap_a2X_GuaranteedFlowBitRate;     /* BitRate */
static int hf_ngap_a2X_MaximumFlowBitRate;        /* BitRate */
static int hf_ngap_A2X_PC5_QoS_Flow_List_item;    /* A2X_PC5_QoS_Flow_Item */
static int hf_ngap_a2X_PQI;                       /* INTEGER_0_255_ */
static int hf_ngap_a2X_PC5_FlowBitRates;          /* A2X_PC5_FlowBitRates */
static int hf_ngap_a2X_Range;                     /* T_a2X_Range */
static int hf_ngap_a2X_PC5_QoS_Flow_List;         /* A2X_PC5_QoS_Flow_List */
static int hf_ngap_a2X_PC5_LinkAggregateBitRates;  /* BitRate */
static int hf_ngap_AdditionalCancelledlocationReportingReferenceIDList_item;  /* AdditionalCancelledlocationReportingReferenceIDItem */
static int hf_ngap_locationReportingReferenceIDToBeCancelled;  /* LocationReportingReferenceID */
static int hf_ngap_priorityLevelARP;              /* PriorityLevelARP */
static int hf_ngap_pre_emptionCapability;         /* Pre_emptionCapability */
static int hf_ngap_pre_emptionVulnerability;      /* Pre_emptionVulnerability */
static int hf_ngap_Allowed_CAG_List_per_PLMN_item;  /* CAG_ID */
static int hf_ngap_AllowedNSSAI_item;             /* AllowedNSSAI_Item */
static int hf_ngap_s_NSSAI;                       /* S_NSSAI */
static int hf_ngap_Allowed_PNI_NPN_List_item;     /* Allowed_PNI_NPN_Item */
static int hf_ngap_pLMNIdentity;                  /* PLMNIdentity */
static int hf_ngap_pNI_NPN_restricted;            /* T_pNI_NPN_restricted */
static int hf_ngap_allowed_CAG_List_per_PLMN;     /* Allowed_CAG_List_per_PLMN */
static int hf_ngap_AllowedTACs_item;              /* TAC */
static int hf_ngap_AlternativeQoSParaSetList_item;  /* AlternativeQoSParaSetItem */
static int hf_ngap_alternativeQoSParaSetIndex;    /* AlternativeQoSParaSetIndex */
static int hf_ngap_guaranteedFlowBitRateDL;       /* BitRate */
static int hf_ngap_guaranteedFlowBitRateUL;       /* BitRate */
static int hf_ngap_packetDelayBudget;             /* PacketDelayBudget */
static int hf_ngap_packetErrorRate;               /* PacketErrorRate */
static int hf_ngap_globalRANNodeID;               /* GlobalRANNodeID */
static int hf_ngap_tAI;                           /* TAI */
static int hf_ngap_choice_Extensions;             /* ProtocolIE_SingleContainer */
static int hf_ngap_AMF_TNLAssociationSetupList_item;  /* AMF_TNLAssociationSetupItem */
static int hf_ngap_aMF_TNLAssociationAddress;     /* CPTransportLayerInformation */
static int hf_ngap_AMF_TNLAssociationToAddList_item;  /* AMF_TNLAssociationToAddItem */
static int hf_ngap_tNLAssociationUsage;           /* TNLAssociationUsage */
static int hf_ngap_tNLAddressWeightFactor;        /* TNLAddressWeightFactor */
static int hf_ngap_AMF_TNLAssociationToRemoveList_item;  /* AMF_TNLAssociationToRemoveItem */
static int hf_ngap_AMF_TNLAssociationToUpdateList_item;  /* AMF_TNLAssociationToUpdateItem */
static int hf_ngap_areaOfInterestTAIList;         /* AreaOfInterestTAIList */
static int hf_ngap_areaOfInterestCellList;        /* AreaOfInterestCellList */
static int hf_ngap_areaOfInterestRANNodeList;     /* AreaOfInterestRANNodeList */
static int hf_ngap_AreaOfInterestCellList_item;   /* AreaOfInterestCellItem */
static int hf_ngap_nGRAN_CGI;                     /* NGRAN_CGI */
static int hf_ngap_AreaOfInterestList_item;       /* AreaOfInterestItem */
static int hf_ngap_areaOfInterest;                /* AreaOfInterest */
static int hf_ngap_locationReportingReferenceID;  /* LocationReportingReferenceID */
static int hf_ngap_AreaOfInterestRANNodeList_item;  /* AreaOfInterestRANNodeItem */
static int hf_ngap_AreaOfInterestTAIList_item;    /* AreaOfInterestTAIItem */
static int hf_ngap_assistanceDataForRecommendedCells;  /* AssistanceDataForRecommendedCells */
static int hf_ngap_pagingAttemptInformation;      /* PagingAttemptInformation */
static int hf_ngap_recommendedCellsForPaging;     /* RecommendedCellsForPaging */
static int hf_ngap_AssociatedMBSQosFlowSetupRequestList_item;  /* AssociatedMBSQosFlowSetupRequestItem */
static int hf_ngap_mBS_QosFlowIdentifier;         /* QosFlowIdentifier */
static int hf_ngap_associatedUnicastQosFlowIdentifier;  /* QosFlowIdentifier */
static int hf_ngap_AssociatedMBSQosFlowSetuporModifyRequestList_item;  /* AssociatedMBSQosFlowSetuporModifyRequestItem */
static int hf_ngap_AssociatedQosFlowList_item;    /* AssociatedQosFlowItem */
static int hf_ngap_qosFlowIdentifier;             /* QosFlowIdentifier */
static int hf_ngap_qosFlowMappingIndication;      /* T_qosFlowMappingIndication */
static int hf_ngap_cellBased;                     /* CellBasedMDT_NR */
static int hf_ngap_tABased;                       /* TABasedMDT */
static int hf_ngap_pLMNWide;                      /* NULL */
static int hf_ngap_tAIBased;                      /* TAIBasedMDT */
static int hf_ngap_cellBased_01;                  /* CellBasedMDT_EUTRA */
static int hf_ngap_AreaScopeOfNeighCellsList_item;  /* AreaScopeOfNeighCellsItem */
static int hf_ngap_nrFrequencyInfo;               /* NRFrequencyInfo */
static int hf_ngap_pciListForMDT;                 /* PCIListForMDT */
static int hf_ngap_cellBased_02;                  /* CellBasedQMC */
static int hf_ngap_tABased_01;                    /* TABasedQMC */
static int hf_ngap_tAIBased_01;                   /* TAIBasedQMC */
static int hf_ngap_pLMNAreaBased;                 /* PLMNAreaBasedQMC */
static int hf_ngap_applicationLayerBufferLevelList;  /* T_applicationLayerBufferLevelList */
static int hf_ngap_playoutDelayForMediaStartup;   /* T_playoutDelayForMediaStartup */
static int hf_ngap_beamMeasurementsReportQuantity;  /* BeamMeasurementsReportQuantity */
static int hf_ngap_maxNrofRS_IndexesToReport;     /* MaxNrofRS_IndexesToReport */
static int hf_ngap_rSRP;                          /* T_rSRP */
static int hf_ngap_rSRQ;                          /* T_rSRQ */
static int hf_ngap_sINR;                          /* T_sINR */
static int hf_ngap_cellIDCancelledEUTRA;          /* CellIDCancelledEUTRA */
static int hf_ngap_tAICancelledEUTRA;             /* TAICancelledEUTRA */
static int hf_ngap_emergencyAreaIDCancelledEUTRA;  /* EmergencyAreaIDCancelledEUTRA */
static int hf_ngap_cellIDCancelledNR;             /* CellIDCancelledNR */
static int hf_ngap_tAICancelledNR;                /* TAICancelledNR */
static int hf_ngap_emergencyAreaIDCancelledNR;    /* EmergencyAreaIDCancelledNR */
static int hf_ngap_cellIDBroadcastEUTRA;          /* CellIDBroadcastEUTRA */
static int hf_ngap_tAIBroadcastEUTRA;             /* TAIBroadcastEUTRA */
static int hf_ngap_emergencyAreaIDBroadcastEUTRA;  /* EmergencyAreaIDBroadcastEUTRA */
static int hf_ngap_cellIDBroadcastNR;             /* CellIDBroadcastNR */
static int hf_ngap_tAIBroadcastNR;                /* TAIBroadcastNR */
static int hf_ngap_emergencyAreaIDBroadcastNR;    /* EmergencyAreaIDBroadcastNR */
static int hf_ngap_BroadcastPLMNList_item;        /* BroadcastPLMNItem */
static int hf_ngap_tAISliceSupportList;           /* SliceSupportList */
static int hf_ngap_mBS_SessionID;                 /* MBS_SessionID */
static int hf_ngap_cause;                         /* Cause */
static int hf_ngap_criticalityDiagnostics;        /* CriticalityDiagnostics */
static int hf_ngap_mBS_SessionTNLInfoNGRAN;       /* MBS_SessionTNLInfoNGRAN */
static int hf_ngap_bluetoothMeasConfig;           /* BluetoothMeasConfig */
static int hf_ngap_bluetoothMeasConfigNameList;   /* BluetoothMeasConfigNameList */
static int hf_ngap_bt_rssi;                       /* T_bt_rssi */
static int hf_ngap_BluetoothMeasConfigNameList_item;  /* BluetoothMeasConfigNameItem */
static int hf_ngap_bluetoothName;                 /* BluetoothName */
static int hf_ngap_burstArrivalTimeWindowStart;   /* INTEGER_0_640000_ */
static int hf_ngap_burstArrivalTimeWindowEnd;     /* INTEGER_0_640000_ */
static int hf_ngap_iE_Extension;                  /* ProtocolExtensionContainer */
static int hf_ngap_CandidateRelayUEInformationList_item;  /* CandidateRelayUEInformationItem */
static int hf_ngap_candidateRelayUE_Id;           /* CandidateRelayUE_ID */
static int hf_ngap_CancelledCellsInEAI_EUTRA_item;  /* CancelledCellsInEAI_EUTRA_Item */
static int hf_ngap_eUTRA_CGI;                     /* EUTRA_CGI */
static int hf_ngap_numberOfBroadcasts;            /* NumberOfBroadcasts */
static int hf_ngap_CancelledCellsInEAI_NR_item;   /* CancelledCellsInEAI_NR_Item */
static int hf_ngap_nR_CGI;                        /* NR_CGI */
static int hf_ngap_CancelledCellsInTAI_EUTRA_item;  /* CancelledCellsInTAI_EUTRA_Item */
static int hf_ngap_CancelledCellsInTAI_NR_item;   /* CancelledCellsInTAI_NR_Item */
static int hf_ngap_CandidateCellList_item;        /* CandidateCellItem */
static int hf_ngap_candidateCell;                 /* CandidateCell */
static int hf_ngap_candidateCGI;                  /* CandidateCellID */
static int hf_ngap_candidatePCI;                  /* CandidatePCI */
static int hf_ngap_candidateCellID;               /* NR_CGI */
static int hf_ngap_candidatePCI_01;               /* INTEGER_0_1007_ */
static int hf_ngap_candidateNRARFCN;              /* INTEGER_0_maxNRARFCN */
static int hf_ngap_radioNetwork;                  /* CauseRadioNetwork */
static int hf_ngap_transport;                     /* CauseTransport */
static int hf_ngap_nas;                           /* CauseNas */
static int hf_ngap_protocol;                      /* CauseProtocol */
static int hf_ngap_misc;                          /* CauseMisc */
static int hf_ngap_cellCAGList;                   /* CellCAGList */
static int hf_ngap_CellCAGList_item;              /* CAG_ID */
static int hf_ngap_CellIDBroadcastEUTRA_item;     /* CellIDBroadcastEUTRA_Item */
static int hf_ngap_CellIDBroadcastNR_item;        /* CellIDBroadcastNR_Item */
static int hf_ngap_CellIDCancelledEUTRA_item;     /* CellIDCancelledEUTRA_Item */
static int hf_ngap_CellIDCancelledNR_item;        /* CellIDCancelledNR_Item */
static int hf_ngap_eUTRA_CGIListforRestart;       /* EUTRA_CGIList */
static int hf_ngap_nR_CGIListforRestart;          /* NR_CGIList */
static int hf_ngap_cellSize;                      /* CellSize */
static int hf_ngap_clockAccuracyValue;            /* INTEGER_1_40000000_ */
static int hf_ngap_clockAccuracyIndex;            /* INTEGER_32_47_ */
static int hf_ngap_clockQualityAcceptanceCriteria;  /* ClockQualityAcceptanceCriteria */
static int hf_ngap_synchronisationState;          /* BIT_STRING_SIZE_8_ */
static int hf_ngap_traceabletoUTC;                /* T_traceabletoUTC */
static int hf_ngap_traceabletoGNSS;               /* T_traceabletoGNSS */
static int hf_ngap_clockFrequencyStability;       /* BIT_STRING_SIZE_16 */
static int hf_ngap_clockAccuracy;                 /* INTEGER_1_40000000_ */
static int hf_ngap_parentTImeSource;              /* BIT_STRING_SIZE_16_ */
static int hf_ngap_clockQualityDetailLevel;       /* ClockQualityDetailLevel */
static int hf_ngap_clockQualityMetrics;           /* NULL */
static int hf_ngap_clockQualityAcceptanceIndication;  /* ClockQualityAcceptanceIndication */
static int hf_ngap_choice_extensions;             /* ProtocolIE_SingleContainer */
static int hf_ngap_expectedUEBehaviour;           /* ExpectedUEBehaviour */
static int hf_ngap_CNTypeRestrictionsForEquivalent_item;  /* CNTypeRestrictionsForEquivalentItem */
static int hf_ngap_plmnIdentity;                  /* PLMNIdentity */
static int hf_ngap_cn_Type;                       /* T_cn_Type */
static int hf_ngap_CompletedCellsInEAI_EUTRA_item;  /* CompletedCellsInEAI_EUTRA_Item */
static int hf_ngap_CompletedCellsInEAI_NR_item;   /* CompletedCellsInEAI_NR_Item */
static int hf_ngap_CompletedCellsInTAI_EUTRA_item;  /* CompletedCellsInTAI_EUTRA_Item */
static int hf_ngap_CompletedCellsInTAI_NR_item;   /* CompletedCellsInTAI_NR_Item */
static int hf_ngap_uEIdentityIndexValue;          /* UEIdentityIndexValue */
static int hf_ngap_uESpecificDRX;                 /* PagingDRX */
static int hf_ngap_periodicRegistrationUpdateTimer;  /* PeriodicRegistrationUpdateTimer */
static int hf_ngap_mICOModeIndication;            /* MICOModeIndication */
static int hf_ngap_tAIListForInactive;            /* TAIListForInactive */
static int hf_ngap_pDCP_SN12;                     /* INTEGER_0_4095 */
static int hf_ngap_hFN_PDCP_SN12;                 /* INTEGER_0_1048575 */
static int hf_ngap_pDCP_SN18;                     /* INTEGER_0_262143 */
static int hf_ngap_hFN_PDCP_SN18;                 /* INTEGER_0_16383 */
static int hf_ngap_endpointIPAddress;             /* TransportLayerAddress */
static int hf_ngap_procedureCode;                 /* ProcedureCode */
static int hf_ngap_triggeringMessage;             /* TriggeringMessage */
static int hf_ngap_procedureCriticality;          /* Criticality */
static int hf_ngap_iEsCriticalityDiagnostics;     /* CriticalityDiagnostics_IE_List */
static int hf_ngap_CriticalityDiagnostics_IE_List_item;  /* CriticalityDiagnostics_IE_Item */
static int hf_ngap_iECriticality;                 /* Criticality */
static int hf_ngap_iE_ID;                         /* ProtocolIE_ID */
static int hf_ngap_typeOfError;                   /* TypeOfError */
static int hf_ngap_cellIdListforMDT;              /* CellIdListforMDT_NR */
static int hf_ngap_CellIdListforMDT_NR_item;      /* NR_CGI */
static int hf_ngap_cellIdListforMDT_01;           /* CellIdListforMDT_EUTRA */
static int hf_ngap_cellIdListforQMC;              /* CellIdListforQMC */
static int hf_ngap_CellIdListforQMC_item;         /* NGRAN_CGI */
static int hf_ngap_CellIdListforMDT_EUTRA_item;   /* EUTRA_CGI */
static int hf_ngap_CAGListforMDT_item;            /* CAGListforMDTItem */
static int hf_ngap_plmnID;                        /* PLMNIdentity */
static int hf_ngap_cAGID;                         /* CAG_ID */
static int hf_ngap_DataForwardingResponseDRBList_item;  /* DataForwardingResponseDRBItem */
static int hf_ngap_dRB_ID;                        /* DRB_ID */
static int hf_ngap_dLForwardingUP_TNLInformation;  /* UPTransportLayerInformation */
static int hf_ngap_uLForwardingUP_TNLInformation;  /* UPTransportLayerInformation */
static int hf_ngap_dAPSIndicator;                 /* T_dAPSIndicator */
static int hf_ngap_DAPSResponseInfoList_item;     /* DAPSResponseInfoItem */
static int hf_ngap_dAPSResponseInfo;              /* DAPSResponseInfo */
static int hf_ngap_dapsresponseindicator;         /* T_dapsresponseindicator */
static int hf_ngap_DataForwardingResponseERABList_item;  /* DataForwardingResponseERABListItem */
static int hf_ngap_e_RAB_ID;                      /* E_RAB_ID */
static int hf_ngap_dl_NAS_MAC;                    /* DL_NAS_MAC */
static int hf_ngap_DRBsSubjectToStatusTransferList_item;  /* DRBsSubjectToStatusTransferItem */
static int hf_ngap_dRBStatusUL;                   /* DRBStatusUL */
static int hf_ngap_dRBStatusDL;                   /* DRBStatusDL */
static int hf_ngap_dRBStatusDL12;                 /* DRBStatusDL12 */
static int hf_ngap_dRBStatusDL18;                 /* DRBStatusDL18 */
static int hf_ngap_dL_COUNTValue;                 /* COUNTValueForPDCP_SN12 */
static int hf_ngap_dL_COUNTValue_01;              /* COUNTValueForPDCP_SN18 */
static int hf_ngap_dRBStatusUL12;                 /* DRBStatusUL12 */
static int hf_ngap_dRBStatusUL18;                 /* DRBStatusUL18 */
static int hf_ngap_uL_COUNTValue;                 /* COUNTValueForPDCP_SN12 */
static int hf_ngap_receiveStatusOfUL_PDCP_SDUs;   /* BIT_STRING_SIZE_1_2048 */
static int hf_ngap_uL_COUNTValue_01;              /* COUNTValueForPDCP_SN18 */
static int hf_ngap_receiveStatusOfUL_PDCP_SDUs_01;  /* BIT_STRING_SIZE_1_131072 */
static int hf_ngap_DRBsToQosFlowsMappingList_item;  /* DRBsToQosFlowsMappingItem */
static int hf_ngap_associatedQosFlowList;         /* AssociatedQosFlowList */
static int hf_ngap_priorityLevelQos;              /* PriorityLevelQos */
static int hf_ngap_fiveQI;                        /* FiveQI */
static int hf_ngap_delayCritical;                 /* DelayCritical */
static int hf_ngap_averagingWindow;               /* AveragingWindow */
static int hf_ngap_maximumDataBurstVolume;        /* MaximumDataBurstVolume */
static int hf_ngap_procedureStage;                /* ProcedureStageChoice */
static int hf_ngap_first_dl_count;                /* FirstDLCount */
static int hf_ngap_dRBsSubjectToDLDiscarding;     /* DRBsSubjectToDLDiscarding_List */
static int hf_ngap_DRBsSubjectToDLDiscarding_List_item;  /* DRBsSubjectToDLDiscarding_Item */
static int hf_ngap_drbID;                         /* DRB_ID */
static int hf_ngap_dlCount;                       /* DLCountChoice */
static int hf_ngap_count12bits;                   /* COUNTValueForPDCP_SN12 */
static int hf_ngap_count18bits;                   /* COUNTValueForPDCP_SN18 */
static int hf_ngap_choice_extension;              /* ProtocolIE_SingleContainer */
static int hf_ngap_dRBsSubjectToEarlyStatusTransfer;  /* DRBsSubjectToEarlyStatusTransfer_List */
static int hf_ngap_DRBsSubjectToEarlyStatusTransfer_List_item;  /* DRBsSubjectToEarlyStatusTransfer_Item */
static int hf_ngap_firstDLCOUNT;                  /* DRBStatusDL */
static int hf_ngap_eCNMarkingAtRANRequest;        /* ECNMarkingAtRANRequest */
static int hf_ngap_eCNMarkingAtUPFRequest;        /* ECNMarkingAtUPFRequest */
static int hf_ngap_congestionInformationRequest;  /* CongestionInformationRequest */
static int hf_ngap_ECNMarkingorCongestionInformationReportingStatus_item;  /* ECNMarkingorCongestionInformationReportingStatus_Item */
static int hf_ngap_activationStatus;              /* ActivationStatus */
static int hf_ngap_EmergencyAreaIDBroadcastEUTRA_item;  /* EmergencyAreaIDBroadcastEUTRA_Item */
static int hf_ngap_emergencyAreaID;               /* EmergencyAreaID */
static int hf_ngap_completedCellsInEAI_EUTRA;     /* CompletedCellsInEAI_EUTRA */
static int hf_ngap_EmergencyAreaIDBroadcastNR_item;  /* EmergencyAreaIDBroadcastNR_Item */
static int hf_ngap_completedCellsInEAI_NR;        /* CompletedCellsInEAI_NR */
static int hf_ngap_EmergencyAreaIDCancelledEUTRA_item;  /* EmergencyAreaIDCancelledEUTRA_Item */
static int hf_ngap_cancelledCellsInEAI_EUTRA;     /* CancelledCellsInEAI_EUTRA */
static int hf_ngap_EmergencyAreaIDCancelledNR_item;  /* EmergencyAreaIDCancelledNR_Item */
static int hf_ngap_cancelledCellsInEAI_NR;        /* CancelledCellsInEAI_NR */
static int hf_ngap_EmergencyAreaIDList_item;      /* EmergencyAreaID */
static int hf_ngap_EmergencyAreaIDListForRestart_item;  /* EmergencyAreaID */
static int hf_ngap_emergencyFallbackRequestIndicator;  /* EmergencyFallbackRequestIndicator */
static int hf_ngap_emergencyServiceTargetCN;      /* EmergencyServiceTargetCN */
static int hf_ngap_macroENB_ID;                   /* BIT_STRING_SIZE_20 */
static int hf_ngap_homeENB_ID;                    /* BIT_STRING_SIZE_28 */
static int hf_ngap_short_macroENB_ID;             /* BIT_STRING_SIZE_18 */
static int hf_ngap_long_macroENB_ID;              /* BIT_STRING_SIZE_21 */
static int hf_ngap_portNumber;                    /* PortNumber */
static int hf_ngap_EquivalentPLMNs_item;          /* PLMNIdentity */
static int hf_ngap_ePS_TAC;                       /* EPS_TAC */
static int hf_ngap_E_RABInformationList_item;     /* E_RABInformationItem */
static int hf_ngap_dLForwarding;                  /* DLForwarding */
static int hf_ngap_eUTRACellIdentity;             /* EUTRACellIdentity */
static int hf_ngap_EUTRA_CGIList_item;            /* EUTRA_CGI */
static int hf_ngap_EUTRA_CGIListForWarning_item;  /* EUTRA_CGI */
static int hf_ngap_eUTRA_paging_eDRX_Cycle;       /* EUTRA_Paging_eDRX_Cycle */
static int hf_ngap_eUTRA_paging_Time_Window;      /* EUTRA_Paging_Time_Window */
static int hf_ngap_ExcessPacketDelayThresholdConfiguration_item;  /* ExcessPacketDelayThresholdItem */
static int hf_ngap_fiveQi;                        /* FiveQI */
static int hf_ngap_excessPacketDelayThresholdValue;  /* ExcessPacketDelayThresholdValue */
static int hf_ngap_expectedActivityPeriod;        /* ExpectedActivityPeriod */
static int hf_ngap_expectedIdlePeriod;            /* ExpectedIdlePeriod */
static int hf_ngap_sourceOfUEActivityBehaviourInformation;  /* SourceOfUEActivityBehaviourInformation */
static int hf_ngap_expectedUEActivityBehaviour;   /* ExpectedUEActivityBehaviour */
static int hf_ngap_expectedHOInterval;            /* ExpectedHOInterval */
static int hf_ngap_expectedUEMobility;            /* ExpectedUEMobility */
static int hf_ngap_expectedUEMovingTrajectory;    /* ExpectedUEMovingTrajectory */
static int hf_ngap_ExpectedUEMovingTrajectory_item;  /* ExpectedUEMovingTrajectoryItem */
static int hf_ngap_timeStayedInCell;              /* INTEGER_0_4095 */
static int hf_ngap_aMFNameVisibleString;          /* AMFNameVisibleString */
static int hf_ngap_aMFNameUTF8String;             /* AMFNameUTF8String */
static int hf_ngap_rANNodeNameVisibleString;      /* RANNodeNameVisibleString */
static int hf_ngap_rANNodeNameUTF8String;         /* RANNodeNameUTF8String */
static int hf_ngap_primaryRATRestriction;         /* T_primaryRATRestriction */
static int hf_ngap_secondaryRATRestriction;       /* T_secondaryRATRestriction */
static int hf_ngap_ExtendedSliceSupportList_item;  /* SliceSupportItem */
static int hf_ngap_outOfCoverage;                 /* T_outOfCoverage */
static int hf_ngap_eventL1LoggedMDTConfig;        /* EventL1LoggedMDTConfig */
static int hf_ngap_l1Threshold;                   /* MeasurementThresholdL1LoggedMDT */
static int hf_ngap_hysteresis;                    /* Hysteresis */
static int hf_ngap_timeToTrigger;                 /* TimeToTrigger */
static int hf_ngap_threshold_RSRP;                /* Threshold_RSRP */
static int hf_ngap_threshold_RSRQ;                /* Threshold_RSRQ */
static int hf_ngap_EquivalentSNPNsList_item;      /* EquivalentSNPNsItem */
static int hf_ngap_nID;                           /* NID */
static int hf_ngap_uERLFReportContainer;          /* UERLFReportContainer */
static int hf_ngap_hLComActivate;                 /* HLComActivate */
static int hf_ngap_hLComDeactivate;               /* HLComDeactivate */
static int hf_ngap_fiveGProSeDirectDiscovery;     /* FiveGProSeDirectDiscovery */
static int hf_ngap_fiveGProSeDirectCommunication;  /* FiveGProSeDirectCommunication */
static int hf_ngap_fiveGProSeLayer2UEtoNetworkRelay;  /* FiveGProSeLayer2UEtoNetworkRelay */
static int hf_ngap_fiveGProSeLayer3UEtoNetworkRelay;  /* FiveGProSeLayer3UEtoNetworkRelay */
static int hf_ngap_fiveGProSeLayer2RemoteUE;      /* FiveGProSeLayer2RemoteUE */
static int hf_ngap_fiveGProSepc5QoSFlowList;      /* FiveGProSePC5QoSFlowList */
static int hf_ngap_fiveGProSepc5LinkAggregateBitRates;  /* BitRate */
static int hf_ngap_FiveGProSePC5QoSFlowList_item;  /* FiveGProSePC5QoSFlowItem */
static int hf_ngap_fiveGproSepQI;                 /* FiveQI */
static int hf_ngap_fiveGproSepc5FlowBitRates;     /* FiveGProSePC5FlowBitRates */
static int hf_ngap_fiveGproSerange;               /* Range */
static int hf_ngap_fiveGproSeguaranteedFlowBitRate;  /* BitRate */
static int hf_ngap_fiveGproSemaximumFlowBitRate;  /* BitRate */
static int hf_ngap_aMFSetID;                      /* AMFSetID */
static int hf_ngap_aMFPointer;                    /* AMFPointer */
static int hf_ngap_fiveG_TMSI;                    /* FiveG_TMSI */
static int hf_ngap_ForbiddenAreaInformation_item;  /* ForbiddenAreaInformation_Item */
static int hf_ngap_forbiddenTACs;                 /* ForbiddenTACs */
static int hf_ngap_ForbiddenTACs_item;            /* TAC */
static int hf_ngap_sourceeNBID;                   /* IntersystemSONeNBID */
static int hf_ngap_targetNGRANnodeID;             /* IntersystemSONNGRANnodeID */
static int hf_ngap_sourceNGRANnodeID;             /* IntersystemSONNGRANnodeID */
static int hf_ngap_targeteNBID;                   /* IntersystemSONeNBID */
static int hf_ngap_maximumFlowBitRateDL;          /* BitRate */
static int hf_ngap_maximumFlowBitRateUL;          /* BitRate */
static int hf_ngap_notificationControl;           /* NotificationControl */
static int hf_ngap_maximumPacketLossRateDL;       /* PacketLossRate */
static int hf_ngap_maximumPacketLossRateUL;       /* PacketLossRate */
static int hf_ngap_globalCable_ID;                /* GlobalCable_ID */
static int hf_ngap_pLMNidentity;                  /* PLMNIdentity */
static int hf_ngap_eNB_ID;                        /* ENB_ID */
static int hf_ngap_globalGNB_ID_gNB_ID;           /* GNB_ID */
static int hf_ngap_globalN3IWF_ID_n3IWF_ID;       /* N3IWF_ID */
static int hf_ngap_globalLineIdentity;            /* GlobalLineIdentity */
static int hf_ngap_lineType;                      /* LineType */
static int hf_ngap_ngENB_ID;                      /* NgENB_ID */
static int hf_ngap_globalGNB_ID;                  /* GlobalGNB_ID */
static int hf_ngap_globalNgENB_ID;                /* GlobalNgENB_ID */
static int hf_ngap_globalN3IWF_ID;                /* GlobalN3IWF_ID */
static int hf_ngap_globalTNGF_ID_tNGF_ID;         /* TNGF_ID */
static int hf_ngap_globalTWIF_ID_tWIF_ID;         /* TWIF_ID */
static int hf_ngap_globalW_AGF_ID_w_AGF_ID;       /* W_AGF_ID */
static int hf_ngap_gNB_ID;                        /* BIT_STRING_SIZE_22_32 */
static int hf_ngap_transportLayerAddress;         /* TransportLayerAddress */
static int hf_ngap_gTP_TEID;                      /* GTP_TEID */
static int hf_ngap_aMFRegionID;                   /* AMFRegionID */
static int hf_ngap_qosFlowToBeForwardedList;      /* QosFlowToBeForwardedList */
static int hf_ngap_dataForwardingResponseDRBList;  /* DataForwardingResponseDRBList */
static int hf_ngap_dL_NGU_UP_TNLInformation;      /* UPTransportLayerInformation */
static int hf_ngap_securityResult;                /* SecurityResult */
static int hf_ngap_qosFlowSetupResponseList;      /* QosFlowListWithDataForwarding */
static int hf_ngap_qosFlowFailedToSetupList;      /* QosFlowListWithCause */
static int hf_ngap_directForwardingPathAvailability;  /* DirectForwardingPathAvailability */
static int hf_ngap_hFCNode_ID;                    /* HFCNode_ID */
static int hf_ngap_nR_Paging_Long_eDRX_Information_for_RRC_INACTIVE;  /* NR_Paging_Long_eDRX_Information_for_RRC_INACTIVE */
static int hf_ngap_uEReachabilityIndication;      /* T_uEReachabilityIndication */
static int hf_ngap_handoverReportType;            /* T_handoverReportType */
static int hf_ngap_handoverCause;                 /* Cause */
static int hf_ngap_sourcecellCGI;                 /* NGRAN_CGI */
static int hf_ngap_targetcellCGI;                 /* NGRAN_CGI */
static int hf_ngap_reestablishmentcellCGI;        /* NGRAN_CGI */
static int hf_ngap_sourcecellC_RNTI;              /* BIT_STRING_SIZE_16 */
static int hf_ngap_targetcellinE_UTRAN;           /* EUTRA_CGI */
static int hf_ngap_mobilityInformation;           /* MobilityInformation */
static int hf_ngap_nRCGI;                         /* NR_CGI */
static int hf_ngap_recommendRANNodesForPaging;    /* RecommendedRANNodesForPaging */
static int hf_ngap_measurementsToActivate;        /* MeasurementsToActivate */
static int hf_ngap_m1Configuration;               /* M1Configuration */
static int hf_ngap_m4Configuration;               /* M4Configuration */
static int hf_ngap_m5Configuration;               /* M5Configuration */
static int hf_ngap_m6Configuration;               /* M6Configuration */
static int hf_ngap_m7Configuration;               /* M7Configuration */
static int hf_ngap_bluetoothMeasurementConfiguration;  /* BluetoothMeasurementConfiguration */
static int hf_ngap_wLANMeasurementConfiguration;  /* WLANMeasurementConfiguration */
static int hf_ngap_mDT_Location_Info;             /* MDT_Location_Info */
static int hf_ngap_sensorMeasurementConfiguration;  /* SensorMeasurementConfiguration */
static int hf_ngap_transferType;                  /* IntersystemSONTransferType */
static int hf_ngap_intersystemSONInformation;     /* IntersystemSONInformation */
static int hf_ngap_fromEUTRANtoNGRAN;             /* FromEUTRANtoNGRAN */
static int hf_ngap_fromNGRANtoEUTRAN;             /* FromNGRANtoEUTRAN */
static int hf_ngap_globaleNBID;                   /* GlobalENB_ID */
static int hf_ngap_selectedEPSTAI;                /* EPS_TAI */
static int hf_ngap_selectedTAI;                   /* TAI */
static int hf_ngap_intersystemSONInformationReport;  /* IntersystemSONInformationReport */
static int hf_ngap_nGRAN_CellActivation;          /* IntersystemCellActivationRequest */
static int hf_ngap_resourceStatus;                /* IntersystemResourceStatusRequest */
static int hf_ngap_activationID;                  /* INTEGER_0_16384_ */
static int hf_ngap_cellsToActivateList;           /* CellsToActivateList */
static int hf_ngap_CellsToActivateList_item;      /* NGRAN_CGI */
static int hf_ngap_reportingSystem;               /* ReportingSystem */
static int hf_ngap_reportCharacteristics;         /* ReportCharacteristics */
static int hf_ngap_reportType;                    /* ReportType */
static int hf_ngap_eUTRAN;                        /* EUTRAN_ReportingSystemIEs */
static int hf_ngap_nGRAN;                         /* NGRAN_ReportingSystemIEs */
static int hf_ngap_noReporting;                   /* NULL */
static int hf_ngap_eUTRAN_CellToReportList;       /* EUTRAN_CellToReportList */
static int hf_ngap_nGRAN_CellToReportList;        /* NGRAN_CellToReportList */
static int hf_ngap_EUTRAN_CellToReportList_item;  /* EUTRAN_CellToReportItem */
static int hf_ngap_eCGI;                          /* EUTRA_CGI */
static int hf_ngap_NGRAN_CellToReportList_item;   /* NGRAN_CellToReportItem */
static int hf_ngap_eventBasedReporting;           /* EventBasedReportingIEs */
static int hf_ngap_periodicReporting;             /* PeriodicReportingIEs */
static int hf_ngap_intersystemResourceThresholdLow;  /* IntersystemResourceThreshold */
static int hf_ngap_intersystemResourceThresholdHigh;  /* IntersystemResourceThreshold */
static int hf_ngap_numberOfMeasurementReportingLevels;  /* NumberOfMeasurementReportingLevels */
static int hf_ngap_reportingPeriodicity;          /* ReportingPeriodicity */
static int hf_ngap_nGRAN_CellActivation_01;       /* IntersystemCellActivationReply */
static int hf_ngap_resourceStatus_01;             /* IntersystemResourceStatusReply */
static int hf_ngap_activatedCellList;             /* ActivatedCellList */
static int hf_ngap_activation_ID;                 /* INTEGER_0_16384_ */
static int hf_ngap_ActivatedCellList_item;        /* NGRAN_CGI */
static int hf_ngap_reportingsystem;               /* ReportingSystem */
static int hf_ngap_hOReportInformation;           /* InterSystemHOReport */
static int hf_ngap_failureIndicationInformation;  /* InterSystemFailureIndication */
static int hf_ngap_notificationCellList;          /* NotificationCellList */
static int hf_ngap_NotificationCellList_item;     /* NotificationCell_Item */
static int hf_ngap_notifyFlag;                    /* T_notifyFlag */
static int hf_ngap_reportingSystem_01;            /* ResourceStatusReportingSystem */
static int hf_ngap_eUTRAN_ReportingStatus;        /* EUTRAN_ReportingStatusIEs */
static int hf_ngap_nGRAN_ReportingStatus;         /* NGRAN_ReportingStatusIEs */
static int hf_ngap_eUTRAN_CellReportList;         /* EUTRAN_CellReportList */
static int hf_ngap_EUTRAN_CellReportList_item;    /* EUTRAN_CellReportItem */
static int hf_ngap_eUTRAN_CompositeAvailableCapacityGroup;  /* EUTRAN_CompositeAvailableCapacityGroup */
static int hf_ngap_eUTRAN_NumberOfActiveUEs;      /* EUTRAN_NumberOfActiveUEs */
static int hf_ngap_eUTRAN_NoofRRCConnections;     /* NGRAN_NoofRRCConnections */
static int hf_ngap_eUTRAN_RadioResourceStatus;    /* EUTRAN_RadioResourceStatus */
static int hf_ngap_dL_CompositeAvailableCapacity;  /* CompositeAvailableCapacity */
static int hf_ngap_uL_CompositeAvailableCapacity;  /* CompositeAvailableCapacity */
static int hf_ngap_cellCapacityClassValue;        /* INTEGER_1_100_ */
static int hf_ngap_capacityValue;                 /* INTEGER_0_100 */
static int hf_ngap_dL_GBR_PRB_usage;              /* INTEGER_0_100 */
static int hf_ngap_uL_GBR_PRB_usage;              /* INTEGER_0_100 */
static int hf_ngap_dL_non_GBR_PRB_usage;          /* INTEGER_0_100 */
static int hf_ngap_uL_non_GBR_PRB_usage;          /* INTEGER_0_100 */
static int hf_ngap_dL_Total_PRB_usage;            /* INTEGER_0_100 */
static int hf_ngap_uL_Total_PRB_usage;            /* INTEGER_0_100 */
static int hf_ngap_dL_scheduling_PDCCH_CCE_usage;  /* INTEGER_0_100 */
static int hf_ngap_uL_scheduling_PDCCH_CCE_usage;  /* INTEGER_0_100 */
static int hf_ngap_nGRAN_CellReportList;          /* NGRAN_CellReportList */
static int hf_ngap_NGRAN_CellReportList_item;     /* NGRAN_CellReportItem */
static int hf_ngap_nGRAN_CompositeAvailableCapacityGroup;  /* EUTRAN_CompositeAvailableCapacityGroup */
static int hf_ngap_nGRAN_NumberOfActiveUEs;       /* NGRAN_NumberOfActiveUEs */
static int hf_ngap_nGRAN_NoofRRCConnections;      /* NGRAN_NoofRRCConnections */
static int hf_ngap_nGRAN_RadioResourceStatus;     /* NGRAN_RadioResourceStatus */
static int hf_ngap_dL_GBR_PRB_usage_for_MIMO;     /* INTEGER_0_100 */
static int hf_ngap_uL_GBR_PRB_usage_for_MIMO;     /* INTEGER_0_100 */
static int hf_ngap_dL_non_GBR_PRB_usage_for_MIMO;  /* INTEGER_0_100 */
static int hf_ngap_uL_non_GBR_PRB_usage_for_MIMO;  /* INTEGER_0_100 */
static int hf_ngap_dL_Total_PRB_usage_for_MIMO;   /* INTEGER_0_100 */
static int hf_ngap_uL_Total_PRB_usage_for_MIMO;   /* INTEGER_0_100 */
static int hf_ngap_handoverReportType_01;         /* InterSystemHandoverReportType */
static int hf_ngap_tooearlyIntersystemHO;         /* TooearlyIntersystemHO */
static int hf_ngap_intersystemUnnecessaryHO;      /* IntersystemUnnecessaryHO */
static int hf_ngap_sourcecellID;                  /* NGRAN_CGI */
static int hf_ngap_targetcellID;                  /* EUTRA_CGI */
static int hf_ngap_reconnectCellID;               /* EUTRA_CGI */
static int hf_ngap_earlyIRATHO;                   /* T_earlyIRATHO */
static int hf_ngap_candidateCellList;             /* CandidateCellList */
static int hf_ngap_lAC;                           /* LAC */
static int hf_ngap_nGRANCell;                     /* LastVisitedNGRANCellInformation */
static int hf_ngap_eUTRANCell;                    /* LastVisitedEUTRANCellInformation */
static int hf_ngap_uTRANCell;                     /* LastVisitedUTRANCellInformation */
static int hf_ngap_gERANCell;                     /* LastVisitedGERANCellInformation */
static int hf_ngap_lastVisitedCellInformation;    /* LastVisitedCellInformation */
static int hf_ngap_globalCellID;                  /* NGRAN_CGI */
static int hf_ngap_cellType;                      /* CellType */
static int hf_ngap_timeUEStayedInCell;            /* TimeUEStayedInCell */
static int hf_ngap_timeUEStayedInCellEnhancedGranularity;  /* TimeUEStayedInCellEnhancedGranularity */
static int hf_ngap_hOCauseValue;                  /* Cause */
static int hf_ngap_LastVisitedPSCellList_item;    /* LastVisitedPSCellInformation */
static int hf_ngap_pSCellID;                      /* NGRAN_CGI */
static int hf_ngap_timeStay;                      /* INTEGER_0_40950 */
static int hf_ngap_eventType;                     /* EventType */
static int hf_ngap_reportArea;                    /* ReportArea */
static int hf_ngap_areaOfInterestList;            /* AreaOfInterestList */
static int hf_ngap_loggingInterval;               /* LoggingInterval */
static int hf_ngap_loggingDuration;               /* LoggingDuration */
static int hf_ngap_loggedMDTTrigger;              /* LoggedMDTTrigger */
static int hf_ngap_areaScopeOfNeighCellsList;     /* AreaScopeOfNeighCellsList */
static int hf_ngap_periodical;                    /* NULL */
static int hf_ngap_eventTrigger;                  /* EventTrigger */
static int hf_ngap_vehicleUE;                     /* VehicleUE */
static int hf_ngap_pedestrianUE;                  /* PedestrianUE */
static int hf_ngap_uESidelinkAggregateMaximumBitRate;  /* BitRate */
static int hf_ngap_aerialUE;                      /* T_aerialUE */
static int hf_ngap_aerialControllerUE;            /* T_aerialControllerUE */
static int hf_ngap_MBS_DataForwardingResponseMRBList_item;  /* MBS_DataForwardingResponseMRBItem */
static int hf_ngap_mRB_ID;                        /* MRB_ID */
static int hf_ngap_dL_Forwarding_UPTNLInformation;  /* UPTransportLayerInformation */
static int hf_ngap_mRB_ProgressInformation;       /* MRB_ProgressInformation */
static int hf_ngap_MBS_MappingandDataForwardingRequestList_item;  /* MBS_MappingandDataForwardingRequestItem */
static int hf_ngap_mBS_QoSFlowList;               /* MBS_QoSFlowList */
static int hf_ngap_MBS_QoSFlowList_item;          /* QosFlowIdentifier */
static int hf_ngap_pDCP_SN_Length12;              /* INTEGER_0_4095 */
static int hf_ngap_pDCP_SN_Length18;              /* INTEGER_0_262143 */
static int hf_ngap_MBS_QoSFlowsToBeSetupList_item;  /* MBS_QoSFlowsToBeSetupItem */
static int hf_ngap_mBSqosFlowIdentifier;          /* QosFlowIdentifier */
static int hf_ngap_mBSqosFlowLevelQosParameters;  /* QosFlowLevelQosParameters */
static int hf_ngap_locationindependent;           /* MBS_ServiceAreaInformation */
static int hf_ngap_locationdependent;             /* MBS_ServiceAreaInformationList */
static int hf_ngap_MBS_ServiceAreaInformationList_item;  /* MBS_ServiceAreaInformationItem */
static int hf_ngap_mBS_AreaSessionID;             /* MBS_AreaSessionID */
static int hf_ngap_mBS_ServiceAreaInformation;    /* MBS_ServiceAreaInformation */
static int hf_ngap_mBS_ServiceAreaCellList;       /* MBS_ServiceAreaCellList */
static int hf_ngap_mBS_ServiceAreaTAIList;        /* MBS_ServiceAreaTAIList */
static int hf_ngap_MBS_ServiceAreaCellList_item;  /* NR_CGI */
static int hf_ngap_MBS_ServiceAreaTAIList_item;   /* TAI */
static int hf_ngap_tMGI;                          /* TMGI */
static int hf_ngap_MBSSessionFailedtoSetupList_item;  /* MBSSessionFailedtoSetupItem */
static int hf_ngap_MBS_ActiveSessionInformation_SourcetoTargetList_item;  /* MBS_ActiveSessionInformation_SourcetoTargetItem */
static int hf_ngap_mBS_ServiceArea;               /* MBS_ServiceArea */
static int hf_ngap_mBS_QoSFlowsToBeSetupList;     /* MBS_QoSFlowsToBeSetupList */
static int hf_ngap_mBS_MappingandDataForwardingRequestList;  /* MBS_MappingandDataForwardingRequestList */
static int hf_ngap_MBS_ActiveSessionInformation_TargettoSourceList_item;  /* MBS_ActiveSessionInformation_TargettoSourceItem */
static int hf_ngap_mBS_DataForwardingResponseMRBList;  /* MBS_DataForwardingResponseMRBList */
static int hf_ngap_MBSSessionSetupResponseList_item;  /* MBSSessionSetupResponseItem */
static int hf_ngap_protocolIEs;                   /* ProtocolIE_Container */
static int hf_ngap_SupportedUETypeList_item;      /* SupportedUEType */
static int hf_ngap_MBS_SessionFSAIDList_item;     /* MBS_SessionFSAID */
static int hf_ngap_locationindependent_01;        /* SharedNGU_MulticastTNLInformation */
static int hf_ngap_locationdependent_01;          /* MBS_SessionTNLInfo5GCList */
static int hf_ngap_MBS_SessionTNLInfo5GCList_item;  /* MBS_SessionTNLInfo5GCItem */
static int hf_ngap_sharedNGU_MulticastTNLInformation;  /* SharedNGU_MulticastTNLInformation */
static int hf_ngap_locationindependent_02;        /* UPTransportLayerInformation */
static int hf_ngap_locationdependent_02;          /* MBS_SessionTNLInfoNGRANList */
static int hf_ngap_MBS_SessionTNLInfoNGRANList_item;  /* MBS_SessionTNLInfoNGRANItem */
static int hf_ngap_sharedNGU_UnicastTNLInformation;  /* UPTransportLayerInformation */
static int hf_ngap_mBSSessionStatus;              /* MBSSessionStatus */
static int hf_ngap_locationindependent_03;        /* MBS_UP_FailureIndication */
static int hf_ngap_locationdependent_03;          /* MBS_UP_FailureIndicationList */
static int hf_ngap_MBS_UP_FailureIndicationList_item;  /* MBS_UP_FailureIndicationItem */
static int hf_ngap_mBS_UP_FailureIndication;      /* MBS_UP_FailureIndication */
static int hf_ngap_MBSSessionSetupRequestList_item;  /* MBSSessionSetupRequestItem */
static int hf_ngap_associatedMBSQosFlowSetupRequestList;  /* AssociatedMBSQosFlowSetupRequestList */
static int hf_ngap_MBSSessionSetuporModifyRequestList_item;  /* MBSSessionSetuporModifyRequestItem */
static int hf_ngap_associatedMBSQosFlowSetuporModifyRequestList;  /* AssociatedMBSQosFlowSetuporModifyRequestList */
static int hf_ngap_mBS_QosFlowToReleaseList;      /* QosFlowListWithCause */
static int hf_ngap_MBSSessionToReleaseList_item;  /* MBSSessionToReleaseItem */
static int hf_ngap_servingPLMN;                   /* PLMNIdentity */
static int hf_ngap_equivalentPLMNs;               /* EquivalentPLMNs */
static int hf_ngap_rATRestrictions;               /* RATRestrictions */
static int hf_ngap_forbiddenAreaInformation;      /* ForbiddenAreaInformation */
static int hf_ngap_serviceAreaInformation;        /* ServiceAreaInformation */
static int hf_ngap_s_basedMDT;                    /* NGRANTraceID */
static int hf_ngap_MDTPLMNList_item;              /* PLMNIdentity */
static int hf_ngap_MDTPLMNModificationList_item;  /* PLMNIdentity */
static int hf_ngap_mdt_Config_NR;                 /* MDT_Configuration_NR */
static int hf_ngap_mdt_Config_EUTRA;              /* MDT_Configuration_EUTRA */
static int hf_ngap_mdt_Activation;                /* MDT_Activation */
static int hf_ngap_areaScopeOfMDT;                /* AreaScopeOfMDT_NR */
static int hf_ngap_mDTModeNr;                     /* MDTModeNr */
static int hf_ngap_signallingBasedMDTPLMNList;    /* MDTPLMNList */
static int hf_ngap_areaScopeOfMDT_01;             /* AreaScopeOfMDT_EUTRA */
static int hf_ngap_mDTMode;                       /* MDTModeEutra */
static int hf_ngap_immediateMDTNr;                /* ImmediateMDTNr */
static int hf_ngap_loggedMDTNr;                   /* LoggedMDTNr */
static int hf_ngap_MulticastGroupPagingAreaList_item;  /* MulticastGroupPagingAreaItem */
static int hf_ngap_multicastGroupPagingArea;      /* MulticastGroupPagingArea */
static int hf_ngap_uE_PagingList;                 /* UE_PagingList */
static int hf_ngap_MBS_AreaTAIList_item;          /* TAI */
static int hf_ngap_mBS_AreaTAIList;               /* MBS_AreaTAIList */
static int hf_ngap_UE_PagingList_item;            /* UE_PagingItem */
static int hf_ngap_pagingDRX;                     /* PagingDRX */
static int hf_ngap_m1reportingTrigger;            /* M1ReportingTrigger */
static int hf_ngap_m1thresholdEventA2;            /* M1ThresholdEventA2 */
static int hf_ngap_m1periodicReporting;           /* M1PeriodicReporting */
static int hf_ngap_m1ThresholdType;               /* M1ThresholdType */
static int hf_ngap_threshold_SINR;                /* Threshold_SINR */
static int hf_ngap_reportInterval;                /* ReportIntervalMDT */
static int hf_ngap_reportAmount;                  /* ReportAmountMDT */
static int hf_ngap_m4period;                      /* M4period */
static int hf_ngap_m4_links_to_log;               /* Links_to_log */
static int hf_ngap_m5period;                      /* M5period */
static int hf_ngap_m5_links_to_log;               /* Links_to_log */
static int hf_ngap_m6report_Interval;             /* M6report_Interval */
static int hf_ngap_m6_links_to_log;               /* Links_to_log */
static int hf_ngap_m7period;                      /* M7period */
static int hf_ngap_m7_links_to_log;               /* Links_to_log */
static int hf_ngap_mDT_Location_Information;      /* MDT_Location_Information */
static int hf_ngap_n3IWF_ID;                      /* BIT_STRING_SIZE_16 */
static int hf_ngap_n6JitterLowerBound;            /* INTEGER_M127_127 */
static int hf_ngap_n6JitterUpperBound;            /* INTEGER_M127_127 */
static int hf_ngap_nB_IoT_Paging_eDRXCycle;       /* NB_IoT_Paging_eDRXCycle */
static int hf_ngap_nB_IoT_Paging_TimeWindow;      /* NB_IoT_Paging_TimeWindow */
static int hf_ngap_NGAPIESupportInformationRequestList_item;  /* NGAPIESupportInformationRequestItem */
static int hf_ngap_ngap_ProtocolIE_Id;            /* ProtocolIE_ID */
static int hf_ngap_NGAPIESupportInformationResponseList_item;  /* NGAPIESupportInformationResponseItem */
static int hf_ngap_ngap_ProtocolIESupportInfo;    /* T_ngap_ProtocolIESupportInfo */
static int hf_ngap_ngap_ProtocolIEPresenceInfo;   /* T_ngap_ProtocolIEPresenceInfo */
static int hf_ngap_macroNgENB_ID;                 /* BIT_STRING_SIZE_20 */
static int hf_ngap_shortMacroNgENB_ID;            /* BIT_STRING_SIZE_18 */
static int hf_ngap_longMacroNgENB_ID;             /* BIT_STRING_SIZE_21 */
static int hf_ngap_NGRAN_TNLAssociationToRemoveList_item;  /* NGRAN_TNLAssociationToRemoveItem */
static int hf_ngap_tNLAssociationTransportLayerAddress;  /* CPTransportLayerInformation */
static int hf_ngap_tNLAssociationTransportLayerAddressAMF;  /* CPTransportLayerInformation */
static int hf_ngap_NotAllowedTACs_item;           /* TAC */
static int hf_ngap_pNI_NPN_Access_Information;    /* CellCAGList */
static int hf_ngap_sNPN_MobilityInformation;      /* SNPN_MobilityInformation */
static int hf_ngap_pNI_NPN_MobilityInformation;   /* PNI_NPN_MobilityInformation */
static int hf_ngap_pNI_NPN_PagingAssistance;      /* Allowed_PNI_NPN_List */
static int hf_ngap_sNPN;                          /* NID */
static int hf_ngap_nRCellIdentity;                /* NRCellIdentity */
static int hf_ngap_NR_CGIList_item;               /* NR_CGI */
static int hf_ngap_NR_CGIListForWarning_item;     /* NR_CGI */
static int hf_ngap_nR_paging_eDRX_Cycle;          /* NR_Paging_eDRX_Cycle */
static int hf_ngap_nR_paging_Time_Window;         /* NR_Paging_Time_Window */
static int hf_ngap_nR_paging_Long_eDRX_Cycle_for_RRC_INACTIVE;  /* NR_Paging_Long_eDRX_Cycle_for_RRC_INACTIVE */
static int hf_ngap_nR_paging_Time_Window_for_RRC_INACTIVE;  /* NR_Paging_Time_Window_for_RRC_INACTIVE */
static int hf_ngap_tACListInNRNTN;                /* TACListInNRNTN */
static int hf_ngap_uELocationDerivedTACInNRNTN;   /* TAC */
static int hf_ngap_NRFrequencyBand_List_item;     /* NRFrequencyBandItem */
static int hf_ngap_nr_frequency_band;             /* NRFrequencyBand */
static int hf_ngap_nrARFCN;                       /* NRARFCN */
static int hf_ngap_frequencyBand_List;            /* NRFrequencyBand_List */
static int hf_ngap_aerialUE_01;                   /* T_aerialUE_01 */
static int hf_ngap_aerialControllerUE_01;         /* T_aerialControllerUE_01 */
static int hf_ngap_overloadAction;                /* OverloadAction */
static int hf_ngap_OverloadStartNSSAIList_item;   /* OverloadStartNSSAIItem */
static int hf_ngap_sliceOverloadList;             /* SliceOverloadList */
static int hf_ngap_sliceOverloadResponse;         /* OverloadResponse */
static int hf_ngap_sliceTrafficLoadReductionIndication;  /* TrafficLoadReductionIndication */
static int hf_ngap_pERScalar;                     /* INTEGER_0_9_ */
static int hf_ngap_pERExponent;                   /* INTEGER_0_9_ */
static int hf_ngap_coverageEnhancementLevel;      /* CoverageEnhancementLevel */
static int hf_ngap_pagingAttemptCount;            /* PagingAttemptCount */
static int hf_ngap_intendedNumberOfPagingAttempts;  /* IntendedNumberOfPagingAttempts */
static int hf_ngap_nextPagingAreaScope;           /* NextPagingAreaScope */
static int hf_ngap_pDUSessionForPagingList;       /* PDUSessionForPagingList */
static int hf_ngap_PDUSessionForPagingList_item;  /* PDUSessionForPagingItem */
static int hf_ngap_pDUSessionID;                  /* PDUSessionID */
static int hf_ngap_pagingPolicyDifferentiationList;  /* PagingPolicyDifferentiationList */
static int hf_ngap_PagingPolicyDifferentiationList_item;  /* PagingPolicyDifferentiationItem */
static int hf_ngap_pagingPolicyIndicator;         /* PagingPolicyIndicator */
static int hf_ngap_allocationAndRetentionPriority;  /* AllocationAndRetentionPriority */
static int hf_ngap_dl_DataSize;                   /* INTEGER_0_96000_ */
static int hf_ngap_Partially_Allowed_NSSAI_item;  /* PartiallyAllowedNSSAI_Item */
static int hf_ngap_uL_NGU_UP_TNLInformation;      /* UPTransportLayerInformation */
static int hf_ngap_securityIndication;            /* SecurityIndication */
static int hf_ngap_dL_NGU_TNLInformationReused;   /* DL_NGU_TNLInformationReused */
static int hf_ngap_userPlaneSecurityInformation;  /* UserPlaneSecurityInformation */
static int hf_ngap_qosFlowAcceptedList;           /* QosFlowAcceptedList */
static int hf_ngap_pc5QoSFlowList;                /* PC5QoSFlowList */
static int hf_ngap_pc5LinkAggregateBitRates;      /* BitRate */
static int hf_ngap_PC5QoSFlowList_item;           /* PC5QoSFlowItem */
static int hf_ngap_pQI;                           /* FiveQI */
static int hf_ngap_pc5FlowBitRates;               /* PC5FlowBitRates */
static int hf_ngap_range;                         /* Range */
static int hf_ngap_guaranteedFlowBitRate;         /* BitRate */
static int hf_ngap_maximumFlowBitRate;            /* BitRate */
static int hf_ngap_PCIListForMDT_item;            /* NR_PCI */
static int hf_ngap_pDUSessionAggregateMaximumBitRateDL;  /* BitRate */
static int hf_ngap_pDUSessionAggregateMaximumBitRateUL;  /* BitRate */
static int hf_ngap_PDUSessionResourceAdmittedList_item;  /* PDUSessionResourceAdmittedItem */
static int hf_ngap_handoverRequestAcknowledgeTransfer;  /* T_handoverRequestAcknowledgeTransfer */
static int hf_ngap_PDUSessionResourceFailedToModifyListModCfm_item;  /* PDUSessionResourceFailedToModifyItemModCfm */
static int hf_ngap_pDUSessionResourceModifyIndicationUnsuccessfulTransfer;  /* T_pDUSessionResourceModifyIndicationUnsuccessfulTransfer */
static int hf_ngap_PDUSessionResourceFailedToModifyListModRes_item;  /* PDUSessionResourceFailedToModifyItemModRes */
static int hf_ngap_pDUSessionResourceModifyUnsuccessfulTransfer;  /* T_pDUSessionResourceModifyUnsuccessfulTransfer */
static int hf_ngap_PDUSessionResourceFailedToResumeListRESReq_item;  /* PDUSessionResourceFailedToResumeItemRESReq */
static int hf_ngap_PDUSessionResourceFailedToResumeListRESRes_item;  /* PDUSessionResourceFailedToResumeItemRESRes */
static int hf_ngap_PDUSessionResourceFailedToSetupListCxtFail_item;  /* PDUSessionResourceFailedToSetupItemCxtFail */
static int hf_ngap_pDUSessionResourceSetupUnsuccessfulTransfer;  /* T_pDUSessionResourceSetupUnsuccessfulTransfer */
static int hf_ngap_PDUSessionResourceFailedToSetupListCxtRes_item;  /* PDUSessionResourceFailedToSetupItemCxtRes */
static int hf_ngap_pDUSessionResourceSetupUnsuccessfulTransfer_01;  /* T_pDUSessionResourceSetupUnsuccessfulTransfer_01 */
static int hf_ngap_PDUSessionResourceFailedToSetupListHOAck_item;  /* PDUSessionResourceFailedToSetupItemHOAck */
static int hf_ngap_handoverResourceAllocationUnsuccessfulTransfer;  /* T_handoverResourceAllocationUnsuccessfulTransfer */
static int hf_ngap_PDUSessionResourceFailedToSetupListPSReq_item;  /* PDUSessionResourceFailedToSetupItemPSReq */
static int hf_ngap_pathSwitchRequestSetupFailedTransfer;  /* T_pathSwitchRequestSetupFailedTransfer */
static int hf_ngap_PDUSessionResourceFailedToSetupListSURes_item;  /* PDUSessionResourceFailedToSetupItemSURes */
static int hf_ngap_pDUSessionResourceSetupUnsuccessfulTransfer_02;  /* T_pDUSessionResourceSetupUnsuccessfulTransfer_02 */
static int hf_ngap_PDUSessionResourceHandoverList_item;  /* PDUSessionResourceHandoverItem */
static int hf_ngap_handoverCommandTransfer;       /* T_handoverCommandTransfer */
static int hf_ngap_PDUSessionResourceInformationList_item;  /* PDUSessionResourceInformationItem */
static int hf_ngap_qosFlowInformationList;        /* QosFlowInformationList */
static int hf_ngap_dRBsToQosFlowsMappingList;     /* DRBsToQosFlowsMappingList */
static int hf_ngap_PDUSessionResourceListCxtRelCpl_item;  /* PDUSessionResourceItemCxtRelCpl */
static int hf_ngap_PDUSessionResourceListCxtRelReq_item;  /* PDUSessionResourceItemCxtRelReq */
static int hf_ngap_PDUSessionResourceListHORqd_item;  /* PDUSessionResourceItemHORqd */
static int hf_ngap_handoverRequiredTransfer;      /* T_handoverRequiredTransfer */
static int hf_ngap_PDUSessionListMTCommHReq_item;  /* PDUSessionListMTCommHReq_Item */
static int hf_ngap_qosFlowModifyConfirmList;      /* QosFlowModifyConfirmList */
static int hf_ngap_uLNGU_UP_TNLInformation;       /* UPTransportLayerInformation */
static int hf_ngap_additionalNG_UUPTNLInformation;  /* UPTransportLayerInformationPairList */
static int hf_ngap_qosFlowFailedToModifyList;     /* QosFlowListWithCause */
static int hf_ngap_qosFlowAddOrModifyResponseList;  /* QosFlowAddOrModifyResponseList */
static int hf_ngap_additionalDLQosFlowPerTNLInformation;  /* QosFlowPerTNLInformationList */
static int hf_ngap_qosFlowFailedToAddOrModifyList;  /* QosFlowListWithCause */
static int hf_ngap_dLQosFlowPerTNLInformation;    /* QosFlowPerTNLInformation */
static int hf_ngap_PDUSessionResourceModifyListModCfm_item;  /* PDUSessionResourceModifyItemModCfm */
static int hf_ngap_pDUSessionResourceModifyConfirmTransfer;  /* T_pDUSessionResourceModifyConfirmTransfer */
static int hf_ngap_PDUSessionResourceModifyListModInd_item;  /* PDUSessionResourceModifyItemModInd */
static int hf_ngap_pDUSessionResourceModifyIndicationTransfer;  /* T_pDUSessionResourceModifyIndicationTransfer */
static int hf_ngap_PDUSessionResourceModifyListModReq_item;  /* PDUSessionResourceModifyItemModReq */
static int hf_ngap_nAS_PDU;                       /* NAS_PDU */
static int hf_ngap_pDUSessionResourceModifyRequestTransfer;  /* T_pDUSessionResourceModifyRequestTransfer */
static int hf_ngap_PDUSessionResourceModifyListModRes_item;  /* PDUSessionResourceModifyItemModRes */
static int hf_ngap_pDUSessionResourceModifyResponseTransfer;  /* T_pDUSessionResourceModifyResponseTransfer */
static int hf_ngap_PDUSessionResourceNotifyList_item;  /* PDUSessionResourceNotifyItem */
static int hf_ngap_pDUSessionResourceNotifyTransfer;  /* T_pDUSessionResourceNotifyTransfer */
static int hf_ngap_qosFlowNotifyList;             /* QosFlowNotifyList */
static int hf_ngap_qosFlowReleasedList;           /* QosFlowListWithCause */
static int hf_ngap_PDUSessionResourceReleasedListNot_item;  /* PDUSessionResourceReleasedItemNot */
static int hf_ngap_pDUSessionResourceNotifyReleasedTransfer;  /* T_pDUSessionResourceNotifyReleasedTransfer */
static int hf_ngap_PDUSessionResourceReleasedListPSAck_item;  /* PDUSessionResourceReleasedItemPSAck */
static int hf_ngap_pathSwitchRequestUnsuccessfulTransfer;  /* T_pathSwitchRequestUnsuccessfulTransfer */
static int hf_ngap_PDUSessionResourceReleasedListPSFail_item;  /* PDUSessionResourceReleasedItemPSFail */
static int hf_ngap_pathSwitchRequestUnsuccessfulTransfer_01;  /* T_pathSwitchRequestUnsuccessfulTransfer_01 */
static int hf_ngap_PDUSessionResourceReleasedListRelRes_item;  /* PDUSessionResourceReleasedItemRelRes */
static int hf_ngap_pDUSessionResourceReleaseResponseTransfer;  /* T_pDUSessionResourceReleaseResponseTransfer */
static int hf_ngap_PDUSessionResourceResumeListRESReq_item;  /* PDUSessionResourceResumeItemRESReq */
static int hf_ngap_uEContextResumeRequestTransfer;  /* T_uEContextResumeRequestTransfer */
static int hf_ngap_PDUSessionResourceResumeListRESRes_item;  /* PDUSessionResourceResumeItemRESRes */
static int hf_ngap_uEContextResumeResponseTransfer;  /* T_uEContextResumeResponseTransfer */
static int hf_ngap_PDUSessionResourceSecondaryRATUsageList_item;  /* PDUSessionResourceSecondaryRATUsageItem */
static int hf_ngap_secondaryRATDataUsageReportTransfer;  /* T_secondaryRATDataUsageReportTransfer */
static int hf_ngap_PDUSessionResourceSetupListCxtReq_item;  /* PDUSessionResourceSetupItemCxtReq */
static int hf_ngap_pDUSessionResourceSetupRequestTransfer;  /* T_pDUSessionResourceSetupRequestTransfer */
static int hf_ngap_PDUSessionResourceSetupListCxtRes_item;  /* PDUSessionResourceSetupItemCxtRes */
static int hf_ngap_pDUSessionResourceSetupResponseTransfer;  /* T_pDUSessionResourceSetupResponseTransfer */
static int hf_ngap_PDUSessionResourceSetupListHOReq_item;  /* PDUSessionResourceSetupItemHOReq */
static int hf_ngap_handoverRequestTransfer;       /* T_handoverRequestTransfer */
static int hf_ngap_PDUSessionResourceSetupListSUReq_item;  /* PDUSessionResourceSetupItemSUReq */
static int hf_ngap_pDUSessionNAS_PDU;             /* NAS_PDU */
static int hf_ngap_pDUSessionResourceSetupRequestTransfer_01;  /* T_pDUSessionResourceSetupRequestTransfer_01 */
static int hf_ngap_PDUSessionResourceSetupListSURes_item;  /* PDUSessionResourceSetupItemSURes */
static int hf_ngap_pDUSessionResourceSetupResponseTransfer_01;  /* T_pDUSessionResourceSetupResponseTransfer_01 */
static int hf_ngap_PDUSessionResourceSuspendListSUSReq_item;  /* PDUSessionResourceSuspendItemSUSReq */
static int hf_ngap_uEContextSuspendRequestTransfer;  /* T_uEContextSuspendRequestTransfer */
static int hf_ngap_PDUSessionResourceSwitchedList_item;  /* PDUSessionResourceSwitchedItem */
static int hf_ngap_pathSwitchRequestAcknowledgeTransfer;  /* T_pathSwitchRequestAcknowledgeTransfer */
static int hf_ngap_PDUSessionResourceToBeSwitchedDLList_item;  /* PDUSessionResourceToBeSwitchedDLItem */
static int hf_ngap_pathSwitchRequestTransfer;     /* T_pathSwitchRequestTransfer */
static int hf_ngap_PDUSessionResourceToReleaseListHOCmd_item;  /* PDUSessionResourceToReleaseItemHOCmd */
static int hf_ngap_handoverPreparationUnsuccessfulTransfer;  /* T_handoverPreparationUnsuccessfulTransfer */
static int hf_ngap_PDUSessionResourceToReleaseListRelCmd_item;  /* PDUSessionResourceToReleaseItemRelCmd */
static int hf_ngap_pDUSessionResourceReleaseCommandTransfer;  /* T_pDUSessionResourceReleaseCommandTransfer */
static int hf_ngap_rATType;                       /* T_rATType */
static int hf_ngap_pDUSessionTimedReportList;     /* VolumeTimedReportList */
static int hf_ngap_ulPDUSetQoSInformation;        /* PDUsetQoSInformation */
static int hf_ngap_dlPDUSetQoSInformation;        /* PDUsetQoSInformation */
static int hf_ngap_pduSetDelayBudget;             /* ExtendedPacketDelayBudget */
static int hf_ngap_pduSetErrorRate;               /* PacketErrorRate */
static int hf_ngap_pduSetIntegratedHandlingInformation;  /* T_pduSetIntegratedHandlingInformation */
static int hf_ngap_cNsubgroupID;                  /* CNsubgroupID */
static int hf_ngap_periodicityLowerBound;         /* Periodicity */
static int hf_ngap_periodicityUpperBound;         /* Periodicity */
static int hf_ngap_AllowedPeriodicityList_item;   /* Periodicity */
static int hf_ngap_periodicityBound;              /* PeriodicityBound */
static int hf_ngap_periodicityList;               /* AllowedPeriodicityList */
static int hf_ngap_plmnListforQMC;                /* PLMNListforQMC */
static int hf_ngap_PLMNListforQMC_item;           /* PLMNIdentity */
static int hf_ngap_PLMNSupportList_item;          /* PLMNSupportItem */
static int hf_ngap_sliceSupportList;              /* SliceSupportList */
static int hf_ngap_allowed_PNI_NPI_List;          /* Allowed_PNI_NPN_List */
static int hf_ngap_eUTRA_CGI_PWSFailedList;       /* EUTRA_CGIList */
static int hf_ngap_nR_CGI_PWSFailedList;          /* NR_CGIList */
static int hf_ngap_cAGListforMDT;                 /* CAGListforMDT */
static int hf_ngap_uEAppLayerMeasInfoList;        /* UEAppLayerMeasInfoList */
static int hf_ngap_qoEReferenceList;              /* QoEReferenceList */
static int hf_ngap_QoEReferenceList_item;         /* QoEReference */
static int hf_ngap_qoEReportingPath;              /* T_qoEReportingPath */
static int hf_ngap_rVQoEReportingPath;            /* T_rVQoEReportingPath */
static int hf_ngap_nonDynamic5QI;                 /* NonDynamic5QIDescriptor */
static int hf_ngap_dynamic5QI;                    /* Dynamic5QIDescriptor */
static int hf_ngap_QosFlowAcceptedList_item;      /* QosFlowAcceptedItem */
static int hf_ngap_QosFlowAdditionalInfoListRelCom_item;  /* QosFlowAdditionalInfoItemRelCom */
static int hf_ngap_downlinkTLContainer;           /* TLContainer */
static int hf_ngap_QosFlowAdditionalInfoListRelRes_item;  /* QosFlowAdditionalInfoItemRelRes */
static int hf_ngap_uplinkTLContainer;             /* TLContainer */
static int hf_ngap_QosFlowAddOrModifyRequestList_item;  /* QosFlowAddOrModifyRequestItem */
static int hf_ngap_qosFlowLevelQosParameters;     /* QosFlowLevelQosParameters */
static int hf_ngap_QosFlowAddOrModifyResponseList_item;  /* QosFlowAddOrModifyResponseItem */
static int hf_ngap_QosFlowFeedbackList_item;      /* QosFlowFeedbackItem */
static int hf_ngap_updateFeedback;                /* UpdateFeedback */
static int hf_ngap_cNpacketDelayBudgetDL;         /* ExtendedPacketDelayBudget */
static int hf_ngap_cNpacketDelayBudgetUL;         /* ExtendedPacketDelayBudget */
static int hf_ngap_QosFlowInformationList_item;   /* QosFlowInformationItem */
static int hf_ngap_qosCharacteristics;            /* QosCharacteristics */
static int hf_ngap_gBR_QosInformation;            /* GBR_QosInformation */
static int hf_ngap_reflectiveQosAttribute;        /* ReflectiveQosAttribute */
static int hf_ngap_additionalQosFlowInformation;  /* AdditionalQosFlowInformation */
static int hf_ngap_QosFlowListWithCause_item;     /* QosFlowWithCauseItem */
static int hf_ngap_QosFlowModifyConfirmList_item;  /* QosFlowModifyConfirmItem */
static int hf_ngap_QosFlowNotifyList_item;        /* QosFlowNotifyItem */
static int hf_ngap_notificationCause;             /* NotificationCause */
static int hf_ngap_QosFlowParametersList_item;    /* QosFlowParametersItem */
static int hf_ngap_alternativeQoSParaSetList;     /* AlternativeQoSParaSetList */
static int hf_ngap_uPTransportLayerInformation;   /* UPTransportLayerInformation */
static int hf_ngap_QosFlowPerTNLInformationList_item;  /* QosFlowPerTNLInformationItem */
static int hf_ngap_qosFlowPerTNLInformation;      /* QosFlowPerTNLInformation */
static int hf_ngap_QosFlowSetupRequestList_item;  /* QosFlowSetupRequestItem */
static int hf_ngap_QosFlowListWithDataForwarding_item;  /* QosFlowItemWithDataForwarding */
static int hf_ngap_dataForwardingAccepted;        /* DataForwardingAccepted */
static int hf_ngap_QosFlowToBeForwardedList_item;  /* QosFlowToBeForwardedItem */
static int hf_ngap_QoSFlowTSCList_item;           /* QoSFlowTSCItem */
static int hf_ngap_tSCTrafficCharacteristicsFeedback;  /* TSCTrafficCharacteristicsFeedback */
static int hf_ngap_aNPacketDelayBudgetUL;         /* ExtendedPacketDelayBudget */
static int hf_ngap_QoSFlowsUsageReportList_item;  /* QoSFlowsUsageReport_Item */
static int hf_ngap_rATType_01;                    /* T_rATType_01 */
static int hf_ngap_qoSFlowsTimedReportList;       /* VolumeTimedReportList */
static int hf_ngap_proactive;                     /* RANfeedbacktype_proactive */
static int hf_ngap_reactive;                      /* RANfeedbacktype_reactive */
static int hf_ngap_burstArrivalTimeWindow;        /* BurstArrivalTimeWindow */
static int hf_ngap_periodicityRange;              /* PeriodicityRange */
static int hf_ngap_capabilityForBATAdaptation;    /* T_capabilityForBATAdaptation */
static int hf_ngap_dRBsSubjectToStatusTransferList;  /* DRBsSubjectToStatusTransferList */
static int hf_ngap_synchronisationState_01;       /* T_synchronisationState */
static int hf_ngap_traceabletoUTC_01;             /* T_traceabletoUTC_01 */
static int hf_ngap_traceabletoGNSS_01;            /* T_traceabletoGNSS_01 */
static int hf_ngap_clockAccuracy_01;              /* ClockAccuracy */
static int hf_ngap_parentTImeSource_01;           /* ParentTImeSource */
static int hf_ngap_rANNodeLevel;                  /* GlobalGNB_ID */
static int hf_ngap_cellListLevel;                 /* RANTSSCellList */
static int hf_ngap_RANTSSCellList_item;           /* RANTSSCellItem */
static int hf_ngap_RATRestrictions_item;          /* RATRestrictions_Item */
static int hf_ngap_rATRestrictionInformation;     /* RATRestrictionInformation */
static int hf_ngap_recommendedCellList;           /* RecommendedCellList */
static int hf_ngap_RecommendedCellList_item;      /* RecommendedCellItem */
static int hf_ngap_recommendedRANNodeList;        /* RecommendedRANNodeList */
static int hf_ngap_RecommendedRANNodeList_item;   /* RecommendedRANNodeItem */
static int hf_ngap_aMFPagingTarget;               /* AMFPagingTarget */
static int hf_ngap_rSN;                           /* RSN */
static int hf_ngap_nG_Interface;                  /* ResetAll */
static int hf_ngap_partOfNG_Interface;            /* UE_associatedLogicalNG_connectionList */
static int hf_ngap_targetRANNodeID_RIM;           /* TargetRANNodeID_RIM */
static int hf_ngap_sourceRANNodeID;               /* SourceRANNodeID */
static int hf_ngap_rIMInformation;                /* RIMInformation */
static int hf_ngap_targetgNBSetID;                /* GNBSetID */
static int hf_ngap_rIM_RSDetection;               /* T_rIM_RSDetection */
static int hf_ngap_RSPPQoSFlowList_item;          /* RSPPQoSFlowItem */
static int hf_ngap_rSPPFlowBitRates;              /* RSPPFlowBitRates */
static int hf_ngap_dayofWeek;                     /* BIT_STRING_SIZE_7 */
static int hf_ngap_timeofDayStart;                /* INTEGER_0_86399_ */
static int hf_ngap_timeofDayEnd;                  /* INTEGER_0_86399_ */
static int hf_ngap_SCTP_TLAs_item;                /* TransportLayerAddress */
static int hf_ngap_pDUSessionUsageReport;         /* PDUSessionUsageReport */
static int hf_ngap_qosFlowsUsageReportList;       /* QoSFlowsUsageReportList */
static int hf_ngap_secondaryRATUsageInformation;  /* SecondaryRATUsageInformation */
static int hf_ngap_nextHopChainingCount;          /* NextHopChainingCount */
static int hf_ngap_nextHopNH;                     /* SecurityKey */
static int hf_ngap_integrityProtectionIndication;  /* IntegrityProtectionIndication */
static int hf_ngap_confidentialityProtectionIndication;  /* ConfidentialityProtectionIndication */
static int hf_ngap_maximumIntegrityProtectedDataRate_UL;  /* MaximumIntegrityProtectedDataRate */
static int hf_ngap_integrityProtectionResult;     /* IntegrityProtectionResult */
static int hf_ngap_confidentialityProtectionResult;  /* ConfidentialityProtectionResult */
static int hf_ngap_sensorMeasConfig;              /* SensorMeasConfig */
static int hf_ngap_sensorMeasConfigNameList;      /* SensorMeasConfigNameList */
static int hf_ngap_SensorMeasConfigNameList_item;  /* SensorMeasConfigNameItem */
static int hf_ngap_sensorNameConfig;              /* SensorNameConfig */
static int hf_ngap_uncompensatedBarometricConfig;  /* T_uncompensatedBarometricConfig */
static int hf_ngap_ueSpeedConfig;                 /* T_ueSpeedConfig */
static int hf_ngap_ueOrientationConfig;           /* T_ueOrientationConfig */
static int hf_ngap_ServedGUAMIList_item;          /* ServedGUAMIItem */
static int hf_ngap_gUAMI;                         /* GUAMI */
static int hf_ngap_backupAMFName;                 /* AMFName */
static int hf_ngap_ServiceAreaInformation_item;   /* ServiceAreaInformation_Item */
static int hf_ngap_allowedTACs;                   /* AllowedTACs */
static int hf_ngap_notAllowedTACs;                /* NotAllowedTACs */
static int hf_ngap_iP_MulticastAddress;           /* TransportLayerAddress */
static int hf_ngap_iP_SourceAddress;              /* TransportLayerAddress */
static int hf_ngap_SliceOverloadList_item;        /* SliceOverloadItem */
static int hf_ngap_SliceSupportList_item;         /* SliceSupportItem */
static int hf_ngap_SliceSupportListQMC_item;      /* SliceSupportQMC_Item */
static int hf_ngap_serving_NID;                   /* NID */
static int hf_ngap_sST;                           /* SST */
static int hf_ngap_sD;                            /* SD */
static int hf_ngap_targetRANNodeID_SON;           /* TargetRANNodeID_SON */
static int hf_ngap_sONInformation;                /* SONInformation */
static int hf_ngap_xnTNLConfigurationInfo;        /* XnTNLConfigurationInfo */
static int hf_ngap_sONInformationRequest;         /* SONInformationRequest */
static int hf_ngap_sONInformationReply;           /* SONInformationReply */
static int hf_ngap_failureIndicationInformation_01;  /* FailureIndication */
static int hf_ngap_hOReportInformation_01;        /* HOReport */
static int hf_ngap_sNPNcellIdListforMDT;          /* SNPNCellIdListforMDT */
static int hf_ngap_SNPNCellIdListforMDT_item;     /* SNPNCellIdListforMDTItem */
static int hf_ngap_sNPNTAIListforMDT;             /* SNPNTAIListforMDT */
static int hf_ngap_SNPNTAIListforMDT_item;        /* SNPNTAIListforMDTItem */
static int hf_ngap_sNPNListforMDT;                /* SNPNListforMDT */
static int hf_ngap_SNPNListforMDT_item;           /* SNPNListforMDTItem */
static int hf_ngap_SuccessfulHandoverReportList_item;  /* SuccessfulHandoverReport_Item */
static int hf_ngap_successfulHOReportContainer;   /* T_successfulHOReportContainer */
static int hf_ngap_SuccessfulPSCellChangeReportList_item;  /* SuccessfulPSCellChangeReport_Item */
static int hf_ngap_successfulPSCellChangeReportContainer;  /* T_successfulPSCellChangeReportContainer */
static int hf_ngap_rRCContainer;                  /* RRCContainer */
static int hf_ngap_pDUSessionResourceInformationList;  /* PDUSessionResourceInformationList */
static int hf_ngap_e_RABInformationList;          /* E_RABInformationList */
static int hf_ngap_targetCell_ID;                 /* NGRAN_CGI */
static int hf_ngap_indexToRFSP;                   /* IndexToRFSP */
static int hf_ngap_uEHistoryInformation;          /* UEHistoryInformation */
static int hf_ngap_sourceengNB_ID;                /* GlobalGNB_ID */
static int hf_ngap_configuredNSSAI;               /* ConfiguredNSSAI */
static int hf_ngap_rejectedNSSAIinPLMN;           /* RejectedNSSAIinPLMN */
static int hf_ngap_rejectedNSSAIinTA;             /* RejectedNSSAIinTA */
static int hf_ngap_SupportedTAList_item;          /* SupportedTAItem */
static int hf_ngap_tAC;                           /* TAC */
static int hf_ngap_broadcastPLMNList;             /* BroadcastPLMNList */
static int hf_ngap_sLPositioningRangingAuthorized;  /* SLPositioningRangingAuthorized */
static int hf_ngap_sLPositioningRangingQoSParameters;  /* SLPositioningRangingQoSParameters */
static int hf_ngap_rSPPQoSFlowList;               /* RSPPQoSFlowList */
static int hf_ngap_rSPPLinkAggregateBitRates;     /* BitRate */
static int hf_ngap_TACListInNRNTN_item;           /* TAC */
static int hf_ngap_TAIBroadcastEUTRA_item;        /* TAIBroadcastEUTRA_Item */
static int hf_ngap_completedCellsInTAI_EUTRA;     /* CompletedCellsInTAI_EUTRA */
static int hf_ngap_TAIBroadcastNR_item;           /* TAIBroadcastNR_Item */
static int hf_ngap_completedCellsInTAI_NR;        /* CompletedCellsInTAI_NR */
static int hf_ngap_TAICancelledEUTRA_item;        /* TAICancelledEUTRA_Item */
static int hf_ngap_cancelledCellsInTAI_EUTRA;     /* CancelledCellsInTAI_EUTRA */
static int hf_ngap_TAICancelledNR_item;           /* TAICancelledNR_Item */
static int hf_ngap_cancelledCellsInTAI_NR;        /* CancelledCellsInTAI_NR */
static int hf_ngap_TAIListForInactive_item;       /* TAIListForInactiveItem */
static int hf_ngap_TAIListForPaging_item;         /* TAIListForPagingItem */
static int hf_ngap_TAIListForRestart_item;        /* TAI */
static int hf_ngap_TAIListForWarning_item;        /* TAI */
static int hf_ngap_TAINSAGSupportList_item;       /* TAINSAGSupportItem */
static int hf_ngap_nSAG_ID;                       /* NSAG_ID */
static int hf_ngap_nSAGSliceSupportList;          /* ExtendedSliceSupportList */
static int hf_ngap_globalENB_ID;                  /* GlobalNgENB_ID */
static int hf_ngap_selected_EPS_TAI;              /* EPS_TAI */
static int hf_ngap_targetRANNodeID;               /* TargetRANNodeID */
static int hf_ngap_targeteNB_ID;                  /* TargeteNB_ID */
static int hf_ngap_cell_CAGInformation;           /* Cell_CAGInformation */
static int hf_ngap_TargetNSSAI_item;              /* TargetNSSAI_Item */
static int hf_ngap_targetNSSAI;                   /* TargetNSSAI */
static int hf_ngap_lAI;                           /* LAI */
static int hf_ngap_rNC_ID;                        /* RNC_ID */
static int hf_ngap_extendedRNC_ID;                /* ExtendedRNC_ID */
static int hf_ngap_hOWindowStart;                 /* HandoverWindowStart */
static int hf_ngap_hOWindowDuration;              /* HandoverWindowDuration */
static int hf_ngap_timeDistributionIndication;    /* T_timeDistributionIndication */
static int hf_ngap_uUTimeSyncErrorBudget;         /* INTEGER_1_1000000_ */
static int hf_ngap_tNGF_ID;                       /* BIT_STRING_SIZE_32_ */
static int hf_ngap_TNLAssociationList_item;       /* TNLAssociationItem */
static int hf_ngap_tNLAssociationAddress;         /* CPTransportLayerInformation */
static int hf_ngap_sourcecellID_01;               /* EUTRA_CGI */
static int hf_ngap_failurecellID;                 /* NGRAN_CGI */
static int hf_ngap_nGRANTraceID;                  /* NGRANTraceID */
static int hf_ngap_interfacesToTrace;             /* InterfacesToTrace */
static int hf_ngap_traceDepth;                    /* TraceDepth */
static int hf_ngap_traceCollectionEntityIPAddress;  /* TransportLayerAddress */
static int hf_ngap_tAIListforMDT;                 /* TAIListforMDT */
static int hf_ngap_TAIListforMDT_item;            /* TAI */
static int hf_ngap_tAIListforQMC;                 /* TAIListforQMC */
static int hf_ngap_TAIListforQMC_item;            /* TAI */
static int hf_ngap_tAListforQMC;                  /* TAListforQMC */
static int hf_ngap_TAListforQMC_item;             /* TAC */
static int hf_ngap_tAListforMDT;                  /* TAListforMDT */
static int hf_ngap_TAListforMDT_item;             /* TAC */
static int hf_ngap_tWIF_ID;                       /* BIT_STRING_SIZE_32_ */
static int hf_ngap_periodicity;                   /* Periodicity */
static int hf_ngap_burstArrivalTime;              /* BurstArrivalTime */
static int hf_ngap_tSCAssistanceInformationDL;    /* TSCAssistanceInformation */
static int hf_ngap_tSCAssistanceInformationUL;    /* TSCAssistanceInformation */
static int hf_ngap_tSCFeedbackInformationDL;      /* TSCFeedbackInformation */
static int hf_ngap_tSCFeedbackInformationUL;      /* TSCFeedbackInformation */
static int hf_ngap_burstArrivalTimeOffset;        /* INTEGER_M640000_640000_ */
static int hf_ngap_adjustedPeriodicity;           /* Periodicity */
static int hf_ngap_uEAggregateMaximumBitRateDL;   /* BitRate */
static int hf_ngap_uEAggregateMaximumBitRateUL;   /* BitRate */
static int hf_ngap_UEAppLayerMeasInfoList_item;   /* UEAppLayerMeasInfoItem */
static int hf_ngap_uEAppLayerMeasConfigInfo;      /* UEAppLayerMeasConfigInfo */
static int hf_ngap_qoEReference;                  /* QoEReference */
static int hf_ngap_serviceType;                   /* ServiceType */
static int hf_ngap_areaScopeOfQMC;                /* AreaScopeOfQMC */
static int hf_ngap_measCollEntityIPAddress;       /* TransportLayerAddress */
static int hf_ngap_qoEMeasurementStatus;          /* T_qoEMeasurementStatus */
static int hf_ngap_containerForAppLayerMeasConfig;  /* OCTET_STRING_SIZE_1_8000 */
static int hf_ngap_measConfigAppLayerID;          /* INTEGER_0_15_ */
static int hf_ngap_sliceSupportListQMC;           /* SliceSupportListQMC */
static int hf_ngap_mDT_AlignmentInfo;             /* MDT_AlignmentInfo */
static int hf_ngap_availableRANVisibleQoEMetrics;  /* AvailableRANVisibleQoEMetrics */
static int hf_ngap_UE_associatedLogicalNG_connectionList_item;  /* UE_associatedLogicalNG_connectionItem */
static int hf_ngap_aMF_UE_NGAP_ID;                /* AMF_UE_NGAP_ID */
static int hf_ngap_rAN_UE_NGAP_ID;                /* RAN_UE_NGAP_ID */
static int hf_ngap_qosFlowFailedToResumeList;     /* QosFlowListWithCause */
static int hf_ngap_suspendIndicator;              /* SuspendIndicator */
static int hf_ngap_periodicCommunicationIndicator;  /* T_periodicCommunicationIndicator */
static int hf_ngap_periodicTime;                  /* INTEGER_1_3600_ */
static int hf_ngap_scheduledCommunicationTime;    /* ScheduledCommunicationTime */
static int hf_ngap_stationaryIndication;          /* T_stationaryIndication */
static int hf_ngap_trafficProfile;                /* T_trafficProfile */
static int hf_ngap_batteryIndication;             /* T_batteryIndication */
static int hf_ngap_UEHistoryInformation_item;     /* LastVisitedCellItem */
static int hf_ngap_nR;                            /* NRMobilityHistoryReport */
static int hf_ngap_indexLength10;                 /* BIT_STRING_SIZE_10 */
static int hf_ngap_uE_NGAP_ID_pair;               /* UE_NGAP_ID_pair */
static int hf_ngap_fiveG_S_TMSI;                  /* FiveG_S_TMSI */
static int hf_ngap_UEPresenceInAreaOfInterestList_item;  /* UEPresenceInAreaOfInterestItem */
static int hf_ngap_uEPresence;                    /* UEPresence */
static int hf_ngap_uERadioCapabilityForPagingOfNR;  /* UERadioCapabilityForPagingOfNR */
static int hf_ngap_uERadioCapabilityForPagingOfEUTRA;  /* UERadioCapabilityForPagingOfEUTRA */
static int hf_ngap_nR_01;                         /* NRUERLFReportContainer */
static int hf_ngap_lTE;                           /* LTEUERLFReportContainer */
static int hf_ngap_nRencryptionAlgorithms;        /* NRencryptionAlgorithms */
static int hf_ngap_nRintegrityProtectionAlgorithms;  /* NRintegrityProtectionAlgorithms */
static int hf_ngap_eUTRAencryptionAlgorithms;     /* EUTRAencryptionAlgorithms */
static int hf_ngap_eUTRAintegrityProtectionAlgorithms;  /* EUTRAintegrityProtectionAlgorithms */
static int hf_ngap_UESliceMaximumBitRateList_item;  /* UESliceMaximumBitRateItem */
static int hf_ngap_uESliceMaximumBitRateDL;       /* BitRate */
static int hf_ngap_uESliceMaximumBitRateUL;       /* BitRate */
static int hf_ngap_ul_NAS_MAC;                    /* UL_NAS_MAC */
static int hf_ngap_ul_NAS_Count;                  /* UL_NAS_Count */
static int hf_ngap_UL_NGU_UP_TNLModifyList_item;  /* UL_NGU_UP_TNLModifyItem */
static int hf_ngap_UnavailableGUAMIList_item;     /* UnavailableGUAMIItem */
static int hf_ngap_timerApproachForGUAMIRemoval;  /* TimerApproachForGUAMIRemoval */
static int hf_ngap_gTPTunnel;                     /* GTPTunnel */
static int hf_ngap_UPTransportLayerInformationList_item;  /* UPTransportLayerInformationItem */
static int hf_ngap_nGU_UP_TNLInformation;         /* UPTransportLayerInformation */
static int hf_ngap_UPTransportLayerInformationPairList_item;  /* UPTransportLayerInformationPairItem */
static int hf_ngap_userLocationInformationEUTRA;  /* UserLocationInformationEUTRA */
static int hf_ngap_userLocationInformationNR;     /* UserLocationInformationNR */
static int hf_ngap_userLocationInformationN3IWF;  /* UserLocationInformationN3IWF */
static int hf_ngap_timeStamp;                     /* TimeStamp */
static int hf_ngap_iPAddress;                     /* TransportLayerAddress */
static int hf_ngap_tNAP_ID;                       /* TNAP_ID */
static int hf_ngap_tWAP_ID;                       /* TWAP_ID */
static int hf_ngap_globalLine_ID;                 /* GlobalLine_ID */
static int hf_ngap_userPlaneFailureType;          /* UserPlaneFailureType */
static int hf_ngap_VolumeTimedReportList_item;    /* VolumeTimedReport_Item */
static int hf_ngap_startTimeStamp;                /* T_startTimeStamp */
static int hf_ngap_endTimeStamp;                  /* T_endTimeStamp */
static int hf_ngap_usageCountUL;                  /* INTEGER_0_18446744073709551615 */
static int hf_ngap_usageCountDL;                  /* INTEGER_0_18446744073709551615 */
static int hf_ngap_w_AGF_ID;                      /* BIT_STRING_SIZE_16_ */
static int hf_ngap_eUTRA_CGIListForWarning;       /* EUTRA_CGIListForWarning */
static int hf_ngap_nR_CGIListForWarning;          /* NR_CGIListForWarning */
static int hf_ngap_tAIListForWarning;             /* TAIListForWarning */
static int hf_ngap_emergencyAreaIDList;           /* EmergencyAreaIDList */
static int hf_ngap_wlanMeasConfig;                /* WLANMeasConfig */
static int hf_ngap_wlanMeasConfigNameList;        /* WLANMeasConfigNameList */
static int hf_ngap_wlan_rssi;                     /* T_wlan_rssi */
static int hf_ngap_wlan_rtt;                      /* T_wlan_rtt */
static int hf_ngap_WLANMeasConfigNameList_item;   /* WLANMeasConfigNameItem */
static int hf_ngap_wLANName;                      /* WLANName */
static int hf_ngap_pagingProbabilityInformation;  /* PagingProbabilityInformation */
static int hf_ngap_XnExtTLAs_item;                /* XnExtTLA_Item */
static int hf_ngap_iPsecTLA;                      /* TransportLayerAddress */
static int hf_ngap_gTP_TLAs;                      /* XnGTP_TLAs */
static int hf_ngap_XnGTP_TLAs_item;               /* TransportLayerAddress */
static int hf_ngap_XnTLAs_item;                   /* TransportLayerAddress */
static int hf_ngap_xnTransportLayerAddresses;     /* XnTLAs */
static int hf_ngap_xnExtendedTransportLayerAddresses;  /* XnExtTLAs */
static int hf_ngap_privateIEs;                    /* PrivateIE_Container */
static int hf_ngap_initiatingMessage;             /* InitiatingMessage */
static int hf_ngap_successfulOutcome;             /* SuccessfulOutcome */
static int hf_ngap_unsuccessfulOutcome;           /* UnsuccessfulOutcome */
static int hf_ngap_initiatingMessagevalue;        /* InitiatingMessage_value */
static int hf_ngap_successfulOutcome_value;       /* SuccessfulOutcome_value */
static int hf_ngap_unsuccessfulOutcome_value;     /* UnsuccessfulOutcome_value */

/* Initialize the subtree pointers */
static int ett_ngap;
static int ett_ngap_TransportLayerAddress;
static int ett_ngap_DataCodingScheme;
static int ett_ngap_SerialNumber;
static int ett_ngap_WarningType;
static int ett_ngap_WarningMessageContents;
static int ett_ngap_PLMNIdentity;
static int ett_ngap_NGAP_Message;
static int ett_ngap_NGRANTraceID;
static int ett_ngap_InterfacesToTrace;
static int ett_ngap_SourceToTarget_TransparentContainer;
static int ett_ngap_TargetToSource_TransparentContainer;
static int ett_ngap_RRCContainer;
static int ett_ngap_RATRestrictionInformation;
static int ett_ngap_primaryRATRestriction;
static int ett_ngap_secondaryRATRestriction;
static int ett_ngap_NrencryptionAlgorithms;
static int ett_ngap_NrintegrityProtectionAlgorithms;
static int ett_ngap_EUTRAencryptionAlgorithms;
static int ett_ngap_EUTRAintegrityProtectionAlgorithms;
static int ett_ngap_UERadioCapabilityForPagingOfNR;
static int ett_ngap_UERadioCapabilityForPagingOfEUTRA;
static int ett_ngap_UERadioCapability;
static int ett_ngap_LastVisitedEUTRANCellInformation;
static int ett_ngap_LastVisitedUTRANCellInformation;
static int ett_ngap_LastVisitedGERANCellInformation;
static int ett_ngap_NASSecurityParametersFromNGRAN;
static int ett_ngap_NASC;
static int ett_ngap_NAS_PDU;
static int ett_ngap_EN_DCSONConfigurationTransfer;
static int ett_ngap_BurstArrivalTime;
static int ett_ngap_CoverageEnhancementLevel;
static int ett_ngap_MDTModeEutra;
static int ett_ngap_MeasurementsToActivate;
static int ett_ngap_MDT_Location_Information;
static int ett_ngap_NRMobilityHistoryReport;
static int ett_ngap_LTEUERLFReportContainer;
static int ett_ngap_NRUERLFReportContainer;
static int ett_ngap_TargettoSource_Failure_TransparentContainer;
static int ett_ngap_UERadioCapabilityForPagingOfNB_IoT;
static int ett_ngap_GlobalCable_ID;
static int ett_ngap_UpdateFeedback;
static int ett_ngap_successfulHOReportContainer;
static int ett_ngap_successfulPSCellChangeReportContainer;
static int ett_ngap_PrivateIE_ID;
static int ett_ngap_ProtocolIE_Container;
static int ett_ngap_ProtocolIE_Field;
static int ett_ngap_ProtocolExtensionContainer;
static int ett_ngap_ProtocolExtensionField;
static int ett_ngap_PrivateIE_Container;
static int ett_ngap_PrivateIE_Field;
static int ett_ngap_AdditionalDLUPTNLInformationForHOList;
static int ett_ngap_AdditionalDLUPTNLInformationForHOItem;
static int ett_ngap_A2X_PC5_FlowBitRates;
static int ett_ngap_A2X_PC5_QoS_Flow_List;
static int ett_ngap_A2X_PC5_QoS_Flow_Item;
static int ett_ngap_A2X_PC5_QoS_Parameters;
static int ett_ngap_AdditionalCancelledlocationReportingReferenceIDList;
static int ett_ngap_AdditionalCancelledlocationReportingReferenceIDItem;
static int ett_ngap_AllocationAndRetentionPriority;
static int ett_ngap_Allowed_CAG_List_per_PLMN;
static int ett_ngap_AllowedNSSAI;
static int ett_ngap_AllowedNSSAI_Item;
static int ett_ngap_Allowed_PNI_NPN_List;
static int ett_ngap_Allowed_PNI_NPN_Item;
static int ett_ngap_AllowedTACs;
static int ett_ngap_AlternativeQoSParaSetList;
static int ett_ngap_AlternativeQoSParaSetItem;
static int ett_ngap_AMFPagingTarget;
static int ett_ngap_AMF_TNLAssociationSetupList;
static int ett_ngap_AMF_TNLAssociationSetupItem;
static int ett_ngap_AMF_TNLAssociationToAddList;
static int ett_ngap_AMF_TNLAssociationToAddItem;
static int ett_ngap_AMF_TNLAssociationToRemoveList;
static int ett_ngap_AMF_TNLAssociationToRemoveItem;
static int ett_ngap_AMF_TNLAssociationToUpdateList;
static int ett_ngap_AMF_TNLAssociationToUpdateItem;
static int ett_ngap_AreaOfInterest;
static int ett_ngap_AreaOfInterestCellList;
static int ett_ngap_AreaOfInterestCellItem;
static int ett_ngap_AreaOfInterestList;
static int ett_ngap_AreaOfInterestItem;
static int ett_ngap_AreaOfInterestRANNodeList;
static int ett_ngap_AreaOfInterestRANNodeItem;
static int ett_ngap_AreaOfInterestTAIList;
static int ett_ngap_AreaOfInterestTAIItem;
static int ett_ngap_AssistanceDataForPaging;
static int ett_ngap_AssistanceDataForRecommendedCells;
static int ett_ngap_AssociatedMBSQosFlowSetupRequestList;
static int ett_ngap_AssociatedMBSQosFlowSetupRequestItem;
static int ett_ngap_AssociatedMBSQosFlowSetuporModifyRequestList;
static int ett_ngap_AssociatedMBSQosFlowSetuporModifyRequestItem;
static int ett_ngap_AssociatedQosFlowList;
static int ett_ngap_AssociatedQosFlowItem;
static int ett_ngap_AreaScopeOfMDT_NR;
static int ett_ngap_AreaScopeOfMDT_EUTRA;
static int ett_ngap_AreaScopeOfNeighCellsList;
static int ett_ngap_AreaScopeOfNeighCellsItem;
static int ett_ngap_AreaScopeOfQMC;
static int ett_ngap_AvailableRANVisibleQoEMetrics;
static int ett_ngap_BeamMeasurementsReportConfiguration;
static int ett_ngap_BeamMeasurementsReportQuantity;
static int ett_ngap_BroadcastCancelledAreaList;
static int ett_ngap_BroadcastCompletedAreaList;
static int ett_ngap_BroadcastPLMNList;
static int ett_ngap_BroadcastPLMNItem;
static int ett_ngap_BroadcastTransportFailureTransfer;
static int ett_ngap_BroadcastTransportRequestTransfer;
static int ett_ngap_BroadcastTransportResponseTransfer;
static int ett_ngap_BluetoothMeasurementConfiguration;
static int ett_ngap_BluetoothMeasConfigNameList;
static int ett_ngap_BluetoothMeasConfigNameItem;
static int ett_ngap_BurstArrivalTimeWindow;
static int ett_ngap_CandidateRelayUEInformationList;
static int ett_ngap_CandidateRelayUEInformationItem;
static int ett_ngap_CancelledCellsInEAI_EUTRA;
static int ett_ngap_CancelledCellsInEAI_EUTRA_Item;
static int ett_ngap_CancelledCellsInEAI_NR;
static int ett_ngap_CancelledCellsInEAI_NR_Item;
static int ett_ngap_CancelledCellsInTAI_EUTRA;
static int ett_ngap_CancelledCellsInTAI_EUTRA_Item;
static int ett_ngap_CancelledCellsInTAI_NR;
static int ett_ngap_CancelledCellsInTAI_NR_Item;
static int ett_ngap_CandidateCellList;
static int ett_ngap_CandidateCellItem;
static int ett_ngap_CandidateCell;
static int ett_ngap_CandidateCellID;
static int ett_ngap_CandidatePCI;
static int ett_ngap_Cause;
static int ett_ngap_Cell_CAGInformation;
static int ett_ngap_CellCAGList;
static int ett_ngap_CellIDBroadcastEUTRA;
static int ett_ngap_CellIDBroadcastEUTRA_Item;
static int ett_ngap_CellIDBroadcastNR;
static int ett_ngap_CellIDBroadcastNR_Item;
static int ett_ngap_CellIDCancelledEUTRA;
static int ett_ngap_CellIDCancelledEUTRA_Item;
static int ett_ngap_CellIDCancelledNR;
static int ett_ngap_CellIDCancelledNR_Item;
static int ett_ngap_CellIDListForRestart;
static int ett_ngap_CellType;
static int ett_ngap_ClockAccuracy;
static int ett_ngap_ClockQualityAcceptanceIndication;
static int ett_ngap_ClockQualityAcceptanceCriteria;
static int ett_ngap_ClockQualityReportingControlInfo;
static int ett_ngap_ClockQualityDetailLevel;
static int ett_ngap_CNAssistedRANTuning;
static int ett_ngap_CNTypeRestrictionsForEquivalent;
static int ett_ngap_CNTypeRestrictionsForEquivalentItem;
static int ett_ngap_CompletedCellsInEAI_EUTRA;
static int ett_ngap_CompletedCellsInEAI_EUTRA_Item;
static int ett_ngap_CompletedCellsInEAI_NR;
static int ett_ngap_CompletedCellsInEAI_NR_Item;
static int ett_ngap_CompletedCellsInTAI_EUTRA;
static int ett_ngap_CompletedCellsInTAI_EUTRA_Item;
static int ett_ngap_CompletedCellsInTAI_NR;
static int ett_ngap_CompletedCellsInTAI_NR_Item;
static int ett_ngap_CoreNetworkAssistanceInformationForInactive;
static int ett_ngap_COUNTValueForPDCP_SN12;
static int ett_ngap_COUNTValueForPDCP_SN18;
static int ett_ngap_CPTransportLayerInformation;
static int ett_ngap_CriticalityDiagnostics;
static int ett_ngap_CriticalityDiagnostics_IE_List;
static int ett_ngap_CriticalityDiagnostics_IE_Item;
static int ett_ngap_CellBasedMDT_NR;
static int ett_ngap_CellIdListforMDT_NR;
static int ett_ngap_CellBasedMDT_EUTRA;
static int ett_ngap_CellBasedQMC;
static int ett_ngap_CellIdListforQMC;
static int ett_ngap_CellIdListforMDT_EUTRA;
static int ett_ngap_CAGListforMDT;
static int ett_ngap_CAGListforMDTItem;
static int ett_ngap_DataForwardingResponseDRBList;
static int ett_ngap_DataForwardingResponseDRBItem;
static int ett_ngap_DAPSRequestInfo;
static int ett_ngap_DAPSResponseInfoList;
static int ett_ngap_DAPSResponseInfoItem;
static int ett_ngap_DAPSResponseInfo;
static int ett_ngap_DataForwardingResponseERABList;
static int ett_ngap_DataForwardingResponseERABListItem;
static int ett_ngap_DL_CP_SecurityInformation;
static int ett_ngap_DRBsSubjectToStatusTransferList;
static int ett_ngap_DRBsSubjectToStatusTransferItem;
static int ett_ngap_DRBStatusDL;
static int ett_ngap_DRBStatusDL12;
static int ett_ngap_DRBStatusDL18;
static int ett_ngap_DRBStatusUL;
static int ett_ngap_DRBStatusUL12;
static int ett_ngap_DRBStatusUL18;
static int ett_ngap_DRBsToQosFlowsMappingList;
static int ett_ngap_DRBsToQosFlowsMappingItem;
static int ett_ngap_Dynamic5QIDescriptor;
static int ett_ngap_EarlyStatusTransfer_TransparentContainer;
static int ett_ngap_ProcedureStageChoice;
static int ett_ngap_DLDiscarding;
static int ett_ngap_DRBsSubjectToDLDiscarding_List;
static int ett_ngap_DRBsSubjectToDLDiscarding_Item;
static int ett_ngap_DLCountChoice;
static int ett_ngap_FirstDLCount;
static int ett_ngap_DRBsSubjectToEarlyStatusTransfer_List;
static int ett_ngap_DRBsSubjectToEarlyStatusTransfer_Item;
static int ett_ngap_ECNMarkingorCongestionInformationReportingRequest;
static int ett_ngap_ECNMarkingorCongestionInformationReportingStatus;
static int ett_ngap_ECNMarkingorCongestionInformationReportingStatus_Item;
static int ett_ngap_EmergencyAreaIDBroadcastEUTRA;
static int ett_ngap_EmergencyAreaIDBroadcastEUTRA_Item;
static int ett_ngap_EmergencyAreaIDBroadcastNR;
static int ett_ngap_EmergencyAreaIDBroadcastNR_Item;
static int ett_ngap_EmergencyAreaIDCancelledEUTRA;
static int ett_ngap_EmergencyAreaIDCancelledEUTRA_Item;
static int ett_ngap_EmergencyAreaIDCancelledNR;
static int ett_ngap_EmergencyAreaIDCancelledNR_Item;
static int ett_ngap_EmergencyAreaIDList;
static int ett_ngap_EmergencyAreaIDListForRestart;
static int ett_ngap_EmergencyFallbackIndicator;
static int ett_ngap_ENB_ID;
static int ett_ngap_EndpointIPAddressAndPort;
static int ett_ngap_EquivalentPLMNs;
static int ett_ngap_EPS_TAI;
static int ett_ngap_E_RABInformationList;
static int ett_ngap_E_RABInformationItem;
static int ett_ngap_EUTRA_CGI;
static int ett_ngap_EUTRA_CGIList;
static int ett_ngap_EUTRA_CGIListForWarning;
static int ett_ngap_EUTRA_PagingeDRXInformation;
static int ett_ngap_ExcessPacketDelayThresholdConfiguration;
static int ett_ngap_ExcessPacketDelayThresholdItem;
static int ett_ngap_ExpectedUEActivityBehaviour;
static int ett_ngap_ExpectedUEBehaviour;
static int ett_ngap_ExpectedUEMovingTrajectory;
static int ett_ngap_ExpectedUEMovingTrajectoryItem;
static int ett_ngap_Extended_AMFName;
static int ett_ngap_Extended_RANNodeName;
static int ett_ngap_ExtendedRATRestrictionInformation;
static int ett_ngap_ExtendedSliceSupportList;
static int ett_ngap_EventTrigger;
static int ett_ngap_EventL1LoggedMDTConfig;
static int ett_ngap_MeasurementThresholdL1LoggedMDT;
static int ett_ngap_EquivalentSNPNsList;
static int ett_ngap_EquivalentSNPNsItem;
static int ett_ngap_FailureIndication;
static int ett_ngap_FiveGCAction;
static int ett_ngap_FiveG_ProSeAuthorized;
static int ett_ngap_FiveG_ProSePC5QoSParameters;
static int ett_ngap_FiveGProSePC5QoSFlowList;
static int ett_ngap_FiveGProSePC5QoSFlowItem;
static int ett_ngap_FiveGProSePC5FlowBitRates;
static int ett_ngap_FiveG_S_TMSI;
static int ett_ngap_ForbiddenAreaInformation;
static int ett_ngap_ForbiddenAreaInformation_Item;
static int ett_ngap_ForbiddenTACs;
static int ett_ngap_FromEUTRANtoNGRAN;
static int ett_ngap_FromNGRANtoEUTRAN;
static int ett_ngap_GBR_QosInformation;
static int ett_ngap_GlobalCable_ID_new;
static int ett_ngap_GlobalENB_ID;
static int ett_ngap_GlobalGNB_ID;
static int ett_ngap_GlobalN3IWF_ID;
static int ett_ngap_GlobalLine_ID;
static int ett_ngap_GlobalNgENB_ID;
static int ett_ngap_GlobalRANNodeID;
static int ett_ngap_GlobalTNGF_ID;
static int ett_ngap_GlobalTWIF_ID;
static int ett_ngap_GlobalW_AGF_ID;
static int ett_ngap_GNB_ID;
static int ett_ngap_GTPTunnel;
static int ett_ngap_GUAMI;
static int ett_ngap_HandoverCommandTransfer;
static int ett_ngap_HandoverPreparationUnsuccessfulTransfer;
static int ett_ngap_HandoverRequestAcknowledgeTransfer;
static int ett_ngap_HandoverRequiredTransfer;
static int ett_ngap_HandoverResourceAllocationUnsuccessfulTransfer;
static int ett_ngap_HFCNode_ID_new;
static int ett_ngap_HLComActivate;
static int ett_ngap_HLComDeactivate;
static int ett_ngap_HOReport;
static int ett_ngap_MobileIAB_MTUserLocationInformation;
static int ett_ngap_InfoOnRecommendedCellsAndRANNodesForPaging;
static int ett_ngap_ImmediateMDTNr;
static int ett_ngap_InterSystemFailureIndication;
static int ett_ngap_IntersystemSONConfigurationTransfer;
static int ett_ngap_IntersystemSONTransferType;
static int ett_ngap_IntersystemSONeNBID;
static int ett_ngap_IntersystemSONNGRANnodeID;
static int ett_ngap_IntersystemSONInformation;
static int ett_ngap_IntersystemSONInformationRequest;
static int ett_ngap_IntersystemCellActivationRequest;
static int ett_ngap_CellsToActivateList;
static int ett_ngap_IntersystemResourceStatusRequest;
static int ett_ngap_ReportingSystem;
static int ett_ngap_EUTRAN_ReportingSystemIEs;
static int ett_ngap_NGRAN_ReportingSystemIEs;
static int ett_ngap_EUTRAN_CellToReportList;
static int ett_ngap_EUTRAN_CellToReportItem;
static int ett_ngap_NGRAN_CellToReportList;
static int ett_ngap_NGRAN_CellToReportItem;
static int ett_ngap_ReportType;
static int ett_ngap_EventBasedReportingIEs;
static int ett_ngap_PeriodicReportingIEs;
static int ett_ngap_IntersystemSONInformationReply;
static int ett_ngap_IntersystemCellActivationReply;
static int ett_ngap_ActivatedCellList;
static int ett_ngap_IntersystemResourceStatusReply;
static int ett_ngap_IntersystemSONInformationReport;
static int ett_ngap_IntersystemCellStateIndication;
static int ett_ngap_NotificationCellList;
static int ett_ngap_NotificationCell_Item;
static int ett_ngap_IntersystemResourceStatusReport;
static int ett_ngap_ResourceStatusReportingSystem;
static int ett_ngap_EUTRAN_ReportingStatusIEs;
static int ett_ngap_EUTRAN_CellReportList;
static int ett_ngap_EUTRAN_CellReportItem;
static int ett_ngap_EUTRAN_CompositeAvailableCapacityGroup;
static int ett_ngap_CompositeAvailableCapacity;
static int ett_ngap_EUTRAN_RadioResourceStatus;
static int ett_ngap_NGRAN_ReportingStatusIEs;
static int ett_ngap_NGRAN_CellReportList;
static int ett_ngap_NGRAN_CellReportItem;
static int ett_ngap_NGRAN_RadioResourceStatus;
static int ett_ngap_InterSystemHOReport;
static int ett_ngap_InterSystemHandoverReportType;
static int ett_ngap_IntersystemMobilityFailureforVoiceFallback;
static int ett_ngap_IntersystemUnnecessaryHO;
static int ett_ngap_LAI;
static int ett_ngap_LastVisitedCellInformation;
static int ett_ngap_LastVisitedCellItem;
static int ett_ngap_LastVisitedNGRANCellInformation;
static int ett_ngap_LastVisitedPSCellList;
static int ett_ngap_LastVisitedPSCellInformation;
static int ett_ngap_LocationReportingRequestType;
static int ett_ngap_LoggedMDTNr;
static int ett_ngap_LoggedMDTTrigger;
static int ett_ngap_LTEV2XServicesAuthorized;
static int ett_ngap_LTEUESidelinkAggregateMaximumBitrate;
static int ett_ngap_LTE_A2X_ServicesAuthorized;
static int ett_ngap_MBS_DataForwardingResponseMRBList;
static int ett_ngap_MBS_DataForwardingResponseMRBItem;
static int ett_ngap_MBS_MappingandDataForwardingRequestList;
static int ett_ngap_MBS_MappingandDataForwardingRequestItem;
static int ett_ngap_MBS_QoSFlowList;
static int ett_ngap_MRB_ProgressInformation;
static int ett_ngap_MBS_QoSFlowsToBeSetupList;
static int ett_ngap_MBS_QoSFlowsToBeSetupItem;
static int ett_ngap_MBS_ServiceArea;
static int ett_ngap_MBS_ServiceAreaInformationList;
static int ett_ngap_MBS_ServiceAreaInformationItem;
static int ett_ngap_MBS_ServiceAreaInformation;
static int ett_ngap_MBS_ServiceAreaCellList;
static int ett_ngap_MBS_ServiceAreaTAIList;
static int ett_ngap_MBS_SessionID;
static int ett_ngap_MBSSessionFailedtoSetupList;
static int ett_ngap_MBSSessionFailedtoSetupItem;
static int ett_ngap_MBS_ActiveSessionInformation_SourcetoTargetList;
static int ett_ngap_MBS_ActiveSessionInformation_SourcetoTargetItem;
static int ett_ngap_MBS_ActiveSessionInformation_TargettoSourceList;
static int ett_ngap_MBS_ActiveSessionInformation_TargettoSourceItem;
static int ett_ngap_MBSSessionSetupOrModFailureTransfer;
static int ett_ngap_MBSSessionSetupResponseList;
static int ett_ngap_MBSSessionSetupResponseItem;
static int ett_ngap_MBSSessionSetupOrModRequestTransfer;
static int ett_ngap_SupportedUETypeList;
static int ett_ngap_MBS_SessionFSAIDList;
static int ett_ngap_MBSSessionReleaseResponseTransfer;
static int ett_ngap_MBSSessionSetupOrModResponseTransfer;
static int ett_ngap_MBS_SessionTNLInfo5GC;
static int ett_ngap_MBS_SessionTNLInfo5GCList;
static int ett_ngap_MBS_SessionTNLInfo5GCItem;
static int ett_ngap_MBS_SessionTNLInfoNGRAN;
static int ett_ngap_MBS_SessionTNLInfoNGRANList;
static int ett_ngap_MBS_SessionTNLInfoNGRANItem;
static int ett_ngap_MBS_DistributionReleaseRequestTransfer;
static int ett_ngap_MBS_DistributionSetupRequestTransfer;
static int ett_ngap_MBS_DistributionSetupResponseTransfer;
static int ett_ngap_MBS_DistributionSetupUnsuccessfulTransfer;
static int ett_ngap_MBS_NGUFailureIndication;
static int ett_ngap_MBS_UP_FailureIndicationList;
static int ett_ngap_MBS_UP_FailureIndicationItem;
static int ett_ngap_MBSSessionSetupRequestList;
static int ett_ngap_MBSSessionSetupRequestItem;
static int ett_ngap_MBSSessionSetuporModifyRequestList;
static int ett_ngap_MBSSessionSetuporModifyRequestItem;
static int ett_ngap_MBSSessionToReleaseList;
static int ett_ngap_MBSSessionToReleaseItem;
static int ett_ngap_MobilityRestrictionList;
static int ett_ngap_MDT_AlignmentInfo;
static int ett_ngap_MDTPLMNList;
static int ett_ngap_MDTPLMNModificationList;
static int ett_ngap_MDT_Configuration;
static int ett_ngap_MDT_Configuration_NR;
static int ett_ngap_MDT_Configuration_EUTRA;
static int ett_ngap_MDTModeNr;
static int ett_ngap_MulticastSessionActivationRequestTransfer;
static int ett_ngap_MulticastSessionDeactivationRequestTransfer;
static int ett_ngap_MulticastSessionUpdateRequestTransfer;
static int ett_ngap_MulticastGroupPagingAreaList;
static int ett_ngap_MulticastGroupPagingAreaItem;
static int ett_ngap_MBS_AreaTAIList;
static int ett_ngap_MulticastGroupPagingArea;
static int ett_ngap_UE_PagingList;
static int ett_ngap_UE_PagingItem;
static int ett_ngap_M1Configuration;
static int ett_ngap_M1ThresholdEventA2;
static int ett_ngap_M1ThresholdType;
static int ett_ngap_M1PeriodicReporting;
static int ett_ngap_M4Configuration;
static int ett_ngap_M5Configuration;
static int ett_ngap_M6Configuration;
static int ett_ngap_M7Configuration;
static int ett_ngap_MDT_Location_Info;
static int ett_ngap_N3IWF_ID;
static int ett_ngap_N6JitterInformation;
static int ett_ngap_NB_IoT_Paging_eDRXInfo;
static int ett_ngap_NGAPIESupportInformationRequestList;
static int ett_ngap_NGAPIESupportInformationRequestItem;
static int ett_ngap_NGAPIESupportInformationResponseList;
static int ett_ngap_NGAPIESupportInformationResponseItem;
static int ett_ngap_NgENB_ID;
static int ett_ngap_NGRAN_CGI;
static int ett_ngap_NGRAN_TNLAssociationToRemoveList;
static int ett_ngap_NGRAN_TNLAssociationToRemoveItem;
static int ett_ngap_NonDynamic5QIDescriptor;
static int ett_ngap_NotAllowedTACs;
static int ett_ngap_NPN_AccessInformation;
static int ett_ngap_NPN_MobilityInformation;
static int ett_ngap_NPN_PagingAssistanceInformation;
static int ett_ngap_NPN_Support;
static int ett_ngap_NR_CGI;
static int ett_ngap_NR_CGIList;
static int ett_ngap_NR_CGIListForWarning;
static int ett_ngap_NR_PagingeDRXInformation;
static int ett_ngap_NR_Paging_Long_eDRX_Information_for_RRC_INACTIVE;
static int ett_ngap_NRNTNTAIInformation;
static int ett_ngap_NRFrequencyBand_List;
static int ett_ngap_NRFrequencyBandItem;
static int ett_ngap_NRFrequencyInfo;
static int ett_ngap_NRV2XServicesAuthorized;
static int ett_ngap_NRUESidelinkAggregateMaximumBitrate;
static int ett_ngap_NR_A2X_ServicesAuthorized;
static int ett_ngap_OverloadResponse;
static int ett_ngap_OverloadStartNSSAIList;
static int ett_ngap_OverloadStartNSSAIItem;
static int ett_ngap_PacketErrorRate;
static int ett_ngap_PagingAssisDataforCEcapabUE;
static int ett_ngap_PagingAttemptInformation;
static int ett_ngap_PagingPolicyDifferentiation;
static int ett_ngap_PDUSessionForPagingList;
static int ett_ngap_PDUSessionForPagingItem;
static int ett_ngap_PagingPolicyDifferentiationList;
static int ett_ngap_PagingPolicyDifferentiationItem;
static int ett_ngap_Partially_Allowed_NSSAI;
static int ett_ngap_PartiallyAllowedNSSAI_Item;
static int ett_ngap_PathSwitchRequestAcknowledgeTransfer;
static int ett_ngap_PathSwitchRequestSetupFailedTransfer;
static int ett_ngap_PathSwitchRequestTransfer;
static int ett_ngap_PathSwitchRequestUnsuccessfulTransfer;
static int ett_ngap_PC5QoSParameters;
static int ett_ngap_PC5QoSFlowList;
static int ett_ngap_PC5QoSFlowItem;
static int ett_ngap_PC5FlowBitRates;
static int ett_ngap_PCIListForMDT;
static int ett_ngap_PDUSessionAggregateMaximumBitRate;
static int ett_ngap_PDUSessionResourceAdmittedList;
static int ett_ngap_PDUSessionResourceAdmittedItem;
static int ett_ngap_PDUSessionResourceFailedToModifyListModCfm;
static int ett_ngap_PDUSessionResourceFailedToModifyItemModCfm;
static int ett_ngap_PDUSessionResourceFailedToModifyListModRes;
static int ett_ngap_PDUSessionResourceFailedToModifyItemModRes;
static int ett_ngap_PDUSessionResourceFailedToResumeListRESReq;
static int ett_ngap_PDUSessionResourceFailedToResumeItemRESReq;
static int ett_ngap_PDUSessionResourceFailedToResumeListRESRes;
static int ett_ngap_PDUSessionResourceFailedToResumeItemRESRes;
static int ett_ngap_PDUSessionResourceFailedToSetupListCxtFail;
static int ett_ngap_PDUSessionResourceFailedToSetupItemCxtFail;
static int ett_ngap_PDUSessionResourceFailedToSetupListCxtRes;
static int ett_ngap_PDUSessionResourceFailedToSetupItemCxtRes;
static int ett_ngap_PDUSessionResourceFailedToSetupListHOAck;
static int ett_ngap_PDUSessionResourceFailedToSetupItemHOAck;
static int ett_ngap_PDUSessionResourceFailedToSetupListPSReq;
static int ett_ngap_PDUSessionResourceFailedToSetupItemPSReq;
static int ett_ngap_PDUSessionResourceFailedToSetupListSURes;
static int ett_ngap_PDUSessionResourceFailedToSetupItemSURes;
static int ett_ngap_PDUSessionResourceHandoverList;
static int ett_ngap_PDUSessionResourceHandoverItem;
static int ett_ngap_PDUSessionResourceInformationList;
static int ett_ngap_PDUSessionResourceInformationItem;
static int ett_ngap_PDUSessionResourceListCxtRelCpl;
static int ett_ngap_PDUSessionResourceItemCxtRelCpl;
static int ett_ngap_PDUSessionResourceListCxtRelReq;
static int ett_ngap_PDUSessionResourceItemCxtRelReq;
static int ett_ngap_PDUSessionResourceListHORqd;
static int ett_ngap_PDUSessionResourceItemHORqd;
static int ett_ngap_PDUSessionListMTCommHReq;
static int ett_ngap_PDUSessionListMTCommHReq_Item;
static int ett_ngap_PDUSessionResourceModifyConfirmTransfer;
static int ett_ngap_PDUSessionResourceModifyIndicationUnsuccessfulTransfer;
static int ett_ngap_PDUSessionResourceModifyRequestTransfer;
static int ett_ngap_PDUSessionResourceModifyResponseTransfer;
static int ett_ngap_PDUSessionResourceModifyIndicationTransfer;
static int ett_ngap_PDUSessionResourceModifyListModCfm;
static int ett_ngap_PDUSessionResourceModifyItemModCfm;
static int ett_ngap_PDUSessionResourceModifyListModInd;
static int ett_ngap_PDUSessionResourceModifyItemModInd;
static int ett_ngap_PDUSessionResourceModifyListModReq;
static int ett_ngap_PDUSessionResourceModifyItemModReq;
static int ett_ngap_PDUSessionResourceModifyListModRes;
static int ett_ngap_PDUSessionResourceModifyItemModRes;
static int ett_ngap_PDUSessionResourceModifyUnsuccessfulTransfer;
static int ett_ngap_PDUSessionResourceNotifyList;
static int ett_ngap_PDUSessionResourceNotifyItem;
static int ett_ngap_PDUSessionResourceNotifyReleasedTransfer;
static int ett_ngap_PDUSessionResourceNotifyTransfer;
static int ett_ngap_PDUSessionResourceReleaseCommandTransfer;
static int ett_ngap_PDUSessionResourceReleasedListNot;
static int ett_ngap_PDUSessionResourceReleasedItemNot;
static int ett_ngap_PDUSessionResourceReleasedListPSAck;
static int ett_ngap_PDUSessionResourceReleasedItemPSAck;
static int ett_ngap_PDUSessionResourceReleasedListPSFail;
static int ett_ngap_PDUSessionResourceReleasedItemPSFail;
static int ett_ngap_PDUSessionResourceReleasedListRelRes;
static int ett_ngap_PDUSessionResourceReleasedItemRelRes;
static int ett_ngap_PDUSessionResourceReleaseResponseTransfer;
static int ett_ngap_PDUSessionResourceResumeListRESReq;
static int ett_ngap_PDUSessionResourceResumeItemRESReq;
static int ett_ngap_PDUSessionResourceResumeListRESRes;
static int ett_ngap_PDUSessionResourceResumeItemRESRes;
static int ett_ngap_PDUSessionResourceSecondaryRATUsageList;
static int ett_ngap_PDUSessionResourceSecondaryRATUsageItem;
static int ett_ngap_PDUSessionResourceSetupListCxtReq;
static int ett_ngap_PDUSessionResourceSetupItemCxtReq;
static int ett_ngap_PDUSessionResourceSetupListCxtRes;
static int ett_ngap_PDUSessionResourceSetupItemCxtRes;
static int ett_ngap_PDUSessionResourceSetupListHOReq;
static int ett_ngap_PDUSessionResourceSetupItemHOReq;
static int ett_ngap_PDUSessionResourceSetupListSUReq;
static int ett_ngap_PDUSessionResourceSetupItemSUReq;
static int ett_ngap_PDUSessionResourceSetupListSURes;
static int ett_ngap_PDUSessionResourceSetupItemSURes;
static int ett_ngap_PDUSessionResourceSetupRequestTransfer;
static int ett_ngap_PDUSessionResourceSetupResponseTransfer;
static int ett_ngap_PDUSessionResourceSetupUnsuccessfulTransfer;
static int ett_ngap_PDUSessionResourceSuspendListSUSReq;
static int ett_ngap_PDUSessionResourceSuspendItemSUSReq;
static int ett_ngap_PDUSessionResourceSwitchedList;
static int ett_ngap_PDUSessionResourceSwitchedItem;
static int ett_ngap_PDUSessionResourceToBeSwitchedDLList;
static int ett_ngap_PDUSessionResourceToBeSwitchedDLItem;
static int ett_ngap_PDUSessionResourceToReleaseListHOCmd;
static int ett_ngap_PDUSessionResourceToReleaseItemHOCmd;
static int ett_ngap_PDUSessionResourceToReleaseListRelCmd;
static int ett_ngap_PDUSessionResourceToReleaseItemRelCmd;
static int ett_ngap_PDUSessionUsageReport;
static int ett_ngap_PDUsetQoSParameters;
static int ett_ngap_PDUsetQoSInformation;
static int ett_ngap_PEIPSassistanceInformation;
static int ett_ngap_PeriodicityBound;
static int ett_ngap_AllowedPeriodicityList;
static int ett_ngap_PeriodicityRange;
static int ett_ngap_PLMNAreaBasedQMC;
static int ett_ngap_PLMNListforQMC;
static int ett_ngap_PLMNSupportList;
static int ett_ngap_PLMNSupportItem;
static int ett_ngap_PNI_NPN_MobilityInformation;
static int ett_ngap_PWSFailedCellIDList;
static int ett_ngap_PNI_NPN_AreaScopeofMDT;
static int ett_ngap_PNI_NPNBasedMDT;
static int ett_ngap_QMCConfigInfo;
static int ett_ngap_QMCDeactivation;
static int ett_ngap_QoEReferenceList;
static int ett_ngap_QoERVQoEReportingPaths;
static int ett_ngap_QosCharacteristics;
static int ett_ngap_QosFlowAcceptedList;
static int ett_ngap_QosFlowAcceptedItem;
static int ett_ngap_QosFlowAdditionalInfoListRelCom;
static int ett_ngap_QosFlowAdditionalInfoItemRelCom;
static int ett_ngap_QosFlowAdditionalInfoListRelRes;
static int ett_ngap_QosFlowAdditionalInfoItemRelRes;
static int ett_ngap_QosFlowAddOrModifyRequestList;
static int ett_ngap_QosFlowAddOrModifyRequestItem;
static int ett_ngap_QosFlowAddOrModifyResponseList;
static int ett_ngap_QosFlowAddOrModifyResponseItem;
static int ett_ngap_QosFlowFeedbackList;
static int ett_ngap_QosFlowFeedbackItem;
static int ett_ngap_QosFlowInformationList;
static int ett_ngap_QosFlowInformationItem;
static int ett_ngap_QosFlowLevelQosParameters;
static int ett_ngap_QosFlowListWithCause;
static int ett_ngap_QosFlowWithCauseItem;
static int ett_ngap_QosFlowModifyConfirmList;
static int ett_ngap_QosFlowModifyConfirmItem;
static int ett_ngap_QosFlowNotifyList;
static int ett_ngap_QosFlowNotifyItem;
static int ett_ngap_QosFlowParametersList;
static int ett_ngap_QosFlowParametersItem;
static int ett_ngap_QosFlowPerTNLInformation;
static int ett_ngap_QosFlowPerTNLInformationList;
static int ett_ngap_QosFlowPerTNLInformationItem;
static int ett_ngap_QosFlowSetupRequestList;
static int ett_ngap_QosFlowSetupRequestItem;
static int ett_ngap_QosFlowListWithDataForwarding;
static int ett_ngap_QosFlowItemWithDataForwarding;
static int ett_ngap_QosFlowToBeForwardedList;
static int ett_ngap_QosFlowToBeForwardedItem;
static int ett_ngap_QoSFlowTSCList;
static int ett_ngap_QoSFlowTSCItem;
static int ett_ngap_QoSFlowsUsageReportList;
static int ett_ngap_QoSFlowsUsageReport_Item;
static int ett_ngap_RANfeedbacktype;
static int ett_ngap_RANfeedbacktype_proactive;
static int ett_ngap_RANfeedbacktype_reactive;
static int ett_ngap_RANStatusTransfer_TransparentContainer;
static int ett_ngap_RANTimingSynchronisationStatusInfo;
static int ett_ngap_RAN_TSSScope;
static int ett_ngap_RANTSSCellList;
static int ett_ngap_RANTSSCellItem;
static int ett_ngap_RATRestrictions;
static int ett_ngap_RATRestrictions_Item;
static int ett_ngap_RecommendedCellsForPaging;
static int ett_ngap_RecommendedCellList;
static int ett_ngap_RecommendedCellItem;
static int ett_ngap_RecommendedRANNodesForPaging;
static int ett_ngap_RecommendedRANNodeList;
static int ett_ngap_RecommendedRANNodeItem;
static int ett_ngap_RedundantPDUSessionInformation;
static int ett_ngap_ResetType;
static int ett_ngap_RIMInformationTransfer;
static int ett_ngap_RIMInformation;
static int ett_ngap_RSPPQoSFlowList;
static int ett_ngap_RSPPQoSFlowItem;
static int ett_ngap_RSPPFlowBitRates;
static int ett_ngap_ScheduledCommunicationTime;
static int ett_ngap_SCTP_TLAs;
static int ett_ngap_SecondaryRATUsageInformation;
static int ett_ngap_SecondaryRATDataUsageReportTransfer;
static int ett_ngap_SecurityContext;
static int ett_ngap_SecurityIndication;
static int ett_ngap_SecurityResult;
static int ett_ngap_SensorMeasurementConfiguration;
static int ett_ngap_SensorMeasConfigNameList;
static int ett_ngap_SensorMeasConfigNameItem;
static int ett_ngap_SensorNameConfig;
static int ett_ngap_ServedGUAMIList;
static int ett_ngap_ServedGUAMIItem;
static int ett_ngap_ServiceAreaInformation;
static int ett_ngap_ServiceAreaInformation_Item;
static int ett_ngap_SharedNGU_MulticastTNLInformation;
static int ett_ngap_SliceOverloadList;
static int ett_ngap_SliceOverloadItem;
static int ett_ngap_SliceSupportList;
static int ett_ngap_SliceSupportItem;
static int ett_ngap_SliceSupportListQMC;
static int ett_ngap_SliceSupportQMC_Item;
static int ett_ngap_SNPN_MobilityInformation;
static int ett_ngap_S_NSSAI;
static int ett_ngap_SONConfigurationTransfer;
static int ett_ngap_SONInformation;
static int ett_ngap_SONInformationReply;
static int ett_ngap_SONInformationReport;
static int ett_ngap_SNPN_CellBasedMDT;
static int ett_ngap_SNPNCellIdListforMDT;
static int ett_ngap_SNPNCellIdListforMDTItem;
static int ett_ngap_SNPN_TAIBasedMDT;
static int ett_ngap_SNPNTAIListforMDT;
static int ett_ngap_SNPNTAIListforMDTItem;
static int ett_ngap_SNPN_BasedMDT;
static int ett_ngap_SNPNListforMDT;
static int ett_ngap_SNPNListforMDTItem;
static int ett_ngap_SuccessfulHandoverReportList;
static int ett_ngap_SuccessfulHandoverReport_Item;
static int ett_ngap_SuccessfulPSCellChangeReportList;
static int ett_ngap_SuccessfulPSCellChangeReport_Item;
static int ett_ngap_SourceNGRANNode_ToTargetNGRANNode_TransparentContainer;
static int ett_ngap_SourceNodeID;
static int ett_ngap_SourceRANNodeID;
static int ett_ngap_SourceToTarget_AMFInformationReroute;
static int ett_ngap_SupportedTAList;
static int ett_ngap_SupportedTAItem;
static int ett_ngap_SLPositioningRangingServiceInfo;
static int ett_ngap_SLPositioningRangingQoSParameters;
static int ett_ngap_TACListInNRNTN;
static int ett_ngap_TAI;
static int ett_ngap_TAIBroadcastEUTRA;
static int ett_ngap_TAIBroadcastEUTRA_Item;
static int ett_ngap_TAIBroadcastNR;
static int ett_ngap_TAIBroadcastNR_Item;
static int ett_ngap_TAICancelledEUTRA;
static int ett_ngap_TAICancelledEUTRA_Item;
static int ett_ngap_TAICancelledNR;
static int ett_ngap_TAICancelledNR_Item;
static int ett_ngap_TAIListForInactive;
static int ett_ngap_TAIListForInactiveItem;
static int ett_ngap_TAIListForPaging;
static int ett_ngap_TAIListForPagingItem;
static int ett_ngap_TAIListForRestart;
static int ett_ngap_TAIListForWarning;
static int ett_ngap_TAINSAGSupportList;
static int ett_ngap_TAINSAGSupportItem;
static int ett_ngap_TargeteNB_ID;
static int ett_ngap_TargetHomeENB_ID;
static int ett_ngap_TargetID;
static int ett_ngap_TargetNGRANNode_ToSourceNGRANNode_TransparentContainer;
static int ett_ngap_TargetNGRANNode_ToSourceNGRANNode_FailureTransparentContainer;
static int ett_ngap_TargetNSSAI;
static int ett_ngap_TargetNSSAI_Item;
static int ett_ngap_TargetNSSAIInformation;
static int ett_ngap_TargetRANNodeID;
static int ett_ngap_TargetRANNodeID_RIM;
static int ett_ngap_TargetRANNodeID_SON;
static int ett_ngap_TargetRNC_ID;
static int ett_ngap_TimeBasedHandoverInformation;
static int ett_ngap_TimeSyncAssistanceInfo;
static int ett_ngap_TNGF_ID;
static int ett_ngap_TNLAssociationList;
static int ett_ngap_TNLAssociationItem;
static int ett_ngap_TooearlyIntersystemHO;
static int ett_ngap_TraceActivation;
static int ett_ngap_TAIBasedMDT;
static int ett_ngap_TAIListforMDT;
static int ett_ngap_TAIBasedQMC;
static int ett_ngap_TAIListforQMC;
static int ett_ngap_TABasedQMC;
static int ett_ngap_TAListforQMC;
static int ett_ngap_TABasedMDT;
static int ett_ngap_TAListforMDT;
static int ett_ngap_TWIF_ID;
static int ett_ngap_TSCAssistanceInformation;
static int ett_ngap_TSCTrafficCharacteristics;
static int ett_ngap_TSCTrafficCharacteristicsFeedback;
static int ett_ngap_TSCFeedbackInformation;
static int ett_ngap_UEAggregateMaximumBitRate;
static int ett_ngap_UEAppLayerMeasInfoList;
static int ett_ngap_UEAppLayerMeasInfoItem;
static int ett_ngap_UEAppLayerMeasConfigInfo;
static int ett_ngap_UE_associatedLogicalNG_connectionList;
static int ett_ngap_UE_associatedLogicalNG_connectionItem;
static int ett_ngap_UEContextResumeRequestTransfer;
static int ett_ngap_UEContextResumeResponseTransfer;
static int ett_ngap_UEContextSuspendRequestTransfer;
static int ett_ngap_UE_DifferentiationInfo;
static int ett_ngap_UEHistoryInformation;
static int ett_ngap_UEHistoryInformationFromTheUE;
static int ett_ngap_UEIdentityIndexValue;
static int ett_ngap_UE_NGAP_IDs;
static int ett_ngap_UE_NGAP_ID_pair;
static int ett_ngap_UEPagingIdentity;
static int ett_ngap_UEPresenceInAreaOfInterestList;
static int ett_ngap_UEPresenceInAreaOfInterestItem;
static int ett_ngap_UERadioCapabilityForPaging;
static int ett_ngap_UERLFReportContainer;
static int ett_ngap_UESecurityCapabilities;
static int ett_ngap_UESliceMaximumBitRateList;
static int ett_ngap_UESliceMaximumBitRateItem;
static int ett_ngap_UL_CP_SecurityInformation;
static int ett_ngap_UL_NGU_UP_TNLModifyList;
static int ett_ngap_UL_NGU_UP_TNLModifyItem;
static int ett_ngap_UnavailableGUAMIList;
static int ett_ngap_UnavailableGUAMIItem;
static int ett_ngap_UPTransportLayerInformation;
static int ett_ngap_UPTransportLayerInformationList;
static int ett_ngap_UPTransportLayerInformationItem;
static int ett_ngap_UPTransportLayerInformationPairList;
static int ett_ngap_UPTransportLayerInformationPairItem;
static int ett_ngap_UserLocationInformation;
static int ett_ngap_UserLocationInformationEUTRA;
static int ett_ngap_UserLocationInformationN3IWF;
static int ett_ngap_UserLocationInformationTNGF;
static int ett_ngap_UserLocationInformationTWIF;
static int ett_ngap_UserLocationInformationW_AGF;
static int ett_ngap_UserLocationInformationNR;
static int ett_ngap_UserPlaneFailureIndication;
static int ett_ngap_UserPlaneSecurityInformation;
static int ett_ngap_VolumeTimedReportList;
static int ett_ngap_VolumeTimedReport_Item;
static int ett_ngap_W_AGF_ID;
static int ett_ngap_WarningAreaList;
static int ett_ngap_WLANMeasurementConfiguration;
static int ett_ngap_WLANMeasConfigNameList;
static int ett_ngap_WLANMeasConfigNameItem;
static int ett_ngap_WUS_Assistance_Information;
static int ett_ngap_XnExtTLAs;
static int ett_ngap_XnExtTLA_Item;
static int ett_ngap_XnGTP_TLAs;
static int ett_ngap_XnTLAs;
static int ett_ngap_XnTNLConfigurationInfo;
static int ett_ngap_PDUSessionResourceSetupRequest;
static int ett_ngap_PDUSessionResourceSetupResponse;
static int ett_ngap_PDUSessionResourceReleaseCommand;
static int ett_ngap_PDUSessionResourceReleaseResponse;
static int ett_ngap_PDUSessionResourceModifyRequest;
static int ett_ngap_PDUSessionResourceModifyResponse;
static int ett_ngap_PDUSessionResourceNotify;
static int ett_ngap_PDUSessionResourceModifyIndication;
static int ett_ngap_PDUSessionResourceModifyConfirm;
static int ett_ngap_InitialContextSetupRequest;
static int ett_ngap_InitialContextSetupResponse;
static int ett_ngap_InitialContextSetupFailure;
static int ett_ngap_UEContextReleaseRequest;
static int ett_ngap_UEContextReleaseCommand;
static int ett_ngap_UEContextReleaseComplete;
static int ett_ngap_UEContextResumeRequest;
static int ett_ngap_UEContextResumeResponse;
static int ett_ngap_UEContextResumeFailure;
static int ett_ngap_UEContextSuspendRequest;
static int ett_ngap_UEContextSuspendResponse;
static int ett_ngap_UEContextSuspendFailure;
static int ett_ngap_UEContextModificationRequest;
static int ett_ngap_UEContextModificationResponse;
static int ett_ngap_UEContextModificationFailure;
static int ett_ngap_RRCInactiveTransitionReport;
static int ett_ngap_RetrieveUEInformation;
static int ett_ngap_UEInformationTransfer;
static int ett_ngap_RANCPRelocationIndication;
static int ett_ngap_HandoverRequired;
static int ett_ngap_HandoverCommand;
static int ett_ngap_HandoverPreparationFailure;
static int ett_ngap_HandoverRequest;
static int ett_ngap_HandoverRequestAcknowledge;
static int ett_ngap_HandoverFailure;
static int ett_ngap_HandoverNotify;
static int ett_ngap_PathSwitchRequest;
static int ett_ngap_PathSwitchRequestAcknowledge;
static int ett_ngap_PathSwitchRequestFailure;
static int ett_ngap_HandoverCancel;
static int ett_ngap_HandoverCancelAcknowledge;
static int ett_ngap_HandoverSuccess;
static int ett_ngap_UplinkRANEarlyStatusTransfer;
static int ett_ngap_DownlinkRANEarlyStatusTransfer;
static int ett_ngap_UplinkRANStatusTransfer;
static int ett_ngap_DownlinkRANStatusTransfer;
static int ett_ngap_Paging;
static int ett_ngap_InitialUEMessage;
static int ett_ngap_DownlinkNASTransport;
static int ett_ngap_UplinkNASTransport;
static int ett_ngap_NASNonDeliveryIndication;
static int ett_ngap_RerouteNASRequest;
static int ett_ngap_NGSetupRequest;
static int ett_ngap_NGSetupResponse;
static int ett_ngap_NGSetupFailure;
static int ett_ngap_RANConfigurationUpdate;
static int ett_ngap_RANConfigurationUpdateAcknowledge;
static int ett_ngap_RANConfigurationUpdateFailure;
static int ett_ngap_AMFConfigurationUpdate;
static int ett_ngap_AMFConfigurationUpdateAcknowledge;
static int ett_ngap_AMFConfigurationUpdateFailure;
static int ett_ngap_AMFStatusIndication;
static int ett_ngap_NGReset;
static int ett_ngap_NGResetAcknowledge;
static int ett_ngap_ErrorIndication;
static int ett_ngap_OverloadStart;
static int ett_ngap_OverloadStop;
static int ett_ngap_UplinkRANConfigurationTransfer;
static int ett_ngap_DownlinkRANConfigurationTransfer;
static int ett_ngap_WriteReplaceWarningRequest;
static int ett_ngap_WriteReplaceWarningResponse;
static int ett_ngap_PWSCancelRequest;
static int ett_ngap_PWSCancelResponse;
static int ett_ngap_PWSRestartIndication;
static int ett_ngap_PWSFailureIndication;
static int ett_ngap_DownlinkUEAssociatedNRPPaTransport;
static int ett_ngap_UplinkUEAssociatedNRPPaTransport;
static int ett_ngap_DownlinkNonUEAssociatedNRPPaTransport;
static int ett_ngap_UplinkNonUEAssociatedNRPPaTransport;
static int ett_ngap_TraceStart;
static int ett_ngap_TraceFailureIndication;
static int ett_ngap_DeactivateTrace;
static int ett_ngap_CellTrafficTrace;
static int ett_ngap_LocationReportingControl;
static int ett_ngap_LocationReportingFailureIndication;
static int ett_ngap_LocationReport;
static int ett_ngap_UETNLABindingReleaseRequest;
static int ett_ngap_UERadioCapabilityInfoIndication;
static int ett_ngap_UERadioCapabilityCheckRequest;
static int ett_ngap_UERadioCapabilityCheckResponse;
static int ett_ngap_PrivateMessage;
static int ett_ngap_SecondaryRATDataUsageReport;
static int ett_ngap_UplinkRIMInformationTransfer;
static int ett_ngap_DownlinkRIMInformationTransfer;
static int ett_ngap_ConnectionEstablishmentIndication;
static int ett_ngap_UERadioCapabilityIDMappingRequest;
static int ett_ngap_UERadioCapabilityIDMappingResponse;
static int ett_ngap_AMFCPRelocationIndication;
static int ett_ngap_BroadcastSessionSetupRequest;
static int ett_ngap_BroadcastSessionSetupResponse;
static int ett_ngap_BroadcastSessionSetupFailure;
static int ett_ngap_BroadcastSessionModificationRequest;
static int ett_ngap_BroadcastSessionModificationResponse;
static int ett_ngap_BroadcastSessionModificationFailure;
static int ett_ngap_BroadcastSessionReleaseRequest;
static int ett_ngap_BroadcastSessionReleaseRequired;
static int ett_ngap_BroadcastSessionReleaseResponse;
static int ett_ngap_BroadcastSessionTransportRequest;
static int ett_ngap_BroadcastSessionTransportResponse;
static int ett_ngap_BroadcastSessionTransportFailure;
static int ett_ngap_DistributionSetupRequest;
static int ett_ngap_DistributionSetupResponse;
static int ett_ngap_DistributionSetupFailure;
static int ett_ngap_DistributionReleaseRequest;
static int ett_ngap_DistributionReleaseResponse;
static int ett_ngap_MulticastSessionActivationRequest;
static int ett_ngap_MulticastSessionActivationResponse;
static int ett_ngap_MulticastSessionActivationFailure;
static int ett_ngap_MulticastSessionDeactivationRequest;
static int ett_ngap_MulticastSessionDeactivationResponse;
static int ett_ngap_MulticastSessionUpdateRequest;
static int ett_ngap_MulticastSessionUpdateResponse;
static int ett_ngap_MulticastSessionUpdateFailure;
static int ett_ngap_MulticastGroupPaging;
static int ett_ngap_TimingSynchronisationStatusRequest;
static int ett_ngap_TimingSynchronisationStatusResponse;
static int ett_ngap_TimingSynchronisationStatusFailure;
static int ett_ngap_TimingSynchronisationStatusReport;
static int ett_ngap_MTCommunicationHandlingRequest;
static int ett_ngap_MTCommunicationHandlingResponse;
static int ett_ngap_MTCommunicationHandlingFailure;
static int ett_ngap_RANPagingRequest;
static int ett_ngap_NGAP_PDU;
static int ett_ngap_InitiatingMessage;
static int ett_ngap_SuccessfulOutcome;
static int ett_ngap_UnsuccessfulOutcome;

static expert_field ei_ngap_number_pages_le15;

enum{
  INITIATING_MESSAGE,
  SUCCESSFUL_OUTCOME,
  UNSUCCESSFUL_OUTCOME
};

/* NGAP stats - Tap interface */

static void set_stats_message_type(packet_info *pinfo, int type);

static const uint8_t *st_str_packets        = "Total Packets";
static const uint8_t *st_str_packet_types   = "NGAP Packet Types";

static int st_node_packets = -1;
static int st_node_packet_types = -1;
static int ngap_tap;

struct ngap_tap_t {
    int ngap_mtype;
};

#define MTYPE_AMF_CONFIGURATION_UPDATE                    1
#define MTYPE_AMF_CONFIGURATION_UPDATE_ACK                2
#define MTYPE_AMF_CONFIGURATION_UPDATE_FAILURE            3
#define MTYPE_AMF_CP_RELOCATION_IND                       4
#define MTYPE_AMF_STATUS_IND                              5
#define MTYPE_BROADCAST_SESSION_MODIFICATION_REQUEST      6
#define MTYPE_BROADCAST_SESSION_MODIFICATION_RESPONSE     7
#define MTYPE_BROADCAST_SESSION_MODIFICATION_FAILURE      8
#define MTYPE_BROADCAST_SESSION_RELEASE_REQUEST           9
#define MTYPE_BROADCAST_SESSION_RELEASE_RESPONSE          10
#define MTYPE_BROADCAST_SESSION_RELEASE_REQUIRED          11
#define MTYPE_BROADCAST_SESSION_SETUP_REQUEST             12
#define MTYPE_BROADCAST_SESSION_SETUP_RESPONSE            13
#define MTYPE_BROADCAST_SESSION_SETUP_FAILURE             14
#define MTYPE_BROADCAST_SESSION_TRANSPORT_REQUEST         15
#define MTYPE_BROADCAST_SESSION_TRANSPORT_RESPONSE        16
#define MTYPE_BROADCAST_SESSION_TRANSPORT_FAILURE         17
#define MTYPE_CELL_TRAFFIC_TRACE                          18
#define MTYPE_CONNECTION_ESTAB_IND                        19
#define MTYPE_DEACTIVATE_TRACE                            20
#define MTYPE_DISTRIBUTION_SETUP_REQUEST                  21
#define MTYPE_DISTRIBUTION_SETUP_RESPONSE                 22
#define MTYPE_DISTRIBUTION_SETUP_FAILURE                  23
#define MTYPE_DISTRIBUTION_RELEASE_REQUEST                24
#define MTYPE_DISTRIBUTION_RELEASE_RESPONSE               25
#define MTYPE_DOWNLINK_NAS_TRANSPORT                      26
#define MTYPE_DOWNLINK_NON_UE_ASSOCIATED_NR_PPA_TRANSPORT 27
#define MTYPE_DOWNLINK_RAN_CONFIGURATION_TRANSFER         28
#define MTYPE_DOWNLINK_RAN_EARLY_STATUS_TRANSFER          29
#define MTYPE_DOWNLINK_RAN_STATUS_TRANSFER                30
#define MTYPE_DOWNLINK_UE_ASSOCIATED_NR_PPA_TRANSPORT     31
#define MTYPE_ERROR_INDICATION                            32
#define MTYPE_HANDOVER_CANCEL                             33
#define MTYPE_HANDOVER_CANCEL_ACK                         34
#define MTYPE_HANDOVER_NOTIFY                             35
#define MTYPE_HANDOVER_REQUIRED                           36
#define MTYPE_HANDOVER_COMMAND                            37
#define MTYPE_HANDOVER_PREPARATION_FAILURE                38
#define MTYPE_HANDOVER_REQUEST                            39
#define MTYPE_HANDOVER_REQUEST_ACK                        40
#define MTYPE_HANDOVER_FAILURE                            41
#define MTYPE_HANDOVER_SUCCESS                            42
#define MTYPE_INITIAL_CONTEXT_SETUP_REQUEST               43
#define MTYPE_INITIAL_CONTEXT_SETUP_RESPONSE              44
#define MTYPE_INITIAL_CONTEXT_SETUP_FAILURE               45
#define MTYPE_INITIAL_UE_MESSAGE                          46
#define MTYPE_LOCATION_REPORT                             47
#define MTYPE_LOCATION_REPORTING_CONTROL                  48
#define MTYPE_LOCATION_REPORTING_FAILURE_IND              49
#define MTYPE_MT_COMMUNICATION_HANDLING_REQUEST           50
#define MTYPE_MT_COMMUNICATION_HANDLING_RESPONSE          51
#define MTYPE_MT_COMMUNICATION_HANDLING_FAILURE           52
#define MTYPE_MULTICAST_SESSION_ACTIVATION_REQUEST        53
#define MTYPE_MULTICAST_SESSION_ACTIVATION_RESPONSE       54
#define MTYPE_MULTICAST_SESSION_ACTIVATION_FAILURE        55
#define MTYPE_MULTICAST_SESSION_DEACTIVATION_REQUEST      56
#define MTYPE_MULTICAST_SESSION_DEACTIVATION_RESPONSE     57
#define MTYPE_MULTICAST_SESSION_UPDATE_REQUEST            58
#define MTYPE_MULTICAST_SESSION_UPDATE_RESPONSE           59
#define MTYPE_MULTICAST_SESSION_UPDATE_FAILURE            60
#define MTYPE_MULTICAST_GROUP_PAGING                      61
#define MTYPE_NAS_NON_DELIVERY_IND                        62
#define MTYPE_NG_RESET                                    63
#define MTYPE_NG_RESET_ACK                                64
#define MTYPE_NG_SETUP_REQUEST                            65
#define MTYPE_NG_SETUP_RESPONSE                           66
#define MTYPE_NG_SETUP_FAILURE                            67
#define MTYPE_OVERLOAD_START                              68
#define MTYPE_OVERLOAD_STOP                               69
#define MTYPE_PAGING                                      70
#define MTYPE_PATH_SWITCH_REQUEST                         71
#define MTYPE_PATH_SWITCH_REQUEST_ACK                     72
#define MTYPE_PATH_SWITCH_REQUEST_FAILURE                 73
#define MTYPE_PDU_SESSION_RESOURCE_MODIFY_REQUEST         74
#define MTYPE_PDU_SESSION_RESOURCE_MODIFY_RESPONSE        75
#define MTYPE_PDU_SESSION_RESOURCE_MODIFY_IND             76
#define MTYPE_PDU_SESSION_RESOURCE_MODIFY_CONFIRM         77
#define MTYPE_PDU_SESSION_RESOURCE_NOTIFY                 78
#define MTYPE_PDU_SESSION_RESOURCE_RELEASE_COMMAND        79
#define MTYPE_PDU_SESSION_RESOURCE_RELEASE_RESPONSE       80
#define MTYPE_PDU_SESSION_RESOURCE_SETUP_REQUEST          81
#define MTYPE_PDU_SESSION_RESOURCE_SETUP_RESPONSE         82
#define MTYPE_PRIVATE_MESSAGE                             83
#define MTYPE_PWS_CANCEL_REQUEST                          84
#define MTYPE_PWS_CANCEL_RESPONSE                         85
#define MTYPE_PWS_FAILURE_INDICATION                      86
#define MTYPE_PWS_RESTART_INDICATION                      87
#define MTYPE_RAN_CONFIGURATION_UPDATE                    88
#define MTYPE_RAN_CONFIGURATION_UPDATE_ACK                89
#define MTYPE_RAN_CONFIGURATION_UPDATE_FAILURE            90
#define MTYPE_RAN_CP_RELOCATION_IND                       91
#define MTYPE_RAN_PAGING_REQUEST                          92
#define MTYPE_REROUTE_NAS_REQUEST                         93
#define MTYPE_RETRIEVE_UE_INFORMATION                     94
#define MTYPE_RRC_INACTIVE_TRANSITION_REPORT              95
#define MTYPE_SECONDARY_RAT_DATA_USAGE_REPORT             96
#define MTYPE_TIMING_SYNCHRONISATION_STATUS_REQUEST       97
#define MTYPE_TIMING_SYNCHRONISATION_STATUS_RESPONSE      98
#define MTYPE_TIMING_SYNCHRONISATION_STATUS_FAILURE       99
#define MTYPE_TIMING_SYNCHRONISATION_STATUS_REPORT        100
#define MTYPE_TRACE_FAILURE_IND                           101
#define MTYPE_TRACE_START                                 102
#define MTYPE_UE_CONTEXT_MODIFICATION_REQUEST             103
#define MTYPE_UE_CONTEXT_MODIFICATION_RESPONSE            104
#define MTYPE_UE_CONTEXT_MODIFICATION_FAILURE             105
#define MTYPE_UE_CONTEXT_RELEASE_COMMAND                  106
#define MTYPE_UE_CONTEXT_RELEASE_COMPLETE                 107
#define MTYPE_UE_CONTEXT_RELEASE_REQUEST                  108
#define MTYPE_UE_CONTEXT_RESUME_REQUEST                   109
#define MTYPE_UE_CONTEXT_RESUME_RESPONSE                  110
#define MTYPE_UE_CONTEXT_RESUME_FAILURE                   111
#define MTYPE_UE_CONTEXT_SUSPEND_REQUEST                  112
#define MTYPE_UE_CONTEXT_SUSPEND_RESPONSE                 113
#define MTYPE_UE_CONTEXT_SUSPEND_FAILURE                  114
#define MTYPE_UE_INFORMATION_TRANSFER                     115
#define MTYPE_UE_RADIO_CAPABILITY_CHECK_REQUEST           116
#define MTYPE_UE_RADIO_CAPABILITY_CHECK_RESPONSE          117
#define MTYPE_UE_RADIO_CAPABILITY_ID_MAPPING_REQUEST      118
#define MTYPE_UE_RADIO_CAPABILITY_ID_MAPPING_RESPONSE     119
#define MTYPE_UE_RADIO_CAPABILITY_INFO_IND                120
#define MTYPE_UE_TN_LAB_BINDING_RELEASE_REQUEST           121
#define MTYPE_UPLINK_NAS_TRANSPORT                        122
#define MTYPE_UPLINK_NON_UE_ASSOCIATED_NR_PPA_TRANSPORT   123
#define MTYPE_UPLINK_RAN_CONFIGURATION_TRANSFER           124
#define MTYPE_UPLINK_RAN_EARLY_STATUS_TRANSFER            125
#define MTYPE_UPLINK_RAN_STATUS_TRANSFER                  126
#define MTYPE_UPLINK_UE_ASSOCIATED_NR_PPA_TRANSPORT       127
#define MTYPE_WRITE_REPLACE_WARNING_REQUEST               128
#define MTYPE_WRITE_REPLACE_WARNING_RESPONSE              129
#define MTYPE_UPLINK_RIM_INFORMATION_TRANSFER             130
#define MTYPE_DOWNLINK_RIM_INFORMATION_TRANSFER           131


/* Value Strings. TODO: ext? */
static const value_string mtype_names[] = {
    { MTYPE_AMF_CONFIGURATION_UPDATE,                    "AMFConfigurationUpdate" },
    { MTYPE_AMF_CONFIGURATION_UPDATE_ACK,                "AMFConfigurationUpdateAcknowledge" },
    { MTYPE_AMF_CONFIGURATION_UPDATE_FAILURE,            "AMFConfigurationUpdateFailure" },
    { MTYPE_AMF_CP_RELOCATION_IND,                       "AMFCPRelocationIndication" },
    { MTYPE_AMF_STATUS_IND,                              "AMFStatusIndication" },
    { MTYPE_BROADCAST_SESSION_MODIFICATION_REQUEST,      "BroadcastSessionModificationRequest" },
    { MTYPE_BROADCAST_SESSION_MODIFICATION_RESPONSE,     "BroadcastSessionModificationResponse" },
    { MTYPE_BROADCAST_SESSION_MODIFICATION_FAILURE,      "BroadcastSessionModificationFailure" },
    { MTYPE_BROADCAST_SESSION_RELEASE_REQUEST,           "BroadcastSessionReleaseRequest" },
    { MTYPE_BROADCAST_SESSION_RELEASE_RESPONSE,          "BroadcastSessionReleaseResponse" },
    { MTYPE_BROADCAST_SESSION_RELEASE_REQUIRED,          "BroadcastSessionReleaseRequired" },
    { MTYPE_BROADCAST_SESSION_SETUP_REQUEST,             "BroadcastSessionSetupRequest" },
    { MTYPE_BROADCAST_SESSION_SETUP_RESPONSE,            "BroadcastSessionSetupResponse" },
    { MTYPE_BROADCAST_SESSION_SETUP_FAILURE,             "BroadcastSessionSetupFailure" },
    { MTYPE_BROADCAST_SESSION_TRANSPORT_REQUEST,         "BroadcastSessionTransportRequest" },
    { MTYPE_BROADCAST_SESSION_TRANSPORT_RESPONSE,        "BroadcastSessionTransportResponse" },
    { MTYPE_BROADCAST_SESSION_TRANSPORT_FAILURE,         "BroadcastSessionTransportFailure" },
    { MTYPE_CELL_TRAFFIC_TRACE,                          "CellTrafficTrace" },
    { MTYPE_CONNECTION_ESTAB_IND,                        "ConnectionEstablishmentIndication" },
    { MTYPE_DEACTIVATE_TRACE,                            "DeactivateTrace" },
    { MTYPE_DISTRIBUTION_SETUP_REQUEST,                  "DistributionSetupRequest" },
    { MTYPE_DISTRIBUTION_SETUP_RESPONSE,                 "DistributionSetupResponse" },
    { MTYPE_DISTRIBUTION_SETUP_FAILURE,                  "DistributionSetupFailure" },
    { MTYPE_DISTRIBUTION_RELEASE_REQUEST,                "DistributionReleaseRequest" },
    { MTYPE_DISTRIBUTION_RELEASE_RESPONSE,               "DistributionReleaseResponse" },
    { MTYPE_DOWNLINK_NAS_TRANSPORT,                      "DownlinkNASTransport" },
    { MTYPE_DOWNLINK_NON_UE_ASSOCIATED_NR_PPA_TRANSPORT, "DownlinkNonUEAssociatedNRPPaTransport" },
    { MTYPE_DOWNLINK_RAN_CONFIGURATION_TRANSFER,         "DownlinkRANConfigurationTransfer" },
    { MTYPE_DOWNLINK_RAN_EARLY_STATUS_TRANSFER,          "DownlinkRANEarlyStatusTransfer" },
    { MTYPE_DOWNLINK_RAN_STATUS_TRANSFER,                "DownlinkRANStatusTransfer" },
    { MTYPE_DOWNLINK_UE_ASSOCIATED_NR_PPA_TRANSPORT,     "DownlinkUEAssociatedNRPPaTransport" },
    { MTYPE_ERROR_INDICATION,                            "ErrorIndication" },
    { MTYPE_HANDOVER_CANCEL,                             "HandoverCancel" },
    { MTYPE_HANDOVER_CANCEL_ACK,                         "HandoverCancelAcknowledge" },
    { MTYPE_HANDOVER_NOTIFY,                             "HandoverNotify" },
    { MTYPE_HANDOVER_REQUIRED,                           "HandoverRequired" },
    { MTYPE_HANDOVER_COMMAND,                            "HandoverCommand" },
    { MTYPE_HANDOVER_PREPARATION_FAILURE,                "HandoverPreparationFailure" },
    { MTYPE_HANDOVER_REQUEST,                            "HandoverRequest" },
    { MTYPE_HANDOVER_REQUEST_ACK,                        "HandoverRequestAcknowledge" },
    { MTYPE_HANDOVER_FAILURE,                            "HandoverFailure" },
    { MTYPE_HANDOVER_SUCCESS,                            "HandoverSuccess" },
    { MTYPE_INITIAL_CONTEXT_SETUP_REQUEST,               "InitialContextSetupRequest" },
    { MTYPE_INITIAL_CONTEXT_SETUP_RESPONSE,              "InitialContextSetupResponse" },
    { MTYPE_INITIAL_CONTEXT_SETUP_FAILURE,               "InitialContextSetupFailure" },
    { MTYPE_INITIAL_UE_MESSAGE,                          "InitialUEMessage" },
    { MTYPE_LOCATION_REPORT,                             "LocationReport" },
    { MTYPE_LOCATION_REPORTING_CONTROL,                  "LocationReportingControl" },
    { MTYPE_LOCATION_REPORTING_FAILURE_IND,              "LocationReportingFailureIndication" },
    { MTYPE_MT_COMMUNICATION_HANDLING_REQUEST,           "MTCommunicationHandlingRequest" },
    { MTYPE_MT_COMMUNICATION_HANDLING_RESPONSE,          "MTCommunicationHandlingResponse" },
    { MTYPE_MT_COMMUNICATION_HANDLING_FAILURE,           "MTCommunicationHandlingFailure" },
    { MTYPE_MULTICAST_SESSION_ACTIVATION_REQUEST,        "MulticastSessionActivationRequest" },
    { MTYPE_MULTICAST_SESSION_ACTIVATION_RESPONSE,       "MulticastSessionActivationResponse" },
    { MTYPE_MULTICAST_SESSION_ACTIVATION_FAILURE,        "MulticastSessionActivationFailure" },
    { MTYPE_MULTICAST_SESSION_DEACTIVATION_REQUEST,      "MulticastSessionDeactivationRequest" },
    { MTYPE_MULTICAST_SESSION_DEACTIVATION_RESPONSE,     "MulticastSessionDeactivationResponse" },
    { MTYPE_MULTICAST_SESSION_UPDATE_REQUEST,            "MulticastSessionUpdateRequest" },
    { MTYPE_MULTICAST_SESSION_UPDATE_RESPONSE,           "MulticastSessionUpdateResponse" },
    { MTYPE_MULTICAST_SESSION_UPDATE_FAILURE,            "MulticastSessionUpdateFailure" },
    { MTYPE_MULTICAST_GROUP_PAGING,                      "MulticastGroupPaging" },
    { MTYPE_NAS_NON_DELIVERY_IND,                        "NASNonDeliveryIndication" },
    { MTYPE_NG_RESET,                                    "NGReset" },
    { MTYPE_NG_RESET_ACK,                                "NGResetAcknowledge" },
    { MTYPE_NG_SETUP_REQUEST,                            "NGSetupRequest" },
    { MTYPE_NG_SETUP_RESPONSE,                           "NGSetupResponse" },
    { MTYPE_NG_SETUP_FAILURE,                            "NGSetupFailure" },
    { MTYPE_OVERLOAD_START,                              "OverloadStart" },
    { MTYPE_OVERLOAD_STOP,                               "OverloadStop" },
    { MTYPE_PAGING,                                      "Paging" },
    { MTYPE_PATH_SWITCH_REQUEST,                         "PathSwitchRequest" },
    { MTYPE_PATH_SWITCH_REQUEST_ACK,                     "PathSwitchRequestAcknowledge" },
    { MTYPE_PATH_SWITCH_REQUEST_FAILURE,                 "PathSwitchRequestFailure" },
    { MTYPE_PDU_SESSION_RESOURCE_MODIFY_REQUEST,         "PDUSessionResourceModifyRequest" },
    { MTYPE_PDU_SESSION_RESOURCE_MODIFY_RESPONSE,        "PDUSessionResourceModifyResponse" },
    { MTYPE_PDU_SESSION_RESOURCE_MODIFY_IND,             "PDUSessionResourceModifyIndication" },
    { MTYPE_PDU_SESSION_RESOURCE_MODIFY_CONFIRM,         "PDUSessionResourceModifyConfirm" },
    { MTYPE_PDU_SESSION_RESOURCE_NOTIFY,                 "PDUSessionResourceNotify" },
    { MTYPE_PDU_SESSION_RESOURCE_RELEASE_COMMAND,        "PDUSessionResourceReleaseCommand" },
    { MTYPE_PDU_SESSION_RESOURCE_RELEASE_RESPONSE,       "PDUSessionResourceReleaseResponse" },
    { MTYPE_PDU_SESSION_RESOURCE_SETUP_REQUEST,          "PDUSessionResourceSetupRequest" },
    { MTYPE_PDU_SESSION_RESOURCE_SETUP_RESPONSE,         "PDUSessionResourceSetupResponse" },
    { MTYPE_PRIVATE_MESSAGE,                             "PrivateMessage" },
    { MTYPE_PWS_CANCEL_REQUEST,                          "PWSCancelRequest" },
    { MTYPE_PWS_CANCEL_RESPONSE,                         "PWSCancelResponse" },
    { MTYPE_PWS_FAILURE_INDICATION,                      "PWSFailureIndication" },
    { MTYPE_PWS_RESTART_INDICATION,                      "PWSRestartIndication" },
    { MTYPE_RAN_CONFIGURATION_UPDATE,                    "RANConfigurationUpdate" },
    { MTYPE_RAN_CONFIGURATION_UPDATE_ACK,                "RANConfigurationUpdateAcknowledge" },
    { MTYPE_RAN_CONFIGURATION_UPDATE_FAILURE,            "RANConfigurationUpdateFailure" },
    { MTYPE_RAN_CP_RELOCATION_IND,                       "RANCPRelocationIndication" },
    { MTYPE_RAN_PAGING_REQUEST,                          "RANPagingRequest" },
    { MTYPE_REROUTE_NAS_REQUEST,                         "RerouteNASRequest" },
    { MTYPE_RETRIEVE_UE_INFORMATION,                     "RetrieveUEInformation" },
    { MTYPE_RRC_INACTIVE_TRANSITION_REPORT,              "RRCInactiveTransitionReport" },
    { MTYPE_SECONDARY_RAT_DATA_USAGE_REPORT,             "SecondaryRATDataUsageReport" },
    { MTYPE_TIMING_SYNCHRONISATION_STATUS_REQUEST,       "TimingSynchronisationStatusRequest" },
    { MTYPE_TIMING_SYNCHRONISATION_STATUS_RESPONSE,      "TimingSynchronisationStatusResponse" },
    { MTYPE_TIMING_SYNCHRONISATION_STATUS_FAILURE,       "TimingSynchronisationStatusFailure" },
    { MTYPE_TIMING_SYNCHRONISATION_STATUS_REPORT,        "TimingSynchronisationStatusReport" },
    { MTYPE_TRACE_FAILURE_IND,                           "TraceFailureIndication" },
    { MTYPE_TRACE_START,                                 "TraceStart" },
    { MTYPE_UE_CONTEXT_MODIFICATION_REQUEST,             "UEContextModificationRequest" },
    { MTYPE_UE_CONTEXT_MODIFICATION_RESPONSE,            "UEContextModificationResponse" },
    { MTYPE_UE_CONTEXT_MODIFICATION_FAILURE,             "UEContextModificationFailure" },
    { MTYPE_UE_CONTEXT_RELEASE_COMMAND,                  "UEContextReleaseCommand" },
    { MTYPE_UE_CONTEXT_RELEASE_COMPLETE,                 "UEContextReleaseComplete" },
    { MTYPE_UE_CONTEXT_RELEASE_REQUEST,                  "UEContextReleaseRequest" },
    { MTYPE_UE_CONTEXT_RESUME_REQUEST,                   "UEContextResumeRequest" },
    { MTYPE_UE_CONTEXT_RESUME_RESPONSE,                  "UEContextResumeResponse" },
    { MTYPE_UE_CONTEXT_RESUME_FAILURE,                   "UEContextResumeFailure" },
    { MTYPE_UE_CONTEXT_SUSPEND_REQUEST,                  "UEContextSuspendRequest" },
    { MTYPE_UE_CONTEXT_SUSPEND_RESPONSE,                 "UEContextSuspendResponse" },
    { MTYPE_UE_CONTEXT_SUSPEND_FAILURE,                  "UEContextSuspendFailure" },
    { MTYPE_UE_INFORMATION_TRANSFER,                     "UEInformationTransfer" },
    { MTYPE_UE_RADIO_CAPABILITY_CHECK_REQUEST,           "UERadioCapabilityCheckRequest" },
    { MTYPE_UE_RADIO_CAPABILITY_CHECK_RESPONSE,          "UERadioCapabilityCheckResponse" },
    { MTYPE_UE_RADIO_CAPABILITY_ID_MAPPING_REQUEST,      "UERadioCapabilityIDMappingRequest" },
    { MTYPE_UE_RADIO_CAPABILITY_ID_MAPPING_RESPONSE,     "UERadioCapabilityIDMappingResponse" },
    { MTYPE_UE_RADIO_CAPABILITY_INFO_IND,                "UERadioCapabilityInfoIndication" },
    { MTYPE_UE_TN_LAB_BINDING_RELEASE_REQUEST,           "UETNLABindingReleaseRequest" },
    { MTYPE_UPLINK_NAS_TRANSPORT,                        "UplinkNASTransport" },
    { MTYPE_UPLINK_NON_UE_ASSOCIATED_NR_PPA_TRANSPORT,   "UplinkNonUEAssociatedNRPPaTransport" },
    { MTYPE_UPLINK_RAN_CONFIGURATION_TRANSFER,           "UplinkRANConfigurationTransfer" },
    { MTYPE_UPLINK_RAN_EARLY_STATUS_TRANSFER,            "UplinkRANEarlyStatusTransfer" },
    { MTYPE_UPLINK_RAN_STATUS_TRANSFER,                  "UplinkRANStatusTransfer" },
    { MTYPE_UPLINK_UE_ASSOCIATED_NR_PPA_TRANSPORT,       "UplinkUEAssociatedNRPPaTransport" },
    { MTYPE_WRITE_REPLACE_WARNING_REQUEST,               "WriteReplaceWarningRequest" },
    { MTYPE_WRITE_REPLACE_WARNING_RESPONSE,              "WriteReplaceWarningResponse" },
    { MTYPE_UPLINK_RIM_INFORMATION_TRANSFER,             "UplinkRIMInformationTransfer" },
    { MTYPE_DOWNLINK_RIM_INFORMATION_TRANSFER,           "DownlinkRIMInformationTransfer" },
    { 0,  NULL }
};


typedef struct _ngap_ctx_t {
    uint32_t message_type;
    uint32_t ProcedureCode;
    uint32_t ProtocolIE_ID;
    uint32_t ProtocolExtensionID;
} ngap_ctx_t;

struct ngap_conv_info {
  address addr_a;
  uint32_t port_a;
  GlobalRANNodeID_enum ranmode_id_a;
  address addr_b;
  uint32_t port_b;
  GlobalRANNodeID_enum ranmode_id_b;
  wmem_map_t *nbiot_ta;
  wmem_tree_t *nbiot_ran_ue_ngap_id;
};

enum {
  SOURCE_TO_TARGET_TRANSPARENT_CONTAINER = 1,
  TARGET_TO_SOURCE_TRANSPARENT_CONTAINER
};

struct ngap_supported_ta {
  uint32_t tac;
  wmem_array_t *plmn;
};

struct ngap_tai {
  uint32_t plmn;
  uint32_t tac;
};

struct ngap_private_data {
  struct ngap_conv_info *ngap_conv;
  uint32_t procedure_code;
  uint32_t protocol_ie_id;
  uint32_t protocol_extension_id;
  uint32_t message_type;
  uint32_t handover_type_value;
  uint8_t data_coding_scheme;
  uint8_t transparent_container_type;
  bool is_qos_flow_notify;
  struct ngap_supported_ta *supported_ta;
  struct ngap_tai *tai;
  uint32_t ran_ue_ngap_id;
  e212_number_type_t number_type;
  int8_t qos_flow_add_info_rel_type;
  struct ngap_tap_t *stats_tap;
};

enum {
  NGAP_NG_RAN_CONTAINER_AUTOMATIC,
  NGAP_NG_RAN_CONTAINER_GNB,
  NGAP_NG_RAN_CONTAINER_NG_ENB
};

static const enum_val_t ngap_target_ng_ran_container_vals[] = {
  {"automatic", "automatic", NGAP_NG_RAN_CONTAINER_AUTOMATIC},
  {"gnb", "gNB", NGAP_NG_RAN_CONTAINER_GNB},
  {"ng-enb","ng-eNB", NGAP_NG_RAN_CONTAINER_NG_ENB},
  {NULL, NULL, -1}
};

enum {
  NGAP_LTE_CONTAINER_AUTOMATIC,
  NGAP_LTE_CONTAINER_LEGACY,
  NGAP_LTE_CONTAINER_NBIOT
};

static const enum_val_t ngap_lte_container_vals[] = {
  {"automatic", "Automatic", NGAP_LTE_CONTAINER_AUTOMATIC},
  {"legacy", "Legacy LTE", NGAP_LTE_CONTAINER_LEGACY},
  {"nb-iot","NB-IoT", NGAP_LTE_CONTAINER_NBIOT},
  {NULL, NULL, -1}
};

/* Global variables */
static range_t *gbl_ngapSctpRange;
static bool ngap_dissect_container = true;
static int ngap_dissect_target_ng_ran_container_as = NGAP_NG_RAN_CONTAINER_AUTOMATIC;
static int ngap_dissect_lte_container_as = NGAP_LTE_CONTAINER_AUTOMATIC;

/* Dissector tables */
static dissector_table_t ngap_ies_dissector_table;
static dissector_table_t ngap_ies_p1_dissector_table;
static dissector_table_t ngap_ies_p2_dissector_table;
static dissector_table_t ngap_extension_dissector_table;
static dissector_table_t ngap_proc_imsg_dissector_table;
static dissector_table_t ngap_proc_sout_dissector_table;
static dissector_table_t ngap_proc_uout_dissector_table;
static dissector_table_t ngap_n2_ie_type_dissector_table;

static proto_tree *top_tree;

static void set_message_label(asn1_ctx_t *actx, int type)
{
  const char *label = val_to_str_const(type, mtype_names, "Unknown");
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, label);
  /* N.B. would like to be able to use actx->subTree.top_tree, but not easy to set.. */
  proto_item_append_text(top_tree, " (%s)", label);
}


static int dissect_ProtocolIEFieldValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
/* Currently not used
static int dissect_ProtocolIEFieldPairFirstValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree);
static int dissect_ProtocolIEFieldPairSecondValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree);
*/
static int dissect_ProtocolExtensionFieldExtensionValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_InitiatingMessageValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_UnsuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);

static int dissect_InitialUEMessage_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data);
static int dissect_PDUSessionResourceReleaseResponseTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_HandoverRequestAcknowledgeTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PDUSessionResourceModifyUnsuccessfulTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PDUSessionResourceSetupUnsuccessfulTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_HandoverResourceAllocationUnsuccessfulTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PathSwitchRequestSetupFailedTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_HandoverCommandTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_HandoverRequiredTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PDUSessionResourceModifyConfirmTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PDUSessionResourceModifyIndicationTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PDUSessionResourceModifyRequestTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PDUSessionResourceModifyResponseTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PDUSessionResourceNotifyTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PDUSessionResourceNotifyReleasedTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PathSwitchRequestUnsuccessfulTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PDUSessionResourceSetupRequestTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PDUSessionResourceSetupResponseTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PathSwitchRequestAcknowledgeTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PathSwitchRequestTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_HandoverPreparationUnsuccessfulTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PDUSessionResourceReleaseCommandTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_TargetNGRANNode_ToSourceNGRANNode_FailureTransparentContainer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SecondaryRATDataUsageReportTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_PDUSessionResourceModifyIndicationUnsuccessfulTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_ngap_AlternativeQoSParaSetNotifyIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_);
static int dissect_UEContextResumeRequestTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UEContextResumeResponseTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UEContextSuspendRequestTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_MBSSessionSetupOrModRequestTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_MBSSessionSetupOrModResponseTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_MBSSessionSetupOrModFailureTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_MBSSessionReleaseResponseTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);

static const value_string ngap_serialNumber_gs_vals[] = {
  { 0, "Display mode immediate, cell wide"},
  { 1, "Display mode normal, PLMN wide"},
  { 2, "Display mode normal, tracking area wide"},
  { 3, "Display mode normal, cell wide"},
  { 0, NULL},
};

static const value_string ngap_warningType_vals[] = {
  { 0, "Earthquake"},
  { 1, "Tsunami"},
  { 2, "Earthquake and Tsunami"},
  { 3, "Test"},
  { 4, "Other"},
  { 0, NULL},
};

static void
dissect_ngap_warningMessageContents(tvbuff_t *warning_msg_tvb, proto_tree *tree, packet_info *pinfo, uint8_t dcs, int hf_nb_pages, int hf_decoded_page)
{
  uint32_t offset;
  uint8_t nb_of_pages, length, *str;
  proto_item *ti;
  tvbuff_t *cb_data_page_tvb, *cb_data_tvb;
  int i;

  nb_of_pages = tvb_get_uint8(warning_msg_tvb, 0);
  ti = proto_tree_add_uint(tree, hf_nb_pages, warning_msg_tvb, 0, 1, nb_of_pages);
  if (nb_of_pages > 15) {
    expert_add_info_format(pinfo, ti, &ei_ngap_number_pages_le15,
                           "Number of pages should be <=15 (found %u)", nb_of_pages);
    nb_of_pages = 15;
  }
  for (i = 0, offset = 1; i < nb_of_pages; i++) {
    length = tvb_get_uint8(warning_msg_tvb, offset+82);
    cb_data_page_tvb = tvb_new_subset_length(warning_msg_tvb, offset, length);
    cb_data_tvb = dissect_cbs_data(dcs, cb_data_page_tvb, tree, pinfo, 0);
    if (cb_data_tvb) {
      str = tvb_get_string_enc(pinfo->pool, cb_data_tvb, 0, tvb_reported_length(cb_data_tvb), ENC_UTF_8|ENC_NA);
      proto_tree_add_string_format(tree, hf_decoded_page, warning_msg_tvb, offset, 83,
                                   str, "Decoded Page %u: %s", i+1, str);
    }
    offset += 83;
  }
}

static void
ngap_PacketLossRate_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1f%% (%u)", (float)v/10, v);
}

static void
ngap_PacketDelayBudget_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fms (%u)", (float)v/2, v);
}

static void
ngap_TimeUEStayedInCellEnhancedGranularity_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fs", ((float)v)/10);
}

static void
ngap_PeriodicRegistrationUpdateTimer_fmt(char *s, uint32_t v)
{
  uint32_t val = v & 0x1f;

  switch (v>>5) {
    case 0:
      snprintf(s, ITEM_LABEL_LENGTH, "%u min (%u)", val * 10, v);
      break;
    case 1:
    default:
      snprintf(s, ITEM_LABEL_LENGTH, "%u hr (%u)", val, v);
      break;
    case 2:
      snprintf(s, ITEM_LABEL_LENGTH, "%u hr (%u)", val * 10, v);
      break;
    case 3:
      snprintf(s, ITEM_LABEL_LENGTH, "%u sec (%u)", val * 2, v);
      break;
    case 4:
      snprintf(s, ITEM_LABEL_LENGTH, "%u sec (%u)", val * 30, v);
      break;
    case 5:
      snprintf(s, ITEM_LABEL_LENGTH, "%u min (%u)", val, v);
      break;
    case 7:
      snprintf(s, ITEM_LABEL_LENGTH, "deactivated (%u)", v);
      break;
  }
}

static void
ngap_ExtendedPacketDelayBudget_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.2fms (%u)", (float)v/100, v);
}

static void
ngap_Threshold_RSRP_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%ddBm (%u)", (int32_t)v-156, v);
}

static void
ngap_Threshold_RSRQ_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB (%u)", ((float)v/2)-43, v);
}

static void
ngap_Threshold_SINR_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB (%u)", ((float)v/2)-23, v);
}

static void
ngap_N6Jitter_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fms (%d)", (float)v/2, (int32_t)v);
}

static struct ngap_private_data*
ngap_get_private_data(packet_info *pinfo)
{
  struct ngap_private_data *ngap_data = (struct ngap_private_data*)p_get_proto_data(pinfo->pool, pinfo, proto_ngap, 0);
  if (!ngap_data) {
    ngap_data = wmem_new0(pinfo->pool, struct ngap_private_data);
    ngap_data->handover_type_value = -1;
    ngap_data->qos_flow_add_info_rel_type = -1;
    p_add_proto_data(pinfo->pool, pinfo, proto_ngap, 0, ngap_data);
  }
  return ngap_data;
}

static GlobalRANNodeID_enum
ngap_get_ranmode_id(address *addr, uint32_t port, packet_info *pinfo)
{
  struct ngap_private_data *ngap_data = ngap_get_private_data(pinfo);
  GlobalRANNodeID_enum ranmode_id = (GlobalRANNodeID_enum)-1;

  if (ngap_data->ngap_conv) {
    if (addresses_equal(addr, &ngap_data->ngap_conv->addr_a) && port == ngap_data->ngap_conv->port_a) {
      ranmode_id = ngap_data->ngap_conv->ranmode_id_a;
    } else if (addresses_equal(addr, &ngap_data->ngap_conv->addr_b) && port == ngap_data->ngap_conv->port_b) {
      ranmode_id = ngap_data->ngap_conv->ranmode_id_b;
    }
  }
  return ranmode_id;
}

static bool
ngap_is_nbiot_ue(packet_info *pinfo)
{
  struct ngap_private_data *ngap_data = ngap_get_private_data(pinfo);

  if (ngap_data->ngap_conv) {
    wmem_tree_key_t tree_key[3];
    uint32_t *id;

    tree_key[0].length = 1;
    tree_key[0].key = &ngap_data->ran_ue_ngap_id;
    tree_key[1].length = 1;
    tree_key[1].key = &pinfo->num;
    tree_key[2].length = 0;
    tree_key[2].key = NULL;
    id = (uint32_t*)wmem_tree_lookup32_array_le(ngap_data->ngap_conv->nbiot_ran_ue_ngap_id, tree_key);
    if (id && (*id == ngap_data->ran_ue_ngap_id)) {
      return true;
    }
  }
  return false;
}

static const true_false_string ngap_not_updated_updated = {
    "Not updated",
    "Updated"
};

/*--- PDUs declarations ---*/
static int dissect_BroadcastTransportRequestTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_BroadcastTransportResponseTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_BroadcastTransportFailureTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_MBS_DistributionSetupRequestTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_MBS_DistributionSetupResponseTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_MBS_DistributionSetupUnsuccessfulTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_MBS_DistributionReleaseRequestTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_MulticastSessionActivationRequestTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_MulticastSessionDeactivationRequestTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_MulticastSessionUpdateRequestTransfer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);


static const value_string ngap_Criticality_vals[] = {
  {   0, "reject" },
  {   1, "ignore" },
  {   2, "notify" },
  { 0, NULL }
};


static int
dissect_ngap_Criticality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_ngap_INTEGER_0_65535(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}



static int
dissect_ngap_OBJECT_IDENTIFIER(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_object_identifier(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const value_string ngap_PrivateIE_ID_vals[] = {
  {   0, "local" },
  {   1, "global" },
  { 0, NULL }
};

static const per_choice_t PrivateIE_ID_choice[] = {
  {   0, &hf_ngap_local          , ASN1_NO_EXTENSIONS     , dissect_ngap_INTEGER_0_65535 },
  {   1, &hf_ngap_global         , ASN1_NO_EXTENSIONS     , dissect_ngap_OBJECT_IDENTIFIER },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_PrivateIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_PrivateIE_ID, PrivateIE_ID_choice,
                                 NULL);

  return offset;
}


static const value_string ngap_ProcedureCode_vals[] = {
  { id_AMFConfigurationUpdate, "id-AMFConfigurationUpdate" },
  { id_AMFStatusIndication, "id-AMFStatusIndication" },
  { id_CellTrafficTrace, "id-CellTrafficTrace" },
  { id_DeactivateTrace, "id-DeactivateTrace" },
  { id_DownlinkNASTransport, "id-DownlinkNASTransport" },
  { id_DownlinkNonUEAssociatedNRPPaTransport, "id-DownlinkNonUEAssociatedNRPPaTransport" },
  { id_DownlinkRANConfigurationTransfer, "id-DownlinkRANConfigurationTransfer" },
  { id_DownlinkRANStatusTransfer, "id-DownlinkRANStatusTransfer" },
  { id_DownlinkUEAssociatedNRPPaTransport, "id-DownlinkUEAssociatedNRPPaTransport" },
  { id_ErrorIndication, "id-ErrorIndication" },
  { id_HandoverCancel, "id-HandoverCancel" },
  { id_HandoverNotification, "id-HandoverNotification" },
  { id_HandoverPreparation, "id-HandoverPreparation" },
  { id_HandoverResourceAllocation, "id-HandoverResourceAllocation" },
  { id_InitialContextSetup, "id-InitialContextSetup" },
  { id_InitialUEMessage, "id-InitialUEMessage" },
  { id_LocationReportingControl, "id-LocationReportingControl" },
  { id_LocationReportingFailureIndication, "id-LocationReportingFailureIndication" },
  { id_LocationReport, "id-LocationReport" },
  { id_NASNonDeliveryIndication, "id-NASNonDeliveryIndication" },
  { id_NGReset, "id-NGReset" },
  { id_NGSetup, "id-NGSetup" },
  { id_OverloadStart, "id-OverloadStart" },
  { id_OverloadStop, "id-OverloadStop" },
  { id_Paging, "id-Paging" },
  { id_PathSwitchRequest, "id-PathSwitchRequest" },
  { id_PDUSessionResourceModify, "id-PDUSessionResourceModify" },
  { id_PDUSessionResourceModifyIndication, "id-PDUSessionResourceModifyIndication" },
  { id_PDUSessionResourceRelease, "id-PDUSessionResourceRelease" },
  { id_PDUSessionResourceSetup, "id-PDUSessionResourceSetup" },
  { id_PDUSessionResourceNotify, "id-PDUSessionResourceNotify" },
  { id_PrivateMessage, "id-PrivateMessage" },
  { id_PWSCancel, "id-PWSCancel" },
  { id_PWSFailureIndication, "id-PWSFailureIndication" },
  { id_PWSRestartIndication, "id-PWSRestartIndication" },
  { id_RANConfigurationUpdate, "id-RANConfigurationUpdate" },
  { id_RerouteNASRequest, "id-RerouteNASRequest" },
  { id_RRCInactiveTransitionReport, "id-RRCInactiveTransitionReport" },
  { id_TraceFailureIndication, "id-TraceFailureIndication" },
  { id_TraceStart, "id-TraceStart" },
  { id_UEContextModification, "id-UEContextModification" },
  { id_UEContextRelease, "id-UEContextRelease" },
  { id_UEContextReleaseRequest, "id-UEContextReleaseRequest" },
  { id_UERadioCapabilityCheck, "id-UERadioCapabilityCheck" },
  { id_UERadioCapabilityInfoIndication, "id-UERadioCapabilityInfoIndication" },
  { id_UETNLABindingRelease, "id-UETNLABindingRelease" },
  { id_UplinkNASTransport, "id-UplinkNASTransport" },
  { id_UplinkNonUEAssociatedNRPPaTransport, "id-UplinkNonUEAssociatedNRPPaTransport" },
  { id_UplinkRANConfigurationTransfer, "id-UplinkRANConfigurationTransfer" },
  { id_UplinkRANStatusTransfer, "id-UplinkRANStatusTransfer" },
  { id_UplinkUEAssociatedNRPPaTransport, "id-UplinkUEAssociatedNRPPaTransport" },
  { id_WriteReplaceWarning, "id-WriteReplaceWarning" },
  { id_SecondaryRATDataUsageReport, "id-SecondaryRATDataUsageReport" },
  { id_UplinkRIMInformationTransfer, "id-UplinkRIMInformationTransfer" },
  { id_DownlinkRIMInformationTransfer, "id-DownlinkRIMInformationTransfer" },
  { id_RetrieveUEInformation, "id-RetrieveUEInformation" },
  { id_UEInformationTransfer, "id-UEInformationTransfer" },
  { id_RANCPRelocationIndication, "id-RANCPRelocationIndication" },
  { id_UEContextResume, "id-UEContextResume" },
  { id_UEContextSuspend, "id-UEContextSuspend" },
  { id_UERadioCapabilityIDMapping, "id-UERadioCapabilityIDMapping" },
  { id_HandoverSuccess, "id-HandoverSuccess" },
  { id_UplinkRANEarlyStatusTransfer, "id-UplinkRANEarlyStatusTransfer" },
  { id_DownlinkRANEarlyStatusTransfer, "id-DownlinkRANEarlyStatusTransfer" },
  { id_AMFCPRelocationIndication, "id-AMFCPRelocationIndication" },
  { id_ConnectionEstablishmentIndication, "id-ConnectionEstablishmentIndication" },
  { id_BroadcastSessionModification, "id-BroadcastSessionModification" },
  { id_BroadcastSessionRelease, "id-BroadcastSessionRelease" },
  { id_BroadcastSessionSetup, "id-BroadcastSessionSetup" },
  { id_DistributionSetup, "id-DistributionSetup" },
  { id_DistributionRelease, "id-DistributionRelease" },
  { id_MulticastSessionActivation, "id-MulticastSessionActivation" },
  { id_MulticastSessionDeactivation, "id-MulticastSessionDeactivation" },
  { id_MulticastSessionUpdate, "id-MulticastSessionUpdate" },
  { id_MulticastGroupPaging, "id-MulticastGroupPaging" },
  { id_BroadcastSessionReleaseRequired, "id-BroadcastSessionReleaseRequired" },
  { id_TimingSynchronisationStatus, "id-TimingSynchronisationStatus" },
  { id_TimingSynchronisationStatusReport, "id-TimingSynchronisationStatusReport" },
  { id_MTCommunicationHandling, "id-MTCommunicationHandling" },
  { id_RANPagingRequest, "id-RANPagingRequest" },
  { id_BroadcastSessionTransport, "id-BroadcastSessionTransport" },
  { 0, NULL }
};

static value_string_ext ngap_ProcedureCode_vals_ext = VALUE_STRING_EXT_INIT(ngap_ProcedureCode_vals);


static int
dissect_ngap_ProcedureCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &ngap_data->procedure_code, false);


  return offset;
}



static int
dissect_ngap_ProtocolExtensionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, &ngap_data->protocol_extension_id, false);



  return offset;
}


static const value_string ngap_ProtocolIE_ID_vals[] = {
  { id_AllowedNSSAI, "id-AllowedNSSAI" },
  { id_AMFName, "id-AMFName" },
  { id_AMFOverloadResponse, "id-AMFOverloadResponse" },
  { id_AMFSetID, "id-AMFSetID" },
  { id_AMF_TNLAssociationFailedToSetupList, "id-AMF-TNLAssociationFailedToSetupList" },
  { id_AMF_TNLAssociationSetupList, "id-AMF-TNLAssociationSetupList" },
  { id_AMF_TNLAssociationToAddList, "id-AMF-TNLAssociationToAddList" },
  { id_AMF_TNLAssociationToRemoveList, "id-AMF-TNLAssociationToRemoveList" },
  { id_AMF_TNLAssociationToUpdateList, "id-AMF-TNLAssociationToUpdateList" },
  { id_AMFTrafficLoadReductionIndication, "id-AMFTrafficLoadReductionIndication" },
  { id_AMF_UE_NGAP_ID, "id-AMF-UE-NGAP-ID" },
  { id_AssistanceDataForPaging, "id-AssistanceDataForPaging" },
  { id_BroadcastCancelledAreaList, "id-BroadcastCancelledAreaList" },
  { id_BroadcastCompletedAreaList, "id-BroadcastCompletedAreaList" },
  { id_CancelAllWarningMessages, "id-CancelAllWarningMessages" },
  { id_Cause, "id-Cause" },
  { id_CellIDListForRestart, "id-CellIDListForRestart" },
  { id_ConcurrentWarningMessageInd, "id-ConcurrentWarningMessageInd" },
  { id_CoreNetworkAssistanceInformationForInactive, "id-CoreNetworkAssistanceInformationForInactive" },
  { id_CriticalityDiagnostics, "id-CriticalityDiagnostics" },
  { id_DataCodingScheme, "id-DataCodingScheme" },
  { id_DefaultPagingDRX, "id-DefaultPagingDRX" },
  { id_DirectForwardingPathAvailability, "id-DirectForwardingPathAvailability" },
  { id_EmergencyAreaIDListForRestart, "id-EmergencyAreaIDListForRestart" },
  { id_EmergencyFallbackIndicator, "id-EmergencyFallbackIndicator" },
  { id_EUTRA_CGI, "id-EUTRA-CGI" },
  { id_FiveG_S_TMSI, "id-FiveG-S-TMSI" },
  { id_GlobalRANNodeID, "id-GlobalRANNodeID" },
  { id_GUAMI, "id-GUAMI" },
  { id_HandoverType, "id-HandoverType" },
  { id_IMSVoiceSupportIndicator, "id-IMSVoiceSupportIndicator" },
  { id_IndexToRFSP, "id-IndexToRFSP" },
  { id_InfoOnRecommendedCellsAndRANNodesForPaging, "id-InfoOnRecommendedCellsAndRANNodesForPaging" },
  { id_LocationReportingRequestType, "id-LocationReportingRequestType" },
  { id_MaskedIMEISV, "id-MaskedIMEISV" },
  { id_MessageIdentifier, "id-MessageIdentifier" },
  { id_MobilityRestrictionList, "id-MobilityRestrictionList" },
  { id_NASC, "id-NASC" },
  { id_NAS_PDU, "id-NAS-PDU" },
  { id_NASSecurityParametersFromNGRAN, "id-NASSecurityParametersFromNGRAN" },
  { id_NewAMF_UE_NGAP_ID, "id-NewAMF-UE-NGAP-ID" },
  { id_NewSecurityContextInd, "id-NewSecurityContextInd" },
  { id_NGAP_Message, "id-NGAP-Message" },
  { id_NGRAN_CGI, "id-NGRAN-CGI" },
  { id_NGRANTraceID, "id-NGRANTraceID" },
  { id_NR_CGI, "id-NR-CGI" },
  { id_NRPPa_PDU, "id-NRPPa-PDU" },
  { id_NumberOfBroadcastsRequested, "id-NumberOfBroadcastsRequested" },
  { id_OldAMF, "id-OldAMF" },
  { id_OverloadStartNSSAIList, "id-OverloadStartNSSAIList" },
  { id_PagingDRX, "id-PagingDRX" },
  { id_PagingOrigin, "id-PagingOrigin" },
  { id_PagingPriority, "id-PagingPriority" },
  { id_PDUSessionResourceAdmittedList, "id-PDUSessionResourceAdmittedList" },
  { id_PDUSessionResourceFailedToModifyListModRes, "id-PDUSessionResourceFailedToModifyListModRes" },
  { id_PDUSessionResourceFailedToSetupListCxtRes, "id-PDUSessionResourceFailedToSetupListCxtRes" },
  { id_PDUSessionResourceFailedToSetupListHOAck, "id-PDUSessionResourceFailedToSetupListHOAck" },
  { id_PDUSessionResourceFailedToSetupListPSReq, "id-PDUSessionResourceFailedToSetupListPSReq" },
  { id_PDUSessionResourceFailedToSetupListSURes, "id-PDUSessionResourceFailedToSetupListSURes" },
  { id_PDUSessionResourceHandoverList, "id-PDUSessionResourceHandoverList" },
  { id_PDUSessionResourceListCxtRelCpl, "id-PDUSessionResourceListCxtRelCpl" },
  { id_PDUSessionResourceListHORqd, "id-PDUSessionResourceListHORqd" },
  { id_PDUSessionResourceModifyListModCfm, "id-PDUSessionResourceModifyListModCfm" },
  { id_PDUSessionResourceModifyListModInd, "id-PDUSessionResourceModifyListModInd" },
  { id_PDUSessionResourceModifyListModReq, "id-PDUSessionResourceModifyListModReq" },
  { id_PDUSessionResourceModifyListModRes, "id-PDUSessionResourceModifyListModRes" },
  { id_PDUSessionResourceNotifyList, "id-PDUSessionResourceNotifyList" },
  { id_PDUSessionResourceReleasedListNot, "id-PDUSessionResourceReleasedListNot" },
  { id_PDUSessionResourceReleasedListPSAck, "id-PDUSessionResourceReleasedListPSAck" },
  { id_PDUSessionResourceReleasedListPSFail, "id-PDUSessionResourceReleasedListPSFail" },
  { id_PDUSessionResourceReleasedListRelRes, "id-PDUSessionResourceReleasedListRelRes" },
  { id_PDUSessionResourceSetupListCxtReq, "id-PDUSessionResourceSetupListCxtReq" },
  { id_PDUSessionResourceSetupListCxtRes, "id-PDUSessionResourceSetupListCxtRes" },
  { id_PDUSessionResourceSetupListHOReq, "id-PDUSessionResourceSetupListHOReq" },
  { id_PDUSessionResourceSetupListSUReq, "id-PDUSessionResourceSetupListSUReq" },
  { id_PDUSessionResourceSetupListSURes, "id-PDUSessionResourceSetupListSURes" },
  { id_PDUSessionResourceToBeSwitchedDLList, "id-PDUSessionResourceToBeSwitchedDLList" },
  { id_PDUSessionResourceSwitchedList, "id-PDUSessionResourceSwitchedList" },
  { id_PDUSessionResourceToReleaseListHOCmd, "id-PDUSessionResourceToReleaseListHOCmd" },
  { id_PDUSessionResourceToReleaseListRelCmd, "id-PDUSessionResourceToReleaseListRelCmd" },
  { id_PLMNSupportList, "id-PLMNSupportList" },
  { id_PWSFailedCellIDList, "id-PWSFailedCellIDList" },
  { id_RANNodeName, "id-RANNodeName" },
  { id_RANPagingPriority, "id-RANPagingPriority" },
  { id_RANStatusTransfer_TransparentContainer, "id-RANStatusTransfer-TransparentContainer" },
  { id_RAN_UE_NGAP_ID, "id-RAN-UE-NGAP-ID" },
  { id_RelativeAMFCapacity, "id-RelativeAMFCapacity" },
  { id_RepetitionPeriod, "id-RepetitionPeriod" },
  { id_ResetType, "id-ResetType" },
  { id_RoutingID, "id-RoutingID" },
  { id_RRCEstablishmentCause, "id-RRCEstablishmentCause" },
  { id_RRCInactiveTransitionReportRequest, "id-RRCInactiveTransitionReportRequest" },
  { id_RRCState, "id-RRCState" },
  { id_SecurityContext, "id-SecurityContext" },
  { id_SecurityKey, "id-SecurityKey" },
  { id_SerialNumber, "id-SerialNumber" },
  { id_ServedGUAMIList, "id-ServedGUAMIList" },
  { id_SliceSupportList, "id-SliceSupportList" },
  { id_SONConfigurationTransferDL, "id-SONConfigurationTransferDL" },
  { id_SONConfigurationTransferUL, "id-SONConfigurationTransferUL" },
  { id_SourceAMF_UE_NGAP_ID, "id-SourceAMF-UE-NGAP-ID" },
  { id_SourceToTarget_TransparentContainer, "id-SourceToTarget-TransparentContainer" },
  { id_SupportedTAList, "id-SupportedTAList" },
  { id_TAIListForPaging, "id-TAIListForPaging" },
  { id_TAIListForRestart, "id-TAIListForRestart" },
  { id_TargetID, "id-TargetID" },
  { id_TargetToSource_TransparentContainer, "id-TargetToSource-TransparentContainer" },
  { id_TimeToWait, "id-TimeToWait" },
  { id_TraceActivation, "id-TraceActivation" },
  { id_TraceCollectionEntityIPAddress, "id-TraceCollectionEntityIPAddress" },
  { id_UEAggregateMaximumBitRate, "id-UEAggregateMaximumBitRate" },
  { id_UE_associatedLogicalNG_connectionList, "id-UE-associatedLogicalNG-connectionList" },
  { id_UEContextRequest, "id-UEContextRequest" },
  { id_Unknown_113, "id-Unknown-113" },
  { id_UE_NGAP_IDs, "id-UE-NGAP-IDs" },
  { id_UEPagingIdentity, "id-UEPagingIdentity" },
  { id_UEPresenceInAreaOfInterestList, "id-UEPresenceInAreaOfInterestList" },
  { id_UERadioCapability, "id-UERadioCapability" },
  { id_UERadioCapabilityForPaging, "id-UERadioCapabilityForPaging" },
  { id_UESecurityCapabilities, "id-UESecurityCapabilities" },
  { id_UnavailableGUAMIList, "id-UnavailableGUAMIList" },
  { id_UserLocationInformation, "id-UserLocationInformation" },
  { id_WarningAreaList, "id-WarningAreaList" },
  { id_WarningMessageContents, "id-WarningMessageContents" },
  { id_WarningSecurityInfo, "id-WarningSecurityInfo" },
  { id_WarningType, "id-WarningType" },
  { id_AdditionalUL_NGU_UP_TNLInformation, "id-AdditionalUL-NGU-UP-TNLInformation" },
  { id_DataForwardingNotPossible, "id-DataForwardingNotPossible" },
  { id_DL_NGU_UP_TNLInformation, "id-DL-NGU-UP-TNLInformation" },
  { id_NetworkInstance, "id-NetworkInstance" },
  { id_PDUSessionAggregateMaximumBitRate, "id-PDUSessionAggregateMaximumBitRate" },
  { id_PDUSessionResourceFailedToModifyListModCfm, "id-PDUSessionResourceFailedToModifyListModCfm" },
  { id_PDUSessionResourceFailedToSetupListCxtFail, "id-PDUSessionResourceFailedToSetupListCxtFail" },
  { id_PDUSessionResourceListCxtRelReq, "id-PDUSessionResourceListCxtRelReq" },
  { id_PDUSessionType, "id-PDUSessionType" },
  { id_QosFlowAddOrModifyRequestList, "id-QosFlowAddOrModifyRequestList" },
  { id_QosFlowSetupRequestList, "id-QosFlowSetupRequestList" },
  { id_QosFlowToReleaseList, "id-QosFlowToReleaseList" },
  { id_SecurityIndication, "id-SecurityIndication" },
  { id_UL_NGU_UP_TNLInformation, "id-UL-NGU-UP-TNLInformation" },
  { id_UL_NGU_UP_TNLModifyList, "id-UL-NGU-UP-TNLModifyList" },
  { id_WarningAreaCoordinates, "id-WarningAreaCoordinates" },
  { id_PDUSessionResourceSecondaryRATUsageList, "id-PDUSessionResourceSecondaryRATUsageList" },
  { id_HandoverFlag, "id-HandoverFlag" },
  { id_SecondaryRATUsageInformation, "id-SecondaryRATUsageInformation" },
  { id_PDUSessionResourceReleaseResponseTransfer, "id-PDUSessionResourceReleaseResponseTransfer" },
  { id_RedirectionVoiceFallback, "id-RedirectionVoiceFallback" },
  { id_UERetentionInformation, "id-UERetentionInformation" },
  { id_S_NSSAI, "id-S-NSSAI" },
  { id_PSCellInformation, "id-PSCellInformation" },
  { id_LastEUTRAN_PLMNIdentity, "id-LastEUTRAN-PLMNIdentity" },
  { id_MaximumIntegrityProtectedDataRate_DL, "id-MaximumIntegrityProtectedDataRate-DL" },
  { id_AdditionalDLForwardingUPTNLInformation, "id-AdditionalDLForwardingUPTNLInformation" },
  { id_AdditionalDLUPTNLInformationForHOList, "id-AdditionalDLUPTNLInformationForHOList" },
  { id_AdditionalNGU_UP_TNLInformation, "id-AdditionalNGU-UP-TNLInformation" },
  { id_AdditionalDLQosFlowPerTNLInformation, "id-AdditionalDLQosFlowPerTNLInformation" },
  { id_SecurityResult, "id-SecurityResult" },
  { id_ENDC_SONConfigurationTransferDL, "id-ENDC-SONConfigurationTransferDL" },
  { id_ENDC_SONConfigurationTransferUL, "id-ENDC-SONConfigurationTransferUL" },
  { id_OldAssociatedQosFlowList_ULendmarkerexpected, "id-OldAssociatedQosFlowList-ULendmarkerexpected" },
  { id_CNTypeRestrictionsForEquivalent, "id-CNTypeRestrictionsForEquivalent" },
  { id_CNTypeRestrictionsForServing, "id-CNTypeRestrictionsForServing" },
  { id_NewGUAMI, "id-NewGUAMI" },
  { id_ULForwarding, "id-ULForwarding" },
  { id_ULForwardingUP_TNLInformation, "id-ULForwardingUP-TNLInformation" },
  { id_CNAssistedRANTuning, "id-CNAssistedRANTuning" },
  { id_CommonNetworkInstance, "id-CommonNetworkInstance" },
  { id_NGRAN_TNLAssociationToRemoveList, "id-NGRAN-TNLAssociationToRemoveList" },
  { id_TNLAssociationTransportLayerAddressNGRAN, "id-TNLAssociationTransportLayerAddressNGRAN" },
  { id_EndpointIPAddressAndPort, "id-EndpointIPAddressAndPort" },
  { id_LocationReportingAdditionalInfo, "id-LocationReportingAdditionalInfo" },
  { id_SourceToTarget_AMFInformationReroute, "id-SourceToTarget-AMFInformationReroute" },
  { id_AdditionalULForwardingUPTNLInformation, "id-AdditionalULForwardingUPTNLInformation" },
  { id_SCTP_TLAs, "id-SCTP-TLAs" },
  { id_SelectedPLMNIdentity, "id-SelectedPLMNIdentity" },
  { id_RIMInformationTransfer, "id-RIMInformationTransfer" },
  { id_GUAMIType, "id-GUAMIType" },
  { id_SRVCCOperationPossible, "id-SRVCCOperationPossible" },
  { id_TargetRNC_ID, "id-TargetRNC-ID" },
  { id_RAT_Information, "id-RAT-Information" },
  { id_ExtendedRATRestrictionInformation, "id-ExtendedRATRestrictionInformation" },
  { id_QosMonitoringRequest, "id-QosMonitoringRequest" },
  { id_SgNB_UE_X2AP_ID, "id-SgNB-UE-X2AP-ID" },
  { id_AdditionalRedundantDL_NGU_UP_TNLInformation, "id-AdditionalRedundantDL-NGU-UP-TNLInformation" },
  { id_AdditionalRedundantDLQosFlowPerTNLInformation, "id-AdditionalRedundantDLQosFlowPerTNLInformation" },
  { id_AdditionalRedundantNGU_UP_TNLInformation, "id-AdditionalRedundantNGU-UP-TNLInformation" },
  { id_AdditionalRedundantUL_NGU_UP_TNLInformation, "id-AdditionalRedundantUL-NGU-UP-TNLInformation" },
  { id_CNPacketDelayBudgetDL, "id-CNPacketDelayBudgetDL" },
  { id_CNPacketDelayBudgetUL, "id-CNPacketDelayBudgetUL" },
  { id_ExtendedPacketDelayBudget, "id-ExtendedPacketDelayBudget" },
  { id_RedundantCommonNetworkInstance, "id-RedundantCommonNetworkInstance" },
  { id_RedundantDL_NGU_TNLInformationReused, "id-RedundantDL-NGU-TNLInformationReused" },
  { id_RedundantDL_NGU_UP_TNLInformation, "id-RedundantDL-NGU-UP-TNLInformation" },
  { id_RedundantDLQosFlowPerTNLInformation, "id-RedundantDLQosFlowPerTNLInformation" },
  { id_RedundantQosFlowIndicator, "id-RedundantQosFlowIndicator" },
  { id_RedundantUL_NGU_UP_TNLInformation, "id-RedundantUL-NGU-UP-TNLInformation" },
  { id_TSCTrafficCharacteristics, "id-TSCTrafficCharacteristics" },
  { id_RedundantPDUSessionInformation, "id-RedundantPDUSessionInformation" },
  { id_UsedRSNInformation, "id-UsedRSNInformation" },
  { id_IAB_Authorized, "id-IAB-Authorized" },
  { id_IAB_Supported, "id-IAB-Supported" },
  { id_IABNodeIndication, "id-IABNodeIndication" },
  { id_NB_IoT_PagingDRX, "id-NB-IoT-PagingDRX" },
  { id_NB_IoT_Paging_eDRXInfo, "id-NB-IoT-Paging-eDRXInfo" },
  { id_NB_IoT_DefaultPagingDRX, "id-NB-IoT-DefaultPagingDRX" },
  { id_Enhanced_CoverageRestriction, "id-Enhanced-CoverageRestriction" },
  { id_Extended_ConnectedTime, "id-Extended-ConnectedTime" },
  { id_PagingAssisDataforCEcapabUE, "id-PagingAssisDataforCEcapabUE" },
  { id_WUS_Assistance_Information, "id-WUS-Assistance-Information" },
  { id_UE_DifferentiationInfo, "id-UE-DifferentiationInfo" },
  { id_NB_IoT_UEPriority, "id-NB-IoT-UEPriority" },
  { id_UL_CP_SecurityInformation, "id-UL-CP-SecurityInformation" },
  { id_DL_CP_SecurityInformation, "id-DL-CP-SecurityInformation" },
  { id_TAI, "id-TAI" },
  { id_UERadioCapabilityForPagingOfNB_IoT, "id-UERadioCapabilityForPagingOfNB-IoT" },
  { id_LTEV2XServicesAuthorized, "id-LTEV2XServicesAuthorized" },
  { id_NRV2XServicesAuthorized, "id-NRV2XServicesAuthorized" },
  { id_LTEUESidelinkAggregateMaximumBitrate, "id-LTEUESidelinkAggregateMaximumBitrate" },
  { id_NRUESidelinkAggregateMaximumBitrate, "id-NRUESidelinkAggregateMaximumBitrate" },
  { id_PC5QoSParameters, "id-PC5QoSParameters" },
  { id_AlternativeQoSParaSetList, "id-AlternativeQoSParaSetList" },
  { id_CurrentQoSParaSetIndex, "id-CurrentQoSParaSetIndex" },
  { id_CEmodeBrestricted, "id-CEmodeBrestricted" },
  { id_EUTRA_PagingeDRXInformation, "id-EUTRA-PagingeDRXInformation" },
  { id_CEmodeBSupport_Indicator, "id-CEmodeBSupport-Indicator" },
  { id_LTEM_Indication, "id-LTEM-Indication" },
  { id_EndIndication, "id-EndIndication" },
  { id_EDT_Session, "id-EDT-Session" },
  { id_UECapabilityInfoRequest, "id-UECapabilityInfoRequest" },
  { id_PDUSessionResourceFailedToResumeListRESReq, "id-PDUSessionResourceFailedToResumeListRESReq" },
  { id_PDUSessionResourceFailedToResumeListRESRes, "id-PDUSessionResourceFailedToResumeListRESRes" },
  { id_PDUSessionResourceSuspendListSUSReq, "id-PDUSessionResourceSuspendListSUSReq" },
  { id_PDUSessionResourceResumeListRESReq, "id-PDUSessionResourceResumeListRESReq" },
  { id_PDUSessionResourceResumeListRESRes, "id-PDUSessionResourceResumeListRESRes" },
  { id_UE_UP_CIoT_Support, "id-UE-UP-CIoT-Support" },
  { id_Suspend_Request_Indication, "id-Suspend-Request-Indication" },
  { id_Suspend_Response_Indication, "id-Suspend-Response-Indication" },
  { id_RRC_Resume_Cause, "id-RRC-Resume-Cause" },
  { id_RGLevelWirelineAccessCharacteristics, "id-RGLevelWirelineAccessCharacteristics" },
  { id_W_AGFIdentityInformation, "id-W-AGFIdentityInformation" },
  { id_GlobalTNGF_ID, "id-GlobalTNGF-ID" },
  { id_GlobalTWIF_ID, "id-GlobalTWIF-ID" },
  { id_GlobalW_AGF_ID, "id-GlobalW-AGF-ID" },
  { id_UserLocationInformationW_AGF, "id-UserLocationInformationW-AGF" },
  { id_UserLocationInformationTNGF, "id-UserLocationInformationTNGF" },
  { id_AuthenticatedIndication, "id-AuthenticatedIndication" },
  { id_TNGFIdentityInformation, "id-TNGFIdentityInformation" },
  { id_TWIFIdentityInformation, "id-TWIFIdentityInformation" },
  { id_UserLocationInformationTWIF, "id-UserLocationInformationTWIF" },
  { id_DataForwardingResponseERABList, "id-DataForwardingResponseERABList" },
  { id_IntersystemSONConfigurationTransferDL, "id-IntersystemSONConfigurationTransferDL" },
  { id_IntersystemSONConfigurationTransferUL, "id-IntersystemSONConfigurationTransferUL" },
  { id_SONInformationReport, "id-SONInformationReport" },
  { id_UEHistoryInformationFromTheUE, "id-UEHistoryInformationFromTheUE" },
  { id_ManagementBasedMDTPLMNList, "id-ManagementBasedMDTPLMNList" },
  { id_MDTConfiguration, "id-MDTConfiguration" },
  { id_PrivacyIndicator, "id-PrivacyIndicator" },
  { id_TraceCollectionEntityURI, "id-TraceCollectionEntityURI" },
  { id_NPN_Support, "id-NPN-Support" },
  { id_NPN_AccessInformation, "id-NPN-AccessInformation" },
  { id_NPN_PagingAssistanceInformation, "id-NPN-PagingAssistanceInformation" },
  { id_NPN_MobilityInformation, "id-NPN-MobilityInformation" },
  { id_TargettoSource_Failure_TransparentContainer, "id-TargettoSource-Failure-TransparentContainer" },
  { id_NID, "id-NID" },
  { id_UERadioCapabilityID, "id-UERadioCapabilityID" },
  { id_UERadioCapability_EUTRA_Format, "id-UERadioCapability-EUTRA-Format" },
  { id_DAPSRequestInfo, "id-DAPSRequestInfo" },
  { id_DAPSResponseInfoList, "id-DAPSResponseInfoList" },
  { id_EarlyStatusTransfer_TransparentContainer, "id-EarlyStatusTransfer-TransparentContainer" },
  { id_NotifySourceNGRANNode, "id-NotifySourceNGRANNode" },
  { id_ExtendedSliceSupportList, "id-ExtendedSliceSupportList" },
  { id_ExtendedTAISliceSupportList, "id-ExtendedTAISliceSupportList" },
  { id_ConfiguredTACIndication, "id-ConfiguredTACIndication" },
  { id_Extended_RANNodeName, "id-Extended-RANNodeName" },
  { id_Extended_AMFName, "id-Extended-AMFName" },
  { id_GlobalCable_ID, "id-GlobalCable-ID" },
  { id_QosMonitoringReportingFrequency, "id-QosMonitoringReportingFrequency" },
  { id_QosFlowParametersList, "id-QosFlowParametersList" },
  { id_QosFlowFeedbackList, "id-QosFlowFeedbackList" },
  { id_BurstArrivalTimeDownlink, "id-BurstArrivalTimeDownlink" },
  { id_ExtendedUEIdentityIndexValue, "id-ExtendedUEIdentityIndexValue" },
  { id_PduSessionExpectedUEActivityBehaviour, "id-PduSessionExpectedUEActivityBehaviour" },
  { id_MicoAllPLMN, "id-MicoAllPLMN" },
  { id_QosFlowFailedToSetupList, "id-QosFlowFailedToSetupList" },
  { id_SourceTNLAddrInfo, "id-SourceTNLAddrInfo" },
  { id_ExtendedReportIntervalMDT, "id-ExtendedReportIntervalMDT" },
  { id_SourceNodeID, "id-SourceNodeID" },
  { id_NRNTNTAIInformation, "id-NRNTNTAIInformation" },
  { id_UEContextReferenceAtSource, "id-UEContextReferenceAtSource" },
  { id_LastVisitedPSCellList, "id-LastVisitedPSCellList" },
  { id_IntersystemSONInformationRequest, "id-IntersystemSONInformationRequest" },
  { id_IntersystemSONInformationReply, "id-IntersystemSONInformationReply" },
  { id_EnergySavingIndication, "id-EnergySavingIndication" },
  { id_IntersystemResourceStatusUpdate, "id-IntersystemResourceStatusUpdate" },
  { id_SuccessfulHandoverReportList, "id-SuccessfulHandoverReportList" },
  { id_MBS_AreaSessionID, "id-MBS-AreaSessionID" },
  { id_MBS_QoSFlowsToBeSetupList, "id-MBS-QoSFlowsToBeSetupList" },
  { id_MBS_QoSFlowsToBeSetupModList, "id-MBS-QoSFlowsToBeSetupModList" },
  { id_MBS_ServiceArea, "id-MBS-ServiceArea" },
  { id_MBS_SessionID, "id-MBS-SessionID" },
  { id_MBS_DistributionReleaseRequestTransfer, "id-MBS-DistributionReleaseRequestTransfer" },
  { id_MBS_DistributionSetupRequestTransfer, "id-MBS-DistributionSetupRequestTransfer" },
  { id_MBS_DistributionSetupResponseTransfer, "id-MBS-DistributionSetupResponseTransfer" },
  { id_MBS_DistributionSetupUnsuccessfulTransfer, "id-MBS-DistributionSetupUnsuccessfulTransfer" },
  { id_MulticastSessionActivationRequestTransfer, "id-MulticastSessionActivationRequestTransfer" },
  { id_MulticastSessionDeactivationRequestTransfer, "id-MulticastSessionDeactivationRequestTransfer" },
  { id_MulticastSessionUpdateRequestTransfer, "id-MulticastSessionUpdateRequestTransfer" },
  { id_MulticastGroupPagingAreaList, "id-MulticastGroupPagingAreaList" },
  { id_Unknown_308, "id-Unknown-308" },
  { id_MBS_SupportIndicator, "id-MBS-SupportIndicator" },
  { id_MBSSessionFailedtoSetupList, "id-MBSSessionFailedtoSetupList" },
  { id_MBSSessionFailedtoSetuporModifyList, "id-MBSSessionFailedtoSetuporModifyList" },
  { id_MBSSessionSetupResponseList, "id-MBSSessionSetupResponseList" },
  { id_MBSSessionSetuporModifyResponseList, "id-MBSSessionSetuporModifyResponseList" },
  { id_MBSSessionSetupFailureTransfer, "id-MBSSessionSetupFailureTransfer" },
  { id_MBSSessionSetupRequestTransfer, "id-MBSSessionSetupRequestTransfer" },
  { id_MBSSessionSetupResponseTransfer, "id-MBSSessionSetupResponseTransfer" },
  { id_MBSSessionToReleaseList, "id-MBSSessionToReleaseList" },
  { id_MBSSessionSetupRequestList, "id-MBSSessionSetupRequestList" },
  { id_MBSSessionSetuporModifyRequestList, "id-MBSSessionSetuporModifyRequestList" },
  { id_Unknown_320, "id-Unknown-320" },
  { id_Unknown_321, "id-Unknown-321" },
  { id_Unknown_322, "id-Unknown-322" },
  { id_MBS_ActiveSessionInformation_SourcetoTargetList, "id-MBS-ActiveSessionInformation-SourcetoTargetList" },
  { id_MBS_ActiveSessionInformation_TargettoSourceList, "id-MBS-ActiveSessionInformation-TargettoSourceList" },
  { id_OnboardingSupport, "id-OnboardingSupport" },
  { id_TimeSyncAssistanceInfo, "id-TimeSyncAssistanceInfo" },
  { id_SurvivalTime, "id-SurvivalTime" },
  { id_QMCConfigInfo, "id-QMCConfigInfo" },
  { id_QMCDeactivation, "id-QMCDeactivation" },
  { id_Unknown_330, "id-Unknown-330" },
  { id_PDUSessionPairID, "id-PDUSessionPairID" },
  { id_NR_PagingeDRXInformation, "id-NR-PagingeDRXInformation" },
  { id_RedCapIndication, "id-RedCapIndication" },
  { id_TargetNSSAIInformation, "id-TargetNSSAIInformation" },
  { id_UESliceMaximumBitRateList, "id-UESliceMaximumBitRateList" },
  { id_M4ReportAmount, "id-M4ReportAmount" },
  { id_M5ReportAmount, "id-M5ReportAmount" },
  { id_M6ReportAmount, "id-M6ReportAmount" },
  { id_M7ReportAmount, "id-M7ReportAmount" },
  { id_IncludeBeamMeasurementsIndication, "id-IncludeBeamMeasurementsIndication" },
  { id_ExcessPacketDelayThresholdConfiguration, "id-ExcessPacketDelayThresholdConfiguration" },
  { id_PagingCause, "id-PagingCause" },
  { id_PagingCauseIndicationForVoiceService, "id-PagingCauseIndicationForVoiceService" },
  { id_PEIPSassistanceInformation, "id-PEIPSassistanceInformation" },
  { id_FiveG_ProSeAuthorized, "id-FiveG-ProSeAuthorized" },
  { id_FiveG_ProSeUEPC5AggregateMaximumBitRate, "id-FiveG-ProSeUEPC5AggregateMaximumBitRate" },
  { id_FiveG_ProSePC5QoSParameters, "id-FiveG-ProSePC5QoSParameters" },
  { id_MBSSessionModificationFailureTransfer, "id-MBSSessionModificationFailureTransfer" },
  { id_MBSSessionModificationRequestTransfer, "id-MBSSessionModificationRequestTransfer" },
  { id_MBSSessionModificationResponseTransfer, "id-MBSSessionModificationResponseTransfer" },
  { id_MBS_QoSFlowToReleaseList, "id-MBS-QoSFlowToReleaseList" },
  { id_MBS_SessionTNLInfo5GC, "id-MBS-SessionTNLInfo5GC" },
  { id_TAINSAGSupportList, "id-TAINSAGSupportList" },
  { id_SourceNodeTNLAddrInfo, "id-SourceNodeTNLAddrInfo" },
  { id_NGAPIESupportInformationRequestList, "id-NGAPIESupportInformationRequestList" },
  { id_NGAPIESupportInformationResponseList, "id-NGAPIESupportInformationResponseList" },
  { id_MBS_SessionFSAIDList, "id-MBS-SessionFSAIDList" },
  { id_MBSSessionReleaseResponseTransfer, "id-MBSSessionReleaseResponseTransfer" },
  { id_ManagementBasedMDTPLMNModificationList, "id-ManagementBasedMDTPLMNModificationList" },
  { id_EarlyMeasurement, "id-EarlyMeasurement" },
  { id_BeamMeasurementsReportConfiguration, "id-BeamMeasurementsReportConfiguration" },
  { id_HFCNode_ID_new, "id-HFCNode-ID-new" },
  { id_GlobalCable_ID_new, "id-GlobalCable-ID-new" },
  { id_TargetHomeENB_ID, "id-TargetHomeENB-ID" },
  { id_HashedUEIdentityIndexValue, "id-HashedUEIdentityIndexValue" },
  { id_ExtendedMobilityInformation, "id-ExtendedMobilityInformation" },
  { id_NetworkControlledRepeaterAuthorized, "id-NetworkControlledRepeaterAuthorized" },
  { id_AdditionalCancelledlocationReportingReferenceIDList, "id-AdditionalCancelledlocationReportingReferenceIDList" },
  { id_Selected_Target_SNPN_Identity, "id-Selected-Target-SNPN-Identity" },
  { id_EquivalentSNPNsList, "id-EquivalentSNPNsList" },
  { id_SelectedNID, "id-SelectedNID" },
  { id_SupportedUETypeList, "id-SupportedUETypeList" },
  { id_AerialUEsubscriptionInformation, "id-AerialUEsubscriptionInformation" },
  { id_NR_A2X_ServicesAuthorized, "id-NR-A2X-ServicesAuthorized" },
  { id_LTE_A2X_ServicesAuthorized, "id-LTE-A2X-ServicesAuthorized" },
  { id_NR_A2X_UE_PC5_AggregateMaximumBitRate, "id-NR-A2X-UE-PC5-AggregateMaximumBitRate" },
  { id_LTE_A2X_UE_PC5_AggregateMaximumBitRate, "id-LTE-A2X-UE-PC5-AggregateMaximumBitRate" },
  { id_A2X_PC5_QoS_Parameters, "id-A2X-PC5-QoS-Parameters" },
  { id_FiveGProSeLayer2Multipath, "id-FiveGProSeLayer2Multipath" },
  { id_FiveGProSeLayer2UEtoUERelay, "id-FiveGProSeLayer2UEtoUERelay" },
  { id_FiveGProSeLayer2UEtoUERemote, "id-FiveGProSeLayer2UEtoUERemote" },
  { id_CandidateRelayUEInformationList, "id-CandidateRelayUEInformationList" },
  { id_SuccessfulPSCellChangeReportList, "id-SuccessfulPSCellChangeReportList" },
  { id_IntersystemMobilityFailureforVoiceFallback, "id-IntersystemMobilityFailureforVoiceFallback" },
  { id_TargetCellCRNTI, "id-TargetCellCRNTI" },
  { id_TimeSinceFailure, "id-TimeSinceFailure" },
  { id_RANTimingSynchronisationStatusInfo, "id-RANTimingSynchronisationStatusInfo" },
  { id_RAN_TSSRequestType, "id-RAN-TSSRequestType" },
  { id_RAN_TSSScope, "id-RAN-TSSScope" },
  { id_ClockQualityReportingControlInfo, "id-ClockQualityReportingControlInfo" },
  { id_RANfeedbacktype, "id-RANfeedbacktype" },
  { id_QoSFlowTSCList, "id-QoSFlowTSCList" },
  { id_TSCTrafficCharacteristicsFeedback, "id-TSCTrafficCharacteristicsFeedback" },
  { id_DownlinkTLContainer, "id-DownlinkTLContainer" },
  { id_UplinkTLContainer, "id-UplinkTLContainer" },
  { id_ANPacketDelayBudgetUL, "id-ANPacketDelayBudgetUL" },
  { id_QosFlowAdditionalInfoList, "id-QosFlowAdditionalInfoList" },
  { id_AssistanceInformationQoE_Meas, "id-AssistanceInformationQoE-Meas" },
  { id_MBSCommServiceType, "id-MBSCommServiceType" },
  { id_MobileIAB_Authorized, "id-MobileIAB-Authorized" },
  { id_MobileIAB_MTUserLocationInformation, "id-MobileIAB-MTUserLocationInformation" },
  { id_MobileIABNodeIndication, "id-MobileIABNodeIndication" },
  { id_NoPDUSessionIndication, "id-NoPDUSessionIndication" },
  { id_MobileIAB_Supported, "id-MobileIAB-Supported" },
  { id_CN_MT_CommunicationHandling, "id-CN-MT-CommunicationHandling" },
  { id_FiveGCAction, "id-FiveGCAction" },
  { id_PagingPolicyDifferentiation, "id-PagingPolicyDifferentiation" },
  { id_DL_Signalling, "id-DL-Signalling" },
  { id_PNI_NPN_AreaScopeofMDT, "id-PNI-NPN-AreaScopeofMDT" },
  { id_PNI_NPNBasedMDT, "id-PNI-NPNBasedMDT" },
  { id_SNPN_CellBasedMDT, "id-SNPN-CellBasedMDT" },
  { id_SNPN_TAIBasedMDT, "id-SNPN-TAIBasedMDT" },
  { id_SNPN_BasedMDT, "id-SNPN-BasedMDT" },
  { id_Partially_Allowed_NSSAI, "id-Partially-Allowed-NSSAI" },
  { id_AssociatedSessionID, "id-AssociatedSessionID" },
  { id_MBS_AssistanceInformation, "id-MBS-AssistanceInformation" },
  { id_BroadcastTransportFailureTransfer, "id-BroadcastTransportFailureTransfer" },
  { id_BroadcastTransportRequestTransfer, "id-BroadcastTransportRequestTransfer" },
  { id_BroadcastTransportResponseTransfer, "id-BroadcastTransportResponseTransfer" },
  { id_TimeBasedHandoverInformation, "id-TimeBasedHandoverInformation" },
  { id_DLDiscarding, "id-DLDiscarding" },
  { id_PDUsetQoSParameters, "id-PDUsetQoSParameters" },
  { id_PDUSetbasedHandlingIndicator, "id-PDUSetbasedHandlingIndicator" },
  { id_N6JitterInformation, "id-N6JitterInformation" },
  { id_ECNMarkingorCongestionInformationReportingRequest, "id-ECNMarkingorCongestionInformationReportingRequest" },
  { id_ECNMarkingorCongestionInformationReportingStatus, "id-ECNMarkingorCongestionInformationReportingStatus" },
  { id_ERedCapIndication, "id-ERedCapIndication" },
  { id_XrDeviceWith2Rx, "id-XrDeviceWith2Rx" },
  { id_UserPlaneErrorIndicator, "id-UserPlaneErrorIndicator" },
  { id_SLPositioningRangingServiceInfo, "id-SLPositioningRangingServiceInfo" },
  { id_PDUSessionListMTCommHReq, "id-PDUSessionListMTCommHReq" },
  { id_MaximumDataBurstVolume, "id-MaximumDataBurstVolume" },
  { id_MN_only_MDT_collection, "id-MN-only-MDT-collection" },
  { id_MBS_NGUFailureIndication, "id-MBS-NGUFailureIndication" },
  { id_UserPlaneFailureIndication, "id-UserPlaneFailureIndication" },
  { id_UserPlaneFailureIndicationReport, "id-UserPlaneFailureIndicationReport" },
  { id_SourceSN_to_TargetSN_QMCInfo, "id-SourceSN-to-TargetSN-QMCInfo" },
  { id_QoERVQoEReportingPaths, "id-QoERVQoEReportingPaths" },
  { 0, NULL }
};

static value_string_ext ngap_ProtocolIE_ID_vals_ext = VALUE_STRING_EXT_INIT(ngap_ProtocolIE_ID_vals);


static int
dissect_ngap_ProtocolIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, &ngap_data->protocol_ie_id, false);



  if (tree) {
    proto_item_append_text(proto_item_get_parent_nth(actx->created_item, 2), ": %s",
                           val_to_str_ext(ngap_data->protocol_ie_id, &ngap_ProtocolIE_ID_vals_ext, "unknown (%d)"));
  }
  return offset;
}


static const value_string ngap_TriggeringMessage_vals[] = {
  {   0, "initiating-message" },
  {   1, "successful-outcome" },
  {   2, "unsuccessful-outcome" },
  { 0, NULL }
};


static int
dissect_ngap_TriggeringMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_ngap_T_ie_field_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolIEFieldValue);

  return offset;
}


static const per_sequence_t ProtocolIE_Field_sequence[] = {
  { &hf_ngap_id             , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_ProtocolIE_ID },
  { &hf_ngap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_Criticality },
  { &hf_ngap_ie_field_value , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_T_ie_field_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ProtocolIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ProtocolIE_Field, ProtocolIE_Field_sequence);

  return offset;
}


static const per_sequence_t ProtocolIE_Container_sequence_of[1] = {
  { &hf_ngap_ProtocolIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_ProtocolIE_Field },
};

static int
dissect_ngap_ProtocolIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_ProtocolIE_Container, ProtocolIE_Container_sequence_of,
                                                  0, maxProtocolIEs, false);

  return offset;
}



static int
dissect_ngap_ProtocolIE_SingleContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ngap_ProtocolIE_Field(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_ngap_T_extensionValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolExtensionFieldExtensionValue);

  return offset;
}


static const per_sequence_t ProtocolExtensionField_sequence[] = {
  { &hf_ngap_ext_id         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_ProtocolExtensionID },
  { &hf_ngap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_Criticality },
  { &hf_ngap_extensionValue , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_T_extensionValue },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ProtocolExtensionField(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ProtocolExtensionField, ProtocolExtensionField_sequence);

  return offset;
}


static const per_sequence_t ProtocolExtensionContainer_sequence_of[1] = {
  { &hf_ngap_ProtocolExtensionContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_ProtocolExtensionField },
};

static int
dissect_ngap_ProtocolExtensionContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_ProtocolExtensionContainer, ProtocolExtensionContainer_sequence_of,
                                                  1, maxProtocolExtensions, false);

  return offset;
}



static int
dissect_ngap_T_private_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t PrivateIE_Field_sequence[] = {
  { &hf_ngap_private_id     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PrivateIE_ID },
  { &hf_ngap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_Criticality },
  { &hf_ngap_private_value  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_T_private_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PrivateIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PrivateIE_Field, PrivateIE_Field_sequence);

  return offset;
}


static const per_sequence_t PrivateIE_Container_sequence_of[1] = {
  { &hf_ngap_PrivateIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PrivateIE_Field },
};

static int
dissect_ngap_PrivateIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PrivateIE_Container, PrivateIE_Container_sequence_of,
                                                  1, maxPrivateIEs, false);

  return offset;
}



static int
dissect_ngap_TransportLayerAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  int len;

  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 160, true, NULL, 0, &parameter_tvb, &len);

  if (!parameter_tvb)
    return offset;

  subtree = proto_item_add_subtree(actx->created_item, ett_ngap_TransportLayerAddress);
  if (len == 32) {
    /* IPv4 */
     proto_tree_add_item(subtree, hf_ngap_transportLayerAddressIPv4, parameter_tvb, 0, 4, ENC_BIG_ENDIAN);
  } else if (len == 128) {
    /* IPv6 */
     proto_tree_add_item(subtree, hf_ngap_transportLayerAddressIPv6, parameter_tvb, 0, 16, ENC_NA);
  } else if (len == 160) {
    /* IPv4 */
     proto_tree_add_item(subtree, hf_ngap_transportLayerAddressIPv4, parameter_tvb, 0, 4, ENC_BIG_ENDIAN);
    /* IPv6 */
     proto_tree_add_item(subtree, hf_ngap_transportLayerAddressIPv6, parameter_tvb, 4, 16, ENC_NA);
  }


  return offset;
}



static int
dissect_ngap_GTP_TEID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, false, NULL);

  return offset;
}


static const per_sequence_t GTPTunnel_sequence[] = {
  { &hf_ngap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TransportLayerAddress },
  { &hf_ngap_gTP_TEID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_GTP_TEID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_GTPTunnel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_GTPTunnel, GTPTunnel_sequence);

  return offset;
}


static const value_string ngap_UPTransportLayerInformation_vals[] = {
  {   0, "gTPTunnel" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t UPTransportLayerInformation_choice[] = {
  {   0, &hf_ngap_gTPTunnel      , ASN1_NO_EXTENSIONS     , dissect_ngap_GTPTunnel },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_UPTransportLayerInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_UPTransportLayerInformation, UPTransportLayerInformation_choice,
                                 NULL);

  return offset;
}



static int
dissect_ngap_QosFlowIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, true);

  return offset;
}


static const value_string ngap_DataForwardingAccepted_vals[] = {
  {   0, "data-forwarding-accepted" },
  { 0, NULL }
};


static int
dissect_ngap_DataForwardingAccepted(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t QosFlowItemWithDataForwarding_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_dataForwardingAccepted, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_DataForwardingAccepted },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowItemWithDataForwarding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowItemWithDataForwarding, QosFlowItemWithDataForwarding_sequence);

  return offset;
}


static const per_sequence_t QosFlowListWithDataForwarding_sequence_of[1] = {
  { &hf_ngap_QosFlowListWithDataForwarding_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowItemWithDataForwarding },
};

static int
dissect_ngap_QosFlowListWithDataForwarding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowListWithDataForwarding, QosFlowListWithDataForwarding_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const per_sequence_t AdditionalDLUPTNLInformationForHOItem_sequence[] = {
  { &hf_ngap_additionalDL_NGU_UP_TNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_additionalQosFlowSetupResponseList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowListWithDataForwarding },
  { &hf_ngap_additionalDLForwardingUPTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AdditionalDLUPTNLInformationForHOItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AdditionalDLUPTNLInformationForHOItem, AdditionalDLUPTNLInformationForHOItem_sequence);

  return offset;
}


static const per_sequence_t AdditionalDLUPTNLInformationForHOList_sequence_of[1] = {
  { &hf_ngap_AdditionalDLUPTNLInformationForHOList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AdditionalDLUPTNLInformationForHOItem },
};

static int
dissect_ngap_AdditionalDLUPTNLInformationForHOList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AdditionalDLUPTNLInformationForHOList, AdditionalDLUPTNLInformationForHOList_sequence_of,
                                                  1, maxnoofMultiConnectivityMinusOne, false);

  return offset;
}


static const value_string ngap_AdditionalQosFlowInformation_vals[] = {
  {   0, "more-likely" },
  { 0, NULL }
};


static int
dissect_ngap_AdditionalQosFlowInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_AerialUEsubscriptionInformation_vals[] = {
  {   0, "allowed" },
  {   1, "not-allowed" },
  { 0, NULL }
};


static int
dissect_ngap_AerialUEsubscriptionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_BitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, UINT64_C(4000000000000), NULL, true);

  return offset;
}


static const per_sequence_t A2X_PC5_FlowBitRates_sequence[] = {
  { &hf_ngap_a2X_GuaranteedFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_a2X_MaximumFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_A2X_PC5_FlowBitRates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_A2X_PC5_FlowBitRates, A2X_PC5_FlowBitRates_sequence);

  return offset;
}



static int
dissect_ngap_INTEGER_0_255_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, true);

  return offset;
}


static const value_string ngap_T_a2X_Range_vals[] = {
  {   0, "m50" },
  {   1, "m80" },
  {   2, "m180" },
  {   3, "m200" },
  {   4, "m350" },
  {   5, "m400" },
  {   6, "m500" },
  {   7, "m700" },
  {   8, "m1000" },
  { 0, NULL }
};


static int
dissect_ngap_T_a2X_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t A2X_PC5_QoS_Flow_Item_sequence[] = {
  { &hf_ngap_a2X_PQI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_255_ },
  { &hf_ngap_a2X_PC5_FlowBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_A2X_PC5_FlowBitRates },
  { &hf_ngap_a2X_Range      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_a2X_Range },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_A2X_PC5_QoS_Flow_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_A2X_PC5_QoS_Flow_Item, A2X_PC5_QoS_Flow_Item_sequence);

  return offset;
}


static const per_sequence_t A2X_PC5_QoS_Flow_List_sequence_of[1] = {
  { &hf_ngap_A2X_PC5_QoS_Flow_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_A2X_PC5_QoS_Flow_Item },
};

static int
dissect_ngap_A2X_PC5_QoS_Flow_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_A2X_PC5_QoS_Flow_List, A2X_PC5_QoS_Flow_List_sequence_of,
                                                  1, maxnoofPC5QoSFlows, false);

  return offset;
}


static const per_sequence_t A2X_PC5_QoS_Parameters_sequence[] = {
  { &hf_ngap_a2X_PC5_QoS_Flow_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_A2X_PC5_QoS_Flow_List },
  { &hf_ngap_a2X_PC5_LinkAggregateBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BitRate },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_A2X_PC5_QoS_Parameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_A2X_PC5_QoS_Parameters, A2X_PC5_QoS_Parameters_sequence);

  return offset;
}



static int
dissect_ngap_LocationReportingReferenceID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, true);

  return offset;
}


static const per_sequence_t AdditionalCancelledlocationReportingReferenceIDItem_sequence[] = {
  { &hf_ngap_locationReportingReferenceIDToBeCancelled, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_LocationReportingReferenceID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AdditionalCancelledlocationReportingReferenceIDItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AdditionalCancelledlocationReportingReferenceIDItem, AdditionalCancelledlocationReportingReferenceIDItem_sequence);

  return offset;
}


static const per_sequence_t AdditionalCancelledlocationReportingReferenceIDList_sequence_of[1] = {
  { &hf_ngap_AdditionalCancelledlocationReportingReferenceIDList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AdditionalCancelledlocationReportingReferenceIDItem },
};

static int
dissect_ngap_AdditionalCancelledlocationReportingReferenceIDList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AdditionalCancelledlocationReportingReferenceIDList, AdditionalCancelledlocationReportingReferenceIDList_sequence_of,
                                                  1, maxnoofAoIMinusOne, false);

  return offset;
}



static int
dissect_ngap_PriorityLevelARP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 15U, NULL, false);

  return offset;
}


static const value_string ngap_Pre_emptionCapability_vals[] = {
  {   0, "shall-not-trigger-pre-emption" },
  {   1, "may-trigger-pre-emption" },
  { 0, NULL }
};


static int
dissect_ngap_Pre_emptionCapability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_Pre_emptionVulnerability_vals[] = {
  {   0, "not-pre-emptable" },
  {   1, "pre-emptable" },
  { 0, NULL }
};


static int
dissect_ngap_Pre_emptionVulnerability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t AllocationAndRetentionPriority_sequence[] = {
  { &hf_ngap_priorityLevelARP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PriorityLevelARP },
  { &hf_ngap_pre_emptionCapability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Pre_emptionCapability },
  { &hf_ngap_pre_emptionVulnerability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Pre_emptionVulnerability },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AllocationAndRetentionPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AllocationAndRetentionPriority, AllocationAndRetentionPriority_sequence);

  return offset;
}



static int
dissect_ngap_CAG_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t Allowed_CAG_List_per_PLMN_sequence_of[1] = {
  { &hf_ngap_Allowed_CAG_List_per_PLMN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CAG_ID },
};

static int
dissect_ngap_Allowed_CAG_List_per_PLMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_Allowed_CAG_List_per_PLMN, Allowed_CAG_List_per_PLMN_sequence_of,
                                                  1, maxnoofAllowedCAGsperPLMN, false);

  return offset;
}



static int
dissect_ngap_SST(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 1, false, NULL);

  return offset;
}



static int
dissect_ngap_SD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, false, NULL);

  return offset;
}


static const per_sequence_t S_NSSAI_sequence[] = {
  { &hf_ngap_sST            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SST },
  { &hf_ngap_sD             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_SD },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_S_NSSAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_S_NSSAI, S_NSSAI_sequence);

  return offset;
}


static const per_sequence_t AllowedNSSAI_Item_sequence[] = {
  { &hf_ngap_s_NSSAI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_S_NSSAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AllowedNSSAI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AllowedNSSAI_Item, AllowedNSSAI_Item_sequence);

  return offset;
}


static const per_sequence_t AllowedNSSAI_sequence_of[1] = {
  { &hf_ngap_AllowedNSSAI_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AllowedNSSAI_Item },
};

static int
dissect_ngap_AllowedNSSAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AllowedNSSAI, AllowedNSSAI_sequence_of,
                                                  1, maxnoofAllowedS_NSSAIs, false);

  return offset;
}



static int
dissect_ngap_PLMNIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  e212_number_type_t number_type = ngap_data->number_type;
  ngap_data->number_type = E212_NONE;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_ngap_PLMNIdentity);
    dissect_e212_mcc_mnc(parameter_tvb, actx->pinfo, subtree, 0, number_type, false);
    if (ngap_data->supported_ta) {
      uint32_t plmn = tvb_get_ntoh24(parameter_tvb, 0);
      wmem_array_append_one(ngap_data->supported_ta->plmn, plmn);
    } else if (ngap_data->tai) {
      ngap_data->tai->plmn = tvb_get_ntoh24(parameter_tvb, 0);
    }
  }


  return offset;
}


static const value_string ngap_T_pNI_NPN_restricted_vals[] = {
  {   0, "restricted" },
  {   1, "not-restricted" },
  { 0, NULL }
};


static int
dissect_ngap_T_pNI_NPN_restricted(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t Allowed_PNI_NPN_Item_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_pNI_NPN_restricted, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pNI_NPN_restricted },
  { &hf_ngap_allowed_CAG_List_per_PLMN, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Allowed_CAG_List_per_PLMN },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_Allowed_PNI_NPN_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_Allowed_PNI_NPN_Item, Allowed_PNI_NPN_Item_sequence);

  return offset;
}


static const per_sequence_t Allowed_PNI_NPN_List_sequence_of[1] = {
  { &hf_ngap_Allowed_PNI_NPN_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_Allowed_PNI_NPN_Item },
};

static int
dissect_ngap_Allowed_PNI_NPN_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_Allowed_PNI_NPN_List, Allowed_PNI_NPN_List_sequence_of,
                                                  1, maxnoofEPLMNsPlusOne, false);

  return offset;
}



static int
dissect_ngap_TAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       3, 3, false, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 3, ENC_BIG_ENDIAN);
    if (ngap_data->supported_ta) {
      ngap_data->supported_ta->tac = tvb_get_ntoh24(parameter_tvb, 0);
    } else if (ngap_data->tai) {
      ngap_data->tai->tac = tvb_get_ntoh24(parameter_tvb, 0);
    }
  }


  return offset;
}


static const per_sequence_t AllowedTACs_sequence_of[1] = {
  { &hf_ngap_AllowedTACs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAC },
};

static int
dissect_ngap_AllowedTACs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AllowedTACs, AllowedTACs_sequence_of,
                                                  1, maxnoofAllowedAreas, false);

  return offset;
}



static int
dissect_ngap_AlternativeQoSParaSetIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  if (ngap_data->is_qos_flow_notify) {
    return dissect_ngap_AlternativeQoSParaSetNotifyIndex(tvb, offset, actx, tree, hf_index);
  }

  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, true);

  return offset;
}



static int
dissect_ngap_AlternativeQoSParaSetNotifyIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8U, NULL, true);

  return offset;
}



static int
dissect_ngap_PacketDelayBudget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, true);

  return offset;
}



static int
dissect_ngap_INTEGER_0_9_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, true);

  return offset;
}


static const per_sequence_t PacketErrorRate_sequence[] = {
  { &hf_ngap_pERScalar      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_9_ },
  { &hf_ngap_pERExponent    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_9_ },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PacketErrorRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PacketErrorRate, PacketErrorRate_sequence);

  return offset;
}


static const per_sequence_t AlternativeQoSParaSetItem_sequence[] = {
  { &hf_ngap_alternativeQoSParaSetIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_AlternativeQoSParaSetIndex },
  { &hf_ngap_guaranteedFlowBitRateDL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BitRate },
  { &hf_ngap_guaranteedFlowBitRateUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BitRate },
  { &hf_ngap_packetDelayBudget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PacketDelayBudget },
  { &hf_ngap_packetErrorRate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PacketErrorRate },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AlternativeQoSParaSetItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AlternativeQoSParaSetItem, AlternativeQoSParaSetItem_sequence);

  return offset;
}


static const per_sequence_t AlternativeQoSParaSetList_sequence_of[1] = {
  { &hf_ngap_AlternativeQoSParaSetList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AlternativeQoSParaSetItem },
};

static int
dissect_ngap_AlternativeQoSParaSetList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AlternativeQoSParaSetList, AlternativeQoSParaSetList_sequence_of,
                                                  1, maxnoofQosParaSets, false);

  return offset;
}



static int
dissect_ngap_AssistanceInformationQoE_Meas(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, true);

  return offset;
}



static int
dissect_ngap_AMFName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_PrintableString(tvb, offset, actx, tree, hf_index,
                                          1, 150, true,
                                          NULL);

  return offset;
}



static int
dissect_ngap_AMFNameVisibleString(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          1, 150, true,
                                          NULL);

  return offset;
}



static int
dissect_ngap_AMFNameUTF8String(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 150, true);

  return offset;
}



static int
dissect_ngap_BIT_STRING_SIZE_22_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     22, 32, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string ngap_GNB_ID_vals[] = {
  {   0, "gNB-ID" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t GNB_ID_choice[] = {
  {   0, &hf_ngap_gNB_ID         , ASN1_NO_EXTENSIONS     , dissect_ngap_BIT_STRING_SIZE_22_32 },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_GNB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_GNB_ID, GNB_ID_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GlobalGNB_ID_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_globalGNB_ID_gNB_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_GNB_ID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_GlobalGNB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_GlobalGNB_ID, GlobalGNB_ID_sequence);

  return offset;
}



static int
dissect_ngap_BIT_STRING_SIZE_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     20, 20, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_ngap_BIT_STRING_SIZE_18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     18, 18, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_ngap_BIT_STRING_SIZE_21(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     21, 21, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string ngap_NgENB_ID_vals[] = {
  {   0, "macroNgENB-ID" },
  {   1, "shortMacroNgENB-ID" },
  {   2, "longMacroNgENB-ID" },
  {   3, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t NgENB_ID_choice[] = {
  {   0, &hf_ngap_macroNgENB_ID  , ASN1_NO_EXTENSIONS     , dissect_ngap_BIT_STRING_SIZE_20 },
  {   1, &hf_ngap_shortMacroNgENB_ID, ASN1_NO_EXTENSIONS     , dissect_ngap_BIT_STRING_SIZE_18 },
  {   2, &hf_ngap_longMacroNgENB_ID, ASN1_NO_EXTENSIONS     , dissect_ngap_BIT_STRING_SIZE_21 },
  {   3, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_NgENB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_NgENB_ID, NgENB_ID_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GlobalNgENB_ID_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_ngENB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NgENB_ID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_GlobalNgENB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_GlobalNgENB_ID, GlobalNgENB_ID_sequence);

  return offset;
}



static int
dissect_ngap_BIT_STRING_SIZE_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string ngap_N3IWF_ID_vals[] = {
  {   0, "n3IWF-ID" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t N3IWF_ID_choice[] = {
  {   0, &hf_ngap_n3IWF_ID       , ASN1_NO_EXTENSIONS     , dissect_ngap_BIT_STRING_SIZE_16 },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_N3IWF_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_N3IWF_ID, N3IWF_ID_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GlobalN3IWF_ID_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_globalN3IWF_ID_n3IWF_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_N3IWF_ID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_GlobalN3IWF_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_GlobalN3IWF_ID, GlobalN3IWF_ID_sequence);

  return offset;
}


static const value_string ngap_GlobalRANNodeID_vals[] = {
  { globalGNB_ID, "globalGNB-ID" },
  { globalNgENB_ID, "globalNgENB-ID" },
  { globalN3IWF_ID, "globalN3IWF-ID" },
  { choice_Extensions, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t GlobalRANNodeID_choice[] = {
  { globalGNB_ID, &hf_ngap_globalGNB_ID   , ASN1_NO_EXTENSIONS     , dissect_ngap_GlobalGNB_ID },
  { globalNgENB_ID, &hf_ngap_globalNgENB_ID , ASN1_NO_EXTENSIONS     , dissect_ngap_GlobalNgENB_ID },
  { globalN3IWF_ID, &hf_ngap_globalN3IWF_ID , ASN1_NO_EXTENSIONS     , dissect_ngap_GlobalN3IWF_ID },
  { choice_Extensions, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_GlobalRANNodeID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  int value;
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);

  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_GlobalRANNodeID, GlobalRANNodeID_choice,
                                 &value);

  if (ngap_data->ngap_conv && ngap_data->procedure_code == id_NGSetup) {
    if (addresses_equal(&actx->pinfo->src, &ngap_data->ngap_conv->addr_a) &&
        actx->pinfo->srcport == ngap_data->ngap_conv->port_a) {
      ngap_data->ngap_conv->ranmode_id_a = (GlobalRANNodeID_enum)value;
    } else if (addresses_equal(&actx->pinfo->src, &ngap_data->ngap_conv->addr_b) &&
               actx->pinfo->srcport == ngap_data->ngap_conv->port_b) {
      ngap_data->ngap_conv->ranmode_id_b = (GlobalRANNodeID_enum)value;
    }
  }


  return offset;
}


static const per_sequence_t TAI_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_tAC            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAC },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  ngap_data->number_type = E212_5GSTAI;
  ngap_data->tai = wmem_new0(actx->pinfo->pool, struct ngap_tai);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TAI, TAI_sequence);

  if (!PINFO_FD_VISITED(actx->pinfo) && ngap_data->ngap_conv &&
      (ngap_data->message_type == INITIATING_MESSAGE) &&
      (ngap_data->procedure_code == id_InitialUEMessage)) {
    uint64_t key = (ngap_data->tai->plmn << 24) | ngap_data->tai->tac;

    if (wmem_map_lookup(ngap_data->ngap_conv->nbiot_ta, &key)) {
      wmem_tree_key_t tree_key[3];
      uint32_t *id = wmem_new(wmem_file_scope(), uint32_t);

      *id = ngap_data->ran_ue_ngap_id;
      tree_key[0].length = 1;
      tree_key[0].key = id;
      tree_key[1].length = 1;
      tree_key[1].key = &actx->pinfo->num;
      tree_key[2].length = 0;
      tree_key[2].key = NULL;
      wmem_tree_insert32_array(ngap_data->ngap_conv->nbiot_ran_ue_ngap_id, tree_key, id);
    }
  }


  return offset;
}


static const value_string ngap_AMFPagingTarget_vals[] = {
  {   0, "globalRANNodeID" },
  {   1, "tAI" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t AMFPagingTarget_choice[] = {
  {   0, &hf_ngap_globalRANNodeID, ASN1_NO_EXTENSIONS     , dissect_ngap_GlobalRANNodeID },
  {   1, &hf_ngap_tAI            , ASN1_NO_EXTENSIONS     , dissect_ngap_TAI },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_AMFPagingTarget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_AMFPagingTarget, AMFPagingTarget_choice,
                                 NULL);

  return offset;
}



static int
dissect_ngap_AMFPointer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 6, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_ngap_AMFRegionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_ngap_AMFSetID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string ngap_CPTransportLayerInformation_vals[] = {
  {   0, "endpointIPAddress" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t CPTransportLayerInformation_choice[] = {
  {   0, &hf_ngap_endpointIPAddress, ASN1_NO_EXTENSIONS     , dissect_ngap_TransportLayerAddress },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_CPTransportLayerInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_CPTransportLayerInformation, CPTransportLayerInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t AMF_TNLAssociationSetupItem_sequence[] = {
  { &hf_ngap_aMF_TNLAssociationAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CPTransportLayerInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AMF_TNLAssociationSetupItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AMF_TNLAssociationSetupItem, AMF_TNLAssociationSetupItem_sequence);

  return offset;
}


static const per_sequence_t AMF_TNLAssociationSetupList_sequence_of[1] = {
  { &hf_ngap_AMF_TNLAssociationSetupList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AMF_TNLAssociationSetupItem },
};

static int
dissect_ngap_AMF_TNLAssociationSetupList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AMF_TNLAssociationSetupList, AMF_TNLAssociationSetupList_sequence_of,
                                                  1, maxnoofTNLAssociations, false);

  return offset;
}


static const value_string ngap_TNLAssociationUsage_vals[] = {
  {   0, "ue" },
  {   1, "non-ue" },
  {   2, "both" },
  { 0, NULL }
};


static int
dissect_ngap_TNLAssociationUsage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_TNLAddressWeightFactor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t AMF_TNLAssociationToAddItem_sequence[] = {
  { &hf_ngap_aMF_TNLAssociationAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CPTransportLayerInformation },
  { &hf_ngap_tNLAssociationUsage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_TNLAssociationUsage },
  { &hf_ngap_tNLAddressWeightFactor, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TNLAddressWeightFactor },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AMF_TNLAssociationToAddItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AMF_TNLAssociationToAddItem, AMF_TNLAssociationToAddItem_sequence);

  return offset;
}


static const per_sequence_t AMF_TNLAssociationToAddList_sequence_of[1] = {
  { &hf_ngap_AMF_TNLAssociationToAddList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AMF_TNLAssociationToAddItem },
};

static int
dissect_ngap_AMF_TNLAssociationToAddList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AMF_TNLAssociationToAddList, AMF_TNLAssociationToAddList_sequence_of,
                                                  1, maxnoofTNLAssociations, false);

  return offset;
}


static const per_sequence_t AMF_TNLAssociationToRemoveItem_sequence[] = {
  { &hf_ngap_aMF_TNLAssociationAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CPTransportLayerInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AMF_TNLAssociationToRemoveItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AMF_TNLAssociationToRemoveItem, AMF_TNLAssociationToRemoveItem_sequence);

  return offset;
}


static const per_sequence_t AMF_TNLAssociationToRemoveList_sequence_of[1] = {
  { &hf_ngap_AMF_TNLAssociationToRemoveList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AMF_TNLAssociationToRemoveItem },
};

static int
dissect_ngap_AMF_TNLAssociationToRemoveList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AMF_TNLAssociationToRemoveList, AMF_TNLAssociationToRemoveList_sequence_of,
                                                  1, maxnoofTNLAssociations, false);

  return offset;
}


static const per_sequence_t AMF_TNLAssociationToUpdateItem_sequence[] = {
  { &hf_ngap_aMF_TNLAssociationAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CPTransportLayerInformation },
  { &hf_ngap_tNLAssociationUsage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_TNLAssociationUsage },
  { &hf_ngap_tNLAddressWeightFactor, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_TNLAddressWeightFactor },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AMF_TNLAssociationToUpdateItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AMF_TNLAssociationToUpdateItem, AMF_TNLAssociationToUpdateItem_sequence);

  return offset;
}


static const per_sequence_t AMF_TNLAssociationToUpdateList_sequence_of[1] = {
  { &hf_ngap_AMF_TNLAssociationToUpdateList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AMF_TNLAssociationToUpdateItem },
};

static int
dissect_ngap_AMF_TNLAssociationToUpdateList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AMF_TNLAssociationToUpdateList, AMF_TNLAssociationToUpdateList_sequence_of,
                                                  1, maxnoofTNLAssociations, false);

  return offset;
}



static int
dissect_ngap_AMF_UE_NGAP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, UINT64_C(1099511627775), NULL, false);

  return offset;
}


static const per_sequence_t AreaOfInterestTAIItem_sequence[] = {
  { &hf_ngap_tAI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AreaOfInterestTAIItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AreaOfInterestTAIItem, AreaOfInterestTAIItem_sequence);

  return offset;
}


static const per_sequence_t AreaOfInterestTAIList_sequence_of[1] = {
  { &hf_ngap_AreaOfInterestTAIList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AreaOfInterestTAIItem },
};

static int
dissect_ngap_AreaOfInterestTAIList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AreaOfInterestTAIList, AreaOfInterestTAIList_sequence_of,
                                                  1, maxnoofTAIinAoI, false);

  return offset;
}



static int
dissect_ngap_NRCellIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *cell_id_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     36, 36, false, NULL, 0, &cell_id_tvb, NULL);

  if (cell_id_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, cell_id_tvb, 0, 5, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t NR_CGI_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_nRCellIdentity , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NRCellIdentity },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NR_CGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  ngap_data->number_type = E212_NRCGI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NR_CGI, NR_CGI_sequence);



  return offset;
}



static int
dissect_ngap_EUTRACellIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *cell_id_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     28, 28, false, NULL, 0, &cell_id_tvb, NULL);

  if (cell_id_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, cell_id_tvb, 0, 4, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t EUTRA_CGI_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_eUTRACellIdentity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRACellIdentity },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EUTRA_CGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  ngap_data->number_type = E212_ECGI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EUTRA_CGI, EUTRA_CGI_sequence);



  return offset;
}


static const value_string ngap_NGRAN_CGI_vals[] = {
  {   0, "nR-CGI" },
  {   1, "eUTRA-CGI" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t NGRAN_CGI_choice[] = {
  {   0, &hf_ngap_nR_CGI         , ASN1_NO_EXTENSIONS     , dissect_ngap_NR_CGI },
  {   1, &hf_ngap_eUTRA_CGI      , ASN1_NO_EXTENSIONS     , dissect_ngap_EUTRA_CGI },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_NGRAN_CGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_NGRAN_CGI, NGRAN_CGI_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t AreaOfInterestCellItem_sequence[] = {
  { &hf_ngap_nGRAN_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AreaOfInterestCellItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AreaOfInterestCellItem, AreaOfInterestCellItem_sequence);

  return offset;
}


static const per_sequence_t AreaOfInterestCellList_sequence_of[1] = {
  { &hf_ngap_AreaOfInterestCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AreaOfInterestCellItem },
};

static int
dissect_ngap_AreaOfInterestCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AreaOfInterestCellList, AreaOfInterestCellList_sequence_of,
                                                  1, maxnoofCellinAoI, false);

  return offset;
}


static const per_sequence_t AreaOfInterestRANNodeItem_sequence[] = {
  { &hf_ngap_globalRANNodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_GlobalRANNodeID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AreaOfInterestRANNodeItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AreaOfInterestRANNodeItem, AreaOfInterestRANNodeItem_sequence);

  return offset;
}


static const per_sequence_t AreaOfInterestRANNodeList_sequence_of[1] = {
  { &hf_ngap_AreaOfInterestRANNodeList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AreaOfInterestRANNodeItem },
};

static int
dissect_ngap_AreaOfInterestRANNodeList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AreaOfInterestRANNodeList, AreaOfInterestRANNodeList_sequence_of,
                                                  1, maxnoofRANNodeinAoI, false);

  return offset;
}


static const per_sequence_t AreaOfInterest_sequence[] = {
  { &hf_ngap_areaOfInterestTAIList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AreaOfInterestTAIList },
  { &hf_ngap_areaOfInterestCellList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AreaOfInterestCellList },
  { &hf_ngap_areaOfInterestRANNodeList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AreaOfInterestRANNodeList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AreaOfInterest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AreaOfInterest, AreaOfInterest_sequence);

  return offset;
}


static const per_sequence_t AreaOfInterestItem_sequence[] = {
  { &hf_ngap_areaOfInterest , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_AreaOfInterest },
  { &hf_ngap_locationReportingReferenceID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_LocationReportingReferenceID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AreaOfInterestItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AreaOfInterestItem, AreaOfInterestItem_sequence);

  return offset;
}


static const per_sequence_t AreaOfInterestList_sequence_of[1] = {
  { &hf_ngap_AreaOfInterestList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AreaOfInterestItem },
};

static int
dissect_ngap_AreaOfInterestList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AreaOfInterestList, AreaOfInterestList_sequence_of,
                                                  1, maxnoofAoI, false);

  return offset;
}



static int
dissect_ngap_INTEGER_0_4095(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, false);

  return offset;
}


static const per_sequence_t RecommendedCellItem_sequence[] = {
  { &hf_ngap_nGRAN_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
  { &hf_ngap_timeStayedInCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_INTEGER_0_4095 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RecommendedCellItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RecommendedCellItem, RecommendedCellItem_sequence);

  return offset;
}


static const per_sequence_t RecommendedCellList_sequence_of[1] = {
  { &hf_ngap_RecommendedCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_RecommendedCellItem },
};

static int
dissect_ngap_RecommendedCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_RecommendedCellList, RecommendedCellList_sequence_of,
                                                  1, maxnoofRecommendedCells, false);

  return offset;
}


static const per_sequence_t RecommendedCellsForPaging_sequence[] = {
  { &hf_ngap_recommendedCellList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_RecommendedCellList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RecommendedCellsForPaging(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RecommendedCellsForPaging, RecommendedCellsForPaging_sequence);

  return offset;
}


static const per_sequence_t AssistanceDataForRecommendedCells_sequence[] = {
  { &hf_ngap_recommendedCellsForPaging, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_RecommendedCellsForPaging },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AssistanceDataForRecommendedCells(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AssistanceDataForRecommendedCells, AssistanceDataForRecommendedCells_sequence);

  return offset;
}



static int
dissect_ngap_PagingAttemptCount(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, true);

  return offset;
}



static int
dissect_ngap_IntendedNumberOfPagingAttempts(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, true);

  return offset;
}


static const value_string ngap_NextPagingAreaScope_vals[] = {
  {   0, "same" },
  {   1, "changed" },
  { 0, NULL }
};


static int
dissect_ngap_NextPagingAreaScope(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PagingAttemptInformation_sequence[] = {
  { &hf_ngap_pagingAttemptCount, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PagingAttemptCount },
  { &hf_ngap_intendedNumberOfPagingAttempts, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_IntendedNumberOfPagingAttempts },
  { &hf_ngap_nextPagingAreaScope, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NextPagingAreaScope },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PagingAttemptInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PagingAttemptInformation, PagingAttemptInformation_sequence);

  return offset;
}


static const per_sequence_t AssistanceDataForPaging_sequence[] = {
  { &hf_ngap_assistanceDataForRecommendedCells, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AssistanceDataForRecommendedCells },
  { &hf_ngap_pagingAttemptInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PagingAttemptInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AssistanceDataForPaging(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AssistanceDataForPaging, AssistanceDataForPaging_sequence);

  return offset;
}


static const per_sequence_t AssociatedMBSQosFlowSetupRequestItem_sequence[] = {
  { &hf_ngap_mBS_QosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_associatedUnicastQosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AssociatedMBSQosFlowSetupRequestItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AssociatedMBSQosFlowSetupRequestItem, AssociatedMBSQosFlowSetupRequestItem_sequence);

  return offset;
}


static const per_sequence_t AssociatedMBSQosFlowSetupRequestList_sequence_of[1] = {
  { &hf_ngap_AssociatedMBSQosFlowSetupRequestList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AssociatedMBSQosFlowSetupRequestItem },
};

static int
dissect_ngap_AssociatedMBSQosFlowSetupRequestList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AssociatedMBSQosFlowSetupRequestList, AssociatedMBSQosFlowSetupRequestList_sequence_of,
                                                  1, maxnoofMBSQoSFlows, false);

  return offset;
}


static const per_sequence_t AssociatedMBSQosFlowSetuporModifyRequestItem_sequence[] = {
  { &hf_ngap_mBS_QosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_associatedUnicastQosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AssociatedMBSQosFlowSetuporModifyRequestItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AssociatedMBSQosFlowSetuporModifyRequestItem, AssociatedMBSQosFlowSetuporModifyRequestItem_sequence);

  return offset;
}


static const per_sequence_t AssociatedMBSQosFlowSetuporModifyRequestList_sequence_of[1] = {
  { &hf_ngap_AssociatedMBSQosFlowSetuporModifyRequestList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AssociatedMBSQosFlowSetuporModifyRequestItem },
};

static int
dissect_ngap_AssociatedMBSQosFlowSetuporModifyRequestList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AssociatedMBSQosFlowSetuporModifyRequestList, AssociatedMBSQosFlowSetuporModifyRequestList_sequence_of,
                                                  1, maxnoofMBSQoSFlows, false);

  return offset;
}


static const value_string ngap_T_qosFlowMappingIndication_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  { 0, NULL }
};


static int
dissect_ngap_T_qosFlowMappingIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t AssociatedQosFlowItem_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_qosFlowMappingIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_qosFlowMappingIndication },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AssociatedQosFlowItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AssociatedQosFlowItem, AssociatedQosFlowItem_sequence);

  return offset;
}


static const per_sequence_t AssociatedQosFlowList_sequence_of[1] = {
  { &hf_ngap_AssociatedQosFlowList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AssociatedQosFlowItem },
};

static int
dissect_ngap_AssociatedQosFlowList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AssociatedQosFlowList, AssociatedQosFlowList_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}



static int
dissect_ngap_AssociatedSessionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}


static const value_string ngap_AuthenticatedIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_AuthenticatedIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_AveragingWindow(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, true);

  return offset;
}


static const per_sequence_t CellIdListforMDT_NR_sequence_of[1] = {
  { &hf_ngap_CellIdListforMDT_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NR_CGI },
};

static int
dissect_ngap_CellIdListforMDT_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CellIdListforMDT_NR, CellIdListforMDT_NR_sequence_of,
                                                  1, maxnoofCellIDforMDT, false);

  return offset;
}


static const per_sequence_t CellBasedMDT_NR_sequence[] = {
  { &hf_ngap_cellIdListforMDT, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CellIdListforMDT_NR },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CellBasedMDT_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CellBasedMDT_NR, CellBasedMDT_NR_sequence);

  return offset;
}


static const per_sequence_t TAListforMDT_sequence_of[1] = {
  { &hf_ngap_TAListforMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAC },
};

static int
dissect_ngap_TAListforMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_TAListforMDT, TAListforMDT_sequence_of,
                                                  1, maxnoofTAforMDT, false);

  return offset;
}


static const per_sequence_t TABasedMDT_sequence[] = {
  { &hf_ngap_tAListforMDT   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAListforMDT },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TABasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TABasedMDT, TABasedMDT_sequence);

  return offset;
}



static int
dissect_ngap_NULL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t TAIListforMDT_sequence_of[1] = {
  { &hf_ngap_TAIListforMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
};

static int
dissect_ngap_TAIListforMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_TAIListforMDT, TAIListforMDT_sequence_of,
                                                  1, maxnoofTAforMDT, false);

  return offset;
}


static const per_sequence_t TAIBasedMDT_sequence[] = {
  { &hf_ngap_tAIListforMDT  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAIListforMDT },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TAIBasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TAIBasedMDT, TAIBasedMDT_sequence);

  return offset;
}


static const value_string ngap_AreaScopeOfMDT_NR_vals[] = {
  {   0, "cellBased" },
  {   1, "tABased" },
  {   2, "pLMNWide" },
  {   3, "tAIBased" },
  {   4, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t AreaScopeOfMDT_NR_choice[] = {
  {   0, &hf_ngap_cellBased      , ASN1_NO_EXTENSIONS     , dissect_ngap_CellBasedMDT_NR },
  {   1, &hf_ngap_tABased        , ASN1_NO_EXTENSIONS     , dissect_ngap_TABasedMDT },
  {   2, &hf_ngap_pLMNWide       , ASN1_NO_EXTENSIONS     , dissect_ngap_NULL },
  {   3, &hf_ngap_tAIBased       , ASN1_NO_EXTENSIONS     , dissect_ngap_TAIBasedMDT },
  {   4, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_AreaScopeOfMDT_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_AreaScopeOfMDT_NR, AreaScopeOfMDT_NR_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CellIdListforMDT_EUTRA_sequence_of[1] = {
  { &hf_ngap_CellIdListforMDT_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
};

static int
dissect_ngap_CellIdListforMDT_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CellIdListforMDT_EUTRA, CellIdListforMDT_EUTRA_sequence_of,
                                                  1, maxnoofCellIDforMDT, false);

  return offset;
}


static const per_sequence_t CellBasedMDT_EUTRA_sequence[] = {
  { &hf_ngap_cellIdListforMDT_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CellIdListforMDT_EUTRA },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CellBasedMDT_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CellBasedMDT_EUTRA, CellBasedMDT_EUTRA_sequence);

  return offset;
}


static const value_string ngap_AreaScopeOfMDT_EUTRA_vals[] = {
  {   0, "cellBased" },
  {   1, "tABased" },
  {   2, "pLMNWide" },
  {   3, "tAIBased" },
  {   4, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t AreaScopeOfMDT_EUTRA_choice[] = {
  {   0, &hf_ngap_cellBased_01   , ASN1_NO_EXTENSIONS     , dissect_ngap_CellBasedMDT_EUTRA },
  {   1, &hf_ngap_tABased        , ASN1_NO_EXTENSIONS     , dissect_ngap_TABasedMDT },
  {   2, &hf_ngap_pLMNWide       , ASN1_NO_EXTENSIONS     , dissect_ngap_NULL },
  {   3, &hf_ngap_tAIBased       , ASN1_NO_EXTENSIONS     , dissect_ngap_TAIBasedMDT },
  {   4, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_AreaScopeOfMDT_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_AreaScopeOfMDT_EUTRA, AreaScopeOfMDT_EUTRA_choice,
                                 NULL);

  return offset;
}



static int
dissect_ngap_NRARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNRARFCN, NULL, false);

  return offset;
}



static int
dissect_ngap_NRFrequencyBand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, true);

  return offset;
}


static const per_sequence_t NRFrequencyBandItem_sequence[] = {
  { &hf_ngap_nr_frequency_band, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NRFrequencyBand },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NRFrequencyBandItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NRFrequencyBandItem, NRFrequencyBandItem_sequence);

  return offset;
}


static const per_sequence_t NRFrequencyBand_List_sequence_of[1] = {
  { &hf_ngap_NRFrequencyBand_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NRFrequencyBandItem },
};

static int
dissect_ngap_NRFrequencyBand_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_NRFrequencyBand_List, NRFrequencyBand_List_sequence_of,
                                                  1, maxnoofNRCellBands, false);

  return offset;
}


static const per_sequence_t NRFrequencyInfo_sequence[] = {
  { &hf_ngap_nrARFCN        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NRARFCN },
  { &hf_ngap_frequencyBand_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NRFrequencyBand_List },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NRFrequencyInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NRFrequencyInfo, NRFrequencyInfo_sequence);

  return offset;
}



static int
dissect_ngap_NR_PCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1007U, NULL, true);

  return offset;
}


static const per_sequence_t PCIListForMDT_sequence_of[1] = {
  { &hf_ngap_PCIListForMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NR_PCI },
};

static int
dissect_ngap_PCIListForMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PCIListForMDT, PCIListForMDT_sequence_of,
                                                  1, maxnoofNeighPCIforMDT, false);

  return offset;
}


static const per_sequence_t AreaScopeOfNeighCellsItem_sequence[] = {
  { &hf_ngap_nrFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NRFrequencyInfo },
  { &hf_ngap_pciListForMDT  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PCIListForMDT },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AreaScopeOfNeighCellsItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AreaScopeOfNeighCellsItem, AreaScopeOfNeighCellsItem_sequence);

  return offset;
}


static const per_sequence_t AreaScopeOfNeighCellsList_sequence_of[1] = {
  { &hf_ngap_AreaScopeOfNeighCellsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_AreaScopeOfNeighCellsItem },
};

static int
dissect_ngap_AreaScopeOfNeighCellsList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AreaScopeOfNeighCellsList, AreaScopeOfNeighCellsList_sequence_of,
                                                  1, maxnoofFreqforMDT, false);

  return offset;
}


static const per_sequence_t CellIdListforQMC_sequence_of[1] = {
  { &hf_ngap_CellIdListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
};

static int
dissect_ngap_CellIdListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CellIdListforQMC, CellIdListforQMC_sequence_of,
                                                  1, maxnoofCellIDforQMC, false);

  return offset;
}


static const per_sequence_t CellBasedQMC_sequence[] = {
  { &hf_ngap_cellIdListforQMC, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CellIdListforQMC },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CellBasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CellBasedQMC, CellBasedQMC_sequence);

  return offset;
}


static const per_sequence_t TAListforQMC_sequence_of[1] = {
  { &hf_ngap_TAListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAC },
};

static int
dissect_ngap_TAListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_TAListforQMC, TAListforQMC_sequence_of,
                                                  1, maxnoofTAforQMC, false);

  return offset;
}


static const per_sequence_t TABasedQMC_sequence[] = {
  { &hf_ngap_tAListforQMC   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAListforQMC },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TABasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TABasedQMC, TABasedQMC_sequence);

  return offset;
}


static const per_sequence_t TAIListforQMC_sequence_of[1] = {
  { &hf_ngap_TAIListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
};

static int
dissect_ngap_TAIListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_TAIListforQMC, TAIListforQMC_sequence_of,
                                                  1, maxnoofTAforQMC, false);

  return offset;
}


static const per_sequence_t TAIBasedQMC_sequence[] = {
  { &hf_ngap_tAIListforQMC  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAIListforQMC },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TAIBasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TAIBasedQMC, TAIBasedQMC_sequence);

  return offset;
}


static const per_sequence_t PLMNListforQMC_sequence_of[1] = {
  { &hf_ngap_PLMNListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
};

static int
dissect_ngap_PLMNListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PLMNListforQMC, PLMNListforQMC_sequence_of,
                                                  1, maxnoofPLMNforQMC, false);

  return offset;
}


static const per_sequence_t PLMNAreaBasedQMC_sequence[] = {
  { &hf_ngap_plmnListforQMC , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNListforQMC },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PLMNAreaBasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PLMNAreaBasedQMC, PLMNAreaBasedQMC_sequence);

  return offset;
}


static const value_string ngap_AreaScopeOfQMC_vals[] = {
  {   0, "cellBased" },
  {   1, "tABased" },
  {   2, "tAIBased" },
  {   3, "pLMNAreaBased" },
  {   4, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t AreaScopeOfQMC_choice[] = {
  {   0, &hf_ngap_cellBased_02   , ASN1_NO_EXTENSIONS     , dissect_ngap_CellBasedQMC },
  {   1, &hf_ngap_tABased_01     , ASN1_NO_EXTENSIONS     , dissect_ngap_TABasedQMC },
  {   2, &hf_ngap_tAIBased_01    , ASN1_NO_EXTENSIONS     , dissect_ngap_TAIBasedQMC },
  {   3, &hf_ngap_pLMNAreaBased  , ASN1_NO_EXTENSIONS     , dissect_ngap_PLMNAreaBasedQMC },
  {   4, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_AreaScopeOfQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_AreaScopeOfQMC, AreaScopeOfQMC_choice,
                                 NULL);

  return offset;
}


static const value_string ngap_T_applicationLayerBufferLevelList_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_applicationLayerBufferLevelList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_playoutDelayForMediaStartup_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_playoutDelayForMediaStartup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t AvailableRANVisibleQoEMetrics_sequence[] = {
  { &hf_ngap_applicationLayerBufferLevelList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_applicationLayerBufferLevelList },
  { &hf_ngap_playoutDelayForMediaStartup, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_playoutDelayForMediaStartup },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_AvailableRANVisibleQoEMetrics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_AvailableRANVisibleQoEMetrics, AvailableRANVisibleQoEMetrics_sequence);

  return offset;
}


static const value_string ngap_T_rSRP_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_rSRP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_rSRQ_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_rSRQ(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_sINR_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_sINR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t BeamMeasurementsReportQuantity_sequence[] = {
  { &hf_ngap_rSRP           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_rSRP },
  { &hf_ngap_rSRQ           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_rSRQ },
  { &hf_ngap_sINR           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_sINR },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_BeamMeasurementsReportQuantity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_BeamMeasurementsReportQuantity, BeamMeasurementsReportQuantity_sequence);

  return offset;
}



static int
dissect_ngap_MaxNrofRS_IndexesToReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, true);

  return offset;
}


static const per_sequence_t BeamMeasurementsReportConfiguration_sequence[] = {
  { &hf_ngap_beamMeasurementsReportQuantity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BeamMeasurementsReportQuantity },
  { &hf_ngap_maxNrofRS_IndexesToReport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MaxNrofRS_IndexesToReport },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_BeamMeasurementsReportConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_BeamMeasurementsReportConfiguration, BeamMeasurementsReportConfiguration_sequence);

  return offset;
}



static int
dissect_ngap_NumberOfBroadcasts(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const per_sequence_t CellIDCancelledEUTRA_Item_sequence[] = {
  { &hf_ngap_eUTRA_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
  { &hf_ngap_numberOfBroadcasts, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NumberOfBroadcasts },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CellIDCancelledEUTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CellIDCancelledEUTRA_Item, CellIDCancelledEUTRA_Item_sequence);

  return offset;
}


static const per_sequence_t CellIDCancelledEUTRA_sequence_of[1] = {
  { &hf_ngap_CellIDCancelledEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CellIDCancelledEUTRA_Item },
};

static int
dissect_ngap_CellIDCancelledEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CellIDCancelledEUTRA, CellIDCancelledEUTRA_sequence_of,
                                                  1, maxnoofCellIDforWarning, false);

  return offset;
}


static const per_sequence_t CancelledCellsInTAI_EUTRA_Item_sequence[] = {
  { &hf_ngap_eUTRA_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
  { &hf_ngap_numberOfBroadcasts, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NumberOfBroadcasts },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CancelledCellsInTAI_EUTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CancelledCellsInTAI_EUTRA_Item, CancelledCellsInTAI_EUTRA_Item_sequence);

  return offset;
}


static const per_sequence_t CancelledCellsInTAI_EUTRA_sequence_of[1] = {
  { &hf_ngap_CancelledCellsInTAI_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CancelledCellsInTAI_EUTRA_Item },
};

static int
dissect_ngap_CancelledCellsInTAI_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CancelledCellsInTAI_EUTRA, CancelledCellsInTAI_EUTRA_sequence_of,
                                                  1, maxnoofCellinTAI, false);

  return offset;
}


static const per_sequence_t TAICancelledEUTRA_Item_sequence[] = {
  { &hf_ngap_tAI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
  { &hf_ngap_cancelledCellsInTAI_EUTRA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CancelledCellsInTAI_EUTRA },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TAICancelledEUTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TAICancelledEUTRA_Item, TAICancelledEUTRA_Item_sequence);

  return offset;
}


static const per_sequence_t TAICancelledEUTRA_sequence_of[1] = {
  { &hf_ngap_TAICancelledEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAICancelledEUTRA_Item },
};

static int
dissect_ngap_TAICancelledEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_TAICancelledEUTRA, TAICancelledEUTRA_sequence_of,
                                                  1, maxnoofTAIforWarning, false);

  return offset;
}



static int
dissect_ngap_EmergencyAreaID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, false, NULL);

  return offset;
}


static const per_sequence_t CancelledCellsInEAI_EUTRA_Item_sequence[] = {
  { &hf_ngap_eUTRA_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
  { &hf_ngap_numberOfBroadcasts, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NumberOfBroadcasts },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CancelledCellsInEAI_EUTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CancelledCellsInEAI_EUTRA_Item, CancelledCellsInEAI_EUTRA_Item_sequence);

  return offset;
}


static const per_sequence_t CancelledCellsInEAI_EUTRA_sequence_of[1] = {
  { &hf_ngap_CancelledCellsInEAI_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CancelledCellsInEAI_EUTRA_Item },
};

static int
dissect_ngap_CancelledCellsInEAI_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CancelledCellsInEAI_EUTRA, CancelledCellsInEAI_EUTRA_sequence_of,
                                                  1, maxnoofCellinEAI, false);

  return offset;
}


static const per_sequence_t EmergencyAreaIDCancelledEUTRA_Item_sequence[] = {
  { &hf_ngap_emergencyAreaID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EmergencyAreaID },
  { &hf_ngap_cancelledCellsInEAI_EUTRA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CancelledCellsInEAI_EUTRA },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EmergencyAreaIDCancelledEUTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EmergencyAreaIDCancelledEUTRA_Item, EmergencyAreaIDCancelledEUTRA_Item_sequence);

  return offset;
}


static const per_sequence_t EmergencyAreaIDCancelledEUTRA_sequence_of[1] = {
  { &hf_ngap_EmergencyAreaIDCancelledEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_EmergencyAreaIDCancelledEUTRA_Item },
};

static int
dissect_ngap_EmergencyAreaIDCancelledEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_EmergencyAreaIDCancelledEUTRA, EmergencyAreaIDCancelledEUTRA_sequence_of,
                                                  1, maxnoofEmergencyAreaID, false);

  return offset;
}


static const per_sequence_t CellIDCancelledNR_Item_sequence[] = {
  { &hf_ngap_nR_CGI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NR_CGI },
  { &hf_ngap_numberOfBroadcasts, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NumberOfBroadcasts },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CellIDCancelledNR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CellIDCancelledNR_Item, CellIDCancelledNR_Item_sequence);

  return offset;
}


static const per_sequence_t CellIDCancelledNR_sequence_of[1] = {
  { &hf_ngap_CellIDCancelledNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CellIDCancelledNR_Item },
};

static int
dissect_ngap_CellIDCancelledNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CellIDCancelledNR, CellIDCancelledNR_sequence_of,
                                                  1, maxnoofCellIDforWarning, false);

  return offset;
}


static const per_sequence_t CancelledCellsInTAI_NR_Item_sequence[] = {
  { &hf_ngap_nR_CGI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NR_CGI },
  { &hf_ngap_numberOfBroadcasts, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NumberOfBroadcasts },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CancelledCellsInTAI_NR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CancelledCellsInTAI_NR_Item, CancelledCellsInTAI_NR_Item_sequence);

  return offset;
}


static const per_sequence_t CancelledCellsInTAI_NR_sequence_of[1] = {
  { &hf_ngap_CancelledCellsInTAI_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CancelledCellsInTAI_NR_Item },
};

static int
dissect_ngap_CancelledCellsInTAI_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CancelledCellsInTAI_NR, CancelledCellsInTAI_NR_sequence_of,
                                                  1, maxnoofCellinTAI, false);

  return offset;
}


static const per_sequence_t TAICancelledNR_Item_sequence[] = {
  { &hf_ngap_tAI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
  { &hf_ngap_cancelledCellsInTAI_NR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CancelledCellsInTAI_NR },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TAICancelledNR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TAICancelledNR_Item, TAICancelledNR_Item_sequence);

  return offset;
}


static const per_sequence_t TAICancelledNR_sequence_of[1] = {
  { &hf_ngap_TAICancelledNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAICancelledNR_Item },
};

static int
dissect_ngap_TAICancelledNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_TAICancelledNR, TAICancelledNR_sequence_of,
                                                  1, maxnoofTAIforWarning, false);

  return offset;
}


static const per_sequence_t CancelledCellsInEAI_NR_Item_sequence[] = {
  { &hf_ngap_nR_CGI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NR_CGI },
  { &hf_ngap_numberOfBroadcasts, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NumberOfBroadcasts },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CancelledCellsInEAI_NR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CancelledCellsInEAI_NR_Item, CancelledCellsInEAI_NR_Item_sequence);

  return offset;
}


static const per_sequence_t CancelledCellsInEAI_NR_sequence_of[1] = {
  { &hf_ngap_CancelledCellsInEAI_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CancelledCellsInEAI_NR_Item },
};

static int
dissect_ngap_CancelledCellsInEAI_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CancelledCellsInEAI_NR, CancelledCellsInEAI_NR_sequence_of,
                                                  1, maxnoofCellinEAI, false);

  return offset;
}


static const per_sequence_t EmergencyAreaIDCancelledNR_Item_sequence[] = {
  { &hf_ngap_emergencyAreaID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EmergencyAreaID },
  { &hf_ngap_cancelledCellsInEAI_NR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CancelledCellsInEAI_NR },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EmergencyAreaIDCancelledNR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EmergencyAreaIDCancelledNR_Item, EmergencyAreaIDCancelledNR_Item_sequence);

  return offset;
}


static const per_sequence_t EmergencyAreaIDCancelledNR_sequence_of[1] = {
  { &hf_ngap_EmergencyAreaIDCancelledNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_EmergencyAreaIDCancelledNR_Item },
};

static int
dissect_ngap_EmergencyAreaIDCancelledNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_EmergencyAreaIDCancelledNR, EmergencyAreaIDCancelledNR_sequence_of,
                                                  1, maxnoofEmergencyAreaID, false);

  return offset;
}


static const value_string ngap_BroadcastCancelledAreaList_vals[] = {
  {   0, "cellIDCancelledEUTRA" },
  {   1, "tAICancelledEUTRA" },
  {   2, "emergencyAreaIDCancelledEUTRA" },
  {   3, "cellIDCancelledNR" },
  {   4, "tAICancelledNR" },
  {   5, "emergencyAreaIDCancelledNR" },
  {   6, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t BroadcastCancelledAreaList_choice[] = {
  {   0, &hf_ngap_cellIDCancelledEUTRA, ASN1_NO_EXTENSIONS     , dissect_ngap_CellIDCancelledEUTRA },
  {   1, &hf_ngap_tAICancelledEUTRA, ASN1_NO_EXTENSIONS     , dissect_ngap_TAICancelledEUTRA },
  {   2, &hf_ngap_emergencyAreaIDCancelledEUTRA, ASN1_NO_EXTENSIONS     , dissect_ngap_EmergencyAreaIDCancelledEUTRA },
  {   3, &hf_ngap_cellIDCancelledNR, ASN1_NO_EXTENSIONS     , dissect_ngap_CellIDCancelledNR },
  {   4, &hf_ngap_tAICancelledNR , ASN1_NO_EXTENSIONS     , dissect_ngap_TAICancelledNR },
  {   5, &hf_ngap_emergencyAreaIDCancelledNR, ASN1_NO_EXTENSIONS     , dissect_ngap_EmergencyAreaIDCancelledNR },
  {   6, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_BroadcastCancelledAreaList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_BroadcastCancelledAreaList, BroadcastCancelledAreaList_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CellIDBroadcastEUTRA_Item_sequence[] = {
  { &hf_ngap_eUTRA_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CellIDBroadcastEUTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CellIDBroadcastEUTRA_Item, CellIDBroadcastEUTRA_Item_sequence);

  return offset;
}


static const per_sequence_t CellIDBroadcastEUTRA_sequence_of[1] = {
  { &hf_ngap_CellIDBroadcastEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CellIDBroadcastEUTRA_Item },
};

static int
dissect_ngap_CellIDBroadcastEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CellIDBroadcastEUTRA, CellIDBroadcastEUTRA_sequence_of,
                                                  1, maxnoofCellIDforWarning, false);

  return offset;
}


static const per_sequence_t CompletedCellsInTAI_EUTRA_Item_sequence[] = {
  { &hf_ngap_eUTRA_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CompletedCellsInTAI_EUTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CompletedCellsInTAI_EUTRA_Item, CompletedCellsInTAI_EUTRA_Item_sequence);

  return offset;
}


static const per_sequence_t CompletedCellsInTAI_EUTRA_sequence_of[1] = {
  { &hf_ngap_CompletedCellsInTAI_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CompletedCellsInTAI_EUTRA_Item },
};

static int
dissect_ngap_CompletedCellsInTAI_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CompletedCellsInTAI_EUTRA, CompletedCellsInTAI_EUTRA_sequence_of,
                                                  1, maxnoofCellinTAI, false);

  return offset;
}


static const per_sequence_t TAIBroadcastEUTRA_Item_sequence[] = {
  { &hf_ngap_tAI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
  { &hf_ngap_completedCellsInTAI_EUTRA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CompletedCellsInTAI_EUTRA },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TAIBroadcastEUTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TAIBroadcastEUTRA_Item, TAIBroadcastEUTRA_Item_sequence);

  return offset;
}


static const per_sequence_t TAIBroadcastEUTRA_sequence_of[1] = {
  { &hf_ngap_TAIBroadcastEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAIBroadcastEUTRA_Item },
};

static int
dissect_ngap_TAIBroadcastEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_TAIBroadcastEUTRA, TAIBroadcastEUTRA_sequence_of,
                                                  1, maxnoofTAIforWarning, false);

  return offset;
}


static const per_sequence_t CompletedCellsInEAI_EUTRA_Item_sequence[] = {
  { &hf_ngap_eUTRA_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CompletedCellsInEAI_EUTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CompletedCellsInEAI_EUTRA_Item, CompletedCellsInEAI_EUTRA_Item_sequence);

  return offset;
}


static const per_sequence_t CompletedCellsInEAI_EUTRA_sequence_of[1] = {
  { &hf_ngap_CompletedCellsInEAI_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CompletedCellsInEAI_EUTRA_Item },
};

static int
dissect_ngap_CompletedCellsInEAI_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CompletedCellsInEAI_EUTRA, CompletedCellsInEAI_EUTRA_sequence_of,
                                                  1, maxnoofCellinEAI, false);

  return offset;
}


static const per_sequence_t EmergencyAreaIDBroadcastEUTRA_Item_sequence[] = {
  { &hf_ngap_emergencyAreaID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EmergencyAreaID },
  { &hf_ngap_completedCellsInEAI_EUTRA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CompletedCellsInEAI_EUTRA },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EmergencyAreaIDBroadcastEUTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EmergencyAreaIDBroadcastEUTRA_Item, EmergencyAreaIDBroadcastEUTRA_Item_sequence);

  return offset;
}


static const per_sequence_t EmergencyAreaIDBroadcastEUTRA_sequence_of[1] = {
  { &hf_ngap_EmergencyAreaIDBroadcastEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_EmergencyAreaIDBroadcastEUTRA_Item },
};

static int
dissect_ngap_EmergencyAreaIDBroadcastEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_EmergencyAreaIDBroadcastEUTRA, EmergencyAreaIDBroadcastEUTRA_sequence_of,
                                                  1, maxnoofEmergencyAreaID, false);

  return offset;
}


static const per_sequence_t CellIDBroadcastNR_Item_sequence[] = {
  { &hf_ngap_nR_CGI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NR_CGI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CellIDBroadcastNR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CellIDBroadcastNR_Item, CellIDBroadcastNR_Item_sequence);

  return offset;
}


static const per_sequence_t CellIDBroadcastNR_sequence_of[1] = {
  { &hf_ngap_CellIDBroadcastNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CellIDBroadcastNR_Item },
};

static int
dissect_ngap_CellIDBroadcastNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CellIDBroadcastNR, CellIDBroadcastNR_sequence_of,
                                                  1, maxnoofCellIDforWarning, false);

  return offset;
}


static const per_sequence_t CompletedCellsInTAI_NR_Item_sequence[] = {
  { &hf_ngap_nR_CGI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NR_CGI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CompletedCellsInTAI_NR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CompletedCellsInTAI_NR_Item, CompletedCellsInTAI_NR_Item_sequence);

  return offset;
}


static const per_sequence_t CompletedCellsInTAI_NR_sequence_of[1] = {
  { &hf_ngap_CompletedCellsInTAI_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CompletedCellsInTAI_NR_Item },
};

static int
dissect_ngap_CompletedCellsInTAI_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CompletedCellsInTAI_NR, CompletedCellsInTAI_NR_sequence_of,
                                                  1, maxnoofCellinTAI, false);

  return offset;
}


static const per_sequence_t TAIBroadcastNR_Item_sequence[] = {
  { &hf_ngap_tAI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
  { &hf_ngap_completedCellsInTAI_NR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CompletedCellsInTAI_NR },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TAIBroadcastNR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TAIBroadcastNR_Item, TAIBroadcastNR_Item_sequence);

  return offset;
}


static const per_sequence_t TAIBroadcastNR_sequence_of[1] = {
  { &hf_ngap_TAIBroadcastNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAIBroadcastNR_Item },
};

static int
dissect_ngap_TAIBroadcastNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_TAIBroadcastNR, TAIBroadcastNR_sequence_of,
                                                  1, maxnoofTAIforWarning, false);

  return offset;
}


static const per_sequence_t CompletedCellsInEAI_NR_Item_sequence[] = {
  { &hf_ngap_nR_CGI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NR_CGI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CompletedCellsInEAI_NR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CompletedCellsInEAI_NR_Item, CompletedCellsInEAI_NR_Item_sequence);

  return offset;
}


static const per_sequence_t CompletedCellsInEAI_NR_sequence_of[1] = {
  { &hf_ngap_CompletedCellsInEAI_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CompletedCellsInEAI_NR_Item },
};

static int
dissect_ngap_CompletedCellsInEAI_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CompletedCellsInEAI_NR, CompletedCellsInEAI_NR_sequence_of,
                                                  1, maxnoofCellinEAI, false);

  return offset;
}


static const per_sequence_t EmergencyAreaIDBroadcastNR_Item_sequence[] = {
  { &hf_ngap_emergencyAreaID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EmergencyAreaID },
  { &hf_ngap_completedCellsInEAI_NR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CompletedCellsInEAI_NR },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EmergencyAreaIDBroadcastNR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EmergencyAreaIDBroadcastNR_Item, EmergencyAreaIDBroadcastNR_Item_sequence);

  return offset;
}


static const per_sequence_t EmergencyAreaIDBroadcastNR_sequence_of[1] = {
  { &hf_ngap_EmergencyAreaIDBroadcastNR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_EmergencyAreaIDBroadcastNR_Item },
};

static int
dissect_ngap_EmergencyAreaIDBroadcastNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_EmergencyAreaIDBroadcastNR, EmergencyAreaIDBroadcastNR_sequence_of,
                                                  1, maxnoofEmergencyAreaID, false);

  return offset;
}


static const value_string ngap_BroadcastCompletedAreaList_vals[] = {
  {   0, "cellIDBroadcastEUTRA" },
  {   1, "tAIBroadcastEUTRA" },
  {   2, "emergencyAreaIDBroadcastEUTRA" },
  {   3, "cellIDBroadcastNR" },
  {   4, "tAIBroadcastNR" },
  {   5, "emergencyAreaIDBroadcastNR" },
  {   6, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t BroadcastCompletedAreaList_choice[] = {
  {   0, &hf_ngap_cellIDBroadcastEUTRA, ASN1_NO_EXTENSIONS     , dissect_ngap_CellIDBroadcastEUTRA },
  {   1, &hf_ngap_tAIBroadcastEUTRA, ASN1_NO_EXTENSIONS     , dissect_ngap_TAIBroadcastEUTRA },
  {   2, &hf_ngap_emergencyAreaIDBroadcastEUTRA, ASN1_NO_EXTENSIONS     , dissect_ngap_EmergencyAreaIDBroadcastEUTRA },
  {   3, &hf_ngap_cellIDBroadcastNR, ASN1_NO_EXTENSIONS     , dissect_ngap_CellIDBroadcastNR },
  {   4, &hf_ngap_tAIBroadcastNR , ASN1_NO_EXTENSIONS     , dissect_ngap_TAIBroadcastNR },
  {   5, &hf_ngap_emergencyAreaIDBroadcastNR, ASN1_NO_EXTENSIONS     , dissect_ngap_EmergencyAreaIDBroadcastNR },
  {   6, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_BroadcastCompletedAreaList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_BroadcastCompletedAreaList, BroadcastCompletedAreaList_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SliceSupportItem_sequence[] = {
  { &hf_ngap_s_NSSAI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_S_NSSAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SliceSupportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SliceSupportItem, SliceSupportItem_sequence);

  return offset;
}


static const per_sequence_t SliceSupportList_sequence_of[1] = {
  { &hf_ngap_SliceSupportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_SliceSupportItem },
};

static int
dissect_ngap_SliceSupportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_SliceSupportList, SliceSupportList_sequence_of,
                                                  1, maxnoofSliceItems, false);

  return offset;
}


static const per_sequence_t BroadcastPLMNItem_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_tAISliceSupportList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SliceSupportList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_BroadcastPLMNItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_BroadcastPLMNItem, BroadcastPLMNItem_sequence);

  return offset;
}


static const per_sequence_t BroadcastPLMNList_sequence_of[1] = {
  { &hf_ngap_BroadcastPLMNList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_BroadcastPLMNItem },
};

static int
dissect_ngap_BroadcastPLMNList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_BroadcastPLMNList, BroadcastPLMNList_sequence_of,
                                                  1, maxnoofBPLMNs, false);

  return offset;
}



static int
dissect_ngap_TMGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       6, 6, false, NULL);

  return offset;
}



static int
dissect_ngap_NID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     44, 44, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t MBS_SessionID_sequence[] = {
  { &hf_ngap_tMGI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TMGI },
  { &hf_ngap_nID            , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_SessionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_SessionID, MBS_SessionID_sequence);

  return offset;
}


static const value_string ngap_CauseRadioNetwork_vals[] = {
  {   0, "unspecified" },
  {   1, "txnrelocoverall-expiry" },
  {   2, "successful-handover" },
  {   3, "release-due-to-ngran-generated-reason" },
  {   4, "release-due-to-5gc-generated-reason" },
  {   5, "handover-cancelled" },
  {   6, "partial-handover" },
  {   7, "ho-failure-in-target-5GC-ngran-node-or-target-system" },
  {   8, "ho-target-not-allowed" },
  {   9, "tngrelocoverall-expiry" },
  {  10, "tngrelocprep-expiry" },
  {  11, "cell-not-available" },
  {  12, "unknown-targetID" },
  {  13, "no-radio-resources-available-in-target-cell" },
  {  14, "unknown-local-UE-NGAP-ID" },
  {  15, "inconsistent-remote-UE-NGAP-ID" },
  {  16, "handover-desirable-for-radio-reason" },
  {  17, "time-critical-handover" },
  {  18, "resource-optimisation-handover" },
  {  19, "reduce-load-in-serving-cell" },
  {  20, "user-inactivity" },
  {  21, "radio-connection-with-ue-lost" },
  {  22, "radio-resources-not-available" },
  {  23, "invalid-qos-combination" },
  {  24, "failure-in-radio-interface-procedure" },
  {  25, "interaction-with-other-procedure" },
  {  26, "unknown-PDU-session-ID" },
  {  27, "unkown-qos-flow-ID" },
  {  28, "multiple-PDU-session-ID-instances" },
  {  29, "multiple-qos-flow-ID-instances" },
  {  30, "encryption-and-or-integrity-protection-algorithms-not-supported" },
  {  31, "ng-intra-system-handover-triggered" },
  {  32, "ng-inter-system-handover-triggered" },
  {  33, "xn-handover-triggered" },
  {  34, "not-supported-5QI-value" },
  {  35, "ue-context-transfer" },
  {  36, "ims-voice-eps-fallback-or-rat-fallback-triggered" },
  {  37, "up-integrity-protection-not-possible" },
  {  38, "up-confidentiality-protection-not-possible" },
  {  39, "slice-not-supported" },
  {  40, "ue-in-rrc-inactive-state-not-reachable" },
  {  41, "redirection" },
  {  42, "resources-not-available-for-the-slice" },
  {  43, "ue-max-integrity-protected-data-rate-reason" },
  {  44, "release-due-to-cn-detected-mobility" },
  {  45, "n26-interface-not-available" },
  {  46, "release-due-to-pre-emption" },
  {  47, "multiple-location-reporting-reference-ID-instances" },
  {  48, "rsn-not-available-for-the-up" },
  {  49, "npn-access-denied" },
  {  50, "cag-only-access-denied" },
  {  51, "insufficient-ue-capabilities" },
  {  52, "redcap-ue-not-supported" },
  {  53, "unknown-MBS-Session-ID" },
  {  54, "indicated-MBS-session-area-information-not-served-by-the-gNB" },
  {  55, "inconsistent-slice-info-for-the-session" },
  {  56, "misaligned-association-for-multicast-unicast" },
  {  57, "eredcap-ue-not-supported" },
  {  58, "two-rx-xr-ue-not-supported" },
  { 0, NULL }
};

static value_string_ext ngap_CauseRadioNetwork_vals_ext = VALUE_STRING_EXT_INIT(ngap_CauseRadioNetwork_vals);


static int
dissect_ngap_CauseRadioNetwork(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  uint32_t value;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     45, &value, true, 14, NULL);

  col_append_fstr(actx->pinfo->cinfo, COL_INFO, " [Cause: RadioNetwork=%s]", val_to_str_const(value, ngap_CauseRadioNetwork_vals, "Unknown"));


  return offset;
}


static const value_string ngap_CauseTransport_vals[] = {
  {   0, "transport-resource-unavailable" },
  {   1, "unspecified" },
  { 0, NULL }
};


static int
dissect_ngap_CauseTransport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  uint32_t value;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, &value, true, 0, NULL);

  col_append_fstr(actx->pinfo->cinfo, COL_INFO, " [Cause: Transport=%s]", val_to_str_const(value, ngap_CauseTransport_vals, "Unknown"));


  return offset;
}


static const value_string ngap_CauseNas_vals[] = {
  {   0, "normal-release" },
  {   1, "authentication-failure" },
  {   2, "deregister" },
  {   3, "unspecified" },
  {   4, "uE-not-in-PLMN-serving-area" },
  {   5, "mobile-IAB-not-authorized" },
  {   6, "iAB-not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_CauseNas(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  uint32_t value;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, &value, true, 3, NULL);

  col_append_fstr(actx->pinfo->cinfo, COL_INFO, " [Cause: Nas=%s]", val_to_str_const(value, ngap_CauseNas_vals, "Unknown"));


  return offset;
}


static const value_string ngap_CauseProtocol_vals[] = {
  {   0, "transfer-syntax-error" },
  {   1, "abstract-syntax-error-reject" },
  {   2, "abstract-syntax-error-ignore-and-notify" },
  {   3, "message-not-compatible-with-receiver-state" },
  {   4, "semantic-error" },
  {   5, "abstract-syntax-error-falsely-constructed-message" },
  {   6, "unspecified" },
  { 0, NULL }
};


static int
dissect_ngap_CauseProtocol(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  uint32_t value;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, &value, true, 0, NULL);

  col_append_fstr(actx->pinfo->cinfo, COL_INFO, " [Cause: Protocol=%s]", val_to_str_const(value, ngap_CauseProtocol_vals, "Unknown"));


  return offset;
}


static const value_string ngap_CauseMisc_vals[] = {
  {   0, "control-processing-overload" },
  {   1, "not-enough-user-plane-processing-resources" },
  {   2, "hardware-failure" },
  {   3, "om-intervention" },
  {   4, "unknown-PLMN-or-SNPN" },
  {   5, "unspecified" },
  { 0, NULL }
};


static int
dissect_ngap_CauseMisc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  uint32_t value;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, &value, true, 0, NULL);

  col_append_fstr(actx->pinfo->cinfo, COL_INFO, " [Cause: Misc=%s]", val_to_str_const(value, ngap_CauseMisc_vals, "Unknown"));


  return offset;
}


static const value_string ngap_Cause_vals[] = {
  {   0, "radioNetwork" },
  {   1, "transport" },
  {   2, "nas" },
  {   3, "protocol" },
  {   4, "misc" },
  {   5, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t Cause_choice[] = {
  {   0, &hf_ngap_radioNetwork   , ASN1_NO_EXTENSIONS     , dissect_ngap_CauseRadioNetwork },
  {   1, &hf_ngap_transport      , ASN1_NO_EXTENSIONS     , dissect_ngap_CauseTransport },
  {   2, &hf_ngap_nas            , ASN1_NO_EXTENSIONS     , dissect_ngap_CauseNas },
  {   3, &hf_ngap_protocol       , ASN1_NO_EXTENSIONS     , dissect_ngap_CauseProtocol },
  {   4, &hf_ngap_misc           , ASN1_NO_EXTENSIONS     , dissect_ngap_CauseMisc },
  {   5, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_Cause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_Cause, Cause_choice,
                                 NULL);

  return offset;
}


static const value_string ngap_TypeOfError_vals[] = {
  {   0, "not-understood" },
  {   1, "missing" },
  { 0, NULL }
};


static int
dissect_ngap_TypeOfError(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_Item_sequence[] = {
  { &hf_ngap_iECriticality  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Criticality },
  { &hf_ngap_iE_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ProtocolIE_ID },
  { &hf_ngap_typeOfError    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TypeOfError },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CriticalityDiagnostics_IE_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CriticalityDiagnostics_IE_Item, CriticalityDiagnostics_IE_Item_sequence);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_List_sequence_of[1] = {
  { &hf_ngap_CriticalityDiagnostics_IE_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CriticalityDiagnostics_IE_Item },
};

static int
dissect_ngap_CriticalityDiagnostics_IE_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CriticalityDiagnostics_IE_List, CriticalityDiagnostics_IE_List_sequence_of,
                                                  1, maxnoofErrors, false);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_sequence[] = {
  { &hf_ngap_procedureCode  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProcedureCode },
  { &hf_ngap_triggeringMessage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_TriggeringMessage },
  { &hf_ngap_procedureCriticality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_Criticality },
  { &hf_ngap_iEsCriticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_CriticalityDiagnostics_IE_List },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CriticalityDiagnostics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CriticalityDiagnostics, CriticalityDiagnostics_sequence);

  return offset;
}


static const per_sequence_t BroadcastTransportFailureTransfer_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_criticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_CriticalityDiagnostics },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_BroadcastTransportFailureTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_BroadcastTransportFailureTransfer, BroadcastTransportFailureTransfer_sequence);

  return offset;
}



static int
dissect_ngap_MBS_AreaSessionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, true);

  return offset;
}


static const per_sequence_t MBS_SessionTNLInfoNGRANItem_sequence[] = {
  { &hf_ngap_mBS_AreaSessionID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_AreaSessionID },
  { &hf_ngap_sharedNGU_UnicastTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_SessionTNLInfoNGRANItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_SessionTNLInfoNGRANItem, MBS_SessionTNLInfoNGRANItem_sequence);

  return offset;
}


static const per_sequence_t MBS_SessionTNLInfoNGRANList_sequence_of[1] = {
  { &hf_ngap_MBS_SessionTNLInfoNGRANList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionTNLInfoNGRANItem },
};

static int
dissect_ngap_MBS_SessionTNLInfoNGRANList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBS_SessionTNLInfoNGRANList, MBS_SessionTNLInfoNGRANList_sequence_of,
                                                  1, maxnoofMBSServiceAreaInformation, false);

  return offset;
}


static const value_string ngap_MBS_SessionTNLInfoNGRAN_vals[] = {
  {   0, "locationindependent" },
  {   1, "locationdependent" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t MBS_SessionTNLInfoNGRAN_choice[] = {
  {   0, &hf_ngap_locationindependent_02, ASN1_NO_EXTENSIONS     , dissect_ngap_UPTransportLayerInformation },
  {   1, &hf_ngap_locationdependent_02, ASN1_NO_EXTENSIONS     , dissect_ngap_MBS_SessionTNLInfoNGRANList },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_MBS_SessionTNLInfoNGRAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_MBS_SessionTNLInfoNGRAN, MBS_SessionTNLInfoNGRAN_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t BroadcastTransportRequestTransfer_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_mBS_SessionTNLInfoNGRAN, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionTNLInfoNGRAN },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_BroadcastTransportRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_BroadcastTransportRequestTransfer, BroadcastTransportRequestTransfer_sequence);

  return offset;
}


static const per_sequence_t BroadcastTransportResponseTransfer_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_BroadcastTransportResponseTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_BroadcastTransportResponseTransfer, BroadcastTransportResponseTransfer_sequence);

  return offset;
}


static const value_string ngap_BluetoothMeasConfig_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_ngap_BluetoothMeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_BluetoothName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       1, 248, false, &parameter_tvb);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, -1, ENC_UTF_8|ENC_NA);

  return offset;
}


static const per_sequence_t BluetoothMeasConfigNameItem_sequence[] = {
  { &hf_ngap_bluetoothName  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BluetoothName },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_BluetoothMeasConfigNameItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_BluetoothMeasConfigNameItem, BluetoothMeasConfigNameItem_sequence);

  return offset;
}


static const per_sequence_t BluetoothMeasConfigNameList_sequence_of[1] = {
  { &hf_ngap_BluetoothMeasConfigNameList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_BluetoothMeasConfigNameItem },
};

static int
dissect_ngap_BluetoothMeasConfigNameList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_BluetoothMeasConfigNameList, BluetoothMeasConfigNameList_sequence_of,
                                                  1, maxnoofBluetoothName, false);

  return offset;
}


static const value_string ngap_T_bt_rssi_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_bt_rssi(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t BluetoothMeasurementConfiguration_sequence[] = {
  { &hf_ngap_bluetoothMeasConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BluetoothMeasConfig },
  { &hf_ngap_bluetoothMeasConfigNameList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BluetoothMeasConfigNameList },
  { &hf_ngap_bt_rssi        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_bt_rssi },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_BluetoothMeasurementConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_BluetoothMeasurementConfiguration, BluetoothMeasurementConfiguration_sequence);

  return offset;
}



static int
dissect_ngap_BurstArrivalTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *burst_arrival_time_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &burst_arrival_time_tvb);

  if (burst_arrival_time_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_BurstArrivalTime);
    dissect_nr_rrc_ReferenceTime_r16_PDU(burst_arrival_time_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_ngap_INTEGER_0_640000_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 640000U, NULL, true);

  return offset;
}


static const per_sequence_t BurstArrivalTimeWindow_sequence[] = {
  { &hf_ngap_burstArrivalTimeWindowStart, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_640000_ },
  { &hf_ngap_burstArrivalTimeWindowEnd, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_640000_ },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_BurstArrivalTimeWindow(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_BurstArrivalTimeWindow, BurstArrivalTimeWindow_sequence);

  return offset;
}



static int
dissect_ngap_CandidateRelayUE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t CandidateRelayUEInformationItem_sequence[] = {
  { &hf_ngap_candidateRelayUE_Id, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CandidateRelayUE_ID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CandidateRelayUEInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CandidateRelayUEInformationItem, CandidateRelayUEInformationItem_sequence);

  return offset;
}


static const per_sequence_t CandidateRelayUEInformationList_sequence_of[1] = {
  { &hf_ngap_CandidateRelayUEInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CandidateRelayUEInformationItem },
};

static int
dissect_ngap_CandidateRelayUEInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CandidateRelayUEInformationList, CandidateRelayUEInformationList_sequence_of,
                                                  1, maxnoofCandidateRelayUEs, false);

  return offset;
}


static const value_string ngap_CancelAllWarningMessages_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_CancelAllWarningMessages(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t CandidateCellID_sequence[] = {
  { &hf_ngap_candidateCellID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NR_CGI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CandidateCellID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CandidateCellID, CandidateCellID_sequence);

  return offset;
}



static int
dissect_ngap_INTEGER_0_1007_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1007U, NULL, true);

  return offset;
}



static int
dissect_ngap_INTEGER_0_maxNRARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNRARFCN, NULL, false);

  return offset;
}


static const per_sequence_t CandidatePCI_sequence[] = {
  { &hf_ngap_candidatePCI_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_1007_ },
  { &hf_ngap_candidateNRARFCN, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_maxNRARFCN },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CandidatePCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CandidatePCI, CandidatePCI_sequence);

  return offset;
}


static const value_string ngap_CandidateCell_vals[] = {
  {   0, "candidateCGI" },
  {   1, "candidatePCI" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t CandidateCell_choice[] = {
  {   0, &hf_ngap_candidateCGI   , ASN1_NO_EXTENSIONS     , dissect_ngap_CandidateCellID },
  {   1, &hf_ngap_candidatePCI   , ASN1_NO_EXTENSIONS     , dissect_ngap_CandidatePCI },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_CandidateCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_CandidateCell, CandidateCell_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CandidateCellItem_sequence[] = {
  { &hf_ngap_candidateCell  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CandidateCell },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CandidateCellItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CandidateCellItem, CandidateCellItem_sequence);

  return offset;
}


static const per_sequence_t CandidateCellList_sequence_of[1] = {
  { &hf_ngap_CandidateCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CandidateCellItem },
};

static int
dissect_ngap_CandidateCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CandidateCellList, CandidateCellList_sequence_of,
                                                  1, maxnoofCandidateCells, false);

  return offset;
}


static const per_sequence_t CellCAGList_sequence_of[1] = {
  { &hf_ngap_CellCAGList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CAG_ID },
};

static int
dissect_ngap_CellCAGList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CellCAGList, CellCAGList_sequence_of,
                                                  1, maxnoofCAGSperCell, false);

  return offset;
}


static const per_sequence_t Cell_CAGInformation_sequence[] = {
  { &hf_ngap_nGRAN_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
  { &hf_ngap_cellCAGList    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CellCAGList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_Cell_CAGInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_Cell_CAGInformation, Cell_CAGInformation_sequence);

  return offset;
}


static const per_sequence_t EUTRA_CGIList_sequence_of[1] = {
  { &hf_ngap_EUTRA_CGIList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
};

static int
dissect_ngap_EUTRA_CGIList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_EUTRA_CGIList, EUTRA_CGIList_sequence_of,
                                                  1, maxnoofCellsinngeNB, false);

  return offset;
}


static const per_sequence_t NR_CGIList_sequence_of[1] = {
  { &hf_ngap_NR_CGIList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NR_CGI },
};

static int
dissect_ngap_NR_CGIList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_NR_CGIList, NR_CGIList_sequence_of,
                                                  1, maxnoofCellsingNB, false);

  return offset;
}


static const value_string ngap_CellIDListForRestart_vals[] = {
  {   0, "eUTRA-CGIListforRestart" },
  {   1, "nR-CGIListforRestart" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t CellIDListForRestart_choice[] = {
  {   0, &hf_ngap_eUTRA_CGIListforRestart, ASN1_NO_EXTENSIONS     , dissect_ngap_EUTRA_CGIList },
  {   1, &hf_ngap_nR_CGIListforRestart, ASN1_NO_EXTENSIONS     , dissect_ngap_NR_CGIList },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_CellIDListForRestart(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_CellIDListForRestart, CellIDListForRestart_choice,
                                 NULL);

  return offset;
}


static const value_string ngap_CellSize_vals[] = {
  {   0, "verysmall" },
  {   1, "small" },
  {   2, "medium" },
  {   3, "large" },
  { 0, NULL }
};


static int
dissect_ngap_CellSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t CellType_sequence[] = {
  { &hf_ngap_cellSize       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CellSize },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CellType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CellType, CellType_sequence);

  return offset;
}


static const value_string ngap_CEmodeBSupport_Indicator_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_ngap_CEmodeBSupport_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_CEmodeBrestricted_vals[] = {
  {   0, "restricted" },
  {   1, "not-restricted" },
  { 0, NULL }
};


static int
dissect_ngap_CEmodeBrestricted(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_INTEGER_1_40000000_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 40000000U, NULL, true);

  return offset;
}



static int
dissect_ngap_INTEGER_32_47_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            32U, 47U, NULL, true);

  return offset;
}


static const value_string ngap_ClockAccuracy_vals[] = {
  {   0, "clockAccuracyValue" },
  {   1, "clockAccuracyIndex" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t ClockAccuracy_choice[] = {
  {   0, &hf_ngap_clockAccuracyValue, ASN1_NO_EXTENSIONS     , dissect_ngap_INTEGER_1_40000000_ },
  {   1, &hf_ngap_clockAccuracyIndex, ASN1_NO_EXTENSIONS     , dissect_ngap_INTEGER_32_47_ },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_ClockAccuracy(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_ClockAccuracy, ClockAccuracy_choice,
                                 NULL);

  return offset;
}



static int
dissect_ngap_BIT_STRING_SIZE_8_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, true, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string ngap_T_traceabletoUTC_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_traceabletoUTC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_traceabletoGNSS_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_traceabletoGNSS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_BIT_STRING_SIZE_16_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, true, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t ClockQualityAcceptanceCriteria_sequence[] = {
  { &hf_ngap_synchronisationState, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BIT_STRING_SIZE_8_ },
  { &hf_ngap_traceabletoUTC , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_traceabletoUTC },
  { &hf_ngap_traceabletoGNSS, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_traceabletoGNSS },
  { &hf_ngap_clockFrequencyStability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BIT_STRING_SIZE_16 },
  { &hf_ngap_clockAccuracy  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_INTEGER_1_40000000_ },
  { &hf_ngap_parentTImeSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BIT_STRING_SIZE_16_ },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ClockQualityAcceptanceCriteria(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ClockQualityAcceptanceCriteria, ClockQualityAcceptanceCriteria_sequence);

  return offset;
}


static const per_sequence_t ClockQualityAcceptanceIndication_sequence[] = {
  { &hf_ngap_clockQualityAcceptanceCriteria, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ClockQualityAcceptanceCriteria },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ClockQualityAcceptanceIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ClockQualityAcceptanceIndication, ClockQualityAcceptanceIndication_sequence);

  return offset;
}


static const value_string ngap_ClockQualityDetailLevel_vals[] = {
  {   0, "clockQualityMetrics" },
  {   1, "clockQualityAcceptanceIndication" },
  {   2, "choice-extensions" },
  { 0, NULL }
};

static const per_choice_t ClockQualityDetailLevel_choice[] = {
  {   0, &hf_ngap_clockQualityMetrics, ASN1_NO_EXTENSIONS     , dissect_ngap_NULL },
  {   1, &hf_ngap_clockQualityAcceptanceIndication, ASN1_NO_EXTENSIONS     , dissect_ngap_ClockQualityAcceptanceIndication },
  {   2, &hf_ngap_choice_extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_ClockQualityDetailLevel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_ClockQualityDetailLevel, ClockQualityDetailLevel_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ClockQualityReportingControlInfo_sequence[] = {
  { &hf_ngap_clockQualityDetailLevel, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ClockQualityDetailLevel },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ClockQualityReportingControlInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ClockQualityReportingControlInfo, ClockQualityReportingControlInfo_sequence);

  return offset;
}



static int
dissect_ngap_ExpectedActivityPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 181U, NULL, true);

  return offset;
}



static int
dissect_ngap_ExpectedIdlePeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 181U, NULL, true);

  return offset;
}


static const value_string ngap_SourceOfUEActivityBehaviourInformation_vals[] = {
  {   0, "subscription-information" },
  {   1, "statistics" },
  { 0, NULL }
};


static int
dissect_ngap_SourceOfUEActivityBehaviourInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t ExpectedUEActivityBehaviour_sequence[] = {
  { &hf_ngap_expectedActivityPeriod, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ExpectedActivityPeriod },
  { &hf_ngap_expectedIdlePeriod, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ExpectedIdlePeriod },
  { &hf_ngap_sourceOfUEActivityBehaviourInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_SourceOfUEActivityBehaviourInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ExpectedUEActivityBehaviour(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ExpectedUEActivityBehaviour, ExpectedUEActivityBehaviour_sequence);

  return offset;
}


static const value_string ngap_ExpectedHOInterval_vals[] = {
  {   0, "sec15" },
  {   1, "sec30" },
  {   2, "sec60" },
  {   3, "sec90" },
  {   4, "sec120" },
  {   5, "sec180" },
  {   6, "long-time" },
  { 0, NULL }
};


static int
dissect_ngap_ExpectedHOInterval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_ExpectedUEMobility_vals[] = {
  {   0, "stationary" },
  {   1, "mobile" },
  { 0, NULL }
};


static int
dissect_ngap_ExpectedUEMobility(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t ExpectedUEMovingTrajectoryItem_sequence[] = {
  { &hf_ngap_nGRAN_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
  { &hf_ngap_timeStayedInCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_INTEGER_0_4095 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ExpectedUEMovingTrajectoryItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ExpectedUEMovingTrajectoryItem, ExpectedUEMovingTrajectoryItem_sequence);

  return offset;
}


static const per_sequence_t ExpectedUEMovingTrajectory_sequence_of[1] = {
  { &hf_ngap_ExpectedUEMovingTrajectory_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_ExpectedUEMovingTrajectoryItem },
};

static int
dissect_ngap_ExpectedUEMovingTrajectory(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_ExpectedUEMovingTrajectory, ExpectedUEMovingTrajectory_sequence_of,
                                                  1, maxnoofCellsUEMovingTrajectory, false);

  return offset;
}


static const per_sequence_t ExpectedUEBehaviour_sequence[] = {
  { &hf_ngap_expectedUEActivityBehaviour, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ExpectedUEActivityBehaviour },
  { &hf_ngap_expectedHOInterval, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ExpectedHOInterval },
  { &hf_ngap_expectedUEMobility, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ExpectedUEMobility },
  { &hf_ngap_expectedUEMovingTrajectory, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ExpectedUEMovingTrajectory },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ExpectedUEBehaviour(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ExpectedUEBehaviour, ExpectedUEBehaviour_sequence);

  return offset;
}


static const per_sequence_t CNAssistedRANTuning_sequence[] = {
  { &hf_ngap_expectedUEBehaviour, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ExpectedUEBehaviour },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CNAssistedRANTuning(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CNAssistedRANTuning, CNAssistedRANTuning_sequence);

  return offset;
}



static int
dissect_ngap_CNsubgroupID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, true);

  return offset;
}


static const value_string ngap_T_cn_Type_vals[] = {
  {   0, "epc-forbidden" },
  {   1, "fiveGC-forbidden" },
  { 0, NULL }
};


static int
dissect_ngap_T_cn_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t CNTypeRestrictionsForEquivalentItem_sequence[] = {
  { &hf_ngap_plmnIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_cn_Type        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_cn_Type },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CNTypeRestrictionsForEquivalentItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CNTypeRestrictionsForEquivalentItem, CNTypeRestrictionsForEquivalentItem_sequence);

  return offset;
}


static const per_sequence_t CNTypeRestrictionsForEquivalent_sequence_of[1] = {
  { &hf_ngap_CNTypeRestrictionsForEquivalent_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CNTypeRestrictionsForEquivalentItem },
};

static int
dissect_ngap_CNTypeRestrictionsForEquivalent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CNTypeRestrictionsForEquivalent, CNTypeRestrictionsForEquivalent_sequence_of,
                                                  1, maxnoofEPLMNs, false);

  return offset;
}


static const value_string ngap_CNTypeRestrictionsForServing_vals[] = {
  {   0, "epc-forbidden" },
  { 0, NULL }
};


static int
dissect_ngap_CNTypeRestrictionsForServing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_CommonNetworkInstance(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}


static const value_string ngap_ConcurrentWarningMessageInd_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_ConcurrentWarningMessageInd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_ConfidentialityProtectionIndication_vals[] = {
  {   0, "required" },
  {   1, "preferred" },
  {   2, "not-needed" },
  { 0, NULL }
};


static int
dissect_ngap_ConfidentialityProtectionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_ConfidentialityProtectionResult_vals[] = {
  {   0, "performed" },
  {   1, "not-performed" },
  { 0, NULL }
};


static int
dissect_ngap_ConfidentialityProtectionResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_ConfiguredTACIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_ConfiguredTACIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_BIT_STRING_SIZE_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string ngap_UEIdentityIndexValue_vals[] = {
  {   0, "indexLength10" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t UEIdentityIndexValue_choice[] = {
  {   0, &hf_ngap_indexLength10  , ASN1_NO_EXTENSIONS     , dissect_ngap_BIT_STRING_SIZE_10 },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_UEIdentityIndexValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_UEIdentityIndexValue, UEIdentityIndexValue_choice,
                                 NULL);

  return offset;
}


static const value_string ngap_PagingDRX_vals[] = {
  {   0, "v32" },
  {   1, "v64" },
  {   2, "v128" },
  {   3, "v256" },
  { 0, NULL }
};


static int
dissect_ngap_PagingDRX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_PeriodicRegistrationUpdateTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *val_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     8, 8, false, NULL, 0, &val_tvb, NULL);

  if (val_tvb) {
    uint32_t val = tvb_get_uint8(val_tvb, 0);
    actx->created_item = proto_tree_add_uint(tree, hf_index, val_tvb, 0, 1, val);
  }


  return offset;
}


static const value_string ngap_MICOModeIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_MICOModeIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t TAIListForInactiveItem_sequence[] = {
  { &hf_ngap_tAI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TAIListForInactiveItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TAIListForInactiveItem, TAIListForInactiveItem_sequence);

  return offset;
}


static const per_sequence_t TAIListForInactive_sequence_of[1] = {
  { &hf_ngap_TAIListForInactive_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAIListForInactiveItem },
};

static int
dissect_ngap_TAIListForInactive(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_TAIListForInactive, TAIListForInactive_sequence_of,
                                                  1, maxnoofTAIforInactive, false);

  return offset;
}


static const per_sequence_t CoreNetworkAssistanceInformationForInactive_sequence[] = {
  { &hf_ngap_uEIdentityIndexValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UEIdentityIndexValue },
  { &hf_ngap_uESpecificDRX  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PagingDRX },
  { &hf_ngap_periodicRegistrationUpdateTimer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PeriodicRegistrationUpdateTimer },
  { &hf_ngap_mICOModeIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MICOModeIndication },
  { &hf_ngap_tAIListForInactive, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAIListForInactive },
  { &hf_ngap_expectedUEBehaviour, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ExpectedUEBehaviour },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CoreNetworkAssistanceInformationForInactive(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CoreNetworkAssistanceInformationForInactive, CoreNetworkAssistanceInformationForInactive_sequence);

  return offset;
}


static const value_string ngap_CN_MT_CommunicationHandling_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_ngap_CN_MT_CommunicationHandling(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_INTEGER_0_1048575(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1048575U, NULL, false);

  return offset;
}


static const per_sequence_t COUNTValueForPDCP_SN12_sequence[] = {
  { &hf_ngap_pDCP_SN12      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_4095 },
  { &hf_ngap_hFN_PDCP_SN12  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_1048575 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_COUNTValueForPDCP_SN12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_COUNTValueForPDCP_SN12, COUNTValueForPDCP_SN12_sequence);

  return offset;
}



static int
dissect_ngap_INTEGER_0_262143(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 262143U, NULL, false);

  return offset;
}



static int
dissect_ngap_INTEGER_0_16383(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, false);

  return offset;
}


static const per_sequence_t COUNTValueForPDCP_SN18_sequence[] = {
  { &hf_ngap_pDCP_SN18      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_262143 },
  { &hf_ngap_hFN_PDCP_SN18  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_16383 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_COUNTValueForPDCP_SN18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_COUNTValueForPDCP_SN18, COUNTValueForPDCP_SN18_sequence);

  return offset;
}



static int
dissect_ngap_CoverageEnhancementLevel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *cov_enh_level_tvb;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &cov_enh_level_tvb);

  if (cov_enh_level_tvb && ngap_dissect_container) {
    subtree = proto_item_add_subtree(actx->created_item, ett_ngap_CoverageEnhancementLevel);
    volatile int saved_offset = offset;
    if ((ngap_is_nbiot_ue(actx->pinfo) && (ngap_dissect_lte_container_as == NGAP_LTE_CONTAINER_AUTOMATIC)) ||
        (ngap_dissect_lte_container_as == NGAP_LTE_CONTAINER_NBIOT)) {
      TRY {
        dissect_lte_rrc_UEPagingCoverageInformation_NB_PDU(cov_enh_level_tvb, actx->pinfo, subtree, NULL);
      }
      CATCH_BOUNDS_ERRORS {
        show_exception(cov_enh_level_tvb, actx->pinfo, subtree, EXCEPT_CODE, GET_MESSAGE);
      }
      ENDTRY;
    } else {
      TRY {
        dissect_lte_rrc_UEPagingCoverageInformation_PDU(cov_enh_level_tvb, actx->pinfo, subtree, NULL);
      }
      CATCH_BOUNDS_ERRORS {
        show_exception(cov_enh_level_tvb, actx->pinfo, subtree, EXCEPT_CODE, GET_MESSAGE);
      }
      ENDTRY;
    }
    offset = saved_offset;
  }


  return offset;
}



static int
dissect_ngap_C_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t CAGListforMDTItem_sequence[] = {
  { &hf_ngap_plmnID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_cAGID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CAG_ID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CAGListforMDTItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CAGListforMDTItem, CAGListforMDTItem_sequence);

  return offset;
}


static const per_sequence_t CAGListforMDT_sequence_of[1] = {
  { &hf_ngap_CAGListforMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CAGListforMDTItem },
};

static int
dissect_ngap_CAGListforMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CAGListforMDT, CAGListforMDT_sequence_of,
                                                  1, maxnoofCAGforMDT, false);

  return offset;
}



static int
dissect_ngap_DataCodingScheme(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
    proto_tree *subtree;

    subtree = proto_item_add_subtree(actx->created_item, ett_ngap_DataCodingScheme);
    ngap_data->data_coding_scheme = dissect_cbs_data_coding_scheme(parameter_tvb, actx->pinfo, subtree, 0);
  }


  return offset;
}


static const value_string ngap_DataForwardingNotPossible_vals[] = {
  {   0, "data-forwarding-not-possible" },
  { 0, NULL }
};


static int
dissect_ngap_DataForwardingNotPossible(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_DRB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, true);

  return offset;
}


static const per_sequence_t DataForwardingResponseDRBItem_sequence[] = {
  { &hf_ngap_dRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DRB_ID },
  { &hf_ngap_dLForwardingUP_TNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_uLForwardingUP_TNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DataForwardingResponseDRBItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DataForwardingResponseDRBItem, DataForwardingResponseDRBItem_sequence);

  return offset;
}


static const per_sequence_t DataForwardingResponseDRBList_sequence_of[1] = {
  { &hf_ngap_DataForwardingResponseDRBList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_DataForwardingResponseDRBItem },
};

static int
dissect_ngap_DataForwardingResponseDRBList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_DataForwardingResponseDRBList, DataForwardingResponseDRBList_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const value_string ngap_T_dAPSIndicator_vals[] = {
  {   0, "daps-ho-required" },
  { 0, NULL }
};


static int
dissect_ngap_T_dAPSIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t DAPSRequestInfo_sequence[] = {
  { &hf_ngap_dAPSIndicator  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_dAPSIndicator },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DAPSRequestInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DAPSRequestInfo, DAPSRequestInfo_sequence);

  return offset;
}


static const value_string ngap_T_dapsresponseindicator_vals[] = {
  {   0, "daps-ho-accepted" },
  {   1, "daps-ho-not-accepted" },
  { 0, NULL }
};


static int
dissect_ngap_T_dapsresponseindicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t DAPSResponseInfo_sequence[] = {
  { &hf_ngap_dapsresponseindicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_dapsresponseindicator },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DAPSResponseInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DAPSResponseInfo, DAPSResponseInfo_sequence);

  return offset;
}


static const per_sequence_t DAPSResponseInfoItem_sequence[] = {
  { &hf_ngap_dRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DRB_ID },
  { &hf_ngap_dAPSResponseInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DAPSResponseInfo },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DAPSResponseInfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DAPSResponseInfoItem, DAPSResponseInfoItem_sequence);

  return offset;
}


static const per_sequence_t DAPSResponseInfoList_sequence_of[1] = {
  { &hf_ngap_DAPSResponseInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_DAPSResponseInfoItem },
};

static int
dissect_ngap_DAPSResponseInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_DAPSResponseInfoList, DAPSResponseInfoList_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}



static int
dissect_ngap_E_RAB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, true);

  return offset;
}


static const per_sequence_t DataForwardingResponseERABListItem_sequence[] = {
  { &hf_ngap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_E_RAB_ID },
  { &hf_ngap_dLForwardingUP_TNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DataForwardingResponseERABListItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DataForwardingResponseERABListItem, DataForwardingResponseERABListItem_sequence);

  return offset;
}


static const per_sequence_t DataForwardingResponseERABList_sequence_of[1] = {
  { &hf_ngap_DataForwardingResponseERABList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_DataForwardingResponseERABListItem },
};

static int
dissect_ngap_DataForwardingResponseERABList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_DataForwardingResponseERABList, DataForwardingResponseERABList_sequence_of,
                                                  1, maxnoofE_RABs, false);

  return offset;
}


static const value_string ngap_DelayCritical_vals[] = {
  {   0, "delay-critical" },
  {   1, "non-delay-critical" },
  { 0, NULL }
};


static int
dissect_ngap_DelayCritical(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_DL_NAS_MAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t DL_CP_SecurityInformation_sequence[] = {
  { &hf_ngap_dl_NAS_MAC     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DL_NAS_MAC },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DL_CP_SecurityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DL_CP_SecurityInformation, DL_CP_SecurityInformation_sequence);

  return offset;
}


static const value_string ngap_DL_Signalling_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_DL_Signalling(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_DLForwarding_vals[] = {
  {   0, "dl-forwarding-proposed" },
  { 0, NULL }
};


static int
dissect_ngap_DLForwarding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_DL_NGU_TNLInformationReused_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_DL_NGU_TNLInformationReused(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_DirectForwardingPathAvailability_vals[] = {
  {   0, "direct-path-available" },
  { 0, NULL }
};


static int
dissect_ngap_DirectForwardingPathAvailability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_BIT_STRING_SIZE_1_2048(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 2048, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t DRBStatusUL12_sequence[] = {
  { &hf_ngap_uL_COUNTValue  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_COUNTValueForPDCP_SN12 },
  { &hf_ngap_receiveStatusOfUL_PDCP_SDUs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BIT_STRING_SIZE_1_2048 },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DRBStatusUL12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DRBStatusUL12, DRBStatusUL12_sequence);

  return offset;
}



static int
dissect_ngap_BIT_STRING_SIZE_1_131072(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 131072, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t DRBStatusUL18_sequence[] = {
  { &hf_ngap_uL_COUNTValue_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_COUNTValueForPDCP_SN18 },
  { &hf_ngap_receiveStatusOfUL_PDCP_SDUs_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BIT_STRING_SIZE_1_131072 },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DRBStatusUL18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DRBStatusUL18, DRBStatusUL18_sequence);

  return offset;
}


static const value_string ngap_DRBStatusUL_vals[] = {
  {   0, "dRBStatusUL12" },
  {   1, "dRBStatusUL18" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t DRBStatusUL_choice[] = {
  {   0, &hf_ngap_dRBStatusUL12  , ASN1_NO_EXTENSIONS     , dissect_ngap_DRBStatusUL12 },
  {   1, &hf_ngap_dRBStatusUL18  , ASN1_NO_EXTENSIONS     , dissect_ngap_DRBStatusUL18 },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_DRBStatusUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_DRBStatusUL, DRBStatusUL_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DRBStatusDL12_sequence[] = {
  { &hf_ngap_dL_COUNTValue  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_COUNTValueForPDCP_SN12 },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DRBStatusDL12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DRBStatusDL12, DRBStatusDL12_sequence);

  return offset;
}


static const per_sequence_t DRBStatusDL18_sequence[] = {
  { &hf_ngap_dL_COUNTValue_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_COUNTValueForPDCP_SN18 },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DRBStatusDL18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DRBStatusDL18, DRBStatusDL18_sequence);

  return offset;
}


static const value_string ngap_DRBStatusDL_vals[] = {
  {   0, "dRBStatusDL12" },
  {   1, "dRBStatusDL18" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t DRBStatusDL_choice[] = {
  {   0, &hf_ngap_dRBStatusDL12  , ASN1_NO_EXTENSIONS     , dissect_ngap_DRBStatusDL12 },
  {   1, &hf_ngap_dRBStatusDL18  , ASN1_NO_EXTENSIONS     , dissect_ngap_DRBStatusDL18 },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_DRBStatusDL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_DRBStatusDL, DRBStatusDL_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DRBsSubjectToStatusTransferItem_sequence[] = {
  { &hf_ngap_dRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DRB_ID },
  { &hf_ngap_dRBStatusUL    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DRBStatusUL },
  { &hf_ngap_dRBStatusDL    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DRBStatusDL },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DRBsSubjectToStatusTransferItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DRBsSubjectToStatusTransferItem, DRBsSubjectToStatusTransferItem_sequence);

  return offset;
}


static const per_sequence_t DRBsSubjectToStatusTransferList_sequence_of[1] = {
  { &hf_ngap_DRBsSubjectToStatusTransferList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_DRBsSubjectToStatusTransferItem },
};

static int
dissect_ngap_DRBsSubjectToStatusTransferList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_DRBsSubjectToStatusTransferList, DRBsSubjectToStatusTransferList_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t DRBsToQosFlowsMappingItem_sequence[] = {
  { &hf_ngap_dRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DRB_ID },
  { &hf_ngap_associatedQosFlowList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_AssociatedQosFlowList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DRBsToQosFlowsMappingItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DRBsToQosFlowsMappingItem, DRBsToQosFlowsMappingItem_sequence);

  return offset;
}


static const per_sequence_t DRBsToQosFlowsMappingList_sequence_of[1] = {
  { &hf_ngap_DRBsToQosFlowsMappingList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_DRBsToQosFlowsMappingItem },
};

static int
dissect_ngap_DRBsToQosFlowsMappingList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_DRBsToQosFlowsMappingList, DRBsToQosFlowsMappingList_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}



static int
dissect_ngap_PriorityLevelQos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, true);

  return offset;
}



static int
dissect_ngap_FiveQI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, true);

  return offset;
}



static int
dissect_ngap_MaximumDataBurstVolume(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, true);

  return offset;
}


static const per_sequence_t Dynamic5QIDescriptor_sequence[] = {
  { &hf_ngap_priorityLevelQos, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PriorityLevelQos },
  { &hf_ngap_packetDelayBudget, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PacketDelayBudget },
  { &hf_ngap_packetErrorRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PacketErrorRate },
  { &hf_ngap_fiveQI         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_FiveQI },
  { &hf_ngap_delayCritical  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_DelayCritical },
  { &hf_ngap_averagingWindow, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AveragingWindow },
  { &hf_ngap_maximumDataBurstVolume, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MaximumDataBurstVolume },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_Dynamic5QIDescriptor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_Dynamic5QIDescriptor, Dynamic5QIDescriptor_sequence);

  return offset;
}


static const value_string ngap_EarlyMeasurement_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_EarlyMeasurement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t DRBsSubjectToEarlyStatusTransfer_Item_sequence[] = {
  { &hf_ngap_dRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DRB_ID },
  { &hf_ngap_firstDLCOUNT   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DRBStatusDL },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DRBsSubjectToEarlyStatusTransfer_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DRBsSubjectToEarlyStatusTransfer_Item, DRBsSubjectToEarlyStatusTransfer_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsSubjectToEarlyStatusTransfer_List_sequence_of[1] = {
  { &hf_ngap_DRBsSubjectToEarlyStatusTransfer_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_DRBsSubjectToEarlyStatusTransfer_Item },
};

static int
dissect_ngap_DRBsSubjectToEarlyStatusTransfer_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_DRBsSubjectToEarlyStatusTransfer_List, DRBsSubjectToEarlyStatusTransfer_List_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t FirstDLCount_sequence[] = {
  { &hf_ngap_dRBsSubjectToEarlyStatusTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DRBsSubjectToEarlyStatusTransfer_List },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_FirstDLCount(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_FirstDLCount, FirstDLCount_sequence);

  return offset;
}


static const value_string ngap_ProcedureStageChoice_vals[] = {
  {   0, "first-dl-count" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t ProcedureStageChoice_choice[] = {
  {   0, &hf_ngap_first_dl_count , ASN1_NO_EXTENSIONS     , dissect_ngap_FirstDLCount },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_ProcedureStageChoice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_ProcedureStageChoice, ProcedureStageChoice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t EarlyStatusTransfer_TransparentContainer_sequence[] = {
  { &hf_ngap_procedureStage , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ProcedureStageChoice },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EarlyStatusTransfer_TransparentContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EarlyStatusTransfer_TransparentContainer, EarlyStatusTransfer_TransparentContainer_sequence);

  return offset;
}


static const value_string ngap_DLCountChoice_vals[] = {
  {   0, "count12bits" },
  {   1, "count18bits" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t DLCountChoice_choice[] = {
  {   0, &hf_ngap_count12bits    , ASN1_NO_EXTENSIONS     , dissect_ngap_COUNTValueForPDCP_SN12 },
  {   1, &hf_ngap_count18bits    , ASN1_NO_EXTENSIONS     , dissect_ngap_COUNTValueForPDCP_SN18 },
  {   2, &hf_ngap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_DLCountChoice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_DLCountChoice, DLCountChoice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DRBsSubjectToDLDiscarding_Item_sequence[] = {
  { &hf_ngap_drbID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DRB_ID },
  { &hf_ngap_dlCount        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DLCountChoice },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DRBsSubjectToDLDiscarding_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DRBsSubjectToDLDiscarding_Item, DRBsSubjectToDLDiscarding_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsSubjectToDLDiscarding_List_sequence_of[1] = {
  { &hf_ngap_DRBsSubjectToDLDiscarding_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_DRBsSubjectToDLDiscarding_Item },
};

static int
dissect_ngap_DRBsSubjectToDLDiscarding_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_DRBsSubjectToDLDiscarding_List, DRBsSubjectToDLDiscarding_List_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const per_sequence_t DLDiscarding_sequence[] = {
  { &hf_ngap_dRBsSubjectToDLDiscarding, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DRBsSubjectToDLDiscarding_List },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_DLDiscarding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_DLDiscarding, DLDiscarding_sequence);

  return offset;
}


static const value_string ngap_ECNMarkingAtRANRequest_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  {   2, "both" },
  {   3, "stop" },
  { 0, NULL }
};


static int
dissect_ngap_ECNMarkingAtRANRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_ECNMarkingAtUPFRequest_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  {   2, "both" },
  {   3, "stop" },
  { 0, NULL }
};


static int
dissect_ngap_ECNMarkingAtUPFRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_CongestionInformationRequest_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  {   2, "both" },
  {   3, "stop" },
  { 0, NULL }
};


static int
dissect_ngap_CongestionInformationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_ECNMarkingorCongestionInformationReportingRequest_vals[] = {
  {   0, "eCNMarkingAtRANRequest" },
  {   1, "eCNMarkingAtUPFRequest" },
  {   2, "congestionInformationRequest" },
  {   3, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t ECNMarkingorCongestionInformationReportingRequest_choice[] = {
  {   0, &hf_ngap_eCNMarkingAtRANRequest, ASN1_NO_EXTENSIONS     , dissect_ngap_ECNMarkingAtRANRequest },
  {   1, &hf_ngap_eCNMarkingAtUPFRequest, ASN1_NO_EXTENSIONS     , dissect_ngap_ECNMarkingAtUPFRequest },
  {   2, &hf_ngap_congestionInformationRequest, ASN1_NO_EXTENSIONS     , dissect_ngap_CongestionInformationRequest },
  {   3, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_ECNMarkingorCongestionInformationReportingRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_ECNMarkingorCongestionInformationReportingRequest, ECNMarkingorCongestionInformationReportingRequest_choice,
                                 NULL);

  return offset;
}


static const value_string ngap_ActivationStatus_vals[] = {
  {   0, "active" },
  {   1, "not-active" },
  { 0, NULL }
};


static int
dissect_ngap_ActivationStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t ECNMarkingorCongestionInformationReportingStatus_Item_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_activationStatus, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ActivationStatus },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ECNMarkingorCongestionInformationReportingStatus_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ECNMarkingorCongestionInformationReportingStatus_Item, ECNMarkingorCongestionInformationReportingStatus_Item_sequence);

  return offset;
}


static const per_sequence_t ECNMarkingorCongestionInformationReportingStatus_sequence_of[1] = {
  { &hf_ngap_ECNMarkingorCongestionInformationReportingStatus_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_ECNMarkingorCongestionInformationReportingStatus_Item },
};

static int
dissect_ngap_ECNMarkingorCongestionInformationReportingStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_ECNMarkingorCongestionInformationReportingStatus, ECNMarkingorCongestionInformationReportingStatus_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const value_string ngap_EDT_Session_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_EDT_Session(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t EmergencyAreaIDList_sequence_of[1] = {
  { &hf_ngap_EmergencyAreaIDList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_EmergencyAreaID },
};

static int
dissect_ngap_EmergencyAreaIDList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_EmergencyAreaIDList, EmergencyAreaIDList_sequence_of,
                                                  1, maxnoofEmergencyAreaID, false);

  return offset;
}


static const per_sequence_t EmergencyAreaIDListForRestart_sequence_of[1] = {
  { &hf_ngap_EmergencyAreaIDListForRestart_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_EmergencyAreaID },
};

static int
dissect_ngap_EmergencyAreaIDListForRestart(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_EmergencyAreaIDListForRestart, EmergencyAreaIDListForRestart_sequence_of,
                                                  1, maxnoofEAIforRestart, false);

  return offset;
}


static const value_string ngap_EmergencyFallbackRequestIndicator_vals[] = {
  {   0, "emergency-fallback-requested" },
  { 0, NULL }
};


static int
dissect_ngap_EmergencyFallbackRequestIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_EmergencyServiceTargetCN_vals[] = {
  {   0, "fiveGC" },
  {   1, "epc" },
  { 0, NULL }
};


static int
dissect_ngap_EmergencyServiceTargetCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t EmergencyFallbackIndicator_sequence[] = {
  { &hf_ngap_emergencyFallbackRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EmergencyFallbackRequestIndicator },
  { &hf_ngap_emergencyServiceTargetCN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_EmergencyServiceTargetCN },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EmergencyFallbackIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EmergencyFallbackIndicator, EmergencyFallbackIndicator_sequence);

  return offset;
}



static int
dissect_ngap_BIT_STRING_SIZE_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     28, 28, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string ngap_ENB_ID_vals[] = {
  {   0, "macroENB-ID" },
  {   1, "homeENB-ID" },
  {   2, "short-macroENB-ID" },
  {   3, "long-macroENB-ID" },
  {   4, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t ENB_ID_choice[] = {
  {   0, &hf_ngap_macroENB_ID    , ASN1_NO_EXTENSIONS     , dissect_ngap_BIT_STRING_SIZE_20 },
  {   1, &hf_ngap_homeENB_ID     , ASN1_NO_EXTENSIONS     , dissect_ngap_BIT_STRING_SIZE_28 },
  {   2, &hf_ngap_short_macroENB_ID, ASN1_NO_EXTENSIONS     , dissect_ngap_BIT_STRING_SIZE_18 },
  {   3, &hf_ngap_long_macroENB_ID, ASN1_NO_EXTENSIONS     , dissect_ngap_BIT_STRING_SIZE_21 },
  {   4, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_ENB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_ENB_ID, ENB_ID_choice,
                                 NULL);

  return offset;
}


static const value_string ngap_Enhanced_CoverageRestriction_vals[] = {
  {   0, "restricted" },
  { 0, NULL }
};


static int
dissect_ngap_Enhanced_CoverageRestriction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_Extended_ConnectedTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static int
dissect_ngap_EN_DCSONConfigurationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_ngap_EN_DCSONConfigurationTransfer);
    dissect_s1ap_EN_DCSONConfigurationTransfer_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_ngap_PortNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       2, 2, false, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t EndpointIPAddressAndPort_sequence[] = {
  { &hf_ngap_endpointIPAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TransportLayerAddress },
  { &hf_ngap_portNumber     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PortNumber },
  { &hf_ngap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EndpointIPAddressAndPort(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EndpointIPAddressAndPort, EndpointIPAddressAndPort_sequence);

  return offset;
}


static const value_string ngap_EndIndication_vals[] = {
  {   0, "no-further-data" },
  {   1, "further-data-exists" },
  { 0, NULL }
};


static int
dissect_ngap_EndIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t EquivalentPLMNs_sequence_of[1] = {
  { &hf_ngap_EquivalentPLMNs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
};

static int
dissect_ngap_EquivalentPLMNs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_EquivalentPLMNs, EquivalentPLMNs_sequence_of,
                                                  1, maxnoofEPLMNs, false);

  return offset;
}



static int
dissect_ngap_EPS_TAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       2, 2, false, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t EPS_TAI_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_ePS_TAC        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EPS_TAC },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EPS_TAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  ngap_data->number_type = E212_TAI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EPS_TAI, EPS_TAI_sequence);



  return offset;
}


static const per_sequence_t E_RABInformationItem_sequence[] = {
  { &hf_ngap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_E_RAB_ID },
  { &hf_ngap_dLForwarding   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_DLForwarding },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_E_RABInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_E_RABInformationItem, E_RABInformationItem_sequence);

  return offset;
}


static const per_sequence_t E_RABInformationList_sequence_of[1] = {
  { &hf_ngap_E_RABInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_E_RABInformationItem },
};

static int
dissect_ngap_E_RABInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_E_RABInformationList, E_RABInformationList_sequence_of,
                                                  1, maxnoofE_RABs, false);

  return offset;
}


static const value_string ngap_ERedCapIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_ERedCapIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t EUTRA_CGIListForWarning_sequence_of[1] = {
  { &hf_ngap_EUTRA_CGIListForWarning_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
};

static int
dissect_ngap_EUTRA_CGIListForWarning(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_EUTRA_CGIListForWarning, EUTRA_CGIListForWarning_sequence_of,
                                                  1, maxnoofCellIDforWarning, false);

  return offset;
}


static const value_string ngap_EUTRA_Paging_eDRX_Cycle_vals[] = {
  {   0, "hfhalf" },
  {   1, "hf1" },
  {   2, "hf2" },
  {   3, "hf4" },
  {   4, "hf6" },
  {   5, "hf8" },
  {   6, "hf10" },
  {   7, "hf12" },
  {   8, "hf14" },
  {   9, "hf16" },
  {  10, "hf32" },
  {  11, "hf64" },
  {  12, "hf128" },
  {  13, "hf256" },
  { 0, NULL }
};


static int
dissect_ngap_EUTRA_Paging_eDRX_Cycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     14, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_EUTRA_Paging_Time_Window_vals[] = {
  {   0, "s1" },
  {   1, "s2" },
  {   2, "s3" },
  {   3, "s4" },
  {   4, "s5" },
  {   5, "s6" },
  {   6, "s7" },
  {   7, "s8" },
  {   8, "s9" },
  {   9, "s10" },
  {  10, "s11" },
  {  11, "s12" },
  {  12, "s13" },
  {  13, "s14" },
  {  14, "s15" },
  {  15, "s16" },
  { 0, NULL }
};


static int
dissect_ngap_EUTRA_Paging_Time_Window(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t EUTRA_PagingeDRXInformation_sequence[] = {
  { &hf_ngap_eUTRA_paging_eDRX_Cycle, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_Paging_eDRX_Cycle },
  { &hf_ngap_eUTRA_paging_Time_Window, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_EUTRA_Paging_Time_Window },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EUTRA_PagingeDRXInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EUTRA_PagingeDRXInformation, EUTRA_PagingeDRXInformation_sequence);

  return offset;
}



static int
dissect_ngap_EUTRAencryptionAlgorithms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, true, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_ngap_EUTRAencryptionAlgorithms_eea1,
      &hf_ngap_EUTRAencryptionAlgorithms_eea2,
      &hf_ngap_EUTRAencryptionAlgorithms_eea3,
      &hf_ngap_EUTRAencryptionAlgorithms_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_EUTRAencryptionAlgorithms);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 2, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}



static int
dissect_ngap_EUTRAintegrityProtectionAlgorithms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, true, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_ngap_EUTRAintegrityProtectionAlgorithms_eia1,
      &hf_ngap_EUTRAintegrityProtectionAlgorithms_eia2,
      &hf_ngap_EUTRAintegrityProtectionAlgorithms_eia3,
      &hf_ngap_EUTRAintegrityProtectionAlgorithms_eia7,
      &hf_ngap_EUTRAintegrityProtectionAlgorithms_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_EUTRAintegrityProtectionAlgorithms);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 2, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const value_string ngap_EventType_vals[] = {
  {   0, "direct" },
  {   1, "change-of-serve-cell" },
  {   2, "ue-presence-in-area-of-interest" },
  {   3, "stop-change-of-serve-cell" },
  {   4, "stop-ue-presence-in-area-of-interest" },
  {   5, "cancel-location-reporting-for-the-ue" },
  {   6, "change-of-serving-cell-and-UE-presence-in-the-Area-of-Interest" },
  { 0, NULL }
};


static int
dissect_ngap_EventType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 1, NULL);

  return offset;
}


static const value_string ngap_ExcessPacketDelayThresholdValue_vals[] = {
  {   0, "ms0dot25" },
  {   1, "ms0dot5" },
  {   2, "ms1" },
  {   3, "ms2" },
  {   4, "ms4" },
  {   5, "ms5" },
  {   6, "ms10" },
  {   7, "ms20" },
  {   8, "ms30" },
  {   9, "ms40" },
  {  10, "ms50" },
  {  11, "ms60" },
  {  12, "ms70" },
  {  13, "ms80" },
  {  14, "ms90" },
  {  15, "ms100" },
  {  16, "ms150" },
  {  17, "ms300" },
  {  18, "ms500" },
  { 0, NULL }
};


static int
dissect_ngap_ExcessPacketDelayThresholdValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     19, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t ExcessPacketDelayThresholdItem_sequence[] = {
  { &hf_ngap_fiveQi         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_FiveQI },
  { &hf_ngap_excessPacketDelayThresholdValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ExcessPacketDelayThresholdValue },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ExcessPacketDelayThresholdItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ExcessPacketDelayThresholdItem, ExcessPacketDelayThresholdItem_sequence);

  return offset;
}


static const per_sequence_t ExcessPacketDelayThresholdConfiguration_sequence_of[1] = {
  { &hf_ngap_ExcessPacketDelayThresholdConfiguration_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_ExcessPacketDelayThresholdItem },
};

static int
dissect_ngap_ExcessPacketDelayThresholdConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_ExcessPacketDelayThresholdConfiguration, ExcessPacketDelayThresholdConfiguration_sequence_of,
                                                  1, maxnoofThresholdsForExcessPacketDelay, false);

  return offset;
}


static const per_sequence_t Extended_AMFName_sequence[] = {
  { &hf_ngap_aMFNameVisibleString, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AMFNameVisibleString },
  { &hf_ngap_aMFNameUTF8String, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AMFNameUTF8String },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_Extended_AMFName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_Extended_AMFName, Extended_AMFName_sequence);

  return offset;
}



static int
dissect_ngap_ExtendedPacketDelayBudget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 65535U, NULL, true);

  return offset;
}



static int
dissect_ngap_RANNodeNameVisibleString(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          1, 150, true,
                                          NULL);

  return offset;
}



static int
dissect_ngap_RANNodeNameUTF8String(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 150, true);

  return offset;
}


static const per_sequence_t Extended_RANNodeName_sequence[] = {
  { &hf_ngap_rANNodeNameVisibleString, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_RANNodeNameVisibleString },
  { &hf_ngap_rANNodeNameUTF8String, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_RANNodeNameUTF8String },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_Extended_RANNodeName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_Extended_RANNodeName, Extended_RANNodeName_sequence);

  return offset;
}



static int
dissect_ngap_T_primaryRATRestriction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, true, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_ngap_primaryRATRestriction_e_UTRA,
      &hf_ngap_primaryRATRestriction_nR,
      &hf_ngap_primaryRATRestriction_nR_unlicensed,
      &hf_ngap_primaryRATRestriction_nR_LEO,
      &hf_ngap_primaryRATRestriction_nR_MEO,
      &hf_ngap_primaryRATRestriction_nR_GEO,
      &hf_ngap_primaryRATRestriction_nR_OTHERSAT,
      &hf_ngap_primaryRATRestriction_e_UTRA_LEO,
      NULL
    };
    static int * const fields2[] = {
      &hf_ngap_primaryRATRestriction_e_UTRA_MEO,
      &hf_ngap_primaryRATRestriction_e_UTRA_GEO,
      &hf_ngap_primaryRATRestriction_e_UTRA_OTHERSAT,
      &hf_ngap_primaryRATRestriction_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_primaryRATRestriction);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
    if (tvb_reported_length(parameter_tvb) >= 2)
        proto_tree_add_bitmask_list(subtree, parameter_tvb, 1, 1, fields2, ENC_BIG_ENDIAN);
  }


  return offset;
}



static int
dissect_ngap_T_secondaryRATRestriction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, true, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_ngap_secondaryRATRestriction_e_UTRA,
      &hf_ngap_secondaryRATRestriction_nR,
      &hf_ngap_secondaryRATRestriction_e_UTRA_unlicensed,
      &hf_ngap_secondaryRATRestriction_nR_unlicensed,
      &hf_ngap_secondaryRATRestriction_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_secondaryRATRestriction);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t ExtendedRATRestrictionInformation_sequence[] = {
  { &hf_ngap_primaryRATRestriction, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_primaryRATRestriction },
  { &hf_ngap_secondaryRATRestriction, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_secondaryRATRestriction },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ExtendedRATRestrictionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ExtendedRATRestrictionInformation, ExtendedRATRestrictionInformation_sequence);

  return offset;
}



static int
dissect_ngap_ExtendedRNC_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            4096U, 65535U, NULL, false);

  return offset;
}


static const per_sequence_t ExtendedSliceSupportList_sequence_of[1] = {
  { &hf_ngap_ExtendedSliceSupportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_SliceSupportItem },
};

static int
dissect_ngap_ExtendedSliceSupportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_ExtendedSliceSupportList, ExtendedSliceSupportList_sequence_of,
                                                  1, maxnoofExtSliceItems, false);

  return offset;
}



static int
dissect_ngap_ExtendedUEIdentityIndexValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string ngap_T_outOfCoverage_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_outOfCoverage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_Threshold_RSRP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}



static int
dissect_ngap_Threshold_RSRQ(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}


static const value_string ngap_MeasurementThresholdL1LoggedMDT_vals[] = {
  {   0, "threshold-RSRP" },
  {   1, "threshold-RSRQ" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t MeasurementThresholdL1LoggedMDT_choice[] = {
  {   0, &hf_ngap_threshold_RSRP , ASN1_NO_EXTENSIONS     , dissect_ngap_Threshold_RSRP },
  {   1, &hf_ngap_threshold_RSRQ , ASN1_NO_EXTENSIONS     , dissect_ngap_Threshold_RSRQ },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_MeasurementThresholdL1LoggedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_MeasurementThresholdL1LoggedMDT, MeasurementThresholdL1LoggedMDT_choice,
                                 NULL);

  return offset;
}



static int
dissect_ngap_Hysteresis(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 30U, NULL, false);

  return offset;
}


static const value_string ngap_TimeToTrigger_vals[] = {
  {   0, "ms0" },
  {   1, "ms40" },
  {   2, "ms64" },
  {   3, "ms80" },
  {   4, "ms100" },
  {   5, "ms128" },
  {   6, "ms160" },
  {   7, "ms256" },
  {   8, "ms320" },
  {   9, "ms480" },
  {  10, "ms512" },
  {  11, "ms640" },
  {  12, "ms1024" },
  {  13, "ms1280" },
  {  14, "ms2560" },
  {  15, "ms5120" },
  { 0, NULL }
};


static int
dissect_ngap_TimeToTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t EventL1LoggedMDTConfig_sequence[] = {
  { &hf_ngap_l1Threshold    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MeasurementThresholdL1LoggedMDT },
  { &hf_ngap_hysteresis     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Hysteresis },
  { &hf_ngap_timeToTrigger  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TimeToTrigger },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EventL1LoggedMDTConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EventL1LoggedMDTConfig, EventL1LoggedMDTConfig_sequence);

  return offset;
}


static const value_string ngap_EventTrigger_vals[] = {
  {   0, "outOfCoverage" },
  {   1, "eventL1LoggedMDTConfig" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t EventTrigger_choice[] = {
  {   0, &hf_ngap_outOfCoverage  , ASN1_NO_EXTENSIONS     , dissect_ngap_T_outOfCoverage },
  {   1, &hf_ngap_eventL1LoggedMDTConfig, ASN1_NO_EXTENSIONS     , dissect_ngap_EventL1LoggedMDTConfig },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_EventTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_EventTrigger, EventTrigger_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t EquivalentSNPNsItem_sequence[] = {
  { &hf_ngap_plmnIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_nID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EquivalentSNPNsItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EquivalentSNPNsItem, EquivalentSNPNsItem_sequence);

  return offset;
}


static const per_sequence_t EquivalentSNPNsList_sequence_of[1] = {
  { &hf_ngap_EquivalentSNPNsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_EquivalentSNPNsItem },
};

static int
dissect_ngap_EquivalentSNPNsList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_EquivalentSNPNsList, EquivalentSNPNsList_sequence_of,
                                                  1, maxnoofESNPNs, false);

  return offset;
}



static int
dissect_ngap_NRUERLFReportContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *nr_ue_rlc_report_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &nr_ue_rlc_report_tvb);

  if (nr_ue_rlc_report_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_NRUERLFReportContainer);
    dissect_nr_rrc_nr_RLF_Report_r16_PDU(nr_ue_rlc_report_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_ngap_LTEUERLFReportContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *lte_ue_rlf_report_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &lte_ue_rlf_report_tvb);

  if (lte_ue_rlf_report_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_LTEUERLFReportContainer);
    dissect_lte_rrc_RLF_Report_r9_PDU(lte_ue_rlf_report_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string ngap_UERLFReportContainer_vals[] = {
  {   0, "nR" },
  {   1, "lTE" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t UERLFReportContainer_choice[] = {
  {   0, &hf_ngap_nR_01          , ASN1_NO_EXTENSIONS     , dissect_ngap_NRUERLFReportContainer },
  {   1, &hf_ngap_lTE            , ASN1_NO_EXTENSIONS     , dissect_ngap_LTEUERLFReportContainer },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_UERLFReportContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_UERLFReportContainer, UERLFReportContainer_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t FailureIndication_sequence[] = {
  { &hf_ngap_uERLFReportContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UERLFReportContainer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_FailureIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_FailureIndication, FailureIndication_sequence);

  return offset;
}


static const value_string ngap_NR_Paging_Long_eDRX_Cycle_for_RRC_INACTIVE_vals[] = {
  {   0, "hf2" },
  {   1, "hf4" },
  {   2, "hf8" },
  {   3, "hf16" },
  {   4, "hf32" },
  {   5, "hf64" },
  {   6, "hf128" },
  {   7, "hf256" },
  {   8, "hf512" },
  {   9, "hf1024" },
  { 0, NULL }
};


static int
dissect_ngap_NR_Paging_Long_eDRX_Cycle_for_RRC_INACTIVE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_NR_Paging_Time_Window_for_RRC_INACTIVE_vals[] = {
  {   0, "s1" },
  {   1, "s2" },
  {   2, "s3" },
  {   3, "s4" },
  {   4, "s5" },
  {   5, "s6" },
  {   6, "s7" },
  {   7, "s8" },
  {   8, "s9" },
  {   9, "s10" },
  {  10, "s11" },
  {  11, "s12" },
  {  12, "s13" },
  {  13, "s14" },
  {  14, "s15" },
  {  15, "s16" },
  {  16, "s17" },
  {  17, "s18" },
  {  18, "s19" },
  {  19, "s20" },
  {  20, "s21" },
  {  21, "s22" },
  {  22, "s23" },
  {  23, "s24" },
  {  24, "s25" },
  {  25, "s26" },
  {  26, "s27" },
  {  27, "s28" },
  {  28, "s29" },
  {  29, "s30" },
  {  30, "s31" },
  {  31, "s32" },
  { 0, NULL }
};


static int
dissect_ngap_NR_Paging_Time_Window_for_RRC_INACTIVE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NR_Paging_Long_eDRX_Information_for_RRC_INACTIVE_sequence[] = {
  { &hf_ngap_nR_paging_Long_eDRX_Cycle_for_RRC_INACTIVE, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NR_Paging_Long_eDRX_Cycle_for_RRC_INACTIVE },
  { &hf_ngap_nR_paging_Time_Window_for_RRC_INACTIVE, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NR_Paging_Time_Window_for_RRC_INACTIVE },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NR_Paging_Long_eDRX_Information_for_RRC_INACTIVE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NR_Paging_Long_eDRX_Information_for_RRC_INACTIVE, NR_Paging_Long_eDRX_Information_for_RRC_INACTIVE_sequence);

  return offset;
}


static const per_sequence_t HLComActivate_sequence[] = {
  { &hf_ngap_nR_Paging_Long_eDRX_Information_for_RRC_INACTIVE, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NR_Paging_Long_eDRX_Information_for_RRC_INACTIVE },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_HLComActivate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_HLComActivate, HLComActivate_sequence);

  return offset;
}


static const value_string ngap_T_uEReachabilityIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_uEReachabilityIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t HLComDeactivate_sequence[] = {
  { &hf_ngap_uEReachabilityIndication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_uEReachabilityIndication },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_HLComDeactivate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_HLComDeactivate, HLComDeactivate_sequence);

  return offset;
}


static const value_string ngap_FiveGCAction_vals[] = {
  {   0, "hLComActivate" },
  {   1, "hLComDeactivate" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t FiveGCAction_choice[] = {
  {   0, &hf_ngap_hLComActivate  , ASN1_NO_EXTENSIONS     , dissect_ngap_HLComActivate },
  {   1, &hf_ngap_hLComDeactivate, ASN1_NO_EXTENSIONS     , dissect_ngap_HLComDeactivate },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_FiveGCAction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_FiveGCAction, FiveGCAction_choice,
                                 NULL);

  return offset;
}


static const value_string ngap_FiveGProSeDirectDiscovery_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_FiveGProSeDirectDiscovery(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_FiveGProSeDirectCommunication_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_FiveGProSeDirectCommunication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_FiveGProSeLayer2UEtoNetworkRelay_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_FiveGProSeLayer2UEtoNetworkRelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_FiveGProSeLayer3UEtoNetworkRelay_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_FiveGProSeLayer3UEtoNetworkRelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_FiveGProSeLayer2RemoteUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_FiveGProSeLayer2RemoteUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t FiveG_ProSeAuthorized_sequence[] = {
  { &hf_ngap_fiveGProSeDirectDiscovery, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_FiveGProSeDirectDiscovery },
  { &hf_ngap_fiveGProSeDirectCommunication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_FiveGProSeDirectCommunication },
  { &hf_ngap_fiveGProSeLayer2UEtoNetworkRelay, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_FiveGProSeLayer2UEtoNetworkRelay },
  { &hf_ngap_fiveGProSeLayer3UEtoNetworkRelay, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_FiveGProSeLayer3UEtoNetworkRelay },
  { &hf_ngap_fiveGProSeLayer2RemoteUE, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_FiveGProSeLayer2RemoteUE },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_FiveG_ProSeAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_FiveG_ProSeAuthorized, FiveG_ProSeAuthorized_sequence);

  return offset;
}


static const value_string ngap_FiveGProSeLayer2Multipath_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_FiveGProSeLayer2Multipath(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_FiveGProSeLayer2UEtoUERelay_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_FiveGProSeLayer2UEtoUERelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_FiveGProSeLayer2UEtoUERemote_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_FiveGProSeLayer2UEtoUERemote(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t FiveGProSePC5FlowBitRates_sequence[] = {
  { &hf_ngap_fiveGproSeguaranteedFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_fiveGproSemaximumFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_FiveGProSePC5FlowBitRates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_FiveGProSePC5FlowBitRates, FiveGProSePC5FlowBitRates_sequence);

  return offset;
}


static const value_string ngap_Range_vals[] = {
  {   0, "m50" },
  {   1, "m80" },
  {   2, "m180" },
  {   3, "m200" },
  {   4, "m350" },
  {   5, "m400" },
  {   6, "m500" },
  {   7, "m700" },
  {   8, "m1000" },
  { 0, NULL }
};


static int
dissect_ngap_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t FiveGProSePC5QoSFlowItem_sequence[] = {
  { &hf_ngap_fiveGproSepQI  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_FiveQI },
  { &hf_ngap_fiveGproSepc5FlowBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_FiveGProSePC5FlowBitRates },
  { &hf_ngap_fiveGproSerange, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_Range },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_FiveGProSePC5QoSFlowItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_FiveGProSePC5QoSFlowItem, FiveGProSePC5QoSFlowItem_sequence);

  return offset;
}


static const per_sequence_t FiveGProSePC5QoSFlowList_sequence_of[1] = {
  { &hf_ngap_FiveGProSePC5QoSFlowList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_FiveGProSePC5QoSFlowItem },
};

static int
dissect_ngap_FiveGProSePC5QoSFlowList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_FiveGProSePC5QoSFlowList, FiveGProSePC5QoSFlowList_sequence_of,
                                                  1, maxnoofPC5QoSFlows, false);

  return offset;
}


static const per_sequence_t FiveG_ProSePC5QoSParameters_sequence[] = {
  { &hf_ngap_fiveGProSepc5QoSFlowList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_FiveGProSePC5QoSFlowList },
  { &hf_ngap_fiveGProSepc5LinkAggregateBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BitRate },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_FiveG_ProSePC5QoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_FiveG_ProSePC5QoSParameters, FiveG_ProSePC5QoSParameters_sequence);

  return offset;
}



static int
dissect_ngap_FiveG_TMSI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_item *ti;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       4, 4, false, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 4, ENC_BIG_ENDIAN);
    ti = proto_tree_add_item(tree, hf_3gpp_tmsi, tvb, 0, 4, ENC_BIG_ENDIAN);
    proto_item_set_hidden(ti);
  }


  return offset;
}


static const per_sequence_t FiveG_S_TMSI_sequence[] = {
  { &hf_ngap_aMFSetID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_AMFSetID },
  { &hf_ngap_aMFPointer     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_AMFPointer },
  { &hf_ngap_fiveG_TMSI     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_FiveG_TMSI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_FiveG_S_TMSI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_FiveG_S_TMSI, FiveG_S_TMSI_sequence);

  return offset;
}


static const per_sequence_t ForbiddenTACs_sequence_of[1] = {
  { &hf_ngap_ForbiddenTACs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAC },
};

static int
dissect_ngap_ForbiddenTACs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_ForbiddenTACs, ForbiddenTACs_sequence_of,
                                                  1, maxnoofForbTACs, false);

  return offset;
}


static const per_sequence_t ForbiddenAreaInformation_Item_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_forbiddenTACs  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ForbiddenTACs },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ForbiddenAreaInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ForbiddenAreaInformation_Item, ForbiddenAreaInformation_Item_sequence);

  return offset;
}


static const per_sequence_t ForbiddenAreaInformation_sequence_of[1] = {
  { &hf_ngap_ForbiddenAreaInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_ForbiddenAreaInformation_Item },
};

static int
dissect_ngap_ForbiddenAreaInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_ForbiddenAreaInformation, ForbiddenAreaInformation_sequence_of,
                                                  1, maxnoofEPLMNsPlusOne, false);

  return offset;
}


static const per_sequence_t GlobalENB_ID_sequence[] = {
  { &hf_ngap_pLMNidentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_eNB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ENB_ID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_GlobalENB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_GlobalENB_ID, GlobalENB_ID_sequence);

  return offset;
}


static const per_sequence_t IntersystemSONeNBID_sequence[] = {
  { &hf_ngap_globaleNBID    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_GlobalENB_ID },
  { &hf_ngap_selectedEPSTAI , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EPS_TAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_IntersystemSONeNBID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_IntersystemSONeNBID, IntersystemSONeNBID_sequence);

  return offset;
}


static const per_sequence_t IntersystemSONNGRANnodeID_sequence[] = {
  { &hf_ngap_globalRANNodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_GlobalRANNodeID },
  { &hf_ngap_selectedTAI    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_IntersystemSONNGRANnodeID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_IntersystemSONNGRANnodeID, IntersystemSONNGRANnodeID_sequence);

  return offset;
}


static const per_sequence_t FromEUTRANtoNGRAN_sequence[] = {
  { &hf_ngap_sourceeNBID    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_IntersystemSONeNBID },
  { &hf_ngap_targetNGRANnodeID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_IntersystemSONNGRANnodeID },
  { &hf_ngap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_FromEUTRANtoNGRAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_FromEUTRANtoNGRAN, FromEUTRANtoNGRAN_sequence);

  return offset;
}


static const per_sequence_t FromNGRANtoEUTRAN_sequence[] = {
  { &hf_ngap_sourceNGRANnodeID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_IntersystemSONNGRANnodeID },
  { &hf_ngap_targeteNBID    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_IntersystemSONeNBID },
  { &hf_ngap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_FromNGRANtoEUTRAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_FromNGRANtoEUTRAN, FromNGRANtoEUTRAN_sequence);

  return offset;
}


static const value_string ngap_NotificationControl_vals[] = {
  {   0, "notification-requested" },
  { 0, NULL }
};


static int
dissect_ngap_NotificationControl(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_PacketLossRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1000U, NULL, true);

  return offset;
}


static const per_sequence_t GBR_QosInformation_sequence[] = {
  { &hf_ngap_maximumFlowBitRateDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_maximumFlowBitRateUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_guaranteedFlowBitRateDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_guaranteedFlowBitRateUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_notificationControl, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NotificationControl },
  { &hf_ngap_maximumPacketLossRateDL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PacketLossRate },
  { &hf_ngap_maximumPacketLossRateUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PacketLossRate },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_GBR_QosInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_GBR_QosInformation, GBR_QosInformation_sequence);

  return offset;
}



static int
dissect_ngap_GlobalCable_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_GlobalCable_ID);
    proto_tree_add_item(subtree, hf_ngap_GlobalCable_ID_str, parameter_tvb, 0, -1, ENC_UTF_8 | ENC_NA);
  }


  return offset;
}


static const per_sequence_t GlobalCable_ID_new_sequence[] = {
  { &hf_ngap_globalCable_ID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_GlobalCable_ID },
  { &hf_ngap_tAI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_GlobalCable_ID_new(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_GlobalCable_ID_new, GlobalCable_ID_new_sequence);

  return offset;
}



static int
dissect_ngap_GlobalLineIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}


static const value_string ngap_LineType_vals[] = {
  {   0, "dsl" },
  {   1, "pon" },
  { 0, NULL }
};


static int
dissect_ngap_LineType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t GlobalLine_ID_sequence[] = {
  { &hf_ngap_globalLineIdentity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_GlobalLineIdentity },
  { &hf_ngap_lineType       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_LineType },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_GlobalLine_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_GlobalLine_ID, GlobalLine_ID_sequence);

  return offset;
}



static int
dissect_ngap_BIT_STRING_SIZE_32_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, true, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string ngap_TNGF_ID_vals[] = {
  {   0, "tNGF-ID" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t TNGF_ID_choice[] = {
  {   0, &hf_ngap_tNGF_ID        , ASN1_NO_EXTENSIONS     , dissect_ngap_BIT_STRING_SIZE_32_ },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_TNGF_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_TNGF_ID, TNGF_ID_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GlobalTNGF_ID_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_globalTNGF_ID_tNGF_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TNGF_ID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_GlobalTNGF_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_GlobalTNGF_ID, GlobalTNGF_ID_sequence);

  return offset;
}


static const value_string ngap_TWIF_ID_vals[] = {
  {   0, "tWIF-ID" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t TWIF_ID_choice[] = {
  {   0, &hf_ngap_tWIF_ID        , ASN1_NO_EXTENSIONS     , dissect_ngap_BIT_STRING_SIZE_32_ },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_TWIF_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_TWIF_ID, TWIF_ID_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GlobalTWIF_ID_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_globalTWIF_ID_tWIF_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TWIF_ID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_GlobalTWIF_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_GlobalTWIF_ID, GlobalTWIF_ID_sequence);

  return offset;
}


static const value_string ngap_W_AGF_ID_vals[] = {
  {   0, "w-AGF-ID" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t W_AGF_ID_choice[] = {
  {   0, &hf_ngap_w_AGF_ID       , ASN1_NO_EXTENSIONS     , dissect_ngap_BIT_STRING_SIZE_16_ },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_W_AGF_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_W_AGF_ID, W_AGF_ID_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GlobalW_AGF_ID_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_globalW_AGF_ID_w_AGF_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_W_AGF_ID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_GlobalW_AGF_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_GlobalW_AGF_ID, GlobalW_AGF_ID_sequence);

  return offset;
}


static const per_sequence_t GUAMI_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_aMFRegionID    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_AMFRegionID },
  { &hf_ngap_aMFSetID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_AMFSetID },
  { &hf_ngap_aMFPointer     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_AMFPointer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_GUAMI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  ngap_data->number_type = E212_GUAMI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_GUAMI, GUAMI_sequence);



  return offset;
}


static const value_string ngap_GUAMIType_vals[] = {
  {   0, "native" },
  {   1, "mapped" },
  { 0, NULL }
};


static int
dissect_ngap_GUAMIType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t QosFlowToBeForwardedItem_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowToBeForwardedItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowToBeForwardedItem, QosFlowToBeForwardedItem_sequence);

  return offset;
}


static const per_sequence_t QosFlowToBeForwardedList_sequence_of[1] = {
  { &hf_ngap_QosFlowToBeForwardedList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowToBeForwardedItem },
};

static int
dissect_ngap_QosFlowToBeForwardedList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowToBeForwardedList, QosFlowToBeForwardedList_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const per_sequence_t HandoverCommandTransfer_sequence[] = {
  { &hf_ngap_dLForwardingUP_TNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_qosFlowToBeForwardedList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QosFlowToBeForwardedList },
  { &hf_ngap_dataForwardingResponseDRBList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_DataForwardingResponseDRBList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_HandoverCommandTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "HandoverCommandTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_HandoverCommandTransfer, HandoverCommandTransfer_sequence);

  return offset;
}


static const value_string ngap_HandoverFlag_vals[] = {
  {   0, "handover-preparation" },
  { 0, NULL }
};


static int
dissect_ngap_HandoverFlag(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t HandoverPreparationUnsuccessfulTransfer_sequence[] = {
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_HandoverPreparationUnsuccessfulTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "HandoverPreparationUnsuccessfulTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_HandoverPreparationUnsuccessfulTransfer, HandoverPreparationUnsuccessfulTransfer_sequence);

  return offset;
}


static const value_string ngap_IntegrityProtectionResult_vals[] = {
  {   0, "performed" },
  {   1, "not-performed" },
  { 0, NULL }
};


static int
dissect_ngap_IntegrityProtectionResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t SecurityResult_sequence[] = {
  { &hf_ngap_integrityProtectionResult, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_IntegrityProtectionResult },
  { &hf_ngap_confidentialityProtectionResult, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ConfidentialityProtectionResult },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SecurityResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SecurityResult, SecurityResult_sequence);

  return offset;
}


static const per_sequence_t QosFlowWithCauseItem_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowWithCauseItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowWithCauseItem, QosFlowWithCauseItem_sequence);

  return offset;
}


static const per_sequence_t QosFlowListWithCause_sequence_of[1] = {
  { &hf_ngap_QosFlowListWithCause_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowWithCauseItem },
};

static int
dissect_ngap_QosFlowListWithCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowListWithCause, QosFlowListWithCause_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const per_sequence_t HandoverRequestAcknowledgeTransfer_sequence[] = {
  { &hf_ngap_dL_NGU_UP_TNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_dLForwardingUP_TNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_securityResult , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_SecurityResult },
  { &hf_ngap_qosFlowSetupResponseList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowListWithDataForwarding },
  { &hf_ngap_qosFlowFailedToSetupList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QosFlowListWithCause },
  { &hf_ngap_dataForwardingResponseDRBList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_DataForwardingResponseDRBList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_HandoverRequestAcknowledgeTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "HandoverRequestAcknowledgeTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_HandoverRequestAcknowledgeTransfer, HandoverRequestAcknowledgeTransfer_sequence);

  return offset;
}


static const per_sequence_t HandoverRequiredTransfer_sequence[] = {
  { &hf_ngap_directForwardingPathAvailability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_DirectForwardingPathAvailability },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_HandoverRequiredTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "HandoverRequiredTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_HandoverRequiredTransfer, HandoverRequiredTransfer_sequence);

  return offset;
}


static const per_sequence_t HandoverResourceAllocationUnsuccessfulTransfer_sequence[] = {
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_criticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_CriticalityDiagnostics },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_HandoverResourceAllocationUnsuccessfulTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "HandoverResourceAllocationUnsuccessfulTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_HandoverResourceAllocationUnsuccessfulTransfer, HandoverResourceAllocationUnsuccessfulTransfer_sequence);

  return offset;
}


static const value_string ngap_HandoverType_vals[] = {
  { intra5gs, "intra5gs" },
  { fivegs_to_eps, "fivegs-to-eps" },
  { eps_to_5gs, "eps-to-5gs" },
  { fivegs_to_utran, "fivegs-to-utran" },
  { 0, NULL }
};


static int
dissect_ngap_HandoverType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, &ngap_data->handover_type_value, true, 1, NULL);




  return offset;
}



static int
dissect_ngap_HashedUEIdentityIndexValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     13, 13, true, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_ngap_HFCNode_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}


static const per_sequence_t HFCNode_ID_new_sequence[] = {
  { &hf_ngap_hFCNode_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_HFCNode_ID },
  { &hf_ngap_tAI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_HFCNode_ID_new(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_HFCNode_ID_new, HFCNode_ID_new_sequence);

  return offset;
}


static const value_string ngap_T_handoverReportType_vals[] = {
  {   0, "ho-too-early" },
  {   1, "ho-to-wrong-cell" },
  {   2, "intersystem-ping-pong" },
  { 0, NULL }
};


static int
dissect_ngap_T_handoverReportType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_MobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t HOReport_sequence[] = {
  { &hf_ngap_handoverReportType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_handoverReportType },
  { &hf_ngap_handoverCause  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_sourcecellCGI  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
  { &hf_ngap_targetcellCGI  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
  { &hf_ngap_reestablishmentcellCGI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NGRAN_CGI },
  { &hf_ngap_sourcecellC_RNTI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BIT_STRING_SIZE_16 },
  { &hf_ngap_targetcellinE_UTRAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_EUTRA_CGI },
  { &hf_ngap_mobilityInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MobilityInformation },
  { &hf_ngap_uERLFReportContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UERLFReportContainer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_HOReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_HOReport, HOReport_sequence);

  return offset;
}


static const value_string ngap_IAB_Authorized_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_IAB_Authorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MobileIAB_MTUserLocationInformation_sequence[] = {
  { &hf_ngap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NR_CGI },
  { &hf_ngap_tAI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MobileIAB_MTUserLocationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MobileIAB_MTUserLocationInformation, MobileIAB_MTUserLocationInformation_sequence);

  return offset;
}


static const value_string ngap_IAB_Supported_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_IAB_Supported(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_IABNodeIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_IABNodeIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_IMSVoiceSupportIndicator_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  { 0, NULL }
};


static int
dissect_ngap_IMSVoiceSupportIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_IndexToRFSP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, true);

  return offset;
}


static const per_sequence_t RecommendedRANNodeItem_sequence[] = {
  { &hf_ngap_aMFPagingTarget, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_AMFPagingTarget },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RecommendedRANNodeItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RecommendedRANNodeItem, RecommendedRANNodeItem_sequence);

  return offset;
}


static const per_sequence_t RecommendedRANNodeList_sequence_of[1] = {
  { &hf_ngap_RecommendedRANNodeList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_RecommendedRANNodeItem },
};

static int
dissect_ngap_RecommendedRANNodeList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_RecommendedRANNodeList, RecommendedRANNodeList_sequence_of,
                                                  1, maxnoofRecommendedRANNodes, false);

  return offset;
}


static const per_sequence_t RecommendedRANNodesForPaging_sequence[] = {
  { &hf_ngap_recommendedRANNodeList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_RecommendedRANNodeList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RecommendedRANNodesForPaging(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RecommendedRANNodesForPaging, RecommendedRANNodesForPaging_sequence);

  return offset;
}


static const per_sequence_t InfoOnRecommendedCellsAndRANNodesForPaging_sequence[] = {
  { &hf_ngap_recommendedCellsForPaging, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_RecommendedCellsForPaging },
  { &hf_ngap_recommendRANNodesForPaging, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_RecommendedRANNodesForPaging },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_InfoOnRecommendedCellsAndRANNodesForPaging(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_InfoOnRecommendedCellsAndRANNodesForPaging, InfoOnRecommendedCellsAndRANNodesForPaging_sequence);

  return offset;
}


static const value_string ngap_IntegrityProtectionIndication_vals[] = {
  {   0, "required" },
  {   1, "preferred" },
  {   2, "not-needed" },
  { 0, NULL }
};


static int
dissect_ngap_IntegrityProtectionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_InterfacesToTrace(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_ngap_InterfacesToTrace_NG_C,
      &hf_ngap_InterfacesToTrace_Xn_C,
      &hf_ngap_InterfacesToTrace_Uu,
      &hf_ngap_InterfacesToTrace_F1_C,
      &hf_ngap_InterfacesToTrace_E1,
      &hf_ngap_InterfacesToTrace_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_InterfacesToTrace);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}



static int
dissect_ngap_MeasurementsToActivate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_ngap_MeasurementsToActivate_M1,
      &hf_ngap_MeasurementsToActivate_M2,
      &hf_ngap_MeasurementsToActivate_M4,
      &hf_ngap_MeasurementsToActivate_M5,
      &hf_ngap_MeasurementsToActivate_M6,
      &hf_ngap_MeasurementsToActivate_M7,
      &hf_ngap_MeasurementsToActivate_M1_from_event,
      &hf_ngap_MeasurementsToActivate_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_MeasurementsToActivate);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const value_string ngap_M1ReportingTrigger_vals[] = {
  {   0, "periodic" },
  {   1, "a2eventtriggered" },
  {   2, "a2eventtriggered-periodic" },
  { 0, NULL }
};


static int
dissect_ngap_M1ReportingTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_Threshold_SINR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}


static const value_string ngap_M1ThresholdType_vals[] = {
  {   0, "threshold-RSRP" },
  {   1, "threshold-RSRQ" },
  {   2, "threshold-SINR" },
  {   3, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t M1ThresholdType_choice[] = {
  {   0, &hf_ngap_threshold_RSRP , ASN1_NO_EXTENSIONS     , dissect_ngap_Threshold_RSRP },
  {   1, &hf_ngap_threshold_RSRQ , ASN1_NO_EXTENSIONS     , dissect_ngap_Threshold_RSRQ },
  {   2, &hf_ngap_threshold_SINR , ASN1_NO_EXTENSIONS     , dissect_ngap_Threshold_SINR },
  {   3, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_M1ThresholdType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_M1ThresholdType, M1ThresholdType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t M1ThresholdEventA2_sequence[] = {
  { &hf_ngap_m1ThresholdType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_M1ThresholdType },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_M1ThresholdEventA2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_M1ThresholdEventA2, M1ThresholdEventA2_sequence);

  return offset;
}


static const value_string ngap_ReportIntervalMDT_vals[] = {
  {   0, "ms120" },
  {   1, "ms240" },
  {   2, "ms480" },
  {   3, "ms640" },
  {   4, "ms1024" },
  {   5, "ms2048" },
  {   6, "ms5120" },
  {   7, "ms10240" },
  {   8, "min1" },
  {   9, "min6" },
  {  10, "min12" },
  {  11, "min30" },
  {  12, "min60" },
  { 0, NULL }
};


static int
dissect_ngap_ReportIntervalMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     13, NULL, false, 0, NULL);

  return offset;
}


static const value_string ngap_ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "rinfinity" },
  { 0, NULL }
};


static int
dissect_ngap_ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t M1PeriodicReporting_sequence[] = {
  { &hf_ngap_reportInterval , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ReportIntervalMDT },
  { &hf_ngap_reportAmount   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ReportAmountMDT },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_M1PeriodicReporting(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_M1PeriodicReporting, M1PeriodicReporting_sequence);

  return offset;
}


static const per_sequence_t M1Configuration_sequence[] = {
  { &hf_ngap_m1reportingTrigger, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_M1ReportingTrigger },
  { &hf_ngap_m1thresholdEventA2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_M1ThresholdEventA2 },
  { &hf_ngap_m1periodicReporting, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_M1PeriodicReporting },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_M1Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_M1Configuration, M1Configuration_sequence);

  return offset;
}


static const value_string ngap_M4period_vals[] = {
  {   0, "ms1024" },
  {   1, "ms2048" },
  {   2, "ms5120" },
  {   3, "ms10240" },
  {   4, "min1" },
  { 0, NULL }
};


static int
dissect_ngap_M4period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_Links_to_log_vals[] = {
  {   0, "uplink" },
  {   1, "downlink" },
  {   2, "both-uplink-and-downlink" },
  { 0, NULL }
};


static int
dissect_ngap_Links_to_log(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t M4Configuration_sequence[] = {
  { &hf_ngap_m4period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_M4period },
  { &hf_ngap_m4_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Links_to_log },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_M4Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_M4Configuration, M4Configuration_sequence);

  return offset;
}


static const value_string ngap_M5period_vals[] = {
  {   0, "ms1024" },
  {   1, "ms2048" },
  {   2, "ms5120" },
  {   3, "ms10240" },
  {   4, "min1" },
  { 0, NULL }
};


static int
dissect_ngap_M5period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t M5Configuration_sequence[] = {
  { &hf_ngap_m5period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_M5period },
  { &hf_ngap_m5_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Links_to_log },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_M5Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_M5Configuration, M5Configuration_sequence);

  return offset;
}


static const value_string ngap_M6report_Interval_vals[] = {
  {   0, "ms120" },
  {   1, "ms240" },
  {   2, "ms480" },
  {   3, "ms640" },
  {   4, "ms1024" },
  {   5, "ms2048" },
  {   6, "ms5120" },
  {   7, "ms10240" },
  {   8, "ms20480" },
  {   9, "ms40960" },
  {  10, "min1" },
  {  11, "min6" },
  {  12, "min12" },
  {  13, "min30" },
  { 0, NULL }
};


static int
dissect_ngap_M6report_Interval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     14, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t M6Configuration_sequence[] = {
  { &hf_ngap_m6report_Interval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_M6report_Interval },
  { &hf_ngap_m6_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Links_to_log },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_M6Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_M6Configuration, M6Configuration_sequence);

  return offset;
}



static int
dissect_ngap_M7period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 60U, NULL, true);

  return offset;
}


static const per_sequence_t M7Configuration_sequence[] = {
  { &hf_ngap_m7period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_M7period },
  { &hf_ngap_m7_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Links_to_log },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_M7Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_M7Configuration, M7Configuration_sequence);

  return offset;
}


static const value_string ngap_WLANMeasConfig_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_ngap_WLANMeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_WLANName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       1, 32, false, &parameter_tvb);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, -1, ENC_UTF_8|ENC_NA);

  return offset;
}


static const per_sequence_t WLANMeasConfigNameItem_sequence[] = {
  { &hf_ngap_wLANName       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_WLANName },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_WLANMeasConfigNameItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_WLANMeasConfigNameItem, WLANMeasConfigNameItem_sequence);

  return offset;
}


static const per_sequence_t WLANMeasConfigNameList_sequence_of[1] = {
  { &hf_ngap_WLANMeasConfigNameList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_WLANMeasConfigNameItem },
};

static int
dissect_ngap_WLANMeasConfigNameList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_WLANMeasConfigNameList, WLANMeasConfigNameList_sequence_of,
                                                  1, maxnoofWLANName, false);

  return offset;
}


static const value_string ngap_T_wlan_rssi_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_wlan_rssi(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_wlan_rtt_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_wlan_rtt(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t WLANMeasurementConfiguration_sequence[] = {
  { &hf_ngap_wlanMeasConfig , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_WLANMeasConfig },
  { &hf_ngap_wlanMeasConfigNameList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_WLANMeasConfigNameList },
  { &hf_ngap_wlan_rssi      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_wlan_rssi },
  { &hf_ngap_wlan_rtt       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_wlan_rtt },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_WLANMeasurementConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_WLANMeasurementConfiguration, WLANMeasurementConfiguration_sequence);

  return offset;
}



static int
dissect_ngap_MDT_Location_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_ngap_MDT_Location_Information_GNSS,
      &hf_ngap_MDT_Location_Information_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_MDT_Location_Information);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t MDT_Location_Info_sequence[] = {
  { &hf_ngap_mDT_Location_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MDT_Location_Information },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MDT_Location_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MDT_Location_Info, MDT_Location_Info_sequence);

  return offset;
}


static const value_string ngap_SensorMeasConfig_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_ngap_SensorMeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_uncompensatedBarometricConfig_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_uncompensatedBarometricConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_ueSpeedConfig_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_ueSpeedConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_ueOrientationConfig_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_ueOrientationConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_SensorNameConfig_vals[] = {
  {   0, "uncompensatedBarometricConfig" },
  {   1, "ueSpeedConfig" },
  {   2, "ueOrientationConfig" },
  {   3, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t SensorNameConfig_choice[] = {
  {   0, &hf_ngap_uncompensatedBarometricConfig, ASN1_NO_EXTENSIONS     , dissect_ngap_T_uncompensatedBarometricConfig },
  {   1, &hf_ngap_ueSpeedConfig  , ASN1_NO_EXTENSIONS     , dissect_ngap_T_ueSpeedConfig },
  {   2, &hf_ngap_ueOrientationConfig, ASN1_NO_EXTENSIONS     , dissect_ngap_T_ueOrientationConfig },
  {   3, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_SensorNameConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_SensorNameConfig, SensorNameConfig_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SensorMeasConfigNameItem_sequence[] = {
  { &hf_ngap_sensorNameConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SensorNameConfig },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SensorMeasConfigNameItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SensorMeasConfigNameItem, SensorMeasConfigNameItem_sequence);

  return offset;
}


static const per_sequence_t SensorMeasConfigNameList_sequence_of[1] = {
  { &hf_ngap_SensorMeasConfigNameList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_SensorMeasConfigNameItem },
};

static int
dissect_ngap_SensorMeasConfigNameList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_SensorMeasConfigNameList, SensorMeasConfigNameList_sequence_of,
                                                  1, maxnoofSensorName, false);

  return offset;
}


static const per_sequence_t SensorMeasurementConfiguration_sequence[] = {
  { &hf_ngap_sensorMeasConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SensorMeasConfig },
  { &hf_ngap_sensorMeasConfigNameList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_SensorMeasConfigNameList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SensorMeasurementConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SensorMeasurementConfiguration, SensorMeasurementConfiguration_sequence);

  return offset;
}


static const per_sequence_t ImmediateMDTNr_sequence[] = {
  { &hf_ngap_measurementsToActivate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MeasurementsToActivate },
  { &hf_ngap_m1Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_M1Configuration },
  { &hf_ngap_m4Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_M4Configuration },
  { &hf_ngap_m5Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_M5Configuration },
  { &hf_ngap_m6Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_M6Configuration },
  { &hf_ngap_m7Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_M7Configuration },
  { &hf_ngap_bluetoothMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BluetoothMeasurementConfiguration },
  { &hf_ngap_wLANMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_WLANMeasurementConfiguration },
  { &hf_ngap_mDT_Location_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MDT_Location_Info },
  { &hf_ngap_sensorMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_SensorMeasurementConfiguration },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ImmediateMDTNr(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ImmediateMDTNr, ImmediateMDTNr_sequence);

  return offset;
}


static const per_sequence_t InterSystemFailureIndication_sequence[] = {
  { &hf_ngap_uERLFReportContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UERLFReportContainer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_InterSystemFailureIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_InterSystemFailureIndication, InterSystemFailureIndication_sequence);

  return offset;
}


static const value_string ngap_IntersystemSONTransferType_vals[] = {
  {   0, "fromEUTRANtoNGRAN" },
  {   1, "fromNGRANtoEUTRAN" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t IntersystemSONTransferType_choice[] = {
  {   0, &hf_ngap_fromEUTRANtoNGRAN, ASN1_NO_EXTENSIONS     , dissect_ngap_FromEUTRANtoNGRAN },
  {   1, &hf_ngap_fromNGRANtoEUTRAN, ASN1_NO_EXTENSIONS     , dissect_ngap_FromNGRANtoEUTRAN },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_IntersystemSONTransferType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_IntersystemSONTransferType, IntersystemSONTransferType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TooearlyIntersystemHO_sequence[] = {
  { &hf_ngap_sourcecellID_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
  { &hf_ngap_failurecellID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
  { &hf_ngap_uERLFReportContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UERLFReportContainer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TooearlyIntersystemHO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TooearlyIntersystemHO, TooearlyIntersystemHO_sequence);

  return offset;
}


static const value_string ngap_T_earlyIRATHO_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_ngap_T_earlyIRATHO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t IntersystemUnnecessaryHO_sequence[] = {
  { &hf_ngap_sourcecellID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
  { &hf_ngap_targetcellID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
  { &hf_ngap_earlyIRATHO    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_earlyIRATHO },
  { &hf_ngap_candidateCellList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CandidateCellList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_IntersystemUnnecessaryHO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_IntersystemUnnecessaryHO, IntersystemUnnecessaryHO_sequence);

  return offset;
}


static const value_string ngap_InterSystemHandoverReportType_vals[] = {
  {   0, "tooearlyIntersystemHO" },
  {   1, "intersystemUnnecessaryHO" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t InterSystemHandoverReportType_choice[] = {
  {   0, &hf_ngap_tooearlyIntersystemHO, ASN1_NO_EXTENSIONS     , dissect_ngap_TooearlyIntersystemHO },
  {   1, &hf_ngap_intersystemUnnecessaryHO, ASN1_NO_EXTENSIONS     , dissect_ngap_IntersystemUnnecessaryHO },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_InterSystemHandoverReportType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_InterSystemHandoverReportType, InterSystemHandoverReportType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t InterSystemHOReport_sequence[] = {
  { &hf_ngap_handoverReportType_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_InterSystemHandoverReportType },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_InterSystemHOReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_InterSystemHOReport, InterSystemHOReport_sequence);

  return offset;
}


static const value_string ngap_IntersystemSONInformationReport_vals[] = {
  {   0, "hOReportInformation" },
  {   1, "failureIndicationInformation" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t IntersystemSONInformationReport_choice[] = {
  {   0, &hf_ngap_hOReportInformation, ASN1_NO_EXTENSIONS     , dissect_ngap_InterSystemHOReport },
  {   1, &hf_ngap_failureIndicationInformation, ASN1_NO_EXTENSIONS     , dissect_ngap_InterSystemFailureIndication },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_IntersystemSONInformationReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_IntersystemSONInformationReport, IntersystemSONInformationReport_choice,
                                 NULL);

  return offset;
}


static const value_string ngap_IntersystemSONInformation_vals[] = {
  {   0, "intersystemSONInformationReport" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t IntersystemSONInformation_choice[] = {
  {   0, &hf_ngap_intersystemSONInformationReport, ASN1_NO_EXTENSIONS     , dissect_ngap_IntersystemSONInformationReport },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_IntersystemSONInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_IntersystemSONInformation, IntersystemSONInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t IntersystemSONConfigurationTransfer_sequence[] = {
  { &hf_ngap_transferType   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_IntersystemSONTransferType },
  { &hf_ngap_intersystemSONInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_IntersystemSONInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_IntersystemSONConfigurationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_IntersystemSONConfigurationTransfer, IntersystemSONConfigurationTransfer_sequence);

  return offset;
}



static int
dissect_ngap_INTEGER_0_16384_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16384U, NULL, true);

  return offset;
}


static const per_sequence_t CellsToActivateList_sequence_of[1] = {
  { &hf_ngap_CellsToActivateList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
};

static int
dissect_ngap_CellsToActivateList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_CellsToActivateList, CellsToActivateList_sequence_of,
                                                  1, maxnoofCellsinNGRANNode, false);

  return offset;
}


static const per_sequence_t IntersystemCellActivationRequest_sequence[] = {
  { &hf_ngap_activationID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_16384_ },
  { &hf_ngap_cellsToActivateList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CellsToActivateList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_IntersystemCellActivationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_IntersystemCellActivationRequest, IntersystemCellActivationRequest_sequence);

  return offset;
}


static const per_sequence_t EUTRAN_CellToReportItem_sequence[] = {
  { &hf_ngap_eCGI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EUTRAN_CellToReportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EUTRAN_CellToReportItem, EUTRAN_CellToReportItem_sequence);

  return offset;
}


static const per_sequence_t EUTRAN_CellToReportList_sequence_of[1] = {
  { &hf_ngap_EUTRAN_CellToReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRAN_CellToReportItem },
};

static int
dissect_ngap_EUTRAN_CellToReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_EUTRAN_CellToReportList, EUTRAN_CellToReportList_sequence_of,
                                                  1, maxnoofReportedCells, false);

  return offset;
}


static const per_sequence_t EUTRAN_ReportingSystemIEs_sequence[] = {
  { &hf_ngap_eUTRAN_CellToReportList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRAN_CellToReportList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EUTRAN_ReportingSystemIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EUTRAN_ReportingSystemIEs, EUTRAN_ReportingSystemIEs_sequence);

  return offset;
}


static const per_sequence_t NGRAN_CellToReportItem_sequence[] = {
  { &hf_ngap_nGRAN_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NGRAN_CellToReportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NGRAN_CellToReportItem, NGRAN_CellToReportItem_sequence);

  return offset;
}


static const per_sequence_t NGRAN_CellToReportList_sequence_of[1] = {
  { &hf_ngap_NGRAN_CellToReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CellToReportItem },
};

static int
dissect_ngap_NGRAN_CellToReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_NGRAN_CellToReportList, NGRAN_CellToReportList_sequence_of,
                                                  1, maxnoofReportedCells, false);

  return offset;
}


static const per_sequence_t NGRAN_ReportingSystemIEs_sequence[] = {
  { &hf_ngap_nGRAN_CellToReportList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CellToReportList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NGRAN_ReportingSystemIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NGRAN_ReportingSystemIEs, NGRAN_ReportingSystemIEs_sequence);

  return offset;
}


static const value_string ngap_ReportingSystem_vals[] = {
  {   0, "eUTRAN" },
  {   1, "nGRAN" },
  {   2, "noReporting" },
  {   3, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t ReportingSystem_choice[] = {
  {   0, &hf_ngap_eUTRAN         , ASN1_NO_EXTENSIONS     , dissect_ngap_EUTRAN_ReportingSystemIEs },
  {   1, &hf_ngap_nGRAN          , ASN1_NO_EXTENSIONS     , dissect_ngap_NGRAN_ReportingSystemIEs },
  {   2, &hf_ngap_noReporting    , ASN1_NO_EXTENSIONS     , dissect_ngap_NULL },
  {   3, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_ReportingSystem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_ReportingSystem, ReportingSystem_choice,
                                 NULL);

  return offset;
}



static int
dissect_ngap_ReportCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_ngap_IntersystemResourceThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}


static const value_string ngap_NumberOfMeasurementReportingLevels_vals[] = {
  {   0, "n2" },
  {   1, "n3" },
  {   2, "n4" },
  {   3, "n5" },
  {   4, "n10" },
  {   5, "n0" },
  { 0, NULL }
};


static int
dissect_ngap_NumberOfMeasurementReportingLevels(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, true, 1, NULL);

  return offset;
}


static const per_sequence_t EventBasedReportingIEs_sequence[] = {
  { &hf_ngap_intersystemResourceThresholdLow, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_IntersystemResourceThreshold },
  { &hf_ngap_intersystemResourceThresholdHigh, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_IntersystemResourceThreshold },
  { &hf_ngap_numberOfMeasurementReportingLevels, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NumberOfMeasurementReportingLevels },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EventBasedReportingIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EventBasedReportingIEs, EventBasedReportingIEs_sequence);

  return offset;
}


static const value_string ngap_ReportingPeriodicity_vals[] = {
  {   0, "stop" },
  {   1, "single" },
  {   2, "ms1000" },
  {   3, "ms2000" },
  {   4, "ms5000" },
  {   5, "ms10000" },
  { 0, NULL }
};


static int
dissect_ngap_ReportingPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PeriodicReportingIEs_sequence[] = {
  { &hf_ngap_reportingPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ReportingPeriodicity },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PeriodicReportingIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PeriodicReportingIEs, PeriodicReportingIEs_sequence);

  return offset;
}


static const value_string ngap_ReportType_vals[] = {
  {   0, "eventBasedReporting" },
  {   1, "periodicReporting" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t ReportType_choice[] = {
  {   0, &hf_ngap_eventBasedReporting, ASN1_NO_EXTENSIONS     , dissect_ngap_EventBasedReportingIEs },
  {   1, &hf_ngap_periodicReporting, ASN1_NO_EXTENSIONS     , dissect_ngap_PeriodicReportingIEs },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_ReportType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_ReportType, ReportType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t IntersystemResourceStatusRequest_sequence[] = {
  { &hf_ngap_reportingSystem, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ReportingSystem },
  { &hf_ngap_reportCharacteristics, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ReportCharacteristics },
  { &hf_ngap_reportType     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ReportType },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_IntersystemResourceStatusRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_IntersystemResourceStatusRequest, IntersystemResourceStatusRequest_sequence);

  return offset;
}


static const value_string ngap_IntersystemSONInformationRequest_vals[] = {
  {   0, "nGRAN-CellActivation" },
  {   1, "resourceStatus" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t IntersystemSONInformationRequest_choice[] = {
  {   0, &hf_ngap_nGRAN_CellActivation, ASN1_NO_EXTENSIONS     , dissect_ngap_IntersystemCellActivationRequest },
  {   1, &hf_ngap_resourceStatus , ASN1_NO_EXTENSIONS     , dissect_ngap_IntersystemResourceStatusRequest },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_IntersystemSONInformationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_IntersystemSONInformationRequest, IntersystemSONInformationRequest_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ActivatedCellList_sequence_of[1] = {
  { &hf_ngap_ActivatedCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
};

static int
dissect_ngap_ActivatedCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_ActivatedCellList, ActivatedCellList_sequence_of,
                                                  1, maxnoofCellsinNGRANNode, false);

  return offset;
}


static const per_sequence_t IntersystemCellActivationReply_sequence[] = {
  { &hf_ngap_activatedCellList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ActivatedCellList },
  { &hf_ngap_activation_ID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_16384_ },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_IntersystemCellActivationReply(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_IntersystemCellActivationReply, IntersystemCellActivationReply_sequence);

  return offset;
}


static const per_sequence_t IntersystemResourceStatusReply_sequence[] = {
  { &hf_ngap_reportingsystem, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ReportingSystem },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_IntersystemResourceStatusReply(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_IntersystemResourceStatusReply, IntersystemResourceStatusReply_sequence);

  return offset;
}


static const value_string ngap_IntersystemSONInformationReply_vals[] = {
  {   0, "nGRAN-CellActivation" },
  {   1, "resourceStatus" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t IntersystemSONInformationReply_choice[] = {
  {   0, &hf_ngap_nGRAN_CellActivation_01, ASN1_NO_EXTENSIONS     , dissect_ngap_IntersystemCellActivationReply },
  {   1, &hf_ngap_resourceStatus_01, ASN1_NO_EXTENSIONS     , dissect_ngap_IntersystemResourceStatusReply },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_IntersystemSONInformationReply(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_IntersystemSONInformationReply, IntersystemSONInformationReply_choice,
                                 NULL);

  return offset;
}


static const value_string ngap_T_notifyFlag_vals[] = {
  {   0, "activated" },
  {   1, "deactivated" },
  { 0, NULL }
};


static int
dissect_ngap_T_notifyFlag(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NotificationCell_Item_sequence[] = {
  { &hf_ngap_nGRAN_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
  { &hf_ngap_notifyFlag     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_notifyFlag },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NotificationCell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NotificationCell_Item, NotificationCell_Item_sequence);

  return offset;
}


static const per_sequence_t NotificationCellList_sequence_of[1] = {
  { &hf_ngap_NotificationCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NotificationCell_Item },
};

static int
dissect_ngap_NotificationCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_NotificationCellList, NotificationCellList_sequence_of,
                                                  1, maxnoofCellsinNGRANNode, false);

  return offset;
}


static const per_sequence_t IntersystemCellStateIndication_sequence[] = {
  { &hf_ngap_notificationCellList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NotificationCellList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_IntersystemCellStateIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_IntersystemCellStateIndication, IntersystemCellStateIndication_sequence);

  return offset;
}



static int
dissect_ngap_INTEGER_1_100_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, true);

  return offset;
}



static int
dissect_ngap_INTEGER_0_100(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}


static const per_sequence_t CompositeAvailableCapacity_sequence[] = {
  { &hf_ngap_cellCapacityClassValue, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_INTEGER_1_100_ },
  { &hf_ngap_capacityValue  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_CompositeAvailableCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_CompositeAvailableCapacity, CompositeAvailableCapacity_sequence);

  return offset;
}


static const per_sequence_t EUTRAN_CompositeAvailableCapacityGroup_sequence[] = {
  { &hf_ngap_dL_CompositeAvailableCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CompositeAvailableCapacity },
  { &hf_ngap_uL_CompositeAvailableCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CompositeAvailableCapacity },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EUTRAN_CompositeAvailableCapacityGroup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EUTRAN_CompositeAvailableCapacityGroup, EUTRAN_CompositeAvailableCapacityGroup_sequence);

  return offset;
}



static int
dissect_ngap_EUTRAN_NumberOfActiveUEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16777215U, NULL, true);

  return offset;
}



static int
dissect_ngap_NGRAN_NoofRRCConnections(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 65536U, NULL, true);

  return offset;
}


static const per_sequence_t EUTRAN_RadioResourceStatus_sequence[] = {
  { &hf_ngap_dL_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_uL_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_dL_non_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_uL_non_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_dL_Total_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_uL_Total_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_dL_scheduling_PDCCH_CCE_usage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_uL_scheduling_PDCCH_CCE_usage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EUTRAN_RadioResourceStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EUTRAN_RadioResourceStatus, EUTRAN_RadioResourceStatus_sequence);

  return offset;
}


static const per_sequence_t EUTRAN_CellReportItem_sequence[] = {
  { &hf_ngap_eCGI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
  { &hf_ngap_eUTRAN_CompositeAvailableCapacityGroup, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRAN_CompositeAvailableCapacityGroup },
  { &hf_ngap_eUTRAN_NumberOfActiveUEs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_EUTRAN_NumberOfActiveUEs },
  { &hf_ngap_eUTRAN_NoofRRCConnections, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NGRAN_NoofRRCConnections },
  { &hf_ngap_eUTRAN_RadioResourceStatus, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_EUTRAN_RadioResourceStatus },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EUTRAN_CellReportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EUTRAN_CellReportItem, EUTRAN_CellReportItem_sequence);

  return offset;
}


static const per_sequence_t EUTRAN_CellReportList_sequence_of[1] = {
  { &hf_ngap_EUTRAN_CellReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRAN_CellReportItem },
};

static int
dissect_ngap_EUTRAN_CellReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_EUTRAN_CellReportList, EUTRAN_CellReportList_sequence_of,
                                                  1, maxnoofReportedCells, false);

  return offset;
}


static const per_sequence_t EUTRAN_ReportingStatusIEs_sequence[] = {
  { &hf_ngap_eUTRAN_CellReportList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRAN_CellReportList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_EUTRAN_ReportingStatusIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_EUTRAN_ReportingStatusIEs, EUTRAN_ReportingStatusIEs_sequence);

  return offset;
}



static int
dissect_ngap_NGRAN_NumberOfActiveUEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16777215U, NULL, true);

  return offset;
}


static const per_sequence_t NGRAN_RadioResourceStatus_sequence[] = {
  { &hf_ngap_dL_GBR_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_uL_GBR_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_dL_non_GBR_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_uL_non_GBR_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_dL_Total_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_uL_Total_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_100 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NGRAN_RadioResourceStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NGRAN_RadioResourceStatus, NGRAN_RadioResourceStatus_sequence);

  return offset;
}


static const per_sequence_t NGRAN_CellReportItem_sequence[] = {
  { &hf_ngap_nGRAN_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
  { &hf_ngap_nGRAN_CompositeAvailableCapacityGroup, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRAN_CompositeAvailableCapacityGroup },
  { &hf_ngap_nGRAN_NumberOfActiveUEs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NGRAN_NumberOfActiveUEs },
  { &hf_ngap_nGRAN_NoofRRCConnections, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NGRAN_NoofRRCConnections },
  { &hf_ngap_nGRAN_RadioResourceStatus, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NGRAN_RadioResourceStatus },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NGRAN_CellReportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NGRAN_CellReportItem, NGRAN_CellReportItem_sequence);

  return offset;
}


static const per_sequence_t NGRAN_CellReportList_sequence_of[1] = {
  { &hf_ngap_NGRAN_CellReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CellReportItem },
};

static int
dissect_ngap_NGRAN_CellReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_NGRAN_CellReportList, NGRAN_CellReportList_sequence_of,
                                                  1, maxnoofReportedCells, false);

  return offset;
}


static const per_sequence_t NGRAN_ReportingStatusIEs_sequence[] = {
  { &hf_ngap_nGRAN_CellReportList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CellReportList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NGRAN_ReportingStatusIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NGRAN_ReportingStatusIEs, NGRAN_ReportingStatusIEs_sequence);

  return offset;
}


static const value_string ngap_ResourceStatusReportingSystem_vals[] = {
  {   0, "eUTRAN-ReportingStatus" },
  {   1, "nGRAN-ReportingStatus" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t ResourceStatusReportingSystem_choice[] = {
  {   0, &hf_ngap_eUTRAN_ReportingStatus, ASN1_NO_EXTENSIONS     , dissect_ngap_EUTRAN_ReportingStatusIEs },
  {   1, &hf_ngap_nGRAN_ReportingStatus, ASN1_NO_EXTENSIONS     , dissect_ngap_NGRAN_ReportingStatusIEs },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_ResourceStatusReportingSystem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_ResourceStatusReportingSystem, ResourceStatusReportingSystem_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t IntersystemResourceStatusReport_sequence[] = {
  { &hf_ngap_reportingSystem_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ResourceStatusReportingSystem },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_IntersystemResourceStatusReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_IntersystemResourceStatusReport, IntersystemResourceStatusReport_sequence);

  return offset;
}


static const per_sequence_t IntersystemMobilityFailureforVoiceFallback_sequence[] = {
  { &hf_ngap_sourcecellID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
  { &hf_ngap_targetcellID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
  { &hf_ngap_reconnectCellID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_EUTRA_CGI },
  { &hf_ngap_uERLFReportContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UERLFReportContainer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_IntersystemMobilityFailureforVoiceFallback(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_IntersystemMobilityFailureforVoiceFallback, IntersystemMobilityFailureforVoiceFallback_sequence);

  return offset;
}



static int
dissect_ngap_LAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       2, 2, false, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t LAI_sequence[] = {
  { &hf_ngap_pLMNidentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_lAC            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_LAC },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_LAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  ngap_data->number_type = E212_LAI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_LAI, LAI_sequence);



  return offset;
}



static int
dissect_ngap_TimeUEStayedInCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, false);

  return offset;
}



static int
dissect_ngap_TimeUEStayedInCellEnhancedGranularity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 40950U, NULL, false);

  return offset;
}


static const per_sequence_t LastVisitedNGRANCellInformation_sequence[] = {
  { &hf_ngap_globalCellID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
  { &hf_ngap_cellType       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CellType },
  { &hf_ngap_timeUEStayedInCell, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TimeUEStayedInCell },
  { &hf_ngap_timeUEStayedInCellEnhancedGranularity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_TimeUEStayedInCellEnhancedGranularity },
  { &hf_ngap_hOCauseValue   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_Cause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_LastVisitedNGRANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_LastVisitedNGRANCellInformation, LastVisitedNGRANCellInformation_sequence);

  return offset;
}



static int
dissect_ngap_LastVisitedEUTRANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_ngap_LastVisitedEUTRANCellInformation);
    dissect_s1ap_LastVisitedEUTRANCellInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_ngap_LastVisitedUTRANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_ngap_LastVisitedUTRANCellInformation);
    dissect_ranap_LastVisitedUTRANCell_Item_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_ngap_LastVisitedGERANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_ngap_LastVisitedGERANCellInformation);
    dissect_s1ap_LastVisitedGERANCellInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string ngap_LastVisitedCellInformation_vals[] = {
  {   0, "nGRANCell" },
  {   1, "eUTRANCell" },
  {   2, "uTRANCell" },
  {   3, "gERANCell" },
  {   4, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t LastVisitedCellInformation_choice[] = {
  {   0, &hf_ngap_nGRANCell      , ASN1_NO_EXTENSIONS     , dissect_ngap_LastVisitedNGRANCellInformation },
  {   1, &hf_ngap_eUTRANCell     , ASN1_NO_EXTENSIONS     , dissect_ngap_LastVisitedEUTRANCellInformation },
  {   2, &hf_ngap_uTRANCell      , ASN1_NO_EXTENSIONS     , dissect_ngap_LastVisitedUTRANCellInformation },
  {   3, &hf_ngap_gERANCell      , ASN1_NO_EXTENSIONS     , dissect_ngap_LastVisitedGERANCellInformation },
  {   4, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_LastVisitedCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_LastVisitedCellInformation, LastVisitedCellInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t LastVisitedCellItem_sequence[] = {
  { &hf_ngap_lastVisitedCellInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_LastVisitedCellInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_LastVisitedCellItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_LastVisitedCellItem, LastVisitedCellItem_sequence);

  return offset;
}



static int
dissect_ngap_INTEGER_0_40950(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 40950U, NULL, false);

  return offset;
}


static const per_sequence_t LastVisitedPSCellInformation_sequence[] = {
  { &hf_ngap_pSCellID       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NGRAN_CGI },
  { &hf_ngap_timeStay       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_40950 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_LastVisitedPSCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_LastVisitedPSCellInformation, LastVisitedPSCellInformation_sequence);

  return offset;
}


static const per_sequence_t LastVisitedPSCellList_sequence_of[1] = {
  { &hf_ngap_LastVisitedPSCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_LastVisitedPSCellInformation },
};

static int
dissect_ngap_LastVisitedPSCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_LastVisitedPSCellList, LastVisitedPSCellList_sequence_of,
                                                  1, maxnoofPSCellsPerPrimaryCellinUEHistoryInfo, false);

  return offset;
}


static const value_string ngap_LocationReportingAdditionalInfo_vals[] = {
  {   0, "includePSCell" },
  { 0, NULL }
};


static int
dissect_ngap_LocationReportingAdditionalInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_ReportArea_vals[] = {
  {   0, "cell" },
  { 0, NULL }
};


static int
dissect_ngap_ReportArea(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t LocationReportingRequestType_sequence[] = {
  { &hf_ngap_eventType      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EventType },
  { &hf_ngap_reportArea     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ReportArea },
  { &hf_ngap_areaOfInterestList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AreaOfInterestList },
  { &hf_ngap_locationReportingReferenceIDToBeCancelled, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_LocationReportingReferenceID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_LocationReportingRequestType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_LocationReportingRequestType, LocationReportingRequestType_sequence);

  return offset;
}


static const value_string ngap_LoggingInterval_vals[] = {
  {   0, "ms320" },
  {   1, "ms640" },
  {   2, "ms1280" },
  {   3, "ms2560" },
  {   4, "ms5120" },
  {   5, "ms10240" },
  {   6, "ms20480" },
  {   7, "ms30720" },
  {   8, "ms40960" },
  {   9, "ms61440" },
  {  10, "infinity" },
  { 0, NULL }
};


static int
dissect_ngap_LoggingInterval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_LoggingDuration_vals[] = {
  {   0, "m10" },
  {   1, "m20" },
  {   2, "m40" },
  {   3, "m60" },
  {   4, "m90" },
  {   5, "m120" },
  { 0, NULL }
};


static int
dissect_ngap_LoggingDuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_LoggedMDTTrigger_vals[] = {
  {   0, "periodical" },
  {   1, "eventTrigger" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t LoggedMDTTrigger_choice[] = {
  {   0, &hf_ngap_periodical     , ASN1_NO_EXTENSIONS     , dissect_ngap_NULL },
  {   1, &hf_ngap_eventTrigger   , ASN1_NO_EXTENSIONS     , dissect_ngap_EventTrigger },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_LoggedMDTTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_LoggedMDTTrigger, LoggedMDTTrigger_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t LoggedMDTNr_sequence[] = {
  { &hf_ngap_loggingInterval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_LoggingInterval },
  { &hf_ngap_loggingDuration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_LoggingDuration },
  { &hf_ngap_loggedMDTTrigger, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_LoggedMDTTrigger },
  { &hf_ngap_bluetoothMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BluetoothMeasurementConfiguration },
  { &hf_ngap_wLANMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_WLANMeasurementConfiguration },
  { &hf_ngap_sensorMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_SensorMeasurementConfiguration },
  { &hf_ngap_areaScopeOfNeighCellsList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AreaScopeOfNeighCellsList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_LoggedMDTNr(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_LoggedMDTNr, LoggedMDTNr_sequence);

  return offset;
}


static const value_string ngap_LTEM_Indication_vals[] = {
  {   0, "lte-m" },
  { 0, NULL }
};


static int
dissect_ngap_LTEM_Indication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_VehicleUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_VehicleUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_PedestrianUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_PedestrianUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t LTEV2XServicesAuthorized_sequence[] = {
  { &hf_ngap_vehicleUE      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_VehicleUE },
  { &hf_ngap_pedestrianUE   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PedestrianUE },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_LTEV2XServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_LTEV2XServicesAuthorized, LTEV2XServicesAuthorized_sequence);

  return offset;
}


static const per_sequence_t LTEUESidelinkAggregateMaximumBitrate_sequence[] = {
  { &hf_ngap_uESidelinkAggregateMaximumBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_LTEUESidelinkAggregateMaximumBitrate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_LTEUESidelinkAggregateMaximumBitrate, LTEUESidelinkAggregateMaximumBitrate_sequence);

  return offset;
}


static const value_string ngap_T_aerialUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_T_aerialUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_aerialControllerUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_T_aerialControllerUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t LTE_A2X_ServicesAuthorized_sequence[] = {
  { &hf_ngap_aerialUE       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_aerialUE },
  { &hf_ngap_aerialControllerUE, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_aerialControllerUE },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_LTE_A2X_ServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_LTE_A2X_ServicesAuthorized, LTE_A2X_ServicesAuthorized_sequence);

  return offset;
}



static int
dissect_ngap_MaskedIMEISV(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_ngap_MessageIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     16, 16, false, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const value_string ngap_MaximumIntegrityProtectedDataRate_vals[] = {
  {   0, "bitrate64kbs" },
  {   1, "maximum-UE-rate" },
  { 0, NULL }
};


static int
dissect_ngap_MaximumIntegrityProtectedDataRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_MBSCommServiceType_vals[] = {
  {   0, "broadcast" },
  {   1, "multicast" },
  { 0, NULL }
};


static int
dissect_ngap_MBSCommServiceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_MRB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 512U, NULL, true);

  return offset;
}


static const value_string ngap_MRB_ProgressInformation_vals[] = {
  {   0, "pDCP-SN-Length12" },
  {   1, "pDCP-SN-Length18" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t MRB_ProgressInformation_choice[] = {
  {   0, &hf_ngap_pDCP_SN_Length12, ASN1_NO_EXTENSIONS     , dissect_ngap_INTEGER_0_4095 },
  {   1, &hf_ngap_pDCP_SN_Length18, ASN1_NO_EXTENSIONS     , dissect_ngap_INTEGER_0_262143 },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_MRB_ProgressInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_MRB_ProgressInformation, MRB_ProgressInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MBS_DataForwardingResponseMRBItem_sequence[] = {
  { &hf_ngap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MRB_ID },
  { &hf_ngap_dL_Forwarding_UPTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_mRB_ProgressInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MRB_ProgressInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_DataForwardingResponseMRBItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_DataForwardingResponseMRBItem, MBS_DataForwardingResponseMRBItem_sequence);

  return offset;
}


static const per_sequence_t MBS_DataForwardingResponseMRBList_sequence_of[1] = {
  { &hf_ngap_MBS_DataForwardingResponseMRBList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_DataForwardingResponseMRBItem },
};

static int
dissect_ngap_MBS_DataForwardingResponseMRBList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBS_DataForwardingResponseMRBList, MBS_DataForwardingResponseMRBList_sequence_of,
                                                  1, maxnoofMRBs, false);

  return offset;
}


static const per_sequence_t MBS_QoSFlowList_sequence_of[1] = {
  { &hf_ngap_MBS_QoSFlowList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
};

static int
dissect_ngap_MBS_QoSFlowList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBS_QoSFlowList, MBS_QoSFlowList_sequence_of,
                                                  1, maxnoofMBSQoSFlows, false);

  return offset;
}


static const per_sequence_t MBS_MappingandDataForwardingRequestItem_sequence[] = {
  { &hf_ngap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MRB_ID },
  { &hf_ngap_mBS_QoSFlowList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_QoSFlowList },
  { &hf_ngap_mRB_ProgressInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MRB_ProgressInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_MappingandDataForwardingRequestItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_MappingandDataForwardingRequestItem, MBS_MappingandDataForwardingRequestItem_sequence);

  return offset;
}


static const per_sequence_t MBS_MappingandDataForwardingRequestList_sequence_of[1] = {
  { &hf_ngap_MBS_MappingandDataForwardingRequestList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_MappingandDataForwardingRequestItem },
};

static int
dissect_ngap_MBS_MappingandDataForwardingRequestList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBS_MappingandDataForwardingRequestList, MBS_MappingandDataForwardingRequestList_sequence_of,
                                                  1, maxnoofMRBs, false);

  return offset;
}


static const per_sequence_t NonDynamic5QIDescriptor_sequence[] = {
  { &hf_ngap_fiveQI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_FiveQI },
  { &hf_ngap_priorityLevelQos, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PriorityLevelQos },
  { &hf_ngap_averagingWindow, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AveragingWindow },
  { &hf_ngap_maximumDataBurstVolume, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MaximumDataBurstVolume },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NonDynamic5QIDescriptor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NonDynamic5QIDescriptor, NonDynamic5QIDescriptor_sequence);

  return offset;
}


static const value_string ngap_QosCharacteristics_vals[] = {
  {   0, "nonDynamic5QI" },
  {   1, "dynamic5QI" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t QosCharacteristics_choice[] = {
  {   0, &hf_ngap_nonDynamic5QI  , ASN1_NO_EXTENSIONS     , dissect_ngap_NonDynamic5QIDescriptor },
  {   1, &hf_ngap_dynamic5QI     , ASN1_NO_EXTENSIONS     , dissect_ngap_Dynamic5QIDescriptor },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_QosCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_QosCharacteristics, QosCharacteristics_choice,
                                 NULL);

  return offset;
}


static const value_string ngap_ReflectiveQosAttribute_vals[] = {
  {   0, "subject-to" },
  { 0, NULL }
};


static int
dissect_ngap_ReflectiveQosAttribute(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t QosFlowLevelQosParameters_sequence[] = {
  { &hf_ngap_qosCharacteristics, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosCharacteristics },
  { &hf_ngap_allocationAndRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_AllocationAndRetentionPriority },
  { &hf_ngap_gBR_QosInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_GBR_QosInformation },
  { &hf_ngap_reflectiveQosAttribute, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ReflectiveQosAttribute },
  { &hf_ngap_additionalQosFlowInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AdditionalQosFlowInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowLevelQosParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowLevelQosParameters, QosFlowLevelQosParameters_sequence);

  return offset;
}


static const per_sequence_t MBS_QoSFlowsToBeSetupItem_sequence[] = {
  { &hf_ngap_mBSqosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_mBSqosFlowLevelQosParameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowLevelQosParameters },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_QoSFlowsToBeSetupItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_QoSFlowsToBeSetupItem, MBS_QoSFlowsToBeSetupItem_sequence);

  return offset;
}


static const per_sequence_t MBS_QoSFlowsToBeSetupList_sequence_of[1] = {
  { &hf_ngap_MBS_QoSFlowsToBeSetupList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_QoSFlowsToBeSetupItem },
};

static int
dissect_ngap_MBS_QoSFlowsToBeSetupList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBS_QoSFlowsToBeSetupList, MBS_QoSFlowsToBeSetupList_sequence_of,
                                                  1, maxnoofMBSQoSFlows, false);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaCellList_sequence_of[1] = {
  { &hf_ngap_MBS_ServiceAreaCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NR_CGI },
};

static int
dissect_ngap_MBS_ServiceAreaCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBS_ServiceAreaCellList, MBS_ServiceAreaCellList_sequence_of,
                                                  1, maxnoofCellsforMBS, false);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaTAIList_sequence_of[1] = {
  { &hf_ngap_MBS_ServiceAreaTAIList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
};

static int
dissect_ngap_MBS_ServiceAreaTAIList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBS_ServiceAreaTAIList, MBS_ServiceAreaTAIList_sequence_of,
                                                  1, maxnoofTAIforMBS, false);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaInformation_sequence[] = {
  { &hf_ngap_mBS_ServiceAreaCellList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_ServiceAreaCellList },
  { &hf_ngap_mBS_ServiceAreaTAIList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_ServiceAreaTAIList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_ServiceAreaInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_ServiceAreaInformation, MBS_ServiceAreaInformation_sequence);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaInformationItem_sequence[] = {
  { &hf_ngap_mBS_AreaSessionID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_AreaSessionID },
  { &hf_ngap_mBS_ServiceAreaInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_ServiceAreaInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_ServiceAreaInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_ServiceAreaInformationItem, MBS_ServiceAreaInformationItem_sequence);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaInformationList_sequence_of[1] = {
  { &hf_ngap_MBS_ServiceAreaInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_ServiceAreaInformationItem },
};

static int
dissect_ngap_MBS_ServiceAreaInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBS_ServiceAreaInformationList, MBS_ServiceAreaInformationList_sequence_of,
                                                  1, maxnoofMBSServiceAreaInformation, false);

  return offset;
}


static const value_string ngap_MBS_ServiceArea_vals[] = {
  {   0, "locationindependent" },
  {   1, "locationdependent" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t MBS_ServiceArea_choice[] = {
  {   0, &hf_ngap_locationindependent, ASN1_NO_EXTENSIONS     , dissect_ngap_MBS_ServiceAreaInformation },
  {   1, &hf_ngap_locationdependent, ASN1_NO_EXTENSIONS     , dissect_ngap_MBS_ServiceAreaInformationList },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_MBS_ServiceArea(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_MBS_ServiceArea, MBS_ServiceArea_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MBSSessionFailedtoSetupItem_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_mBS_AreaSessionID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_AreaSessionID },
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBSSessionFailedtoSetupItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBSSessionFailedtoSetupItem, MBSSessionFailedtoSetupItem_sequence);

  return offset;
}


static const per_sequence_t MBSSessionFailedtoSetupList_sequence_of[1] = {
  { &hf_ngap_MBSSessionFailedtoSetupList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBSSessionFailedtoSetupItem },
};

static int
dissect_ngap_MBSSessionFailedtoSetupList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBSSessionFailedtoSetupList, MBSSessionFailedtoSetupList_sequence_of,
                                                  1, maxnoofMBSSessions, false);

  return offset;
}


static const per_sequence_t MBS_ActiveSessionInformation_SourcetoTargetItem_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_mBS_AreaSessionID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_AreaSessionID },
  { &hf_ngap_mBS_ServiceArea, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_ServiceArea },
  { &hf_ngap_mBS_QoSFlowsToBeSetupList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_QoSFlowsToBeSetupList },
  { &hf_ngap_mBS_MappingandDataForwardingRequestList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_MappingandDataForwardingRequestList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_ActiveSessionInformation_SourcetoTargetItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_ActiveSessionInformation_SourcetoTargetItem, MBS_ActiveSessionInformation_SourcetoTargetItem_sequence);

  return offset;
}


static const per_sequence_t MBS_ActiveSessionInformation_SourcetoTargetList_sequence_of[1] = {
  { &hf_ngap_MBS_ActiveSessionInformation_SourcetoTargetList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_ActiveSessionInformation_SourcetoTargetItem },
};

static int
dissect_ngap_MBS_ActiveSessionInformation_SourcetoTargetList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBS_ActiveSessionInformation_SourcetoTargetList, MBS_ActiveSessionInformation_SourcetoTargetList_sequence_of,
                                                  1, maxnoofMBSSessionsofUE, false);

  return offset;
}


static const per_sequence_t MBS_ActiveSessionInformation_TargettoSourceItem_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_mBS_DataForwardingResponseMRBList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_DataForwardingResponseMRBList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_ActiveSessionInformation_TargettoSourceItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_ActiveSessionInformation_TargettoSourceItem, MBS_ActiveSessionInformation_TargettoSourceItem_sequence);

  return offset;
}


static const per_sequence_t MBS_ActiveSessionInformation_TargettoSourceList_sequence_of[1] = {
  { &hf_ngap_MBS_ActiveSessionInformation_TargettoSourceList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_ActiveSessionInformation_TargettoSourceItem },
};

static int
dissect_ngap_MBS_ActiveSessionInformation_TargettoSourceList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBS_ActiveSessionInformation_TargettoSourceList, MBS_ActiveSessionInformation_TargettoSourceList_sequence_of,
                                                  1, maxnoofMBSSessionsofUE, false);

  return offset;
}


static const value_string ngap_MBS_AssistanceInformation_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_MBS_AssistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MBSSessionSetupOrModFailureTransfer_sequence[] = {
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_criticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_CriticalityDiagnostics },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBSSessionSetupOrModFailureTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "MBSSessionSetupOrModFailureTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBSSessionSetupOrModFailureTransfer, MBSSessionSetupOrModFailureTransfer_sequence);

  return offset;
}


static const per_sequence_t MBSSessionSetupResponseItem_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_mBS_AreaSessionID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_AreaSessionID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBSSessionSetupResponseItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBSSessionSetupResponseItem, MBSSessionSetupResponseItem_sequence);

  return offset;
}


static const per_sequence_t MBSSessionSetupResponseList_sequence_of[1] = {
  { &hf_ngap_MBSSessionSetupResponseList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBSSessionSetupResponseItem },
};

static int
dissect_ngap_MBSSessionSetupResponseList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBSSessionSetupResponseList, MBSSessionSetupResponseList_sequence_of,
                                                  1, maxnoofMBSSessions, false);

  return offset;
}


static const per_sequence_t MBSSessionSetupOrModRequestTransfer_sequence[] = {
  { &hf_ngap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBSSessionSetupOrModRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "MBSSessionSetupOrModRequestTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBSSessionSetupOrModRequestTransfer, MBSSessionSetupOrModRequestTransfer_sequence);

  return offset;
}


static const value_string ngap_SupportedUEType_vals[] = {
  {   0, "non-RedCap-UE" },
  {   1, "redCap-UE" },
  { 0, NULL }
};


static int
dissect_ngap_SupportedUEType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t SupportedUETypeList_sequence_of[1] = {
  { &hf_ngap_SupportedUETypeList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_SupportedUEType },
};

static int
dissect_ngap_SupportedUETypeList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_SupportedUETypeList, SupportedUETypeList_sequence_of,
                                                  1, maxnoofUETypes, false);

  return offset;
}



static int
dissect_ngap_MBS_SessionFSAID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, false, NULL);

  return offset;
}


static const per_sequence_t MBS_SessionFSAIDList_sequence_of[1] = {
  { &hf_ngap_MBS_SessionFSAIDList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionFSAID },
};

static int
dissect_ngap_MBS_SessionFSAIDList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBS_SessionFSAIDList, MBS_SessionFSAIDList_sequence_of,
                                                  1, maxnoofMBSFSAs, false);

  return offset;
}


static const per_sequence_t MBSSessionReleaseResponseTransfer_sequence[] = {
  { &hf_ngap_mBS_SessionTNLInfoNGRAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_SessionTNLInfoNGRAN },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBSSessionReleaseResponseTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "MBSSessionReleaseResponseTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBSSessionReleaseResponseTransfer, MBSSessionReleaseResponseTransfer_sequence);

  return offset;
}


static const per_sequence_t MBSSessionSetupOrModResponseTransfer_sequence[] = {
  { &hf_ngap_mBS_SessionTNLInfoNGRAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_SessionTNLInfoNGRAN },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBSSessionSetupOrModResponseTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "MBSSessionSetupOrModResponseTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBSSessionSetupOrModResponseTransfer, MBSSessionSetupOrModResponseTransfer_sequence);

  return offset;
}


static const value_string ngap_MBS_SupportIndicator_vals[] = {
  {   0, "multicast-supported" },
  {   1, "multicast-supported-with-reception-in-RRC-inactive" },
  { 0, NULL }
};


static int
dissect_ngap_MBS_SupportIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 1, NULL);

  return offset;
}


static const per_sequence_t SharedNGU_MulticastTNLInformation_sequence[] = {
  { &hf_ngap_iP_MulticastAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TransportLayerAddress },
  { &hf_ngap_iP_SourceAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TransportLayerAddress },
  { &hf_ngap_gTP_TEID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_GTP_TEID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SharedNGU_MulticastTNLInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SharedNGU_MulticastTNLInformation, SharedNGU_MulticastTNLInformation_sequence);

  return offset;
}


static const per_sequence_t MBS_SessionTNLInfo5GCItem_sequence[] = {
  { &hf_ngap_mBS_AreaSessionID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_AreaSessionID },
  { &hf_ngap_sharedNGU_MulticastTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SharedNGU_MulticastTNLInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_SessionTNLInfo5GCItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_SessionTNLInfo5GCItem, MBS_SessionTNLInfo5GCItem_sequence);

  return offset;
}


static const per_sequence_t MBS_SessionTNLInfo5GCList_sequence_of[1] = {
  { &hf_ngap_MBS_SessionTNLInfo5GCList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionTNLInfo5GCItem },
};

static int
dissect_ngap_MBS_SessionTNLInfo5GCList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBS_SessionTNLInfo5GCList, MBS_SessionTNLInfo5GCList_sequence_of,
                                                  1, maxnoofMBSServiceAreaInformation, false);

  return offset;
}


static const value_string ngap_MBS_SessionTNLInfo5GC_vals[] = {
  {   0, "locationindependent" },
  {   1, "locationdependent" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t MBS_SessionTNLInfo5GC_choice[] = {
  {   0, &hf_ngap_locationindependent_01, ASN1_NO_EXTENSIONS     , dissect_ngap_SharedNGU_MulticastTNLInformation },
  {   1, &hf_ngap_locationdependent_01, ASN1_NO_EXTENSIONS     , dissect_ngap_MBS_SessionTNLInfo5GCList },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_MBS_SessionTNLInfo5GC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_MBS_SessionTNLInfo5GC, MBS_SessionTNLInfo5GC_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MBS_DistributionReleaseRequestTransfer_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_mBS_AreaSessionID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_AreaSessionID },
  { &hf_ngap_sharedNGU_UnicastTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_DistributionReleaseRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_DistributionReleaseRequestTransfer, MBS_DistributionReleaseRequestTransfer_sequence);

  return offset;
}


static const per_sequence_t MBS_DistributionSetupRequestTransfer_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_mBS_AreaSessionID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_AreaSessionID },
  { &hf_ngap_sharedNGU_UnicastTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_DistributionSetupRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_DistributionSetupRequestTransfer, MBS_DistributionSetupRequestTransfer_sequence);

  return offset;
}


static const value_string ngap_MBSSessionStatus_vals[] = {
  {   0, "activated" },
  {   1, "deactivated" },
  { 0, NULL }
};


static int
dissect_ngap_MBSSessionStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MBS_DistributionSetupResponseTransfer_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_mBS_AreaSessionID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_AreaSessionID },
  { &hf_ngap_sharedNGU_MulticastTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_SharedNGU_MulticastTNLInformation },
  { &hf_ngap_mBS_QoSFlowsToBeSetupList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_QoSFlowsToBeSetupList },
  { &hf_ngap_mBSSessionStatus, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBSSessionStatus },
  { &hf_ngap_mBS_ServiceArea, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_ServiceArea },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_DistributionSetupResponseTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_DistributionSetupResponseTransfer, MBS_DistributionSetupResponseTransfer_sequence);

  return offset;
}


static const per_sequence_t MBS_DistributionSetupUnsuccessfulTransfer_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_mBS_AreaSessionID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_AreaSessionID },
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_criticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_CriticalityDiagnostics },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_DistributionSetupUnsuccessfulTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_DistributionSetupUnsuccessfulTransfer, MBS_DistributionSetupUnsuccessfulTransfer_sequence);

  return offset;
}


static const value_string ngap_MBS_UP_FailureIndication_vals[] = {
  {   0, "ng-u-path-failure-detected" },
  { 0, NULL }
};


static int
dissect_ngap_MBS_UP_FailureIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MBS_UP_FailureIndicationItem_sequence[] = {
  { &hf_ngap_mBS_AreaSessionID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_AreaSessionID },
  { &hf_ngap_mBS_UP_FailureIndication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_UP_FailureIndication },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBS_UP_FailureIndicationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBS_UP_FailureIndicationItem, MBS_UP_FailureIndicationItem_sequence);

  return offset;
}


static const per_sequence_t MBS_UP_FailureIndicationList_sequence_of[1] = {
  { &hf_ngap_MBS_UP_FailureIndicationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_UP_FailureIndicationItem },
};

static int
dissect_ngap_MBS_UP_FailureIndicationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBS_UP_FailureIndicationList, MBS_UP_FailureIndicationList_sequence_of,
                                                  1, maxnoofMBSServiceAreaInformation, false);

  return offset;
}


static const value_string ngap_MBS_NGUFailureIndication_vals[] = {
  {   0, "locationindependent" },
  {   1, "locationdependent" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t MBS_NGUFailureIndication_choice[] = {
  {   0, &hf_ngap_locationindependent_03, ASN1_NO_EXTENSIONS     , dissect_ngap_MBS_UP_FailureIndication },
  {   1, &hf_ngap_locationdependent_03, ASN1_NO_EXTENSIONS     , dissect_ngap_MBS_UP_FailureIndicationList },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_MBS_NGUFailureIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_MBS_NGUFailureIndication, MBS_NGUFailureIndication_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MBSSessionSetupRequestItem_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_mBS_AreaSessionID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_AreaSessionID },
  { &hf_ngap_associatedMBSQosFlowSetupRequestList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AssociatedMBSQosFlowSetupRequestList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBSSessionSetupRequestItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBSSessionSetupRequestItem, MBSSessionSetupRequestItem_sequence);

  return offset;
}


static const per_sequence_t MBSSessionSetupRequestList_sequence_of[1] = {
  { &hf_ngap_MBSSessionSetupRequestList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBSSessionSetupRequestItem },
};

static int
dissect_ngap_MBSSessionSetupRequestList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBSSessionSetupRequestList, MBSSessionSetupRequestList_sequence_of,
                                                  1, maxnoofMBSSessions, false);

  return offset;
}


static const per_sequence_t MBSSessionSetuporModifyRequestItem_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_mBS_AreaSessionID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MBS_AreaSessionID },
  { &hf_ngap_associatedMBSQosFlowSetuporModifyRequestList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AssociatedMBSQosFlowSetuporModifyRequestList },
  { &hf_ngap_mBS_QosFlowToReleaseList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QosFlowListWithCause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBSSessionSetuporModifyRequestItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBSSessionSetuporModifyRequestItem, MBSSessionSetuporModifyRequestItem_sequence);

  return offset;
}


static const per_sequence_t MBSSessionSetuporModifyRequestList_sequence_of[1] = {
  { &hf_ngap_MBSSessionSetuporModifyRequestList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBSSessionSetuporModifyRequestItem },
};

static int
dissect_ngap_MBSSessionSetuporModifyRequestList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBSSessionSetuporModifyRequestList, MBSSessionSetuporModifyRequestList_sequence_of,
                                                  1, maxnoofMBSSessions, false);

  return offset;
}


static const per_sequence_t MBSSessionToReleaseItem_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MBSSessionToReleaseItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MBSSessionToReleaseItem, MBSSessionToReleaseItem_sequence);

  return offset;
}


static const per_sequence_t MBSSessionToReleaseList_sequence_of[1] = {
  { &hf_ngap_MBSSessionToReleaseList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MBSSessionToReleaseItem },
};

static int
dissect_ngap_MBSSessionToReleaseList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBSSessionToReleaseList, MBSSessionToReleaseList_sequence_of,
                                                  1, maxnoofMBSSessions, false);

  return offset;
}


static const value_string ngap_MicoAllPLMN_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_MicoAllPLMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_ExtendedMobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_ngap_RATRestrictionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, true, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_ngap_RATRestrictionInformation_e_UTRA,
      &hf_ngap_RATRestrictionInformation_nR,
      &hf_ngap_RATRestrictionInformation_nR_unlicensed,
      &hf_ngap_RATRestrictionInformation_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_RATRestrictionInformation);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t RATRestrictions_Item_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_rATRestrictionInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_RATRestrictionInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RATRestrictions_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RATRestrictions_Item, RATRestrictions_Item_sequence);

  return offset;
}


static const per_sequence_t RATRestrictions_sequence_of[1] = {
  { &hf_ngap_RATRestrictions_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_RATRestrictions_Item },
};

static int
dissect_ngap_RATRestrictions(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_RATRestrictions, RATRestrictions_sequence_of,
                                                  1, maxnoofEPLMNsPlusOne, false);

  return offset;
}


static const per_sequence_t NotAllowedTACs_sequence_of[1] = {
  { &hf_ngap_NotAllowedTACs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAC },
};

static int
dissect_ngap_NotAllowedTACs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_NotAllowedTACs, NotAllowedTACs_sequence_of,
                                                  1, maxnoofAllowedAreas, false);

  return offset;
}


static const per_sequence_t ServiceAreaInformation_Item_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_allowedTACs    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AllowedTACs },
  { &hf_ngap_notAllowedTACs , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NotAllowedTACs },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ServiceAreaInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ServiceAreaInformation_Item, ServiceAreaInformation_Item_sequence);

  return offset;
}


static const per_sequence_t ServiceAreaInformation_sequence_of[1] = {
  { &hf_ngap_ServiceAreaInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_ServiceAreaInformation_Item },
};

static int
dissect_ngap_ServiceAreaInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_ServiceAreaInformation, ServiceAreaInformation_sequence_of,
                                                  1, maxnoofEPLMNsPlusOne, false);

  return offset;
}


static const per_sequence_t MobilityRestrictionList_sequence[] = {
  { &hf_ngap_servingPLMN    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_equivalentPLMNs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_EquivalentPLMNs },
  { &hf_ngap_rATRestrictions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_RATRestrictions },
  { &hf_ngap_forbiddenAreaInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ForbiddenAreaInformation },
  { &hf_ngap_serviceAreaInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ServiceAreaInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MobilityRestrictionList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MobilityRestrictionList, MobilityRestrictionList_sequence);

  return offset;
}



static int
dissect_ngap_NGRANTraceID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb;
  proto_tree *subtree = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       8, 8, false, &parameter_tvb);

  if (!parameter_tvb)
    return offset;
  subtree = proto_item_add_subtree(actx->created_item, ett_ngap_NGRANTraceID);
  dissect_e212_mcc_mnc(parameter_tvb, actx->pinfo, subtree, 0, E212_NONE, false);
  proto_tree_add_item(subtree, hf_ngap_NGRANTraceID_TraceID, parameter_tvb, 3, 3, ENC_BIG_ENDIAN);
  proto_tree_add_item(subtree, hf_ngap_NGRANTraceID_TraceRecordingSessionReference, parameter_tvb, 6, 2, ENC_BIG_ENDIAN);


  return offset;
}


static const value_string ngap_MDT_AlignmentInfo_vals[] = {
  {   0, "s-basedMDT" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t MDT_AlignmentInfo_choice[] = {
  {   0, &hf_ngap_s_basedMDT     , ASN1_NO_EXTENSIONS     , dissect_ngap_NGRANTraceID },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_MDT_AlignmentInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_MDT_AlignmentInfo, MDT_AlignmentInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MDTPLMNList_sequence_of[1] = {
  { &hf_ngap_MDTPLMNList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
};

static int
dissect_ngap_MDTPLMNList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MDTPLMNList, MDTPLMNList_sequence_of,
                                                  1, maxnoofMDTPLMNs, false);

  return offset;
}


static const per_sequence_t MDTPLMNModificationList_sequence_of[1] = {
  { &hf_ngap_MDTPLMNModificationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
};

static int
dissect_ngap_MDTPLMNModificationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MDTPLMNModificationList, MDTPLMNModificationList_sequence_of,
                                                  0, maxnoofMDTPLMNs, false);

  return offset;
}


static const value_string ngap_MDT_Activation_vals[] = {
  {   0, "immediate-MDT-only" },
  {   1, "logged-MDT-only" },
  {   2, "immediate-MDT-and-Trace" },
  { 0, NULL }
};


static int
dissect_ngap_MDT_Activation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_MDTModeNr_vals[] = {
  {   0, "immediateMDTNr" },
  {   1, "loggedMDTNr" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t MDTModeNr_choice[] = {
  {   0, &hf_ngap_immediateMDTNr , ASN1_NO_EXTENSIONS     , dissect_ngap_ImmediateMDTNr },
  {   1, &hf_ngap_loggedMDTNr    , ASN1_NO_EXTENSIONS     , dissect_ngap_LoggedMDTNr },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_MDTModeNr(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_MDTModeNr, MDTModeNr_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MDT_Configuration_NR_sequence[] = {
  { &hf_ngap_mdt_Activation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MDT_Activation },
  { &hf_ngap_areaScopeOfMDT , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_AreaScopeOfMDT_NR },
  { &hf_ngap_mDTModeNr      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MDTModeNr },
  { &hf_ngap_signallingBasedMDTPLMNList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MDTPLMNList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MDT_Configuration_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MDT_Configuration_NR, MDT_Configuration_NR_sequence);

  return offset;
}



static int
dissect_ngap_MDTModeEutra(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *mdt_mode_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &mdt_mode_eutra_tvb);

  if (mdt_mode_eutra_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_MDTModeEutra);
    dissect_s1ap_MDTMode_PDU(mdt_mode_eutra_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t MDT_Configuration_EUTRA_sequence[] = {
  { &hf_ngap_mdt_Activation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MDT_Activation },
  { &hf_ngap_areaScopeOfMDT_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_AreaScopeOfMDT_EUTRA },
  { &hf_ngap_mDTMode        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MDTModeEutra },
  { &hf_ngap_signallingBasedMDTPLMNList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MDTPLMNList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MDT_Configuration_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MDT_Configuration_EUTRA, MDT_Configuration_EUTRA_sequence);

  return offset;
}


static const per_sequence_t MDT_Configuration_sequence[] = {
  { &hf_ngap_mdt_Config_NR  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MDT_Configuration_NR },
  { &hf_ngap_mdt_Config_EUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MDT_Configuration_EUTRA },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MDT_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MDT_Configuration, MDT_Configuration_sequence);

  return offset;
}


static const value_string ngap_MN_only_MDT_collection_vals[] = {
  {   0, "mn-only" },
  { 0, NULL }
};


static int
dissect_ngap_MN_only_MDT_collection(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_MobileIAB_Authorized_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_MobileIAB_Authorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_MobileIABNodeIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_MobileIABNodeIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_MobileIAB_Supported_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_MobileIAB_Supported(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MulticastSessionActivationRequestTransfer_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MulticastSessionActivationRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MulticastSessionActivationRequestTransfer, MulticastSessionActivationRequestTransfer_sequence);

  return offset;
}


static const per_sequence_t MulticastSessionDeactivationRequestTransfer_sequence[] = {
  { &hf_ngap_mBS_SessionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_SessionID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MulticastSessionDeactivationRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MulticastSessionDeactivationRequestTransfer, MulticastSessionDeactivationRequestTransfer_sequence);

  return offset;
}


static const per_sequence_t MulticastSessionUpdateRequestTransfer_sequence[] = {
  { &hf_ngap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MulticastSessionUpdateRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MulticastSessionUpdateRequestTransfer, MulticastSessionUpdateRequestTransfer_sequence);

  return offset;
}


static const per_sequence_t MBS_AreaTAIList_sequence_of[1] = {
  { &hf_ngap_MBS_AreaTAIList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
};

static int
dissect_ngap_MBS_AreaTAIList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MBS_AreaTAIList, MBS_AreaTAIList_sequence_of,
                                                  1, maxnoofTAIforPaging, false);

  return offset;
}


static const per_sequence_t MulticastGroupPagingArea_sequence[] = {
  { &hf_ngap_mBS_AreaTAIList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MBS_AreaTAIList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MulticastGroupPagingArea(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MulticastGroupPagingArea, MulticastGroupPagingArea_sequence);

  return offset;
}


static const per_sequence_t UE_PagingItem_sequence[] = {
  { &hf_ngap_uEIdentityIndexValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UEIdentityIndexValue },
  { &hf_ngap_pagingDRX      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PagingDRX },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_UE_PagingItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_UE_PagingItem, UE_PagingItem_sequence);

  return offset;
}


static const per_sequence_t UE_PagingList_sequence_of[1] = {
  { &hf_ngap_UE_PagingList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_UE_PagingItem },
};

static int
dissect_ngap_UE_PagingList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_UE_PagingList, UE_PagingList_sequence_of,
                                                  1, maxnoofUEsforPaging, false);

  return offset;
}


static const per_sequence_t MulticastGroupPagingAreaItem_sequence[] = {
  { &hf_ngap_multicastGroupPagingArea, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_MulticastGroupPagingArea },
  { &hf_ngap_uE_PagingList  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UE_PagingList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_MulticastGroupPagingAreaItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_MulticastGroupPagingAreaItem, MulticastGroupPagingAreaItem_sequence);

  return offset;
}


static const per_sequence_t MulticastGroupPagingAreaList_sequence_of[1] = {
  { &hf_ngap_MulticastGroupPagingAreaList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_MulticastGroupPagingAreaItem },
};

static int
dissect_ngap_MulticastGroupPagingAreaList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_MulticastGroupPagingAreaList, MulticastGroupPagingAreaList_sequence_of,
                                                  1, maxnoofPagingAreas, false);

  return offset;
}


static const value_string ngap_IncludeBeamMeasurementsIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_IncludeBeamMeasurementsIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_M4ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_ngap_M4ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_M5ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_ngap_M5ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_M6ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_ngap_M6ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_M7ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_ngap_M7ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_INTEGER_M127_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -127, 127U, NULL, false);

  return offset;
}


static const per_sequence_t N6JitterInformation_sequence[] = {
  { &hf_ngap_n6JitterLowerBound, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_M127_127 },
  { &hf_ngap_n6JitterUpperBound, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_M127_127 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_N6JitterInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_N6JitterInformation, N6JitterInformation_sequence);

  return offset;
}



static int
dissect_ngap_NAS_PDU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

  tvbuff_t *parameter_tvb=NULL;
  unsigned tvb_len;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);


  tvb_len = tvb_reported_length(parameter_tvb);
  if (tvb_len > 0) {
    struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
    if (ngap_data->protocol_ie_id == id_NASC) {
      proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_NASC);
      /* use an heuristic based on the payload length to identify the Intra N1 mode
         NAS transparent container or the S1 mode to N1 mode NAS transparent container */
      if (tvb_len == 8)
        de_nas_5gs_s1_mode_to_n1_mode_nas_transparent_cont(parameter_tvb, subtree, actx->pinfo);
      else
        de_nas_5gs_intra_n1_mode_nas_transparent_cont(parameter_tvb, subtree, actx->pinfo);
    } else {
      if (nas_5gs_handle) {
        proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_NAS_PDU);
        volatile int saved_offset = offset;
        TRY {
          call_dissector(nas_5gs_handle, parameter_tvb, actx->pinfo, subtree);
        }
        CATCH_BOUNDS_ERRORS {
          show_exception(tvb, actx->pinfo, subtree, EXCEPT_CODE, GET_MESSAGE);
        }
        ENDTRY;
        offset = saved_offset;
      }
    }
  }


  return offset;
}



static int
dissect_ngap_NASSecurityParametersFromNGRAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree;

    subtree = proto_item_add_subtree(actx->created_item, ett_ngap_NASSecurityParametersFromNGRAN);
    de_nas_5gs_n1_mode_to_s1_mode_nas_transparent_cont(parameter_tvb, subtree, actx->pinfo);
  }


  return offset;
}


static const value_string ngap_NB_IoT_DefaultPagingDRX_vals[] = {
  {   0, "rf128" },
  {   1, "rf256" },
  {   2, "rf512" },
  {   3, "rf1024" },
  { 0, NULL }
};


static int
dissect_ngap_NB_IoT_DefaultPagingDRX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_NB_IoT_PagingDRX_vals[] = {
  {   0, "rf32" },
  {   1, "rf64" },
  {   2, "rf128" },
  {   3, "rf256" },
  {   4, "rf512" },
  {   5, "rf1024" },
  { 0, NULL }
};


static int
dissect_ngap_NB_IoT_PagingDRX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_NB_IoT_Paging_eDRXCycle_vals[] = {
  {   0, "hf2" },
  {   1, "hf4" },
  {   2, "hf6" },
  {   3, "hf8" },
  {   4, "hf10" },
  {   5, "hf12" },
  {   6, "hf14" },
  {   7, "hf16" },
  {   8, "hf32" },
  {   9, "hf64" },
  {  10, "hf128" },
  {  11, "hf256" },
  {  12, "hf512" },
  {  13, "hf1024" },
  { 0, NULL }
};


static int
dissect_ngap_NB_IoT_Paging_eDRXCycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     14, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_NB_IoT_Paging_TimeWindow_vals[] = {
  {   0, "s1" },
  {   1, "s2" },
  {   2, "s3" },
  {   3, "s4" },
  {   4, "s5" },
  {   5, "s6" },
  {   6, "s7" },
  {   7, "s8" },
  {   8, "s9" },
  {   9, "s10" },
  {  10, "s11" },
  {  11, "s12" },
  {  12, "s13" },
  {  13, "s14" },
  {  14, "s15" },
  {  15, "s16" },
  { 0, NULL }
};


static int
dissect_ngap_NB_IoT_Paging_TimeWindow(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NB_IoT_Paging_eDRXInfo_sequence[] = {
  { &hf_ngap_nB_IoT_Paging_eDRXCycle, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NB_IoT_Paging_eDRXCycle },
  { &hf_ngap_nB_IoT_Paging_TimeWindow, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NB_IoT_Paging_TimeWindow },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NB_IoT_Paging_eDRXInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NB_IoT_Paging_eDRXInfo, NB_IoT_Paging_eDRXInfo_sequence);

  return offset;
}



static int
dissect_ngap_NB_IoT_UEPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, true);

  return offset;
}


static const value_string ngap_NetworkControlledRepeaterAuthorized_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_NetworkControlledRepeaterAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_NetworkInstance(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, true);

  return offset;
}


static const value_string ngap_NewSecurityContextInd_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_NewSecurityContextInd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_NextHopChainingCount(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const per_sequence_t NGAPIESupportInformationRequestItem_sequence[] = {
  { &hf_ngap_ngap_ProtocolIE_Id, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ProtocolIE_ID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NGAPIESupportInformationRequestItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NGAPIESupportInformationRequestItem, NGAPIESupportInformationRequestItem_sequence);

  return offset;
}


static const per_sequence_t NGAPIESupportInformationRequestList_sequence_of[1] = {
  { &hf_ngap_NGAPIESupportInformationRequestList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NGAPIESupportInformationRequestItem },
};

static int
dissect_ngap_NGAPIESupportInformationRequestList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_NGAPIESupportInformationRequestList, NGAPIESupportInformationRequestList_sequence_of,
                                                  1, maxnoofNGAPIESupportInfo, false);

  return offset;
}


static const value_string ngap_T_ngap_ProtocolIESupportInfo_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  { 0, NULL }
};


static int
dissect_ngap_T_ngap_ProtocolIESupportInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_ngap_ProtocolIEPresenceInfo_vals[] = {
  {   0, "present" },
  {   1, "not-present" },
  { 0, NULL }
};


static int
dissect_ngap_T_ngap_ProtocolIEPresenceInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NGAPIESupportInformationResponseItem_sequence[] = {
  { &hf_ngap_ngap_ProtocolIE_Id, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ProtocolIE_ID },
  { &hf_ngap_ngap_ProtocolIESupportInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_ngap_ProtocolIESupportInfo },
  { &hf_ngap_ngap_ProtocolIEPresenceInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_ngap_ProtocolIEPresenceInfo },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NGAPIESupportInformationResponseItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NGAPIESupportInformationResponseItem, NGAPIESupportInformationResponseItem_sequence);

  return offset;
}


static const per_sequence_t NGAPIESupportInformationResponseList_sequence_of[1] = {
  { &hf_ngap_NGAPIESupportInformationResponseList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NGAPIESupportInformationResponseItem },
};

static int
dissect_ngap_NGAPIESupportInformationResponseList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_NGAPIESupportInformationResponseList, NGAPIESupportInformationResponseList_sequence_of,
                                                  1, maxnoofNGAPIESupportInfo, false);

  return offset;
}


static const value_string ngap_NotifySourceNGRANNode_vals[] = {
  {   0, "notifySource" },
  { 0, NULL }
};


static int
dissect_ngap_NotifySourceNGRANNode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NGRAN_TNLAssociationToRemoveItem_sequence[] = {
  { &hf_ngap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_CPTransportLayerInformation },
  { &hf_ngap_tNLAssociationTransportLayerAddressAMF, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ngap_CPTransportLayerInformation },
  { &hf_ngap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NGRAN_TNLAssociationToRemoveItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NGRAN_TNLAssociationToRemoveItem, NGRAN_TNLAssociationToRemoveItem_sequence);

  return offset;
}


static const per_sequence_t NGRAN_TNLAssociationToRemoveList_sequence_of[1] = {
  { &hf_ngap_NGRAN_TNLAssociationToRemoveList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_TNLAssociationToRemoveItem },
};

static int
dissect_ngap_NGRAN_TNLAssociationToRemoveList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_NGRAN_TNLAssociationToRemoveList, NGRAN_TNLAssociationToRemoveList_sequence_of,
                                                  1, maxnoofTNLAssociations, false);

  return offset;
}


static const value_string ngap_NoPDUSessionIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_NoPDUSessionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_NotificationCause_vals[] = {
  {   0, "fulfilled" },
  {   1, "not-fulfilled" },
  { 0, NULL }
};


static int
dissect_ngap_NotificationCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_NPN_AccessInformation_vals[] = {
  {   0, "pNI-NPN-Access-Information" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t NPN_AccessInformation_choice[] = {
  {   0, &hf_ngap_pNI_NPN_Access_Information, ASN1_NO_EXTENSIONS     , dissect_ngap_CellCAGList },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_NPN_AccessInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_NPN_AccessInformation, NPN_AccessInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SNPN_MobilityInformation_sequence[] = {
  { &hf_ngap_serving_NID    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SNPN_MobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SNPN_MobilityInformation, SNPN_MobilityInformation_sequence);

  return offset;
}


static const per_sequence_t PNI_NPN_MobilityInformation_sequence[] = {
  { &hf_ngap_allowed_PNI_NPI_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Allowed_PNI_NPN_List },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PNI_NPN_MobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PNI_NPN_MobilityInformation, PNI_NPN_MobilityInformation_sequence);

  return offset;
}


static const value_string ngap_NPN_MobilityInformation_vals[] = {
  {   0, "sNPN-MobilityInformation" },
  {   1, "pNI-NPN-MobilityInformation" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t NPN_MobilityInformation_choice[] = {
  {   0, &hf_ngap_sNPN_MobilityInformation, ASN1_NO_EXTENSIONS     , dissect_ngap_SNPN_MobilityInformation },
  {   1, &hf_ngap_pNI_NPN_MobilityInformation, ASN1_NO_EXTENSIONS     , dissect_ngap_PNI_NPN_MobilityInformation },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_NPN_MobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_NPN_MobilityInformation, NPN_MobilityInformation_choice,
                                 NULL);

  return offset;
}


static const value_string ngap_NPN_PagingAssistanceInformation_vals[] = {
  {   0, "pNI-NPN-PagingAssistance" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t NPN_PagingAssistanceInformation_choice[] = {
  {   0, &hf_ngap_pNI_NPN_PagingAssistance, ASN1_NO_EXTENSIONS     , dissect_ngap_Allowed_PNI_NPN_List },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_NPN_PagingAssistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_NPN_PagingAssistanceInformation, NPN_PagingAssistanceInformation_choice,
                                 NULL);

  return offset;
}


static const value_string ngap_NPN_Support_vals[] = {
  {   0, "sNPN" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t NPN_Support_choice[] = {
  {   0, &hf_ngap_sNPN           , ASN1_NO_EXTENSIONS     , dissect_ngap_NID },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_NPN_Support(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_NPN_Support, NPN_Support_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NR_CGIListForWarning_sequence_of[1] = {
  { &hf_ngap_NR_CGIListForWarning_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_NR_CGI },
};

static int
dissect_ngap_NR_CGIListForWarning(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_NR_CGIListForWarning, NR_CGIListForWarning_sequence_of,
                                                  1, maxnoofCellIDforWarning, false);

  return offset;
}


static const value_string ngap_NR_Paging_eDRX_Cycle_vals[] = {
  {   0, "hfquarter" },
  {   1, "hfhalf" },
  {   2, "hf1" },
  {   3, "hf2" },
  {   4, "hf4" },
  {   5, "hf8" },
  {   6, "hf16" },
  {   7, "hf32" },
  {   8, "hf64" },
  {   9, "hf128" },
  {  10, "hf256" },
  {  11, "hf512" },
  {  12, "hf1024" },
  { 0, NULL }
};


static int
dissect_ngap_NR_Paging_eDRX_Cycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     13, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_NR_Paging_Time_Window_vals[] = {
  {   0, "s1" },
  {   1, "s2" },
  {   2, "s3" },
  {   3, "s4" },
  {   4, "s5" },
  {   5, "s6" },
  {   6, "s7" },
  {   7, "s8" },
  {   8, "s9" },
  {   9, "s10" },
  {  10, "s11" },
  {  11, "s12" },
  {  12, "s13" },
  {  13, "s14" },
  {  14, "s15" },
  {  15, "s16" },
  {  16, "s17" },
  {  17, "s18" },
  {  18, "s19" },
  {  19, "s20" },
  {  20, "s21" },
  {  21, "s22" },
  {  22, "s23" },
  {  23, "s24" },
  {  24, "s25" },
  {  25, "s26" },
  {  26, "s27" },
  {  27, "s28" },
  {  28, "s29" },
  {  29, "s30" },
  {  30, "s31" },
  {  31, "s32" },
  { 0, NULL }
};


static int
dissect_ngap_NR_Paging_Time_Window(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, true, 16, NULL);

  return offset;
}


static const per_sequence_t NR_PagingeDRXInformation_sequence[] = {
  { &hf_ngap_nR_paging_eDRX_Cycle, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NR_Paging_eDRX_Cycle },
  { &hf_ngap_nR_paging_Time_Window, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NR_Paging_Time_Window },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NR_PagingeDRXInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NR_PagingeDRXInformation, NR_PagingeDRXInformation_sequence);

  return offset;
}



static int
dissect_ngap_NRencryptionAlgorithms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, true, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_ngap_NrencryptionAlgorithms_nea1,
      &hf_ngap_NrencryptionAlgorithms_nea2,
      &hf_ngap_NrencryptionAlgorithms_nea3,
      &hf_ngap_NrencryptionAlgorithms_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_NrencryptionAlgorithms);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 2, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}



static int
dissect_ngap_NRintegrityProtectionAlgorithms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, true, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_ngap_NrintegrityProtectionAlgorithms_nia1,
      &hf_ngap_NrintegrityProtectionAlgorithms_nia2,
      &hf_ngap_NrintegrityProtectionAlgorithms_nia3,
      &hf_ngap_NrintegrityProtectionAlgorithms_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_NrintegrityProtectionAlgorithms);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 2, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}



static int
dissect_ngap_NRMobilityHistoryReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *nr_mob_hist_report_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &nr_mob_hist_report_tvb);

  if (nr_mob_hist_report_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_NRMobilityHistoryReport);
    dissect_nr_rrc_VisitedCellInfoList_r16_PDU(nr_mob_hist_report_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_ngap_NRPPa_PDU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "NRPPa-PDU");


  tvbuff_t *parameter_tvb=NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);


  if ((tvb_reported_length(parameter_tvb)>0)&&(nrppa_handle))
    call_dissector(nrppa_handle, parameter_tvb, actx->pinfo, tree);


  return offset;
}


static const per_sequence_t TACListInNRNTN_sequence_of[1] = {
  { &hf_ngap_TACListInNRNTN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TAC },
};

static int
dissect_ngap_TACListInNRNTN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_TACListInNRNTN, TACListInNRNTN_sequence_of,
                                                  1, maxnoofTACsinNTN, false);

  return offset;
}


static const per_sequence_t NRNTNTAIInformation_sequence[] = {
  { &hf_ngap_servingPLMN    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_tACListInNRNTN , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TACListInNRNTN },
  { &hf_ngap_uELocationDerivedTACInNRNTN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_TAC },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NRNTNTAIInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NRNTNTAIInformation, NRNTNTAIInformation_sequence);

  return offset;
}



static int
dissect_ngap_NumberOfBroadcastsRequested(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const per_sequence_t NRV2XServicesAuthorized_sequence[] = {
  { &hf_ngap_vehicleUE      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_VehicleUE },
  { &hf_ngap_pedestrianUE   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PedestrianUE },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NRV2XServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NRV2XServicesAuthorized, NRV2XServicesAuthorized_sequence);

  return offset;
}


static const per_sequence_t NRUESidelinkAggregateMaximumBitrate_sequence[] = {
  { &hf_ngap_uESidelinkAggregateMaximumBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NRUESidelinkAggregateMaximumBitrate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NRUESidelinkAggregateMaximumBitrate, NRUESidelinkAggregateMaximumBitrate_sequence);

  return offset;
}



static int
dissect_ngap_NSAG_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, true);

  return offset;
}


static const value_string ngap_T_aerialUE_01_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_T_aerialUE_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_aerialControllerUE_01_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_ngap_T_aerialControllerUE_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NR_A2X_ServicesAuthorized_sequence[] = {
  { &hf_ngap_aerialUE_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_aerialUE_01 },
  { &hf_ngap_aerialControllerUE_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_aerialControllerUE_01 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_NR_A2X_ServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_NR_A2X_ServicesAuthorized, NR_A2X_ServicesAuthorized_sequence);

  return offset;
}


static const value_string ngap_OnboardingSupport_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_OnboardingSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_OverloadAction_vals[] = {
  {   0, "reject-non-emergency-mo-dt" },
  {   1, "reject-rrc-cr-signalling" },
  {   2, "permit-emergency-sessions-and-mobile-terminated-services-only" },
  {   3, "permit-high-priority-sessions-and-mobile-terminated-services-only" },
  { 0, NULL }
};


static int
dissect_ngap_OverloadAction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_OverloadResponse_vals[] = {
  {   0, "overloadAction" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t OverloadResponse_choice[] = {
  {   0, &hf_ngap_overloadAction , ASN1_NO_EXTENSIONS     , dissect_ngap_OverloadAction },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_OverloadResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_OverloadResponse, OverloadResponse_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SliceOverloadItem_sequence[] = {
  { &hf_ngap_s_NSSAI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_S_NSSAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SliceOverloadItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SliceOverloadItem, SliceOverloadItem_sequence);

  return offset;
}


static const per_sequence_t SliceOverloadList_sequence_of[1] = {
  { &hf_ngap_SliceOverloadList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_SliceOverloadItem },
};

static int
dissect_ngap_SliceOverloadList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_SliceOverloadList, SliceOverloadList_sequence_of,
                                                  1, maxnoofSliceItems, false);

  return offset;
}



static int
dissect_ngap_TrafficLoadReductionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 99U, NULL, false);

  return offset;
}


static const per_sequence_t OverloadStartNSSAIItem_sequence[] = {
  { &hf_ngap_sliceOverloadList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SliceOverloadList },
  { &hf_ngap_sliceOverloadResponse, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_OverloadResponse },
  { &hf_ngap_sliceTrafficLoadReductionIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_TrafficLoadReductionIndication },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_OverloadStartNSSAIItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_OverloadStartNSSAIItem, OverloadStartNSSAIItem_sequence);

  return offset;
}


static const per_sequence_t OverloadStartNSSAIList_sequence_of[1] = {
  { &hf_ngap_OverloadStartNSSAIList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_OverloadStartNSSAIItem },
};

static int
dissect_ngap_OverloadStartNSSAIList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_OverloadStartNSSAIList, OverloadStartNSSAIList_sequence_of,
                                                  1, maxnoofSliceItems, false);

  return offset;
}


static const per_sequence_t PagingAssisDataforCEcapabUE_sequence[] = {
  { &hf_ngap_eUTRA_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_EUTRA_CGI },
  { &hf_ngap_coverageEnhancementLevel, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CoverageEnhancementLevel },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PagingAssisDataforCEcapabUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PagingAssisDataforCEcapabUE, PagingAssisDataforCEcapabUE_sequence);

  return offset;
}


static const value_string ngap_PagingCause_vals[] = {
  {   0, "voice" },
  { 0, NULL }
};


static int
dissect_ngap_PagingCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  uint32_t value;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, &value, true, 0, NULL);

  col_append_fstr(actx->pinfo->cinfo, COL_INFO, " [PagingCause=%s]", val_to_str_const(value, ngap_PagingCause_vals, "Unknown"));


  return offset;
}


static const value_string ngap_PagingCauseIndicationForVoiceService_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_ngap_PagingCauseIndicationForVoiceService(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  uint32_t value;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, &value, true, 0, NULL);

  col_append_fstr(actx->pinfo->cinfo, COL_INFO, " [PagingCauseIndicationForVoiceService=%s]", val_to_str_const(value, ngap_PagingCauseIndicationForVoiceService_vals, "Unknown"));


  return offset;
}


static const value_string ngap_PagingOrigin_vals[] = {
  {   0, "non-3gpp" },
  { 0, NULL }
};


static int
dissect_ngap_PagingOrigin(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_PDUSessionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static int
dissect_ngap_PagingPolicyIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, true);

  return offset;
}



static int
dissect_ngap_INTEGER_0_96000_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 96000U, NULL, true);

  return offset;
}


static const per_sequence_t PagingPolicyDifferentiationItem_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_pagingPolicyIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PagingPolicyIndicator },
  { &hf_ngap_allocationAndRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AllocationAndRetentionPriority },
  { &hf_ngap_fiveQI         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_FiveQI },
  { &hf_ngap_dl_DataSize    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_INTEGER_0_96000_ },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PagingPolicyDifferentiationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PagingPolicyDifferentiationItem, PagingPolicyDifferentiationItem_sequence);

  return offset;
}


static const per_sequence_t PagingPolicyDifferentiationList_sequence_of[1] = {
  { &hf_ngap_PagingPolicyDifferentiationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PagingPolicyDifferentiationItem },
};

static int
dissect_ngap_PagingPolicyDifferentiationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PagingPolicyDifferentiationList, PagingPolicyDifferentiationList_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const per_sequence_t PDUSessionForPagingItem_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pagingPolicyDifferentiationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PagingPolicyDifferentiationList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionForPagingItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionForPagingItem, PDUSessionForPagingItem_sequence);

  return offset;
}


static const per_sequence_t PDUSessionForPagingList_sequence_of[1] = {
  { &hf_ngap_PDUSessionForPagingList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionForPagingItem },
};

static int
dissect_ngap_PDUSessionForPagingList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionForPagingList, PDUSessionForPagingList_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t PagingPolicyDifferentiation_sequence[] = {
  { &hf_ngap_pDUSessionForPagingList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionForPagingList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PagingPolicyDifferentiation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PagingPolicyDifferentiation, PagingPolicyDifferentiation_sequence);

  return offset;
}


static const value_string ngap_PagingPriority_vals[] = {
  {   0, "priolevel1" },
  {   1, "priolevel2" },
  {   2, "priolevel3" },
  {   3, "priolevel4" },
  {   4, "priolevel5" },
  {   5, "priolevel6" },
  {   6, "priolevel7" },
  {   7, "priolevel8" },
  { 0, NULL }
};


static int
dissect_ngap_PagingPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_PagingProbabilityInformation_vals[] = {
  {   0, "p00" },
  {   1, "p05" },
  {   2, "p10" },
  {   3, "p15" },
  {   4, "p20" },
  {   5, "p25" },
  {   6, "p30" },
  {   7, "p35" },
  {   8, "p40" },
  {   9, "p45" },
  {  10, "p50" },
  {  11, "p55" },
  {  12, "p60" },
  {  13, "p65" },
  {  14, "p70" },
  {  15, "p75" },
  {  16, "p80" },
  {  17, "p85" },
  {  18, "p90" },
  {  19, "p95" },
  {  20, "p100" },
  { 0, NULL }
};


static int
dissect_ngap_PagingProbabilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     21, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_ParentTImeSource_vals[] = {
  {   0, "synce" },
  {   1, "ptp" },
  {   2, "gnss" },
  {   3, "atomicclock" },
  {   4, "terrestrialradio" },
  {   5, "serialtimecode" },
  {   6, "ntp" },
  {   7, "handset" },
  {   8, "other" },
  { 0, NULL }
};


static int
dissect_ngap_ParentTImeSource(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PartiallyAllowedNSSAI_Item_sequence[] = {
  { &hf_ngap_s_NSSAI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_S_NSSAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PartiallyAllowedNSSAI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PartiallyAllowedNSSAI_Item, PartiallyAllowedNSSAI_Item_sequence);

  return offset;
}


static const per_sequence_t Partially_Allowed_NSSAI_sequence_of[1] = {
  { &hf_ngap_Partially_Allowed_NSSAI_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PartiallyAllowedNSSAI_Item },
};

static int
dissect_ngap_Partially_Allowed_NSSAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_Partially_Allowed_NSSAI, Partially_Allowed_NSSAI_sequence_of,
                                                  1, maxnoofPartiallyAllowedS_NSSAIs, false);

  return offset;
}


static const per_sequence_t SecurityIndication_sequence[] = {
  { &hf_ngap_integrityProtectionIndication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_IntegrityProtectionIndication },
  { &hf_ngap_confidentialityProtectionIndication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ConfidentialityProtectionIndication },
  { &hf_ngap_maximumIntegrityProtectedDataRate_UL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MaximumIntegrityProtectedDataRate },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SecurityIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SecurityIndication, SecurityIndication_sequence);

  return offset;
}


static const per_sequence_t PathSwitchRequestAcknowledgeTransfer_sequence[] = {
  { &hf_ngap_uL_NGU_UP_TNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_securityIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_SecurityIndication },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PathSwitchRequestAcknowledgeTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PathSwitchRequestAcknowledgeTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PathSwitchRequestAcknowledgeTransfer, PathSwitchRequestAcknowledgeTransfer_sequence);

  return offset;
}


static const per_sequence_t PathSwitchRequestSetupFailedTransfer_sequence[] = {
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PathSwitchRequestSetupFailedTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PathSwitchRequestSetupFailedTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PathSwitchRequestSetupFailedTransfer, PathSwitchRequestSetupFailedTransfer_sequence);

  return offset;
}


static const per_sequence_t UserPlaneSecurityInformation_sequence[] = {
  { &hf_ngap_securityResult , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SecurityResult },
  { &hf_ngap_securityIndication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SecurityIndication },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_UserPlaneSecurityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_UserPlaneSecurityInformation, UserPlaneSecurityInformation_sequence);

  return offset;
}


static const per_sequence_t QosFlowAcceptedItem_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowAcceptedItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowAcceptedItem, QosFlowAcceptedItem_sequence);

  return offset;
}


static const per_sequence_t QosFlowAcceptedList_sequence_of[1] = {
  { &hf_ngap_QosFlowAcceptedList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowAcceptedItem },
};

static int
dissect_ngap_QosFlowAcceptedList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowAcceptedList, QosFlowAcceptedList_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const per_sequence_t PathSwitchRequestTransfer_sequence[] = {
  { &hf_ngap_dL_NGU_UP_TNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_dL_NGU_TNLInformationReused, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_DL_NGU_TNLInformationReused },
  { &hf_ngap_userPlaneSecurityInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UserPlaneSecurityInformation },
  { &hf_ngap_qosFlowAcceptedList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowAcceptedList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PathSwitchRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PathSwitchRequestTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PathSwitchRequestTransfer, PathSwitchRequestTransfer_sequence);

  return offset;
}


static const per_sequence_t PathSwitchRequestUnsuccessfulTransfer_sequence[] = {
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PathSwitchRequestUnsuccessfulTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PathSwitchRequestUnsuccessfulTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PathSwitchRequestUnsuccessfulTransfer, PathSwitchRequestUnsuccessfulTransfer_sequence);

  return offset;
}


static const per_sequence_t PC5FlowBitRates_sequence[] = {
  { &hf_ngap_guaranteedFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_maximumFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PC5FlowBitRates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PC5FlowBitRates, PC5FlowBitRates_sequence);

  return offset;
}


static const per_sequence_t PC5QoSFlowItem_sequence[] = {
  { &hf_ngap_pQI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_FiveQI },
  { &hf_ngap_pc5FlowBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PC5FlowBitRates },
  { &hf_ngap_range          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_Range },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PC5QoSFlowItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PC5QoSFlowItem, PC5QoSFlowItem_sequence);

  return offset;
}


static const per_sequence_t PC5QoSFlowList_sequence_of[1] = {
  { &hf_ngap_PC5QoSFlowList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PC5QoSFlowItem },
};

static int
dissect_ngap_PC5QoSFlowList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PC5QoSFlowList, PC5QoSFlowList_sequence_of,
                                                  1, maxnoofPC5QoSFlows, false);

  return offset;
}


static const per_sequence_t PC5QoSParameters_sequence[] = {
  { &hf_ngap_pc5QoSFlowList , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PC5QoSFlowList },
  { &hf_ngap_pc5LinkAggregateBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BitRate },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PC5QoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PC5QoSParameters, PC5QoSParameters_sequence);

  return offset;
}


static const value_string ngap_PrivacyIndicator_vals[] = {
  {   0, "immediate-MDT" },
  {   1, "logged-MDT" },
  { 0, NULL }
};


static int
dissect_ngap_PrivacyIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PDUSessionAggregateMaximumBitRate_sequence[] = {
  { &hf_ngap_pDUSessionAggregateMaximumBitRateDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_pDUSessionAggregateMaximumBitRateUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionAggregateMaximumBitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionAggregateMaximumBitRate, PDUSessionAggregateMaximumBitRate_sequence);

  return offset;
}



static int
dissect_ngap_PDUSessionPairID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, true);

  return offset;
}



static int
dissect_ngap_T_handoverRequestAcknowledgeTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_HandoverRequestAcknowledgeTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceAdmittedItem_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_handoverRequestAcknowledgeTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_handoverRequestAcknowledgeTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceAdmittedItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceAdmittedItem, PDUSessionResourceAdmittedItem_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceAdmittedList_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceAdmittedList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceAdmittedItem },
};

static int
dissect_ngap_PDUSessionResourceAdmittedList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceAdmittedList, PDUSessionResourceAdmittedList_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceModifyIndicationUnsuccessfulTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceModifyIndicationUnsuccessfulTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToModifyItemModCfm_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionResourceModifyIndicationUnsuccessfulTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceModifyIndicationUnsuccessfulTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceFailedToModifyItemModCfm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceFailedToModifyItemModCfm, PDUSessionResourceFailedToModifyItemModCfm_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToModifyListModCfm_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceFailedToModifyListModCfm_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceFailedToModifyItemModCfm },
};

static int
dissect_ngap_PDUSessionResourceFailedToModifyListModCfm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceFailedToModifyListModCfm, PDUSessionResourceFailedToModifyListModCfm_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceModifyUnsuccessfulTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceModifyUnsuccessfulTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToModifyItemModRes_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionResourceModifyUnsuccessfulTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceModifyUnsuccessfulTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceFailedToModifyItemModRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceFailedToModifyItemModRes, PDUSessionResourceFailedToModifyItemModRes_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToModifyListModRes_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceFailedToModifyListModRes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceFailedToModifyItemModRes },
};

static int
dissect_ngap_PDUSessionResourceFailedToModifyListModRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceFailedToModifyListModRes, PDUSessionResourceFailedToModifyListModRes_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToResumeItemRESReq_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceFailedToResumeItemRESReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceFailedToResumeItemRESReq, PDUSessionResourceFailedToResumeItemRESReq_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToResumeListRESReq_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceFailedToResumeListRESReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceFailedToResumeItemRESReq },
};

static int
dissect_ngap_PDUSessionResourceFailedToResumeListRESReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceFailedToResumeListRESReq, PDUSessionResourceFailedToResumeListRESReq_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToResumeItemRESRes_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceFailedToResumeItemRESRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceFailedToResumeItemRESRes, PDUSessionResourceFailedToResumeItemRESRes_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToResumeListRESRes_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceFailedToResumeListRESRes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceFailedToResumeItemRESRes },
};

static int
dissect_ngap_PDUSessionResourceFailedToResumeListRESRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceFailedToResumeListRESRes, PDUSessionResourceFailedToResumeListRESRes_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceSetupUnsuccessfulTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceSetupUnsuccessfulTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToSetupItemCxtFail_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionResourceSetupUnsuccessfulTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceSetupUnsuccessfulTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceFailedToSetupItemCxtFail(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceFailedToSetupItemCxtFail, PDUSessionResourceFailedToSetupItemCxtFail_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToSetupListCxtFail_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceFailedToSetupListCxtFail_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceFailedToSetupItemCxtFail },
};

static int
dissect_ngap_PDUSessionResourceFailedToSetupListCxtFail(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceFailedToSetupListCxtFail, PDUSessionResourceFailedToSetupListCxtFail_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceSetupUnsuccessfulTransfer_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceSetupUnsuccessfulTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToSetupItemCxtRes_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionResourceSetupUnsuccessfulTransfer_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceSetupUnsuccessfulTransfer_01 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceFailedToSetupItemCxtRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceFailedToSetupItemCxtRes, PDUSessionResourceFailedToSetupItemCxtRes_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToSetupListCxtRes_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceFailedToSetupListCxtRes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceFailedToSetupItemCxtRes },
};

static int
dissect_ngap_PDUSessionResourceFailedToSetupListCxtRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceFailedToSetupListCxtRes, PDUSessionResourceFailedToSetupListCxtRes_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_handoverResourceAllocationUnsuccessfulTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_HandoverResourceAllocationUnsuccessfulTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToSetupItemHOAck_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_handoverResourceAllocationUnsuccessfulTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_handoverResourceAllocationUnsuccessfulTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceFailedToSetupItemHOAck(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceFailedToSetupItemHOAck, PDUSessionResourceFailedToSetupItemHOAck_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToSetupListHOAck_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceFailedToSetupListHOAck_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceFailedToSetupItemHOAck },
};

static int
dissect_ngap_PDUSessionResourceFailedToSetupListHOAck(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceFailedToSetupListHOAck, PDUSessionResourceFailedToSetupListHOAck_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pathSwitchRequestSetupFailedTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PathSwitchRequestSetupFailedTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToSetupItemPSReq_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pathSwitchRequestSetupFailedTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pathSwitchRequestSetupFailedTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceFailedToSetupItemPSReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceFailedToSetupItemPSReq, PDUSessionResourceFailedToSetupItemPSReq_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToSetupListPSReq_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceFailedToSetupListPSReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceFailedToSetupItemPSReq },
};

static int
dissect_ngap_PDUSessionResourceFailedToSetupListPSReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceFailedToSetupListPSReq, PDUSessionResourceFailedToSetupListPSReq_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceSetupUnsuccessfulTransfer_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceSetupUnsuccessfulTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToSetupItemSURes_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionResourceSetupUnsuccessfulTransfer_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceSetupUnsuccessfulTransfer_02 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceFailedToSetupItemSURes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceFailedToSetupItemSURes, PDUSessionResourceFailedToSetupItemSURes_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceFailedToSetupListSURes_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceFailedToSetupListSURes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceFailedToSetupItemSURes },
};

static int
dissect_ngap_PDUSessionResourceFailedToSetupListSURes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceFailedToSetupListSURes, PDUSessionResourceFailedToSetupListSURes_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_handoverCommandTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_HandoverCommandTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceHandoverItem_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_handoverCommandTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_handoverCommandTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceHandoverItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceHandoverItem, PDUSessionResourceHandoverItem_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceHandoverList_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceHandoverList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceHandoverItem },
};

static int
dissect_ngap_PDUSessionResourceHandoverList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceHandoverList, PDUSessionResourceHandoverList_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t QosFlowInformationItem_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_dLForwarding   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_DLForwarding },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowInformationItem, QosFlowInformationItem_sequence);

  return offset;
}


static const per_sequence_t QosFlowInformationList_sequence_of[1] = {
  { &hf_ngap_QosFlowInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowInformationItem },
};

static int
dissect_ngap_QosFlowInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowInformationList, QosFlowInformationList_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceInformationItem_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_qosFlowInformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowInformationList },
  { &hf_ngap_dRBsToQosFlowsMappingList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_DRBsToQosFlowsMappingList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceInformationItem, PDUSessionResourceInformationItem_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceInformationList_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceInformationItem },
};

static int
dissect_ngap_PDUSessionResourceInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceInformationList, PDUSessionResourceInformationList_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceItemCxtRelCpl_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceItemCxtRelCpl(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceItemCxtRelCpl, PDUSessionResourceItemCxtRelCpl_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceListCxtRelCpl_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceListCxtRelCpl_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceItemCxtRelCpl },
};

static int
dissect_ngap_PDUSessionResourceListCxtRelCpl(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceListCxtRelCpl, PDUSessionResourceListCxtRelCpl_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_PDUSessionResourceReleaseResponseTransfer_OCTET_STRING(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceReleaseResponseTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceItemCxtRelReq_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceItemCxtRelReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceItemCxtRelReq, PDUSessionResourceItemCxtRelReq_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceListCxtRelReq_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceListCxtRelReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceItemCxtRelReq },
};

static int
dissect_ngap_PDUSessionResourceListCxtRelReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceListCxtRelReq, PDUSessionResourceListCxtRelReq_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_handoverRequiredTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_HandoverRequiredTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceItemHORqd_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_handoverRequiredTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_handoverRequiredTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceItemHORqd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceItemHORqd, PDUSessionResourceItemHORqd_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceListHORqd_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceListHORqd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceItemHORqd },
};

static int
dissect_ngap_PDUSessionResourceListHORqd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceListHORqd, PDUSessionResourceListHORqd_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t PDUSessionListMTCommHReq_Item_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionListMTCommHReq_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionListMTCommHReq_Item, PDUSessionListMTCommHReq_Item_sequence);

  return offset;
}


static const per_sequence_t PDUSessionListMTCommHReq_sequence_of[1] = {
  { &hf_ngap_PDUSessionListMTCommHReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionListMTCommHReq_Item },
};

static int
dissect_ngap_PDUSessionListMTCommHReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionListMTCommHReq, PDUSessionListMTCommHReq_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t QosFlowModifyConfirmItem_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowModifyConfirmItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowModifyConfirmItem, QosFlowModifyConfirmItem_sequence);

  return offset;
}


static const per_sequence_t QosFlowModifyConfirmList_sequence_of[1] = {
  { &hf_ngap_QosFlowModifyConfirmList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowModifyConfirmItem },
};

static int
dissect_ngap_QosFlowModifyConfirmList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowModifyConfirmList, QosFlowModifyConfirmList_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const per_sequence_t UPTransportLayerInformationPairItem_sequence[] = {
  { &hf_ngap_uL_NGU_UP_TNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_dL_NGU_UP_TNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_UPTransportLayerInformationPairItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_UPTransportLayerInformationPairItem, UPTransportLayerInformationPairItem_sequence);

  return offset;
}


static const per_sequence_t UPTransportLayerInformationPairList_sequence_of[1] = {
  { &hf_ngap_UPTransportLayerInformationPairList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_UPTransportLayerInformationPairItem },
};

static int
dissect_ngap_UPTransportLayerInformationPairList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_UPTransportLayerInformationPairList, UPTransportLayerInformationPairList_sequence_of,
                                                  1, maxnoofMultiConnectivityMinusOne, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceModifyConfirmTransfer_sequence[] = {
  { &hf_ngap_qosFlowModifyConfirmList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowModifyConfirmList },
  { &hf_ngap_uLNGU_UP_TNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_additionalNG_UUPTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UPTransportLayerInformationPairList },
  { &hf_ngap_qosFlowFailedToModifyList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QosFlowListWithCause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceModifyConfirmTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PDUSessionResourceModifyConfirmTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceModifyConfirmTransfer, PDUSessionResourceModifyConfirmTransfer_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceModifyIndicationUnsuccessfulTransfer_sequence[] = {
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceModifyIndicationUnsuccessfulTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PDUSessionResourceModifyIndicationUnsuccessfulTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceModifyIndicationUnsuccessfulTransfer, PDUSessionResourceModifyIndicationUnsuccessfulTransfer_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceModifyRequestTransfer_sequence[] = {
  { &hf_ngap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceModifyRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PDUSessionResourceModifyRequestTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceModifyRequestTransfer, PDUSessionResourceModifyRequestTransfer_sequence);

  return offset;
}


static const per_sequence_t QosFlowAddOrModifyResponseItem_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowAddOrModifyResponseItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowAddOrModifyResponseItem, QosFlowAddOrModifyResponseItem_sequence);

  return offset;
}


static const per_sequence_t QosFlowAddOrModifyResponseList_sequence_of[1] = {
  { &hf_ngap_QosFlowAddOrModifyResponseList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowAddOrModifyResponseItem },
};

static int
dissect_ngap_QosFlowAddOrModifyResponseList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowAddOrModifyResponseList, QosFlowAddOrModifyResponseList_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const per_sequence_t QosFlowPerTNLInformation_sequence[] = {
  { &hf_ngap_uPTransportLayerInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_associatedQosFlowList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_AssociatedQosFlowList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowPerTNLInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowPerTNLInformation, QosFlowPerTNLInformation_sequence);

  return offset;
}


static const per_sequence_t QosFlowPerTNLInformationItem_sequence[] = {
  { &hf_ngap_qosFlowPerTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowPerTNLInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowPerTNLInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowPerTNLInformationItem, QosFlowPerTNLInformationItem_sequence);

  return offset;
}


static const per_sequence_t QosFlowPerTNLInformationList_sequence_of[1] = {
  { &hf_ngap_QosFlowPerTNLInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowPerTNLInformationItem },
};

static int
dissect_ngap_QosFlowPerTNLInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowPerTNLInformationList, QosFlowPerTNLInformationList_sequence_of,
                                                  1, maxnoofMultiConnectivityMinusOne, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceModifyResponseTransfer_sequence[] = {
  { &hf_ngap_dL_NGU_UP_TNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_uL_NGU_UP_TNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UPTransportLayerInformation },
  { &hf_ngap_qosFlowAddOrModifyResponseList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QosFlowAddOrModifyResponseList },
  { &hf_ngap_additionalDLQosFlowPerTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QosFlowPerTNLInformationList },
  { &hf_ngap_qosFlowFailedToAddOrModifyList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QosFlowListWithCause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceModifyResponseTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PDUSessionResourceModifyResponseTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceModifyResponseTransfer, PDUSessionResourceModifyResponseTransfer_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceModifyIndicationTransfer_sequence[] = {
  { &hf_ngap_dLQosFlowPerTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowPerTNLInformation },
  { &hf_ngap_additionalDLQosFlowPerTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QosFlowPerTNLInformationList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceModifyIndicationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PDUSessionResourceModifyIndicationTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceModifyIndicationTransfer, PDUSessionResourceModifyIndicationTransfer_sequence);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceModifyConfirmTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceModifyConfirmTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceModifyItemModCfm_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionResourceModifyConfirmTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceModifyConfirmTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceModifyItemModCfm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceModifyItemModCfm, PDUSessionResourceModifyItemModCfm_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceModifyListModCfm_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceModifyListModCfm_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceModifyItemModCfm },
};

static int
dissect_ngap_PDUSessionResourceModifyListModCfm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceModifyListModCfm, PDUSessionResourceModifyListModCfm_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceModifyIndicationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceModifyIndicationTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceModifyItemModInd_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionResourceModifyIndicationTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceModifyIndicationTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceModifyItemModInd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceModifyItemModInd, PDUSessionResourceModifyItemModInd_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceModifyListModInd_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceModifyListModInd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceModifyItemModInd },
};

static int
dissect_ngap_PDUSessionResourceModifyListModInd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceModifyListModInd, PDUSessionResourceModifyListModInd_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceModifyRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceModifyRequestTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceModifyItemModReq_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_nAS_PDU        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NAS_PDU },
  { &hf_ngap_pDUSessionResourceModifyRequestTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceModifyRequestTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceModifyItemModReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceModifyItemModReq, PDUSessionResourceModifyItemModReq_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceModifyListModReq_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceModifyListModReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceModifyItemModReq },
};

static int
dissect_ngap_PDUSessionResourceModifyListModReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceModifyListModReq, PDUSessionResourceModifyListModReq_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceModifyResponseTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceModifyResponseTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceModifyItemModRes_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionResourceModifyResponseTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceModifyResponseTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceModifyItemModRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceModifyItemModRes, PDUSessionResourceModifyItemModRes_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceModifyListModRes_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceModifyListModRes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceModifyItemModRes },
};

static int
dissect_ngap_PDUSessionResourceModifyListModRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceModifyListModRes, PDUSessionResourceModifyListModRes_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceModifyUnsuccessfulTransfer_sequence[] = {
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_criticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_CriticalityDiagnostics },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceModifyUnsuccessfulTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PDUSessionResourceModifyUnsuccessfulTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceModifyUnsuccessfulTransfer, PDUSessionResourceModifyUnsuccessfulTransfer_sequence);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceNotifyTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceNotifyTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceNotifyItem_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionResourceNotifyTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceNotifyTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceNotifyItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceNotifyItem, PDUSessionResourceNotifyItem_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceNotifyList_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceNotifyList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceNotifyItem },
};

static int
dissect_ngap_PDUSessionResourceNotifyList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceNotifyList, PDUSessionResourceNotifyList_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceNotifyReleasedTransfer_sequence[] = {
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceNotifyReleasedTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PDUSessionResourceNotifyReleasedTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceNotifyReleasedTransfer, PDUSessionResourceNotifyReleasedTransfer_sequence);

  return offset;
}


static const value_string ngap_UserPlaneErrorIndicator_vals[] = {
  {   0, "gTP-U-error-indication-received" },
  { 0, NULL }
};


static int
dissect_ngap_UserPlaneErrorIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t QosFlowNotifyItem_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_notificationCause, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NotificationCause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowNotifyItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  ngap_data->is_qos_flow_notify = true;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowNotifyItem, QosFlowNotifyItem_sequence);

  ngap_data->is_qos_flow_notify = false;

  return offset;
}


static const per_sequence_t QosFlowNotifyList_sequence_of[1] = {
  { &hf_ngap_QosFlowNotifyList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowNotifyItem },
};

static int
dissect_ngap_QosFlowNotifyList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowNotifyList, QosFlowNotifyList_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceNotifyTransfer_sequence[] = {
  { &hf_ngap_qosFlowNotifyList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QosFlowNotifyList },
  { &hf_ngap_qosFlowReleasedList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QosFlowListWithCause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceNotifyTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PDUSessionResourceNotifyTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceNotifyTransfer, PDUSessionResourceNotifyTransfer_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceReleaseCommandTransfer_sequence[] = {
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceReleaseCommandTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PDUSessionResourceReleaseCommandTransfer");

  ngap_get_private_data(actx->pinfo)->qos_flow_add_info_rel_type = 0;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceReleaseCommandTransfer, PDUSessionResourceReleaseCommandTransfer_sequence);

  ngap_get_private_data(actx->pinfo)->qos_flow_add_info_rel_type = -1;


  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceNotifyReleasedTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceNotifyReleasedTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceReleasedItemNot_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionResourceNotifyReleasedTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceNotifyReleasedTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceReleasedItemNot(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceReleasedItemNot, PDUSessionResourceReleasedItemNot_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceReleasedListNot_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceReleasedListNot_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceReleasedItemNot },
};

static int
dissect_ngap_PDUSessionResourceReleasedListNot(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceReleasedListNot, PDUSessionResourceReleasedListNot_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pathSwitchRequestUnsuccessfulTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PathSwitchRequestUnsuccessfulTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceReleasedItemPSAck_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pathSwitchRequestUnsuccessfulTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pathSwitchRequestUnsuccessfulTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceReleasedItemPSAck(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceReleasedItemPSAck, PDUSessionResourceReleasedItemPSAck_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceReleasedListPSAck_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceReleasedListPSAck_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceReleasedItemPSAck },
};

static int
dissect_ngap_PDUSessionResourceReleasedListPSAck(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceReleasedListPSAck, PDUSessionResourceReleasedListPSAck_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pathSwitchRequestUnsuccessfulTransfer_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PathSwitchRequestUnsuccessfulTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceReleasedItemPSFail_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pathSwitchRequestUnsuccessfulTransfer_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pathSwitchRequestUnsuccessfulTransfer_01 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceReleasedItemPSFail(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceReleasedItemPSFail, PDUSessionResourceReleasedItemPSFail_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceReleasedListPSFail_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceReleasedListPSFail_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceReleasedItemPSFail },
};

static int
dissect_ngap_PDUSessionResourceReleasedListPSFail(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceReleasedListPSFail, PDUSessionResourceReleasedListPSFail_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceReleaseResponseTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceReleaseResponseTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceReleasedItemRelRes_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionResourceReleaseResponseTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceReleaseResponseTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceReleasedItemRelRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceReleasedItemRelRes, PDUSessionResourceReleasedItemRelRes_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceReleasedListRelRes_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceReleasedListRelRes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceReleasedItemRelRes },
};

static int
dissect_ngap_PDUSessionResourceReleasedListRelRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceReleasedListRelRes, PDUSessionResourceReleasedListRelRes_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceReleaseResponseTransfer_sequence[] = {
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceReleaseResponseTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PDUSessionResourceReleaseResponseTransfer");

  ngap_get_private_data(actx->pinfo)->qos_flow_add_info_rel_type = 1;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceReleaseResponseTransfer, PDUSessionResourceReleaseResponseTransfer_sequence);

  ngap_get_private_data(actx->pinfo)->qos_flow_add_info_rel_type = -1;


  return offset;
}



static int
dissect_ngap_T_uEContextResumeRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_UEContextResumeRequestTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceResumeItemRESReq_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_uEContextResumeRequestTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_uEContextResumeRequestTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceResumeItemRESReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceResumeItemRESReq, PDUSessionResourceResumeItemRESReq_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceResumeListRESReq_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceResumeListRESReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceResumeItemRESReq },
};

static int
dissect_ngap_PDUSessionResourceResumeListRESReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceResumeListRESReq, PDUSessionResourceResumeListRESReq_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_uEContextResumeResponseTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_UEContextResumeResponseTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceResumeItemRESRes_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_uEContextResumeResponseTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_uEContextResumeResponseTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceResumeItemRESRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceResumeItemRESRes, PDUSessionResourceResumeItemRESRes_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceResumeListRESRes_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceResumeListRESRes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceResumeItemRESRes },
};

static int
dissect_ngap_PDUSessionResourceResumeListRESRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceResumeListRESRes, PDUSessionResourceResumeListRESRes_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_secondaryRATDataUsageReportTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_SecondaryRATDataUsageReportTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceSecondaryRATUsageItem_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_secondaryRATDataUsageReportTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_secondaryRATDataUsageReportTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceSecondaryRATUsageItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceSecondaryRATUsageItem, PDUSessionResourceSecondaryRATUsageItem_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSecondaryRATUsageList_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceSecondaryRATUsageList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceSecondaryRATUsageItem },
};

static int
dissect_ngap_PDUSessionResourceSecondaryRATUsageList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceSecondaryRATUsageList, PDUSessionResourceSecondaryRATUsageList_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceSetupRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceSetupRequestTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupItemCxtReq_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_nAS_PDU        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NAS_PDU },
  { &hf_ngap_s_NSSAI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_S_NSSAI },
  { &hf_ngap_pDUSessionResourceSetupRequestTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceSetupRequestTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceSetupItemCxtReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceSetupItemCxtReq, PDUSessionResourceSetupItemCxtReq_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupListCxtReq_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceSetupListCxtReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceSetupItemCxtReq },
};

static int
dissect_ngap_PDUSessionResourceSetupListCxtReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceSetupListCxtReq, PDUSessionResourceSetupListCxtReq_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceSetupResponseTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceSetupResponseTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupItemCxtRes_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionResourceSetupResponseTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceSetupResponseTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceSetupItemCxtRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceSetupItemCxtRes, PDUSessionResourceSetupItemCxtRes_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupListCxtRes_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceSetupListCxtRes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceSetupItemCxtRes },
};

static int
dissect_ngap_PDUSessionResourceSetupListCxtRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceSetupListCxtRes, PDUSessionResourceSetupListCxtRes_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_handoverRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceSetupRequestTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupItemHOReq_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_s_NSSAI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_S_NSSAI },
  { &hf_ngap_handoverRequestTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_handoverRequestTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceSetupItemHOReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceSetupItemHOReq, PDUSessionResourceSetupItemHOReq_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupListHOReq_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceSetupListHOReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceSetupItemHOReq },
};

static int
dissect_ngap_PDUSessionResourceSetupListHOReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceSetupListHOReq, PDUSessionResourceSetupListHOReq_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceSetupRequestTransfer_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceSetupRequestTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupItemSUReq_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionNAS_PDU, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_NAS_PDU },
  { &hf_ngap_s_NSSAI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_S_NSSAI },
  { &hf_ngap_pDUSessionResourceSetupRequestTransfer_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceSetupRequestTransfer_01 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceSetupItemSUReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceSetupItemSUReq, PDUSessionResourceSetupItemSUReq_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupListSUReq_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceSetupListSUReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceSetupItemSUReq },
};

static int
dissect_ngap_PDUSessionResourceSetupListSUReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceSetupListSUReq, PDUSessionResourceSetupListSUReq_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceSetupResponseTransfer_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceSetupResponseTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupItemSURes_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionResourceSetupResponseTransfer_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceSetupResponseTransfer_01 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceSetupItemSURes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceSetupItemSURes, PDUSessionResourceSetupItemSURes_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupListSURes_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceSetupListSURes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceSetupItemSURes },
};

static int
dissect_ngap_PDUSessionResourceSetupListSURes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceSetupListSURes, PDUSessionResourceSetupListSURes_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupRequestTransfer_sequence[] = {
  { &hf_ngap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceSetupRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PDUSessionResourceSetupRequestTransfer");

  volatile uint32_t _offset;

  _offset = offset;
  TRY {
    _offset = dissect_per_sequence(tvb, _offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceSetupRequestTransfer,
                                   PDUSessionResourceSetupRequestTransfer_sequence);
  }
  CATCH_BOUNDS_ERRORS {
    show_exception(tvb, actx->pinfo, tree, EXCEPT_CODE, GET_MESSAGE);
  }
  ENDTRY;
  offset = _offset;


  return offset;
}


static const per_sequence_t PDUSessionResourceSetupResponseTransfer_sequence[] = {
  { &hf_ngap_dLQosFlowPerTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowPerTNLInformation },
  { &hf_ngap_additionalDLQosFlowPerTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QosFlowPerTNLInformationList },
  { &hf_ngap_securityResult , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_SecurityResult },
  { &hf_ngap_qosFlowFailedToSetupList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QosFlowListWithCause },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceSetupResponseTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PDUSessionResourceSetupResponseTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceSetupResponseTransfer, PDUSessionResourceSetupResponseTransfer_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupUnsuccessfulTransfer_sequence[] = {
  { &hf_ngap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Cause },
  { &hf_ngap_criticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_CriticalityDiagnostics },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceSetupUnsuccessfulTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "PDUSessionResourceSetupUnsuccessfulTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceSetupUnsuccessfulTransfer, PDUSessionResourceSetupUnsuccessfulTransfer_sequence);

  return offset;
}



static int
dissect_ngap_T_uEContextSuspendRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_UEContextSuspendRequestTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceSuspendItemSUSReq_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_uEContextSuspendRequestTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_uEContextSuspendRequestTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceSuspendItemSUSReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceSuspendItemSUSReq, PDUSessionResourceSuspendItemSUSReq_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSuspendListSUSReq_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceSuspendListSUSReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceSuspendItemSUSReq },
};

static int
dissect_ngap_PDUSessionResourceSuspendListSUSReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceSuspendListSUSReq, PDUSessionResourceSuspendListSUSReq_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pathSwitchRequestAcknowledgeTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PathSwitchRequestAcknowledgeTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceSwitchedItem_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pathSwitchRequestAcknowledgeTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pathSwitchRequestAcknowledgeTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceSwitchedItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceSwitchedItem, PDUSessionResourceSwitchedItem_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSwitchedList_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceSwitchedList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceSwitchedItem },
};

static int
dissect_ngap_PDUSessionResourceSwitchedList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceSwitchedList, PDUSessionResourceSwitchedList_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pathSwitchRequestTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PathSwitchRequestTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceToBeSwitchedDLItem_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pathSwitchRequestTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pathSwitchRequestTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceToBeSwitchedDLItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceToBeSwitchedDLItem, PDUSessionResourceToBeSwitchedDLItem_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceToBeSwitchedDLList_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceToBeSwitchedDLList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceToBeSwitchedDLItem },
};

static int
dissect_ngap_PDUSessionResourceToBeSwitchedDLList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceToBeSwitchedDLList, PDUSessionResourceToBeSwitchedDLList_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_handoverPreparationUnsuccessfulTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_HandoverPreparationUnsuccessfulTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceToReleaseItemHOCmd_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_handoverPreparationUnsuccessfulTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_handoverPreparationUnsuccessfulTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceToReleaseItemHOCmd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceToReleaseItemHOCmd, PDUSessionResourceToReleaseItemHOCmd_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceToReleaseListHOCmd_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceToReleaseListHOCmd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceToReleaseItemHOCmd },
};

static int
dissect_ngap_PDUSessionResourceToReleaseListHOCmd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceToReleaseListHOCmd, PDUSessionResourceToReleaseListHOCmd_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}



static int
dissect_ngap_T_pDUSessionResourceReleaseCommandTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, false, dissect_PDUSessionResourceReleaseCommandTransfer_PDU);

  return offset;
}


static const per_sequence_t PDUSessionResourceToReleaseItemRelCmd_sequence[] = {
  { &hf_ngap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionID },
  { &hf_ngap_pDUSessionResourceReleaseCommandTransfer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_pDUSessionResourceReleaseCommandTransfer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionResourceToReleaseItemRelCmd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionResourceToReleaseItemRelCmd, PDUSessionResourceToReleaseItemRelCmd_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceToReleaseListRelCmd_sequence_of[1] = {
  { &hf_ngap_PDUSessionResourceToReleaseListRelCmd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PDUSessionResourceToReleaseItemRelCmd },
};

static int
dissect_ngap_PDUSessionResourceToReleaseListRelCmd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PDUSessionResourceToReleaseListRelCmd, PDUSessionResourceToReleaseListRelCmd_sequence_of,
                                                  1, maxnoofPDUSessions, false);

  return offset;
}


static const value_string ngap_PDUSessionType_vals[] = {
  {   0, "ipv4" },
  {   1, "ipv6" },
  {   2, "ipv4v6" },
  {   3, "ethernet" },
  {   4, "unstructured" },
  { 0, NULL }
};


static int
dissect_ngap_PDUSessionType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_rATType_vals[] = {
  {   0, "nr" },
  {   1, "eutra" },
  {   2, "nr-unlicensed" },
  {   3, "e-utra-unlicensed" },
  { 0, NULL }
};


static int
dissect_ngap_T_rATType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 2, NULL);

  return offset;
}



static int
dissect_ngap_T_startTimeStamp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *timestamp_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, false, &timestamp_tvb);



  if (timestamp_tvb) {
    proto_item_append_text(actx->created_item, " (%s)", tvb_ntp_fmt_ts_sec(timestamp_tvb, 0));
  }

  return offset;
}



static int
dissect_ngap_T_endTimeStamp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *timestamp_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, false, &timestamp_tvb);



  if (timestamp_tvb) {
    proto_item_append_text(actx->created_item, " (%s)", tvb_ntp_fmt_ts_sec(timestamp_tvb, 0));
  }

  return offset;
}



static int
dissect_ngap_INTEGER_0_18446744073709551615(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, UINT64_C(18446744073709551615), NULL, false);

  return offset;
}


static const per_sequence_t VolumeTimedReport_Item_sequence[] = {
  { &hf_ngap_startTimeStamp , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_startTimeStamp },
  { &hf_ngap_endTimeStamp   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_endTimeStamp },
  { &hf_ngap_usageCountUL   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_18446744073709551615 },
  { &hf_ngap_usageCountDL   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_0_18446744073709551615 },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_VolumeTimedReport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_VolumeTimedReport_Item, VolumeTimedReport_Item_sequence);

  return offset;
}


static const per_sequence_t VolumeTimedReportList_sequence_of[1] = {
  { &hf_ngap_VolumeTimedReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_VolumeTimedReport_Item },
};

static int
dissect_ngap_VolumeTimedReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_VolumeTimedReportList, VolumeTimedReportList_sequence_of,
                                                  1, maxnoofTimePeriods, false);

  return offset;
}


static const per_sequence_t PDUSessionUsageReport_sequence[] = {
  { &hf_ngap_rATType        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_rATType },
  { &hf_ngap_pDUSessionTimedReportList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_VolumeTimedReportList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUSessionUsageReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUSessionUsageReport, PDUSessionUsageReport_sequence);

  return offset;
}


static const value_string ngap_T_pduSetIntegratedHandlingInformation_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_ngap_T_pduSetIntegratedHandlingInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PDUsetQoSInformation_sequence[] = {
  { &hf_ngap_pduSetDelayBudget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ExtendedPacketDelayBudget },
  { &hf_ngap_pduSetErrorRate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PacketErrorRate },
  { &hf_ngap_pduSetIntegratedHandlingInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_pduSetIntegratedHandlingInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUsetQoSInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUsetQoSInformation, PDUsetQoSInformation_sequence);

  return offset;
}


static const per_sequence_t PDUsetQoSParameters_sequence[] = {
  { &hf_ngap_ulPDUSetQoSInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PDUsetQoSInformation },
  { &hf_ngap_dlPDUSetQoSInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PDUsetQoSInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PDUsetQoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PDUsetQoSParameters, PDUsetQoSParameters_sequence);

  return offset;
}


static const value_string ngap_PDUSetbasedHandlingIndicator_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_ngap_PDUSetbasedHandlingIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PEIPSassistanceInformation_sequence[] = {
  { &hf_ngap_cNsubgroupID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CNsubgroupID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PEIPSassistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PEIPSassistanceInformation, PEIPSassistanceInformation_sequence);

  return offset;
}



static int
dissect_ngap_Periodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 640000U, NULL, true);

  return offset;
}


static const per_sequence_t PeriodicityBound_sequence[] = {
  { &hf_ngap_periodicityLowerBound, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Periodicity },
  { &hf_ngap_periodicityUpperBound, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_Periodicity },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PeriodicityBound(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PeriodicityBound, PeriodicityBound_sequence);

  return offset;
}


static const per_sequence_t AllowedPeriodicityList_sequence_of[1] = {
  { &hf_ngap_AllowedPeriodicityList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_Periodicity },
};

static int
dissect_ngap_AllowedPeriodicityList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_AllowedPeriodicityList, AllowedPeriodicityList_sequence_of,
                                                  1, maxnoofPeriodicities, false);

  return offset;
}


static const value_string ngap_PeriodicityRange_vals[] = {
  {   0, "periodicityBound" },
  {   1, "periodicityList" },
  {   2, "choice-extensions" },
  { 0, NULL }
};

static const per_choice_t PeriodicityRange_choice[] = {
  {   0, &hf_ngap_periodicityBound, ASN1_NO_EXTENSIONS     , dissect_ngap_PeriodicityBound },
  {   1, &hf_ngap_periodicityList, ASN1_NO_EXTENSIONS     , dissect_ngap_AllowedPeriodicityList },
  {   2, &hf_ngap_choice_extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_PeriodicityRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_PeriodicityRange, PeriodicityRange_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PLMNSupportItem_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_sliceSupportList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SliceSupportList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PLMNSupportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PLMNSupportItem, PLMNSupportItem_sequence);

  return offset;
}


static const per_sequence_t PLMNSupportList_sequence_of[1] = {
  { &hf_ngap_PLMNSupportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNSupportItem },
};

static int
dissect_ngap_PLMNSupportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_PLMNSupportList, PLMNSupportList_sequence_of,
                                                  1, maxnoofPLMNs, false);

  return offset;
}


static const value_string ngap_PWSFailedCellIDList_vals[] = {
  {   0, "eUTRA-CGI-PWSFailedList" },
  {   1, "nR-CGI-PWSFailedList" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t PWSFailedCellIDList_choice[] = {
  {   0, &hf_ngap_eUTRA_CGI_PWSFailedList, ASN1_NO_EXTENSIONS     , dissect_ngap_EUTRA_CGIList },
  {   1, &hf_ngap_nR_CGI_PWSFailedList, ASN1_NO_EXTENSIONS     , dissect_ngap_NR_CGIList },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_PWSFailedCellIDList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_PWSFailedCellIDList, PWSFailedCellIDList_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PNI_NPN_AreaScopeofMDT_sequence[] = {
  { &hf_ngap_cAGListforMDT  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CAGListforMDT },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PNI_NPN_AreaScopeofMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PNI_NPN_AreaScopeofMDT, PNI_NPN_AreaScopeofMDT_sequence);

  return offset;
}


static const per_sequence_t PNI_NPNBasedMDT_sequence[] = {
  { &hf_ngap_cAGListforMDT  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_CAGListforMDT },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_PNI_NPNBasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_PNI_NPNBasedMDT, PNI_NPNBasedMDT_sequence);

  return offset;
}



static int
dissect_ngap_QoEReference(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       6, 6, false, NULL);

  return offset;
}


static const value_string ngap_ServiceType_vals[] = {
  {   0, "streaming" },
  {   1, "mTSI" },
  {   2, "vR" },
  { 0, NULL }
};


static int
dissect_ngap_ServiceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_qoEMeasurementStatus_vals[] = {
  {   0, "ongoing" },
  { 0, NULL }
};


static int
dissect_ngap_T_qoEMeasurementStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_ngap_OCTET_STRING_SIZE_1_8000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 8000, false, NULL);

  return offset;
}



static int
dissect_ngap_INTEGER_0_15_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, true);

  return offset;
}


static const per_sequence_t SliceSupportQMC_Item_sequence[] = {
  { &hf_ngap_s_NSSAI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_S_NSSAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SliceSupportQMC_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SliceSupportQMC_Item, SliceSupportQMC_Item_sequence);

  return offset;
}


static const per_sequence_t SliceSupportListQMC_sequence_of[1] = {
  { &hf_ngap_SliceSupportListQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_SliceSupportQMC_Item },
};

static int
dissect_ngap_SliceSupportListQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_SliceSupportListQMC, SliceSupportListQMC_sequence_of,
                                                  1, maxnoofSNSSAIforQMC, false);

  return offset;
}


static const per_sequence_t UEAppLayerMeasConfigInfo_sequence[] = {
  { &hf_ngap_qoEReference   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QoEReference },
  { &hf_ngap_serviceType    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ServiceType },
  { &hf_ngap_areaScopeOfQMC , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AreaScopeOfQMC },
  { &hf_ngap_measCollEntityIPAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TransportLayerAddress },
  { &hf_ngap_qoEMeasurementStatus, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_qoEMeasurementStatus },
  { &hf_ngap_containerForAppLayerMeasConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_OCTET_STRING_SIZE_1_8000 },
  { &hf_ngap_measConfigAppLayerID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_INTEGER_0_15_ },
  { &hf_ngap_sliceSupportListQMC, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_SliceSupportListQMC },
  { &hf_ngap_mDT_AlignmentInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_MDT_AlignmentInfo },
  { &hf_ngap_availableRANVisibleQoEMetrics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AvailableRANVisibleQoEMetrics },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_UEAppLayerMeasConfigInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_UEAppLayerMeasConfigInfo, UEAppLayerMeasConfigInfo_sequence);

  return offset;
}


static const per_sequence_t UEAppLayerMeasInfoItem_sequence[] = {
  { &hf_ngap_uEAppLayerMeasConfigInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UEAppLayerMeasConfigInfo },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_UEAppLayerMeasInfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_UEAppLayerMeasInfoItem, UEAppLayerMeasInfoItem_sequence);

  return offset;
}


static const per_sequence_t UEAppLayerMeasInfoList_sequence_of[1] = {
  { &hf_ngap_UEAppLayerMeasInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_UEAppLayerMeasInfoItem },
};

static int
dissect_ngap_UEAppLayerMeasInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_UEAppLayerMeasInfoList, UEAppLayerMeasInfoList_sequence_of,
                                                  1, maxnoofUEAppLayerMeas, false);

  return offset;
}


static const per_sequence_t QMCConfigInfo_sequence[] = {
  { &hf_ngap_uEAppLayerMeasInfoList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UEAppLayerMeasInfoList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QMCConfigInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QMCConfigInfo, QMCConfigInfo_sequence);

  return offset;
}


static const per_sequence_t QoEReferenceList_sequence_of[1] = {
  { &hf_ngap_QoEReferenceList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QoEReference },
};

static int
dissect_ngap_QoEReferenceList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QoEReferenceList, QoEReferenceList_sequence_of,
                                                  1, maxnoofUEAppLayerMeas, false);

  return offset;
}


static const per_sequence_t QMCDeactivation_sequence[] = {
  { &hf_ngap_qoEReferenceList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QoEReferenceList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QMCDeactivation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QMCDeactivation, QMCDeactivation_sequence);

  return offset;
}


static const value_string ngap_T_qoEReportingPath_vals[] = {
  {   0, "srb4" },
  {   1, "srb5" },
  { 0, NULL }
};


static int
dissect_ngap_T_qoEReportingPath(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_rVQoEReportingPath_vals[] = {
  {   0, "srb4" },
  {   1, "srb5" },
  { 0, NULL }
};


static int
dissect_ngap_T_rVQoEReportingPath(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t QoERVQoEReportingPaths_sequence[] = {
  { &hf_ngap_qoEReportingPath, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_qoEReportingPath },
  { &hf_ngap_rVQoEReportingPath, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_rVQoEReportingPath },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QoERVQoEReportingPaths(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QoERVQoEReportingPaths, QoERVQoEReportingPaths_sequence);

  return offset;
}



static int
dissect_ngap_TLContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}


static const per_sequence_t QosFlowAdditionalInfoItemRelCom_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_downlinkTLContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_TLContainer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowAdditionalInfoItemRelCom(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowAdditionalInfoItemRelCom, QosFlowAdditionalInfoItemRelCom_sequence);

  return offset;
}


static const per_sequence_t QosFlowAdditionalInfoListRelCom_sequence_of[1] = {
  { &hf_ngap_QosFlowAdditionalInfoListRelCom_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowAdditionalInfoItemRelCom },
};

static int
dissect_ngap_QosFlowAdditionalInfoListRelCom(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowAdditionalInfoListRelCom, QosFlowAdditionalInfoListRelCom_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const per_sequence_t QosFlowAdditionalInfoItemRelRes_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_uplinkTLContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_TLContainer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowAdditionalInfoItemRelRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowAdditionalInfoItemRelRes, QosFlowAdditionalInfoItemRelRes_sequence);

  return offset;
}


static const per_sequence_t QosFlowAdditionalInfoListRelRes_sequence_of[1] = {
  { &hf_ngap_QosFlowAdditionalInfoListRelRes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowAdditionalInfoItemRelRes },
};

static int
dissect_ngap_QosFlowAdditionalInfoListRelRes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowAdditionalInfoListRelRes, QosFlowAdditionalInfoListRelRes_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const per_sequence_t QosFlowAddOrModifyRequestItem_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_qosFlowLevelQosParameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QosFlowLevelQosParameters },
  { &hf_ngap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_E_RAB_ID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowAddOrModifyRequestItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowAddOrModifyRequestItem, QosFlowAddOrModifyRequestItem_sequence);

  return offset;
}


static const per_sequence_t QosFlowAddOrModifyRequestList_sequence_of[1] = {
  { &hf_ngap_QosFlowAddOrModifyRequestList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowAddOrModifyRequestItem },
};

static int
dissect_ngap_QosFlowAddOrModifyRequestList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowAddOrModifyRequestList, QosFlowAddOrModifyRequestList_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}



static int
dissect_ngap_UpdateFeedback(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, true, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_ngap_UpdateFeedback_CN_PDB_DL,
      &hf_ngap_UpdateFeedback_CN_PDB_UL,
      &hf_ngap_UpdateFeedback_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_UpdateFeedback);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t QosFlowFeedbackItem_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_updateFeedback , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_UpdateFeedback },
  { &hf_ngap_cNpacketDelayBudgetDL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ExtendedPacketDelayBudget },
  { &hf_ngap_cNpacketDelayBudgetUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ExtendedPacketDelayBudget },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowFeedbackItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowFeedbackItem, QosFlowFeedbackItem_sequence);

  return offset;
}


static const per_sequence_t QosFlowFeedbackList_sequence_of[1] = {
  { &hf_ngap_QosFlowFeedbackList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowFeedbackItem },
};

static int
dissect_ngap_QosFlowFeedbackList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowFeedbackList, QosFlowFeedbackList_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const value_string ngap_QosMonitoringRequest_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  {   2, "both" },
  {   3, "stop" },
  { 0, NULL }
};


static int
dissect_ngap_QosMonitoringRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 1, NULL);

  return offset;
}



static int
dissect_ngap_QosMonitoringReportingFrequency(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1800U, NULL, true);

  return offset;
}


static const per_sequence_t QosFlowParametersItem_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_alternativeQoSParaSetList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AlternativeQoSParaSetList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowParametersItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowParametersItem, QosFlowParametersItem_sequence);

  return offset;
}


static const per_sequence_t QosFlowParametersList_sequence_of[1] = {
  { &hf_ngap_QosFlowParametersList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowParametersItem },
};

static int
dissect_ngap_QosFlowParametersList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowParametersList, QosFlowParametersList_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const per_sequence_t QosFlowSetupRequestItem_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_qosFlowLevelQosParameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowLevelQosParameters },
  { &hf_ngap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_E_RAB_ID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QosFlowSetupRequestItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QosFlowSetupRequestItem, QosFlowSetupRequestItem_sequence);

  return offset;
}


static const per_sequence_t QosFlowSetupRequestList_sequence_of[1] = {
  { &hf_ngap_QosFlowSetupRequestList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowSetupRequestItem },
};

static int
dissect_ngap_QosFlowSetupRequestList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QosFlowSetupRequestList, QosFlowSetupRequestList_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}



static int
dissect_ngap_INTEGER_M640000_640000_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -640000, 640000U, NULL, true);

  return offset;
}


static const per_sequence_t TSCFeedbackInformation_sequence[] = {
  { &hf_ngap_burstArrivalTimeOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_INTEGER_M640000_640000_ },
  { &hf_ngap_adjustedPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_Periodicity },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TSCFeedbackInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TSCFeedbackInformation, TSCFeedbackInformation_sequence);

  return offset;
}


static const per_sequence_t TSCTrafficCharacteristicsFeedback_sequence[] = {
  { &hf_ngap_tSCFeedbackInformationDL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_TSCFeedbackInformation },
  { &hf_ngap_tSCFeedbackInformationUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_TSCFeedbackInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TSCTrafficCharacteristicsFeedback(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TSCTrafficCharacteristicsFeedback, TSCTrafficCharacteristicsFeedback_sequence);

  return offset;
}


static const per_sequence_t QoSFlowTSCItem_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_tSCTrafficCharacteristicsFeedback, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_TSCTrafficCharacteristicsFeedback },
  { &hf_ngap_aNPacketDelayBudgetUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ExtendedPacketDelayBudget },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QoSFlowTSCItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QoSFlowTSCItem, QoSFlowTSCItem_sequence);

  return offset;
}


static const per_sequence_t QoSFlowTSCList_sequence_of[1] = {
  { &hf_ngap_QoSFlowTSCList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QoSFlowTSCItem },
};

static int
dissect_ngap_QoSFlowTSCList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QoSFlowTSCList, QoSFlowTSCList_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const value_string ngap_T_rATType_01_vals[] = {
  {   0, "nr" },
  {   1, "eutra" },
  {   2, "nr-unlicensed" },
  {   3, "e-utra-unlicensed" },
  { 0, NULL }
};


static int
dissect_ngap_T_rATType_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 2, NULL);

  return offset;
}


static const per_sequence_t QoSFlowsUsageReport_Item_sequence[] = {
  { &hf_ngap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_QosFlowIdentifier },
  { &hf_ngap_rATType_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_rATType_01 },
  { &hf_ngap_qoSFlowsTimedReportList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_VolumeTimedReportList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_QoSFlowsUsageReport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_QoSFlowsUsageReport_Item, QoSFlowsUsageReport_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsUsageReportList_sequence_of[1] = {
  { &hf_ngap_QoSFlowsUsageReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_QoSFlowsUsageReport_Item },
};

static int
dissect_ngap_QoSFlowsUsageReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_QoSFlowsUsageReportList, QoSFlowsUsageReportList_sequence_of,
                                                  1, maxnoofQosFlows, false);

  return offset;
}


static const per_sequence_t RANfeedbacktype_proactive_sequence[] = {
  { &hf_ngap_burstArrivalTimeWindow, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BurstArrivalTimeWindow },
  { &hf_ngap_periodicityRange, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PeriodicityRange },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RANfeedbacktype_proactive(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RANfeedbacktype_proactive, RANfeedbacktype_proactive_sequence);

  return offset;
}


static const value_string ngap_T_capabilityForBATAdaptation_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_ngap_T_capabilityForBATAdaptation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t RANfeedbacktype_reactive_sequence[] = {
  { &hf_ngap_capabilityForBATAdaptation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_capabilityForBATAdaptation },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RANfeedbacktype_reactive(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RANfeedbacktype_reactive, RANfeedbacktype_reactive_sequence);

  return offset;
}


static const value_string ngap_RANfeedbacktype_vals[] = {
  {   0, "proactive" },
  {   1, "reactive" },
  {   2, "choice-extensions" },
  { 0, NULL }
};

static const per_choice_t RANfeedbacktype_choice[] = {
  {   0, &hf_ngap_proactive      , ASN1_NO_EXTENSIONS     , dissect_ngap_RANfeedbacktype_proactive },
  {   1, &hf_ngap_reactive       , ASN1_NO_EXTENSIONS     , dissect_ngap_RANfeedbacktype_reactive },
  {   2, &hf_ngap_choice_extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_RANfeedbacktype(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_RANfeedbacktype, RANfeedbacktype_choice,
                                 NULL);

  return offset;
}



static int
dissect_ngap_RANNodeName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_PrintableString(tvb, offset, actx, tree, hf_index,
                                          1, 150, true,
                                          NULL);

  return offset;
}



static int
dissect_ngap_RANPagingPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, false);

  return offset;
}


static const per_sequence_t RANStatusTransfer_TransparentContainer_sequence[] = {
  { &hf_ngap_dRBsSubjectToStatusTransferList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_DRBsSubjectToStatusTransferList },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RANStatusTransfer_TransparentContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "RANStatusTransfer-TransparentContainer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RANStatusTransfer_TransparentContainer, RANStatusTransfer_TransparentContainer_sequence);

  return offset;
}


static const value_string ngap_T_synchronisationState_vals[] = {
  {   0, "locked" },
  {   1, "holdover" },
  {   2, "freerun" },
  { 0, NULL }
};


static int
dissect_ngap_T_synchronisationState(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_traceabletoUTC_01_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_ngap_T_traceabletoUTC_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_T_traceabletoGNSS_01_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_ngap_T_traceabletoGNSS_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t RANTimingSynchronisationStatusInfo_sequence[] = {
  { &hf_ngap_synchronisationState_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_synchronisationState },
  { &hf_ngap_traceabletoUTC_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_traceabletoUTC_01 },
  { &hf_ngap_traceabletoGNSS_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_T_traceabletoGNSS_01 },
  { &hf_ngap_clockFrequencyStability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BIT_STRING_SIZE_16 },
  { &hf_ngap_clockAccuracy_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ClockAccuracy },
  { &hf_ngap_parentTImeSource_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ParentTImeSource },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RANTimingSynchronisationStatusInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RANTimingSynchronisationStatusInfo, RANTimingSynchronisationStatusInfo_sequence);

  return offset;
}


static const value_string ngap_RAN_TSSRequestType_vals[] = {
  {   0, "start" },
  {   1, "stop" },
  { 0, NULL }
};


static int
dissect_ngap_RAN_TSSRequestType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t RANTSSCellItem_sequence[] = {
  { &hf_ngap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NR_CGI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RANTSSCellItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RANTSSCellItem, RANTSSCellItem_sequence);

  return offset;
}


static const per_sequence_t RANTSSCellList_sequence_of[1] = {
  { &hf_ngap_RANTSSCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_RANTSSCellItem },
};

static int
dissect_ngap_RANTSSCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_RANTSSCellList, RANTSSCellList_sequence_of,
                                                  1, maxnoofCellsTSS, false);

  return offset;
}


static const value_string ngap_RAN_TSSScope_vals[] = {
  {   0, "rANNodeLevel" },
  {   1, "cellListLevel" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t RAN_TSSScope_choice[] = {
  {   0, &hf_ngap_rANNodeLevel   , ASN1_NO_EXTENSIONS     , dissect_ngap_GlobalGNB_ID },
  {   1, &hf_ngap_cellListLevel  , ASN1_NO_EXTENSIONS     , dissect_ngap_RANTSSCellList },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_RAN_TSSScope(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_RAN_TSSScope, RAN_TSSScope_choice,
                                 NULL);

  return offset;
}



static int
dissect_ngap_RAN_UE_NGAP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  uint32_t ran_ue_ngap_id;
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, &ran_ue_ngap_id, false);

  ngap_data->ran_ue_ngap_id = ran_ue_ngap_id;


  return offset;
}


static const value_string ngap_RAT_Information_vals[] = {
  { unlicensed, "unlicensed" },
  { nb_IoT, "nb-IoT" },
  { nR_LEO, "nR-LEO" },
  { nR_MEO, "nR-MEO" },
  { nR_GEO, "nR-GEO" },
  { nR_OTHERSAT, "nR-OTHERSAT" },
  { 0, NULL }
};


static int
dissect_ngap_RAT_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  uint32_t rat_info = 0xffffffff;
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, &rat_info, true, 4, NULL);

  if (ngap_data->ngap_conv && ngap_data->supported_ta && (rat_info == nb_IoT)) {
    uint64_t *key;
    unsigned i;

    for (i = 0; i < wmem_array_get_count(ngap_data->supported_ta->plmn); i++) {
      key = wmem_new(wmem_file_scope(), uint64_t);
      *key = ((*(uint32_t*)wmem_array_index(ngap_data->supported_ta->plmn, i)) << 24) | ngap_data->supported_ta->tac;
      wmem_map_insert(ngap_data->ngap_conv->nbiot_ta, key, GUINT_TO_POINTER(1));
    }
  }


  return offset;
}


static const value_string ngap_RedCapIndication_vals[] = {
  {   0, "redcap" },
  { 0, NULL }
};


static int
dissect_ngap_RedCapIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_RedirectionVoiceFallback_vals[] = {
  {   0, "possible" },
  {   1, "not-possible" },
  { 0, NULL }
};


static int
dissect_ngap_RedirectionVoiceFallback(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_RSN_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  { 0, NULL }
};


static int
dissect_ngap_RSN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t RedundantPDUSessionInformation_sequence[] = {
  { &hf_ngap_rSN            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_RSN },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RedundantPDUSessionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RedundantPDUSessionInformation, RedundantPDUSessionInformation_sequence);

  return offset;
}


static const value_string ngap_RedundantQosFlowIndicator_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_ngap_RedundantQosFlowIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_ngap_RelativeAMFCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static int
dissect_ngap_RepetitionPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 131071U, NULL, false);

  return offset;
}


static const value_string ngap_ResetAll_vals[] = {
  {   0, "reset-all" },
  { 0, NULL }
};


static int
dissect_ngap_ResetAll(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_ExtendedReportIntervalMDT_vals[] = {
  {   0, "ms20480" },
  {   1, "ms40960" },
  { 0, NULL }
};


static int
dissect_ngap_ExtendedReportIntervalMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t UE_associatedLogicalNG_connectionItem_sequence[] = {
  { &hf_ngap_aMF_UE_NGAP_ID , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AMF_UE_NGAP_ID },
  { &hf_ngap_rAN_UE_NGAP_ID , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_RAN_UE_NGAP_ID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_UE_associatedLogicalNG_connectionItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_UE_associatedLogicalNG_connectionItem, UE_associatedLogicalNG_connectionItem_sequence);

  return offset;
}


static const per_sequence_t UE_associatedLogicalNG_connectionList_sequence_of[1] = {
  { &hf_ngap_UE_associatedLogicalNG_connectionList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_UE_associatedLogicalNG_connectionItem },
};

static int
dissect_ngap_UE_associatedLogicalNG_connectionList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_UE_associatedLogicalNG_connectionList, UE_associatedLogicalNG_connectionList_sequence_of,
                                                  1, maxnoofNGConnectionsToReset, false);

  return offset;
}


static const value_string ngap_ResetType_vals[] = {
  {   0, "nG-Interface" },
  {   1, "partOfNG-Interface" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t ResetType_choice[] = {
  {   0, &hf_ngap_nG_Interface   , ASN1_NO_EXTENSIONS     , dissect_ngap_ResetAll },
  {   1, &hf_ngap_partOfNG_Interface, ASN1_NO_EXTENSIONS     , dissect_ngap_UE_associatedLogicalNG_connectionList },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_ResetType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_ResetType, ResetType_choice,
                                 NULL);

  return offset;
}



static int
dissect_ngap_RGLevelWirelineAccessCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}



static int
dissect_ngap_RNC_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, false);

  return offset;
}



static int
dissect_ngap_RoutingID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}



static int
dissect_ngap_RRCContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);
    proto_tree *subtree;
    GlobalRANNodeID_enum ranmode_id;

    if (ngap_data->transparent_container_type == SOURCE_TO_TARGET_TRANSPARENT_CONTAINER ||
        ngap_data->transparent_container_type == TARGET_TO_SOURCE_TRANSPARENT_CONTAINER) {
      if (value_is_in_range(gbl_ngapSctpRange, actx->pinfo->destport))
        ranmode_id = ngap_get_ranmode_id(&actx->pinfo->src, actx->pinfo->srcport, actx->pinfo);
      else
        ranmode_id = ngap_get_ranmode_id(&actx->pinfo->dst, actx->pinfo->destport, actx->pinfo);
    } else {
      ranmode_id = (GlobalRANNodeID_enum)-1;
    }
    subtree = proto_item_add_subtree(actx->created_item, ett_ngap_RRCContainer);
    if ((ngap_dissect_target_ng_ran_container_as == NGAP_NG_RAN_CONTAINER_AUTOMATIC &&
         ranmode_id == globalGNB_ID) ||
        (ngap_dissect_target_ng_ran_container_as == NGAP_NG_RAN_CONTAINER_GNB)) {
      if (ngap_data->transparent_container_type == SOURCE_TO_TARGET_TRANSPARENT_CONTAINER) {
        dissect_nr_rrc_HandoverPreparationInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
      } else if (ngap_data->transparent_container_type == TARGET_TO_SOURCE_TRANSPARENT_CONTAINER) {
        dissect_nr_rrc_HandoverCommand_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
      }
    } else if ((ngap_dissect_target_ng_ran_container_as == NGAP_NG_RAN_CONTAINER_AUTOMATIC &&
                ranmode_id == globalNgENB_ID) ||
               (ngap_dissect_target_ng_ran_container_as == NGAP_NG_RAN_CONTAINER_NG_ENB)) {
      if (ngap_data->transparent_container_type == SOURCE_TO_TARGET_TRANSPARENT_CONTAINER) {
        dissect_lte_rrc_HandoverPreparationInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
      } else if (ngap_data->transparent_container_type == TARGET_TO_SOURCE_TRANSPARENT_CONTAINER) {
        dissect_lte_rrc_HandoverCommand_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
      }
    }
  }


  return offset;
}


static const value_string ngap_RRCEstablishmentCause_vals[] = {
  {   0, "emergency" },
  {   1, "highPriorityAccess" },
  {   2, "mt-Access" },
  {   3, "mo-Signalling" },
  {   4, "mo-Data" },
  {   5, "mo-VoiceCall" },
  {   6, "mo-VideoCall" },
  {   7, "mo-SMS" },
  {   8, "mps-PriorityAccess" },
  {   9, "mcs-PriorityAccess" },
  {  10, "notAvailable" },
  {  11, "mo-ExceptionData" },
  { 0, NULL }
};


static int
dissect_ngap_RRCEstablishmentCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  uint32_t value;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, &value, true, 2, NULL);

  col_append_fstr(actx->pinfo->cinfo, COL_INFO, " [RRCEstablishmentCause=%s]", val_to_str_const(value, ngap_RRCEstablishmentCause_vals, "Unknown"));


  return offset;
}


static const value_string ngap_RRCInactiveTransitionReportRequest_vals[] = {
  {   0, "subsequent-state-transition-report" },
  {   1, "single-rrc-connected-state-report" },
  {   2, "cancel-report" },
  { 0, NULL }
};


static int
dissect_ngap_RRCInactiveTransitionReportRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string ngap_RRCState_vals[] = {
  {   0, "inactive" },
  {   1, "connected" },
  { 0, NULL }
};


static int
dissect_ngap_RRCState(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t TargetRANNodeID_RIM_sequence[] = {
  { &hf_ngap_globalRANNodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_GlobalRANNodeID },
  { &hf_ngap_selectedTAI    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TargetRANNodeID_RIM(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TargetRANNodeID_RIM, TargetRANNodeID_RIM_sequence);

  return offset;
}


static const per_sequence_t SourceRANNodeID_sequence[] = {
  { &hf_ngap_globalRANNodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_GlobalRANNodeID },
  { &hf_ngap_selectedTAI    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SourceRANNodeID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SourceRANNodeID, SourceRANNodeID_sequence);

  return offset;
}



static int
dissect_ngap_GNBSetID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     22, 22, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string ngap_T_rIM_RSDetection_vals[] = {
  {   0, "rs-detected" },
  {   1, "rs-disappeared" },
  { 0, NULL }
};


static int
dissect_ngap_T_rIM_RSDetection(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t RIMInformation_sequence[] = {
  { &hf_ngap_targetgNBSetID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_GNBSetID },
  { &hf_ngap_rIM_RSDetection, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_rIM_RSDetection },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RIMInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RIMInformation, RIMInformation_sequence);

  return offset;
}


static const per_sequence_t RIMInformationTransfer_sequence[] = {
  { &hf_ngap_targetRANNodeID_RIM, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TargetRANNodeID_RIM },
  { &hf_ngap_sourceRANNodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SourceRANNodeID },
  { &hf_ngap_rIMInformation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_RIMInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RIMInformationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RIMInformationTransfer, RIMInformationTransfer_sequence);

  return offset;
}


static const per_sequence_t RSPPFlowBitRates_sequence[] = {
  { &hf_ngap_guaranteedFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_maximumFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_BitRate },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RSPPFlowBitRates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RSPPFlowBitRates, RSPPFlowBitRates_sequence);

  return offset;
}


static const per_sequence_t RSPPQoSFlowItem_sequence[] = {
  { &hf_ngap_pQI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_FiveQI },
  { &hf_ngap_rSPPFlowBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_RSPPFlowBitRates },
  { &hf_ngap_range          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_Range },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_RSPPQoSFlowItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_RSPPQoSFlowItem, RSPPQoSFlowItem_sequence);

  return offset;
}


static const per_sequence_t RSPPQoSFlowList_sequence_of[1] = {
  { &hf_ngap_RSPPQoSFlowList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_RSPPQoSFlowItem },
};

static int
dissect_ngap_RSPPQoSFlowList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_RSPPQoSFlowList, RSPPQoSFlowList_sequence_of,
                                                  1, maxnoofRSPPQoSFlows, false);

  return offset;
}



static int
dissect_ngap_BIT_STRING_SIZE_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     7, 7, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_ngap_INTEGER_0_86399_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 86399U, NULL, true);

  return offset;
}


static const per_sequence_t ScheduledCommunicationTime_sequence[] = {
  { &hf_ngap_dayofWeek      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_BIT_STRING_SIZE_7 },
  { &hf_ngap_timeofDayStart , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_INTEGER_0_86399_ },
  { &hf_ngap_timeofDayEnd   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_INTEGER_0_86399_ },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ScheduledCommunicationTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ScheduledCommunicationTime, ScheduledCommunicationTime_sequence);

  return offset;
}


static const per_sequence_t SCTP_TLAs_sequence_of[1] = {
  { &hf_ngap_SCTP_TLAs_item , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TransportLayerAddress },
};

static int
dissect_ngap_SCTP_TLAs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_SCTP_TLAs, SCTP_TLAs_sequence_of,
                                                  1, maxnoofXnTLAs, false);

  return offset;
}


static const per_sequence_t SecondaryRATUsageInformation_sequence[] = {
  { &hf_ngap_pDUSessionUsageReport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PDUSessionUsageReport },
  { &hf_ngap_qosFlowsUsageReportList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_QoSFlowsUsageReportList },
  { &hf_ngap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SecondaryRATUsageInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SecondaryRATUsageInformation, SecondaryRATUsageInformation_sequence);

  return offset;
}


static const per_sequence_t SecondaryRATDataUsageReportTransfer_sequence[] = {
  { &hf_ngap_secondaryRATUsageInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_SecondaryRATUsageInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

int
dissect_ngap_SecondaryRATDataUsageReportTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SecondaryRATDataUsageReportTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SecondaryRATDataUsageReportTransfer, SecondaryRATDataUsageReportTransfer_sequence);

  return offset;
}



static int
dissect_ngap_SecurityKey(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     256, 256, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t SecurityContext_sequence[] = {
  { &hf_ngap_nextHopChainingCount, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NextHopChainingCount },
  { &hf_ngap_nextHopNH      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SecurityKey },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SecurityContext(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SecurityContext, SecurityContext_sequence);

  return offset;
}



static int
dissect_ngap_SerialNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_SerialNumber);
    proto_tree_add_item(subtree, hf_ngap_SerialNumber_gs, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
    proto_tree_add_item(subtree, hf_ngap_SerialNumber_msg_code, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
    proto_tree_add_item(subtree, hf_ngap_SerialNumber_upd_nb, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t ServedGUAMIItem_sequence[] = {
  { &hf_ngap_gUAMI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_GUAMI },
  { &hf_ngap_backupAMFName  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_AMFName },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_ServedGUAMIItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_ServedGUAMIItem, ServedGUAMIItem_sequence);

  return offset;
}


static const per_sequence_t ServedGUAMIList_sequence_of[1] = {
  { &hf_ngap_ServedGUAMIList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_ServedGUAMIItem },
};

static int
dissect_ngap_ServedGUAMIList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_ServedGUAMIList, ServedGUAMIList_sequence_of,
                                                  1, maxnoofServedGUAMIs, false);

  return offset;
}



static int
dissect_ngap_SgNB_UE_X2AP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, false);

  return offset;
}


static const per_sequence_t TargetRANNodeID_SON_sequence[] = {
  { &hf_ngap_globalRANNodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_GlobalRANNodeID },
  { &hf_ngap_selectedTAI    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_TargetRANNodeID_SON(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_TargetRANNodeID_SON, TargetRANNodeID_SON_sequence);

  return offset;
}


static const value_string ngap_SONInformationRequest_vals[] = {
  {   0, "xn-TNL-configuration-info" },
  { 0, NULL }
};


static int
dissect_ngap_SONInformationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t XnTLAs_sequence_of[1] = {
  { &hf_ngap_XnTLAs_item    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TransportLayerAddress },
};

static int
dissect_ngap_XnTLAs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_XnTLAs, XnTLAs_sequence_of,
                                                  1, maxnoofXnTLAs, false);

  return offset;
}


static const per_sequence_t XnGTP_TLAs_sequence_of[1] = {
  { &hf_ngap_XnGTP_TLAs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_TransportLayerAddress },
};

static int
dissect_ngap_XnGTP_TLAs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_XnGTP_TLAs, XnGTP_TLAs_sequence_of,
                                                  1, maxnoofXnGTP_TLAs, false);

  return offset;
}


static const per_sequence_t XnExtTLA_Item_sequence[] = {
  { &hf_ngap_iPsecTLA       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_TransportLayerAddress },
  { &hf_ngap_gTP_TLAs       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_XnGTP_TLAs },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_XnExtTLA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_XnExtTLA_Item, XnExtTLA_Item_sequence);

  return offset;
}


static const per_sequence_t XnExtTLAs_sequence_of[1] = {
  { &hf_ngap_XnExtTLAs_item , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_XnExtTLA_Item },
};

static int
dissect_ngap_XnExtTLAs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_XnExtTLAs, XnExtTLAs_sequence_of,
                                                  1, maxnoofXnExtTLAs, false);

  return offset;
}


static const per_sequence_t XnTNLConfigurationInfo_sequence[] = {
  { &hf_ngap_xnTransportLayerAddresses, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_XnTLAs },
  { &hf_ngap_xnExtendedTransportLayerAddresses, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_XnExtTLAs },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_XnTNLConfigurationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_XnTNLConfigurationInfo, XnTNLConfigurationInfo_sequence);

  return offset;
}


static const per_sequence_t SONInformationReply_sequence[] = {
  { &hf_ngap_xnTNLConfigurationInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_XnTNLConfigurationInfo },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SONInformationReply(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SONInformationReply, SONInformationReply_sequence);

  return offset;
}


static const value_string ngap_SONInformation_vals[] = {
  {   0, "sONInformationRequest" },
  {   1, "sONInformationReply" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t SONInformation_choice[] = {
  {   0, &hf_ngap_sONInformationRequest, ASN1_NO_EXTENSIONS     , dissect_ngap_SONInformationRequest },
  {   1, &hf_ngap_sONInformationReply, ASN1_NO_EXTENSIONS     , dissect_ngap_SONInformationReply },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_SONInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_SONInformation, SONInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SONConfigurationTransfer_sequence[] = {
  { &hf_ngap_targetRANNodeID_SON, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TargetRANNodeID_SON },
  { &hf_ngap_sourceRANNodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SourceRANNodeID },
  { &hf_ngap_sONInformation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SONInformation },
  { &hf_ngap_xnTNLConfigurationInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_XnTNLConfigurationInfo },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SONConfigurationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SONConfigurationTransfer");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SONConfigurationTransfer, SONConfigurationTransfer_sequence);

  return offset;
}


static const value_string ngap_SONInformationReport_vals[] = {
  {   0, "failureIndicationInformation" },
  {   1, "hOReportInformation" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t SONInformationReport_choice[] = {
  {   0, &hf_ngap_failureIndicationInformation_01, ASN1_NO_EXTENSIONS     , dissect_ngap_FailureIndication },
  {   1, &hf_ngap_hOReportInformation_01, ASN1_NO_EXTENSIONS     , dissect_ngap_HOReport },
  {   2, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_SONInformationReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_SONInformationReport, SONInformationReport_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SNPNCellIdListforMDTItem_sequence[] = {
  { &hf_ngap_nR_CGI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NR_CGI },
  { &hf_ngap_nID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SNPNCellIdListforMDTItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SNPNCellIdListforMDTItem, SNPNCellIdListforMDTItem_sequence);

  return offset;
}


static const per_sequence_t SNPNCellIdListforMDT_sequence_of[1] = {
  { &hf_ngap_SNPNCellIdListforMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_SNPNCellIdListforMDTItem },
};

static int
dissect_ngap_SNPNCellIdListforMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_SNPNCellIdListforMDT, SNPNCellIdListforMDT_sequence_of,
                                                  1, maxnoofCellIDforMDT, false);

  return offset;
}


static const per_sequence_t SNPN_CellBasedMDT_sequence[] = {
  { &hf_ngap_sNPNcellIdListforMDT, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SNPNCellIdListforMDT },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SNPN_CellBasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SNPN_CellBasedMDT, SNPN_CellBasedMDT_sequence);

  return offset;
}


static const per_sequence_t SNPNTAIListforMDTItem_sequence[] = {
  { &hf_ngap_tAI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_TAI },
  { &hf_ngap_nID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SNPNTAIListforMDTItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SNPNTAIListforMDTItem, SNPNTAIListforMDTItem_sequence);

  return offset;
}


static const per_sequence_t SNPNTAIListforMDT_sequence_of[1] = {
  { &hf_ngap_SNPNTAIListforMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_SNPNTAIListforMDTItem },
};

static int
dissect_ngap_SNPNTAIListforMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_SNPNTAIListforMDT, SNPNTAIListforMDT_sequence_of,
                                                  1, maxnoofTAforMDT, false);

  return offset;
}


static const per_sequence_t SNPN_TAIBasedMDT_sequence[] = {
  { &hf_ngap_sNPNTAIListforMDT, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SNPNTAIListforMDT },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SNPN_TAIBasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SNPN_TAIBasedMDT, SNPN_TAIBasedMDT_sequence);

  return offset;
}


static const per_sequence_t SNPNListforMDTItem_sequence[] = {
  { &hf_ngap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_PLMNIdentity },
  { &hf_ngap_nID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NID },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SNPNListforMDTItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SNPNListforMDTItem, SNPNListforMDTItem_sequence);

  return offset;
}


static const per_sequence_t SNPNListforMDT_sequence_of[1] = {
  { &hf_ngap_SNPNListforMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_SNPNListforMDTItem },
};

static int
dissect_ngap_SNPNListforMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_SNPNListforMDT, SNPNListforMDT_sequence_of,
                                                  1, maxnoofMDTSNPNs, false);

  return offset;
}


static const per_sequence_t SNPN_BasedMDT_sequence[] = {
  { &hf_ngap_sNPNListforMDT , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_SNPNListforMDT },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SNPN_BasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SNPN_BasedMDT, SNPN_BasedMDT_sequence);

  return offset;
}



static int
dissect_ngap_T_successfulHOReportContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_successfulHOReportContainer);
    dissect_nr_rrc_SuccessHO_Report_r17_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t SuccessfulHandoverReport_Item_sequence[] = {
  { &hf_ngap_successfulHOReportContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_successfulHOReportContainer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SuccessfulHandoverReport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SuccessfulHandoverReport_Item, SuccessfulHandoverReport_Item_sequence);

  return offset;
}


static const per_sequence_t SuccessfulHandoverReportList_sequence_of[1] = {
  { &hf_ngap_SuccessfulHandoverReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_SuccessfulHandoverReport_Item },
};

static int
dissect_ngap_SuccessfulHandoverReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_SuccessfulHandoverReportList, SuccessfulHandoverReportList_sequence_of,
                                                  1, maxnoofSuccessfulHOReports, false);

  return offset;
}



static int
dissect_ngap_T_successfulPSCellChangeReportContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_ngap_successfulPSCellChangeReportContainer);
    dissect_nr_rrc_SuccessPSCell_Report_r18_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t SuccessfulPSCellChangeReport_Item_sequence[] = {
  { &hf_ngap_successfulPSCellChangeReportContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_T_successfulPSCellChangeReportContainer },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SuccessfulPSCellChangeReport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SuccessfulPSCellChangeReport_Item, SuccessfulPSCellChangeReport_Item_sequence);

  return offset;
}


static const per_sequence_t SuccessfulPSCellChangeReportList_sequence_of[1] = {
  { &hf_ngap_SuccessfulPSCellChangeReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_SuccessfulPSCellChangeReport_Item },
};

static int
dissect_ngap_SuccessfulPSCellChangeReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_SuccessfulPSCellChangeReportList, SuccessfulPSCellChangeReportList_sequence_of,
                                                  1, maxnoofSuccessfulPSCellChangeReports, false);

  return offset;
}


static const per_sequence_t UEHistoryInformation_sequence_of[1] = {
  { &hf_ngap_UEHistoryInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ngap_LastVisitedCellItem },
};

static int
dissect_ngap_UEHistoryInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ngap_UEHistoryInformation, UEHistoryInformation_sequence_of,
                                                  1, maxnoofCellsinUEHistoryInfo, false);

  return offset;
}


static const per_sequence_t SourceNGRANNode_ToTargetNGRANNode_TransparentContainer_sequence[] = {
  { &hf_ngap_rRCContainer   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_RRCContainer },
  { &hf_ngap_pDUSessionResourceInformationList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_PDUSessionResourceInformationList },
  { &hf_ngap_e_RABInformationList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_E_RABInformationList },
  { &hf_ngap_targetCell_ID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_NGRAN_CGI },
  { &hf_ngap_indexToRFSP    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_IndexToRFSP },
  { &hf_ngap_uEHistoryInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ngap_UEHistoryInformation },
  { &hf_ngap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ngap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_ngap_SourceNGRANNode_ToTargetNGRANNode_TransparentContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct ngap_private_data *ngap_data = ngap_get_private_data(actx->pinfo);

  ngap_data->transparent_container_type = SOURCE_TO_TARGET_TRANSPARENT_CONTAINER;


  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ngap_SourceNGRANNode_ToTargetNGRANNode_TransparentContainer, SourceNGRANNode_ToTargetNGRANNode_TransparentContainer_sequence);

  return offset;
}


static const value_string ngap_SourceNodeID_vals[] = {
  {   0, "sourceengNB-ID" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t SourceNodeID_choice[] = {
  {   0, &hf_ngap_sourceengNB_ID , ASN1_NO_EXTENSIONS     , dissect_ngap_GlobalGNB_ID },
  {   1, &hf_ngap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_ngap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_ngap_SourceNodeID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ngap_SourceNodeID, SourceNodeID_choice,
                                 NULL);

  return offset;
}



static int
dissect_ngap_SourceToTarget_TransparentContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t* json_tvb = (tvbuff_t*)p_get_proto_data(actx->pinfo->pool, actx->pinfo, proto_json, 0);
  if (json_tvb)
    col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "SourceToTarget-TransparentContainer");

  tvbuff_t *parameter_tvb;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (ngap_dissect_container && parameter_tvb &&
      tvb_reported_length(parameter_tvb) > 0) {
    uint32_t handover_type = ngap_get_private_data(actx->pinfo)->handover_type_value;
    /* Don't want elements inside container to write to info column */
    col_set_writable(actx->pinfo->cinfo, COL_INFO, false);
    subtree = proto_item_add_subtree(actx->created_item, ett_ngap_SourceToTarget_TransparentContainer);
    TRY {
        switch(handover_type) {
        case intra5gs:
        case eps_to_5gs:
            dissect_ngap_SourceNGRANNode_ToTargetNGRANNode_TransparentContainer_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
            break;
        case fivegs_to_eps:
            dissect_s1ap_SourceeNB_ToTargeteNB_TransparentContainer_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
            break;
        case fivegs_to_utran:
            dissect_rrc_ToTargetRNC_Container_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
            break;
        default:
            break;
        }
    }
    CATCH_BOUNDS_ERRORS {
          show_exception(tvb, actx->pinfo, tree, EXCEPT_CODE, GET_MESSAGE);
    }
    ENDTRY;

    /* Enable writing of the column again */
    col_set_writable(actx->pinfo->cinfo, COL_INFO, true);
  }


  return offset;
}



static int
dissect_ngap_ConfiguredNSSAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       128, 128, false, NULL);

  return offset;
}



static int
dissect_ngap_RejectedNSSAIinPLMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       32, 32, false, NULL);

  return offset;
}



static int
dissect_ngap_RejectedNSSAIinTA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_)