/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;

abstract class AbstractPollSelectorImpl
extends SelectorImpl {
    PollArrayWrapper pollWrapper;
    protected final int INIT_CAP = 10;
    protected SelectionKeyImpl[] channelArray;
    protected int channelOffset = 0;
    protected int totalChannels;
    private boolean closed = false;
    private Object closeLock = new Object();

    AbstractPollSelectorImpl(SelectorProvider selectorProvider, int n, int n2) {
        super(selectorProvider);
        this.totalChannels = n;
        this.channelOffset = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                throw new ClosedSelectorException();
            }
            this.pollWrapper.putEventOps(selectionKeyImpl.getIndex(), n);
        }
    }

    @Override
    public Selector wakeup() {
        this.pollWrapper.interrupt();
        return this;
    }

    @Override
    protected abstract int doSelect(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implClose() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (int i = this.channelOffset; i < this.totalChannels; ++i) {
                SelectionKeyImpl selectionKeyImpl = this.channelArray[i];
                assert (selectionKeyImpl.getIndex() != -1);
                selectionKeyImpl.setIndex(-1);
                this.deregister(selectionKeyImpl);
                SelectableChannel selectableChannel = this.channelArray[i].channel();
                if (selectableChannel.isOpen() || selectableChannel.isRegistered()) continue;
                ((SelChImpl)((Object)selectableChannel)).kill();
            }
            this.implCloseInterrupt();
            this.pollWrapper.free();
            this.pollWrapper = null;
            this.selectedKeys = null;
            this.channelArray = null;
            this.totalChannels = 0;
        }
    }

    protected abstract void implCloseInterrupt() throws IOException;

    protected int updateSelectedKeys() {
        int n = 0;
        for (int i = this.channelOffset; i < this.totalChannels; ++i) {
            int n2 = this.pollWrapper.getReventOps(i);
            if (n2 == 0) continue;
            SelectionKeyImpl selectionKeyImpl = this.channelArray[i];
            this.pollWrapper.putReventOps(i, 0);
            if (this.selectedKeys.contains(selectionKeyImpl)) {
                if (!selectionKeyImpl.channel.translateAndSetReadyOps(n2, selectionKeyImpl)) continue;
                ++n;
                continue;
            }
            selectionKeyImpl.channel.translateAndSetReadyOps(n2, selectionKeyImpl);
            if ((selectionKeyImpl.nioReadyOps() & selectionKeyImpl.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(selectionKeyImpl);
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                throw new ClosedSelectorException();
            }
            if (this.channelArray.length == this.totalChannels) {
                int n = this.pollWrapper.totalChannels * 2;
                SelectionKeyImpl[] selectionKeyImplArray = new SelectionKeyImpl[n];
                for (int i = this.channelOffset; i < this.totalChannels; ++i) {
                    selectionKeyImplArray[i] = this.channelArray[i];
                }
                this.channelArray = selectionKeyImplArray;
                this.pollWrapper.grow(n);
            }
            this.channelArray[this.totalChannels] = selectionKeyImpl;
            selectionKeyImpl.setIndex(this.totalChannels);
            this.pollWrapper.addEntry(selectionKeyImpl.channel);
            ++this.totalChannels;
            this.keys.add(selectionKeyImpl);
        }
    }

    @Override
    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        Object object;
        int n = selectionKeyImpl.getIndex();
        assert (n >= 0);
        if (n != this.totalChannels - 1) {
            object = this.channelArray[this.totalChannels - 1];
            this.channelArray[n] = object;
            ((SelectionKeyImpl)object).setIndex(n);
            this.pollWrapper.release(n);
            PollArrayWrapper.replaceEntry(this.pollWrapper, this.totalChannels - 1, this.pollWrapper, n);
        } else {
            this.pollWrapper.release(n);
        }
        this.channelArray[this.totalChannels - 1] = null;
        --this.totalChannels;
        --this.pollWrapper.totalChannels;
        selectionKeyImpl.setIndex(-1);
        this.keys.remove(selectionKeyImpl);
        this.selectedKeys.remove(selectionKeyImpl);
        this.deregister(selectionKeyImpl);
        object = selectionKeyImpl.channel();
        if (!((AbstractInterruptibleChannel)object).isOpen() && !((SelectableChannel)object).isRegistered()) {
            ((SelChImpl)object).kill();
        }
    }
}

