/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.CStringUtilities;

public class Arguments {
    private static AddressField jvmFlagsField;
    private static AddressField jvmArgsField;
    private static AddressField javaCommandField;
    private static long jvmFlagsCount;
    private static long jvmArgsCount;

    public static String getJVMFlags() {
        return Arguments.buildString(jvmFlagsField, jvmFlagsCount);
    }

    public static String getJVMArgs() {
        return Arguments.buildString(jvmArgsField, jvmArgsCount);
    }

    public static String getJavaCommand() {
        return Arguments.getString(javaCommandField);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type argumentsType = db.lookupType("Arguments");
        jvmFlagsField = argumentsType.getAddressField("_jvm_flags_array");
        jvmArgsField = argumentsType.getAddressField("_jvm_args_array");
        javaCommandField = argumentsType.getAddressField("_java_command");
        jvmArgsCount = argumentsType.getCIntegerField("_num_jvm_args").getValue();
        jvmFlagsCount = argumentsType.getCIntegerField("_num_jvm_flags").getValue();
    }

    private static String buildString(AddressField arrayField, long count) {
        StringBuilder sb = new StringBuilder();
        if (count > 0L) {
            sb.append(Arguments.getStringAt(arrayField, 0L));
            for (long i = 1L; i < count; ++i) {
                sb.append(" ");
                sb.append(Arguments.getStringAt(arrayField, i));
            }
        }
        return sb.toString();
    }

    private static String getString(AddressField field) {
        Address addr = field.getAddress();
        return CStringUtilities.getString(addr);
    }

    private static String getStringAt(AddressField field, long index) {
        Address addr = field.getAddress();
        return CStringUtilities.getString(addr.getAddressAt(index * VM.getVM().getAddressSize()));
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                Arguments.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

