/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.ProviderException;
import java.util.Arrays;
import sun.security.provider.ByteArrayAccess;
import sun.security.provider.DigestBase;

abstract class SHA3
extends DigestBase {
    private static final int WIDTH = 200;
    private static final int DM = 5;
    private static final int NR = 24;
    private static final long[] RC_CONSTANTS = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};
    private byte[] state = new byte[200];
    private final long[] lanes = new long[25];

    SHA3(String string, int n) {
        super(string, n, 200 - 2 * n);
    }

    @Override
    void implCompress(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < this.buffer.length) {
            int n3 = n2++;
            this.state[n3] = (byte)(this.state[n3] ^ byArray[n++]);
        }
        this.keccak();
    }

    @Override
    void implDigest(byte[] byArray, int n) {
        int n2 = SHA3.setPaddingBytes(this.buffer, (int)(this.bytesProcessed % (long)this.buffer.length));
        if (n2 < 1) {
            throw new ProviderException("Incorrect pad size: " + n2);
        }
        for (int i = 0; i < this.buffer.length; ++i) {
            int n3 = i;
            this.state[n3] = (byte)(this.state[n3] ^ this.buffer[i]);
        }
        this.keccak();
        System.arraycopy(this.state, 0, byArray, n, this.engineGetDigestLength());
    }

    @Override
    void implReset() {
        Arrays.fill(this.state, (byte)0);
        Arrays.fill(this.lanes, 0L);
    }

    private static int setPaddingBytes(byte[] byArray, int n) {
        if (n != byArray.length) {
            Arrays.fill(byArray, n, byArray.length, (byte)0);
            int n2 = n;
            byArray[n2] = (byte)(byArray[n2] | 6);
            int n3 = byArray.length - 1;
            byArray[n3] = (byte)(byArray[n3] | 0xFFFFFF80);
        }
        return byArray.length - n;
    }

    private static void bytes2Lanes(byte[] byArray, long[] lArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < 5) {
            ByteArrayAccess.b2lLittle(byArray, n, lArray, 5 * n2, 40);
            ++n2;
            n += 40;
        }
    }

    private static void lanes2Bytes(long[] lArray, byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < 5) {
            ByteArrayAccess.l2bLittle(lArray, 5 * n2, byArray, n, 40);
            ++n2;
            n += 40;
        }
    }

    private static long[] smTheta(long[] lArray) {
        long l = lArray[0] ^ lArray[5] ^ lArray[10] ^ lArray[15] ^ lArray[20];
        long l2 = lArray[1] ^ lArray[6] ^ lArray[11] ^ lArray[16] ^ lArray[21];
        long l3 = lArray[2] ^ lArray[7] ^ lArray[12] ^ lArray[17] ^ lArray[22];
        long l4 = lArray[3] ^ lArray[8] ^ lArray[13] ^ lArray[18] ^ lArray[23];
        long l5 = lArray[4] ^ lArray[9] ^ lArray[14] ^ lArray[19] ^ lArray[24];
        long l6 = l5 ^ Long.rotateLeft(l2, 1);
        long l7 = l ^ Long.rotateLeft(l3, 1);
        long l8 = l2 ^ Long.rotateLeft(l4, 1);
        long l9 = l3 ^ Long.rotateLeft(l5, 1);
        long l10 = l4 ^ Long.rotateLeft(l, 1);
        for (int i = 0; i < lArray.length; i += 5) {
            int n = i;
            lArray[n] = lArray[n] ^ l6;
            int n2 = i + 1;
            lArray[n2] = lArray[n2] ^ l7;
            int n3 = i + 2;
            lArray[n3] = lArray[n3] ^ l8;
            int n4 = i + 3;
            lArray[n4] = lArray[n4] ^ l9;
            int n5 = i + 4;
            lArray[n5] = lArray[n5] ^ l10;
        }
        return lArray;
    }

    private static long[] smPiRho(long[] lArray) {
        long l = Long.rotateLeft(lArray[10], 3);
        lArray[10] = Long.rotateLeft(lArray[1], 1);
        lArray[1] = Long.rotateLeft(lArray[6], 44);
        lArray[6] = Long.rotateLeft(lArray[9], 20);
        lArray[9] = Long.rotateLeft(lArray[22], 61);
        lArray[22] = Long.rotateLeft(lArray[14], 39);
        lArray[14] = Long.rotateLeft(lArray[20], 18);
        lArray[20] = Long.rotateLeft(lArray[2], 62);
        lArray[2] = Long.rotateLeft(lArray[12], 43);
        lArray[12] = Long.rotateLeft(lArray[13], 25);
        lArray[13] = Long.rotateLeft(lArray[19], 8);
        lArray[19] = Long.rotateLeft(lArray[23], 56);
        lArray[23] = Long.rotateLeft(lArray[15], 41);
        lArray[15] = Long.rotateLeft(lArray[4], 27);
        lArray[4] = Long.rotateLeft(lArray[24], 14);
        lArray[24] = Long.rotateLeft(lArray[21], 2);
        lArray[21] = Long.rotateLeft(lArray[8], 55);
        lArray[8] = Long.rotateLeft(lArray[16], 45);
        lArray[16] = Long.rotateLeft(lArray[5], 36);
        lArray[5] = Long.rotateLeft(lArray[3], 28);
        lArray[3] = Long.rotateLeft(lArray[18], 21);
        lArray[18] = Long.rotateLeft(lArray[17], 15);
        lArray[17] = Long.rotateLeft(lArray[11], 10);
        lArray[11] = Long.rotateLeft(lArray[7], 6);
        lArray[7] = l;
        return lArray;
    }

    private static long[] smChi(long[] lArray) {
        for (int i = 0; i < lArray.length; i += 5) {
            long l = lArray[i];
            long l2 = lArray[i + 1];
            long l3 = lArray[i + 2];
            long l4 = lArray[i + 3];
            long l5 = lArray[i + 4];
            lArray[i] = l ^ (l2 ^ 0xFFFFFFFFFFFFFFFFL) & l3;
            lArray[i + 1] = l2 ^ (l3 ^ 0xFFFFFFFFFFFFFFFFL) & l4;
            lArray[i + 2] = l3 ^ (l4 ^ 0xFFFFFFFFFFFFFFFFL) & l5;
            lArray[i + 3] = l4 ^ (l5 ^ 0xFFFFFFFFFFFFFFFFL) & l;
            lArray[i + 4] = l5 ^ (l ^ 0xFFFFFFFFFFFFFFFFL) & l2;
        }
        return lArray;
    }

    private static long[] smIota(long[] lArray, int n) {
        lArray[0] = lArray[0] ^ RC_CONSTANTS[n];
        return lArray;
    }

    private void keccak() {
        SHA3.bytes2Lanes(this.state, this.lanes);
        for (int i = 0; i < 24; ++i) {
            SHA3.smIota(SHA3.smChi(SHA3.smPiRho(SHA3.smTheta(this.lanes))), i);
        }
        SHA3.lanes2Bytes(this.lanes, this.state);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SHA3 sHA3 = (SHA3)super.clone();
        sHA3.state = (byte[])sHA3.state.clone();
        return sHA3;
    }

    public static final class SHA512
    extends SHA3 {
        public SHA512() {
            super("SHA3-512", 64);
        }
    }

    public static final class SHA384
    extends SHA3 {
        public SHA384() {
            super("SHA3-384", 48);
        }
    }

    public static final class SHA256
    extends SHA3 {
        public SHA256() {
            super("SHA3-256", 32);
        }
    }

    public static final class SHA224
    extends SHA3 {
        public SHA224() {
            super("SHA3-224", 28);
        }
    }
}

