/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.shared.models;

import com.azul.crs.com.fasterxml.jackson.annotation.JsonIgnore;
import com.azul.crs.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.azul.crs.com.fasterxml.jackson.annotation.JsonInclude;
import com.azul.crs.com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.azul.crs.shared.models.DataPageRef;
import com.azul.crs.shared.models.Payload;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"size", "hasNext"}, allowGetters=true)
public class DataPage<T extends Payload>
extends Payload {
    @JsonUnwrapped
    private DataPageRef nextPage;
    private Collection<T> data;
    private Map<String, Object> summary;

    public DataPageRef getNextPage() {
        return this.nextPage;
    }

    public Boolean isHasNext() {
        return this.nextPage != null && this.nextPage.getAfterToken() != null;
    }

    public Collection<T> getData() {
        return this.data == null ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(this.data);
    }

    public Map<String, Object> getSummary() {
        return this.summary;
    }

    public int getSize() {
        return this.data != null ? this.data.size() : 0;
    }

    public void setNextPage(DataPageRef nextPage) {
        this.nextPage = nextPage;
    }

    public void setData(Collection<T> data) {
        this.data = data;
    }

    public void setSummary(Map<String, Object> summary) {
        this.summary = summary;
    }

    public DataPage<T> nextPage(DataPageRef nextPage) {
        this.setNextPage(nextPage);
        return this;
    }

    public DataPage<T> data(Collection<T> data) {
        this.setData(data);
        return this;
    }

    public DataPage<T> summary(Map<String, Object> summary) {
        this.setSummary(summary);
        return this;
    }

    @JsonIgnore
    public DataPage<T> summary(String key, Object value) {
        if (this.summary == null) {
            this.summary = new HashMap<String, Object>();
        }
        this.summary.put(key, value);
        return this;
    }

    public DataPage<T> data(T item) {
        if (this.data == null) {
            this.data = new LinkedList<T>();
        }
        this.data.add(item);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataPage dataPage = (DataPage)o;
        return Objects.equals(this.nextPage, dataPage.nextPage) && Objects.equals(this.data, dataPage.data) && Objects.equals(this.summary, dataPage.summary);
    }

    public int hashCode() {
        return Objects.hash(this.nextPage, this.data, this.summary);
    }
}

