/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.shared.models;

import com.azul.crs.com.fasterxml.jackson.annotation.JsonInclude;
import com.azul.crs.shared.models.Payload;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TaskState
extends Payload {
    private State state;
    private Long submitTime;
    private Long startTime;
    private Long lastHeardTime;
    private Map<String, Object> summary;
    private List<String> errors;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private boolean cancelRequested;

    public State getState() {
        return this.state;
    }

    public Long getSubmitTime() {
        return this.submitTime;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getLastHeardTime() {
        return this.lastHeardTime;
    }

    public Map<String, Object> getSummary() {
        return this.summary;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean isCancelRequested() {
        return this.cancelRequested;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setSubmitTime(Long submitTime) {
        this.submitTime = submitTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setLastHeardTime(Long lastHeardTime) {
        this.lastHeardTime = lastHeardTime;
    }

    public void setSummary(Map<String, Object> summary) {
        this.summary = summary;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public void setCancelRequested(boolean cancelRequested) {
        this.cancelRequested = cancelRequested;
    }

    public TaskState state(State state) {
        this.setState(state);
        return this;
    }

    public TaskState state(String state) {
        this.setState(State.valueOf(state));
        return this;
    }

    public TaskState submitTime(Long createTime) {
        this.setSubmitTime(createTime);
        return this;
    }

    public TaskState startTime(Long startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public TaskState lastHeardTime(Long lastHeardTime) {
        this.setLastHeardTime(lastHeardTime);
        return this;
    }

    public TaskState summary(Map<String, Object> summary) {
        this.setSummary(summary);
        return this;
    }

    public TaskState errors(List<String> errors) {
        this.setErrors(errors);
        return this;
    }

    public TaskState cancelRequested(boolean cancelRequested) {
        this.setCancelRequested(cancelRequested);
        return this;
    }

    public TaskState error(String error) {
        if (this.errors == null) {
            this.errors = new LinkedList<String>();
        }
        this.errors.add(error);
        return this;
    }

    public TaskState error(Throwable th) {
        return this.error(th.getMessage() != null ? th.getMessage() : th.getClass().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskState taskState = (TaskState)o;
        return this.state == taskState.state && Objects.equals(this.submitTime, taskState.submitTime) && Objects.equals(this.startTime, taskState.startTime) && Objects.equals(this.lastHeardTime, taskState.lastHeardTime) && Objects.equals(this.summary, taskState.summary) && Objects.equals(this.errors, taskState.errors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.submitTime, this.startTime, this.lastHeardTime, this.summary, this.errors});
    }

    public static enum State {
        SUBMITTED,
        RUNNING,
        WAITING,
        SUCCEEDED,
        ABORTED,
        FAILED;


        public boolean isFinal() {
            return this == SUCCEEDED || this == ABORTED || this == FAILED;
        }
    }
}

