/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.sun.security.ssl;

import java.net.Socket;
import java.security.AlgorithmConstraints;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.openjsse.javax.net.ssl.SSLEngine;
import org.openjsse.javax.net.ssl.SSLSocket;
import org.openjsse.sun.security.ssl.ProtocolVersion;
import org.openjsse.sun.security.ssl.SSLAlgorithmConstraints;
import org.openjsse.sun.security.ssl.X509TrustManagerImpl;
import sun.security.provider.certpath.AlgorithmChecker;

final class AbstractTrustManagerWrapper
extends X509ExtendedTrustManager
implements X509TrustManager {
    private final X509TrustManager tm;

    AbstractTrustManagerWrapper(X509TrustManager tm) {
        this.tm = tm;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType);
        this.checkAdditionalTrust(chain, authType, socket, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType);
        this.checkAdditionalTrust(chain, authType, socket, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, javax.net.ssl.SSLEngine engine) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType);
        this.checkAdditionalTrust(chain, authType, engine, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, javax.net.ssl.SSLEngine engine) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType);
        this.checkAdditionalTrust(chain, authType, engine, false);
    }

    private void checkAdditionalTrust(X509Certificate[] chain, String authType, Socket socket, boolean checkClientTrusted) throws CertificateException {
        if (socket != null && socket.isConnected() && socket instanceof SSLSocket) {
            SSLAlgorithmConstraints constraints;
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession session = sslSocket.getHandshakeSession();
            if (session == null) {
                throw new CertificateException("No handshake session");
            }
            String identityAlg = sslSocket.getSSLParameters().getEndpointIdentificationAlgorithm();
            if (identityAlg != null && identityAlg.length() != 0) {
                X509TrustManagerImpl.checkIdentity(session, chain, identityAlg, checkClientTrusted);
            }
            if (ProtocolVersion.useTLS12PlusSpec(session.getProtocol())) {
                if (session instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extSession = (ExtendedSSLSession)session;
                    String[] peerSupportedSignAlgs = extSession.getLocalSupportedSignatureAlgorithms();
                    constraints = new SSLAlgorithmConstraints(sslSocket, peerSupportedSignAlgs, true);
                } else {
                    constraints = new SSLAlgorithmConstraints(sslSocket, true);
                }
            } else {
                constraints = new SSLAlgorithmConstraints(sslSocket, true);
            }
            this.checkAlgorithmConstraints(chain, constraints, checkClientTrusted);
        }
    }

    private void checkAdditionalTrust(X509Certificate[] chain, String authType, javax.net.ssl.SSLEngine engine, boolean checkClientTrusted) throws CertificateException {
        if (engine != null) {
            SSLAlgorithmConstraints constraints;
            SSLSession session = engine.getHandshakeSession();
            if (session == null) {
                throw new CertificateException("No handshake session");
            }
            String identityAlg = engine.getSSLParameters().getEndpointIdentificationAlgorithm();
            if (identityAlg != null && identityAlg.length() != 0) {
                X509TrustManagerImpl.checkIdentity(session, chain, identityAlg, checkClientTrusted);
            }
            if (ProtocolVersion.useTLS12PlusSpec(session.getProtocol())) {
                if (session instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extSession = (ExtendedSSLSession)session;
                    String[] peerSupportedSignAlgs = extSession.getLocalSupportedSignatureAlgorithms();
                    constraints = new SSLAlgorithmConstraints((SSLEngine)engine, peerSupportedSignAlgs, true);
                } else {
                    constraints = new SSLAlgorithmConstraints((SSLEngine)engine, true);
                }
            } else {
                constraints = new SSLAlgorithmConstraints((SSLEngine)engine, true);
            }
            this.checkAlgorithmConstraints(chain, constraints, checkClientTrusted);
        }
    }

    private void checkAlgorithmConstraints(X509Certificate[] chain, AlgorithmConstraints constraints, boolean checkClientTrusted) throws CertificateException {
        try {
            int checkedLength = chain.length - 1;
            HashSet trustedCerts = new HashSet();
            X509Certificate[] certs = this.tm.getAcceptedIssuers();
            if (certs != null && certs.length > 0) {
                Collections.addAll(trustedCerts, certs);
            }
            if (trustedCerts.contains(chain[checkedLength])) {
                --checkedLength;
            }
            if (checkedLength >= 0) {
                AlgorithmChecker checker = new AlgorithmChecker(constraints, null, checkClientTrusted ? "tls client" : "tls server");
                checker.init(false);
                for (int i = checkedLength; i >= 0; --i) {
                    X509Certificate cert = chain[i];
                    checker.check(cert, Collections.emptySet());
                }
            }
        }
        catch (CertPathValidatorException cpve) {
            throw new CertificateException("Certificates do not conform to algorithm constraints", cpve);
        }
    }
}

