/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.FrameController;

public class Compat {
    public static final String FREEPLANE_USERDIR_PROPERTY = "org.freeplane.userfpdir";
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String VERSION_1_6_0 = "1.6.0";
    public static final String JAVA_VERSION_15 = "15.";
    public static final String CURRENT_VERSION_DIR = File.separatorChar + "1.11.x";
    public static final String PREVIOUS_VERSION_DIR_NAME = "1.10.x";
    private static OS os = null;
    public static final Set<String> executableExtensions = new HashSet<String>(Arrays.asList("exe", "com", "vbs", "bat", "lnk", "cmd"));
    private static String userFpDir = null;
    private static Boolean isApplet = null;

    public static boolean isWindowsExecutable(Hyperlink link) {
        if (link == null || !"file".equalsIgnoreCase(link.getScheme())) {
            return false;
        }
        return Compat.isWindowsOS() && executableExtensions.contains(FileUtils.getExtension(link.toString()));
    }

    public static URL fileToUrl(File pFile) throws MalformedURLException {
        return pFile.toURL();
    }

    public static boolean isJavaVersionLessThan(String version) {
        return JAVA_VERSION.compareTo(version) < 0;
    }

    public static boolean isMacOsX() {
        Compat.initOS();
        return os.equals((Object)OS.MAC);
    }

    private static void initOS() {
        if (os == null) {
            String debugOsName;
            String osProperty;
            try {
                osProperty = System.getProperty("os.name");
            }
            catch (SecurityException e) {
                osProperty = "";
            }
            try {
                debugOsName = System.getProperty("freeplane.debug.os.name", "");
            }
            catch (SecurityException e) {
                debugOsName = "";
            }
            if (osProperty.startsWith("Mac OS") || debugOsName.startsWith("Mac")) {
                os = OS.MAC;
                return;
            }
            if (osProperty.startsWith("Windows") || debugOsName.startsWith("Windows")) {
                os = OS.WINDOWS;
                return;
            }
            os = OS.OTHER;
        }
    }

    public static boolean isWindowsOS() {
        Compat.initOS();
        return os.equals((Object)OS.WINDOWS);
    }

    private static String urlGetFile(URL url) {
        if (!url.getProtocol().equals("file")) {
            return null;
        }
        String fileName = url.toString().replaceFirst("^file:", "");
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        if (osNameStart.equals("Win") && url.getProtocol().equals("file")) {
            return (fileName = fileName.replace('/', File.separatorChar)).indexOf(58) >= 0 ? fileName.replaceFirst("^\\\\*", "") : fileName;
        }
        return fileName;
    }

    public static File urlToFile(URL pUrl) {
        String path = Compat.urlGetFile(pUrl);
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    public static void macAppChanges() {
        if (!Compat.isMacOsX()) {
            return;
        }
        try {
            String lookandfeel = System.getProperty("lookandfeel", ResourceController.getResourceController().getProperty("lookandfeel"));
            if (lookandfeel.equals("VAqua") || lookandfeel.equals("org.violetlib.aqua.AquaLookAndFeel")) {
                try {
                    FrameController.class.getClassLoader().loadClass("org.violetlib.aqua.AquaLookAndFeel");
                    System.setProperty("apple.awt.application.appearance", "system");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Class<?> macChanges = Controller.class.getClassLoader().loadClass("org.freeplane.plugin.macos.MacChanges");
            Method method = macChanges.getMethod("apply", Controller.class);
            method.invoke(null, Controller.getCurrentController());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setFullScreenOnMac(JFrame frame, boolean fullScreen) {
        try {
            Class<?> macChanges = Controller.class.getClassLoader().loadClass("org.freeplane.plugin.macos.MacChanges");
            Method method = macChanges.getMethod("setFullScreen", JFrame.class, Boolean.TYPE);
            method.invoke(null, frame, fullScreen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getApplicationUserDirectory() {
        return Compat.getApplicationUserDirectoryExcludingVersion() + CURRENT_VERSION_DIR;
    }

    public static String getApplicationUserDirectoryExcludingVersion() {
        if (userFpDir == null) {
            Compat.findApplicationUserDirectory();
        }
        return userFpDir;
    }

    protected static void findApplicationUserDirectory() {
        String userFpDirByProperty = System.getProperty(FREEPLANE_USERDIR_PROPERTY);
        String userFpDirPath = userFpDirByProperty != null ? userFpDirByProperty : Compat.getDefaultFreeplaneUserDirectory();
        try {
            userFpDir = new File(userFpDirPath).getCanonicalPath();
        }
        catch (IOException e) {
            try {
                userFpDir = new File(Compat.getDefaultFreeplaneUserDirectory()).getCanonicalPath();
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public static String getDefaultFreeplaneUserDirectory() {
        return System.getProperty("user.home") + File.separator + ".freeplane";
    }

    public static String smbUri2unc(URI uri) {
        String uriString = ("//" + uri.getHost() + uri.getPath()).replace('/', '\\');
        String fragment = uri.getFragment();
        if (fragment != null) {
            uriString = uriString + '#' + fragment;
        }
        return uriString;
    }

    public static boolean isPlainEvent(MouseEvent e) {
        int modifiers = Compat.getModifiers(e);
        return modifiers == 0;
    }

    private static int getModifiers(MouseEvent e) {
        return e.getModifiersEx() & 0x3C0;
    }

    public static boolean isCtrlEvent(MouseEvent e) {
        return Compat.isExtendedCtrlEvent(e, 0);
    }

    public static boolean isCtrlShiftEvent(MouseEvent e) {
        return Compat.isExtendedCtrlEvent(e, 64);
    }

    public static boolean isCtrlAltEvent(MouseEvent e) {
        return Compat.isExtendedCtrlEvent(e, 512);
    }

    private static boolean isExtendedCtrlEvent(MouseEvent e, int otherModifiers) {
        int modifiers = Compat.getModifiers(e);
        if (Compat.isMacOsX()) {
            return modifiers == (0x100 | otherModifiers);
        }
        return modifiers == (0x80 | otherModifiers);
    }

    public static boolean isShiftEvent(MouseEvent e) {
        int modifiers = Compat.getModifiers(e);
        return modifiers == 64;
    }

    public static boolean isApplet() {
        if (isApplet == null) {
            throw new IllegalStateException("Not set");
        }
        return isApplet;
    }

    public static void setIsApplet(boolean isApplet) {
        if (Compat.isApplet != null) {
            if (isApplet != Compat.isApplet) {
                throw new IllegalStateException("Already set");
            }
        } else {
            Compat.isApplet = isApplet;
        }
    }

    private static enum OS {
        MAC,
        WINDOWS,
        OTHER;

    }
}

