/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import java.util.Locale;
import java.util.StringTokenizer;

public class LocaleUtil {
    public static Locale localeFromString(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, "_");
        String language = tokenizer.nextToken();
        if (tokenizer.hasMoreElements()) {
            String country = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                String variant = tokenizer.nextToken("");
                return new Locale(language, country, variant);
            }
            return new Locale(language, country);
        }
        return new Locale(language);
    }

    public static String localeToString(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder builder = new StringBuilder(language);
        if (country != null && country.length() > 0) {
            builder.append('_').append(country);
        }
        if (variant != null && variant.length() > 0) {
            builder.append('_').append(variant);
        }
        return builder.toString();
    }

    public static final boolean translationAvailable(Locale locale) {
        String localeName = LocaleUtil.localeToString(locale);
        if ("en".equals(localeName)) {
            return true;
        }
        ClassLoader classLoader = LocaleUtil.class.getClassLoader();
        String className = "org.fibs.geotag.i18n.Messages_" + localeName;
        System.out.println("Checking for class " + className);
        try {
            classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class " + className + " not found");
            return false;
        }
        System.out.println("Class " + className + " found");
        return true;
    }
}

