package Lire::UI::IntegerWidget;

use strict;

use base qw/ Curses::UI::Container Lire::UI::Widget /;

use Curses::UI::Common;
use Curses;

use Carp;
use vars qw/@CARP_NOT/;
use Lire::Utils qw/ check_object_param /;

@CARP_NOT = qw/Curses::UI::Container/;

my %routines = ( 'increase' => \&increase,
                 'decrease' => \&decrease );

sub new {
    my $class = shift;
    my %userargs = @_;
    keys_to_lowercase(\%userargs);

    check_object_param( $userargs{'value'}, 'value',
                        'Lire::Config::Scalar' );

    my $self =  $class->Curses::UI::Container::new( %userargs,
                                                    '-height' => 1,
                                                    '-routines' => \%routines,
                                                    '-releasefocus' => 1,
                                                    '-border' => 0 );
    $self->set_binding( sub { $self->do_routine( 'decrease' ) },
                        '-', KEY_LEFT() );
    $self->set_binding( sub { $self->do_routine( 'increase' ) },
                        '+', KEY_RIGHT() );
    $self->set_binding( sub { $self->do_routine( 'decrease', 10 ) },
                        KEY_DOWN() );
    $self->set_binding( sub { $self->do_routine( 'increase', 10 ) },
                        KEY_UP() );

    $self->add( 'text_entry', 'TextEntry',
                '-sbborder' => 1,
                '-height' => 1,
                '-text' => $userargs{'value'}->get(),
                '-regexp' => '/^[0-9]*$/',
                '-onchange' => \&_on_change_cb );

    $self->add( 'buttons', 'Buttonbox',
                '-width' => 7,
                '-buttons' =>
                [ { '-label' => '[<]',
                    '-onpress' => sub { $self->do_routine( 'decrease' ) },
                  },
                  { '-label' => '[>]',
                    '-onpress' => sub { $self->do_routine( 'increase' ) },
                  }
                ] );

    $self->layout();

    return $self;
}

sub layout {
    my $self = $_[0];

    $self->{'-height'} = 1;

    return $self->SUPER::layout();
}

sub layout_contained_objects {
    my $self = $_[0];

    return $self unless $self->getobj( 'text_entry' );

    my $width = $self->canvaswidth();
    my $entry = $self->getobj( 'text_entry' );
    my $box = $self->getobj( 'buttons' );
    if ( $width < 18 ) {
        $box->hide();
        $entry->{'-width'} = $width;
    } else {
        $box->show();
        $entry->{'-width'} = $width - 8;
        $box->{'-x'} = $entry->{'-width'} + 1;
    }

    return $self->SUPER::layout_contained_objects();
}

sub refresh_view {
    my $self = $_[0];

    my $text_entry = $self->getobj( 'text_entry' );
    $text_entry->text( $self->{'value'}->get() );

    return;
}

# Routines
sub decrease {
    my ( $self, $offset ) = @_;

    $offset ||= 1;
    my $value = $self->{'value'}->get() || 0;
    $self->{'value'}->set( $value - $offset );
    $self->refresh_view();

    return;
}

sub increase {
    my ( $self, $offset ) = @_;

    $offset ||= 1;

    my $value = $self->{'value'}->get() || 0;
    $self->{'value'}->set( $value + $offset );
    $self->refresh_view();

    return;
}

# callbacks
sub _on_change_cb {
    my $text_entry = $_[0];

    my $self = $text_entry->parent();
    $self->{'value'}->set( $text_entry->{'-text'} );
    $self->run_event( 'onvaluechanged' );

    return;
}

1;
