import { CancellationToken, Diagnostic } from 'vscode-languageserver';
import { Document } from '../../../lib/documents';
import { DiagnosticsProvider } from '../../interfaces';
import { LSAndTSDocResolver } from '../LSAndTSDocResolver';
import { LSConfigManager } from '../../../ls-config';
export declare enum DiagnosticCode {
    MODIFIERS_CANNOT_APPEAR_HERE = 1184,
    USED_BEFORE_ASSIGNED = 2454,
    JSX_ELEMENT_DOES_NOT_SUPPORT_ATTRIBUTES = 2607,
    CANNOT_BE_USED_AS_JSX_COMPONENT = 2786,
    NOOP_IN_COMMAS = 2695,
    NEVER_READ = 6133,
    ALL_IMPORTS_UNUSED = 6192,
    UNUSED_LABEL = 7028,
    DUPLICATED_JSX_ATTRIBUTES = 17001,
    DUPLICATE_IDENTIFIER = 2300,
    MULTIPLE_PROPS_SAME_NAME = 1117,
    TYPE_X_NOT_ASSIGNABLE_TO_TYPE_Y = 2345,
    MISSING_PROPS = 2739,
    MISSING_PROP = 2741,
    NO_OVERLOAD_MATCHES_CALL = 2769,
    CANNOT_FIND_NAME = 2304
}
export declare class DiagnosticsProviderImpl implements DiagnosticsProvider {
    private readonly lsAndTsDocResolver;
    private configManager;
    constructor(lsAndTsDocResolver: LSAndTSDocResolver, configManager: LSConfigManager);
    getDiagnostics(document: Document, cancellationToken?: CancellationToken): Promise<Diagnostic[]>;
    private getLSAndTSDoc;
}
