/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;
import javax.net.ssl.X509KeyManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLUtilBase;
import org.apache.tomcat.util.net.openssl.ciphers.Authentication;
import org.apache.tomcat.util.res.StringManager;

public class SSLHostConfigCertificate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SSLHostConfigCertificate.class);
    private static final StringManager sm = StringManager.getManager(SSLHostConfigCertificate.class);
    public static final Type DEFAULT_TYPE = Type.UNDEFINED;
    static final String DEFAULT_KEYSTORE_PROVIDER = System.getProperty("javax.net.ssl.keyStoreProvider");
    static final String DEFAULT_KEYSTORE_TYPE = System.getProperty("javax.net.ssl.keyStoreType", "JKS");
    private static final String DEFAULT_KEYSTORE_FILE = System.getProperty("user.home") + File.separator + ".keystore";
    private static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private ObjectName oname;
    private volatile transient SSLContext sslContext;
    private final SSLHostConfig sslHostConfig;
    private final Type type;
    private String certificateKeyPassword = null;
    private String certificateKeyPasswordFile = null;
    private String certificateKeyAlias;
    private String certificateKeystorePassword = "changeit";
    private String certificateKeystorePasswordFile = null;
    private String certificateKeystoreFile = DEFAULT_KEYSTORE_FILE;
    private String certificateKeystoreProvider = DEFAULT_KEYSTORE_PROVIDER;
    private String certificateKeystoreType = DEFAULT_KEYSTORE_TYPE;
    private transient KeyStore certificateKeystore = null;
    private transient X509KeyManager certificateKeyManager = null;
    private String certificateChainFile;
    private String certificateFile;
    private String certificateKeyFile;
    private StoreType storeType = null;

    public SSLHostConfigCertificate() {
        this(null, Type.UNDEFINED);
    }

    public SSLHostConfigCertificate(SSLHostConfig sSLHostConfig, Type type) {
        this.sslHostConfig = sSLHostConfig;
        this.type = type;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sSLContext) {
        this.sslContext = sSLContext;
    }

    public SSLHostConfig getSSLHostConfig() {
        return this.sslHostConfig;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public void setObjectName(ObjectName objectName) {
        this.oname = objectName;
    }

    public Type getType() {
        return this.type;
    }

    public String getCertificateKeyPassword() {
        return this.certificateKeyPassword;
    }

    public void setCertificateKeyPassword(String string) {
        this.certificateKeyPassword = string;
    }

    public String getCertificateKeyPasswordFile() {
        return this.certificateKeyPasswordFile;
    }

    public void setCertificateKeyPasswordFile(String string) {
        this.certificateKeyPasswordFile = string;
    }

    public void setCertificateKeyAlias(String string) {
        this.sslHostConfig.setProperty("Certificate.certificateKeyAlias", SSLHostConfig.Type.JSSE);
        this.certificateKeyAlias = string;
    }

    public String getCertificateKeyAlias() {
        return this.certificateKeyAlias;
    }

    public void setCertificateKeystoreFile(String string) {
        this.sslHostConfig.setProperty("Certificate.certificateKeystoreFile", SSLHostConfig.Type.JSSE);
        this.setStoreType("Certificate.certificateKeystoreFile", StoreType.KEYSTORE);
        this.certificateKeystoreFile = string;
    }

    public String getCertificateKeystoreFile() {
        return this.certificateKeystoreFile;
    }

    public void setCertificateKeystorePassword(String string) {
        this.sslHostConfig.setProperty("Certificate.certificateKeystorePassword", SSLHostConfig.Type.JSSE);
        this.setStoreType("Certificate.certificateKeystorePassword", StoreType.KEYSTORE);
        this.certificateKeystorePassword = string;
    }

    public String getCertificateKeystorePassword() {
        return this.certificateKeystorePassword;
    }

    public void setCertificateKeystorePasswordFile(String string) {
        this.sslHostConfig.setProperty("Certificate.certificateKeystorePasswordFile", SSLHostConfig.Type.JSSE);
        this.setStoreType("Certificate.certificateKeystorePasswordFile", StoreType.KEYSTORE);
        this.certificateKeystorePasswordFile = string;
    }

    public String getCertificateKeystorePasswordFile() {
        return this.certificateKeystorePasswordFile;
    }

    public void setCertificateKeystoreProvider(String string) {
        this.sslHostConfig.setProperty("Certificate.certificateKeystoreProvider", SSLHostConfig.Type.JSSE);
        this.setStoreType("Certificate.certificateKeystoreProvider", StoreType.KEYSTORE);
        this.certificateKeystoreProvider = string;
    }

    public String getCertificateKeystoreProvider() {
        return this.certificateKeystoreProvider;
    }

    public void setCertificateKeystoreType(String string) {
        this.sslHostConfig.setProperty("Certificate.certificateKeystoreType", SSLHostConfig.Type.JSSE);
        this.setStoreType("Certificate.certificateKeystoreType", StoreType.KEYSTORE);
        this.certificateKeystoreType = string;
    }

    public String getCertificateKeystoreType() {
        return this.certificateKeystoreType;
    }

    public void setCertificateKeystore(KeyStore keyStore) {
        this.certificateKeystore = keyStore;
        if (keyStore != null) {
            this.setCertificateKeystoreType(keyStore.getType());
        }
    }

    public KeyStore getCertificateKeystore() throws IOException {
        KeyStore keyStore = this.certificateKeystore;
        if (keyStore == null && this.storeType == StoreType.KEYSTORE) {
            keyStore = SSLUtilBase.getStore(this.getCertificateKeystoreType(), this.getCertificateKeystoreProvider(), this.getCertificateKeystoreFile(), this.getCertificateKeystorePassword(), this.getCertificateKeystorePasswordFile());
        }
        return keyStore;
    }

    public void setCertificateKeyManager(X509KeyManager x509KeyManager) {
        this.certificateKeyManager = x509KeyManager;
    }

    public X509KeyManager getCertificateKeyManager() {
        return this.certificateKeyManager;
    }

    public void setCertificateChainFile(String string) {
        this.setStoreType("Certificate.certificateChainFile", StoreType.PEM);
        this.certificateChainFile = string;
    }

    public String getCertificateChainFile() {
        return this.certificateChainFile;
    }

    public void setCertificateFile(String string) {
        this.setStoreType("Certificate.certificateFile", StoreType.PEM);
        this.certificateFile = string;
    }

    public String getCertificateFile() {
        return this.certificateFile;
    }

    public void setCertificateKeyFile(String string) {
        this.setStoreType("Certificate.certificateKeyFile", StoreType.PEM);
        this.certificateKeyFile = string;
    }

    public String getCertificateKeyFile() {
        return this.certificateKeyFile;
    }

    private void setStoreType(String string, StoreType storeType) {
        if (this.storeType == null) {
            this.storeType = storeType;
        } else if (this.storeType != storeType) {
            log.warn((Object)sm.getString("sslHostConfigCertificate.mismatch", new Object[]{string, this.sslHostConfig.getHostName(), storeType, this.storeType}));
        }
    }

    StoreType getStoreType() {
        return this.storeType;
    }

    public static enum Type {
        UNDEFINED(new Authentication[0]),
        RSA(Authentication.RSA),
        DSA(Authentication.DSS),
        EC(Authentication.ECDH, Authentication.ECDSA);

        private final Set<Authentication> compatibleAuthentications = new HashSet<Authentication>();

        private Type(Authentication ... authenticationArray) {
            if (authenticationArray != null) {
                this.compatibleAuthentications.addAll(Arrays.asList(authenticationArray));
            }
        }

        public boolean isCompatibleWith(Authentication authentication) {
            return this.compatibleAuthentications.contains((Object)authentication);
        }
    }

    static enum StoreType {
        KEYSTORE,
        PEM;

    }
}

