/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

public final class SimpleSeparator
extends JPanel
implements SwingConstants {
    private final int orientation;
    private final Dimension preferredSize = new Dimension(1, 1);

    public SimpleSeparator() {
        this(0);
    }

    public SimpleSeparator(int orientation) {
        super(null);
        this.orientation = orientation;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize.width = preferredSize.width;
        this.preferredSize.height = preferredSize.height;
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        if (this.orientation == 0) {
            return new Dimension(insets.left + insets.right, insets.top + insets.bottom + 1);
        }
        return new Dimension(insets.left + insets.right + 1, insets.top + insets.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        Insets insets = this.getInsets();
        if (this.orientation == 0) {
            return new Dimension(Integer.MAX_VALUE, insets.top + insets.bottom + 1);
        }
        return new Dimension(insets.left + insets.right + 1, Integer.MAX_VALUE);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        if (this.orientation == 0) {
            return new Dimension(Math.max(insets.left + insets.right, this.preferredSize.width), insets.top + insets.bottom + 1);
        }
        return new Dimension(insets.left + insets.right + 1, Math.max(insets.top + insets.bottom, this.preferredSize.height));
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(new Color(192, 192, 192));
        Insets insets = this.getInsets();
        if (this.orientation == 0) {
            g.drawLine(insets.left, insets.top, this.getWidth() - insets.right, insets.top);
        } else {
            g.drawLine(insets.left, insets.top, insets.left, this.getHeight() - insets.bottom);
        }
    }
}

