/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DeleteFleetErrorItem;
import software.amazon.awssdk.services.ec2.model.DeleteFleetErrorSetCopier;
import software.amazon.awssdk.services.ec2.model.DeleteFleetSuccessItem;
import software.amazon.awssdk.services.ec2.model.DeleteFleetSuccessSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFleetsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DeleteFleetsResponse> {
    private static final SdkField<List<DeleteFleetSuccessItem>> SUCCESSFUL_FLEET_DELETIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfulFleetDeletions").getter(DeleteFleetsResponse.getter(DeleteFleetsResponse::successfulFleetDeletions)).setter(DeleteFleetsResponse.setter(Builder::successfulFleetDeletions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulFleetDeletionSet").unmarshallLocationName("successfulFleetDeletionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteFleetSuccessItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<DeleteFleetErrorItem>> UNSUCCESSFUL_FLEET_DELETIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnsuccessfulFleetDeletions").getter(DeleteFleetsResponse.getter(DeleteFleetsResponse::unsuccessfulFleetDeletions)).setter(DeleteFleetsResponse.setter(Builder::unsuccessfulFleetDeletions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsuccessfulFleetDeletionSet").unmarshallLocationName("unsuccessfulFleetDeletionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteFleetErrorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FLEET_DELETIONS_FIELD, UNSUCCESSFUL_FLEET_DELETIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteFleetsResponse.memberNameToFieldInitializer();
    private final List<DeleteFleetSuccessItem> successfulFleetDeletions;
    private final List<DeleteFleetErrorItem> unsuccessfulFleetDeletions;

    private DeleteFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.successfulFleetDeletions = builder.successfulFleetDeletions;
        this.unsuccessfulFleetDeletions = builder.unsuccessfulFleetDeletions;
    }

    public final boolean hasSuccessfulFleetDeletions() {
        return this.successfulFleetDeletions != null && !(this.successfulFleetDeletions instanceof SdkAutoConstructList);
    }

    public final List<DeleteFleetSuccessItem> successfulFleetDeletions() {
        return this.successfulFleetDeletions;
    }

    public final boolean hasUnsuccessfulFleetDeletions() {
        return this.unsuccessfulFleetDeletions != null && !(this.unsuccessfulFleetDeletions instanceof SdkAutoConstructList);
    }

    public final List<DeleteFleetErrorItem> unsuccessfulFleetDeletions() {
        return this.unsuccessfulFleetDeletions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulFleetDeletions() ? this.successfulFleetDeletions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnsuccessfulFleetDeletions() ? this.unsuccessfulFleetDeletions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFleetsResponse)) {
            return false;
        }
        DeleteFleetsResponse other = (DeleteFleetsResponse)((Object)obj);
        return this.hasSuccessfulFleetDeletions() == other.hasSuccessfulFleetDeletions() && Objects.equals(this.successfulFleetDeletions(), other.successfulFleetDeletions()) && this.hasUnsuccessfulFleetDeletions() == other.hasUnsuccessfulFleetDeletions() && Objects.equals(this.unsuccessfulFleetDeletions(), other.unsuccessfulFleetDeletions());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteFleetsResponse").add("SuccessfulFleetDeletions", this.hasSuccessfulFleetDeletions() ? this.successfulFleetDeletions() : null).add("UnsuccessfulFleetDeletions", this.hasUnsuccessfulFleetDeletions() ? this.unsuccessfulFleetDeletions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfulFleetDeletions": {
                return Optional.ofNullable(clazz.cast(this.successfulFleetDeletions()));
            }
            case "UnsuccessfulFleetDeletions": {
                return Optional.ofNullable(clazz.cast(this.unsuccessfulFleetDeletions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SuccessfulFleetDeletionSet", SUCCESSFUL_FLEET_DELETIONS_FIELD);
        map.put("UnsuccessfulFleetDeletionSet", UNSUCCESSFUL_FLEET_DELETIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteFleetsResponse, T> g) {
        return obj -> g.apply((DeleteFleetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<DeleteFleetSuccessItem> successfulFleetDeletions = DefaultSdkAutoConstructList.getInstance();
        private List<DeleteFleetErrorItem> unsuccessfulFleetDeletions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFleetsResponse model) {
            super(model);
            this.successfulFleetDeletions(model.successfulFleetDeletions);
            this.unsuccessfulFleetDeletions(model.unsuccessfulFleetDeletions);
        }

        public final List<DeleteFleetSuccessItem.Builder> getSuccessfulFleetDeletions() {
            List<DeleteFleetSuccessItem.Builder> result = DeleteFleetSuccessSetCopier.copyToBuilder(this.successfulFleetDeletions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulFleetDeletions(Collection<DeleteFleetSuccessItem.BuilderImpl> successfulFleetDeletions) {
            this.successfulFleetDeletions = DeleteFleetSuccessSetCopier.copyFromBuilder(successfulFleetDeletions);
        }

        @Override
        public final Builder successfulFleetDeletions(Collection<DeleteFleetSuccessItem> successfulFleetDeletions) {
            this.successfulFleetDeletions = DeleteFleetSuccessSetCopier.copy(successfulFleetDeletions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulFleetDeletions(DeleteFleetSuccessItem ... successfulFleetDeletions) {
            this.successfulFleetDeletions(Arrays.asList(successfulFleetDeletions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulFleetDeletions(Consumer<DeleteFleetSuccessItem.Builder> ... successfulFleetDeletions) {
            this.successfulFleetDeletions(Stream.of(successfulFleetDeletions).map(c -> (DeleteFleetSuccessItem)((DeleteFleetSuccessItem.Builder)DeleteFleetSuccessItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DeleteFleetErrorItem.Builder> getUnsuccessfulFleetDeletions() {
            List<DeleteFleetErrorItem.Builder> result = DeleteFleetErrorSetCopier.copyToBuilder(this.unsuccessfulFleetDeletions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessfulFleetDeletions(Collection<DeleteFleetErrorItem.BuilderImpl> unsuccessfulFleetDeletions) {
            this.unsuccessfulFleetDeletions = DeleteFleetErrorSetCopier.copyFromBuilder(unsuccessfulFleetDeletions);
        }

        @Override
        public final Builder unsuccessfulFleetDeletions(Collection<DeleteFleetErrorItem> unsuccessfulFleetDeletions) {
            this.unsuccessfulFleetDeletions = DeleteFleetErrorSetCopier.copy(unsuccessfulFleetDeletions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFleetDeletions(DeleteFleetErrorItem ... unsuccessfulFleetDeletions) {
            this.unsuccessfulFleetDeletions(Arrays.asList(unsuccessfulFleetDeletions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFleetDeletions(Consumer<DeleteFleetErrorItem.Builder> ... unsuccessfulFleetDeletions) {
            this.unsuccessfulFleetDeletions(Stream.of(unsuccessfulFleetDeletions).map(c -> (DeleteFleetErrorItem)((DeleteFleetErrorItem.Builder)DeleteFleetErrorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeleteFleetsResponse build() {
            return new DeleteFleetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteFleetsResponse> {
        public Builder successfulFleetDeletions(Collection<DeleteFleetSuccessItem> var1);

        public Builder successfulFleetDeletions(DeleteFleetSuccessItem ... var1);

        public Builder successfulFleetDeletions(Consumer<DeleteFleetSuccessItem.Builder> ... var1);

        public Builder unsuccessfulFleetDeletions(Collection<DeleteFleetErrorItem> var1);

        public Builder unsuccessfulFleetDeletions(DeleteFleetErrorItem ... var1);

        public Builder unsuccessfulFleetDeletions(Consumer<DeleteFleetErrorItem.Builder> ... var1);
    }
}

