/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.RequestHostIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHostsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeHostsRequest> {
    private static final SdkField<List<String>> HOST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HostIds").getter(DescribeHostsRequest.getter(DescribeHostsRequest::hostIds)).setter(DescribeHostsRequest.setter(Builder::hostIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId").unmarshallLocationName("hostId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeHostsRequest.getter(DescribeHostsRequest::nextToken)).setter(DescribeHostsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeHostsRequest.getter(DescribeHostsRequest::maxResults)).setter(DescribeHostsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("maxResults").build()}).build();
    private static final SdkField<List<Filter>> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filter").getter(DescribeHostsRequest.getter(DescribeHostsRequest::filter)).setter(DescribeHostsRequest.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeHostsRequest.memberNameToFieldInitializer();
    private final List<String> hostIds;
    private final String nextToken;
    private final Integer maxResults;
    private final List<Filter> filter;

    private DescribeHostsRequest(BuilderImpl builder) {
        super(builder);
        this.hostIds = builder.hostIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filter = builder.filter;
    }

    public final boolean hasHostIds() {
        return this.hostIds != null && !(this.hostIds instanceof SdkAutoConstructList);
    }

    public final List<String> hostIds() {
        return this.hostIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasFilter() {
        return this.filter != null && !(this.filter instanceof SdkAutoConstructList);
    }

    public final List<Filter> filter() {
        return this.filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHostIds() ? this.hostIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilter() ? this.filter() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostsRequest)) {
            return false;
        }
        DescribeHostsRequest other = (DescribeHostsRequest)((Object)obj);
        return this.hasHostIds() == other.hasHostIds() && Objects.equals(this.hostIds(), other.hostIds()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasFilter() == other.hasFilter() && Objects.equals(this.filter(), other.filter());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHostsRequest").add("HostIds", this.hasHostIds() ? this.hostIds() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Filter", this.hasFilter() ? this.filter() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostIds": {
                return Optional.ofNullable(clazz.cast(this.hostIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HostId", HOST_IDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHostsRequest, T> g) {
        return obj -> g.apply((DescribeHostsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> hostIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;
        private List<Filter> filter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostsRequest model) {
            super(model);
            this.hostIds(model.hostIds);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.filter(model.filter);
        }

        public final Collection<String> getHostIds() {
            if (this.hostIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hostIds;
        }

        public final void setHostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
        }

        @Override
        public final Builder hostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIds(String ... hostIds) {
            this.hostIds(Arrays.asList(hostIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<Filter.Builder> getFilter() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filter);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilter(Collection<Filter.BuilderImpl> filter) {
            this.filter = FilterListCopier.copyFromBuilder(filter);
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter ... filter) {
            this.filter(Arrays.asList(filter));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Consumer<Filter.Builder> ... filter) {
            this.filter(Stream.of(filter).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeHostsRequest build() {
            return new DescribeHostsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHostsRequest> {
        public Builder hostIds(Collection<String> var1);

        public Builder hostIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder filter(Collection<Filter> var1);

        public Builder filter(Filter ... var1);

        public Builder filter(Consumer<Filter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

